// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The state of an application discovered through Migration Hub import, the AWS
// Agentless Discovery Connector, or the AWS Application Discovery Agent.
type ApplicationState struct {

	// The configurationId from the Application Discovery Service that uniquely
	// identifies an application.
	ApplicationId *string

	// The current status of an application.
	ApplicationStatus ApplicationStatus

	// The timestamp when the application status was last updated.
	LastUpdatedTime *time.Time

	noSmithyDocumentSerde
}

// An ARN of the AWS cloud resource target receiving the migration (e.g., AMI, EC2
// instance, RDS instance, etc.).
type CreatedArtifact struct {

	// An ARN that uniquely identifies the result of a migration task.
	//
	// This member is required.
	Name *string

	// A description that can be free-form text to record additional detail about the
	// artifact for clarity or for later reference.
	Description *string

	noSmithyDocumentSerde
}

// Object representing the on-premises resource being migrated.
type DiscoveredResource struct {

	// The configurationId in Application Discovery Service that uniquely identifies
	// the on-premise resource.
	//
	// This member is required.
	ConfigurationId *string

	// A description that can be free-form text to record additional detail about the
	// discovered resource for clarity or later reference.
	Description *string

	noSmithyDocumentSerde
}

// Represents a migration task in a migration tool.
type MigrationTask struct {

	// Unique identifier that references the migration task. Do not store personal data
	// in this field.
	MigrationTaskName *string

	// A name that identifies the vendor of the migration tool being used.
	ProgressUpdateStream *string

	// Information about the resource that is being migrated. This data will be used to
	// map the task to a resource in the Application Discovery Service repository.
	ResourceAttributeList []ResourceAttribute

	// Task object encapsulating task information.
	Task *Task

	// The timestamp when the task was gathered.
	UpdateDateTime *time.Time

	noSmithyDocumentSerde
}

// MigrationTaskSummary includes MigrationTaskName, ProgressPercent,
// ProgressUpdateStream, Status, and UpdateDateTime for each task.
type MigrationTaskSummary struct {

	// Unique identifier that references the migration task. Do not store personal data
	// in this field.
	MigrationTaskName *string

	// Indication of the percentage completion of the task.
	ProgressPercent *int32

	// An AWS resource used for access control. It should uniquely identify the
	// migration tool as it is used for all updates made by the tool.
	ProgressUpdateStream *string

	// Status of the task.
	Status Status

	// Detail information of what is being done within the overall status state.
	StatusDetail *string

	// The timestamp when the task was gathered.
	UpdateDateTime *time.Time

	noSmithyDocumentSerde
}

// Summary of the AWS resource used for access control that is implicitly linked to
// your AWS account.
type ProgressUpdateStreamSummary struct {

	// The name of the ProgressUpdateStream. Do not store personal data in this field.
	ProgressUpdateStreamName *string

	noSmithyDocumentSerde
}

// Attribute associated with a resource. Note the corresponding format required per
// type listed below: IPV4 x.x.x.x where x is an integer in the range [0,255] IPV6
// y : y : y : y : y : y : y : y where y is a hexadecimal between 0 and FFFF. [0,
// FFFF] MAC_ADDRESS ^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$ FQDN
// ^[^<>{}\\/?,=\p{Cntrl}]{1,256}$
type ResourceAttribute struct {

	// Type of resource.
	//
	// This member is required.
	Type ResourceAttributeType

	// Value of the resource type.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Task object encapsulating task information.
type Task struct {

	// Status of the task - Not Started, In-Progress, Complete.
	//
	// This member is required.
	Status Status

	// Indication of the percentage completion of the task.
	ProgressPercent *int32

	// Details of task status as notified by a migration tool. A tool might use this
	// field to provide clarifying information about the status that is unique to that
	// tool or that explains an error state.
	StatusDetail *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
