// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: aes_ctr_hmac_streaming.proto

package aes_ctr_hmac_streaming_go_proto

import (
	common_go_proto "github.com/tink-crypto/tink-go/v2/proto/common_go_proto"
	hmac_go_proto "github.com/tink-crypto/tink-go/v2/proto/hmac_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AesCtrHmacStreamingParams struct {
	state                 protoimpl.MessageState    `protogen:"open.v1"`
	CiphertextSegmentSize uint32                    `protobuf:"varint,1,opt,name=ciphertext_segment_size,json=ciphertextSegmentSize,proto3" json:"ciphertext_segment_size,omitempty"`
	DerivedKeySize        uint32                    `protobuf:"varint,2,opt,name=derived_key_size,json=derivedKeySize,proto3" json:"derived_key_size,omitempty"`                            // size of AES-CTR keys derived for each segment
	HkdfHashType          common_go_proto.HashType  `protobuf:"varint,3,opt,name=hkdf_hash_type,json=hkdfHashType,proto3,enum=google.crypto.tink.HashType" json:"hkdf_hash_type,omitempty"` // hash function for key derivation via HKDF
	HmacParams            *hmac_go_proto.HmacParams `protobuf:"bytes,4,opt,name=hmac_params,json=hmacParams,proto3" json:"hmac_params,omitempty"`                                           // params for authentication tags
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *AesCtrHmacStreamingParams) Reset() {
	*x = AesCtrHmacStreamingParams{}
	mi := &file_aes_ctr_hmac_streaming_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AesCtrHmacStreamingParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AesCtrHmacStreamingParams) ProtoMessage() {}

func (x *AesCtrHmacStreamingParams) ProtoReflect() protoreflect.Message {
	mi := &file_aes_ctr_hmac_streaming_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AesCtrHmacStreamingParams.ProtoReflect.Descriptor instead.
func (*AesCtrHmacStreamingParams) Descriptor() ([]byte, []int) {
	return file_aes_ctr_hmac_streaming_proto_rawDescGZIP(), []int{0}
}

func (x *AesCtrHmacStreamingParams) GetCiphertextSegmentSize() uint32 {
	if x != nil {
		return x.CiphertextSegmentSize
	}
	return 0
}

func (x *AesCtrHmacStreamingParams) GetDerivedKeySize() uint32 {
	if x != nil {
		return x.DerivedKeySize
	}
	return 0
}

func (x *AesCtrHmacStreamingParams) GetHkdfHashType() common_go_proto.HashType {
	if x != nil {
		return x.HkdfHashType
	}
	return common_go_proto.HashType(0)
}

func (x *AesCtrHmacStreamingParams) GetHmacParams() *hmac_go_proto.HmacParams {
	if x != nil {
		return x.HmacParams
	}
	return nil
}

type AesCtrHmacStreamingKeyFormat struct {
	state         protoimpl.MessageState     `protogen:"open.v1"`
	Version       uint32                     `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	Params        *AesCtrHmacStreamingParams `protobuf:"bytes,1,opt,name=params,proto3" json:"params,omitempty"`
	KeySize       uint32                     `protobuf:"varint,2,opt,name=key_size,json=keySize,proto3" json:"key_size,omitempty"` // size of the main key (aka. "ikm", input key material)
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AesCtrHmacStreamingKeyFormat) Reset() {
	*x = AesCtrHmacStreamingKeyFormat{}
	mi := &file_aes_ctr_hmac_streaming_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AesCtrHmacStreamingKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AesCtrHmacStreamingKeyFormat) ProtoMessage() {}

func (x *AesCtrHmacStreamingKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_aes_ctr_hmac_streaming_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AesCtrHmacStreamingKeyFormat.ProtoReflect.Descriptor instead.
func (*AesCtrHmacStreamingKeyFormat) Descriptor() ([]byte, []int) {
	return file_aes_ctr_hmac_streaming_proto_rawDescGZIP(), []int{1}
}

func (x *AesCtrHmacStreamingKeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *AesCtrHmacStreamingKeyFormat) GetParams() *AesCtrHmacStreamingParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *AesCtrHmacStreamingKeyFormat) GetKeySize() uint32 {
	if x != nil {
		return x.KeySize
	}
	return 0
}

// key_type: type.googleapis.com/google.crypto.tink.AesCtrHmacStreamingKey
type AesCtrHmacStreamingKey struct {
	state         protoimpl.MessageState     `protogen:"open.v1"`
	Version       uint32                     `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Params        *AesCtrHmacStreamingParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	KeyValue      []byte                     `protobuf:"bytes,3,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for multi-line ctype and debug_redact.  // the main key, aka. "ikm", input key material
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AesCtrHmacStreamingKey) Reset() {
	*x = AesCtrHmacStreamingKey{}
	mi := &file_aes_ctr_hmac_streaming_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AesCtrHmacStreamingKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AesCtrHmacStreamingKey) ProtoMessage() {}

func (x *AesCtrHmacStreamingKey) ProtoReflect() protoreflect.Message {
	mi := &file_aes_ctr_hmac_streaming_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AesCtrHmacStreamingKey.ProtoReflect.Descriptor instead.
func (*AesCtrHmacStreamingKey) Descriptor() ([]byte, []int) {
	return file_aes_ctr_hmac_streaming_proto_rawDescGZIP(), []int{2}
}

func (x *AesCtrHmacStreamingKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *AesCtrHmacStreamingKey) GetParams() *AesCtrHmacStreamingParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *AesCtrHmacStreamingKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

var File_aes_ctr_hmac_streaming_proto protoreflect.FileDescriptor

const file_aes_ctr_hmac_streaming_proto_rawDesc = "" +
	"\n" +
	"\x1caes_ctr_hmac_streaming.proto\x12\x12google.crypto.tink\x1a\x12proto/common.proto\x1a\x10proto/hmac.proto\"\x82\x02\n" +
	"\x19AesCtrHmacStreamingParams\x126\n" +
	"\x17ciphertext_segment_size\x18\x01 \x01(\rR\x15ciphertextSegmentSize\x12(\n" +
	"\x10derived_key_size\x18\x02 \x01(\rR\x0ederivedKeySize\x12B\n" +
	"\x0ehkdf_hash_type\x18\x03 \x01(\x0e2\x1c.google.crypto.tink.HashTypeR\fhkdfHashType\x12?\n" +
	"\vhmac_params\x18\x04 \x01(\v2\x1e.google.crypto.tink.HmacParamsR\n" +
	"hmacParams\"\x9a\x01\n" +
	"\x1cAesCtrHmacStreamingKeyFormat\x12\x18\n" +
	"\aversion\x18\x03 \x01(\rR\aversion\x12E\n" +
	"\x06params\x18\x01 \x01(\v2-.google.crypto.tink.AesCtrHmacStreamingParamsR\x06params\x12\x19\n" +
	"\bkey_size\x18\x02 \x01(\rR\akeySize\"\x96\x01\n" +
	"\x16AesCtrHmacStreamingKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12E\n" +
	"\x06params\x18\x02 \x01(\v2-.google.crypto.tink.AesCtrHmacStreamingParamsR\x06params\x12\x1b\n" +
	"\tkey_value\x18\x03 \x01(\fR\bkeyValueBi\n" +
	"\x1ccom.google.crypto.tink.protoP\x01ZGgithub.com/tink-crypto/tink-go/v2/proto/aes_ctr_hmac_streaming_go_protob\x06proto3"

var (
	file_aes_ctr_hmac_streaming_proto_rawDescOnce sync.Once
	file_aes_ctr_hmac_streaming_proto_rawDescData []byte
)

func file_aes_ctr_hmac_streaming_proto_rawDescGZIP() []byte {
	file_aes_ctr_hmac_streaming_proto_rawDescOnce.Do(func() {
		file_aes_ctr_hmac_streaming_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_aes_ctr_hmac_streaming_proto_rawDesc), len(file_aes_ctr_hmac_streaming_proto_rawDesc)))
	})
	return file_aes_ctr_hmac_streaming_proto_rawDescData
}

var file_aes_ctr_hmac_streaming_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_aes_ctr_hmac_streaming_proto_goTypes = []any{
	(*AesCtrHmacStreamingParams)(nil),    // 0: google.crypto.tink.AesCtrHmacStreamingParams
	(*AesCtrHmacStreamingKeyFormat)(nil), // 1: google.crypto.tink.AesCtrHmacStreamingKeyFormat
	(*AesCtrHmacStreamingKey)(nil),       // 2: google.crypto.tink.AesCtrHmacStreamingKey
	(common_go_proto.HashType)(0),        // 3: google.crypto.tink.HashType
	(*hmac_go_proto.HmacParams)(nil),     // 4: google.crypto.tink.HmacParams
}
var file_aes_ctr_hmac_streaming_proto_depIdxs = []int32{
	3, // 0: google.crypto.tink.AesCtrHmacStreamingParams.hkdf_hash_type:type_name -> google.crypto.tink.HashType
	4, // 1: google.crypto.tink.AesCtrHmacStreamingParams.hmac_params:type_name -> google.crypto.tink.HmacParams
	0, // 2: google.crypto.tink.AesCtrHmacStreamingKeyFormat.params:type_name -> google.crypto.tink.AesCtrHmacStreamingParams
	0, // 3: google.crypto.tink.AesCtrHmacStreamingKey.params:type_name -> google.crypto.tink.AesCtrHmacStreamingParams
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_aes_ctr_hmac_streaming_proto_init() }
func file_aes_ctr_hmac_streaming_proto_init() {
	if File_aes_ctr_hmac_streaming_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_aes_ctr_hmac_streaming_proto_rawDesc), len(file_aes_ctr_hmac_streaming_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_aes_ctr_hmac_streaming_proto_goTypes,
		DependencyIndexes: file_aes_ctr_hmac_streaming_proto_depIdxs,
		MessageInfos:      file_aes_ctr_hmac_streaming_proto_msgTypes,
	}.Build()
	File_aes_ctr_hmac_streaming_proto = out.File
	file_aes_ctr_hmac_streaming_proto_goTypes = nil
	file_aes_ctr_hmac_streaming_proto_depIdxs = nil
}
