'''This ClassJsRef module provides JS reference for a given C++ class'''

class ClassJsRef:
	'''This class acts as a storage unit for a class JS reference'''
	def __init__(self):

		self.name_space = ""
		self.class_name = ""
		# List of lines making the description
		self.description = [ ]
		# List of QpropertyJsRef instances
		self.properties = [ ]
		# List of QinvokableJsRef instances
		self.invokables = [ ]
		self.valid = False


	def __str__(self):
		return self.get_as_text("  ", 1)


	def get_description_as_text(self, tab, offset):

		lead = offset * tab

		# print(f"The description: {self.description}\n")
		# print(f"The description has {len(self.description)} items.")

		output_text = ""

		for line in self.description:

			# print(f"Appending class description line: '{line}")

			output_text = f"{output_text}{lead}{line}"

			# print(f"Now output_text is:\n{output_text}")

		return output_text


	def print_description(self, tab, offset):

		print(f"{self.get_description_as_text(tab, offset)}")


	def get_properties_as_text(self, tab, offset):

		output_text = ""

		for property  in self.properties:
			output_text = f"{output_text}{property.get_as_text(tab, offset)}"

		# print(f"Returning properties as text: {output_text}")

		return output_text


	def print_properties(self, tab, offset):

		print(f"{self.get_properties_as_text(tab, offset)}")


	def get_invokables_as_text(self, tab, offset):

		output_text = ""

		for invokable  in self.invokables:
			output_text = f"{output_text}{invokable.get_as_text(tab, offset)}"

		return output_text


	def print_invokables(self, tab, offset):

		print(f"{self.get_invokables_as_text(tab, offset)}")


	def get_as_text(self, tab, offset):

		lead = offset * tab

		output_text = f"{lead}{self.name_space} {self.class_name}:\n\n"

		offset += 1
		lead = offset * tab

		if len(self.description):

			output_text = f"{output_text}{lead}Description:\n\n"

			indented_offset = offset + 1

			output_text = f"{output_text}{self.get_description_as_text(tab, indented_offset)}\n"

		if len(self.properties):

			output_text = f"{output_text}{lead}Properties: {len(self.properties)}\n\n"

			indented_offset = offset + 1

			output_text = f"{output_text}{self.get_properties_as_text(tab, indented_offset)}\n"

			#print(f"Got {output_text} for properties text.")

		if len(self.invokables):

			output_text = f"{output_text}{lead}Invokables: {len(self.invokables)}\n\n"

			indented_offset = offset + 1

			output_text = f"{output_text}{self.get_invokables_as_text(tab, indented_offset)}\n"

			# print(f"Got {output_text} for invokables text.")

		return output_text


	def print(self, tab, offset):

		print(f"{self.get_as_text(tab, offset)}")





