/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8371083
 * @summary Verify FollowReferences does not report non-classes roots as JVMTI_HEAP_REFERENCE_SYSTEM_CLASS
 * @requires vm.jvmti
 * @run main/othervm/native -agentlib:KindSystemClass
 *                          KindSystemClass
 */

public class KindSystemClass {

    static native int tagSysClasses();
    static native Object[] getObjectsWithTags();

    public static void main(String[] args) throws Exception {
        System.loadLibrary("KindSystemClass");

        int tagged = tagSysClasses();
        System.out.println("Tagged " + tagged + " classes");

        Object[] objs = getObjectsWithTags();
        System.out.println("Tagged objects (total " + objs.length + "):");
        int nonClassesCnt = 0;
        for (int i = 0; i < objs.length; i++) {
            Object obj = objs[i];
            String s;
            if (obj instanceof Class cls) {
                s = "OK: " + cls;
            } else {
                nonClassesCnt++;
                s = "ERROR, not a class: " + obj;
            }
            System.out.println("[" + i + "] " + s);
        }
        if (nonClassesCnt != 0) {
            throw new RuntimeException("Found " + nonClassesCnt + " non-classes");
        }
    }
}
