/*PGR-GNU*****************************************************************
File: schedule_rt.h

Copyright (c) 2017 pgRouting developers
Mail: project@pgrouting.org

Copyright (c) 2017 Celia Virginia Vergara Castillo
Mail: vicky_vergara@hotmail.com

------

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 ********************************************************************PGR-GNU*/
/*! @file */

#ifndef INCLUDE_C_TYPES_SCHEDULE_RT_H_
#define INCLUDE_C_TYPES_SCHEDULE_RT_H_
#pragma once

/* for int64_t */
#ifdef __cplusplus
#   include <cstdint>
#else
#   include <stdint.h>
#endif

/*
   OUT seq INTEGER,        done in the .c code
   OUT vehicle_seq INTEGER,
   OUT vehicle_id INTEGER,
   OUT order_id BIGINT,
   OUT travelTime FLOAT,
   OUT arrivalTime FLOAT,
   OUT waitTime FLOAT,
   OUT serviceTime FLOAT,
   OUT departureTime FLOAT,
   */

struct  Schedule_rt {
    int vehicle_seq;
    int64_t vehicle_id;
    int stop_seq;
    int64_t order_id;
    int64_t stop_id;
    int stop_type;
    double cargo;
    double travelTime;
    double arrivalTime;
    double waitTime;
    double serviceTime;
    double departureTime;
};

/*************************************************************************/

#endif  // INCLUDE_C_TYPES_SCHEDULE_RT_H_
