<?php

declare(strict_types=1);

#####################################################################
# PHP Web Counter, version 1.1                                      #
#                                                                   #
# A simple and light web hits counter                               #
#                                                                   #
# This is a Free Software under Gnu/GPL license                     #
#                                                                   #
# C 2006-2025 - Andre Bertelli Araujo <bertelli.andre@gmail.com>    #
#               Joao Eriberto Mota Filho <eriberto@eriberto.pro.br> #
#               Marcos Patricio do Santos <marpasan@ig.com.br>      #
#                                                                   #
# URL: http://phpwebcounter.sourceforge.net                         #
#####################################################################


##############################
##############################
### Part 1 - Configuration ###
##############################
##############################

require("/etc/phpwebcounter/phpwebcounter.config.php");

##########################
##########################
### Part 2 - The code! ###
##########################
##########################

function hits_webcounter(int $webcounter_id=0, string|null $hits_file=null, bool|null $vis=null, string|null $path_images=null, int $counter_pad=6, int $step=1): void
{
	global $path_hits_file, $visible;

	if (is_null($hits_file))
		$hits_file = $path_hits_file;
	if (is_null($vis))
		$vis = $visible;

	$counter = read_webcounter($webcounter_id, $hits_file);
	increment_webcounter($webcounter_id, $counter, $step, $hits_file);

	if (!$vis) return;
	if (is_null($path_images)) {
		echo $counter;
	} else {
		show_webcounter($counter, $path_images, $counter_pad);
	}
}

function show_webcounter(int $counter, string $path_images, int $counter_pad=6): void
{
	echo "<SPAN>";
		$counter = str_pad((string) $counter, $counter_pad, '0', STR_PAD_LEFT);
		for ($i=0; $i< strlen($counter) ; $i++) {
			$digit=$counter[$i];
			echo "<IMG src='$path_images/$digit.png' alt='$digit' />";
		}
	echo "</SPAN>";
}

function read_webcounter(int $webcounter_id, string|null $hits_file=null): int
{
	global $path_hits_file;

	if (is_null($hits_file))
		$hits_file = $path_hits_file;

	$file="$hits_file/hits_webcounter.$webcounter_id";
	$fp = fopen($file, 'a+');
	$counter = (int) fread($fp,1024);
	fclose($fp);
	return $counter;
}

function increment_webcounter(int $webcounter_id, int $counter, int $step=1, string|null $hits_file=null): void
{
	global $path_hits_file;

	if (is_null($hits_file))
		$hits_file = $path_hits_file;

	$file="$hits_file/hits_webcounter.$webcounter_id";
	$fp = fopen($file, 'w');
	fwrite($fp,(string) ($counter + $step));
	fclose($fp);
}

########################
########################
### Part 3 - Running ###
########################
########################

hits_webcounter($webcounter_id,$path_hits_file,$visible,$path_images,$counter_pad, $step);

if ($banner == '1') {
    echo '<br><a href="http://phpwebcounter.sourceforge.net"><font size=1px>PHP Web Counter</a></font size><br>';
    }
?>
