#!/usr/bin/perl -w
#
# $Cambridge: hermes/src/prayer/utils/ucsnews.pl,v 1.2 2008/09/16 10:00:08 dpc22 Exp $
#
# Small utility for dumping start of UCS news feed as suitable HTML

use strict;
use XML::RSS;
use HTML::Entities;
use LWP::Simple;

# Declare variables
my $content;
my $url   = "http://ucsnews.csx.cam.ac.uk/xml/rss20/feed.xml";
my $total = 6;

# create new instance of XML::RSS
my $rss = new XML::RSS;

$content = get($url);
die "Could not retrieve $url" unless $content;
# parse the RSS content
$rss->parse($content);

print <<HTML;
<div id="content-secondary">
<dl class="news_box" style="border-bottom: 1px solid #ccc;">
<dt>
<a href="http://ucsnews.csx.cam.ac.uk/xml/rss20/feed.xml">
<img class="news_rss_image" src="/icons/rssfeed.gif"
  alt="[rss feed]" title="RSS feed" /></a>
<a href="http://ucsnews.csx.cam.ac.uk/">University Computing Service news</a>
</dt>
<dd>
HTML

# print the channel items
my $count = 0;
foreach my $item (@{$rss->{'items'}}) {
  next unless defined($item->{'title'});
  next unless defined($item->{'link'});
  next unless defined($item->{'pubDate'});

  my $pubdate    = $item->{'pubDate'};

  # "Wed, 03 Sep 2008 15:55:00 +0100" -> "03 Sep 2008"
  $pubdate = $1
    if ($pubdate =~ /^\w\w\w, (\d\d \w\w\w \d\d\d\d) \d\d:\d\d:\d\d \+0\d00$/);

  my $link       = $item->{'link'};
  my $title_html = HTML::Entities::encode($item->{'title'});
  my $date_html  = HTML::Entities::encode($pubdate);

  print <<"HTML";
<div class="news_item">
 <p class="news_item_date">${date_html}</p>
 <p>
   <a class="news_item_right_link" href="${link}">${title_html}</a>
 </p>
</div>
HTML

  last if ((++$count) >= $total);
}

print <<HTML;
<div class="news_seealso" style="padding-right: 1em;">
 See also <a href="http://ucsnews.csx.cam.ac.uk/xml/rss20/feed.xml">
 all Computing Service news</a>
</div>
</dd></dl>
  </div>
</div>
HTML
