      SUBROUTINE    N2P(N, ND, P, X, CALCR, CALCJ, IV, LIV, LV, V,
     1                  UI, UR, UF)
C
C  ***  VERSION OF NL2SOL THAT CALLS   RN2G AND HAS EXPANDED CALLING
C  ***  SEQUENCES FOR CALCR, CALCJ, ALLOWING THEM TO PROVIDE R AND J
C  ***  (RESIDUALS AND JACOBIAN) IN CHUNKS.
C
C  ***  PARAMETERS  ***
C
      INTEGER N, ND, P, LIV, LV
C/6
C     INTEGER IV(LIV), UI(1)
C     REAL X(P), V(LV), UR(1)
C/7
      INTEGER IV(LIV), UI(*)
      REAL X(P), V(LV), UR(*)
C/
      EXTERNAL CALCR, CALCJ, UF
C
C
C  ***  PARAMETER USAGE  ***
C
C N....... TOTAL NUMBER OF RESIDUALS.
C ND...... MAXIMUM NUMBER OF RESIDUAL COMPONENTS PROVIDED BY ANY CALL
C             ON CALCR.
C P....... NUMBER OF PARAMETERS (COMPONENTS OF X) BEING ESTIMATED.
C X....... PARAMETER VECTOR BEING ESTIMATED (INPUT = INITIAL GUESS,
C             OUTPUT = BEST VALUE FOUND).
C CALCR... SUBROUTINE FOR COMPUTING RESIDUAL VECTOR.
C CALCJ... SUBROUTINE FOR COMPUTING JACOBIAN MATRIX = MATRIX OF FIRST
C             PARTIALS OF THE RESIDUAL VECTOR.
C IV...... INTEGER VALUES ARRAY.
C LIV..... LENGTH OF IV (SEE DISCUSSION BELOW).
C LV...... LENGTH OF V (SEE DISCUSSION BELOW).
C V....... FLOATING-POINT VALUES ARRAY.
C UI...... PASSED UNCHANGED TO CALCR AND CALCJ.
C UR...... PASSED UNCHANGED TO CALCR AND CALCJ.
C UF...... PASSED UNCHANGED TO CALCR AND CALCJ.
C
C
C  ***  DISCUSSION  ***
C
C    THIS ROUTINE IS SIMILAR TO    N2G (WHICH SEE), EXCEPT THAT THE
C CALLING SEQUENCE FOR CALCR AND CALCJ IS DIFFERENT -- IT ALLOWS
C THE RESIDUAL VECTOR AND JACOBIAN MATRIX TO BE PASSED IN BLOCKS.
C
C   FOR CALCR, THE CALLING SEQUENCE IS...
C
C     CALCR(N, ND1, N1, N2, P, X, NF, R, UI, UR, UF)
C
C   PARAMETERS N, P, X, NF, R, UI, UR, UF ARE AS FOR THE CALCR USED
C BY NL2SOL OR    N2G.
C   PARAMETERS ND1, N1, AND N2 ARE INPUTS TO CALCR.  CALCR SHOULD NOT
C CHANGE ND1 OR N1 (BUT MAY CHANGE N2).
C   ND1 = MIN(N,ND) IS THE MAXIMUM NUMBER OF RESIDUAL COMPONENTS THAT
C CALCR SHOULD SUPPLY ON ONE CALL.
C   N1 IS THE INDEX OF THE FIRST RESIDUAL COMPONENT THAT CALCR SHOULD
C SUPPLY ON THIS CALL.
C   N2 HAS THE VALUE MIN(N, N1+ND1-1) WHEN CALCR IS CALLED.  CALCR
C MAY SET N2 TO A LOWER VALUE (AT LEAST 1) AND FOR N1 .LE. I .LE. N2
C SHOULD RETURN RESIDUAL COMPONENT I IN R(I-N1+1), I.E., IN COMPONENTS
C R(1), R(2), ..., R(N2-N1+1).
C
C   FOR CALCJ, THE CALLING SEQUENCE IS...
C
C     CALCJ(N, ND1, N1, N2, P, X, NF, J, UI, UR, UF)
C
C   ALL PARAMETERS EXCEPT N2 AND J ARE AS FOR CALCR.  N2 MAY NOT BE
C CHANGED, BUT OTHERWISE IS AS FOR CALCR.  (WHENEVER CALCJ IS CALLED,
C CALCR WILL JUST HAVE BEEN CALLED WITH THE SAME VALUE OF N1 BUT
C POSSIBLY A DIFFERENT X -- NF IDENTIFIES THE X PASSED.  IF CALCR
C CHANGES N2, THEN THIS CHANGED VALUE IS PASSED TO CALCJ.)
C   J IS A FLOATING-POINT ARRAY DIMENSIONED J(ND1,P).  FOR I = N1(1)N2
C AND K = 1(1)P, CALCJ MUST STORE THE PARTIAL DERIVATIVE AT X OF
C RESIDUAL COMPONENT I WITH RESPECT TO X(K) IN J(I-N1+1,K).
C
C   LIV MUST BE AT LEAST 82 + P.  LV MUST BE AT LEAST
C         105 + P*(17 + 2*P) + (P+1)*MIN(ND,N) + N
C IF ND .LT. N AND NO REGRESSION DIAGNOSTIC ARRAY IS REQUESTED
C (I.E., IV(RDREQ) = 0 OR 1), THEN LV CAN BE N LESS THAN THIS.
C
C+++++++++++++++++++++++++++  DECLARATIONS  +++++++++++++++++++++++++++
C
C  ***  EXTERNAL SUBROUTINES  ***
C
      EXTERNAL IVSET,  N2RDP,   RN2G
C IVSET.... PROVIDES DEFAULT IV AND V INPUT COMPONENTS.
C  N2RDP... PRINTS REGRESSION DIAGNOSTICS.
C   RN2G... CARRIES OUT OPTIMIZATION ITERATIONS.
C
C  ***  LOCAL VARIABLES  ***
C
      LOGICAL ONERD
      INTEGER D1, DR1, I, IV1, N1, N2, ND1, NF, R1, RD0, RD1, X01
C
C  ***  IV COMPONENTS  ***
C
      INTEGER D, J, NEXTV, NF00, NFCALL, NFGCAL, R, RDREQ, REGD,
     1        REGD0, TOOBIG, VNEED, X0
C/6
C     DATA D/27/, J/70/, NEXTV/47/, NF00/81/, NFCALL/6/, NFGCAL/7/,
C    1     R/61/, RDREQ/57/, REGD/67/, REGD0/82/, TOOBIG/2/, VNEED/4/,
C    2     X0/43/
C/7
      PARAMETER (D=27, J=70, NEXTV=47, NF00=81, NFCALL=6, NFGCAL=7,
     1           R=61, RDREQ=57, REGD=67, REGD0=82, TOOBIG=2, VNEED=4,
     2           X0=43)
C/
C---------------------------------  BODY  ------------------------------
C
      IF (IV(1) .EQ. 0) CALL IVSET(1, IV, LIV, LV, V)
      ND1 = MIN0(ND, N)
      IV1 = IV(1)
      IF (IV1 .EQ. 14) GO TO 10
      IF (IV1 .GT. 2 .AND. IV1 .LT. 12) GO TO 10
      IF (IV1 .EQ. 12) IV(1) = 13
      I = IV(VNEED) + P + ND1*(P+1)
      ONERD = IV(RDREQ) .GE. 2 .OR. ND .GE. N
      IF (ONERD) I = I + N
      IF (IV(1) .EQ. 13) IV(VNEED) = I
      CALL   RN2G(V, V, IV, LIV, LV, N, ND1, N1, N2, P, V, V, V, X)
      IF (IV(1) .NE. 14) GO TO 999
C
C  ***  STORAGE ALLOCATION  ***
C
      IV(D) = IV(NEXTV)
      IV(R) = IV(D) + P
      I = IV(R) + ND1
      IV(REGD0) = I
      IF (ONERD) I = I + N
      IV(J) = I
      IV(NEXTV) = I + ND1*P
      IF (IV1 .EQ. 13) GO TO 999
C
 10   D1 = IV(D)
      DR1 = IV(J)
      R1 = IV(R)
      RD1 = IV(REGD0)
      RD0 = RD1 - 1
C
 20   CALL   RN2G(V(D1), V(DR1), IV, LIV, LV, N, ND1, N1, N2, P, V(R1),
     1            V(RD1), V, X)
      IV1 = IV(1)
      IF (IV1-2) 40, 30, 80
 30   IF (ND .GE. N) GO TO 70
C
C  ***  FIRST COMPUTE RELEVANT PORTION OF R  ***
C
 40   NF = IV(NFCALL)
      IF (IABS(IV1) .GE. 2) NF = IV(NFGCAL)
      CALL CALCR(N, ND1, N1, N2, P, X, NF, V(R1), UI, UR, UF)
      IF (NF .GT. 0) GO TO 50
         IV(TOOBIG) = 1
         GO TO 20
 50   I = IV1 + 4
      GO TO (70, 60, 70, 20, 20, 70), I
 60   X01 = IV(X0)
      CALL CALCJ(N, ND1, N1, N2, P, V(X01), IV(NF00), V(DR1), UI,
     1           UR, UF)
      IF (IV(NF00) .LE. 0) IV(TOOBIG) = 1
      GO TO 20
C
C  ***  COMPUTE DR = GRADIENT OF R COMPONENTS  ***
C
 70   CALL CALCJ(N, ND1, N1, N2, P, X, IV(NFGCAL), V(DR1), UI, UR, UF)
      IF (IV(NFGCAL) .EQ. 0) IV(TOOBIG) = 1
      RD1 = RD0 + N1
      GO TO 20
C
 80   RD1 = RD0 + 1
      IF (IV(REGD) .GT. 0) IV(REGD) = RD1
      IF (IV(1) .LE. 8) CALL  N2RDP(IV, LIV, LV, N, V(RD1), V)
C
 999  RETURN
C
C  ***  LAST LINE OF    N2P FOLLOWS  ***
      END
