/**********************************************************************
 * Example veriusertfs table that is used by many Verilog simulators
 * to register PLI applications that use the TF and ACC libraries of
 * the IEEE 1364 PLI.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

/* prototypes of the PLI application routines */
extern int PLIbook_pow_sizetf(), PLIbook_pow_checktf(),
           PLIbook_pow_calltf(), PLIbook_pow_misctf();

/* the veriusertfs table */
s_tfcell veriusertfs[] =
{
    {userfunction,             /* type of PLI routine */
      0,                       /* user_data value */
      PLIbook_pow_checktf,     /* checktf routine */
      PLIbook_pow_sizetf,      /* sizetf routine */
      PLIbook_pow_calltf,      /* calltf routine */
      PLIbook_pow_misctf,      /* misctf routine */
      "$pow",                  /* system task/function name */
      1                        /* forward reference = true */
    },

    {0} /*** final entry must be 0 ***/
};
