# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AlertingResultQuery(msrest.serialization.Model):
    """AlertingResultQuery.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. start time.
    :type start_time: ~datetime.datetime
    :param end_time: Required. end time.
    :type end_time: ~datetime.datetime
    :param time_mode: Required. time mode. Possible values include: "AnomalyTime", "CreatedTime",
     "ModifiedTime".
    :type time_mode: str or ~azure.ai.metricsadvisor.models.TimeMode
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
        'time_mode': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_mode': {'key': 'timeMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertingResultQuery, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.time_mode = kwargs['time_mode']


class AlertResult(msrest.serialization.Model):
    """AlertResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_id: alert id.
    :vartype alert_id: str
    :ivar timestamp: anomaly time.
    :vartype timestamp: ~datetime.datetime
    :ivar created_time: created time.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: modified time.
    :vartype modified_time: ~datetime.datetime
    """

    _validation = {
        'alert_id': {'readonly': True},
        'timestamp': {'readonly': True},
        'created_time': {'readonly': True},
        'modified_time': {'readonly': True},
    }

    _attribute_map = {
        'alert_id': {'key': 'alertId', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertResult, self).__init__(**kwargs)
        self.alert_id = None
        self.timestamp = None
        self.created_time = None
        self.modified_time = None


class AlertResultList(msrest.serialization.Model):
    """AlertResultList.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Required.
    :type next_link: str
    :param value: Required.
    :type value: list[~azure.ai.metricsadvisor.models.AlertResult]
    """

    _validation = {
        'next_link': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[AlertResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertResultList, self).__init__(**kwargs)
        self.next_link = kwargs['next_link']
        self.value = kwargs['value']


class AlertSnoozeCondition(msrest.serialization.Model):
    """AlertSnoozeCondition.

    All required parameters must be populated in order to send to Azure.

    :param auto_snooze: Required. snooze point count, value range : [0, +∞).
    :type auto_snooze: int
    :param snooze_scope: Required. snooze scope. Possible values include: "Metric", "Series".
    :type snooze_scope: str or ~azure.ai.metricsadvisor.models.SnoozeScope
    :param only_for_successive: Required. only snooze for successive anomalies.
    :type only_for_successive: bool
    """

    _validation = {
        'auto_snooze': {'required': True},
        'snooze_scope': {'required': True},
        'only_for_successive': {'required': True},
    }

    _attribute_map = {
        'auto_snooze': {'key': 'autoSnooze', 'type': 'int'},
        'snooze_scope': {'key': 'snoozeScope', 'type': 'str'},
        'only_for_successive': {'key': 'onlyForSuccessive', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertSnoozeCondition, self).__init__(**kwargs)
        self.auto_snooze = kwargs['auto_snooze']
        self.snooze_scope = kwargs['snooze_scope']
        self.only_for_successive = kwargs['only_for_successive']


class AnomalyAlertingConfiguration(msrest.serialization.Model):
    """AnomalyAlertingConfiguration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar anomaly_alerting_configuration_id: anomaly alerting configuration unique id.
    :vartype anomaly_alerting_configuration_id: str
    :param name: Required. anomaly alerting configuration name.
    :type name: str
    :param description: anomaly alerting configuration description.
    :type description: str
    :param cross_metrics_operator: cross metrics operator
    
     should be specified when setting up multiple metric alerting configurations. Possible values
     include: "AND", "OR", "XOR".
    :type cross_metrics_operator: str or
     ~azure.ai.metricsadvisor.models.AnomalyAlertingConfigurationCrossMetricsOperator
    :param hook_ids: Required. hook unique ids.
    :type hook_ids: list[str]
    :param metric_alerting_configurations: Required. Anomaly alerting configurations.
    :type metric_alerting_configurations:
     list[~azure.ai.metricsadvisor.models.MetricAlertingConfiguration]
    """

    _validation = {
        'anomaly_alerting_configuration_id': {'readonly': True},
        'name': {'required': True},
        'hook_ids': {'required': True, 'unique': True},
        'metric_alerting_configurations': {'required': True, 'unique': True},
    }

    _attribute_map = {
        'anomaly_alerting_configuration_id': {'key': 'anomalyAlertingConfigurationId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'cross_metrics_operator': {'key': 'crossMetricsOperator', 'type': 'str'},
        'hook_ids': {'key': 'hookIds', 'type': '[str]'},
        'metric_alerting_configurations': {'key': 'metricAlertingConfigurations', 'type': '[MetricAlertingConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyAlertingConfiguration, self).__init__(**kwargs)
        self.anomaly_alerting_configuration_id = None
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.cross_metrics_operator = kwargs.get('cross_metrics_operator', None)
        self.hook_ids = kwargs['hook_ids']
        self.metric_alerting_configurations = kwargs['metric_alerting_configurations']


class AnomalyAlertingConfigurationList(msrest.serialization.Model):
    """AnomalyAlertingConfigurationList.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.ai.metricsadvisor.models.AnomalyAlertingConfiguration]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AnomalyAlertingConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyAlertingConfigurationList, self).__init__(**kwargs)
        self.value = kwargs['value']


class AnomalyAlertingConfigurationPatch(msrest.serialization.Model):
    """AnomalyAlertingConfigurationPatch.

    :param name: Anomaly alerting configuration name.
    :type name: str
    :param description: anomaly alerting configuration description.
    :type description: str
    :param cross_metrics_operator: cross metrics operator. Possible values include: "AND", "OR",
     "XOR".
    :type cross_metrics_operator: str or
     ~azure.ai.metricsadvisor.models.AnomalyAlertingConfigurationPatchCrossMetricsOperator
    :param hook_ids: hook unique ids.
    :type hook_ids: list[str]
    :param metric_alerting_configurations: Anomaly alerting configurations.
    :type metric_alerting_configurations:
     list[~azure.ai.metricsadvisor.models.MetricAlertingConfiguration]
    """

    _validation = {
        'hook_ids': {'unique': True},
        'metric_alerting_configurations': {'unique': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'cross_metrics_operator': {'key': 'crossMetricsOperator', 'type': 'str'},
        'hook_ids': {'key': 'hookIds', 'type': '[str]'},
        'metric_alerting_configurations': {'key': 'metricAlertingConfigurations', 'type': '[MetricAlertingConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyAlertingConfigurationPatch, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.cross_metrics_operator = kwargs.get('cross_metrics_operator', None)
        self.hook_ids = kwargs.get('hook_ids', None)
        self.metric_alerting_configurations = kwargs.get('metric_alerting_configurations', None)


class AnomalyDetectionConfiguration(msrest.serialization.Model):
    """AnomalyDetectionConfiguration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar anomaly_detection_configuration_id: anomaly detection configuration unique id.
    :vartype anomaly_detection_configuration_id: str
    :param name: Required. anomaly detection configuration name.
    :type name: str
    :param description: anomaly detection configuration description.
    :type description: str
    :param metric_id: Required. metric unique id.
    :type metric_id: str
    :param whole_metric_configuration: Required.
    :type whole_metric_configuration: ~azure.ai.metricsadvisor.models.WholeMetricConfiguration
    :param dimension_group_override_configurations: detection configuration for series group.
    :type dimension_group_override_configurations:
     list[~azure.ai.metricsadvisor.models.DimensionGroupConfiguration]
    :param series_override_configurations: detection configuration for specific series.
    :type series_override_configurations: list[~azure.ai.metricsadvisor.models.SeriesConfiguration]
    """

    _validation = {
        'anomaly_detection_configuration_id': {'readonly': True},
        'name': {'required': True},
        'metric_id': {'required': True},
        'whole_metric_configuration': {'required': True},
        'dimension_group_override_configurations': {'unique': True},
        'series_override_configurations': {'unique': True},
    }

    _attribute_map = {
        'anomaly_detection_configuration_id': {'key': 'anomalyDetectionConfigurationId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'whole_metric_configuration': {'key': 'wholeMetricConfiguration', 'type': 'WholeMetricConfiguration'},
        'dimension_group_override_configurations': {'key': 'dimensionGroupOverrideConfigurations', 'type': '[DimensionGroupConfiguration]'},
        'series_override_configurations': {'key': 'seriesOverrideConfigurations', 'type': '[SeriesConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyDetectionConfiguration, self).__init__(**kwargs)
        self.anomaly_detection_configuration_id = None
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.metric_id = kwargs['metric_id']
        self.whole_metric_configuration = kwargs['whole_metric_configuration']
        self.dimension_group_override_configurations = kwargs.get('dimension_group_override_configurations', None)
        self.series_override_configurations = kwargs.get('series_override_configurations', None)


class AnomalyDetectionConfigurationList(msrest.serialization.Model):
    """AnomalyDetectionConfigurationList.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.ai.metricsadvisor.models.AnomalyDetectionConfiguration]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AnomalyDetectionConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyDetectionConfigurationList, self).__init__(**kwargs)
        self.value = kwargs['value']


class AnomalyDetectionConfigurationPatch(msrest.serialization.Model):
    """AnomalyDetectionConfigurationPatch.

    :param name: anomaly detection configuration name.
    :type name: str
    :param description: anomaly detection configuration description.
    :type description: str
    :param whole_metric_configuration:
    :type whole_metric_configuration: ~azure.ai.metricsadvisor.models.WholeMetricConfiguration
    :param dimension_group_override_configurations: detection configuration for series group.
    :type dimension_group_override_configurations:
     list[~azure.ai.metricsadvisor.models.DimensionGroupConfiguration]
    :param series_override_configurations: detection configuration for specific series.
    :type series_override_configurations: list[~azure.ai.metricsadvisor.models.SeriesConfiguration]
    """

    _validation = {
        'dimension_group_override_configurations': {'unique': True},
        'series_override_configurations': {'unique': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'whole_metric_configuration': {'key': 'wholeMetricConfiguration', 'type': 'WholeMetricConfiguration'},
        'dimension_group_override_configurations': {'key': 'dimensionGroupOverrideConfigurations', 'type': '[DimensionGroupConfiguration]'},
        'series_override_configurations': {'key': 'seriesOverrideConfigurations', 'type': '[SeriesConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyDetectionConfigurationPatch, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.whole_metric_configuration = kwargs.get('whole_metric_configuration', None)
        self.dimension_group_override_configurations = kwargs.get('dimension_group_override_configurations', None)
        self.series_override_configurations = kwargs.get('series_override_configurations', None)


class AnomalyDimensionList(msrest.serialization.Model):
    """AnomalyDimensionList.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Required.
    :type next_link: str
    :param value: Required.
    :type value: list[str]
    """

    _validation = {
        'next_link': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyDimensionList, self).__init__(**kwargs)
        self.next_link = kwargs['next_link']
        self.value = kwargs['value']


class AnomalyDimensionQuery(msrest.serialization.Model):
    """AnomalyDimensionQuery.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. start time.
    :type start_time: ~datetime.datetime
    :param end_time: Required. end time.
    :type end_time: ~datetime.datetime
    :param dimension_name: Required. dimension to query.
    :type dimension_name: str
    :param dimension_filter:
    :type dimension_filter: ~azure.ai.metricsadvisor.models.DimensionGroupIdentity
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
        'dimension_name': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'dimension_name': {'key': 'dimensionName', 'type': 'str'},
        'dimension_filter': {'key': 'dimensionFilter', 'type': 'DimensionGroupIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyDimensionQuery, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.dimension_name = kwargs['dimension_name']
        self.dimension_filter = kwargs.get('dimension_filter', None)


class MetricFeedback(msrest.serialization.Model):
    """MetricFeedback.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AnomalyFeedback, ChangePointFeedback, CommentFeedback, PeriodFeedback.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param feedback_type: Required. feedback type.Constant filled by server.  Possible values
     include: "Anomaly", "ChangePoint", "Period", "Comment".
    :type feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar feedback_id: feedback unique id.
    :vartype feedback_id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :param metric_id: Required. metric unique id.
    :type metric_id: str
    :param dimension_filter: Required.
    :type dimension_filter: ~azure.ai.metricsadvisor.models.FeedbackDimensionFilter
    """

    _validation = {
        'feedback_type': {'required': True},
        'feedback_id': {'readonly': True},
        'created_time': {'readonly': True},
        'user_principal': {'readonly': True},
        'metric_id': {'required': True},
        'dimension_filter': {'required': True},
    }

    _attribute_map = {
        'feedback_type': {'key': 'feedbackType', 'type': 'str'},
        'feedback_id': {'key': 'feedbackId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'user_principal': {'key': 'userPrincipal', 'type': 'str'},
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'dimension_filter': {'key': 'dimensionFilter', 'type': 'FeedbackDimensionFilter'},
    }

    _subtype_map = {
        'feedback_type': {'Anomaly': 'AnomalyFeedback', 'ChangePoint': 'ChangePointFeedback', 'Comment': 'CommentFeedback', 'Period': 'PeriodFeedback'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricFeedback, self).__init__(**kwargs)
        self.feedback_type = None  # type: Optional[str]
        self.feedback_id = None
        self.created_time = None
        self.user_principal = None
        self.metric_id = kwargs['metric_id']
        self.dimension_filter = kwargs['dimension_filter']


class AnomalyFeedback(MetricFeedback):
    """AnomalyFeedback.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param feedback_type: Required. feedback type.Constant filled by server.  Possible values
     include: "Anomaly", "ChangePoint", "Period", "Comment".
    :type feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar feedback_id: feedback unique id.
    :vartype feedback_id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :param metric_id: Required. metric unique id.
    :type metric_id: str
    :param dimension_filter: Required.
    :type dimension_filter: ~azure.ai.metricsadvisor.models.FeedbackDimensionFilter
    :param start_time: Required. the start timestamp of feedback timerange.
    :type start_time: ~datetime.datetime
    :param end_time: Required. the end timestamp of feedback timerange, when equals to startTime
     means only one timestamp.
    :type end_time: ~datetime.datetime
    :param value: Required.
    :type value: ~azure.ai.metricsadvisor.models.AnomalyFeedbackValue
    :param anomaly_detection_configuration_id: the corresponding anomaly detection configuration of
     this feedback.
    :type anomaly_detection_configuration_id: str
    :param anomaly_detection_configuration_snapshot:
    :type anomaly_detection_configuration_snapshot:
     ~azure.ai.metricsadvisor.models.AnomalyDetectionConfiguration
    """

    _validation = {
        'feedback_type': {'required': True},
        'feedback_id': {'readonly': True},
        'created_time': {'readonly': True},
        'user_principal': {'readonly': True},
        'metric_id': {'required': True},
        'dimension_filter': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'feedback_type': {'key': 'feedbackType', 'type': 'str'},
        'feedback_id': {'key': 'feedbackId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'user_principal': {'key': 'userPrincipal', 'type': 'str'},
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'dimension_filter': {'key': 'dimensionFilter', 'type': 'FeedbackDimensionFilter'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'AnomalyFeedbackValue'},
        'anomaly_detection_configuration_id': {'key': 'anomalyDetectionConfigurationId', 'type': 'str'},
        'anomaly_detection_configuration_snapshot': {'key': 'anomalyDetectionConfigurationSnapshot', 'type': 'AnomalyDetectionConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyFeedback, self).__init__(**kwargs)
        self.feedback_type = 'Anomaly'  # type: str
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.value = kwargs['value']
        self.anomaly_detection_configuration_id = kwargs.get('anomaly_detection_configuration_id', None)
        self.anomaly_detection_configuration_snapshot = kwargs.get('anomaly_detection_configuration_snapshot', None)


class AnomalyFeedbackValue(msrest.serialization.Model):
    """AnomalyFeedbackValue.

    All required parameters must be populated in order to send to Azure.

    :param anomaly_value: Required.  Possible values include: "AutoDetect", "Anomaly",
     "NotAnomaly".
    :type anomaly_value: str or ~azure.ai.metricsadvisor.models.AnomalyValue
    """

    _validation = {
        'anomaly_value': {'required': True},
    }

    _attribute_map = {
        'anomaly_value': {'key': 'anomalyValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyFeedbackValue, self).__init__(**kwargs)
        self.anomaly_value = kwargs['anomaly_value']


class AnomalyProperty(msrest.serialization.Model):
    """AnomalyProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param anomaly_severity: Required. anomaly severity. Possible values include: "Low", "Medium",
     "High".
    :type anomaly_severity: str or ~azure.ai.metricsadvisor.models.Severity
    :ivar anomaly_status: anomaly status
    
     only return for alerting anomaly result. Possible values include: "Active", "Resolved".
    :vartype anomaly_status: str or ~azure.ai.metricsadvisor.models.AnomalyPropertyAnomalyStatus
    """

    _validation = {
        'anomaly_severity': {'required': True},
        'anomaly_status': {'readonly': True},
    }

    _attribute_map = {
        'anomaly_severity': {'key': 'anomalySeverity', 'type': 'str'},
        'anomaly_status': {'key': 'anomalyStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyProperty, self).__init__(**kwargs)
        self.anomaly_severity = kwargs['anomaly_severity']
        self.anomaly_status = None


class AnomalyResult(msrest.serialization.Model):
    """AnomalyResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar metric_id: metric unique id
    
     only return for alerting anomaly result.
    :vartype metric_id: str
    :ivar anomaly_detection_configuration_id: anomaly detection configuration unique id
    
     only return for alerting anomaly result.
    :vartype anomaly_detection_configuration_id: str
    :param timestamp: Required. anomaly time.
    :type timestamp: ~datetime.datetime
    :ivar created_time: created time
    
     only return for alerting result.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: modified time
    
     only return for alerting result.
    :vartype modified_time: ~datetime.datetime
    :param dimension: Required. dimension specified for series.
    :type dimension: dict[str, str]
    :param property: Required.
    :type property: ~azure.ai.metricsadvisor.models.AnomalyProperty
    """

    _validation = {
        'metric_id': {'readonly': True},
        'anomaly_detection_configuration_id': {'readonly': True},
        'timestamp': {'required': True},
        'created_time': {'readonly': True},
        'modified_time': {'readonly': True},
        'dimension': {'required': True},
        'property': {'required': True},
    }

    _attribute_map = {
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'anomaly_detection_configuration_id': {'key': 'anomalyDetectionConfigurationId', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'dimension': {'key': 'dimension', 'type': '{str}'},
        'property': {'key': 'property', 'type': 'AnomalyProperty'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyResult, self).__init__(**kwargs)
        self.metric_id = None
        self.anomaly_detection_configuration_id = None
        self.timestamp = kwargs['timestamp']
        self.created_time = None
        self.modified_time = None
        self.dimension = kwargs['dimension']
        self.property = kwargs['property']


class AnomalyResultList(msrest.serialization.Model):
    """AnomalyResultList.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Required.
    :type next_link: str
    :param value: Required.
    :type value: list[~azure.ai.metricsadvisor.models.AnomalyResult]
    """

    _validation = {
        'next_link': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[AnomalyResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnomalyResultList, self).__init__(**kwargs)
        self.next_link = kwargs['next_link']
        self.value = kwargs['value']


class DataFeedDetail(msrest.serialization.Model):
    """DataFeedDetail.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureApplicationInsightsDataFeed, AzureBlobDataFeed, AzureCosmosDBDataFeed, AzureDataExplorerDataFeed, AzureDataLakeStorageGen2DataFeed, AzureTableDataFeed, ElasticsearchDataFeed, HttpRequestDataFeed, InfluxDBDataFeed, MongoDBDataFeed, MySqlDataFeed, PostgreSqlDataFeed, SQLServerDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
    }

    _subtype_map = {
        'data_source_type': {'AzureApplicationInsights': 'AzureApplicationInsightsDataFeed', 'AzureBlob': 'AzureBlobDataFeed', 'AzureCosmosDB': 'AzureCosmosDBDataFeed', 'AzureDataExplorer': 'AzureDataExplorerDataFeed', 'AzureDataLakeStorageGen2': 'AzureDataLakeStorageGen2DataFeed', 'AzureTable': 'AzureTableDataFeed', 'Elasticsearch': 'ElasticsearchDataFeed', 'HttpRequest': 'HttpRequestDataFeed', 'InfluxDB': 'InfluxDBDataFeed', 'MongoDB': 'MongoDBDataFeed', 'MySql': 'MySqlDataFeed', 'PostgreSql': 'PostgreSqlDataFeed', 'SqlServer': 'SQLServerDataFeed'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFeedDetail, self).__init__(**kwargs)
        self.data_source_type = None  # type: Optional[str]
        self.data_feed_id = None
        self.data_feed_name = kwargs['data_feed_name']
        self.data_feed_description = kwargs.get('data_feed_description', None)
        self.granularity_name = kwargs['granularity_name']
        self.granularity_amount = kwargs.get('granularity_amount', None)
        self.metrics = kwargs['metrics']
        self.dimension = kwargs.get('dimension', None)
        self.timestamp_column = kwargs.get('timestamp_column', None)
        self.data_start_from = kwargs['data_start_from']
        self.start_offset_in_seconds = kwargs.get('start_offset_in_seconds', 0)
        self.max_concurrency = kwargs.get('max_concurrency', -1)
        self.min_retry_interval_in_seconds = kwargs.get('min_retry_interval_in_seconds', -1)
        self.stop_retry_after_in_seconds = kwargs.get('stop_retry_after_in_seconds', -1)
        self.need_rollup = kwargs.get('need_rollup', "NeedRollup")
        self.roll_up_method = kwargs.get('roll_up_method', None)
        self.roll_up_columns = kwargs.get('roll_up_columns', None)
        self.all_up_identification = kwargs.get('all_up_identification', None)
        self.fill_missing_point_type = kwargs.get('fill_missing_point_type', "SmartFilling")
        self.fill_missing_point_value = kwargs.get('fill_missing_point_value', None)
        self.view_mode = kwargs.get('view_mode', "Private")
        self.admins = kwargs.get('admins', None)
        self.viewers = kwargs.get('viewers', None)
        self.is_admin = None
        self.creator = None
        self.status = None
        self.created_time = None
        self.action_link_template = kwargs.get('action_link_template', None)


class AzureApplicationInsightsDataFeed(DataFeedDetail):
    """AzureApplicationInsightsDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureApplicationInsightsParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureApplicationInsightsParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureApplicationInsightsDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'AzureApplicationInsights'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class DataFeedDetailPatch(msrest.serialization.Model):
    """DataFeedDetailPatch.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureApplicationInsightsDataFeedPatch, AzureBlobDataFeedPatch, AzureCosmosDBDataFeedPatch, AzureDataExplorerDataFeedPatch, AzureDataLakeStorageGen2DataFeedPatch, AzureTableDataFeedPatch, ElasticsearchDataFeedPatch, HttpRequestDataFeedPatch, InfluxDBDataFeedPatch, MongoDBDataFeedPatch, MySqlDataFeedPatch, PostgreSqlDataFeedPatch, SQLServerDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
    }

    _subtype_map = {
        'data_source_type': {'AzureApplicationInsights': 'AzureApplicationInsightsDataFeedPatch', 'AzureBlob': 'AzureBlobDataFeedPatch', 'AzureCosmosDB': 'AzureCosmosDBDataFeedPatch', 'AzureDataExplorer': 'AzureDataExplorerDataFeedPatch', 'AzureDataLakeStorageGen2': 'AzureDataLakeStorageGen2DataFeedPatch', 'AzureTable': 'AzureTableDataFeedPatch', 'Elasticsearch': 'ElasticsearchDataFeedPatch', 'HttpRequest': 'HttpRequestDataFeedPatch', 'InfluxDB': 'InfluxDBDataFeedPatch', 'MongoDB': 'MongoDBDataFeedPatch', 'MySql': 'MySqlDataFeedPatch', 'PostgreSql': 'PostgreSqlDataFeedPatch', 'SqlServer': 'SQLServerDataFeedPatch'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFeedDetailPatch, self).__init__(**kwargs)
        self.data_source_type = None  # type: Optional[str]
        self.data_feed_name = kwargs.get('data_feed_name', None)
        self.data_feed_description = kwargs.get('data_feed_description', None)
        self.timestamp_column = kwargs.get('timestamp_column', None)
        self.data_start_from = kwargs.get('data_start_from', None)
        self.start_offset_in_seconds = kwargs.get('start_offset_in_seconds', None)
        self.max_concurrency = kwargs.get('max_concurrency', None)
        self.min_retry_interval_in_seconds = kwargs.get('min_retry_interval_in_seconds', None)
        self.stop_retry_after_in_seconds = kwargs.get('stop_retry_after_in_seconds', None)
        self.need_rollup = kwargs.get('need_rollup', None)
        self.roll_up_method = kwargs.get('roll_up_method', None)
        self.roll_up_columns = kwargs.get('roll_up_columns', None)
        self.all_up_identification = kwargs.get('all_up_identification', None)
        self.fill_missing_point_type = kwargs.get('fill_missing_point_type', None)
        self.fill_missing_point_value = kwargs.get('fill_missing_point_value', None)
        self.view_mode = kwargs.get('view_mode', None)
        self.admins = kwargs.get('admins', None)
        self.viewers = kwargs.get('viewers', None)
        self.status = kwargs.get('status', None)
        self.action_link_template = kwargs.get('action_link_template', None)


class AzureApplicationInsightsDataFeedPatch(DataFeedDetailPatch):
    """AzureApplicationInsightsDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureApplicationInsightsParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureApplicationInsightsParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureApplicationInsightsDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'AzureApplicationInsights'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class AzureApplicationInsightsParameter(msrest.serialization.Model):
    """AzureApplicationInsightsParameter.

    All required parameters must be populated in order to send to Azure.

    :param azure_cloud: Required. Azure cloud environment.
    :type azure_cloud: str
    :param application_id: Required. Azure Application Insights ID.
    :type application_id: str
    :param api_key: Required. API Key.
    :type api_key: str
    :param query: Required. Query.
    :type query: str
    """

    _validation = {
        'azure_cloud': {'required': True},
        'application_id': {'required': True},
        'api_key': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'azure_cloud': {'key': 'azureCloud', 'type': 'str'},
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'api_key': {'key': 'apiKey', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureApplicationInsightsParameter, self).__init__(**kwargs)
        self.azure_cloud = kwargs['azure_cloud']
        self.application_id = kwargs['application_id']
        self.api_key = kwargs['api_key']
        self.query = kwargs['query']


class AzureBlobDataFeed(DataFeedDetail):
    """AzureBlobDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureBlobParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureBlobParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'AzureBlob'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class AzureBlobDataFeedPatch(DataFeedDetailPatch):
    """AzureBlobDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureBlobParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureBlobParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'AzureBlob'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class AzureBlobParameter(msrest.serialization.Model):
    """AzureBlobParameter.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. Azure Blob connection string.
    :type connection_string: str
    :param container: Required. Container.
    :type container: str
    :param blob_template: Required. Blob Template.
    :type blob_template: str
    """

    _validation = {
        'connection_string': {'required': True},
        'container': {'required': True},
        'blob_template': {'required': True},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'container': {'key': 'container', 'type': 'str'},
        'blob_template': {'key': 'blobTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobParameter, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.container = kwargs['container']
        self.blob_template = kwargs['blob_template']


class AzureCosmosDBDataFeed(DataFeedDetail):
    """AzureCosmosDBDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureCosmosDBParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureCosmosDBParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureCosmosDBDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'AzureCosmosDB'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class AzureCosmosDBDataFeedPatch(DataFeedDetailPatch):
    """AzureCosmosDBDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureCosmosDBParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureCosmosDBParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureCosmosDBDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'AzureCosmosDB'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class AzureCosmosDBParameter(msrest.serialization.Model):
    """AzureCosmosDBParameter.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. Azure CosmosDB connection string.
    :type connection_string: str
    :param sql_query: Required. Query script.
    :type sql_query: str
    :param database: Required. Database name.
    :type database: str
    :param collection_id: Required. Collection id.
    :type collection_id: str
    """

    _validation = {
        'connection_string': {'required': True},
        'sql_query': {'required': True},
        'database': {'required': True},
        'collection_id': {'required': True},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'sql_query': {'key': 'sqlQuery', 'type': 'str'},
        'database': {'key': 'database', 'type': 'str'},
        'collection_id': {'key': 'collectionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureCosmosDBParameter, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.sql_query = kwargs['sql_query']
        self.database = kwargs['database']
        self.collection_id = kwargs['collection_id']


class AzureDataExplorerDataFeed(DataFeedDetail):
    """AzureDataExplorerDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.SqlSourceParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'SqlSourceParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataExplorerDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'AzureDataExplorer'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class AzureDataExplorerDataFeedPatch(DataFeedDetailPatch):
    """AzureDataExplorerDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.SqlSourceParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'SqlSourceParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataExplorerDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'AzureDataExplorer'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class AzureDataLakeStorageGen2DataFeed(DataFeedDetail):
    """AzureDataLakeStorageGen2DataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureDataLakeStorageGen2Parameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureDataLakeStorageGen2Parameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeStorageGen2DataFeed, self).__init__(**kwargs)
        self.data_source_type = 'AzureDataLakeStorageGen2'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class AzureDataLakeStorageGen2DataFeedPatch(DataFeedDetailPatch):
    """AzureDataLakeStorageGen2DataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureDataLakeStorageGen2Parameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureDataLakeStorageGen2Parameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeStorageGen2DataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'AzureDataLakeStorageGen2'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class AzureDataLakeStorageGen2Parameter(msrest.serialization.Model):
    """AzureDataLakeStorageGen2Parameter.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required. Account name.
    :type account_name: str
    :param account_key: Required. Account key.
    :type account_key: str
    :param file_system_name: Required. File system name (Container).
    :type file_system_name: str
    :param directory_template: Required. Directory template.
    :type directory_template: str
    :param file_template: Required. File template.
    :type file_template: str
    """

    _validation = {
        'account_name': {'required': True},
        'account_key': {'required': True},
        'file_system_name': {'required': True},
        'directory_template': {'required': True},
        'file_template': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'file_system_name': {'key': 'fileSystemName', 'type': 'str'},
        'directory_template': {'key': 'directoryTemplate', 'type': 'str'},
        'file_template': {'key': 'fileTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeStorageGen2Parameter, self).__init__(**kwargs)
        self.account_name = kwargs['account_name']
        self.account_key = kwargs['account_key']
        self.file_system_name = kwargs['file_system_name']
        self.directory_template = kwargs['directory_template']
        self.file_template = kwargs['file_template']


class AzureTableDataFeed(DataFeedDetail):
    """AzureTableDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureTableParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureTableParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureTableDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'AzureTable'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class AzureTableDataFeedPatch(DataFeedDetailPatch):
    """AzureTableDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.AzureTableParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'AzureTableParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureTableDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'AzureTable'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class AzureTableParameter(msrest.serialization.Model):
    """AzureTableParameter.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. Azure Table connection string.
    :type connection_string: str
    :param table: Required. Table name.
    :type table: str
    :param query: Required. Query script.
    :type query: str
    """

    _validation = {
        'connection_string': {'required': True},
        'table': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureTableParameter, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.table = kwargs['table']
        self.query = kwargs['query']


class ChangePointFeedback(MetricFeedback):
    """ChangePointFeedback.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param feedback_type: Required. feedback type.Constant filled by server.  Possible values
     include: "Anomaly", "ChangePoint", "Period", "Comment".
    :type feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar feedback_id: feedback unique id.
    :vartype feedback_id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :param metric_id: Required. metric unique id.
    :type metric_id: str
    :param dimension_filter: Required.
    :type dimension_filter: ~azure.ai.metricsadvisor.models.FeedbackDimensionFilter
    :param start_time: Required. the start timestamp of feedback timerange.
    :type start_time: ~datetime.datetime
    :param end_time: Required. the end timestamp of feedback timerange, when equals to startTime
     means only one timestamp.
    :type end_time: ~datetime.datetime
    :param value: Required.
    :type value: ~azure.ai.metricsadvisor.models.ChangePointFeedbackValue
    """

    _validation = {
        'feedback_type': {'required': True},
        'feedback_id': {'readonly': True},
        'created_time': {'readonly': True},
        'user_principal': {'readonly': True},
        'metric_id': {'required': True},
        'dimension_filter': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'feedback_type': {'key': 'feedbackType', 'type': 'str'},
        'feedback_id': {'key': 'feedbackId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'user_principal': {'key': 'userPrincipal', 'type': 'str'},
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'dimension_filter': {'key': 'dimensionFilter', 'type': 'FeedbackDimensionFilter'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'ChangePointFeedbackValue'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ChangePointFeedback, self).__init__(**kwargs)
        self.feedback_type = 'ChangePoint'  # type: str
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.value = kwargs['value']


class ChangePointFeedbackValue(msrest.serialization.Model):
    """ChangePointFeedbackValue.

    All required parameters must be populated in order to send to Azure.

    :param change_point_value: Required.  Possible values include: "AutoDetect", "ChangePoint",
     "NotChangePoint".
    :type change_point_value: str or ~azure.ai.metricsadvisor.models.ChangePointValue
    """

    _validation = {
        'change_point_value': {'required': True},
    }

    _attribute_map = {
        'change_point_value': {'key': 'changePointValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ChangePointFeedbackValue, self).__init__(**kwargs)
        self.change_point_value = kwargs['change_point_value']


class ChangeThresholdCondition(msrest.serialization.Model):
    """ChangeThresholdCondition.

    All required parameters must be populated in order to send to Azure.

    :param change_percentage: Required. change percentage, value range : [0, +∞).
    :type change_percentage: float
    :param shift_point: Required. shift point, value range : [1, +∞).
    :type shift_point: int
    :param within_range: Required. if the withinRange = true, detected data is abnormal when the
     value falls in the range, in this case anomalyDetectorDirection must be Both
     if the withinRange = false, detected data is abnormal when the value falls out of the range.
    :type within_range: bool
    :param anomaly_detector_direction: Required. detection direction. Possible values include:
     "Both", "Down", "Up".
    :type anomaly_detector_direction: str or
     ~azure.ai.metricsadvisor.models.AnomalyDetectorDirection
    :param suppress_condition: Required.
    :type suppress_condition: ~azure.ai.metricsadvisor.models.SuppressCondition
    """

    _validation = {
        'change_percentage': {'required': True},
        'shift_point': {'required': True},
        'within_range': {'required': True},
        'anomaly_detector_direction': {'required': True},
        'suppress_condition': {'required': True},
    }

    _attribute_map = {
        'change_percentage': {'key': 'changePercentage', 'type': 'float'},
        'shift_point': {'key': 'shiftPoint', 'type': 'int'},
        'within_range': {'key': 'withinRange', 'type': 'bool'},
        'anomaly_detector_direction': {'key': 'anomalyDetectorDirection', 'type': 'str'},
        'suppress_condition': {'key': 'suppressCondition', 'type': 'SuppressCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ChangeThresholdCondition, self).__init__(**kwargs)
        self.change_percentage = kwargs['change_percentage']
        self.shift_point = kwargs['shift_point']
        self.within_range = kwargs['within_range']
        self.anomaly_detector_direction = kwargs['anomaly_detector_direction']
        self.suppress_condition = kwargs['suppress_condition']


class CommentFeedback(MetricFeedback):
    """CommentFeedback.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param feedback_type: Required. feedback type.Constant filled by server.  Possible values
     include: "Anomaly", "ChangePoint", "Period", "Comment".
    :type feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar feedback_id: feedback unique id.
    :vartype feedback_id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :param metric_id: Required. metric unique id.
    :type metric_id: str
    :param dimension_filter: Required.
    :type dimension_filter: ~azure.ai.metricsadvisor.models.FeedbackDimensionFilter
    :param start_time: the start timestamp of feedback timerange.
    :type start_time: ~datetime.datetime
    :param end_time: the end timestamp of feedback timerange, when equals to startTime means only
     one timestamp.
    :type end_time: ~datetime.datetime
    :param value: Required.
    :type value: ~azure.ai.metricsadvisor.models.CommentFeedbackValue
    """

    _validation = {
        'feedback_type': {'required': True},
        'feedback_id': {'readonly': True},
        'created_time': {'readonly': True},
        'user_principal': {'readonly': True},
        'metric_id': {'required': True},
        'dimension_filter': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'feedback_type': {'key': 'feedbackType', 'type': 'str'},
        'feedback_id': {'key': 'feedbackId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'user_principal': {'key': 'userPrincipal', 'type': 'str'},
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'dimension_filter': {'key': 'dimensionFilter', 'type': 'FeedbackDimensionFilter'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'CommentFeedbackValue'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CommentFeedback, self).__init__(**kwargs)
        self.feedback_type = 'Comment'  # type: str
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.value = kwargs['value']


class CommentFeedbackValue(msrest.serialization.Model):
    """CommentFeedbackValue.

    All required parameters must be populated in order to send to Azure.

    :param comment_value: Required. the comment string.
    :type comment_value: str
    """

    _validation = {
        'comment_value': {'required': True},
    }

    _attribute_map = {
        'comment_value': {'key': 'commentValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CommentFeedbackValue, self).__init__(**kwargs)
        self.comment_value = kwargs['comment_value']


class DataFeedIngestionProgress(msrest.serialization.Model):
    """DataFeedIngestionProgress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar latest_success_timestamp: the timestamp of lastest success ingestion job.
     null indicates not available.
    :vartype latest_success_timestamp: ~datetime.datetime
    :ivar latest_active_timestamp: the timestamp of lastest ingestion job with status update.
     null indicates not available.
    :vartype latest_active_timestamp: ~datetime.datetime
    """

    _validation = {
        'latest_success_timestamp': {'readonly': True},
        'latest_active_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'latest_success_timestamp': {'key': 'latestSuccessTimestamp', 'type': 'iso-8601'},
        'latest_active_timestamp': {'key': 'latestActiveTimestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFeedIngestionProgress, self).__init__(**kwargs)
        self.latest_success_timestamp = None
        self.latest_active_timestamp = None


class DataFeedList(msrest.serialization.Model):
    """DataFeedList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.DataFeedDetail]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataFeedDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFeedList, self).__init__(**kwargs)
        self.next_link = None
        self.value = None


class DetectionAnomalyFilterCondition(msrest.serialization.Model):
    """DetectionAnomalyFilterCondition.

    :param dimension_filter: dimension filter.
    :type dimension_filter: list[~azure.ai.metricsadvisor.models.DimensionGroupIdentity]
    :param severity_filter:
    :type severity_filter: ~azure.ai.metricsadvisor.models.SeverityFilterCondition
    """

    _validation = {
        'dimension_filter': {'unique': True},
    }

    _attribute_map = {
        'dimension_filter': {'key': 'dimensionFilter', 'type': '[DimensionGroupIdentity]'},
        'severity_filter': {'key': 'severityFilter', 'type': 'SeverityFilterCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectionAnomalyFilterCondition, self).__init__(**kwargs)
        self.dimension_filter = kwargs.get('dimension_filter', None)
        self.severity_filter = kwargs.get('severity_filter', None)


class DetectionAnomalyResultQuery(msrest.serialization.Model):
    """DetectionAnomalyResultQuery.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. start time.
    :type start_time: ~datetime.datetime
    :param end_time: Required. end time.
    :type end_time: ~datetime.datetime
    :param filter:
    :type filter: ~azure.ai.metricsadvisor.models.DetectionAnomalyFilterCondition
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'filter': {'key': 'filter', 'type': 'DetectionAnomalyFilterCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectionAnomalyResultQuery, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.filter = kwargs.get('filter', None)


class DetectionIncidentFilterCondition(msrest.serialization.Model):
    """DetectionIncidentFilterCondition.

    :param dimension_filter: dimension filter.
    :type dimension_filter: list[~azure.ai.metricsadvisor.models.DimensionGroupIdentity]
    """

    _validation = {
        'dimension_filter': {'unique': True},
    }

    _attribute_map = {
        'dimension_filter': {'key': 'dimensionFilter', 'type': '[DimensionGroupIdentity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectionIncidentFilterCondition, self).__init__(**kwargs)
        self.dimension_filter = kwargs.get('dimension_filter', None)


class DetectionIncidentResultQuery(msrest.serialization.Model):
    """DetectionIncidentResultQuery.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. start time.
    :type start_time: ~datetime.datetime
    :param end_time: Required. end time.
    :type end_time: ~datetime.datetime
    :param filter:
    :type filter: ~azure.ai.metricsadvisor.models.DetectionIncidentFilterCondition
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'filter': {'key': 'filter', 'type': 'DetectionIncidentFilterCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectionIncidentResultQuery, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.filter = kwargs.get('filter', None)


class DetectionSeriesQuery(msrest.serialization.Model):
    """DetectionSeriesQuery.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. start time.
    :type start_time: ~datetime.datetime
    :param end_time: Required. end time.
    :type end_time: ~datetime.datetime
    :param series: Required. series.
    :type series: list[~azure.ai.metricsadvisor.models.SeriesIdentity]
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
        'series': {'required': True, 'unique': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'series': {'key': 'series', 'type': '[SeriesIdentity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectionSeriesQuery, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.series = kwargs['series']


class Dimension(msrest.serialization.Model):
    """Dimension.

    All required parameters must be populated in order to send to Azure.

    :param dimension_name: Required. dimension name.
    :type dimension_name: str
    :param dimension_display_name: dimension display name.
    :type dimension_display_name: str
    """

    _validation = {
        'dimension_name': {'required': True},
        'dimension_display_name': {'pattern': r'[.a-zA-Z0-9_-]+'},
    }

    _attribute_map = {
        'dimension_name': {'key': 'dimensionName', 'type': 'str'},
        'dimension_display_name': {'key': 'dimensionDisplayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.dimension_name = kwargs['dimension_name']
        self.dimension_display_name = kwargs.get('dimension_display_name', None)


class DimensionGroupConfiguration(msrest.serialization.Model):
    """DimensionGroupConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param group: Required.
    :type group: ~azure.ai.metricsadvisor.models.DimensionGroupIdentity
    :param condition_operator: condition operator
    
     should be specified when combining multiple detection conditions. Possible values include:
     "AND", "OR".
    :type condition_operator: str or
     ~azure.ai.metricsadvisor.models.DimensionGroupConfigurationConditionOperator
    :param smart_detection_condition:
    :type smart_detection_condition: ~azure.ai.metricsadvisor.models.SmartDetectionCondition
    :param hard_threshold_condition:
    :type hard_threshold_condition: ~azure.ai.metricsadvisor.models.HardThresholdCondition
    :param change_threshold_condition:
    :type change_threshold_condition: ~azure.ai.metricsadvisor.models.ChangeThresholdCondition
    """

    _validation = {
        'group': {'required': True},
    }

    _attribute_map = {
        'group': {'key': 'group', 'type': 'DimensionGroupIdentity'},
        'condition_operator': {'key': 'conditionOperator', 'type': 'str'},
        'smart_detection_condition': {'key': 'smartDetectionCondition', 'type': 'SmartDetectionCondition'},
        'hard_threshold_condition': {'key': 'hardThresholdCondition', 'type': 'HardThresholdCondition'},
        'change_threshold_condition': {'key': 'changeThresholdCondition', 'type': 'ChangeThresholdCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DimensionGroupConfiguration, self).__init__(**kwargs)
        self.group = kwargs['group']
        self.condition_operator = kwargs.get('condition_operator', None)
        self.smart_detection_condition = kwargs.get('smart_detection_condition', None)
        self.hard_threshold_condition = kwargs.get('hard_threshold_condition', None)
        self.change_threshold_condition = kwargs.get('change_threshold_condition', None)


class DimensionGroupIdentity(msrest.serialization.Model):
    """DimensionGroupIdentity.

    All required parameters must be populated in order to send to Azure.

    :param dimension: Required. dimension specified for series group.
    :type dimension: dict[str, str]
    """

    _validation = {
        'dimension': {'required': True},
    }

    _attribute_map = {
        'dimension': {'key': 'dimension', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DimensionGroupIdentity, self).__init__(**kwargs)
        self.dimension = kwargs['dimension']


class ElasticsearchDataFeed(DataFeedDetail):
    """ElasticsearchDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.ElasticsearchParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'ElasticsearchParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ElasticsearchDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'Elasticsearch'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class ElasticsearchDataFeedPatch(DataFeedDetailPatch):
    """ElasticsearchDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.ElasticsearchParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'ElasticsearchParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ElasticsearchDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'Elasticsearch'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class ElasticsearchParameter(msrest.serialization.Model):
    """ElasticsearchParameter.

    All required parameters must be populated in order to send to Azure.

    :param host: Required. Host.
    :type host: str
    :param port: Required. Port.
    :type port: str
    :param auth_header: Required. Authorization header.
    :type auth_header: str
    :param query: Required. Query.
    :type query: str
    """

    _validation = {
        'host': {'required': True},
        'port': {'required': True},
        'auth_header': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'host': {'key': 'host', 'type': 'str'},
        'port': {'key': 'port', 'type': 'str'},
        'auth_header': {'key': 'authHeader', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ElasticsearchParameter, self).__init__(**kwargs)
        self.host = kwargs['host']
        self.port = kwargs['port']
        self.auth_header = kwargs['auth_header']
        self.query = kwargs['query']


class HookInfo(msrest.serialization.Model):
    """HookInfo.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EmailHookInfo, WebhookHookInfo.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param hook_type: Required. hook type.Constant filled by server.  Possible values include:
     "Webhook", "Email".
    :type hook_type: str or ~azure.ai.metricsadvisor.models.HookType
    :ivar hook_id: Hook unique id.
    :vartype hook_id: str
    :param hook_name: Required. hook unique name.
    :type hook_name: str
    :param description: hook description.
    :type description: str
    :param external_link: hook external link.
    :type external_link: str
    :ivar admins: hook administrators.
    :vartype admins: list[str]
    """

    _validation = {
        'hook_type': {'required': True},
        'hook_id': {'readonly': True},
        'hook_name': {'required': True},
        'admins': {'readonly': True, 'unique': True},
    }

    _attribute_map = {
        'hook_type': {'key': 'hookType', 'type': 'str'},
        'hook_id': {'key': 'hookId', 'type': 'str'},
        'hook_name': {'key': 'hookName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'external_link': {'key': 'externalLink', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
    }

    _subtype_map = {
        'hook_type': {'Email': 'EmailHookInfo', 'Webhook': 'WebhookHookInfo'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HookInfo, self).__init__(**kwargs)
        self.hook_type = None  # type: Optional[str]
        self.hook_id = None
        self.hook_name = kwargs['hook_name']
        self.description = kwargs.get('description', None)
        self.external_link = kwargs.get('external_link', None)
        self.admins = None


class EmailHookInfo(HookInfo):
    """EmailHookInfo.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param hook_type: Required. hook type.Constant filled by server.  Possible values include:
     "Webhook", "Email".
    :type hook_type: str or ~azure.ai.metricsadvisor.models.HookType
    :ivar hook_id: Hook unique id.
    :vartype hook_id: str
    :param hook_name: Required. hook unique name.
    :type hook_name: str
    :param description: hook description.
    :type description: str
    :param external_link: hook external link.
    :type external_link: str
    :ivar admins: hook administrators.
    :vartype admins: list[str]
    :param hook_parameter: Required.
    :type hook_parameter: ~azure.ai.metricsadvisor.models.EmailHookParameter
    """

    _validation = {
        'hook_type': {'required': True},
        'hook_id': {'readonly': True},
        'hook_name': {'required': True},
        'admins': {'readonly': True, 'unique': True},
        'hook_parameter': {'required': True},
    }

    _attribute_map = {
        'hook_type': {'key': 'hookType', 'type': 'str'},
        'hook_id': {'key': 'hookId', 'type': 'str'},
        'hook_name': {'key': 'hookName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'external_link': {'key': 'externalLink', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'hook_parameter': {'key': 'hookParameter', 'type': 'EmailHookParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailHookInfo, self).__init__(**kwargs)
        self.hook_type = 'Email'  # type: str
        self.hook_parameter = kwargs['hook_parameter']


class HookInfoPatch(msrest.serialization.Model):
    """HookInfoPatch.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EmailHookInfoPatch, WebhookHookInfoPatch.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param hook_type: Required. hook type.Constant filled by server.  Possible values include:
     "Webhook", "Email".
    :type hook_type: str or ~azure.ai.metricsadvisor.models.HookInfoPatchHookType
    :param hook_name: hook unique name.
    :type hook_name: str
    :param description: hook description.
    :type description: str
    :param external_link: hook external link.
    :type external_link: str
    :ivar admins: hook administrators.
    :vartype admins: list[str]
    """

    _validation = {
        'hook_type': {'required': True},
        'admins': {'readonly': True, 'unique': True},
    }

    _attribute_map = {
        'hook_type': {'key': 'hookType', 'type': 'str'},
        'hook_name': {'key': 'hookName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'external_link': {'key': 'externalLink', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
    }

    _subtype_map = {
        'hook_type': {'Email': 'EmailHookInfoPatch', 'Webhook': 'WebhookHookInfoPatch'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HookInfoPatch, self).__init__(**kwargs)
        self.hook_type = None  # type: Optional[str]
        self.hook_name = kwargs.get('hook_name', None)
        self.description = kwargs.get('description', None)
        self.external_link = kwargs.get('external_link', None)
        self.admins = None


class EmailHookInfoPatch(HookInfoPatch):
    """EmailHookInfoPatch.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param hook_type: Required. hook type.Constant filled by server.  Possible values include:
     "Webhook", "Email".
    :type hook_type: str or ~azure.ai.metricsadvisor.models.HookInfoPatchHookType
    :param hook_name: hook unique name.
    :type hook_name: str
    :param description: hook description.
    :type description: str
    :param external_link: hook external link.
    :type external_link: str
    :ivar admins: hook administrators.
    :vartype admins: list[str]
    :param hook_parameter:
    :type hook_parameter: ~azure.ai.metricsadvisor.models.EmailHookParameter
    """

    _validation = {
        'hook_type': {'required': True},
        'admins': {'readonly': True, 'unique': True},
    }

    _attribute_map = {
        'hook_type': {'key': 'hookType', 'type': 'str'},
        'hook_name': {'key': 'hookName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'external_link': {'key': 'externalLink', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'hook_parameter': {'key': 'hookParameter', 'type': 'EmailHookParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailHookInfoPatch, self).__init__(**kwargs)
        self.hook_type = 'Email'  # type: str
        self.hook_parameter = kwargs.get('hook_parameter', None)


class EmailHookParameter(msrest.serialization.Model):
    """EmailHookParameter.

    All required parameters must be populated in order to send to Azure.

    :param to_list: Required. Email TO: list.
    :type to_list: list[str]
    """

    _validation = {
        'to_list': {'required': True, 'unique': True},
    }

    _attribute_map = {
        'to_list': {'key': 'toList', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailHookParameter, self).__init__(**kwargs)
        self.to_list = kwargs['to_list']


class EnrichmentStatus(msrest.serialization.Model):
    """EnrichmentStatus.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: data slice timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar status: latest enrichment status for this data slice.
    :vartype status: str
    :ivar message: the trimmed message describes details of the enrichment status.
    :vartype message: str
    """

    _validation = {
        'timestamp': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnrichmentStatus, self).__init__(**kwargs)
        self.timestamp = None
        self.status = None
        self.message = None


class EnrichmentStatusList(msrest.serialization.Model):
    """EnrichmentStatusList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.EnrichmentStatus]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EnrichmentStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnrichmentStatusList, self).__init__(**kwargs)
        self.next_link = None
        self.value = None


class EnrichmentStatusQueryOption(msrest.serialization.Model):
    """EnrichmentStatusQueryOption.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. the start point of time range to query anomaly detection status.
    :type start_time: ~datetime.datetime
    :param end_time: Required. the end point of time range to query anomaly detection status.
    :type end_time: ~datetime.datetime
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnrichmentStatusQueryOption, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']


class ErrorCode(msrest.serialization.Model):
    """ErrorCode.

    :param message:
    :type message: str
    :param code:
    :type code: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorCode, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.code = kwargs.get('code', None)


class FeedbackDimensionFilter(msrest.serialization.Model):
    """FeedbackDimensionFilter.

    All required parameters must be populated in order to send to Azure.

    :param dimension: Required. metric dimension filter.
    :type dimension: dict[str, str]
    """

    _validation = {
        'dimension': {'required': True},
    }

    _attribute_map = {
        'dimension': {'key': 'dimension', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FeedbackDimensionFilter, self).__init__(**kwargs)
        self.dimension = kwargs['dimension']


class HardThresholdCondition(msrest.serialization.Model):
    """HardThresholdCondition.

    All required parameters must be populated in order to send to Azure.

    :param lower_bound: lower bound
    
     should be specified when anomalyDetectorDirection is Both or Down.
    :type lower_bound: float
    :param upper_bound: upper bound
    
     should be specified when anomalyDetectorDirection is Both or Up.
    :type upper_bound: float
    :param anomaly_detector_direction: Required. detection direction. Possible values include:
     "Both", "Down", "Up".
    :type anomaly_detector_direction: str or
     ~azure.ai.metricsadvisor.models.AnomalyDetectorDirection
    :param suppress_condition: Required.
    :type suppress_condition: ~azure.ai.metricsadvisor.models.SuppressCondition
    """

    _validation = {
        'anomaly_detector_direction': {'required': True},
        'suppress_condition': {'required': True},
    }

    _attribute_map = {
        'lower_bound': {'key': 'lowerBound', 'type': 'float'},
        'upper_bound': {'key': 'upperBound', 'type': 'float'},
        'anomaly_detector_direction': {'key': 'anomalyDetectorDirection', 'type': 'str'},
        'suppress_condition': {'key': 'suppressCondition', 'type': 'SuppressCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardThresholdCondition, self).__init__(**kwargs)
        self.lower_bound = kwargs.get('lower_bound', None)
        self.upper_bound = kwargs.get('upper_bound', None)
        self.anomaly_detector_direction = kwargs['anomaly_detector_direction']
        self.suppress_condition = kwargs['suppress_condition']


class HookList(msrest.serialization.Model):
    """HookList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.HookInfo]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'readonly': True, 'unique': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[HookInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HookList, self).__init__(**kwargs)
        self.next_link = None
        self.value = None


class HttpRequestDataFeed(DataFeedDetail):
    """HttpRequestDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.HttpRequestParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'HttpRequestParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpRequestDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'HttpRequest'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class HttpRequestDataFeedPatch(DataFeedDetailPatch):
    """HttpRequestDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.HttpRequestParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'HttpRequestParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpRequestDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'HttpRequest'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class HttpRequestParameter(msrest.serialization.Model):
    """HttpRequestParameter.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. HTTP URL.
    :type url: str
    :param http_header: Required. HTTP header.
    :type http_header: str
    :param http_method: Required. HTTP method.
    :type http_method: str
    :param payload: Required. HTTP reuqest body.
    :type payload: str
    """

    _validation = {
        'url': {'required': True},
        'http_header': {'required': True},
        'http_method': {'required': True},
        'payload': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'http_header': {'key': 'httpHeader', 'type': 'str'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
        'payload': {'key': 'payload', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpRequestParameter, self).__init__(**kwargs)
        self.url = kwargs['url']
        self.http_header = kwargs['http_header']
        self.http_method = kwargs['http_method']
        self.payload = kwargs['payload']


class IncidentProperty(msrest.serialization.Model):
    """IncidentProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param max_severity: Required. max severity of latest anomalies in the incident. Possible
     values include: "Low", "Medium", "High".
    :type max_severity: str or ~azure.ai.metricsadvisor.models.Severity
    :ivar incident_status: incident status
    
     only return for alerting incident result. Possible values include: "Active", "Resolved".
    :vartype incident_status: str or ~azure.ai.metricsadvisor.models.IncidentPropertyIncidentStatus
    """

    _validation = {
        'max_severity': {'required': True},
        'incident_status': {'readonly': True},
    }

    _attribute_map = {
        'max_severity': {'key': 'maxSeverity', 'type': 'str'},
        'incident_status': {'key': 'incidentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IncidentProperty, self).__init__(**kwargs)
        self.max_severity = kwargs['max_severity']
        self.incident_status = None


class IncidentResult(msrest.serialization.Model):
    """IncidentResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar metric_id: metric unique id
    
     only return for alerting incident result.
    :vartype metric_id: str
    :ivar anomaly_detection_configuration_id: anomaly detection configuration unique id
    
     only return for alerting incident result.
    :vartype anomaly_detection_configuration_id: str
    :param incident_id: Required. incident id.
    :type incident_id: str
    :param start_time: Required. incident start time.
    :type start_time: ~datetime.datetime
    :param last_time: Required. incident last time.
    :type last_time: ~datetime.datetime
    :param root_node: Required.
    :type root_node: ~azure.ai.metricsadvisor.models.SeriesIdentity
    :param property: Required.
    :type property: ~azure.ai.metricsadvisor.models.IncidentProperty
    """

    _validation = {
        'metric_id': {'readonly': True},
        'anomaly_detection_configuration_id': {'readonly': True},
        'incident_id': {'required': True},
        'start_time': {'required': True},
        'last_time': {'required': True},
        'root_node': {'required': True},
        'property': {'required': True},
    }

    _attribute_map = {
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'anomaly_detection_configuration_id': {'key': 'anomalyDetectionConfigurationId', 'type': 'str'},
        'incident_id': {'key': 'incidentId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_time': {'key': 'lastTime', 'type': 'iso-8601'},
        'root_node': {'key': 'rootNode', 'type': 'SeriesIdentity'},
        'property': {'key': 'property', 'type': 'IncidentProperty'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IncidentResult, self).__init__(**kwargs)
        self.metric_id = None
        self.anomaly_detection_configuration_id = None
        self.incident_id = kwargs['incident_id']
        self.start_time = kwargs['start_time']
        self.last_time = kwargs['last_time']
        self.root_node = kwargs['root_node']
        self.property = kwargs['property']


class IncidentResultList(msrest.serialization.Model):
    """IncidentResultList.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Required.
    :type next_link: str
    :param value: Required.
    :type value: list[~azure.ai.metricsadvisor.models.IncidentResult]
    """

    _validation = {
        'next_link': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[IncidentResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IncidentResultList, self).__init__(**kwargs)
        self.next_link = kwargs['next_link']
        self.value = kwargs['value']


class InfluxDBDataFeed(DataFeedDetail):
    """InfluxDBDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.InfluxDBParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'InfluxDBParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InfluxDBDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'InfluxDB'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class InfluxDBDataFeedPatch(DataFeedDetailPatch):
    """InfluxDBDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.InfluxDBParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'InfluxDBParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InfluxDBDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'InfluxDB'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class InfluxDBParameter(msrest.serialization.Model):
    """InfluxDBParameter.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. InfluxDB connection string.
    :type connection_string: str
    :param database: Required. Database name.
    :type database: str
    :param user_name: Required. Database access user.
    :type user_name: str
    :param password: Required. Database access password.
    :type password: str
    :param query: Required. Query script.
    :type query: str
    """

    _validation = {
        'connection_string': {'required': True},
        'database': {'required': True},
        'user_name': {'required': True},
        'password': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'database': {'key': 'database', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InfluxDBParameter, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.database = kwargs['database']
        self.user_name = kwargs['user_name']
        self.password = kwargs['password']
        self.query = kwargs['query']


class IngestionProgressResetOptions(msrest.serialization.Model):
    """IngestionProgressResetOptions.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. the start point of time range to reset data ingestion status.
    :type start_time: ~datetime.datetime
    :param end_time: Required. the end point of time range to reset data ingestion status.
    :type end_time: ~datetime.datetime
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IngestionProgressResetOptions, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']


class IngestionStatus(msrest.serialization.Model):
    """IngestionStatus.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: data slice timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar status: latest ingestion task status for this data slice. Possible values include:
     "NotStarted", "Scheduled", "Running", "Succeeded", "Failed", "NoData", "Error", "Paused".
    :vartype status: str or ~azure.ai.metricsadvisor.models.IngestionStatusType
    :ivar message: the trimmed message of last ingestion job.
    :vartype message: str
    """

    _validation = {
        'timestamp': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IngestionStatus, self).__init__(**kwargs)
        self.timestamp = None
        self.status = None
        self.message = None


class IngestionStatusList(msrest.serialization.Model):
    """IngestionStatusList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.IngestionStatus]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[IngestionStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IngestionStatusList, self).__init__(**kwargs)
        self.next_link = None
        self.value = None


class IngestionStatusQueryOptions(msrest.serialization.Model):
    """IngestionStatusQueryOptions.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. the start point of time range to query data ingestion status.
    :type start_time: ~datetime.datetime
    :param end_time: Required. the end point of time range to query data ingestion status.
    :type end_time: ~datetime.datetime
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IngestionStatusQueryOptions, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']


class Metric(msrest.serialization.Model):
    """Metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar metric_id: metric id.
    :vartype metric_id: str
    :param metric_name: Required. metric name.
    :type metric_name: str
    :param metric_display_name: metric display name.
    :type metric_display_name: str
    :param metric_description: metric description.
    :type metric_description: str
    """

    _validation = {
        'metric_id': {'readonly': True},
        'metric_name': {'required': True},
        'metric_display_name': {'pattern': r'[.a-zA-Z0-9_-]+'},
    }

    _attribute_map = {
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_display_name': {'key': 'metricDisplayName', 'type': 'str'},
        'metric_description': {'key': 'metricDescription', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Metric, self).__init__(**kwargs)
        self.metric_id = None
        self.metric_name = kwargs['metric_name']
        self.metric_display_name = kwargs.get('metric_display_name', None)
        self.metric_description = kwargs.get('metric_description', None)


class MetricAlertingConfiguration(msrest.serialization.Model):
    """MetricAlertingConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param anomaly_detection_configuration_id: Required. Anomaly detection configuration unique id.
    :type anomaly_detection_configuration_id: str
    :param anomaly_scope_type: Required. Anomaly scope. Possible values include: "All",
     "Dimension", "TopN".
    :type anomaly_scope_type: str or ~azure.ai.metricsadvisor.models.AnomalyScope
    :param negation_operation: Negation operation.
    :type negation_operation: bool
    :param dimension_anomaly_scope:
    :type dimension_anomaly_scope: ~azure.ai.metricsadvisor.models.DimensionGroupIdentity
    :param top_n_anomaly_scope:
    :type top_n_anomaly_scope: ~azure.ai.metricsadvisor.models.TopNGroupScope
    :param severity_filter:
    :type severity_filter: ~azure.ai.metricsadvisor.models.SeverityCondition
    :param snooze_filter:
    :type snooze_filter: ~azure.ai.metricsadvisor.models.AlertSnoozeCondition
    :param value_filter:
    :type value_filter: ~azure.ai.metricsadvisor.models.ValueCondition
    """

    _validation = {
        'anomaly_detection_configuration_id': {'required': True},
        'anomaly_scope_type': {'required': True},
    }

    _attribute_map = {
        'anomaly_detection_configuration_id': {'key': 'anomalyDetectionConfigurationId', 'type': 'str'},
        'anomaly_scope_type': {'key': 'anomalyScopeType', 'type': 'str'},
        'negation_operation': {'key': 'negationOperation', 'type': 'bool'},
        'dimension_anomaly_scope': {'key': 'dimensionAnomalyScope', 'type': 'DimensionGroupIdentity'},
        'top_n_anomaly_scope': {'key': 'topNAnomalyScope', 'type': 'TopNGroupScope'},
        'severity_filter': {'key': 'severityFilter', 'type': 'SeverityCondition'},
        'snooze_filter': {'key': 'snoozeFilter', 'type': 'AlertSnoozeCondition'},
        'value_filter': {'key': 'valueFilter', 'type': 'ValueCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAlertingConfiguration, self).__init__(**kwargs)
        self.anomaly_detection_configuration_id = kwargs['anomaly_detection_configuration_id']
        self.anomaly_scope_type = kwargs['anomaly_scope_type']
        self.negation_operation = kwargs.get('negation_operation', None)
        self.dimension_anomaly_scope = kwargs.get('dimension_anomaly_scope', None)
        self.top_n_anomaly_scope = kwargs.get('top_n_anomaly_scope', None)
        self.severity_filter = kwargs.get('severity_filter', None)
        self.snooze_filter = kwargs.get('snooze_filter', None)
        self.value_filter = kwargs.get('value_filter', None)


class MetricDataItem(msrest.serialization.Model):
    """MetricDataItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id:
    :type id: ~azure.ai.metricsadvisor.models.MetricSeriesItem
    :ivar timestamp_list: timestamps of the data related to this time series.
    :vartype timestamp_list: list[~datetime.datetime]
    :ivar value_list: values of the data related to this time series.
    :vartype value_list: list[float]
    """

    _validation = {
        'timestamp_list': {'readonly': True},
        'value_list': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'MetricSeriesItem'},
        'timestamp_list': {'key': 'timestampList', 'type': '[iso-8601]'},
        'value_list': {'key': 'valueList', 'type': '[float]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDataItem, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.timestamp_list = None
        self.value_list = None


class MetricDataList(msrest.serialization.Model):
    """MetricDataList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.MetricDataItem]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricDataItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDataList, self).__init__(**kwargs)
        self.value = None


class MetricDataQueryOptions(msrest.serialization.Model):
    """MetricDataQueryOptions.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. start time of query a time series data, and format should be yyyy-
     MM-ddThh:mm:ssZ.
    :type start_time: ~datetime.datetime
    :param end_time: Required. start time of query a time series data, and format should be yyyy-
     MM-ddThh:mm:ssZ.
    :type end_time: ~datetime.datetime
    :param series: Required. query specific series.
    :type series: list[dict[str, str]]
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
        'series': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'series': {'key': 'series', 'type': '[{str}]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDataQueryOptions, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.series = kwargs['series']


class MetricDimensionList(msrest.serialization.Model):
    """MetricDimensionList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[str]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'readonly': True, 'unique': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDimensionList, self).__init__(**kwargs)
        self.next_link = None
        self.value = None


class MetricDimensionQueryOptions(msrest.serialization.Model):
    """MetricDimensionQueryOptions.

    All required parameters must be populated in order to send to Azure.

    :param dimension_name: Required. dimension name.
    :type dimension_name: str
    :param dimension_value_filter: dimension value to be filtered.
    :type dimension_value_filter: str
    """

    _validation = {
        'dimension_name': {'required': True},
    }

    _attribute_map = {
        'dimension_name': {'key': 'dimensionName', 'type': 'str'},
        'dimension_value_filter': {'key': 'dimensionValueFilter', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDimensionQueryOptions, self).__init__(**kwargs)
        self.dimension_name = kwargs['dimension_name']
        self.dimension_value_filter = kwargs.get('dimension_value_filter', None)


class MetricFeedbackFilter(msrest.serialization.Model):
    """MetricFeedbackFilter.

    All required parameters must be populated in order to send to Azure.

    :param metric_id: Required. filter feedbacks by metric id.
    :type metric_id: str
    :param dimension_filter:
    :type dimension_filter: ~azure.ai.metricsadvisor.models.FeedbackDimensionFilter
    :param feedback_type: filter feedbacks by type. Possible values include: "Anomaly",
     "ChangePoint", "Period", "Comment".
    :type feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :param start_time: start time filter under chosen time mode.
    :type start_time: ~datetime.datetime
    :param end_time: end time filter under chosen time mode.
    :type end_time: ~datetime.datetime
    :param time_mode: time mode to filter feedback. Possible values include: "MetricTimestamp",
     "FeedbackCreatedTime".
    :type time_mode: str or ~azure.ai.metricsadvisor.models.FeedbackQueryTimeMode
    """

    _validation = {
        'metric_id': {'required': True},
    }

    _attribute_map = {
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'dimension_filter': {'key': 'dimensionFilter', 'type': 'FeedbackDimensionFilter'},
        'feedback_type': {'key': 'feedbackType', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_mode': {'key': 'timeMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricFeedbackFilter, self).__init__(**kwargs)
        self.metric_id = kwargs['metric_id']
        self.dimension_filter = kwargs.get('dimension_filter', None)
        self.feedback_type = kwargs.get('feedback_type', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.time_mode = kwargs.get('time_mode', None)


class MetricFeedbackList(msrest.serialization.Model):
    """MetricFeedbackList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.MetricFeedback]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[MetricFeedback]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricFeedbackList, self).__init__(**kwargs)
        self.next_link = None
        self.value = None


class MetricSeriesItem(msrest.serialization.Model):
    """MetricSeriesItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metric_id: metric unique id.
    :vartype metric_id: str
    :ivar dimension: dimension name and value pair.
    :vartype dimension: dict[str, str]
    """

    _validation = {
        'metric_id': {'readonly': True},
        'dimension': {'readonly': True},
    }

    _attribute_map = {
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'dimension': {'key': 'dimension', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSeriesItem, self).__init__(**kwargs)
        self.metric_id = None
        self.dimension = None


class MetricSeriesList(msrest.serialization.Model):
    """MetricSeriesList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.MetricSeriesItem]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[MetricSeriesItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSeriesList, self).__init__(**kwargs)
        self.next_link = None
        self.value = None


class MetricSeriesQueryOptions(msrest.serialization.Model):
    """MetricSeriesQueryOptions.

    All required parameters must be populated in order to send to Azure.

    :param active_since: Required. query series ingested after this time, the format should be
     yyyy-MM-ddTHH:mm:ssZ.
    :type active_since: ~datetime.datetime
    :param dimension_filter: filter specfic dimension name and values.
    :type dimension_filter: dict[str, list[str]]
    """

    _validation = {
        'active_since': {'required': True},
    }

    _attribute_map = {
        'active_since': {'key': 'activeSince', 'type': 'iso-8601'},
        'dimension_filter': {'key': 'dimensionFilter', 'type': '{[str]}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSeriesQueryOptions, self).__init__(**kwargs)
        self.active_since = kwargs['active_since']
        self.dimension_filter = kwargs.get('dimension_filter', None)


class MongoDBDataFeed(DataFeedDetail):
    """MongoDBDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.MongoDBParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'MongoDBParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDBDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'MongoDB'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class MongoDBDataFeedPatch(DataFeedDetailPatch):
    """MongoDBDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.MongoDBParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'MongoDBParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDBDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'MongoDB'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class MongoDBParameter(msrest.serialization.Model):
    """MongoDBParameter.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. MongoDB connection string.
    :type connection_string: str
    :param database: Required. Database name.
    :type database: str
    :param command: Required. Query script.
    :type command: str
    """

    _validation = {
        'connection_string': {'required': True},
        'database': {'required': True},
        'command': {'required': True},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'database': {'key': 'database', 'type': 'str'},
        'command': {'key': 'command', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDBParameter, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.database = kwargs['database']
        self.command = kwargs['command']


class MySqlDataFeed(DataFeedDetail):
    """MySqlDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.SqlSourceParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'SqlSourceParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MySqlDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'MySql'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class MySqlDataFeedPatch(DataFeedDetailPatch):
    """MySqlDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.SqlSourceParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'SqlSourceParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MySqlDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'MySql'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class PeriodFeedback(MetricFeedback):
    """PeriodFeedback.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param feedback_type: Required. feedback type.Constant filled by server.  Possible values
     include: "Anomaly", "ChangePoint", "Period", "Comment".
    :type feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar feedback_id: feedback unique id.
    :vartype feedback_id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :param metric_id: Required. metric unique id.
    :type metric_id: str
    :param dimension_filter: Required.
    :type dimension_filter: ~azure.ai.metricsadvisor.models.FeedbackDimensionFilter
    :param value: Required.
    :type value: ~azure.ai.metricsadvisor.models.PeriodFeedbackValue
    """

    _validation = {
        'feedback_type': {'required': True},
        'feedback_id': {'readonly': True},
        'created_time': {'readonly': True},
        'user_principal': {'readonly': True},
        'metric_id': {'required': True},
        'dimension_filter': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'feedback_type': {'key': 'feedbackType', 'type': 'str'},
        'feedback_id': {'key': 'feedbackId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'user_principal': {'key': 'userPrincipal', 'type': 'str'},
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'dimension_filter': {'key': 'dimensionFilter', 'type': 'FeedbackDimensionFilter'},
        'value': {'key': 'value', 'type': 'PeriodFeedbackValue'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeriodFeedback, self).__init__(**kwargs)
        self.feedback_type = 'Period'  # type: str
        self.value = kwargs['value']


class PeriodFeedbackValue(msrest.serialization.Model):
    """PeriodFeedbackValue.

    All required parameters must be populated in order to send to Azure.

    :param period_type: Required. the type of setting period. Possible values include:
     "AutoDetect", "AssignValue".
    :type period_type: str or ~azure.ai.metricsadvisor.models.PeriodType
    :param period_value: Required. the number of intervals a period contains, when no period set to
     0.
    :type period_value: int
    """

    _validation = {
        'period_type': {'required': True},
        'period_value': {'required': True},
    }

    _attribute_map = {
        'period_type': {'key': 'periodType', 'type': 'str'},
        'period_value': {'key': 'periodValue', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeriodFeedbackValue, self).__init__(**kwargs)
        self.period_type = kwargs['period_type']
        self.period_value = kwargs['period_value']


class PostgreSqlDataFeed(DataFeedDetail):
    """PostgreSqlDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.SqlSourceParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'SqlSourceParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PostgreSqlDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'PostgreSql'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class PostgreSqlDataFeedPatch(DataFeedDetailPatch):
    """PostgreSqlDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.SqlSourceParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'SqlSourceParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PostgreSqlDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'PostgreSql'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class RootCause(msrest.serialization.Model):
    """RootCause.

    All required parameters must be populated in order to send to Azure.

    :param root_cause: Required.
    :type root_cause: ~azure.ai.metricsadvisor.models.DimensionGroupIdentity
    :param path: Required. drilling down path from query anomaly to root cause.
    :type path: list[str]
    :param score: Required. score.
    :type score: float
    :param description: Required. description.
    :type description: str
    """

    _validation = {
        'root_cause': {'required': True},
        'path': {'required': True},
        'score': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'root_cause': {'key': 'rootCause', 'type': 'DimensionGroupIdentity'},
        'path': {'key': 'path', 'type': '[str]'},
        'score': {'key': 'score', 'type': 'float'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RootCause, self).__init__(**kwargs)
        self.root_cause = kwargs['root_cause']
        self.path = kwargs['path']
        self.score = kwargs['score']
        self.description = kwargs['description']


class RootCauseList(msrest.serialization.Model):
    """RootCauseList.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.ai.metricsadvisor.models.RootCause]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RootCause]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RootCauseList, self).__init__(**kwargs)
        self.value = kwargs['value']


class SeriesConfiguration(msrest.serialization.Model):
    """SeriesConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param series: Required.
    :type series: ~azure.ai.metricsadvisor.models.SeriesIdentity
    :param condition_operator: condition operator
    
     should be specified when combining multiple detection conditions. Possible values include:
     "AND", "OR".
    :type condition_operator: str or
     ~azure.ai.metricsadvisor.models.SeriesConfigurationConditionOperator
    :param smart_detection_condition:
    :type smart_detection_condition: ~azure.ai.metricsadvisor.models.SmartDetectionCondition
    :param hard_threshold_condition:
    :type hard_threshold_condition: ~azure.ai.metricsadvisor.models.HardThresholdCondition
    :param change_threshold_condition:
    :type change_threshold_condition: ~azure.ai.metricsadvisor.models.ChangeThresholdCondition
    """

    _validation = {
        'series': {'required': True},
    }

    _attribute_map = {
        'series': {'key': 'series', 'type': 'SeriesIdentity'},
        'condition_operator': {'key': 'conditionOperator', 'type': 'str'},
        'smart_detection_condition': {'key': 'smartDetectionCondition', 'type': 'SmartDetectionCondition'},
        'hard_threshold_condition': {'key': 'hardThresholdCondition', 'type': 'HardThresholdCondition'},
        'change_threshold_condition': {'key': 'changeThresholdCondition', 'type': 'ChangeThresholdCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SeriesConfiguration, self).__init__(**kwargs)
        self.series = kwargs['series']
        self.condition_operator = kwargs.get('condition_operator', None)
        self.smart_detection_condition = kwargs.get('smart_detection_condition', None)
        self.hard_threshold_condition = kwargs.get('hard_threshold_condition', None)
        self.change_threshold_condition = kwargs.get('change_threshold_condition', None)


class SeriesIdentity(msrest.serialization.Model):
    """SeriesIdentity.

    All required parameters must be populated in order to send to Azure.

    :param dimension: Required. dimension specified for series.
    :type dimension: dict[str, str]
    """

    _validation = {
        'dimension': {'required': True},
    }

    _attribute_map = {
        'dimension': {'key': 'dimension', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SeriesIdentity, self).__init__(**kwargs)
        self.dimension = kwargs['dimension']


class SeriesResult(msrest.serialization.Model):
    """SeriesResult.

    All required parameters must be populated in order to send to Azure.

    :param series: Required.
    :type series: ~azure.ai.metricsadvisor.models.SeriesIdentity
    :param timestamp_list: Required. timestamps of the series.
    :type timestamp_list: list[~datetime.datetime]
    :param value_list: Required. values of the series.
    :type value_list: list[float]
    :param is_anomaly_list: Required. whether points of the series are anomalies.
    :type is_anomaly_list: list[bool]
    :param period_list: Required. period calculated on each point of the series.
    :type period_list: list[int]
    :param expected_value_list: Required. expected values of the series given by smart detector.
    :type expected_value_list: list[float]
    :param lower_boundary_list: Required. lower boundary list of the series given by smart
     detector.
    :type lower_boundary_list: list[float]
    :param upper_boundary_list: Required. upper boundary list of the series given by smart
     detector.
    :type upper_boundary_list: list[float]
    """

    _validation = {
        'series': {'required': True},
        'timestamp_list': {'required': True},
        'value_list': {'required': True},
        'is_anomaly_list': {'required': True},
        'period_list': {'required': True},
        'expected_value_list': {'required': True},
        'lower_boundary_list': {'required': True},
        'upper_boundary_list': {'required': True},
    }

    _attribute_map = {
        'series': {'key': 'series', 'type': 'SeriesIdentity'},
        'timestamp_list': {'key': 'timestampList', 'type': '[iso-8601]'},
        'value_list': {'key': 'valueList', 'type': '[float]'},
        'is_anomaly_list': {'key': 'isAnomalyList', 'type': '[bool]'},
        'period_list': {'key': 'periodList', 'type': '[int]'},
        'expected_value_list': {'key': 'expectedValueList', 'type': '[float]'},
        'lower_boundary_list': {'key': 'lowerBoundaryList', 'type': '[float]'},
        'upper_boundary_list': {'key': 'upperBoundaryList', 'type': '[float]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SeriesResult, self).__init__(**kwargs)
        self.series = kwargs['series']
        self.timestamp_list = kwargs['timestamp_list']
        self.value_list = kwargs['value_list']
        self.is_anomaly_list = kwargs['is_anomaly_list']
        self.period_list = kwargs['period_list']
        self.expected_value_list = kwargs['expected_value_list']
        self.lower_boundary_list = kwargs['lower_boundary_list']
        self.upper_boundary_list = kwargs['upper_boundary_list']


class SeriesResultList(msrest.serialization.Model):
    """SeriesResultList.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.ai.metricsadvisor.models.SeriesResult]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SeriesResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SeriesResultList, self).__init__(**kwargs)
        self.value = kwargs['value']


class SeverityCondition(msrest.serialization.Model):
    """SeverityCondition.

    All required parameters must be populated in order to send to Azure.

    :param min_alert_severity: Required. min alert severity. Possible values include: "Low",
     "Medium", "High".
    :type min_alert_severity: str or ~azure.ai.metricsadvisor.models.Severity
    :param max_alert_severity: Required. max alert severity. Possible values include: "Low",
     "Medium", "High".
    :type max_alert_severity: str or ~azure.ai.metricsadvisor.models.Severity
    """

    _validation = {
        'min_alert_severity': {'required': True},
        'max_alert_severity': {'required': True},
    }

    _attribute_map = {
        'min_alert_severity': {'key': 'minAlertSeverity', 'type': 'str'},
        'max_alert_severity': {'key': 'maxAlertSeverity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SeverityCondition, self).__init__(**kwargs)
        self.min_alert_severity = kwargs['min_alert_severity']
        self.max_alert_severity = kwargs['max_alert_severity']


class SeverityFilterCondition(msrest.serialization.Model):
    """SeverityFilterCondition.

    All required parameters must be populated in order to send to Azure.

    :param min: Required. min severity. Possible values include: "Low", "Medium", "High".
    :type min: str or ~azure.ai.metricsadvisor.models.Severity
    :param max: Required. max severity. Possible values include: "Low", "Medium", "High".
    :type max: str or ~azure.ai.metricsadvisor.models.Severity
    """

    _validation = {
        'min': {'required': True},
        'max': {'required': True},
    }

    _attribute_map = {
        'min': {'key': 'min', 'type': 'str'},
        'max': {'key': 'max', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SeverityFilterCondition, self).__init__(**kwargs)
        self.min = kwargs['min']
        self.max = kwargs['max']


class SmartDetectionCondition(msrest.serialization.Model):
    """SmartDetectionCondition.

    All required parameters must be populated in order to send to Azure.

    :param sensitivity: Required. sensitivity, value range : (0, 100].
    :type sensitivity: float
    :param anomaly_detector_direction: Required. detection direction. Possible values include:
     "Both", "Down", "Up".
    :type anomaly_detector_direction: str or
     ~azure.ai.metricsadvisor.models.AnomalyDetectorDirection
    :param suppress_condition: Required.
    :type suppress_condition: ~azure.ai.metricsadvisor.models.SuppressCondition
    """

    _validation = {
        'sensitivity': {'required': True},
        'anomaly_detector_direction': {'required': True},
        'suppress_condition': {'required': True},
    }

    _attribute_map = {
        'sensitivity': {'key': 'sensitivity', 'type': 'float'},
        'anomaly_detector_direction': {'key': 'anomalyDetectorDirection', 'type': 'str'},
        'suppress_condition': {'key': 'suppressCondition', 'type': 'SuppressCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmartDetectionCondition, self).__init__(**kwargs)
        self.sensitivity = kwargs['sensitivity']
        self.anomaly_detector_direction = kwargs['anomaly_detector_direction']
        self.suppress_condition = kwargs['suppress_condition']


class SQLServerDataFeed(DataFeedDetail):
    """SQLServerDataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or ~azure.ai.metricsadvisor.models.DataSourceType
    :ivar data_feed_id: data feed unique id.
    :vartype data_feed_id: str
    :param data_feed_name: Required. data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param granularity_name: Required. granularity of the time series. Possible values include:
     "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", "Secondly", "Custom".
    :type granularity_name: str or ~azure.ai.metricsadvisor.models.Granularity
    :param granularity_amount: if granularity is custom,it is required.
    :type granularity_amount: int
    :param metrics: Required. measure list.
    :type metrics: list[~azure.ai.metricsadvisor.models.Metric]
    :param dimension: dimension list.
    :type dimension: list[~azure.ai.metricsadvisor.models.Dimension]
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: Required. ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup". Default value: "NeedRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.NeedRollupEnum
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling". Default value:
     "SmartFilling".
    :type fill_missing_point_type: str or ~azure.ai.metricsadvisor.models.FillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public". Default value: "Private".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.ViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Possible values include: "Active", "Paused". Default value:
     "Active".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter: Required.
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.SqlSourceParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'data_feed_id': {'readonly': True},
        'data_feed_name': {'required': True},
        'granularity_name': {'required': True},
        'metrics': {'required': True, 'unique': True},
        'dimension': {'unique': True},
        'data_start_from': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
        'is_admin': {'readonly': True},
        'creator': {'readonly': True},
        'status': {'readonly': True},
        'created_time': {'readonly': True},
        'data_source_parameter': {'required': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_id': {'key': 'dataFeedId', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'granularity_name': {'key': 'granularityName', 'type': 'str'},
        'granularity_amount': {'key': 'granularityAmount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[Metric]'},
        'dimension': {'key': 'dimension', 'type': '[Dimension]'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'creator': {'key': 'creator', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'SqlSourceParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SQLServerDataFeed, self).__init__(**kwargs)
        self.data_source_type = 'SqlServer'  # type: str
        self.data_source_parameter = kwargs['data_source_parameter']


class SQLServerDataFeedPatch(DataFeedDetailPatch):
    """SQLServerDataFeedPatch.

    All required parameters must be populated in order to send to Azure.

    :param data_source_type: Required. data source type.Constant filled by server.  Possible values
     include: "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureTable", "Elasticsearch", "HttpRequest", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", "SqlServer".
    :type data_source_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchDataSourceType
    :param data_feed_name: data feed name.
    :type data_feed_name: str
    :param data_feed_description: data feed description.
    :type data_feed_description: str
    :param timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :type timestamp_column: str
    :param data_start_from: ingestion start time.
    :type data_start_from: ~datetime.datetime
    :param start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :type start_offset_in_seconds: long
    :param max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :type max_concurrency: int
    :param min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :type min_retry_interval_in_seconds: long
    :param stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :type stop_retry_after_in_seconds: long
    :param need_rollup: mark if the data feed need rollup. Possible values include: "NoRollup",
     "NeedRollup", "AlreadyRollup".
    :type need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchNeedRollup
    :param roll_up_method: roll up method. Possible values include: "None", "Sum", "Max", "Min",
     "Avg", "Count".
    :type roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchRollUpMethod
    :param roll_up_columns: roll up columns.
    :type roll_up_columns: list[str]
    :param all_up_identification: the identification value for the row of calculated all-up value.
    :type all_up_identification: str
    :param fill_missing_point_type: the type of fill missing point for anomaly detection. Possible
     values include: "SmartFilling", "PreviousValue", "CustomValue", "NoFilling".
    :type fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DataFeedDetailPatchFillMissingPointType
    :param fill_missing_point_value: the value of fill missing point for anomaly detection.
    :type fill_missing_point_value: float
    :param view_mode: data feed access mode, default is Private. Possible values include:
     "Private", "Public".
    :type view_mode: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchViewMode
    :param admins: data feed administrator.
    :type admins: list[str]
    :param viewers: data feed viewer.
    :type viewers: list[str]
    :param status: data feed status. Possible values include: "Active", "Paused".
    :type status: str or ~azure.ai.metricsadvisor.models.DataFeedDetailPatchStatus
    :param action_link_template: action link for alert.
    :type action_link_template: str
    :param data_source_parameter:
    :type data_source_parameter: ~azure.ai.metricsadvisor.models.SqlSourceParameter
    """

    _validation = {
        'data_source_type': {'required': True},
        'roll_up_columns': {'unique': True},
        'admins': {'unique': True},
        'viewers': {'unique': True},
    }

    _attribute_map = {
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'data_feed_name': {'key': 'dataFeedName', 'type': 'str'},
        'data_feed_description': {'key': 'dataFeedDescription', 'type': 'str'},
        'timestamp_column': {'key': 'timestampColumn', 'type': 'str'},
        'data_start_from': {'key': 'dataStartFrom', 'type': 'iso-8601'},
        'start_offset_in_seconds': {'key': 'startOffsetInSeconds', 'type': 'long'},
        'max_concurrency': {'key': 'maxConcurrency', 'type': 'int'},
        'min_retry_interval_in_seconds': {'key': 'minRetryIntervalInSeconds', 'type': 'long'},
        'stop_retry_after_in_seconds': {'key': 'stopRetryAfterInSeconds', 'type': 'long'},
        'need_rollup': {'key': 'needRollup', 'type': 'str'},
        'roll_up_method': {'key': 'rollUpMethod', 'type': 'str'},
        'roll_up_columns': {'key': 'rollUpColumns', 'type': '[str]'},
        'all_up_identification': {'key': 'allUpIdentification', 'type': 'str'},
        'fill_missing_point_type': {'key': 'fillMissingPointType', 'type': 'str'},
        'fill_missing_point_value': {'key': 'fillMissingPointValue', 'type': 'float'},
        'view_mode': {'key': 'viewMode', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'viewers': {'key': 'viewers', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'action_link_template': {'key': 'actionLinkTemplate', 'type': 'str'},
        'data_source_parameter': {'key': 'dataSourceParameter', 'type': 'SqlSourceParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SQLServerDataFeedPatch, self).__init__(**kwargs)
        self.data_source_type = 'SqlServer'  # type: str
        self.data_source_parameter = kwargs.get('data_source_parameter', None)


class SqlSourceParameter(msrest.serialization.Model):
    """SqlSourceParameter.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. Database connection string.
    :type connection_string: str
    :param query: Required. Query script.
    :type query: str
    """

    _validation = {
        'connection_string': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlSourceParameter, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.query = kwargs['query']


class SuppressCondition(msrest.serialization.Model):
    """SuppressCondition.

    All required parameters must be populated in order to send to Azure.

    :param min_number: Required. min point number, value range : [1, +∞).
    :type min_number: int
    :param min_ratio: Required. min point ratio, value range : (0, 100].
    :type min_ratio: float
    """

    _validation = {
        'min_number': {'required': True},
        'min_ratio': {'required': True},
    }

    _attribute_map = {
        'min_number': {'key': 'minNumber', 'type': 'int'},
        'min_ratio': {'key': 'minRatio', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SuppressCondition, self).__init__(**kwargs)
        self.min_number = kwargs['min_number']
        self.min_ratio = kwargs['min_ratio']


class TopNGroupScope(msrest.serialization.Model):
    """TopNGroupScope.

    All required parameters must be populated in order to send to Azure.

    :param top: Required. top N, value range : [1, +∞).
    :type top: int
    :param period: Required. point count used to look back, value range : [1, +∞).
    :type period: int
    :param min_top_count: Required. min count should be in top N, value range : [1, +∞)
    
     should be less than or equal to period.
    :type min_top_count: int
    """

    _validation = {
        'top': {'required': True},
        'period': {'required': True},
        'min_top_count': {'required': True},
    }

    _attribute_map = {
        'top': {'key': 'top', 'type': 'int'},
        'period': {'key': 'period', 'type': 'int'},
        'min_top_count': {'key': 'minTopCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopNGroupScope, self).__init__(**kwargs)
        self.top = kwargs['top']
        self.period = kwargs['period']
        self.min_top_count = kwargs['min_top_count']


class UsageStats(msrest.serialization.Model):
    """UsageStats.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: The timestamp of the stats.
    :vartype timestamp: ~datetime.datetime
    :ivar active_series_count: The active series count.
    :vartype active_series_count: int
    :ivar all_series_count: All series count under non deleted data feed.
    :vartype all_series_count: int
    :ivar metrics_count: The metrics count under non deleted data feed.
    :vartype metrics_count: int
    :ivar datafeed_count: The count of non deleted data feed.
    :vartype datafeed_count: int
    """

    _validation = {
        'timestamp': {'readonly': True},
        'active_series_count': {'readonly': True},
        'all_series_count': {'readonly': True},
        'metrics_count': {'readonly': True},
        'datafeed_count': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'active_series_count': {'key': 'activeSeriesCount', 'type': 'int'},
        'all_series_count': {'key': 'allSeriesCount', 'type': 'int'},
        'metrics_count': {'key': 'metricsCount', 'type': 'int'},
        'datafeed_count': {'key': 'datafeedCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageStats, self).__init__(**kwargs)
        self.timestamp = None
        self.active_series_count = None
        self.all_series_count = None
        self.metrics_count = None
        self.datafeed_count = None


class ValueCondition(msrest.serialization.Model):
    """ValueCondition.

    All required parameters must be populated in order to send to Azure.

    :param lower: lower bound
    
     should be specified when direction is Both or Down.
    :type lower: float
    :param upper: upper bound
    
     should be specified when direction is Both or Up.
    :type upper: float
    :param direction: Required. value filter direction. Possible values include: "Both", "Down",
     "Up".
    :type direction: str or ~azure.ai.metricsadvisor.models.Direction
    :param metric_id: the other metric unique id used for value filter.
    :type metric_id: str
    :param trigger_for_missing: trigger alert when the corresponding point is missing in the other
     metric
    
     should be specified only when using other metric to filter.
    :type trigger_for_missing: bool
    """

    _validation = {
        'direction': {'required': True},
    }

    _attribute_map = {
        'lower': {'key': 'lower', 'type': 'float'},
        'upper': {'key': 'upper', 'type': 'float'},
        'direction': {'key': 'direction', 'type': 'str'},
        'metric_id': {'key': 'metricId', 'type': 'str'},
        'trigger_for_missing': {'key': 'triggerForMissing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValueCondition, self).__init__(**kwargs)
        self.lower = kwargs.get('lower', None)
        self.upper = kwargs.get('upper', None)
        self.direction = kwargs['direction']
        self.metric_id = kwargs.get('metric_id', None)
        self.trigger_for_missing = kwargs.get('trigger_for_missing', None)


class WebhookHookInfo(HookInfo):
    """WebhookHookInfo.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param hook_type: Required. hook type.Constant filled by server.  Possible values include:
     "Webhook", "Email".
    :type hook_type: str or ~azure.ai.metricsadvisor.models.HookType
    :ivar hook_id: Hook unique id.
    :vartype hook_id: str
    :param hook_name: Required. hook unique name.
    :type hook_name: str
    :param description: hook description.
    :type description: str
    :param external_link: hook external link.
    :type external_link: str
    :ivar admins: hook administrators.
    :vartype admins: list[str]
    :param hook_parameter: Required.
    :type hook_parameter: ~azure.ai.metricsadvisor.models.WebhookHookParameter
    """

    _validation = {
        'hook_type': {'required': True},
        'hook_id': {'readonly': True},
        'hook_name': {'required': True},
        'admins': {'readonly': True, 'unique': True},
        'hook_parameter': {'required': True},
    }

    _attribute_map = {
        'hook_type': {'key': 'hookType', 'type': 'str'},
        'hook_id': {'key': 'hookId', 'type': 'str'},
        'hook_name': {'key': 'hookName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'external_link': {'key': 'externalLink', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'hook_parameter': {'key': 'hookParameter', 'type': 'WebhookHookParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookHookInfo, self).__init__(**kwargs)
        self.hook_type = 'Webhook'  # type: str
        self.hook_parameter = kwargs['hook_parameter']


class WebhookHookInfoPatch(HookInfoPatch):
    """WebhookHookInfoPatch.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param hook_type: Required. hook type.Constant filled by server.  Possible values include:
     "Webhook", "Email".
    :type hook_type: str or ~azure.ai.metricsadvisor.models.HookInfoPatchHookType
    :param hook_name: hook unique name.
    :type hook_name: str
    :param description: hook description.
    :type description: str
    :param external_link: hook external link.
    :type external_link: str
    :ivar admins: hook administrators.
    :vartype admins: list[str]
    :param hook_parameter:
    :type hook_parameter: ~azure.ai.metricsadvisor.models.WebhookHookParameter
    """

    _validation = {
        'hook_type': {'required': True},
        'admins': {'readonly': True, 'unique': True},
    }

    _attribute_map = {
        'hook_type': {'key': 'hookType', 'type': 'str'},
        'hook_name': {'key': 'hookName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'external_link': {'key': 'externalLink', 'type': 'str'},
        'admins': {'key': 'admins', 'type': '[str]'},
        'hook_parameter': {'key': 'hookParameter', 'type': 'WebhookHookParameter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookHookInfoPatch, self).__init__(**kwargs)
        self.hook_type = 'Webhook'  # type: str
        self.hook_parameter = kwargs.get('hook_parameter', None)


class WebhookHookParameter(msrest.serialization.Model):
    """WebhookHookParameter.

    All required parameters must be populated in order to send to Azure.

    :param endpoint: Required. API address, will be called when alert is triggered, only support
     POST method via SSL.
    :type endpoint: str
    :param username: basic authentication.
    :type username: str
    :param password: basic authentication.
    :type password: str
    :param headers: custom headers in api call.
    :type headers: dict[str, str]
    :param certificate_key: client certificate.
    :type certificate_key: str
    :param certificate_password: client certificate password.
    :type certificate_password: str
    """

    _validation = {
        'endpoint': {'required': True},
    }

    _attribute_map = {
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'certificate_key': {'key': 'certificateKey', 'type': 'str'},
        'certificate_password': {'key': 'certificatePassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookHookParameter, self).__init__(**kwargs)
        self.endpoint = kwargs['endpoint']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.headers = kwargs.get('headers', None)
        self.certificate_key = kwargs.get('certificate_key', None)
        self.certificate_password = kwargs.get('certificate_password', None)


class WholeMetricConfiguration(msrest.serialization.Model):
    """WholeMetricConfiguration.

    :param condition_operator: condition operator
    
     should be specified when combining multiple detection conditions. Possible values include:
     "AND", "OR".
    :type condition_operator: str or
     ~azure.ai.metricsadvisor.models.WholeMetricConfigurationConditionOperator
    :param smart_detection_condition:
    :type smart_detection_condition: ~azure.ai.metricsadvisor.models.SmartDetectionCondition
    :param hard_threshold_condition:
    :type hard_threshold_condition: ~azure.ai.metricsadvisor.models.HardThresholdCondition
    :param change_threshold_condition:
    :type change_threshold_condition: ~azure.ai.metricsadvisor.models.ChangeThresholdCondition
    """

    _attribute_map = {
        'condition_operator': {'key': 'conditionOperator', 'type': 'str'},
        'smart_detection_condition': {'key': 'smartDetectionCondition', 'type': 'SmartDetectionCondition'},
        'hard_threshold_condition': {'key': 'hardThresholdCondition', 'type': 'HardThresholdCondition'},
        'change_threshold_condition': {'key': 'changeThresholdCondition', 'type': 'ChangeThresholdCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WholeMetricConfiguration, self).__init__(**kwargs)
        self.condition_operator = kwargs.get('condition_operator', None)
        self.smart_detection_condition = kwargs.get('smart_detection_condition', None)
        self.hard_threshold_condition = kwargs.get('hard_threshold_condition', None)
        self.change_threshold_condition = kwargs.get('change_threshold_condition', None)
