# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...operations._operations import (
    build_received_shares_activate_tenant_email_registration_request,
    build_received_shares_create_or_replace_request,
    build_received_shares_delete_request,
    build_received_shares_get_request,
    build_received_shares_list_attached_request,
    build_received_shares_list_detached_request,
    build_received_shares_register_tenant_email_registration_request,
    build_sent_shares_create_invitation_request,
    build_sent_shares_create_or_replace_request,
    build_sent_shares_delete_invitation_request,
    build_sent_shares_delete_request,
    build_sent_shares_get_invitation_request,
    build_sent_shares_get_request,
    build_sent_shares_list_invitations_request,
    build_sent_shares_list_request,
    build_sent_shares_notify_user_invitation_request,
    build_share_resources_list_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ReceivedSharesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.sharing.aio.PurviewSharingClient`'s
        :attr:`received_shares` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, received_share_id: str, **kwargs: Any) -> JSON:
        """Get a received share by unique id.

        Get a received share.

        :param received_share_id: Id of the received share. Required.
        :type received_share_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200
                response == received_share
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_received_shares_get_request(
            received_share_id=received_share_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _create_or_replace_initial(
        self, received_share_id: str, received_share: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(received_share, (IO, bytes)):
            _content = received_share
        else:
            _json = received_share

        request = build_received_shares_create_or_replace_request(
            received_share_id=received_share_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def begin_create_or_replace(
        self, received_share_id: str, received_share: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create or replace a received share.

        Update changes to a received share.

        :param received_share_id: Id of the received share. Required.
        :type received_share_id: str
        :param received_share: The received share to create or replace. Required.
        :type received_share: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template you can fill out and use as your body input.
                received_share = received_share
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200, 201
                response == received_share
        """

    @overload
    async def begin_create_or_replace(
        self, received_share_id: str, received_share: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create or replace a received share.

        Update changes to a received share.

        :param received_share_id: Id of the received share. Required.
        :type received_share_id: str
        :param received_share: The received share to create or replace. Required.
        :type received_share: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200, 201
                response == received_share
        """

    @distributed_trace_async
    async def begin_create_or_replace(
        self, received_share_id: str, received_share: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create or replace a received share.

        Update changes to a received share.

        :param received_share_id: Id of the received share. Required.
        :type received_share_id: str
        :param received_share: The received share to create or replace. Is either a JSON type or a IO
         type. Required.
        :type received_share: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template you can fill out and use as your body input.
                received_share = received_share
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200, 201
                response == received_share
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_replace_initial(
                received_share_id=received_share_id,
                received_share=received_share,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _delete_initial(self, received_share_id: str, **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_received_shares_delete_request(
            received_share_id=received_share_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_delete(self, received_share_id: str, **kwargs: Any) -> AsyncLROPoller[JSON]:
        """Deletes a received share.

        Delete a received share.

        :param received_share_id: Id of the received share. Required.
        :type received_share_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "status": "str",  # States for long running operations. Required. Known
                      values are: "Running", "TransientFailure", "Succeeded", "Failed", and
                      "NotStarted".
                    "endTime": "2020-02-20 00:00:00",  # Optional. End time of the long running
                      operation. Represented in the standard date-time format as defined by `RFC 3339
                      <https://www.rfc-editor.org/rfc/rfc3339>`_.
                    "error": {
                        "code": "str",  # Code of the error. Required.
                        "message": "str",  # Message of the error. Required.
                        "details": [
                            ...
                        ],
                        "target": "str"  # Optional. Target of the error.
                    },
                    "id": "str",  # Optional. Job id of the long running operation.
                    "startTime": "2020-02-20 00:00:00"  # Optional. Start time of the long
                      running operation. Represented in the standard date-time format as defined by
                      `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                received_share_id=received_share_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_attached(
        self, *, reference_name: str, filter: Optional[str] = None, order_by: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Get a list of attached received shares.

        List attached received shares.

        :keyword reference_name: A name that references a data store. Required.
        :paramtype reference_name: str
        :keyword filter: Filters the results using OData syntax. Default value is None.
        :paramtype filter: str
        :keyword order_by: Sorts the results using OData syntax. Default value is None.
        :paramtype order_by: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200
                response == received_share
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_received_shares_list_attached_request(
                    reference_name=reference_name,
                    filter=filter,
                    order_by=order_by,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_detached(
        self, *, filter: Optional[str] = None, order_by: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Get a list of detached received shares.

        List detached received shares.

        :keyword filter: Filters the results using OData syntax. Default value is None.
        :paramtype filter: str
        :keyword order_by: Sorts the results using OData syntax. Default value is None.
        :paramtype order_by: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                received_share = {
                    "properties": {
                        "assetLocation": "str",  # Optional. Location of the shared Asset.
                        "assetStoreKind": "str",  # Optional. The types of asset. Known
                          values are: "AdlsGen2Account" and "BlobAccount".
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          received share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "displayName": "str",  # Optional. Received Share Name.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The expiration
                          date of the received share. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "receiverEmail": "str",  # Optional. Email of the user/receiver who
                          received the sent share invitation.
                        "receiverName": "str",  # Optional. Name of the user/receiver who
                          received the sent share invitation.
                        "receiverTenantName": "str",  # Optional. Tenant name of the
                          user/receiver who received the sent share invitation.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share invitation.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share invitation.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share invitation.
                        "sentShareDescription": "str",  # Optional. Share description.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "sharedAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was shared. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "sink": sink,
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                sink = {
                    "properties": {
                        "containerName": "str",  # Adls Gen 2 Container Name. Required.
                        "folder": "str",  # Adls Gen 2 Folder. Required.
                        "location": "str",  # Optional. Adls Gen 2 Location.
                        "mountPath": "str"  # Optional. Adls Gen 2 Mount Path.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                sink = {
                    "properties": {
                        "containerName": "str",  # Blob Container Name. Required.
                        "folder": "str",  # Blob Folder. Required.
                        "location": "str",  # Optional. Blob Location.
                        "mountPath": "str"  # Optional. Blob Mount Path.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200
                response == received_share
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_received_shares_list_detached_request(
                    filter=filter,
                    order_by=order_by,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def activate_tenant_email_registration(
        self,
        tenant_email_registration: JSON,
        *,
        repeatability_request_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Activates the tenant and email combination using the activation code received.

        Activates the email registration for current tenant.

        :param tenant_email_registration: The tenant email registration payload. Required.
        :type tenant_email_registration: JSON
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated, globally unique for all time, identifier for the request. It
         is recommended to use version 4 (random) UUIDs. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                tenant_email_registration = {
                    "id": "str",  # Optional. The unique id of the resource.
                    "properties": {
                        "activationCode": "str",  # Activation code for the registration.
                          Required.
                        "activationExpiration": "2020-02-20 00:00:00",  # Optional. Date of
                          the activation expiration. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "email": "str",  # Optional. The email to register.
                        "registrationStatus": "str",  # Optional. Defines the supported types
                          for registration. Known values are: "ActivationPending", "Activated", and
                          "ActivationAttemptsExhausted".
                        "state": "str",  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                        "tenantId": "str"  # Optional. The tenant id to register.
                    },
                    "type": "str"  # Optional. Type of the resource.
                }

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. The unique id of the resource.
                    "properties": {
                        "activationCode": "str",  # Activation code for the registration.
                          Required.
                        "activationExpiration": "2020-02-20 00:00:00",  # Optional. Date of
                          the activation expiration. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "email": "str",  # Optional. The email to register.
                        "registrationStatus": "str",  # Optional. Defines the supported types
                          for registration. Known values are: "ActivationPending", "Activated", and
                          "ActivationAttemptsExhausted".
                        "state": "str",  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                        "tenantId": "str"  # Optional. The tenant id to register.
                    },
                    "type": "str"  # Optional. Type of the resource.
                }
        """

    @overload
    async def activate_tenant_email_registration(
        self,
        tenant_email_registration: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Activates the tenant and email combination using the activation code received.

        Activates the email registration for current tenant.

        :param tenant_email_registration: The tenant email registration payload. Required.
        :type tenant_email_registration: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated, globally unique for all time, identifier for the request. It
         is recommended to use version 4 (random) UUIDs. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. The unique id of the resource.
                    "properties": {
                        "activationCode": "str",  # Activation code for the registration.
                          Required.
                        "activationExpiration": "2020-02-20 00:00:00",  # Optional. Date of
                          the activation expiration. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "email": "str",  # Optional. The email to register.
                        "registrationStatus": "str",  # Optional. Defines the supported types
                          for registration. Known values are: "ActivationPending", "Activated", and
                          "ActivationAttemptsExhausted".
                        "state": "str",  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                        "tenantId": "str"  # Optional. The tenant id to register.
                    },
                    "type": "str"  # Optional. Type of the resource.
                }
        """

    @distributed_trace_async
    async def activate_tenant_email_registration(
        self,
        tenant_email_registration: Union[JSON, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Activates the tenant and email combination using the activation code received.

        Activates the email registration for current tenant.

        :param tenant_email_registration: The tenant email registration payload. Is either a JSON type
         or a IO type. Required.
        :type tenant_email_registration: JSON or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated, globally unique for all time, identifier for the request. It
         is recommended to use version 4 (random) UUIDs. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                tenant_email_registration = {
                    "id": "str",  # Optional. The unique id of the resource.
                    "properties": {
                        "activationCode": "str",  # Activation code for the registration.
                          Required.
                        "activationExpiration": "2020-02-20 00:00:00",  # Optional. Date of
                          the activation expiration. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "email": "str",  # Optional. The email to register.
                        "registrationStatus": "str",  # Optional. Defines the supported types
                          for registration. Known values are: "ActivationPending", "Activated", and
                          "ActivationAttemptsExhausted".
                        "state": "str",  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                        "tenantId": "str"  # Optional. The tenant id to register.
                    },
                    "type": "str"  # Optional. Type of the resource.
                }

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. The unique id of the resource.
                    "properties": {
                        "activationCode": "str",  # Activation code for the registration.
                          Required.
                        "activationExpiration": "2020-02-20 00:00:00",  # Optional. Date of
                          the activation expiration. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "email": "str",  # Optional. The email to register.
                        "registrationStatus": "str",  # Optional. Defines the supported types
                          for registration. Known values are: "ActivationPending", "Activated", and
                          "ActivationAttemptsExhausted".
                        "state": "str",  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                        "tenantId": "str"  # Optional. The tenant id to register.
                    },
                    "type": "str"  # Optional. Type of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(tenant_email_registration, (IO, bytes)):
            _content = tenant_email_registration
        else:
            _json = tenant_email_registration

        request = build_received_shares_activate_tenant_email_registration_request(
            repeatability_request_id=repeatability_request_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def register_tenant_email_registration(
        self, *, repeatability_request_id: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Registers the tenant and email combination for activation.

        Register an email for the current tenant.

        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated, globally unique for all time, identifier for the request. It
         is recommended to use version 4 (random) UUIDs. Default value is None.
        :paramtype repeatability_request_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. The unique id of the resource.
                    "properties": {
                        "activationCode": "str",  # Activation code for the registration.
                          Required.
                        "activationExpiration": "2020-02-20 00:00:00",  # Optional. Date of
                          the activation expiration. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "email": "str",  # Optional. The email to register.
                        "registrationStatus": "str",  # Optional. Defines the supported types
                          for registration. Known values are: "ActivationPending", "Activated", and
                          "ActivationAttemptsExhausted".
                        "state": "str",  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                        "tenantId": "str"  # Optional. The tenant id to register.
                    },
                    "type": "str"  # Optional. Type of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_received_shares_register_tenant_email_registration_request(
            repeatability_request_id=repeatability_request_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class SentSharesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.sharing.aio.PurviewSharingClient`'s
        :attr:`sent_shares` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, *, reference_name: str, filter: Optional[str] = None, order_by: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Get a list of sent shares.

        List sent shares.

        :keyword reference_name: A name that references a data store. Required.
        :paramtype reference_name: str
        :keyword filter: Filters the results using OData syntax. Default value is None.
        :paramtype filter: str
        :keyword order_by: Sorts the results using OData syntax. Default value is None.
        :paramtype order_by: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200
                response == sent_share
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_sent_shares_list_request(
                    reference_name=reference_name,
                    filter=filter,
                    order_by=order_by,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, sent_share_id: str, **kwargs: Any) -> JSON:
        """Get a sent share by guid.

        Get a sent share.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200
                response == sent_share
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_sent_shares_get_request(
            sent_share_id=sent_share_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _create_or_replace_initial(self, sent_share_id: str, sent_share: Union[JSON, IO], **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(sent_share, (IO, bytes)):
            _content = sent_share
        else:
            _json = sent_share

        request = build_sent_shares_create_or_replace_request(
            sent_share_id=sent_share_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def begin_create_or_replace(
        self, sent_share_id: str, sent_share: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create or replace a sent share.

        Create or replace a sent share.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :param sent_share: The sent share to create or replace. Required.
        :type sent_share: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template you can fill out and use as your body input.
                sent_share = sent_share
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200, 201
                response == sent_share
        """

    @overload
    async def begin_create_or_replace(
        self, sent_share_id: str, sent_share: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create or replace a sent share.

        Create or replace a sent share.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :param sent_share: The sent share to create or replace. Required.
        :type sent_share: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200, 201
                response == sent_share
        """

    @distributed_trace_async
    async def begin_create_or_replace(
        self, sent_share_id: str, sent_share: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create or replace a sent share.

        Create or replace a sent share.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :param sent_share: The sent share to create or replace. Is either a JSON type or a IO type.
         Required.
        :type sent_share: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template you can fill out and use as your body input.
                sent_share = sent_share
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "shareKind":

                # JSON input template for discriminator value "InPlace":
                sent_share = {
                    "properties": {
                        "artifact": artifact,
                        "displayName": "str",  # The name of the sent share. Required.
                        "createdAt": "2020-02-20 00:00:00",  # Optional. Time at which the
                          sent share was created. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "dependsOn": [
                            "str"  # Optional. List of shares on which the sent share
                              depends.
                        ],
                        "description": "str",  # Optional. Sent share description.
                        "senderEmail": "str",  # Optional. Email of the sender who created
                          the sent share.
                        "senderName": "str",  # Optional. Name of the sender who created the
                          sent share.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender who
                          created the sent share.
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "shareKind": "InPlace",
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "AdlsGen2Account":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "AdlsGen2Account",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # JSON input template for discriminator value "BlobAccount":
                artifact = {
                    "properties": {
                        "paths": [
                            {
                                "containerName": "str",  # Gets or sets the container
                                  name. Required.
                                "receiverPath": "str",  # Optional. Gets or sets the
                                  path on the receiver side where the artifact is to be mapped.
                                "senderPath": "str"  # Optional. Gets or sets the
                                  path to file/folder within the container to be shared.
                            }
                        ],
                        "location": "str"  # Optional. Location of the storage account.
                    },
                    "storeKind": "BlobAccount",
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    }
                }

                # response body for status code(s): 200, 201
                response == sent_share
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_replace_initial(
                sent_share_id=sent_share_id,
                sent_share=sent_share,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _delete_initial(self, sent_share_id: str, **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_sent_shares_delete_request(
            sent_share_id=sent_share_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_delete(self, sent_share_id: str, **kwargs: Any) -> AsyncLROPoller[JSON]:
        """Deletes a sent share.

        Delete a sent share.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "status": "str",  # States for long running operations. Required. Known
                      values are: "Running", "TransientFailure", "Succeeded", "Failed", and
                      "NotStarted".
                    "endTime": "2020-02-20 00:00:00",  # Optional. End time of the long running
                      operation. Represented in the standard date-time format as defined by `RFC 3339
                      <https://www.rfc-editor.org/rfc/rfc3339>`_.
                    "error": {
                        "code": "str",  # Code of the error. Required.
                        "message": "str",  # Message of the error. Required.
                        "details": [
                            ...
                        ],
                        "target": "str"  # Optional. Target of the error.
                    },
                    "id": "str",  # Optional. Job id of the long running operation.
                    "startTime": "2020-02-20 00:00:00"  # Optional. Start time of the long
                      running operation. Represented in the standard date-time format as defined by
                      `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                sent_share_id=sent_share_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_invitations(
        self, sent_share_id: str, *, filter: Optional[str] = None, order_by: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """List all sent share invitations in a sent share.

        List sent share recipients.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :keyword filter: Filters the results using OData syntax. Default value is None.
        :paramtype filter: str
        :keyword order_by: Sorts the results using OData syntax. Default value is None.
        :paramtype order_by: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "invitationKind":

                # JSON input template for discriminator value "Service":
                sent_share_invitation = {
                    "invitationKind": "Service",
                    "properties": {
                        "targetActiveDirectoryId": "str",  # The target azure active
                          directory id the invitation is sent to. Required.
                        "targetObjectId": "str",  # The target object id in the azure active
                          directory the invitation is sent to. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "User":
                sent_share_invitation = {
                    "invitationKind": "User",
                    "properties": {
                        "targetEmail": "str",  # The receiver email for the invitation is
                          being sent. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "notify": bool,  # Optional. Whether or not the recipient was
                          notified via email.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # response body for status code(s): 200
                response == sent_share_invitation
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_sent_shares_list_invitations_request(
                    sent_share_id=sent_share_id,
                    filter=filter,
                    order_by=order_by,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_invitation(self, sent_share_id: str, sent_share_invitation_id: str, **kwargs: Any) -> JSON:
        """Get sent share invitation for a given sent share.

        Get recipient for a given sent share.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :param sent_share_invitation_id: Id of the sent share invitation. Required.
        :type sent_share_invitation_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "invitationKind":

                # JSON input template for discriminator value "Service":
                sent_share_invitation = {
                    "invitationKind": "Service",
                    "properties": {
                        "targetActiveDirectoryId": "str",  # The target azure active
                          directory id the invitation is sent to. Required.
                        "targetObjectId": "str",  # The target object id in the azure active
                          directory the invitation is sent to. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "User":
                sent_share_invitation = {
                    "invitationKind": "User",
                    "properties": {
                        "targetEmail": "str",  # The receiver email for the invitation is
                          being sent. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "notify": bool,  # Optional. Whether or not the recipient was
                          notified via email.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # response body for status code(s): 200
                response == sent_share_invitation
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_sent_shares_get_invitation_request(
            sent_share_id=sent_share_id,
            sent_share_invitation_id=sent_share_invitation_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_invitation(
        self,
        sent_share_id: str,
        sent_share_invitation_id: str,
        sent_share_invitation: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Create a sent share invitation.

        Create a recipient for a given sent share.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :param sent_share_invitation_id: Id of the sent share invitation. Required.
        :type sent_share_invitation_id: str
        :param sent_share_invitation: The sent share invitation to create. Required.
        :type sent_share_invitation: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "invitationKind":

                # JSON input template for discriminator value "Service":
                sent_share_invitation = {
                    "invitationKind": "Service",
                    "properties": {
                        "targetActiveDirectoryId": "str",  # The target azure active
                          directory id the invitation is sent to. Required.
                        "targetObjectId": "str",  # The target object id in the azure active
                          directory the invitation is sent to. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "User":
                sent_share_invitation = {
                    "invitationKind": "User",
                    "properties": {
                        "targetEmail": "str",  # The receiver email for the invitation is
                          being sent. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "notify": bool,  # Optional. Whether or not the recipient was
                          notified via email.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template you can fill out and use as your body input.
                sent_share_invitation = sent_share_invitation
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "invitationKind":

                # JSON input template for discriminator value "Service":
                sent_share_invitation = {
                    "invitationKind": "Service",
                    "properties": {
                        "targetActiveDirectoryId": "str",  # The target azure active
                          directory id the invitation is sent to. Required.
                        "targetObjectId": "str",  # The target object id in the azure active
                          directory the invitation is sent to. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "User":
                sent_share_invitation = {
                    "invitationKind": "User",
                    "properties": {
                        "targetEmail": "str",  # The receiver email for the invitation is
                          being sent. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "notify": bool,  # Optional. Whether or not the recipient was
                          notified via email.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # response body for status code(s): 201
                response == sent_share_invitation
        """

    @overload
    async def create_invitation(
        self,
        sent_share_id: str,
        sent_share_invitation_id: str,
        sent_share_invitation: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Create a sent share invitation.

        Create a recipient for a given sent share.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :param sent_share_invitation_id: Id of the sent share invitation. Required.
        :type sent_share_invitation_id: str
        :param sent_share_invitation: The sent share invitation to create. Required.
        :type sent_share_invitation: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "invitationKind":

                # JSON input template for discriminator value "Service":
                sent_share_invitation = {
                    "invitationKind": "Service",
                    "properties": {
                        "targetActiveDirectoryId": "str",  # The target azure active
                          directory id the invitation is sent to. Required.
                        "targetObjectId": "str",  # The target object id in the azure active
                          directory the invitation is sent to. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "User":
                sent_share_invitation = {
                    "invitationKind": "User",
                    "properties": {
                        "targetEmail": "str",  # The receiver email for the invitation is
                          being sent. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "notify": bool,  # Optional. Whether or not the recipient was
                          notified via email.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # response body for status code(s): 201
                response == sent_share_invitation
        """

    @distributed_trace_async
    async def create_invitation(
        self, sent_share_id: str, sent_share_invitation_id: str, sent_share_invitation: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Create a sent share invitation.

        Create a recipient for a given sent share.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :param sent_share_invitation_id: Id of the sent share invitation. Required.
        :type sent_share_invitation_id: str
        :param sent_share_invitation: The sent share invitation to create. Is either a JSON type or a
         IO type. Required.
        :type sent_share_invitation: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "invitationKind":

                # JSON input template for discriminator value "Service":
                sent_share_invitation = {
                    "invitationKind": "Service",
                    "properties": {
                        "targetActiveDirectoryId": "str",  # The target azure active
                          directory id the invitation is sent to. Required.
                        "targetObjectId": "str",  # The target object id in the azure active
                          directory the invitation is sent to. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "User":
                sent_share_invitation = {
                    "invitationKind": "User",
                    "properties": {
                        "targetEmail": "str",  # The receiver email for the invitation is
                          being sent. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "notify": bool,  # Optional. Whether or not the recipient was
                          notified via email.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template you can fill out and use as your body input.
                sent_share_invitation = sent_share_invitation
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "invitationKind":

                # JSON input template for discriminator value "Service":
                sent_share_invitation = {
                    "invitationKind": "Service",
                    "properties": {
                        "targetActiveDirectoryId": "str",  # The target azure active
                          directory id the invitation is sent to. Required.
                        "targetObjectId": "str",  # The target object id in the azure active
                          directory the invitation is sent to. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "User":
                sent_share_invitation = {
                    "invitationKind": "User",
                    "properties": {
                        "targetEmail": "str",  # The receiver email for the invitation is
                          being sent. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "notify": bool,  # Optional. Whether or not the recipient was
                          notified via email.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # response body for status code(s): 201
                response == sent_share_invitation
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(sent_share_invitation, (IO, bytes)):
            _content = sent_share_invitation
        else:
            _json = sent_share_invitation

        request = build_sent_shares_create_invitation_request(
            sent_share_id=sent_share_id,
            sent_share_invitation_id=sent_share_invitation_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _delete_invitation_initial(
        self, sent_share_id: str, sent_share_invitation_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_sent_shares_delete_invitation_request(
            sent_share_id=sent_share_id,
            sent_share_invitation_id=sent_share_invitation_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_delete_invitation(
        self, sent_share_id: str, sent_share_invitation_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Delete Invitation in a share.

        Delete a sent share invitation.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :param sent_share_invitation_id: Id of the sent share invitation. Required.
        :type sent_share_invitation_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "status": "str",  # States for long running operations. Required. Known
                      values are: "Running", "TransientFailure", "Succeeded", "Failed", and
                      "NotStarted".
                    "endTime": "2020-02-20 00:00:00",  # Optional. End time of the long running
                      operation. Represented in the standard date-time format as defined by `RFC 3339
                      <https://www.rfc-editor.org/rfc/rfc3339>`_.
                    "error": {
                        "code": "str",  # Code of the error. Required.
                        "message": "str",  # Message of the error. Required.
                        "details": [
                            ...
                        ],
                        "target": "str"  # Optional. Target of the error.
                    },
                    "id": "str",  # Optional. Job id of the long running operation.
                    "startTime": "2020-02-20 00:00:00"  # Optional. Start time of the long
                      running operation. Represented in the standard date-time format as defined by
                      `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_invitation_initial(
                sent_share_id=sent_share_id,
                sent_share_invitation_id=sent_share_invitation_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def notify_user_invitation(
        self,
        sent_share_id: str,
        sent_share_invitation_id: str,
        *,
        repeatability_request_id: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Notifies the recipient of the sent share invitation.

        Notifies the user recipient of the sent share invitation, does not apply to service
        invitations.

        :param sent_share_id: Id of the sent share. Required.
        :type sent_share_id: str
        :param sent_share_invitation_id: Id of the sent share invitation. Required.
        :type sent_share_invitation_id: str
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated, globally unique for all time, identifier for the request. It
         is recommended to use version 4 (random) UUIDs. Default value is None.
        :paramtype repeatability_request_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "invitationKind":

                # JSON input template for discriminator value "Service":
                sent_share_invitation = {
                    "invitationKind": "Service",
                    "properties": {
                        "targetActiveDirectoryId": "str",  # The target azure active
                          directory id the invitation is sent to. Required.
                        "targetObjectId": "str",  # The target object id in the azure active
                          directory the invitation is sent to. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # JSON input template for discriminator value "User":
                sent_share_invitation = {
                    "invitationKind": "User",
                    "properties": {
                        "targetEmail": "str",  # The receiver email for the invitation is
                          being sent. Required.
                        "expirationDate": "2020-02-20 00:00:00",  # Optional. The time at
                          which the invitation will expire. Represented in the standard date-time
                          format as defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "notify": bool,  # Optional. Whether or not the recipient was
                          notified via email.
                        "senderEmail": "str",  # Optional. Email address of the sender.
                        "senderName": "str",  # Optional. Name of the sender.
                        "senderTenantName": "str",  # Optional. Tenant name of the sender.
                        "sentAt": "2020-02-20 00:00:00",  # Optional. Gets the time at which
                          the invitation was sent. Represented in the standard date-time format as
                          defined by `RFC 3339 <https://www.rfc-editor.org/rfc/rfc3339>`_.
                        "shareStatus": "str",  # Optional. Share status. Known values are:
                          "Detached" and "Attached".
                        "state": "str"  # Optional. State of the resource. Known values are:
                          "Unknown", "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
                    },
                    "id": "str",  # Optional. The unique id of the resource.
                    "type": "str"  # Optional. Type of the resource.
                }

                # response body for status code(s): 200
                response == sent_share_invitation
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_sent_shares_notify_user_invitation_request(
            sent_share_id=sent_share_id,
            sent_share_invitation_id=sent_share_invitation_id,
            repeatability_request_id=repeatability_request_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class ShareResourcesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.sharing.aio.PurviewSharingClient`'s
        :attr:`share_resources` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, *, filter: Optional[str] = None, order_by: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """API operation to list ShareResources.

        List share resources.

        :keyword filter: Filters the results using OData syntax. Default value is None.
        :paramtype filter: str
        :keyword order_by: Sorts the results using OData syntax. Default value is None.
        :paramtype order_by: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. The unique id of the resource.
                    "receivedSharesCount": 0,  # Optional. A count of Received Shares associated
                      with the
                      Microsoft.Azure.Purview.Share.ApiService.V3.DataTransferObjects.ShareResource.
                    "sentSharesCount": 0,  # Optional. A count of Sent Shares associated with the
                      Microsoft.Azure.Purview.Share.ApiService.V3.DataTransferObjects.ShareResource.
                    "storeKind": "str",  # Optional. The types of asset. Known values are:
                      "AdlsGen2Account" and "BlobAccount".
                    "storeReference": {
                        "referenceName": "str",  # Optional. Reference name for resource
                          associated with the sink or artifact.
                        "type": "str"  # Optional. Defines the type of resource being shared.
                          "ArmResourceReference"
                    },
                    "type": "str"  # Optional. Type of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_share_resources_list_request(
                    filter=filter,
                    order_by=order_by,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
