# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.mongodbatlas.aio import MongoDBAtlasMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMongoDBAtlasMgmtOrganizationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MongoDBAtlasMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_get(self, resource_group):
        response = await self.client.organizations.get(
            resource_group_name=resource_group.name,
            organization_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.organizations.begin_create_or_update(
                resource_group_name=resource_group.name,
                organization_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "name": "str",
                    "properties": {
                        "marketplace": {
                            "offerDetails": {
                                "offerId": "str",
                                "planId": "str",
                                "publisherId": "str",
                                "planName": "str",
                                "termId": "str",
                                "termUnit": "str",
                            },
                            "subscriptionId": "str",
                            "subscriptionStatus": "str",
                        },
                        "user": {
                            "emailAddress": "str",
                            "firstName": "str",
                            "lastName": "str",
                            "companyName": "str",
                            "phoneNumber": "str",
                            "upn": "str",
                        },
                        "partnerProperties": {"organizationName": "str", "organizationId": "str", "redirectUrl": "str"},
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_begin_update(self, resource_group):
        response = await (
            await self.client.organizations.begin_update(
                resource_group_name=resource_group.name,
                organization_name="str",
                properties={
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "properties": {
                        "partnerProperties": {"organizationName": "str", "organizationId": "str", "redirectUrl": "str"},
                        "user": {
                            "emailAddress": "str",
                            "firstName": "str",
                            "lastName": "str",
                            "companyName": "str",
                            "phoneNumber": "str",
                            "upn": "str",
                        },
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_begin_delete(self, resource_group):
        response = await (
            await self.client.organizations.begin_delete(
                resource_group_name=resource_group.name,
                organization_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_list_by_resource_group(self, resource_group):
        response = self.client.organizations.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_organizations_list_by_subscription(self, resource_group):
        response = self.client.organizations.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
