# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.settings import settings
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from . import models as _models
from ._configuration import AuthorizationManagementClientConfiguration
from ._utils.serialization import Deserializer, Serializer
from .operations import (
    AccessReviewDefaultSettingsOperations,
    AccessReviewHistoryDefinitionInstanceOperations,
    AccessReviewHistoryDefinitionInstancesOperations,
    AccessReviewHistoryDefinitionOperations,
    AccessReviewHistoryDefinitionsOperations,
    AccessReviewInstanceContactedReviewersOperations,
    AccessReviewInstanceDecisionsOperations,
    AccessReviewInstanceMyDecisionsOperations,
    AccessReviewInstanceOperations,
    AccessReviewInstancesAssignedForMyApprovalOperations,
    AccessReviewInstancesOperations,
    AccessReviewScheduleDefinitionsAssignedForMyApprovalOperations,
    AccessReviewScheduleDefinitionsOperations,
    AlertConfigurationsOperations,
    AlertDefinitionsOperations,
    AlertIncidentsOperations,
    AlertOperationOperations,
    AlertsOperations,
    ClassicAdministratorsOperations,
    DenyAssignmentsOperations,
    EligibleChildResourcesOperations,
    GlobalAdministratorOperations,
    Operations,
    PermissionsOperations,
    ProviderOperationsMetadataOperations,
    RoleAssignmentScheduleInstancesOperations,
    RoleAssignmentScheduleRequestsOperations,
    RoleAssignmentSchedulesOperations,
    RoleAssignmentsOperations,
    RoleDefinitionsOperations,
    RoleEligibilityScheduleInstancesOperations,
    RoleEligibilityScheduleRequestsOperations,
    RoleEligibilitySchedulesOperations,
    RoleManagementPoliciesOperations,
    RoleManagementPolicyAssignmentsOperations,
    ScopeAccessReviewDefaultSettingsOperations,
    ScopeAccessReviewHistoryDefinitionInstanceOperations,
    ScopeAccessReviewHistoryDefinitionInstancesOperations,
    ScopeAccessReviewHistoryDefinitionOperations,
    ScopeAccessReviewHistoryDefinitionsOperations,
    ScopeAccessReviewInstanceContactedReviewersOperations,
    ScopeAccessReviewInstanceDecisionsOperations,
    ScopeAccessReviewInstanceOperations,
    ScopeAccessReviewInstancesOperations,
    ScopeAccessReviewScheduleDefinitionsOperations,
    TenantLevelAccessReviewInstanceContactedReviewersOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials import TokenCredential


class AuthorizationManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Role based access control provides you a way to apply granular level policy administration down
    to individual resources or resource groups. These operations enable you to manage role
    definitions and role assignments. A role definition describes the set of actions that can be
    performed on resources. A role assignment grants access to Azure Active Directory users.

    :ivar classic_administrators: ClassicAdministratorsOperations operations
    :vartype classic_administrators:
     azure.mgmt.authorization.operations.ClassicAdministratorsOperations
    :ivar global_administrator: GlobalAdministratorOperations operations
    :vartype global_administrator:
     azure.mgmt.authorization.operations.GlobalAdministratorOperations
    :ivar deny_assignments: DenyAssignmentsOperations operations
    :vartype deny_assignments: azure.mgmt.authorization.operations.DenyAssignmentsOperations
    :ivar provider_operations_metadata: ProviderOperationsMetadataOperations operations
    :vartype provider_operations_metadata:
     azure.mgmt.authorization.operations.ProviderOperationsMetadataOperations
    :ivar role_assignments: RoleAssignmentsOperations operations
    :vartype role_assignments: azure.mgmt.authorization.operations.RoleAssignmentsOperations
    :ivar permissions: PermissionsOperations operations
    :vartype permissions: azure.mgmt.authorization.operations.PermissionsOperations
    :ivar role_definitions: RoleDefinitionsOperations operations
    :vartype role_definitions: azure.mgmt.authorization.operations.RoleDefinitionsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.authorization.operations.Operations
    :ivar access_review_history_definitions: AccessReviewHistoryDefinitionsOperations operations
    :vartype access_review_history_definitions:
     azure.mgmt.authorization.operations.AccessReviewHistoryDefinitionsOperations
    :ivar access_review_history_definition: AccessReviewHistoryDefinitionOperations operations
    :vartype access_review_history_definition:
     azure.mgmt.authorization.operations.AccessReviewHistoryDefinitionOperations
    :ivar access_review_history_definition_instance:
     AccessReviewHistoryDefinitionInstanceOperations operations
    :vartype access_review_history_definition_instance:
     azure.mgmt.authorization.operations.AccessReviewHistoryDefinitionInstanceOperations
    :ivar access_review_history_definition_instances:
     AccessReviewHistoryDefinitionInstancesOperations operations
    :vartype access_review_history_definition_instances:
     azure.mgmt.authorization.operations.AccessReviewHistoryDefinitionInstancesOperations
    :ivar access_review_schedule_definitions: AccessReviewScheduleDefinitionsOperations operations
    :vartype access_review_schedule_definitions:
     azure.mgmt.authorization.operations.AccessReviewScheduleDefinitionsOperations
    :ivar access_review_instances: AccessReviewInstancesOperations operations
    :vartype access_review_instances:
     azure.mgmt.authorization.operations.AccessReviewInstancesOperations
    :ivar access_review_instance: AccessReviewInstanceOperations operations
    :vartype access_review_instance:
     azure.mgmt.authorization.operations.AccessReviewInstanceOperations
    :ivar access_review_instance_decisions: AccessReviewInstanceDecisionsOperations operations
    :vartype access_review_instance_decisions:
     azure.mgmt.authorization.operations.AccessReviewInstanceDecisionsOperations
    :ivar access_review_instance_contacted_reviewers:
     AccessReviewInstanceContactedReviewersOperations operations
    :vartype access_review_instance_contacted_reviewers:
     azure.mgmt.authorization.operations.AccessReviewInstanceContactedReviewersOperations
    :ivar access_review_default_settings: AccessReviewDefaultSettingsOperations operations
    :vartype access_review_default_settings:
     azure.mgmt.authorization.operations.AccessReviewDefaultSettingsOperations
    :ivar scope_access_review_history_definitions: ScopeAccessReviewHistoryDefinitionsOperations
     operations
    :vartype scope_access_review_history_definitions:
     azure.mgmt.authorization.operations.ScopeAccessReviewHistoryDefinitionsOperations
    :ivar scope_access_review_history_definition: ScopeAccessReviewHistoryDefinitionOperations
     operations
    :vartype scope_access_review_history_definition:
     azure.mgmt.authorization.operations.ScopeAccessReviewHistoryDefinitionOperations
    :ivar scope_access_review_history_definition_instance:
     ScopeAccessReviewHistoryDefinitionInstanceOperations operations
    :vartype scope_access_review_history_definition_instance:
     azure.mgmt.authorization.operations.ScopeAccessReviewHistoryDefinitionInstanceOperations
    :ivar scope_access_review_history_definition_instances:
     ScopeAccessReviewHistoryDefinitionInstancesOperations operations
    :vartype scope_access_review_history_definition_instances:
     azure.mgmt.authorization.operations.ScopeAccessReviewHistoryDefinitionInstancesOperations
    :ivar scope_access_review_schedule_definitions: ScopeAccessReviewScheduleDefinitionsOperations
     operations
    :vartype scope_access_review_schedule_definitions:
     azure.mgmt.authorization.operations.ScopeAccessReviewScheduleDefinitionsOperations
    :ivar scope_access_review_instances: ScopeAccessReviewInstancesOperations operations
    :vartype scope_access_review_instances:
     azure.mgmt.authorization.operations.ScopeAccessReviewInstancesOperations
    :ivar scope_access_review_instance: ScopeAccessReviewInstanceOperations operations
    :vartype scope_access_review_instance:
     azure.mgmt.authorization.operations.ScopeAccessReviewInstanceOperations
    :ivar scope_access_review_instance_decisions: ScopeAccessReviewInstanceDecisionsOperations
     operations
    :vartype scope_access_review_instance_decisions:
     azure.mgmt.authorization.operations.ScopeAccessReviewInstanceDecisionsOperations
    :ivar scope_access_review_instance_contacted_reviewers:
     ScopeAccessReviewInstanceContactedReviewersOperations operations
    :vartype scope_access_review_instance_contacted_reviewers:
     azure.mgmt.authorization.operations.ScopeAccessReviewInstanceContactedReviewersOperations
    :ivar scope_access_review_default_settings: ScopeAccessReviewDefaultSettingsOperations
     operations
    :vartype scope_access_review_default_settings:
     azure.mgmt.authorization.operations.ScopeAccessReviewDefaultSettingsOperations
    :ivar access_review_schedule_definitions_assigned_for_my_approval:
     AccessReviewScheduleDefinitionsAssignedForMyApprovalOperations operations
    :vartype access_review_schedule_definitions_assigned_for_my_approval:
     azure.mgmt.authorization.operations.AccessReviewScheduleDefinitionsAssignedForMyApprovalOperations
    :ivar access_review_instances_assigned_for_my_approval:
     AccessReviewInstancesAssignedForMyApprovalOperations operations
    :vartype access_review_instances_assigned_for_my_approval:
     azure.mgmt.authorization.operations.AccessReviewInstancesAssignedForMyApprovalOperations
    :ivar access_review_instance_my_decisions: AccessReviewInstanceMyDecisionsOperations operations
    :vartype access_review_instance_my_decisions:
     azure.mgmt.authorization.operations.AccessReviewInstanceMyDecisionsOperations
    :ivar tenant_level_access_review_instance_contacted_reviewers:
     TenantLevelAccessReviewInstanceContactedReviewersOperations operations
    :vartype tenant_level_access_review_instance_contacted_reviewers:
     azure.mgmt.authorization.operations.TenantLevelAccessReviewInstanceContactedReviewersOperations
    :ivar eligible_child_resources: EligibleChildResourcesOperations operations
    :vartype eligible_child_resources:
     azure.mgmt.authorization.operations.EligibleChildResourcesOperations
    :ivar role_assignment_schedules: RoleAssignmentSchedulesOperations operations
    :vartype role_assignment_schedules:
     azure.mgmt.authorization.operations.RoleAssignmentSchedulesOperations
    :ivar role_assignment_schedule_instances: RoleAssignmentScheduleInstancesOperations operations
    :vartype role_assignment_schedule_instances:
     azure.mgmt.authorization.operations.RoleAssignmentScheduleInstancesOperations
    :ivar role_assignment_schedule_requests: RoleAssignmentScheduleRequestsOperations operations
    :vartype role_assignment_schedule_requests:
     azure.mgmt.authorization.operations.RoleAssignmentScheduleRequestsOperations
    :ivar role_eligibility_schedules: RoleEligibilitySchedulesOperations operations
    :vartype role_eligibility_schedules:
     azure.mgmt.authorization.operations.RoleEligibilitySchedulesOperations
    :ivar role_eligibility_schedule_instances: RoleEligibilityScheduleInstancesOperations
     operations
    :vartype role_eligibility_schedule_instances:
     azure.mgmt.authorization.operations.RoleEligibilityScheduleInstancesOperations
    :ivar role_eligibility_schedule_requests: RoleEligibilityScheduleRequestsOperations operations
    :vartype role_eligibility_schedule_requests:
     azure.mgmt.authorization.operations.RoleEligibilityScheduleRequestsOperations
    :ivar role_management_policies: RoleManagementPoliciesOperations operations
    :vartype role_management_policies:
     azure.mgmt.authorization.operations.RoleManagementPoliciesOperations
    :ivar role_management_policy_assignments: RoleManagementPolicyAssignmentsOperations operations
    :vartype role_management_policy_assignments:
     azure.mgmt.authorization.operations.RoleManagementPolicyAssignmentsOperations
    :ivar alerts: AlertsOperations operations
    :vartype alerts: azure.mgmt.authorization.operations.AlertsOperations
    :ivar alert_configurations: AlertConfigurationsOperations operations
    :vartype alert_configurations:
     azure.mgmt.authorization.operations.AlertConfigurationsOperations
    :ivar alert_definitions: AlertDefinitionsOperations operations
    :vartype alert_definitions: azure.mgmt.authorization.operations.AlertDefinitionsOperations
    :ivar alert_incidents: AlertIncidentsOperations operations
    :vartype alert_incidents: azure.mgmt.authorization.operations.AlertIncidentsOperations
    :ivar alert_operation: AlertOperationOperations operations
    :vartype alert_operation: azure.mgmt.authorization.operations.AlertOperationOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "TokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = AuthorizationManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, credential_scopes=credential_scopes, **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=cast(str, base_url), policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.classic_administrators = ClassicAdministratorsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.global_administrator = GlobalAdministratorOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.deny_assignments = DenyAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.provider_operations_metadata = ProviderOperationsMetadataOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.role_assignments = RoleAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.permissions = PermissionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.role_definitions = RoleDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.access_review_history_definitions = AccessReviewHistoryDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_history_definition = AccessReviewHistoryDefinitionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_history_definition_instance = AccessReviewHistoryDefinitionInstanceOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_history_definition_instances = AccessReviewHistoryDefinitionInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_schedule_definitions = AccessReviewScheduleDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_instances = AccessReviewInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_instance = AccessReviewInstanceOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_instance_decisions = AccessReviewInstanceDecisionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_instance_contacted_reviewers = AccessReviewInstanceContactedReviewersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_default_settings = AccessReviewDefaultSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_history_definitions = ScopeAccessReviewHistoryDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_history_definition = ScopeAccessReviewHistoryDefinitionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_history_definition_instance = ScopeAccessReviewHistoryDefinitionInstanceOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_history_definition_instances = ScopeAccessReviewHistoryDefinitionInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_schedule_definitions = ScopeAccessReviewScheduleDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_instances = ScopeAccessReviewInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_instance = ScopeAccessReviewInstanceOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_instance_decisions = ScopeAccessReviewInstanceDecisionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_instance_contacted_reviewers = ScopeAccessReviewInstanceContactedReviewersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.scope_access_review_default_settings = ScopeAccessReviewDefaultSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_schedule_definitions_assigned_for_my_approval = (
            AccessReviewScheduleDefinitionsAssignedForMyApprovalOperations(
                self._client, self._config, self._serialize, self._deserialize
            )
        )
        self.access_review_instances_assigned_for_my_approval = AccessReviewInstancesAssignedForMyApprovalOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.access_review_instance_my_decisions = AccessReviewInstanceMyDecisionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.tenant_level_access_review_instance_contacted_reviewers = (
            TenantLevelAccessReviewInstanceContactedReviewersOperations(
                self._client, self._config, self._serialize, self._deserialize
            )
        )
        self.eligible_child_resources = EligibleChildResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.role_assignment_schedules = RoleAssignmentSchedulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.role_assignment_schedule_instances = RoleAssignmentScheduleInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.role_assignment_schedule_requests = RoleAssignmentScheduleRequestsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.role_eligibility_schedules = RoleEligibilitySchedulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.role_eligibility_schedule_instances = RoleEligibilityScheduleInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.role_eligibility_schedule_requests = RoleEligibilityScheduleRequestsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.role_management_policies = RoleManagementPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.role_management_policy_assignments = RoleManagementPolicyAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.alerts = AlertsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.alert_configurations = AlertConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.alert_definitions = AlertDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.alert_incidents = AlertIncidentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.alert_operation = AlertOperationOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
