# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class SubscribeRulesTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.video.v1.rooms("RMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .participants("PAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .subscribe_rules.fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://video.twilio.com/v1/Rooms/RMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Participants/PAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/SubscribeRules',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "participant_sid": "PAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "room_sid": "RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": null,
                "date_updated": null,
                "rules": [
                    {
                        "type": "include",
                        "all": true,
                        "publisher": null,
                        "track": null,
                        "kind": null,
                        "priority": null
                    }
                ]
            }
            '''
        ))

        actual = self.client.video.v1.rooms("RMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .participants("PAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .subscribe_rules.fetch()

        self.assertIsNotNone(actual)

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.video.v1.rooms("RMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .participants("PAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .subscribe_rules.update()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://video.twilio.com/v1/Rooms/RMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Participants/PAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/SubscribeRules',
        ))

    def test_update_filters_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "participant_sid": "PAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "room_sid": "RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": null,
                "date_updated": null,
                "rules": [
                    {
                        "type": "exclude",
                        "all": true,
                        "publisher": null,
                        "track": null,
                        "kind": null,
                        "priority": null
                    }
                ]
            }
            '''
        ))

        actual = self.client.video.v1.rooms("RMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .participants("PAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .subscribe_rules.update()

        self.assertIsNotNone(actual)
