# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class ConferenceParticipantTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.insights.v1.conferences("CFXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                   .conference_participants("CPXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://insights.twilio.com/v1/Conferences/CFXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Participants/CPXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "participant_sid": "CPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "label": null,
                "conference_sid": "CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "call_sid": "CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "call_direction": "outbound",
                "from": "+10000000000",
                "to": "+1000000001",
                "call_status": "completed",
                "country_code": "US",
                "is_moderator": true,
                "join_time": "2021-10-08T02:58:59Z",
                "leave_time": "2021-10-08T03:00:02Z",
                "duration_seconds": 64,
                "outbound_queue_length": 0,
                "outbound_time_in_queue": 965,
                "jitter_buffer_size": null,
                "is_coach": false,
                "coached_participants": null,
                "participant_region": "us1",
                "conference_region": "us1",
                "call_type": "carrier",
                "processing_state": "complete",
                "properties": {
                    "start_conference_on_enter": false,
                    "end_conference_on_exit": false,
                    "play_early_media": false,
                    "enter_muted": true,
                    "beep_on_enter": false,
                    "beep_on_exit": false
                },
                "events": {
                    "mute": [
                        1633705131000
                    ]
                },
                "metrics": {
                    "inbound": {
                        "total_packets_lost": 0,
                        "total_packets_received": 49,
                        "packet_loss_percentage": 0.0,
                        "jitter": {
                            "avg": 0.34,
                            "max": 0.53
                        },
                        "latency": {
                            "avg": 0.0,
                            "max": 0.0
                        },
                        "mos": 4.4
                    },
                    "outbound": {
                        "total_packets_lost": 0,
                        "total_packets_received": 126,
                        "packet_loss_percentage": 0,
                        "jitter": {
                            "avg": 0.01,
                            "max": 0.01
                        },
                        "latency": {
                            "avg": 0,
                            "max": 0
                        },
                        "mos": 4.4
                    }
                },
                "url": "https://insights.twilio.com/v1/Conferences/CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Participants/CPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.insights.v1.conferences("CFXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .conference_participants("CPXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.insights.v1.conferences("CFXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                   .conference_participants.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://insights.twilio.com/v1/Conferences/CFXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Participants',
        ))

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 25,
                    "first_page_url": "https://insights.twilio.com/v1/Conferences/CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Participants?PageSize=25&Page=0",
                    "previous_page_url": null,
                    "url": "https://insights.twilio.com/v1/Conferences/CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Participants?PageSize=25&Page=0",
                    "next_page_url": null,
                    "key": "participants"
                },
                "participants": [
                    {
                        "participant_sid": "CPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "label": null,
                        "conference_sid": "CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "call_sid": "CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "call_direction": "outbound",
                        "from": "+10000000000",
                        "to": "+10000000001",
                        "call_status": "completed",
                        "country_code": "US",
                        "is_moderator": true,
                        "join_time": "2021-10-08T02:58:51Z",
                        "leave_time": "2021-10-08T02:59:55Z",
                        "duration_seconds": 65,
                        "outbound_queue_length": 0,
                        "outbound_time_in_queue": 3361,
                        "jitter_buffer_size": null,
                        "is_coach": false,
                        "coached_participants": null,
                        "participant_region": "us1",
                        "conference_region": "us1",
                        "call_type": "carrier",
                        "processing_state": "complete",
                        "properties": {
                            "start_conference_on_enter": true,
                            "end_conference_on_exit": false,
                            "play_early_media": true,
                            "enter_muted": false,
                            "beep_on_enter": false,
                            "beep_on_exit": false
                        },
                        "metrics": {
                            "inbound": {
                                "total_packets_lost": 0,
                                "total_packets_received": 70,
                                "packet_loss_percentage": 0.0,
                                "jitter": {
                                    "avg": 0.41,
                                    "max": 0.84
                                },
                                "latency": {
                                    "avg": 0.0,
                                    "max": 0.0
                                },
                                "mos": 4.4
                            },
                            "outbound": {
                                "total_packets_lost": 0,
                                "total_packets_received": 126,
                                "packet_loss_percentage": 0,
                                "jitter": {
                                    "avg": 0.01,
                                    "max": 0.01
                                },
                                "latency": {
                                    "avg": 0,
                                    "max": 0
                                },
                                "mos": 4.4
                            }
                        },
                        "events": null,
                        "url": "https://insights.twilio.com/v1/Conferences/CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Participants/CPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    },
                    {
                        "participant_sid": "CPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab",
                        "label": null,
                        "conference_sid": "CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "call_sid": "CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "call_direction": "outbound",
                        "from": "+10000000000",
                        "to": "+10000000002",
                        "call_status": "completed",
                        "country_code": "US",
                        "is_moderator": true,
                        "join_time": "2021-10-08T02:58:52Z",
                        "leave_time": "2021-10-08T02:59:54Z",
                        "duration_seconds": 63,
                        "outbound_queue_length": 0,
                        "outbound_time_in_queue": 321,
                        "jitter_buffer_size": null,
                        "is_coach": false,
                        "coached_participants": null,
                        "participant_region": "us1",
                        "conference_region": "us1",
                        "call_type": "carrier",
                        "processing_state": "complete",
                        "properties": {
                            "start_conference_on_enter": false,
                            "end_conference_on_exit": false,
                            "early_media": false,
                            "enter_muted": true,
                            "beep_on_enter": false,
                            "beep_on_exit": false
                        },
                        "metrics": {
                            "inbound": {
                                "total_packets_lost": 0,
                                "total_packets_received": 16,
                                "packet_loss_percentage": 0,
                                "jitter": {
                                    "avg": 0.26,
                                    "max": 0.45
                                },
                                "latency": {
                                    "avg": 0,
                                    "max": 0
                                },
                                "mos": 4.4
                            },
                            "outbound": {
                                "total_packets_lost": 0,
                                "total_packets_received": 42,
                                "packet_loss_percentage": 0,
                                "jitter": {
                                    "avg": 0.03,
                                    "max": 0.08
                                },
                                "latency": {
                                    "avg": 0,
                                    "max": 0
                                },
                                "mos": 4.4,
                                "tags": [
                                    "silent"
                                ]
                            }
                        },
                        "events": {
                            "mute": [
                                1633705131000
                            ]
                        },
                        "url": "https://insights.twilio.com/v1/Conferences/CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Participants/CPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab"
                    }
                ]
            }
            '''
        ))

        actual = self.client.insights.v1.conferences("CFXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .conference_participants.list()

        self.assertIsNotNone(actual)

    def test_read_with_label_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 25,
                    "first_page_url": "https://insights.twilio.com/v1/Conferences/CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Participants?Label=client&PageSize=25&Page=0",
                    "previous_page_url": null,
                    "url": "https://insights.twilio.com/v1/Conferences/CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Participants?Label=client&PageSize=25&Page=0",
                    "next_page_url": null,
                    "key": "participants"
                },
                "participants": [
                    {
                        "participant_sid": "CPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "conference_sid": "CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "call_sid": "CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "call_direction": "outbound",
                        "from": "+10000000000",
                        "to": "+10000000001",
                        "call_status": "completed",
                        "country_code": "US",
                        "is_moderator": true,
                        "join_time": "2021-10-08T02:58:51Z",
                        "leave_time": "2021-10-08T02:59:55Z",
                        "duration_seconds": 65,
                        "label": "client",
                        "outbound_queue_length": 0,
                        "outbound_time_in_queue": 3361,
                        "jitter_buffer_size": null,
                        "is_coach": false,
                        "coached_participants": null,
                        "participant_region": "us1",
                        "conference_region": "us1",
                        "call_type": "carrier",
                        "processing_state": "complete",
                        "properties": {
                            "start_conference_on_enter": true,
                            "end_conference_on_exit": false,
                            "play_early_media": true,
                            "enter_muted": false,
                            "beep_on_enter": false,
                            "beep_on_exit": false
                        },
                        "metrics": {
                            "inbound": {
                                "total_packets_lost": 0,
                                "total_packets_received": 70,
                                "packet_loss_percentage": 0.0,
                                "jitter": {
                                    "avg": 0.41,
                                    "max": 0.84
                                },
                                "latency": {
                                    "avg": 0.0,
                                    "max": 0.0
                                },
                                "mos": 4.4
                            },
                            "outbound": {
                                "total_packets_lost": 0,
                                "total_packets_received": 96,
                                "packet_loss_percentage": 0,
                                "jitter": {
                                    "avg": 0.01,
                                    "max": 0.01
                                },
                                "latency": {
                                    "avg": 0,
                                    "max": 0
                                },
                                "mos": 4.4
                            }
                        },
                        "events": null,
                        "url": "https://insights.twilio.com/v1/Conferences/CFaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Participants/CPaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ]
            }
            '''
        ))

        actual = self.client.insights.v1.conferences("CFXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .conference_participants.list()

        self.assertIsNotNone(actual)
