/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "backends/keymapper/standard-actions.h"

namespace Common {

const char *kStandardActionLeftClick     = "LCLK";
const char *kStandardActionMiddleClick   = "MCLK";
const char *kStandardActionRightClick    = "RCLK";
const char *kStandardActionInteract      = "INTRCT";
const char *kStandardActionSkip          = "SKIP";
const char *kStandardActionPause         = "PAUSE";
const char *kStandardActionMoveUp        = "UP";
const char *kStandardActionMoveDown      = "DOWN";
const char *kStandardActionMoveLeft      = "LEFT";
const char *kStandardActionMoveRight     = "RIGHT";
const char *kStandardActionOpenMainMenu  = "MENU";
const char *kStandardActionLoad          = "LOAD";
const char *kStandardActionSave          = "SAVE";
const char *kStandardActionOpenSettings  = "OPTS";
const char *kStandardActionEE            = "WTF";

} //namespace Common
