/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_04 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 2426, "epsg", 2426,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 87E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",87],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "2426\"]]");
    p = add_epsg_def_ex (filter, first, last, 2427, "epsg", 2427,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 90E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 90E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",90],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "2427\"]]");
    p = add_epsg_def_ex (filter, first, last, 2428, "epsg", 2428,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 93E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",93],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "2428\"]]");
    p = add_epsg_def_ex (filter, first, last, 2429, "epsg", 2429,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 96E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 96E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",96],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "2429\"]]");
    p = add_epsg_def_ex (filter, first, last, 2430, "epsg", 2430,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 99E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",99],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "2430\"]]");
    p = add_epsg_def_ex (filter, first, last, 2431, "epsg", 2431,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 102E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 102E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",102],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2431\"]]");
    p = add_epsg_def_ex (filter, first, last, 2432, "epsg", 2432,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 105E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",105],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2432\"]]");
    p = add_epsg_def_ex (filter, first, last, 2433, "epsg", 2433,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 108E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 108E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",108],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2433\"]]");
    p = add_epsg_def_ex (filter, first, last, 2434, "epsg", 2434,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 111E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",111],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2434\"]]");
    p = add_epsg_def_ex (filter, first, last, 2435, "epsg", 2435,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 114E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 114E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",114],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2435\"]]");
    p = add_epsg_def_ex (filter, first, last, 2436, "epsg", 2436,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 117E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",117],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2436\"]]");
    p = add_epsg_def_ex (filter, first, last, 2437, "epsg", 2437,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 120E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 120E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",120],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2437\"]]");
    p = add_epsg_def_ex (filter, first, last, 2438, "epsg", 2438,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 123E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",123],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2438\"]]");
    p = add_epsg_def_ex (filter, first, last, 2439, "epsg", 2439,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 126E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 126E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",126],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2439\"]]");
    p = add_epsg_def_ex (filter, first, last, 2440, "epsg", 2440,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 129E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",129],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2440\"]]");
    p = add_epsg_def_ex (filter, first, last, 2441, "epsg", 2441,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 132E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 132E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",132],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2441\"]]");
    p = add_epsg_def_ex (filter, first, last, 2442, "epsg", 2442,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 135E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4214\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",135],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"2442\"]]");
    p = add_epsg_def_ex (filter, first, last, 2443, "epsg", 2443,
        "JGD2000 / Japan Plane Rectangular CS I", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS I\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",129.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2443\"]]");
    p = add_epsg_def_ex (filter, first, last, 2444, "epsg", 2444,
        "JGD2000 / Japan Plane Rectangular CS II", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS II\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",131],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"2444\"]]");
    p = add_epsg_def_ex (filter, first, last, 2445, "epsg", 2445,
        "JGD2000 / Japan Plane Rectangular CS III", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS III\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",132.166666666667],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2445\"]]");
    p = add_epsg_def_ex (filter, first, last, 2446, "epsg", 2446,
        "JGD2000 / Japan Plane Rectangular CS IV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS IV\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",133.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2446\"]]");
    p = add_epsg_def_ex (filter, first, last, 2447, "epsg", 2447,
        "JGD2000 / Japan Plane Rectangular CS V", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS V\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",134.333333333333],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"2447\"]]");
    p = add_epsg_def_ex (filter, first, last, 2448, "epsg", 2448,
        "JGD2000 / Japan Plane Rectangular CS VI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS VI\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",136],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"2448\"]]");
    p = add_epsg_def_ex (filter, first, last, 2449, "epsg", 2449,
        "JGD2000 / Japan Plane Rectangular CS VII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS VII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",137.166666666667],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2449\"]]");
    p = add_epsg_def_ex (filter, first, last, 2450, "epsg", 2450,
        "JGD2000 / Japan Plane Rectangular CS VIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS VIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",138.5],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"2450\"]]");
    p = add_epsg_def_ex (filter, first, last, 2451, "epsg", 2451,
        "JGD2000 / Japan Plane Rectangular CS IX", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS IX\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",139.833333333333],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"2451\"]]");
    p = add_epsg_def_ex (filter, first, last, 2452, "epsg", 2452,
        "JGD2000 / Japan Plane Rectangular CS X", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS X\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",140.833333333333],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"2452\"]]");
    p = add_epsg_def_ex (filter, first, last, 2453, "epsg", 2453,
        "JGD2000 / Japan Plane Rectangular CS XI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XI\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",140.25],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"2453\"]]");
    p = add_epsg_def_ex (filter, first, last, 2454, "epsg", 2454,
        "JGD2000 / Japan Plane Rectangular CS XII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",142.25],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"2454\"]]");
    p = add_epsg_def_ex (filter, first, last, 2455, "epsg", 2455,
        "JGD2000 / Japan Plane Rectangular CS XIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",144.25],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"2455\"]]");
    p = add_epsg_def_ex (filter, first, last, 2456, "epsg", 2456,
        "JGD2000 / Japan Plane Rectangular CS XIV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XIV\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",142],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2456\"]]");
    p = add_epsg_def_ex (filter, first, last, 2457, "epsg", 2457,
        "JGD2000 / Japan Plane Rectangular CS XV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XV\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",127.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2457\"]]");
    p = add_epsg_def_ex (filter, first, last, 2458, "epsg", 2458,
        "JGD2000 / Japan Plane Rectangular CS XVI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XVI\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",124],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2458\"]]");
    p = add_epsg_def_ex (filter, first, last, 2459, "epsg", 2459,
        "JGD2000 / Japan Plane Rectangular CS XVII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XVII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",131],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"2459\"]]");
    p = add_epsg_def_ex (filter, first, last, 2460, "epsg", 2460,
        "JGD2000 / Japan Plane Rectangular CS XVIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XVIII\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",20],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",136],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"2460\"]]");
    p = add_epsg_def_ex (filter, first, last, 2461, "epsg", 2461,
        "JGD2000 / Japan Plane Rectangular CS XIX", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2000 / Japan Plane Rectangular CS XIX\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4612\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",154],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2461\"]]");
    p = add_epsg_def_ex (filter, first, last, 2462, "epsg", 2462,
        "Albanian 1987 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Albanian_1987", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=-44.183,-0.58,-38.489,2.3867,2.707");
    add_proj4text (p, 2,
        "2,-3.5196,-8.2703 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Albanian 1987 / Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Albanian 1987\",DATUM[\"Albanian_1987\",SPHEROID[\"Krass");
    add_srs_wkt (p, 2,
        "owsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6191\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4191\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",21],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2462");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2463, "epsg", 2463,
        "Pulkovo 1995 / Gauss-Kruger CM 21E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 21E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2463\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2464, "epsg", 2464,
        "Pulkovo 1995 / Gauss-Kruger CM 27E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 27E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2464\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2465, "epsg", 2465,
        "Pulkovo 1995 / Gauss-Kruger CM 33E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 33E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2465\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2466, "epsg", 2466,
        "Pulkovo 1995 / Gauss-Kruger CM 39E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 39E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2466\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2467, "epsg", 2467,
        "Pulkovo 1995 / Gauss-Kruger CM 45E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 45E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2467\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2468, "epsg", 2468,
        "Pulkovo 1995 / Gauss-Kruger CM 51E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 51E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2468\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2469, "epsg", 2469,
        "Pulkovo 1995 / Gauss-Kruger CM 57E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 57E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2469\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2470, "epsg", 2470,
        "Pulkovo 1995 / Gauss-Kruger CM 63E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 63E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2470\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2471, "epsg", 2471,
        "Pulkovo 1995 / Gauss-Kruger CM 69E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 69E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2471\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2472, "epsg", 2472,
        "Pulkovo 1995 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 75E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2472\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2473, "epsg", 2473,
        "Pulkovo 1995 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 81E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2473\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2474, "epsg", 2474,
        "Pulkovo 1995 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 87E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2474\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2475, "epsg", 2475,
        "Pulkovo 1995 / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 93E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2475\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2476, "epsg", 2476,
        "Pulkovo 1995 / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 99E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2476\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2477, "epsg", 2477,
        "Pulkovo 1995 / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2477\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2478, "epsg", 2478,
        "Pulkovo 1995 / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2478\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2479, "epsg", 2479,
        "Pulkovo 1995 / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2479\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2480, "epsg", 2480,
        "Pulkovo 1995 / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2480\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2481, "epsg", 2481,
        "Pulkovo 1995 / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2481\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2482, "epsg", 2482,
        "Pulkovo 1995 / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2482\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2483, "epsg", 2483,
        "Pulkovo 1995 / Gauss-Kruger CM 141E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 141E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2483\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2484, "epsg", 2484,
        "Pulkovo 1995 / Gauss-Kruger CM 147E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 147E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2484\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2485, "epsg", 2485,
        "Pulkovo 1995 / Gauss-Kruger CM 153E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 153E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2485\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2486, "epsg", 2486,
        "Pulkovo 1995 / Gauss-Kruger CM 159E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 159E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2486\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2487, "epsg", 2487,
        "Pulkovo 1995 / Gauss-Kruger CM 165E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 165E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2487\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2488, "epsg", 2488,
        "Pulkovo 1995 / Gauss-Kruger CM 171E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 171E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2488\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2489, "epsg", 2489,
        "Pulkovo 1995 / Gauss-Kruger CM 177E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 177E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2489\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2490, "epsg", 2490,
        "Pulkovo 1995 / Gauss-Kruger CM 177W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 177W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2490\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2491, "epsg", 2491,
        "Pulkovo 1995 / Gauss-Kruger CM 171W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 171W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2491\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2492, "epsg", 2492,
        "Pulkovo 1942 / Gauss-Kruger CM 9E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +e");
    add_proj4text (p, 1,
        "llps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.1");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 9E (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"2492\"]]");
    p = add_epsg_def_ex (filter, first, last, 2493, "epsg", 2493,
        "Pulkovo 1942 / Gauss-Kruger CM 15E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 15E (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"2493\"]]");
    p = add_epsg_def_ex (filter, first, last, 2494, "epsg", 2494,
        "Pulkovo 1942 / Gauss-Kruger CM 21E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 21E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2494\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2495, "epsg", 2495,
        "Pulkovo 1942 / Gauss-Kruger CM 27E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 27E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2495\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2496, "epsg", 2496,
        "Pulkovo 1942 / Gauss-Kruger CM 33E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 33E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2496\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2497, "epsg", 2497,
        "Pulkovo 1942 / Gauss-Kruger CM 39E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 39E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2497\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2498, "epsg", 2498,
        "Pulkovo 1942 / Gauss-Kruger CM 45E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 45E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2498\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2499, "epsg", 2499,
        "Pulkovo 1942 / Gauss-Kruger CM 51E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 51E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2499\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2500, "epsg", 2500,
        "Pulkovo 1942 / Gauss-Kruger CM 57E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 57E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2500\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2501, "epsg", 2501,
        "Pulkovo 1942 / Gauss-Kruger CM 63E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 63E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2501\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2502, "epsg", 2502,
        "Pulkovo 1942 / Gauss-Kruger CM 69E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 69E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2502\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2503, "epsg", 2503,
        "Pulkovo 1942 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 75E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2503\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2504, "epsg", 2504,
        "Pulkovo 1942 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 81E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2504\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2505, "epsg", 2505,
        "Pulkovo 1942 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 87E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2505\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2506, "epsg", 2506,
        "Pulkovo 1942 / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 93E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2506\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2507, "epsg", 2507,
        "Pulkovo 1942 / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 99E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2507\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2508, "epsg", 2508,
        "Pulkovo 1942 / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2508\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2509, "epsg", 2509,
        "Pulkovo 1942 / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2509\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2510, "epsg", 2510,
        "Pulkovo 1942 / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2510\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2511, "epsg", 2511,
        "Pulkovo 1942 / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2511\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2512, "epsg", 2512,
        "Pulkovo 1942 / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2512\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2513, "epsg", 2513,
        "Pulkovo 1942 / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2513\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2514, "epsg", 2514,
        "Pulkovo 1942 / Gauss-Kruger CM 141E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 141E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2514\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2515, "epsg", 2515,
        "Pulkovo 1942 / Gauss-Kruger CM 147E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 147E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2515\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2516, "epsg", 2516,
        "Pulkovo 1942 / Gauss-Kruger CM 153E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 153E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2516\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2517, "epsg", 2517,
        "Pulkovo 1942 / Gauss-Kruger CM 159E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 159E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2517\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2518, "epsg", 2518,
        "Pulkovo 1942 / Gauss-Kruger CM 165E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 165E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2518\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2519, "epsg", 2519,
        "Pulkovo 1942 / Gauss-Kruger CM 171E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 171E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2519\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2520, "epsg", 2520,
        "Pulkovo 1942 / Gauss-Kruger CM 177E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 177E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2520\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2521, "epsg", 2521,
        "Pulkovo 1942 / Gauss-Kruger CM 177W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 177W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2521\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2522, "epsg", 2522,
        "Pulkovo 1942 / Gauss-Kruger CM 171W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 171W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2522\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2523, "epsg", 2523,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 7\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",21],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",7500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"2523\"]]");
    p = add_epsg_def_ex (filter, first, last, 2524, "epsg", 2524,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 8\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",24],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",8500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"2524\"]]");
    p = add_epsg_def_ex (filter, first, last, 2525, "epsg", 2525,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 9\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",27],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",9500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"2525\"]]");
    p = add_epsg_def_ex (filter, first, last, 2526, "epsg", 2526,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 10\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",30],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",10500000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"2526\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

