---
title: Plugin: Genesys Logic
---

## Introduction

This plugin allows updating the Genesys Logic USB Hub devices.

* GL3521
* GL3523
* GL3525
* GL3590

Additionally, this plugin allows updating the MStar Semiconductor Scaler connected via an I²C bus.

* TSUM G

## Firmware Format

The daemon will decompress the cabinet archives and extract the firmware blob in an unspecified binary file format.

This plugin supports the following protocol IDs:

* `com.genesys.usbhub`
* `com.mstarsemi.scaler`

## GUID Generation

These devices use the standard USB DeviceInstanceId values for the USB Hub, e.g.

* `USB\VID_05E3&PID_0610` (quirk-only)

These devices use the standard USB DeviceInstanceId values for the HID under USB hub, e.g.

* `USB\VID_05E3&PID_0102` (quirk-only)

Additionally, some customized instance IDs are added. e.g.

* `USB\VID_03F0&PID_0610&IC_352330&BONDING_0F`
* `USB\VID_03F0&PID_0610&IC_352330&BONDING_0F&RUNMODE_M`
* `USB\VID_03F0&PID_0610&VENDOR_GENESYSLOGIC&IC_352330&BONDING_0F&PORTNUM_23&VENDORSUP_C09B5DD3-1A23-51D2-995A-F7366AAB3CA4`
* `USB\VID_05E3&PID_0630&PROJECT_1885D34D-0418-5EF8-8E69-4CEF77B6B6E8`
* `USB\VID_03F0&PID_0610&PUBKEY_AB859399-95B8-5817-B521-9AD8CC7F5BD6`

These devices also use custom GUID values for the Scaler, e.g.

* `GENESYS_SCALER\MSTAR_TSUM_G&PUBKEY_B335BDCE-7073-5D0E-9BD3-9B69C1A6899F&PANELREV_RIM101`

The Public Key is product-specific and is required to identify the product.

## Quirk Use

This plugin uses the following plugin-specific quirks:

### `Flags=has-mstar-scaler`

USB Hub has a MStar Semiconductor Scaler attached via I²C.

Since 1.7.6.

### `Flags=has-public-key`

Device has a public-key appended to firmware.

Since 1.8.0

### `Flags=pause-r2-cpu`

Pause R2 CPU.

Since 1.7.6

### `Flags=use-i2c-ch0`

Use I2C ch0.

Since 1.7.6

### GenesysUsbhubSwitchRequest

USB Hub Switch Request value.

* HP Mxfd FHD Monitors: `0xA1`

Since 1.7.6.

### GenesysUsbhubReadRequest

USB Hub Read Request value.

* HP Mxfd FHD Monitors: `0xA2`

Since 1.7.6.

### GenesysUsbhubWriteRequest

USB Hub Write Request value.

* HP Mxfd FHD Monitors: `0xA3`

Since 1.7.6.

### GenesysScalerDeviceTransferSize

Scaler Block size to use for transfers.

* MStar Semiconductor TSUM G: `0x40`

Since 1.7.6.

### GenesysScalerGpioOutputRegister

Scaler GPIO Output Register value.

* MStar Semiconductor TSUM G: `0x0426`

Since 1.7.6.

### GenesysScalerGpioEnableRegister

Scaler GPIO Enable Register value.

* MStar Semiconductor TSUM G: `0x0428`

Since 1.7.6.

### GenesysScalerGpioValue

Scaler GPIO value.

* MStar Semiconductor TSUM G: `0x01`

Since 1.7.6.

### GenesysScalerCfiFlashId

CFI Flash Id.

* HP M24fd USB-C Monitor: `0xC22016`
* HP M27fd USB-C Monitor: `0xC84016`

Since 1.8.2.

## Firmware Bank Quirk Use

These parameters are used to configure and manage Genesys firmware banks.

This plugin uses the following plugin-specific quirks to indicate firmware bank detail:

### GenesysSupportDualBank

Indicates if dual-bank support is enabled.

Since 2.0.17

### GenesysSupportCodeSize

Indicatess if code size support is enabled.

Since 2.0.17

### GenesysHubBank1Address / GenesysHubBank2Address

Memory addresses for Hub bank 1 and 2.

Since 2.0.17

### GenesysHubBankCapacity

Capacity of the Hub bank.

Since 2.0.17

### GenesysDevBank1Address / GenesysDevBank2Address

Memory addresses for Device bank 1 and 2.

Since 2.0.17

### GenesysDevBankCapacity

Capacity of the Device bank.

Since 2.0.17

### GenesysPdBank1Address / GenesysPdBank2Address

Memory addresses for PD bank 1 and 2.

Since 2.0.17

### GenesysPdBankCapacity

Capacity of the PD bank.

Since 2.0.17

### GenesysCodesignBank1Address / GenesysCodesignBank2Address

Memory addresses for Codesign bank 1 and 2.

Since 2.0.17

### GenesysCodesignBankCapacity

Capacity of the Codesign bank.

Since 2.0.17

### GenesysFwDataMaxCount

Maximum count of firmware data.

Since 2.0.17

## Update Behavior

The devices are independently updated at runtime using USB control transfers.

The firmware is deployed when the device is in normal runtime mode, and the device will reset when the new firmware has been written.

The HP Mxfd FHD Monitors must be connected to host via the USB-C cable to apply an update. The devices remain functional during the update; the Scaler update is ~10 minute long.

## Vendor ID Security

The vendor ID is set from the USB vendor, for example set to `USB:0x03F0` for HP.

## External Interface Access

This plugin requires read/write access to `/dev/bus/usb`.

## Version Considerations

This plugin has been available since fwupd version `1.7.6`.

## Owners

Anyone can submit a pull request to modify this plugin, but the following people should be
consulted before making major or functional changes:

* Adam Chen: @adamgene
