/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util.iterator;

import java.util.Iterator;
import java.util.Random;
import org.apache.jena.util.iterator.WrappedIterator;

public class RandomOrderIterator<T>
extends WrappedIterator<T> {
    private Random rnd = new Random();
    private Object[] buffer;
    int top;

    public RandomOrderIterator(int sz, Iterator<T> base) {
        super(base);
        this.buffer = new Object[sz];
        this.top = 0;
        this.fill();
    }

    @Override
    public boolean hasNext() {
        return this.top > 0;
    }

    @Override
    public T next() {
        int ix = this.rnd.nextInt(this.top);
        Object rslt = this.buffer[ix];
        --this.top;
        this.buffer[ix] = this.buffer[this.top];
        this.fill();
        Object obj = rslt;
        return (T)obj;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("randomizing does not allow modification");
    }

    private void fill() {
        while (this.top < this.buffer.length && super.hasNext()) {
            this.buffer[this.top++] = super.next();
        }
    }
}

