# 0.0.13

**Version:** 0.0.13
**Published:** 2022-04-02T12:16:39Z

## Release Notes

This is a big release with 276 new PR's merged!

The highlights of this release are:
* Mininum supported Rust version is now 1.54.
* Many improvements and fixes in many utils. In particular, `cp`, `dd`, `df`, `split` and `tr` have gotten very large improvements and are much more compatible with GNU.
* [Online user documentation](https://uutils.github.io/coreutils-docs/user/) featuring installation instructions, descriptions, flags, options and examples.
* We now use `clap` 3, which gives the `--help` output a new look and enables abbreviations of long arguments. For example:
```sh
ls --color    # already worked pre 0.0.13
ls --col      # any unambiguous shorthand now also works
```

## Changes
The PR's listed below change the user-facing behaviour of the utils. It is just a small selection of all the contributions in this release.

General
* Clap 3 by @tertsdiepraam in https://github.com/uutils/coreutils/pull/2863
* Infer unambiguous long arguments in clap by @tertsdiepraam in https://github.com/uutils/coreutils/pull/2936
* User documentation by @tertsdiepraam in https://github.com/uutils/coreutils/pull/2897, https://github.com/uutils/coreutils/pull/3152, https://github.com/uutils/coreutils/pull/3134
* Include license text in all published crates by @davide125 in https://github.com/uutils/coreutils/pull/3131

`uucore`
* Allow backup suffix with hyphen value by @tertsdiepraam in https://github.com/uutils/coreutils/pull/2997
* Error on negative interval in `parse_time::from_str()` by @jfinkels in https://github.com/uutils/coreutils/pull/3292
* No uppercase suffixes in `parse_time` by @jfinkels in https://github.com/uutils/coreutils/pull/3315
* Don't panic when canonicalizing a nonexistent path by @water-ghosts in https://github.com/uutils/coreutils/pull/3103
* Fix `parse_size` to use u64 rather than usize for better 32-bit support by @omertuc in https://github.com/uutils/coreutils/pull/3084

`cp`
* Override args instead of having them conflict by @tertsdiepraam in https://github.com/uutils/coreutils/pull/2998
* Avoid following a destination symlink with `-P` by @refi64 in https://github.com/uutils/coreutils/pull/3101
* Create backup before hardlink by @water-ghosts in https://github.com/uutils/coreutils/pull/3033
* Fail when copying a directory to a file by @water-ghosts in https://github.com/uutils/coreutils/pull/3044
* Only allow directory for `-t` by @shoriminimoe in https://github.com/uutils/coreutils/pull/3027
* Support copying FIFOs with `-r` by @water-ghosts in https://github.com/uutils/coreutils/pull/3032
* Don't panic when calling `cp -a` with a nonexistent file by @water-ghosts in https://github.com/uutils/coreutils/pull/2960
* Avoid infinite recursion when source and destinations are same while using `cp -R` by @Narasimha1997 in https://github.com/uutils/coreutils/pull/3018

`dd`
* block/unblock on ebcdic/ascii conversions by @jfinkels in https://github.com/uutils/coreutils/pull/2909
* Correct behavior when status=noxfer by @jfinkels in https://github.com/uutils/coreutils/pull/2915
* Support `seek=N` when destination is stdout by @jfinkels in https://github.com/uutils/coreutils/pull/2911
* Add support for 'b' and 'x' multipliers in numeric arguments by @jfinkels in https://github.com/uutils/coreutils/pull/3028
* Allow multiple instances of arguments by @iovanom in https://github.com/uutils/coreutils/pull/3021
* Correct order and phrasing of truncated record by @jfinkels in https://github.com/uutils/coreutils/pull/3154
* Correctly account for partial record written by @jfinkels in https://github.com/uutils/coreutils/pull/3129
* Create ConversionMode to simplify conversion, blocking, and unblocking by @jfinkels in https://github.com/uutils/coreutils/pull/3293
* Don't error when outfile is /dev/null by @jfinkels in https://github.com/uutils/coreutils/pull/3148
* Implement iseek + oseek flags by @chordtoll in https://github.com/uutils/coreutils/pull/3256
* Make `status=progress` rewrite once/sec by @ndd7xv in https://github.com/uutils/coreutils/pull/3078
* Pad partial record with spaces in some cases by @jfinkels in https://github.com/uutils/coreutils/pull/3156
* Remove spurious zero multiplier warning by @jfinkels in https://github.com/uutils/coreutils/pull/3128
* Show warning if skipping past end of input by @jfinkels in https://github.com/uutils/coreutils/pull/3066
* Show warning when using 0x size multiplier by @jfinkels in https://github.com/uutils/coreutils/pull/3085
* Truncate to specified seek length by @jfinkels in https://github.com/uutils/coreutils/pull/3076

`df`
* Adds support for mount path prefix matching and input path by @crazystylus in https://github.com/uutils/coreutils/pull/3161
* `--output w/o "="` doesn't expect further args by @cakebaker in https://github.com/uutils/coreutils/pull/3327
* Add support for `--total` option by @jfinkels in https://github.com/uutils/coreutils/pull/3197
* Always produce the same order in output table by @jfinkels in https://github.com/uutils/coreutils/pull/3126
* Always round up usage percentage (#3208) by @cakebaker in https://github.com/uutils/coreutils/pull/3230
* Correctly scale bytes by block size by @jfinkels in https://github.com/uutils/coreutils/pull/3182
* Fix block size header for multiples of 1024 by @jfinkels in https://github.com/uutils/coreutils/pull/3191
* Fix calculation of `Use%` column by @cakebaker in https://github.com/uutils/coreutils/pull/3309
* Fix calculation of Use% in "total" row by @cakebaker in https://github.com/uutils/coreutils/pull/3347
* Fix panic when using `-x` argument (#3257) by @cakebaker in https://github.com/uutils/coreutils/pull/3258
* Implement the `--output` command-line argument by @jfinkels in https://github.com/uutils/coreutils/pull/3176, https://github.com/uutils/coreutils/pull/3322, https://github.com/uutils/coreutils/pull/3323
* Implement the File column by @jfinkels in https://github.com/uutils/coreutils/pull/3294
* Omit reserved filesystem blocks in "Available" by @cakebaker in https://github.com/uutils/coreutils/pull/3270
* Remove unused "--direct" option by @cakebaker in https://github.com/uutils/coreutils/pull/3263
* Some option changes by @xxyzz in https://github.com/uutils/coreutils/pull/3127

`echo`
* Allow echo with escapes to work with `\0` by @Dr-Emann in https://github.com/uutils/coreutils/pull/2977

`hashsum`
* Added b2sum and b3sum utilities by @palaster in https://github.com/uutils/coreutils/pull/3164
* Add BLAKE3 to Hashing Algorithms by @DestroyerXyz in https://github.com/uutils/coreutils/pull/3108

`head`
* Add `---presume-input-pipe` parameter by @DevSabb in https://github.com/uutils/coreutils/pull/3345
* Don't add trailing newline to end of file that didn't originally have one by @jfinkels in https://github.com/uutils/coreutils/pull/2957

`install`
* Better error messages when handling invalid arguments by @ndd7xv in https://github.com/uutils/coreutils/pull/3187

`join`
* Print unsorted line in error message by @cohosh in https://github.com/uutils/coreutils/pull/2899
* Fix default check order behaviour by @cohosh in https://github.com/uutils/coreutils/pull/2908
* Add support for `-t '\0'` by @jtracey in https://github.com/uutils/coreutils/pull/2881
* "Support" field numbers larger than `usize::MAX` by @jtracey in https://github.com/uutils/coreutils/pull/2882
* Add support for non-unicode field separators by @jtracey in https://github.com/uutils/coreutils/pull/2902
* Improve performance by @jtracey in https://github.com/uutils/coreutils/pull/3092

`ln`
* Make the tests/ln/hard-backup.sh test work by @sylvestre in https://github.com/uutils/coreutils/pull/3340
* Pass tests/ln/backup-1.sh  & improvement in the error messages by @sylvestre in https://github.com/uutils/coreutils/pull/3346

`ls`
* Add new optional arguments to `--classify` flag by @abhishekc-sharma in https://github.com/uutils/coreutils/pull/3041
* Add proper quotes on symlink with `--quoting-style=shell-escape` by @sylvestre in https://github.com/uutils/coreutils/pull/3317
* Fix display of bad file descriptor errors by @kimono-koans in https://github.com/uutils/coreutils/pull/2875
* Fix display of inodes and add allocation size feature by @kimono-koans in https://github.com/uutils/coreutils/pull/3052
* When `-aA` are provided, the order matters by @sylvestre in https://github.com/uutils/coreutils/pull/3285

`mkdir`
* Add support of `mkdir -p foo/.` by @sylvestre in https://github.com/uutils/coreutils/pull/3311
* Recursive reporting of created directories in verbose mode by @353fc443 in https://github.com/uutils/coreutils/pull/3217

`nproc`
* Add the full support of `OMP_THREAD_LIMIT` by @sylvestre in https://github.com/uutils/coreutils/pull/3286
* Improve the GNU compat by @sylvestre in https://github.com/uutils/coreutils/pull/3248
* Make tests/misc/nproc-override.sh pass by implementing `OMP_NUM_THREADS=X,Y,Z` by @sylvestre in https://github.com/uutils/coreutils/pull/3296

`paste`
* Fixes and cleanup by @Dr-Emann in https://github.com/uutils/coreutils/pull/2982

`pinky`
* Fix off-by-one in GECOS parsing by @jtracey in https://github.com/uutils/coreutils/pull/3155

`pr`
* Move from getopts to clap and fix heuristic for `-n` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3185

`printf`
* Update `%g` formatting to match GNU by @water-ghosts in https://github.com/uutils/coreutils/pull/3087
* Fix printf sci notation round up by @nickd0 in https://github.com/uutils/coreutils/pull/3116
* Support leading zeroes with `%0n` formatting by @water-ghosts in https://github.com/uutils/coreutils/pull/3070
* Use clap default help and version by @ndd7xv in https://github.com/uutils/coreutils/pull/3067

`realpath`
* Error when resolved symlink is absolute and ENOENT by @hbina in https://github.com/uutils/coreutils/pull/3037

`seq`
* Add `-f FORMAT` option by @jfinkels in https://github.com/uutils/coreutils/pull/2918
* Correct error message for zero increment by @jfinkels in https://github.com/uutils/coreutils/pull/2923
* Better argument parsing by @HeroicKatora in https://github.com/uutils/coreutils/pull/3081

`shuf`
* accept multiple occurances of head-count argument by @DevSabb in https://github.com/uutils/coreutils/pull/3329

`sleep`
* Give usage error on invalid time interval by @jfinkels in https://github.com/uutils/coreutils/pull/3284

`sort`
* Add two missing spaces in help texts by @cakebaker in https://github.com/uutils/coreutils/pull/3287

`split`
* Add support for `-e` argument by @jfinkels in https://github.com/uutils/coreutils/pull/3107
* Add support for `-x` option (hex suffixes) by @jfinkels in https://github.com/uutils/coreutils/pull/2981
* Add support for `-n l/NUM` option to split by @jfinkels in https://github.com/uutils/coreutils/pull/2980
* Avoid writing final empty chunk with `-C` by @jfinkels in https://github.com/uutils/coreutils/pull/3278
* Catch and handle broken pipe errors by @jfinkels in https://github.com/uutils/coreutils/pull/3275
* Correct error message on invalid arg. to `-a` by @jfinkels in https://github.com/uutils/coreutils/pull/3006
* Elide all chunks when input file is empty by @jfinkels in https://github.com/uutils/coreutils/pull/3274
* Error when `--additional-suffix contains` `/` by @jfinkels in https://github.com/uutils/coreutils/pull/3111
* Error when num. of chunks is greater than num. of possible filenames by @ndd7xv in https://github.com/uutils/coreutils/pull/3146
* Handle no final newline with `--line-bytes` by @jfinkels in https://github.com/uutils/coreutils/pull/3277
* Add `--line-bytes` option by @jfinkels in https://github.com/uutils/coreutils/pull/3204
* Add `-n` option by @jfinkels in https://github.com/uutils/coreutils/pull/2866
* Implement outputting kth chunk of file by @jfinkels in https://github.com/uutils/coreutils/pull/3207
* Add `---io-blksize` parameter by @DevSabb in https://github.com/uutils/coreutils/pull/3064

`stat`
* Allow formatting of negative numbers by @snobee in https://github.com/uutils/coreutils/pull/3053

`tail`
* Fix a bug in `tail [ -n | -c ] +NUM <file>` by @jfinkels in https://github.com/uutils/coreutils/pull/2904
* Don't error when following non-UTF-8 data by @jfinkels in https://github.com/uutils/coreutils/pull/2916
* Add `---presume-input-pipe` parameter by @DevSabb in https://github.com/uutils/coreutils/pull/3345
* Support zero-terminated lines in streams by @jfinkels in https://github.com/uutils/coreutils/pull/2898

`test`
* `test`: fix wsl executable permission by @tertsdiepraam in https://github.com/uutils/coreutils/pull/2965

`timeout`
* Avoid panicking for empty string by @353fc443 in https://github.com/uutils/coreutils/pull/3206
* Fix bug in `--preserve-status` mode by @jfinkels in https://github.com/uutils/coreutils/pull/3249
* Give usage error on invalid time interval by @jfinkels in https://github.com/uutils/coreutils/pull/3283
* Produce usage error on invalid signal by @jfinkels in https://github.com/uutils/coreutils/pull/3297
* Return `125` on invalid time interval args by @jfinkels in https://github.com/uutils/coreutils/pull/3314
* Support long form of `--kill-after` arg by @jfinkels in https://github.com/uutils/coreutils/pull/3313

`touch`
* Better error messages when no args is provided by @hbina in https://github.com/uutils/coreutils/pull/3047
* Implement `-` by @dgunay in https://github.com/uutils/coreutils/pull/3158
* Show error on `-h` with nonexistent file by @jfinkels in https://github.com/uutils/coreutils/pull/3117

`tr`
* Expanding expansion module (added support for character classes and many more patterns) by @hbina in https://github.com/uutils/coreutils/pull/2502
* Fix octal interpretation of repeat count string by @DevSabb in https://github.com/uutils/coreutils/pull/3178

`true`
* Make true return false less frequently by @HeroicKatora in https://github.com/uutils/coreutils/pull/3014

`truncate`
* Create non-existent file by default by @jfinkels in https://github.com/uutils/coreutils/pull/2912
* Add a division by zero error by @jfinkels in https://github.com/uutils/coreutils/pull/2934
* Prevent underflow when reducing size by @jfinkels in https://github.com/uutils/coreutils/pull/2945
* Better error msg when dir does not exist by @jfinkels in https://github.com/uutils/coreutils/pull/2943
* Change cli error return code by @shoriminimoe in https://github.com/uutils/coreutils/pull/3012
* Error when trying to truncate a fifo by @jfinkels in https://github.com/uutils/coreutils/pull/2944

`wc`
* Fix counting files from pseudo-filesystem by @tertsdiepraam in https://github.com/uutils/coreutils/pull/2935
* Compute number widths using total file sizes by @ackerleytng in https://github.com/uutils/coreutils/pull/3304
* Implement `--files0-from` option by @allan-silva in https://github.com/uutils/coreutils/pull/2966

## New Contributors
@cohosh (https://github.com/uutils/coreutils/pull/2899, @g-k (https://github.com/uutils/coreutils/pull/2893), @water-ghosts (https://github.com/uutils/coreutils/pull/2956), @biomunky (https://github.com/uutils/coreutils/pull/2964), @danieleades (https://github.com/uutils/coreutils/pull/2963), @douglaz (https://github.com/uutils/coreutils/pull/2975), @Narasimha1997 (https://github.com/uutils/coreutils/pull/2947), @Toxaris (https://github.com/uutils/coreutils/pull/3020), @rahulkadukar (https://github.com/uutils/coreutils/pull/3030), @DevSabb (https://github.com/uutils/coreutils/pull/3038), @HeroicKatora (https://github.com/uutils/coreutils/pull/3014), @shoriminimoe (https://github.com/uutils/coreutils/pull/3012), @lguist (https://github.com/uutils/coreutils/pull/3011), @ndd7xv (https://github.com/uutils/coreutils/pull/3024), @slycordinator (https://github.com/uutils/coreutils/pull/3013), @RishiKumarRay (https://github.com/uutils/coreutils/pull/3023), @daissi (https://github.com/uutils/coreutils/pull/3100), @snobee (https://github.com/uutils/coreutils/pull/3053), @abhishekc-sharma (https://github.com/uutils/coreutils/pull/3041), @DestroyerXyz (https://github.com/uutils/coreutils/pull/3108), @alextibbles (https://github.com/uutils/coreutils/pull/3110), @serhansekman (https://github.com/uutils/coreutils/pull/3121), @allan-silva (https://github.com/uutils/coreutils/pull/2966), @davide125 (https://github.com/uutils/coreutils/pull/3130), @crazystylus (https://github.com/uutils/coreutils/pull/3074), @miallo (https://github.com/uutils/coreutils/pull/3145), @iovanom (https://github.com/uutils/coreutils/pull/3021), @palaster (https://github.com/uutils/coreutils/pull/3056), @xxyzz (https://github.com/uutils/coreutils/pull/3045), @omertuc (https://github.com/uutils/coreutils/pull/3084), @cakebaker (https://github.com/uutils/coreutils/pull/3202), @dgunay (https://github.com/uutils/coreutils/pull/3158), @nickd0 (https://github.com/uutils/coreutils/pull/3116), @OHNONOTAMOTH (https://github.com/uutils/coreutils/pull/3244), @bnjbvr (https://github.com/uutils/coreutils/pull/3264), @chordtoll (https://github.com/uutils/coreutils/pull/3256), @ackerleytng (https://github.com/uutils/coreutils/pull/3304)

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.12...0.0.13
