/**
 * Represents any possible JSON value:
 * - number
 * - string
 * - boolean
 * - null
 * - object (with any JSON value as property)
 * - array (with any JSON value as element)
 */
export type JsonValue = number | string | boolean | null | JsonObject | JsonValue[];
/**
 * Represents a JSON object.
 */
export type JsonObject = {
    [k: string]: JsonValue;
};
