static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * This is derived from the (public domain) reference implementation on       \n"
" * netlib.                                                                    \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <glib.h>                                                             \n"
"                                                                              \n"
"#include \"matting-levin-cblas.h\"                                            \n"
"                                                                              \n"
"                                                                              \n"
"/* cblas_dgemm: We include this implementation so that we don't have to       \n"
" * depend on cblas solely for this one function. It does not appear to be the \n"
" * performance bottleneck at this time, and the matrices aren't going to be   \n"
" * massive.                                                                   \n"
" *                                                                            \n"
" * Using restrict may not be correct in the general case, but we can          \n"
" * guarantee in our case that the matrices do not overlap.                    \n"
" */                                                                           \n"
"gint                                                                          \n"
"cblas_dgemm(enum CBLAS_ORDER      order,                                      \n"
"            enum CBLAS_TRANSPOSE  transa,                                     \n"
"            enum CBLAS_TRANSPOSE  transb,                                     \n"
"            gint                  m,                                          \n"
"            gint                  n,                                          \n"
"            gint                  k,                                          \n"
"            gdouble               alpha,                                      \n"
"            const gdouble        *restrict a,                                 \n"
"            gint                  lda,                                        \n"
"            const gdouble        *restrict b,                                 \n"
"            gint                  ldb,                                        \n"
"            gdouble               beta,                                       \n"
"            gdouble              *restrict c,                                 \n"
"            gint                  ldc)                                        \n"
"{                                                                             \n"
"  /* Local variables */                                                       \n"
"  gint     info;                                                              \n"
"  gboolean nota, notb;                                                        \n"
"  gdouble  temp;                                                              \n"
"  gint     i, j, l;                                                           \n"
"  gint     nrowa, nrowb;                                                      \n"
"                                                                              \n"
"  /* Rather than catering for arbitrary indexing, just force row-major */     \n"
"  //g_return_val_if_fail (order == CblasRowMajor, 1);                         \n"
"                                                                              \n"
"#define A(I,J) a[(I)-1 + ((J)-1)* (lda)]                                      \n"
"#define B(I,J) b[(I)-1 + ((J)-1)* (ldb)]                                      \n"
"#define C(I,J) c[(I)-1 + ((J)-1)* (ldc)]                                      \n"
"                                                                              \n"
"  if (order == CblasRowMajor)                                                 \n"
"    return cblas_dgemm (CblasColMajor, transb, transa,                        \n"
"                        n, m, k, alpha, b, ldb, a, lda, beta, c, ldc);        \n"
"                                                                              \n"
"  nota = CblasNoTrans == transa;                                              \n"
"  notb = CblasNoTrans == transb;                                              \n"
"  if (nota)                                                                   \n"
"    {                                                                         \n"
"      nrowa = m;                                                              \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      nrowa = k;                                                              \n"
"    }                                                                         \n"
"  if (notb)                                                                   \n"
"    {                                                                         \n"
"      nrowb = k;                                                              \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      nrowb = n;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Test the input parameters. */                                            \n"
"  info = 0;                                                                   \n"
"  if (!nota && transa != CblasConjTrans && transa != CblasTrans)              \n"
"    info = 1;                                                                 \n"
"  else if (!notb && transb != CblasConjTrans && transb != CblasTrans)         \n"
"    info = 2;                                                                 \n"
"  else if (m < 0)                                                             \n"
"    info = 3;                                                                 \n"
"  else if (n < 0)                                                             \n"
"    info = 4;                                                                 \n"
"  else if (k < 0)                                                             \n"
"    info = 5;                                                                 \n"
"  else if (lda < MAX (1, nrowa))                                              \n"
"    info = 8;                                                                 \n"
"  else if (ldb < MAX (1, nrowb))                                              \n"
"    info = 10;                                                                \n"
"  else if (ldc < MAX (1, m))                                                  \n"
"    info = 13;                                                                \n"
"  if (info != 0)                                                              \n"
"    {                                                                         \n"
"      g_warning (\"On entry to %s, parameter number %i had an illegal value\",\n"
"                 \"DGEMM \", info);                                           \n"
"      return 1;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Start the operations. */                                                 \n"
"  if (notb)                                                                   \n"
"    {                                                                         \n"
"      if (nota)                                                               \n"
"        {                                                                     \n"
"          /* Form  C := alpha*A*B + beta*C. */                                \n"
"          for (j = 1; j <= n; ++j)                                            \n"
"            {                                                                 \n"
"              if (beta == 0.)                                                 \n"
"                {                                                             \n"
"                  for (i = 1; i <= m; ++i)                                    \n"
"                      C(i,j) = 0.;                                            \n"
"                }                                                             \n"
"              else if (beta != 1.)                                            \n"
"                {                                                             \n"
"                  for (i = 1; i <= m; ++i)                                    \n"
"                    C(i,j) = beta * C(i,j);                                   \n"
"                }                                                             \n"
"                                                                              \n"
"              for (l = 1; l <= k; ++l)                                        \n"
"                {                                                             \n"
"                  if (B(l,j) != 0.)                                           \n"
"                    {                                                         \n"
"                      temp = alpha * B(l,j);                                  \n"
"                                                                              \n"
"                      for (i = 1; i <= m; ++i)                                \n"
"                        C(i,j) += temp * A(i,l);                              \n"
"                    }                                                         \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          for (j = 1; j <= n; ++j)                                            \n"
"            {                                                                 \n"
"              for (i = 1; i <= m; ++i)                                        \n"
"                {                                                             \n"
"                  temp = 0.;                                                  \n"
"                                                                              \n"
"                  for (l = 1; l <= k; ++l)                                    \n"
"                    temp += A(l,i) * B(l,j);                                  \n"
"                                                                              \n"
"                  if (beta == 0.)                                             \n"
"                    C(i,j) = alpha * temp;                                    \n"
"                  else                                                        \n"
"                    C(i,j) = alpha * temp + beta * C(i,j);                    \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      if (nota)                                                               \n"
"        {                                                                     \n"
"          /* Form  C := alpha*A*B' + beta*C */                                \n"
"          for (j = 1; j <= n; ++j)                                            \n"
"            {                                                                 \n"
"              if (beta == 0.)                                                 \n"
"                {                                                             \n"
"                                                                              \n"
"                  for (i = 1; i <= m; ++i)                                    \n"
"                    C(i,j) = 0.;                                              \n"
"                }                                                             \n"
"              else if (beta != 1.)                                            \n"
"                {                                                             \n"
"                                                                              \n"
"                  for (i = 1; i <= m; ++i)                                    \n"
"                    C(i,j) = beta * C(i,j);                                   \n"
"                }                                                             \n"
"                                                                              \n"
"              for (l = 1; l <= k; ++l)                                        \n"
"                {                                                             \n"
"                  if (B(j,l) != 0.)                                           \n"
"                    {                                                         \n"
"                      temp = alpha * B(j,l);                                  \n"
"                                                                              \n"
"                      for (i = 1; i <= m; ++i)                                \n"
"                        C(i,j) += temp * A(i,l);                              \n"
"                    }                                                         \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          /* Form  C := alpha*A'*B' + beta*C */                               \n"
"                                                                              \n"
"          for (j = 1; j <= n; ++j)                                            \n"
"            {                                                                 \n"
"              for (i = 1; i <= m; ++i)                                        \n"
"                {                                                             \n"
"                  temp = 0.;                                                  \n"
"                  for (l = 1; l <= k; ++l)                                    \n"
"                    temp += A(l,i) * B(j,l);                                  \n"
"                                                                              \n"
"                  if (beta == 0.)                                             \n"
"                    C(i,j) = alpha * temp;                                    \n"
"                  else                                                        \n"
"                    C(i,j) = alpha * temp + beta * C(i,j);                    \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
;
