/* gitg-application.c generated by valac 0.28.0, the Vala compiler
 * generated from gitg-application.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include "libgitg-ext/libgitg-ext.h"
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>
#include "libgitg/libgitg.h"
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>


#define GITG_TYPE_APPLICATION (gitg_application_get_type ())
#define GITG_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_APPLICATION, GitgApplication))
#define GITG_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_APPLICATION, GitgApplicationClass))
#define GITG_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_APPLICATION))
#define GITG_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_APPLICATION))
#define GITG_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_APPLICATION, GitgApplicationClass))

typedef struct _GitgApplication GitgApplication;
typedef struct _GitgApplicationClass GitgApplicationClass;
typedef struct _GitgApplicationPrivate GitgApplicationPrivate;

#define GITG_TYPE_PREFERENCES_DIALOG (gitg_preferences_dialog_get_type ())
#define GITG_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialog))
#define GITG_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialogClass))
#define GITG_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PREFERENCES_DIALOG))
#define GITG_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PREFERENCES_DIALOG))
#define GITG_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialogClass))

typedef struct _GitgPreferencesDialog GitgPreferencesDialog;
typedef struct _GitgPreferencesDialogClass GitgPreferencesDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_HISTORY_TYPE_COMMAND_LINE (gitg_history_command_line_get_type ())
#define GITG_HISTORY_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLine))
#define GITG_HISTORY_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLineClass))
#define GITG_HISTORY_IS_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_COMMAND_LINE))
#define GITG_HISTORY_IS_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_COMMAND_LINE))
#define GITG_HISTORY_COMMAND_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLineClass))

typedef struct _GitgHistoryCommandLine GitgHistoryCommandLine;
typedef struct _GitgHistoryCommandLineClass GitgHistoryCommandLineClass;

#define GITG_TYPE_PLUGINS_ENGINE (gitg_plugins_engine_get_type ())
#define GITG_PLUGINS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngine))
#define GITG_PLUGINS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngineClass))
#define GITG_IS_PLUGINS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PLUGINS_ENGINE))
#define GITG_IS_PLUGINS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PLUGINS_ENGINE))
#define GITG_PLUGINS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngineClass))

typedef struct _GitgPluginsEngine GitgPluginsEngine;
typedef struct _GitgPluginsEngineClass GitgPluginsEngineClass;
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define GITG_APPLICATION_TYPE_ACCEL (gitg_application_accel_get_type ())
typedef struct _GitgApplicationAccel GitgApplicationAccel;

#define GITG_APPLICATION_TYPE_MULTI_ACCEL (gitg_application_multi_accel_get_type ())
typedef struct _GitgApplicationMultiAccel GitgApplicationMultiAccel;

#define GITG_TYPE_WINDOW (gitg_window_get_type ())
#define GITG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_WINDOW, GitgWindow))
#define GITG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_WINDOW, GitgWindowClass))
#define GITG_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_WINDOW))
#define GITG_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_WINDOW))
#define GITG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_WINDOW, GitgWindowClass))

typedef struct _GitgWindow GitgWindow;
typedef struct _GitgWindowClass GitgWindowClass;

#define GITG_APPLICATION_TYPE_OPTIONS (gitg_application_options_get_type ())
typedef struct _GitgApplicationOptions GitgApplicationOptions;

struct _GitgApplication {
	GtkApplication parent_instance;
	GitgApplicationPrivate * priv;
};

struct _GitgApplicationClass {
	GtkApplicationClass parent_class;
};

struct _GitgApplicationPrivate {
	GSettings* d_state_settings;
	GitgPreferencesDialog* d_preferences;
};

struct _GitgApplicationAccel {
	gchar* name;
	gchar* accel;
};

struct _GitgApplicationMultiAccel {
	gchar* name;
	gchar** accels;
	gint accels_length1;
	gint _accels_size_;
};

struct _GitgApplicationOptions {
};


static gpointer gitg_application_parent_class = NULL;
static gboolean gitg_application_options_quit;
static gchar* gitg_application_options_activity;
static gboolean gitg_application_options_no_wd;
static GApplicationCommandLine* gitg_application_options_command_line;
static gboolean gitg_application_options_quit = FALSE;
static gchar* gitg_application_options_activity = NULL;
static gboolean gitg_application_options_no_wd = FALSE;
static GApplicationCommandLine* gitg_application_options_command_line = NULL;

GType gitg_application_get_type (void) G_GNUC_CONST;
GType gitg_preferences_dialog_get_type (void) G_GNUC_CONST;
#define GITG_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_APPLICATION, GitgApplicationPrivate))
enum  {
	GITG_APPLICATION_DUMMY_PROPERTY,
	GITG_APPLICATION_STATE_SETTINGS
};
static void gitg_application_on_app_new_window_activated (GitgApplication* self);
static void _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_app_help_activated (GitgApplication* self);
static void _gitg_application_on_app_help_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_app_about_activated (GitgApplication* self);
static void _gitg_application_on_app_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_app_quit_activated (GitgApplication* self);
static void _gitg_application_on_app_quit_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_preferences_activated (GitgApplication* self);
static void _gitg_application_on_preferences_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GitgApplication* gitg_application_new (void);
GitgApplication* gitg_application_construct (GType object_type);
static gboolean gitg_application_show_version_and_quit (void);
static GitgExtCommandLines* gitg_application_parse_command_line (GitgApplication* self, gchar*** argv, int* argv_length1, GError** error);
static gboolean gitg_application_options_commit_activity (void);
GType gitg_history_command_line_get_type (void) G_GNUC_CONST;
GitgHistoryCommandLine* gitg_history_command_line_new (void);
GitgHistoryCommandLine* gitg_history_command_line_construct (GType object_type);
static void _vala_array_add8 (GitgExtCommandLine*** array, int* length, int* size, GitgExtCommandLine* value);
GType gitg_plugins_engine_get_type (void) G_GNUC_CONST;
GitgPluginsEngine* gitg_plugins_engine_get_default (void);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void _vala_array_add9 (GitgExtCommandLine*** array, int* length, int* size, GitgExtCommandLine* value);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static gboolean gitg_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status);
static gchar** _vala_array_dup16 (gchar** self, int length);
void gitg_plugins_engine_initialize (void);
static gint gitg_application_real_command_line (GApplication* base, GApplicationCommandLine* cmd);
static void _vala_array_add10 (GFile*** array, int* length, int* size, GFile* value);
static void gitg_application_open_command_line (GitgApplication* self, GFile** files, int files_length1, const gchar* hint, GitgExtCommandLines* command_lines);
static void gitg_application_activate_command_line (GitgApplication* self, GitgExtCommandLines* command_lines);
static void gitg_application_new_window (GitgApplication* self, GitgRepository* repo, const gchar* hint, GitgExtCommandLines* command_lines);
gpointer gitg_resource_load_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* id, const gchar* object);
static void ___lambda128_ (GitgApplication* self, GtkWidget* w);
static void ____lambda128__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void gitg_application_real_startup (GApplication* base);
static GType gitg_application_accel_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GitgApplicationAccel* gitg_application_accel_dup (const GitgApplicationAccel* self);
static void gitg_application_accel_free (GitgApplicationAccel* self);
static void gitg_application_accel_copy (const GitgApplicationAccel* self, GitgApplicationAccel* dest);
static void gitg_application_accel_destroy (GitgApplicationAccel* self);
static GType gitg_application_multi_accel_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GitgApplicationMultiAccel* gitg_application_multi_accel_dup (const GitgApplicationMultiAccel* self);
static void gitg_application_multi_accel_free (GitgApplicationMultiAccel* self);
static void gitg_application_multi_accel_copy (const GitgApplicationMultiAccel* self, GitgApplicationMultiAccel* dest);
static void gitg_application_multi_accel_destroy (GitgApplicationMultiAccel* self);
GtkCssProvider* gitg_resource_load_css (const gchar* id);
static void _vala_GitgApplicationMultiAccel_array_free (GitgApplicationMultiAccel* array, gint array_length);
static void gitg_application_real_shutdown (GApplication* base);
static void gitg_application_present_window (GitgApplication* self, const gchar* activity, GitgExtCommandLines* command_lines);
static void gitg_application_real_activate (GApplication* base);
GType gitg_window_get_type (void) G_GNUC_CONST;
static GitgWindow* gitg_application_find_window_for_file (GitgApplication* self, GFile* file);
static void gitg_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
void gitg_window_set_environment (GitgWindow* self, gchar** environment, int environment_length1);
void gitg_window_present (GitgWindow* self, const gchar* hint, GitgExtCommandLines* command_lines);
GitgWindow* gitg_window_create_new (GtkApplication* app, GitgRepository* repository, const gchar* action);
GSettings* gitg_application_get_state_settings (GitgApplication* self);
static GType gitg_application_options_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GitgApplicationOptions* gitg_application_options_dup (const GitgApplicationOptions* self);
static void gitg_application_options_free (GitgApplicationOptions* self);
static gchar** _vala_array_dup17 (gchar** self, int length);
static void gitg_application_finalize (GObject* obj);
static void _vala_gitg_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry GITG_APPLICATION_app_entries[5] = {{"new", _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback}, {"help", _gitg_application_on_app_help_activated_gsimple_action_activate_callback}, {"about", _gitg_application_on_app_about_activated_gsimple_action_activate_callback}, {"quit", _gitg_application_on_app_quit_activated_gsimple_action_activate_callback}, {"preferences", _gitg_application_on_preferences_activated_gsimple_action_activate_callback}};
static const GOptionEntry GITG_APPLICATION_OPTIONS_entries[5] = {{"version", 'v', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) gitg_application_show_version_and_quit, "Show the application's version", NULL}, {"activity", '\0', 0, G_OPTION_ARG_STRING, &gitg_application_options_activity, "Start gitg with a particular activity", NULL}, {"commit", 'c', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) gitg_application_options_commit_activity, "Start gitg with the commit activity (shorthand for --activity commit)", NULL}, {"no-wd", (gchar) 0, 0, G_OPTION_ARG_NONE, &gitg_application_options_no_wd, "Do not try to load a repository from the current working directory", NULL}, {NULL}};

static void _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 271 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_new_window_activated ((GitgApplication*) self);
#line 227 "gitg-application.c"
}


static void _gitg_application_on_app_help_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 271 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_help_activated ((GitgApplication*) self);
#line 234 "gitg-application.c"
}


static void _gitg_application_on_app_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 271 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_about_activated ((GitgApplication*) self);
#line 241 "gitg-application.c"
}


static void _gitg_application_on_app_quit_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 271 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_quit_activated ((GitgApplication*) self);
#line 248 "gitg-application.c"
}


static void _gitg_application_on_preferences_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 271 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_on_preferences_activated ((GitgApplication*) self);
#line 255 "gitg-application.c"
}


GitgApplication* gitg_application_construct (GType object_type) {
	GitgApplication * self = NULL;
#line 34 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) g_object_new (object_type, "application-id", "org.gnome.gitg", "flags", (G_APPLICATION_HANDLES_OPEN | G_APPLICATION_HANDLES_COMMAND_LINE) | G_APPLICATION_SEND_ENVIRONMENT, NULL);
#line 32 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return self;
#line 265 "gitg-application.c"
}


GitgApplication* gitg_application_new (void) {
#line 32 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return gitg_application_construct (GITG_TYPE_APPLICATION);
#line 272 "gitg-application.c"
}


static gboolean gitg_application_show_version_and_quit (void) {
	gboolean result = FALSE;
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 80 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = stdout;
#line 80 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_get_application_name ();
#line 80 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	fprintf (_tmp0_, "%s %s\n", _tmp1_, VERSION);
#line 84 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_options_quit = TRUE;
#line 85 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	result = TRUE;
#line 85 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return result;
#line 292 "gitg-application.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return self ? g_object_ref (self) : NULL;
#line 299 "gitg-application.c"
}


static void _vala_array_add8 (GitgExtCommandLine*** array, int* length, int* size, GitgExtCommandLine* value) {
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if ((*length) == (*size)) {
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		*array = g_renew (GitgExtCommandLine*, *array, (*size) + 1);
#line 310 "gitg-application.c"
	}
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*array)[(*length)++] = value;
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*array)[*length] = NULL;
#line 316 "gitg-application.c"
}


static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self) {
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return g_boxed_copy (peas_plugin_info_get_type (), self);
#line 323 "gitg-application.c"
}


static gpointer __vala_PeasPluginInfo_copy0 (gpointer self) {
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
#line 330 "gitg-application.c"
}


static void _vala_array_add9 (GitgExtCommandLine*** array, int* length, int* size, GitgExtCommandLine* value) {
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if ((*length) == (*size)) {
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		*array = g_renew (GitgExtCommandLine*, *array, (*size) + 1);
#line 341 "gitg-application.c"
	}
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*array)[(*length)++] = value;
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*array)[*length] = NULL;
#line 347 "gitg-application.c"
}


static void _vala_PeasPluginInfo_free (PeasPluginInfo* self) {
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_boxed_free (peas_plugin_info_get_type (), self);
#line 354 "gitg-application.c"
}


static GitgExtCommandLines* gitg_application_parse_command_line (GitgApplication* self, gchar*** argv, int* argv_length1, GError** error) {
	GitgExtCommandLines* result = NULL;
	GOptionContext* ctx = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	GitgExtCommandLine** cmdexts = NULL;
	GitgExtCommandLine** _tmp5_ = NULL;
	gint cmdexts_length1 = 0;
	gint _cmdexts_size_ = 0;
	GitgHistoryCommandLine* historycmd = NULL;
	GitgHistoryCommandLine* _tmp6_ = NULL;
	GitgExtCommandLine** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GitgHistoryCommandLine* _tmp8_ = NULL;
	GitgExtCommandLine* _tmp9_ = NULL;
	GOptionContext* _tmp10_ = NULL;
	GitgHistoryCommandLine* _tmp11_ = NULL;
	GOptionGroup* _tmp12_ = NULL;
	GitgPluginsEngine* engine = NULL;
	GitgPluginsEngine* _tmp13_ = NULL;
	GitgPluginsEngine* _tmp14_ = NULL;
	GList* _tmp15_ = NULL;
	GOptionContext* _tmp30_ = NULL;
	GitgExtCommandLines* ret = NULL;
	GitgExtCommandLine** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	GitgExtCommandLines* _tmp32_ = NULL;
	GitgExtCommandLines* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
#line 88 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = _ ("- Git repository viewer");
#line 90 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_option_context_new (_tmp0_);
#line 90 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	ctx = _tmp1_;
#line 92 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = ctx;
#line 92 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_option_context_add_main_entries (_tmp2_, GITG_APPLICATION_OPTIONS_entries, GETTEXT_PACKAGE);
#line 93 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3_ = ctx;
#line 93 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp4_ = gtk_get_option_group (TRUE);
#line 93 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_option_context_add_group (_tmp3_, _tmp4_);
#line 95 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp5_ = g_new0 (GitgExtCommandLine*, 0 + 1);
#line 95 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	cmdexts = _tmp5_;
#line 95 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	cmdexts_length1 = 0;
#line 95 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_cmdexts_size_ = cmdexts_length1;
#line 97 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp6_ = gitg_history_command_line_new ();
#line 97 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	historycmd = _tmp6_;
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp7_ = cmdexts;
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp7__length1 = cmdexts_length1;
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp8_ = historycmd;
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp9_ = _g_object_ref0 ((GitgExtCommandLine*) _tmp8_);
#line 98 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_vala_array_add8 (&cmdexts, &cmdexts_length1, &_cmdexts_size_, _tmp9_);
#line 100 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp10_ = ctx;
#line 100 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp11_ = historycmd;
#line 100 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp12_ = gitg_ext_command_line_get_option_group ((GitgExtCommandLine*) _tmp11_);
#line 100 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_option_context_add_group (_tmp10_, _tmp12_);
#line 103 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp13_ = gitg_plugins_engine_get_default ();
#line 103 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	engine = _tmp13_;
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp14_ = engine;
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp15_ = peas_engine_get_plugin_list ((PeasEngine*) _tmp14_);
#line 446 "gitg-application.c"
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		info_collection = _tmp15_;
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
#line 454 "gitg-application.c"
			PeasPluginInfo* _tmp16_ = NULL;
			PeasPluginInfo* info = NULL;
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_tmp16_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) info_it->data);
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			info = _tmp16_;
#line 461 "gitg-application.c"
			{
				PeasPluginInfo* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
#line 107 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp17_ = info;
#line 107 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp18_ = peas_plugin_info_get_external_data (_tmp17_, "CommandLine");
#line 107 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				if (_tmp18_ != NULL) {
#line 471 "gitg-application.c"
					GitgExtCommandLine* ext = NULL;
					GitgPluginsEngine* _tmp19_ = NULL;
					PeasPluginInfo* _tmp20_ = NULL;
					PeasExtension* _tmp21_ = NULL;
					GitgExtCommandLine* _tmp22_ = NULL;
					GitgExtCommandLine* _tmp23_ = NULL;
#line 109 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp19_ = engine;
#line 109 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp20_ = info;
#line 109 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp21_ = peas_engine_create_extension ((PeasEngine*) _tmp19_, _tmp20_, GITG_EXT_TYPE_COMMAND_LINE, NULL);
#line 109 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp22_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, GITG_EXT_TYPE_COMMAND_LINE) ? ((GitgExtCommandLine*) _tmp21_) : NULL;
#line 109 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					if (_tmp22_ == NULL) {
#line 109 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						_g_object_unref0 (_tmp21_);
#line 490 "gitg-application.c"
					}
#line 109 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					ext = _tmp22_;
#line 111 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp23_ = ext;
#line 111 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					if (_tmp23_ != NULL) {
#line 498 "gitg-application.c"
						GitgExtCommandLine** _tmp24_ = NULL;
						gint _tmp24__length1 = 0;
						GitgExtCommandLine* _tmp25_ = NULL;
						GitgExtCommandLine* _tmp26_ = NULL;
						GOptionContext* _tmp27_ = NULL;
						GitgExtCommandLine* _tmp28_ = NULL;
						GOptionGroup* _tmp29_ = NULL;
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						_tmp24_ = cmdexts;
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						_tmp24__length1 = cmdexts_length1;
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						_tmp25_ = ext;
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						_tmp26_ = _g_object_ref0 (_tmp25_);
#line 113 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						_vala_array_add9 (&cmdexts, &cmdexts_length1, &_cmdexts_size_, _tmp26_);
#line 114 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						_tmp27_ = ctx;
#line 114 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						_tmp28_ = ext;
#line 114 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						_tmp29_ = gitg_ext_command_line_get_option_group (_tmp28_);
#line 114 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
						g_option_context_add_group (_tmp27_, _tmp29_);
#line 524 "gitg-application.c"
					}
#line 107 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (ext);
#line 528 "gitg-application.c"
				}
#line 105 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				__vala_PeasPluginInfo_free0 (info);
#line 532 "gitg-application.c"
			}
		}
	}
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp30_ = ctx;
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_option_context_parse (_tmp30_, argv_length1, argv, &_inner_error_);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		if (_inner_error_->domain == G_OPTION_ERROR) {
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			g_propagate_error (error, _inner_error_);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (engine);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (historycmd);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			cmdexts = (_vala_array_free (cmdexts, cmdexts_length1, (GDestroyNotify) g_object_unref), NULL);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_g_option_context_free0 (ctx);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			return NULL;
#line 556 "gitg-application.c"
		} else {
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (engine);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (historycmd);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			cmdexts = (_vala_array_free (cmdexts, cmdexts_length1, (GDestroyNotify) g_object_unref), NULL);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_g_option_context_free0 (ctx);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			g_clear_error (&_inner_error_);
#line 119 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			return NULL;
#line 572 "gitg-application.c"
		}
	}
#line 121 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp31_ = cmdexts;
#line 121 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp31__length1 = cmdexts_length1;
#line 121 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp32_ = gitg_ext_command_lines_new (_tmp31_, _tmp31__length1);
#line 121 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	ret = _tmp32_;
#line 122 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp33_ = ret;
#line 122 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_ext_command_lines_parse_finished (_tmp33_);
#line 124 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	result = ret;
#line 124 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (engine);
#line 124 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (historycmd);
#line 124 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	cmdexts = (_vala_array_free (cmdexts, cmdexts_length1, (GDestroyNotify) g_object_unref), NULL);
#line 124 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_option_context_free0 (ctx);
#line 124 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return result;
#line 599 "gitg-application.c"
}


static gchar** _vala_array_dup16 (gchar** self, int length) {
	gchar** result;
	int i;
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	result = g_new0 (gchar*, length + 1);
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	for (i = 0; i < length; i++) {
#line 610 "gitg-application.c"
		gchar* _tmp0_ = NULL;
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp0_ = g_strdup (self[i]);
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		result[i] = _tmp0_;
#line 616 "gitg-application.c"
	}
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return result;
#line 620 "gitg-application.c"
}


static gboolean gitg_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status) {
	GitgApplication * self;
	gint _vala_exit_status = 0;
	gboolean result = FALSE;
	gchar** cp = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint cp_length1 = 0;
	gint _cp_size_ = 0;
	gchar** argv = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
#line 127 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = *arguments;
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0__length1 = _vala_array_length (*arguments);
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup16 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1__length1 = _tmp0__length1;
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	cp = _tmp1_;
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	cp_length1 = _tmp1__length1;
#line 130 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_cp_size_ = cp_length1;
#line 131 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = cp;
#line 131 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2__length1 = cp_length1;
#line 131 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	argv = _tmp2_;
#line 131 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	argv_length1 = _tmp2__length1;
#line 131 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_argv_size_ = argv_length1;
#line 133 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_plugins_engine_initialize ();
#line 672 "gitg-application.c"
	{
		GitgExtCommandLines* _tmp3_ = NULL;
		GitgExtCommandLines* _tmp4_ = NULL;
#line 138 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp3_ = gitg_application_parse_command_line (self, &argv, &argv_length1, &_inner_error_);
#line 138 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp4_ = _tmp3_;
#line 138 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (_tmp4_);
#line 138 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 684 "gitg-application.c"
			goto __catch34_g_error;
		}
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 135 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		e = _inner_error_;
#line 135 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_inner_error_ = NULL;
#line 142 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp5_ = stderr;
#line 142 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp6_ = e;
#line 142 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp7_ = _tmp6_->message;
#line 142 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		fprintf (_tmp5_, "Failed to parse options: %s\n", _tmp7_);
#line 143 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_vala_exit_status = 1;
#line 144 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		result = TRUE;
#line 144 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_error_free0 (e);
#line 144 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 144 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		if (exit_status) {
#line 144 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			*exit_status = _vala_exit_status;
#line 719 "gitg-application.c"
		}
#line 144 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		return result;
#line 723 "gitg-application.c"
	}
	__finally34:
#line 135 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 135 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		g_clear_error (&_inner_error_);
#line 135 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		return FALSE;
#line 736 "gitg-application.c"
	}
#line 147 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp8_ = gitg_application_options_quit;
#line 147 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp8_) {
#line 149 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_vala_exit_status = 0;
#line 150 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		result = TRUE;
#line 150 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 150 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		if (exit_status) {
#line 150 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			*exit_status = _vala_exit_status;
#line 752 "gitg-application.c"
		}
#line 150 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		return result;
#line 756 "gitg-application.c"
	}
#line 153 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp10_ = G_APPLICATION_CLASS (gitg_application_parent_class)->local_command_line ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), arguments, &_tmp9_);
#line 153 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_vala_exit_status = _tmp9_;
#line 153 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	result = _tmp10_;
#line 153 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 153 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (exit_status) {
#line 153 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		*exit_status = _vala_exit_status;
#line 770 "gitg-application.c"
	}
#line 153 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return result;
#line 774 "gitg-application.c"
}


static void _vala_array_add10 (GFile*** array, int* length, int* size, GFile* value) {
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if ((*length) == (*size)) {
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 785 "gitg-application.c"
	}
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*array)[(*length)++] = value;
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*array)[*length] = NULL;
#line 791 "gitg-application.c"
}


static gint gitg_application_real_command_line (GApplication* base, GApplicationCommandLine* cmd) {
	GitgApplication * self;
	gint result = 0;
	gchar** arguments = NULL;
	GApplicationCommandLine* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint arguments_length1 = 0;
	gint _arguments_size_ = 0;
	gchar** argv = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	GitgExtCommandLines* command_lines = NULL;
	gboolean _tmp10_ = FALSE;
	GApplicationCommandLine* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GApplicationCommandLine* tmpcmd = NULL;
	GApplicationCommandLine* _tmp15_ = NULL;
	GApplicationCommandLine* _tmp16_ = NULL;
	GApplicationCommandLine* _tmp17_ = NULL;
	GApplicationCommandLine* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	GApplicationCommandLine* _tmp33_ = NULL;
	GApplicationCommandLine* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
#line 156 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 156 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (cmd != NULL, 0);
#line 158 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = cmd;
#line 158 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = g_application_command_line_get_arguments (_tmp0_, &_tmp1_);
#line 158 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	arguments = _tmp2_;
#line 158 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	arguments_length1 = _tmp1_;
#line 158 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_arguments_size_ = arguments_length1;
#line 159 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3_ = arguments;
#line 159 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3__length1 = arguments_length1;
#line 159 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	argv = _tmp3_;
#line 159 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	argv_length1 = _tmp3__length1;
#line 159 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_argv_size_ = argv_length1;
#line 847 "gitg-application.c"
	{
		GitgExtCommandLines* _tmp4_ = NULL;
		GitgExtCommandLines* _tmp5_ = NULL;
		GitgExtCommandLines* _tmp6_ = NULL;
#line 164 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp5_ = gitg_application_parse_command_line (self, &argv, &argv_length1, &_inner_error_);
#line 164 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp4_ = _tmp5_;
#line 164 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 858 "gitg-application.c"
			goto __catch35_g_error;
		}
#line 164 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp6_ = _tmp4_;
#line 164 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp4_ = NULL;
#line 164 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (command_lines);
#line 164 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		command_lines = _tmp6_;
#line 162 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (_tmp4_);
#line 871 "gitg-application.c"
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
		GApplicationCommandLine* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 162 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		e = _inner_error_;
#line 162 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_inner_error_ = NULL;
#line 168 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp7_ = cmd;
#line 168 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp8_ = e;
#line 168 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp9_ = _tmp8_->message;
#line 168 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		g_application_command_line_printerr (_tmp7_, "option parsing failed: %s\n", _tmp9_);
#line 169 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		result = 1;
#line 169 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_error_free0 (e);
#line 169 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (command_lines);
#line 169 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 169 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		return result;
#line 902 "gitg-application.c"
	}
	__finally35:
#line 162 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 162 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (command_lines);
#line 162 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 162 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		g_clear_error (&_inner_error_);
#line 162 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		return 0;
#line 917 "gitg-application.c"
	}
#line 172 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp10_ = gitg_application_options_quit;
#line 172 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp10_) {
#line 174 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		result = 0;
#line 174 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (command_lines);
#line 174 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 174 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		return result;
#line 931 "gitg-application.c"
	}
#line 177 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp11_ = cmd;
#line 177 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp12_ = g_application_command_line_get_is_remote (_tmp11_);
#line 177 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (!_tmp12_) {
#line 939 "gitg-application.c"
		GApplicationCommandLine* _tmp13_ = NULL;
		GApplicationCommandLine* _tmp14_ = NULL;
#line 179 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp13_ = cmd;
#line 179 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp14_ = _g_object_ref0 (_tmp13_);
#line 179 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (gitg_application_options_command_line);
#line 179 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		gitg_application_options_command_line = _tmp14_;
#line 950 "gitg-application.c"
	}
#line 182 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp15_ = gitg_application_options_command_line;
#line 182 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp16_ = _g_object_ref0 (_tmp15_);
#line 182 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	tmpcmd = _tmp16_;
#line 183 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp17_ = cmd;
#line 183 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp18_ = _g_object_ref0 (_tmp17_);
#line 183 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (gitg_application_options_command_line);
#line 183 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_options_command_line = _tmp18_;
#line 185 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp19_ = argv;
#line 185 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp19__length1 = argv_length1;
#line 185 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp19__length1 > 1) {
#line 972 "gitg-application.c"
		GFile** files = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		GFile** _tmp21_ = NULL;
		gint files_length1 = 0;
		gint _files_size_ = 0;
		gint _tmp22_ = 0;
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		GFile** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		const gchar* _tmp30_ = NULL;
		GitgExtCommandLines* _tmp31_ = NULL;
#line 187 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp20_ = argv;
#line 187 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp20__length1 = argv_length1;
#line 187 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp21_ = g_new0 (GFile*, (_tmp20__length1 - 1) + 1);
#line 187 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		files = _tmp21_;
#line 187 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		files_length1 = _tmp20__length1 - 1;
#line 187 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_files_size_ = files_length1;
#line 188 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		files_length1 = 0;
#line 188 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp22_ = files_length1;
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp23_ = argv;
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp23__length1 = argv_length1;
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp24_ = argv;
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp24__length1 = argv_length1;
#line 1012 "gitg-application.c"
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			arg_collection = _tmp23_ + 1;
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			arg_collection_length1 = _tmp24__length1 - 1;
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			for (arg_it = 0; arg_it < (_tmp24__length1 - 1); arg_it = arg_it + 1) {
#line 1024 "gitg-application.c"
				gchar* _tmp25_ = NULL;
				gchar* arg = NULL;
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp25_ = g_strdup (arg_collection[arg_it]);
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				arg = _tmp25_;
#line 1031 "gitg-application.c"
				{
					GFile** _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					const gchar* _tmp27_ = NULL;
					GFile* _tmp28_ = NULL;
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp26_ = files;
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp26__length1 = files_length1;
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp27_ = arg;
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp28_ = g_file_new_for_commandline_arg (_tmp27_);
#line 192 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_vala_array_add10 (&files, &files_length1, &_files_size_, _tmp28_);
#line 190 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_free0 (arg);
#line 1049 "gitg-application.c"
				}
			}
		}
#line 195 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp29_ = files;
#line 195 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp29__length1 = files_length1;
#line 195 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp30_ = gitg_application_options_activity;
#line 195 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp31_ = command_lines;
#line 195 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		gitg_application_open_command_line (self, _tmp29_, _tmp29__length1, _tmp30_, _tmp31_);
#line 185 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1065 "gitg-application.c"
	} else {
		GitgExtCommandLines* _tmp32_ = NULL;
#line 199 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp32_ = command_lines;
#line 199 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		gitg_application_activate_command_line (self, _tmp32_);
#line 1072 "gitg-application.c"
	}
#line 202 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp33_ = tmpcmd;
#line 202 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp34_ = _g_object_ref0 (_tmp33_);
#line 202 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (gitg_application_options_command_line);
#line 202 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_options_command_line = _tmp34_;
#line 203 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	result = 1;
#line 203 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (tmpcmd);
#line 203 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (command_lines);
#line 203 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 203 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return result;
#line 1092 "gitg-application.c"
}


static void gitg_application_on_app_new_window_activated (GitgApplication* self) {
#line 206 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 208 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_new_window (self, NULL, NULL, NULL);
#line 1101 "gitg-application.c"
}


static void gitg_application_on_app_help_activated (GitgApplication* self) {
#line 211 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 1108 "gitg-application.c"
}


static void gitg_application_on_app_about_activated (GitgApplication* self) {
	gchar** artists = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** authors = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar* copyright = NULL;
	gchar* _tmp5_ = NULL;
	gchar* comments = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GList* wnds = NULL;
	GList* _tmp8_ = NULL;
	GtkWindow* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
#line 215 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 217 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_strdup ("Jakub Steiner <jimmac@gmail.com>");
#line 217 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 217 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_[0] = _tmp0_;
#line 217 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	artists = _tmp1_;
#line 217 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	artists_length1 = 1;
#line 217 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_artists_size_ = artists_length1;
#line 218 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = g_strdup ("Jesse van den Kieboom <jessevdk@gnome.org>");
#line 218 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3_ = g_strdup ("Ignacio Casal Quinteiro <icq@gnome.org>");
#line 218 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 218 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp4_[0] = _tmp2_;
#line 218 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp4_[1] = _tmp3_;
#line 218 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	authors = _tmp4_;
#line 218 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	authors_length1 = 2;
#line 218 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_authors_size_ = authors_length1;
#line 221 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp5_ = g_strdup ("Copyright \xc2\xa9 2012 Jesse van den Kieboom");
#line 221 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	copyright = _tmp5_;
#line 222 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp6_ = _ ("gitg is a Git repository viewer for gtk+/GNOME");
#line 222 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 222 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	comments = _tmp7_;
#line 224 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp8_ = gtk_application_get_windows ((GtkApplication*) self);
#line 224 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	wnds = _tmp8_;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp10_ = wnds;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp10_ != NULL) {
#line 1189 "gitg-application.c"
		GList* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp11_ = wnds;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp12_ = _tmp11_->data;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp9_ = (GtkWindow*) _tmp12_;
#line 1198 "gitg-application.c"
	} else {
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp9_ = NULL;
#line 1202 "gitg-application.c"
	}
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp13_ = artists;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp13__length1 = artists_length1;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp14_ = authors;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp14__length1 = authors_length1;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp15_ = copyright;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp16_ = comments;
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp17_ = _ ("translator-credits");
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp18_ = _ ("gitg homepage");
#line 226 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gtk_show_about_dialog (_tmp9_, "artists", _tmp13_, "authors", _tmp14_, "copyright", _tmp15_, "comments", _tmp16_, "translator-credits", _tmp17_, "version", VERSION, "website", PACKAGE_URL, "website-label", _tmp18_, "logo-icon-name", PACKAGE_NAME, "license-type", GTK_LICENSE_GPL_2_0, NULL);
#line 215 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 (comments);
#line 215 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 (copyright);
#line 215 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 215 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
#line 1230 "gitg-application.c"
}


static void gitg_application_on_app_quit_activated (GitgApplication* self) {
	GList* wnds = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
#line 239 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 241 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 241 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_list_copy (_tmp0_);
#line 241 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	wnds = _tmp1_;
#line 243 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = wnds;
#line 1249 "gitg-application.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 243 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		window_collection = _tmp2_;
#line 243 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 1257 "gitg-application.c"
			GtkWindow* window = NULL;
#line 243 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			window = (GtkWindow*) window_it->data;
#line 1261 "gitg-application.c"
			{
				GtkWindow* _tmp3_ = NULL;
#line 245 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp3_ = window;
#line 245 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 1268 "gitg-application.c"
			}
		}
	}
#line 239 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_list_free0 (wnds);
#line 1274 "gitg-application.c"
}


static void ___lambda128_ (GitgApplication* self, GtkWidget* w) {
#line 258 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (w != NULL);
#line 259 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_preferences);
#line 259 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self->priv->d_preferences = NULL;
#line 1285 "gitg-application.c"
}


static void ____lambda128__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 258 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	___lambda128_ ((GitgApplication*) self, _sender);
#line 1292 "gitg-application.c"
}


static void gitg_application_on_preferences_activated (GitgApplication* self) {
	GList* wnds = NULL;
	GList* _tmp0_ = NULL;
	GitgPreferencesDialog* _tmp1_ = NULL;
	GList* _tmp4_ = NULL;
	GitgPreferencesDialog* _tmp8_ = NULL;
#line 249 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 251 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 251 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	wnds = _tmp0_;
#line 254 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = self->priv->d_preferences;
#line 254 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp1_ == NULL) {
#line 1312 "gitg-application.c"
		gpointer _tmp2_ = NULL;
		GitgPreferencesDialog* _tmp3_ = NULL;
#line 256 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp2_ = gitg_resource_load_object (GITG_TYPE_PREFERENCES_DIALOG, (GBoxedCopyFunc) g_object_ref, g_object_unref, "ui/gitg-preferences.ui", "preferences");
#line 256 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (self->priv->d_preferences);
#line 256 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		self->priv->d_preferences = (GitgPreferencesDialog*) _tmp2_;
#line 258 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp3_ = self->priv->d_preferences;
#line 258 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		g_signal_connect_object ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda128__gtk_widget_destroy, self, 0);
#line 1325 "gitg-application.c"
	}
#line 263 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp4_ = wnds;
#line 263 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp4_ != NULL) {
#line 1331 "gitg-application.c"
		GitgPreferencesDialog* _tmp5_ = NULL;
		GList* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
#line 265 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp5_ = self->priv->d_preferences;
#line 265 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp6_ = wnds;
#line 265 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp7_ = _tmp6_->data;
#line 265 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) _tmp7_);
#line 1343 "gitg-application.c"
	}
#line 268 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp8_ = self->priv->d_preferences;
#line 268 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gtk_window_present ((GtkWindow*) _tmp8_);
#line 1349 "gitg-application.c"
}


static void _vala_GitgApplicationMultiAccel_array_free (GitgApplicationMultiAccel* array, gint array_length) {
#line 291 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (array != NULL) {
#line 1356 "gitg-application.c"
		int i;
#line 291 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 291 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			gitg_application_multi_accel_destroy (&array[i]);
#line 1362 "gitg-application.c"
		}
	}
#line 291 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_free (array);
#line 1367 "gitg-application.c"
}


static void gitg_application_real_startup (GApplication* base) {
	GitgApplication * self;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 302 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	static const GitgApplicationAccel single_accels[] = {{"app.new", "<Primary>N"}, {"app.quit", "<Primary>Q"}, {"app.help", "F1"}, {"win.search", "<Primary>F"}, {"win.gear-menu", "F10"}, {"win.open-repository", "<Primary>O"}, {"win.close", "<Primary>W"}};
#line 1377 "gitg-application.c"
	GitgApplicationMultiAccel* multi_accels = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	GitgApplicationMultiAccel _tmp6_ = {0};
	GitgApplicationMultiAccel* _tmp7_ = NULL;
	gint multi_accels_length1 = 0;
	gint _multi_accels_size_ = 0;
	GitgApplicationMultiAccel* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	GtkSettings* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp27_ = NULL;
	GtkCssProvider* _tmp28_ = NULL;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp31_ = NULL;
	GtkIconTheme* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
#line 291 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 293 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (gitg_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 296 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_settings_new ("org.gnome.gitg.state.window");
#line 296 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_state_settings);
#line 296 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self->priv->d_state_settings = _tmp0_;
#line 297 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = self->priv->d_state_settings;
#line 297 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_settings_delay (_tmp1_);
#line 300 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_action_map_add_action_entries ((GActionMap*) self, GITG_APPLICATION_app_entries, G_N_ELEMENTS (GITG_APPLICATION_app_entries), self);
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = g_strdup ("win.reload");
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3_ = g_strdup ("<Primary>R");
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp4_ = g_strdup ("F5");
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp5_ = g_new0 (gchar*, 2 + 1);
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp5_[0] = _tmp3_;
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp5_[1] = _tmp4_;
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	memset (&_tmp6_, 0, sizeof (GitgApplicationMultiAccel));
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 (_tmp6_.name);
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp6_.name = _tmp2_;
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp6_.accels = (_vala_array_free (_tmp6_.accels, _tmp6_.accels_length1, (GDestroyNotify) g_free), NULL);
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp6_.accels = _tmp5_;
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp6_.accels_length1 = 2;
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp6_._accels_size_ = _tmp6_.accels_length1;
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp7_ = g_new0 (GitgApplicationMultiAccel, 1);
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp7_[0] = _tmp6_;
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	multi_accels = _tmp7_;
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	multi_accels_length1 = 1;
#line 313 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_multi_accels_size_ = multi_accels_length1;
#line 1452 "gitg-application.c"
	{
		GitgApplicationAccel* accel_collection = NULL;
		gint accel_collection_length1 = 0;
		gint _accel_collection_size_ = 0;
		gint accel_it = 0;
#line 320 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		accel_collection = single_accels;
#line 320 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		accel_collection_length1 = G_N_ELEMENTS (single_accels);
#line 320 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		for (accel_it = 0; accel_it < G_N_ELEMENTS (single_accels); accel_it = accel_it + 1) {
#line 1464 "gitg-application.c"
			GitgApplicationAccel accel = {0};
#line 320 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			accel = accel_collection[accel_it];
#line 1468 "gitg-application.c"
			{
				GitgApplicationAccel _tmp8_ = {0};
				const gchar* _tmp9_ = NULL;
				GitgApplicationAccel _tmp10_ = {0};
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gchar** _tmp13_ = NULL;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp8_ = accel;
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp9_ = _tmp8_.name;
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp10_ = accel;
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp11_ = _tmp10_.accel;
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp12_ = g_strdup (_tmp11_);
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp13_ = g_new0 (gchar*, 1 + 1);
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp13_[0] = _tmp12_;
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp14_ = _tmp13_;
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp14__length1 = 1;
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				gtk_application_set_accels_for_action ((GtkApplication*) self, _tmp9_, _tmp14_);
#line 322 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 1500 "gitg-application.c"
			}
		}
	}
#line 325 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp15_ = multi_accels;
#line 325 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp15__length1 = multi_accels_length1;
#line 1508 "gitg-application.c"
	{
		GitgApplicationMultiAccel* accel_collection = NULL;
		gint accel_collection_length1 = 0;
		gint _accel_collection_size_ = 0;
		gint accel_it = 0;
#line 325 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		accel_collection = _tmp15_;
#line 325 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		accel_collection_length1 = _tmp15__length1;
#line 325 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		for (accel_it = 0; accel_it < _tmp15__length1; accel_it = accel_it + 1) {
#line 1520 "gitg-application.c"
			GitgApplicationMultiAccel _tmp16_ = {0};
			GitgApplicationMultiAccel accel = {0};
#line 325 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			gitg_application_multi_accel_copy (&accel_collection[accel_it], &_tmp16_);
#line 325 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			accel = _tmp16_;
#line 1527 "gitg-application.c"
			{
				GitgApplicationMultiAccel _tmp17_ = {0};
				const gchar* _tmp18_ = NULL;
				GitgApplicationMultiAccel _tmp19_ = {0};
				gchar** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
#line 327 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp17_ = accel;
#line 327 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp18_ = _tmp17_.name;
#line 327 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp19_ = accel;
#line 327 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp20_ = _tmp19_.accels;
#line 327 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp20__length1 = _tmp19_.accels_length1;
#line 327 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				gtk_application_set_accels_for_action ((GtkApplication*) self, _tmp18_, _tmp20_);
#line 325 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				gitg_application_multi_accel_destroy (&accel);
#line 1548 "gitg-application.c"
			}
		}
	}
#line 330 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp21_ = gtk_settings_get_default ();
#line 330 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_object_get (_tmp21_, "gtk-shell-shows-app-menu", &_tmp22_, NULL);
#line 330 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp23_ = _tmp22_;
#line 330 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp23_) {
#line 1560 "gitg-application.c"
		GMenuModel* menu = NULL;
		gpointer _tmp24_ = NULL;
		GMenuModel* _tmp25_ = NULL;
#line 332 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp24_ = gitg_resource_load_object (g_menu_model_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, "ui/gitg-menus.ui", "app-menu");
#line 332 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		menu = (GMenuModel*) _tmp24_;
#line 334 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp25_ = menu;
#line 334 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		if (_tmp25_ != NULL) {
#line 1572 "gitg-application.c"
			GMenuModel* _tmp26_ = NULL;
#line 336 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_tmp26_ = menu;
#line 336 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			gtk_application_set_app_menu ((GtkApplication*) self, _tmp26_);
#line 1578 "gitg-application.c"
		}
#line 330 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (menu);
#line 1582 "gitg-application.c"
	}
#line 341 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp27_ = gitg_resource_load_css ("style.css");
#line 341 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	provider = _tmp27_;
#line 343 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp28_ = provider;
#line 343 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp28_ != NULL) {
#line 1592 "gitg-application.c"
		GdkScreen* _tmp29_ = NULL;
		GtkCssProvider* _tmp30_ = NULL;
#line 345 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp29_ = gdk_screen_get_default ();
#line 345 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp30_ = provider;
#line 345 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		gtk_style_context_add_provider_for_screen (_tmp29_, (GtkStyleProvider*) _tmp30_, (guint) 600);
#line 1601 "gitg-application.c"
	}
#line 350 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp31_ = gtk_icon_theme_get_default ();
#line 350 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp32_ = _g_object_ref0 (_tmp31_);
#line 350 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	theme = _tmp32_;
#line 351 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp33_ = g_build_filename (GITG_DATADIR, "icons", NULL);
#line 351 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp34_ = _tmp33_;
#line 351 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gtk_icon_theme_prepend_search_path (theme, _tmp34_);
#line 351 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 (_tmp34_);
#line 291 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (theme);
#line 291 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (provider);
#line 291 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	multi_accels = (_vala_GitgApplicationMultiAccel_array_free (multi_accels, multi_accels_length1), NULL);
#line 1623 "gitg-application.c"
}


static void gitg_application_real_shutdown (GApplication* base) {
	GitgApplication * self;
	GSettings* _tmp0_ = NULL;
#line 354 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 356 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = self->priv->d_state_settings;
#line 356 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_settings_apply (_tmp0_);
#line 357 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (gitg_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1638 "gitg-application.c"
}


static void gitg_application_activate_command_line (GitgApplication* self, GitgExtCommandLines* command_lines) {
	gboolean _tmp0_ = FALSE;
#line 360 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 360 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (command_lines != NULL);
#line 362 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = gitg_application_options_no_wd;
#line 362 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp0_) {
#line 1652 "gitg-application.c"
		const gchar* _tmp1_ = NULL;
		GitgExtCommandLines* _tmp2_ = NULL;
#line 364 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp1_ = gitg_application_options_activity;
#line 364 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp2_ = command_lines;
#line 364 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		gitg_application_present_window (self, _tmp1_, _tmp2_);
#line 1661 "gitg-application.c"
	} else {
		gchar* wd = NULL;
		GApplicationCommandLine* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFile** _tmp8_ = NULL;
		GFile** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GitgExtCommandLines* _tmp12_ = NULL;
#line 369 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp3_ = gitg_application_options_command_line;
#line 369 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp4_ = g_application_command_line_get_cwd (_tmp3_);
#line 369 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 369 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		wd = _tmp5_;
#line 371 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp6_ = wd;
#line 371 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp7_ = g_file_new_for_path (_tmp6_);
#line 371 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp8_ = g_new0 (GFile*, 1 + 1);
#line 371 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp8_[0] = _tmp7_;
#line 371 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp9_ = _tmp8_;
#line 371 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp9__length1 = 1;
#line 371 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp10_ = gitg_application_options_activity;
#line 371 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		g_application_open ((GApplication*) self, _tmp9_, 1, _tmp10_);
#line 371 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_object_unref), NULL);
#line 372 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp11_ = gitg_application_options_activity;
#line 372 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp12_ = command_lines;
#line 372 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		gitg_application_present_window (self, _tmp11_, _tmp12_);
#line 362 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_g_free0 (wd);
#line 1709 "gitg-application.c"
	}
}


static void gitg_application_real_activate (GApplication* base) {
	GitgApplication * self;
#line 376 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 378 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_present_window (self, NULL, NULL);
#line 379 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (gitg_application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1722 "gitg-application.c"
}


static GitgWindow* gitg_application_find_window_for_file (GitgApplication* self, GFile* file) {
	GitgWindow* result = NULL;
	GList* _tmp0_ = NULL;
#line 382 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 382 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 384 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 1735 "gitg-application.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 384 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		window_collection = _tmp0_;
#line 384 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 1743 "gitg-application.c"
			GtkWindow* _tmp1_ = NULL;
			GtkWindow* window = NULL;
#line 384 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_tmp1_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 384 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			window = _tmp1_;
#line 1750 "gitg-application.c"
			{
				GitgWindow* wnd = NULL;
				GtkWindow* _tmp2_ = NULL;
				GitgWindow* _tmp3_ = NULL;
				GitgWindow* _tmp4_ = NULL;
				GitgRepository* _tmp5_ = NULL;
				GitgRepository* _tmp6_ = NULL;
				GitgRepository* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				GitgWindow* _tmp9_ = NULL;
				GitgRepository* _tmp10_ = NULL;
				GitgRepository* _tmp11_ = NULL;
				GitgRepository* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
#line 386 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp2_ = window;
#line 386 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_WINDOW) ? ((GitgWindow*) _tmp2_) : NULL);
#line 386 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				wnd = _tmp3_;
#line 388 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp4_ = wnd;
#line 388 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp5_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp4_);
#line 388 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp6_ = _tmp5_;
#line 388 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp7_ = _tmp6_;
#line 388 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp8_ = _tmp7_ == NULL;
#line 388 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (_tmp7_);
#line 388 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				if (_tmp8_) {
#line 390 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (wnd);
#line 390 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 390 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					continue;
#line 1795 "gitg-application.c"
				}
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp9_ = wnd;
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp10_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp9_);
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp11_ = _tmp10_;
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp12_ = _tmp11_;
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp13_ = ggit_repository_get_location ((GgitRepository*) _tmp12_);
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp14_ = _tmp13_;
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp15_ = file;
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp16_ = g_file_equal (_tmp14_, _tmp15_);
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp17_ = _tmp16_;
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (_tmp14_);
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (_tmp12_);
#line 393 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				if (_tmp17_) {
#line 395 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					result = wnd;
#line 395 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 395 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					return result;
#line 1827 "gitg-application.c"
				}
#line 384 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (wnd);
#line 384 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (window);
#line 1833 "gitg-application.c"
			}
		}
	}
#line 399 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	result = NULL;
#line 399 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return result;
#line 1841 "gitg-application.c"
}


static void gitg_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	GitgApplication * self;
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
#line 402 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 402 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (hint != NULL);
#line 404 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = files;
#line 404 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0__length1 = files_length1;
#line 404 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = hint;
#line 404 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_open_command_line (self, _tmp0_, _tmp0__length1, _tmp1_, NULL);
#line 1862 "gitg-application.c"
}


static void gitg_application_open_command_line (GitgApplication* self, GFile** files, int files_length1, const gchar* hint, GitgExtCommandLines* command_lines) {
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GFile** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GError * _inner_error_ = NULL;
#line 408 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 410 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = files;
#line 410 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0__length1 = files_length1;
#line 410 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp0__length1 == 0) {
#line 412 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		return;
#line 1882 "gitg-application.c"
	}
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = files;
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1__length1 = files_length1;
#line 1888 "gitg-application.c"
	{
		GFile** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		f_collection = _tmp1_;
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		f_collection_length1 = _tmp1__length1;
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		for (f_it = 0; f_it < _tmp1__length1; f_it = f_it + 1) {
#line 1900 "gitg-application.c"
			GFile* _tmp2_ = NULL;
			GFile* f = NULL;
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			_tmp2_ = _g_object_ref0 (f_collection[f_it]);
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
			f = _tmp2_;
#line 1907 "gitg-application.c"
			{
				GFile* resolved = NULL;
				GitgWindow* window = NULL;
				GFile* _tmp7_ = NULL;
				GitgWindow* _tmp8_ = NULL;
				GitgWindow* _tmp9_ = NULL;
				GitgRepository* repo = NULL;
				GitgRepository* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				GitgExtCommandLines* _tmp23_ = NULL;
				{
					GFile* _tmp3_ = NULL;
					GFile* _tmp4_ = NULL;
					GFile* _tmp5_ = NULL;
					GFile* _tmp6_ = NULL;
#line 423 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp4_ = f;
#line 423 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp5_ = ggit_repository_discover (_tmp4_, &_inner_error_);
#line 423 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp3_ = _tmp5_;
#line 423 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1931 "gitg-application.c"
						goto __catch36_g_error;
					}
#line 423 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp6_ = _tmp3_;
#line 423 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp3_ = NULL;
#line 423 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 423 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					resolved = _tmp6_;
#line 421 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (_tmp3_);
#line 1944 "gitg-application.c"
				}
				goto __finally36;
				__catch36_g_error:
				{
#line 421 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 421 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_inner_error_ = NULL;
#line 425 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 425 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 425 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					continue;
#line 1959 "gitg-application.c"
				}
				__finally36:
#line 421 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 421 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 421 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 421 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 421 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 421 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					return;
#line 1974 "gitg-application.c"
				}
#line 428 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp7_ = resolved;
#line 428 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp8_ = gitg_application_find_window_for_file (self, _tmp7_);
#line 428 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				window = _tmp8_;
#line 430 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp9_ = window;
#line 430 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				if (_tmp9_ != NULL) {
#line 1986 "gitg-application.c"
					GitgWindow* _tmp10_ = NULL;
					GApplicationCommandLine* _tmp11_ = NULL;
					gchar** _tmp12_ = NULL;
					gchar** _tmp13_ = NULL;
					GitgWindow* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					GitgExtCommandLines* _tmp16_ = NULL;
#line 433 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp10_ = window;
#line 433 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp11_ = gitg_application_options_command_line;
#line 433 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp13_ = _tmp12_ = g_application_command_line_get_environ (_tmp11_);
#line 433 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					gitg_window_set_environment (_tmp10_, _tmp13_, _vala_array_length (_tmp12_));
#line 434 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp14_ = window;
#line 434 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp15_ = hint;
#line 434 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp16_ = command_lines;
#line 434 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					gitg_window_present (_tmp14_, _tmp15_, _tmp16_);
#line 435 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 435 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 435 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 435 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					continue;
#line 2018 "gitg-application.c"
				}
				{
					GitgRepository* _tmp17_ = NULL;
					GFile* _tmp18_ = NULL;
					GitgRepository* _tmp19_ = NULL;
					GitgRepository* _tmp20_ = NULL;
#line 443 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp18_ = resolved;
#line 443 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp19_ = gitg_repository_new (_tmp18_, NULL, &_inner_error_);
#line 443 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp17_ = _tmp19_;
#line 443 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2033 "gitg-application.c"
						goto __catch37_g_error;
					}
#line 443 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp20_ = _tmp17_;
#line 443 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_tmp17_ = NULL;
#line 443 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (repo);
#line 443 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					repo = _tmp20_;
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (_tmp17_);
#line 2046 "gitg-application.c"
				}
				goto __finally37;
				__catch37_g_error:
				{
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_inner_error_ = NULL;
#line 445 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (repo);
#line 445 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 445 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 445 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 445 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					continue;
#line 2065 "gitg-application.c"
				}
				__finally37:
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (repo);
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 441 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
					return;
#line 2084 "gitg-application.c"
				}
#line 448 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp21_ = repo;
#line 448 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp22_ = hint;
#line 448 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_tmp23_ = command_lines;
#line 448 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				gitg_application_new_window (self, _tmp21_, _tmp22_, _tmp23_);
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (repo);
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (window);
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (resolved);
#line 416 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (f);
#line 2102 "gitg-application.c"
			}
		}
	}
}


static void gitg_application_new_window (GitgApplication* self, GitgRepository* repo, const gchar* hint, GitgExtCommandLines* command_lines) {
	GitgWindow* window = NULL;
	GitgRepository* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GitgWindow* _tmp2_ = NULL;
	GitgWindow* _tmp3_ = NULL;
	const gchar* _tmp8_ = NULL;
	GitgExtCommandLines* _tmp9_ = NULL;
#line 452 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 454 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = repo;
#line 454 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = hint;
#line 454 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = gitg_window_create_new ((GtkApplication*) self, _tmp0_, _tmp1_);
#line 454 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	window = _tmp2_;
#line 456 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3_ = window;
#line 456 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp3_ != NULL) {
#line 2131 "gitg-application.c"
		GitgWindow* _tmp4_ = NULL;
		GApplicationCommandLine* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
#line 458 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp4_ = window;
#line 458 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp5_ = gitg_application_options_command_line;
#line 458 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp7_ = _tmp6_ = g_application_command_line_get_environ (_tmp5_);
#line 458 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		gitg_window_set_environment (_tmp4_, _tmp7_, _vala_array_length (_tmp6_));
#line 2144 "gitg-application.c"
	}
#line 461 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp8_ = hint;
#line 461 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp9_ = command_lines;
#line 461 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_present_window (self, _tmp8_, _tmp9_);
#line 452 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (window);
#line 2154 "gitg-application.c"
}


static void gitg_application_present_window (GitgApplication* self, const gchar* activity, GitgExtCommandLines* command_lines) {
	GList* windows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GitgWindow* w = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GitgWindow* _tmp5_ = NULL;
	GitgWindow* _tmp6_ = NULL;
	GApplicationCommandLine* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	GitgWindow* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GitgExtCommandLines* _tmp12_ = NULL;
#line 464 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 470 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 470 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	windows = _tmp0_;
#line 472 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = windows;
#line 472 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	if (_tmp1_ == NULL) {
#line 474 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		gitg_application_new_window (self, NULL, NULL, NULL);
#line 475 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		return;
#line 2188 "gitg-application.c"
	}
#line 478 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = windows;
#line 478 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3_ = g_list_first (_tmp2_);
#line 478 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp4_ = _tmp3_->data;
#line 478 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp4_, GITG_TYPE_WINDOW, GitgWindow));
#line 478 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	w = _tmp5_;
#line 480 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp6_ = w;
#line 480 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp7_ = gitg_application_options_command_line;
#line 480 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp9_ = _tmp8_ = g_application_command_line_get_environ (_tmp7_);
#line 480 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_window_set_environment (_tmp6_, _tmp9_, _vala_array_length (_tmp8_));
#line 481 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp10_ = w;
#line 481 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp11_ = activity;
#line 481 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp12_ = command_lines;
#line 481 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_window_present (_tmp10_, _tmp11_, _tmp12_);
#line 464 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (w);
#line 2218 "gitg-application.c"
}


GSettings* gitg_application_get_state_settings (GitgApplication* self) {
	GSettings* result;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 29 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = self->priv->d_state_settings;
#line 29 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 29 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	result = _tmp1_;
#line 29 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return result;
#line 2236 "gitg-application.c"
}


static gboolean gitg_application_options_commit_activity (void) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
#line 50 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_strdup ("commit");
#line 50 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 (gitg_application_options_activity);
#line 50 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_options_activity = _tmp0_;
#line 51 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	result = TRUE;
#line 51 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return result;
#line 2253 "gitg-application.c"
}


static GitgApplicationOptions* gitg_application_options_dup (const GitgApplicationOptions* self) {
	GitgApplicationOptions* dup;
#line 40 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	dup = g_new0 (GitgApplicationOptions, 1);
#line 40 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	memcpy (dup, self, sizeof (GitgApplicationOptions));
#line 40 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return dup;
#line 2265 "gitg-application.c"
}


static void gitg_application_options_free (GitgApplicationOptions* self) {
#line 40 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_free (self);
#line 2272 "gitg-application.c"
}


static GType gitg_application_options_get_type (void) {
	static volatile gsize gitg_application_options_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_options_type_id__volatile)) {
		GType gitg_application_options_type_id;
		gitg_application_options_type_id = g_boxed_type_register_static ("GitgApplicationOptions", (GBoxedCopyFunc) gitg_application_options_dup, (GBoxedFreeFunc) gitg_application_options_free);
		g_once_init_leave (&gitg_application_options_type_id__volatile, gitg_application_options_type_id);
	}
	return gitg_application_options_type_id__volatile;
}


static void gitg_application_accel_copy (const GitgApplicationAccel* self, GitgApplicationAccel* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = (*self).name;
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 ((*dest).name);
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*dest).name = _tmp1_;
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = (*self).accel;
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 ((*dest).accel);
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*dest).accel = _tmp3_;
#line 2308 "gitg-application.c"
}


static void gitg_application_accel_destroy (GitgApplicationAccel* self) {
#line 281 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 ((*self).name);
#line 282 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 ((*self).accel);
#line 2317 "gitg-application.c"
}


static GitgApplicationAccel* gitg_application_accel_dup (const GitgApplicationAccel* self) {
	GitgApplicationAccel* dup;
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	dup = g_new0 (GitgApplicationAccel, 1);
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_accel_copy (self, dup);
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return dup;
#line 2329 "gitg-application.c"
}


static void gitg_application_accel_free (GitgApplicationAccel* self) {
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_accel_destroy (self);
#line 279 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_free (self);
#line 2338 "gitg-application.c"
}


static GType gitg_application_accel_get_type (void) {
	static volatile gsize gitg_application_accel_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_accel_type_id__volatile)) {
		GType gitg_application_accel_type_id;
		gitg_application_accel_type_id = g_boxed_type_register_static ("GitgApplicationAccel", (GBoxedCopyFunc) gitg_application_accel_dup, (GBoxedFreeFunc) gitg_application_accel_free);
		g_once_init_leave (&gitg_application_accel_type_id__volatile, gitg_application_accel_type_id);
	}
	return gitg_application_accel_type_id__volatile;
}


static gchar** _vala_array_dup17 (gchar** self, int length) {
	gchar** result;
	int i;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	result = g_new0 (gchar*, length + 1);
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	for (i = 0; i < length; i++) {
#line 2360 "gitg-application.c"
		gchar* _tmp0_ = NULL;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		_tmp0_ = g_strdup (self[i]);
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		result[i] = _tmp0_;
#line 2366 "gitg-application.c"
	}
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return result;
#line 2370 "gitg-application.c"
}


static void gitg_application_multi_accel_copy (const GitgApplicationMultiAccel* self, GitgApplicationMultiAccel* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = (*self).name;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 ((*dest).name);
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*dest).name = _tmp1_;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2_ = (*self).accels;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp2__length1 = (*self).accels_length1;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup17 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp3__length1 = _tmp2__length1;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*dest).accels = (_vala_array_free ((*dest).accels, (*dest).accels_length1, (GDestroyNotify) g_free), NULL);
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*dest).accels = _tmp3_;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*dest).accels_length1 = _tmp3__length1;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*dest)._accels_size_ = (*dest).accels_length1;
#line 2405 "gitg-application.c"
}


static void gitg_application_multi_accel_destroy (GitgApplicationMultiAccel* self) {
#line 287 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 ((*self).name);
#line 288 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	(*self).accels = (_vala_array_free ((*self).accels, (*self).accels_length1, (GDestroyNotify) g_free), NULL);
#line 2414 "gitg-application.c"
}


static GitgApplicationMultiAccel* gitg_application_multi_accel_dup (const GitgApplicationMultiAccel* self) {
	GitgApplicationMultiAccel* dup;
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	dup = g_new0 (GitgApplicationMultiAccel, 1);
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_multi_accel_copy (self, dup);
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	return dup;
#line 2426 "gitg-application.c"
}


static void gitg_application_multi_accel_free (GitgApplicationMultiAccel* self) {
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_multi_accel_destroy (self);
#line 285 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_free (self);
#line 2435 "gitg-application.c"
}


static GType gitg_application_multi_accel_get_type (void) {
	static volatile gsize gitg_application_multi_accel_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_multi_accel_type_id__volatile)) {
		GType gitg_application_multi_accel_type_id;
		gitg_application_multi_accel_type_id = g_boxed_type_register_static ("GitgApplicationMultiAccel", (GBoxedCopyFunc) gitg_application_multi_accel_dup, (GBoxedFreeFunc) gitg_application_multi_accel_free);
		g_once_init_leave (&gitg_application_multi_accel_type_id__volatile, gitg_application_multi_accel_type_id);
	}
	return gitg_application_multi_accel_type_id__volatile;
}


static void gitg_application_class_init (GitgApplicationClass * klass) {
	gchar* _tmp0_ = NULL;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_type_class_add_private (klass, sizeof (GitgApplicationPrivate));
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->local_command_line = gitg_application_real_local_command_line;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->command_line = gitg_application_real_command_line;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->startup = gitg_application_real_startup;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->shutdown = gitg_application_real_shutdown;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->activate = gitg_application_real_activate;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->open = gitg_application_real_open;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_application_get_property;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_application_finalize;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_APPLICATION_STATE_SETTINGS, g_param_spec_object ("state-settings", "state-settings", "state-settings", G_TYPE_SETTINGS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 75 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_strdup ("");
#line 75 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_free0 (gitg_application_options_activity);
#line 75 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	gitg_application_options_activity = _tmp0_;
#line 2480 "gitg-application.c"
}


static void gitg_application_instance_init (GitgApplication * self) {
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self->priv = GITG_APPLICATION_GET_PRIVATE (self);
#line 2487 "gitg-application.c"
}


static void gitg_application_finalize (GObject* obj) {
	GitgApplication * self;
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_APPLICATION, GitgApplication);
#line 25 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_state_settings);
#line 71 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_preferences);
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	G_OBJECT_CLASS (gitg_application_parent_class)->finalize (obj);
#line 2501 "gitg-application.c"
}


GType gitg_application_get_type (void) {
	static volatile gsize gitg_application_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgApplication), 0, (GInstanceInitFunc) gitg_application_instance_init, NULL };
		GType gitg_application_type_id;
		gitg_application_type_id = g_type_register_static (gtk_application_get_type (), "GitgApplication", &g_define_type_info, 0);
		g_once_init_leave (&gitg_application_type_id__volatile, gitg_application_type_id);
	}
	return gitg_application_type_id__volatile;
}


static void _vala_gitg_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_APPLICATION, GitgApplication);
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
	switch (property_id) {
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		case GITG_APPLICATION_STATE_SETTINGS:
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		g_value_take_object (value, gitg_application_get_state_settings (self));
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		break;
#line 2528 "gitg-application.c"
		default:
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/devel/gitg/gitg/gitg-application.vala"
		break;
#line 2534 "gitg-application.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



