/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
 
/*
 */
 
package com.sun.appserv.management.util.misc;

import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;


public final class ListUtil
{
		private
	ListUtil( )
	{
		// disallow instantiation
	}
	
	/**
		Add all items in an array to a list.
	 */
		public static <T> void
	addArray(
		final List<T> 	 list,
		final T[]	     array )
	{
		for( int i = 0; i < array.length; ++i )
		{
			list.add( array[ i ] );
		}
	}
	
	/**
		Convert a List to a String[]
	 */
		public static String[]
	toStringArray( final List<?>	list )
	{
		final String[]	names	= new String[ list.size() ];
		
		int i   = 0;
		for( final Object o : list )
		{
		    names[ i ] = "" + o;
		    ++i;
		}
		
		return( names );
	}
	
	/**
		Create a new List from a Collection
	 */
		public static <T> List<T>
	newListFromCollection( final Collection<T> c )
	{
		final List<T>	list	= new ArrayList<T>();
		
		list.addAll( c );
		
		return( list );
	}
	
	/**
		Create a new List from a Collection
	 */
		public static <T> List<? extends T>
	newListFromIterator( final Iterator<? extends T> iter )
	{
		final List<T>	list	= new ArrayList<T>();
		
		while ( iter.hasNext() )
		{
			list.add( iter.next() );
		}
		
		return( list );
	}
	
	/**
		Create a new List with one member.
	 */
		public static <T> List<T>
	newList( T m1 )
	{
		final List<T>	list	= new ArrayList<T>();
		
		list.add( m1 );
		
		return( list );
	}
	
	/**
		Create a new List with two members.
	 */
		public static <T> List<T>
	newList(
		final T m1,
		final T m2 )
	{
		final List<T>	list	= new ArrayList<T>();
		
		list.add( m1 );
		list.add( m2 );
		
		return( list );
	}
	
	
	/**
		Create a new List with three members.
	 */
		public static <T> List<T>
	newList(
		final T m1,
		final T m2, 
		final T m3 )
	{
		final List<T> 	list	= new ArrayList<T>();
		
		list.add( m1 );
		list.add( m2 );
		list.add( m3 );
		
		return( list );
	}
	
	/**
		Create a new List with four members.
	 */
		public static <T> List<T>
	newList(
		final T m1,
		final T m2, 
		final T m3, 
		final T m4 )
	{
		final List<T> 	list	= new ArrayList<T> ();
		
		list.add( m1 );
		list.add( m2 );
		list.add( m3 );
		list.add( m4 );
		
		return( list );
	}
	
	/**
		Create a new List with four members.
	 */
		public static <T> List<T>
	newList(
		final T m1,
		final T m2, 
		final T m3, 
		final T m4, 
		final T m5 )
	{
		final List<T> 	list	= new ArrayList<T> ();
		
		list.add( m1 );
		list.add( m2 );
		list.add( m3 );
		list.add( m4 );
		list.add( m5 );
		
		return( list );
	}
	
	

		public static <T> List<T>
	newListFromArray( final T []  items )
	{
		final List<T>	list	= new ArrayList<T>();
		
		for( int i = 0; i < items.length; ++i )
		{
			list.add( items[ i ] );
		}

		return( list );
	}

	/**
		Return a new List in reverse order. Because the List is new,
		it works on any list, modifiable or not.
	 */
		public static <T> List<T>
	reverse( final List<T> list )
	{
		final int	numItems	= list.size();
		final List<T> result		= new ArrayList<T>( numItems );
		
		for( int i = 0; i < numItems; ++i )
		{
			result.add( list.get( numItems - i -1 ) );
		}
		
		return( result );
	}

}

