/* upnp_connmgr.h - UPnP Connection Manager definitions
 *
 * Copyright (C) 2005   Ivo Clarysse
 *
 * This file is part of GMediaRender.
 *
 * GMediaRender is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GMediaRender is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GMediaRender; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA 02110-1301, USA.
 *
 */

#ifndef _UPNP_CONNMGR_H
#define _UPNP_CONNMGR_H

#include <glib.h>

typedef struct mime_type_filters_t
{
	GSList* allowed_roots;
	GSList* removed_types;
	GSList* added_types;
} mime_type_filters_t;

struct service *upnp_connmgr_get_service(void);
int connmgr_init(const char* mime_filter);

void register_mime_type(const char *mime_type);

#endif /* _UPNP_CONNMGR_H */
