#include <glib-object.h>
#include "gm-mcp-awns-status.h"
#include "gm-mcp-session.h"
#include "gm-mcp.h"
#include "gm-world.h"
#include "gm-debug.h"
#include "widgets/gm-world-view.h"

#define GM_MCP_AWNS_STATUS_GET_PRIVATE(object)( \
		G_TYPE_INSTANCE_GET_PRIVATE((object), \
		GM_TYPE_MCP_AWNS_STATUS, GmMcpAwnsStatusPrivate))

struct _GmMcpAwnsStatusPrivate {
	gchar *status;
};

typedef struct _GmMcpAwnsStatusView {
	GmMcpAwnsStatus *package;
	GmWorldView *view;
} GmMcpAwnsStatusView;

/* Signals */

enum {
	STATUS_CHANGED,
	NUM_SIGNALS
};

static guint gm_mcp_awns_status_signals[NUM_SIGNALS] = {0};
void gm_mcp_awns_status_handle_simple(GmMcpPackage *package, gchar *suffix,
		GList *fields);
void gm_mcp_awns_status_create_view(GmMcpPackage *package, GObject *parent);

G_DEFINE_TYPE(GmMcpAwnsStatus, gm_mcp_awns_status, GM_TYPE_MCP_PACKAGE)

static void
gm_mcp_awns_status_finalize(GObject *object) {
	//GmMcpAwnsStatus *obj = GM_MCP_AWNS_STATUS(object);
	
	G_OBJECT_CLASS(gm_mcp_awns_status_parent_class)->finalize(object);
}

static void
gm_mcp_awns_status_class_init(GmMcpAwnsStatusClass *klass) {
	GObjectClass *object_class = G_OBJECT_CLASS(klass);
	GmMcpPackageClass *pklass = GM_MCP_PACKAGE_CLASS(klass);
	
	object_class->finalize = gm_mcp_awns_status_finalize;

	gm_mcp_awns_status_signals[STATUS_CHANGED] = 
		g_signal_new("status_changed",
			G_OBJECT_CLASS_TYPE(object_class),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET(GmMcpAwnsStatusClass, status_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);
			
	pklass->name = "dns-com-awns-status";
	pklass->handle_simple = &gm_mcp_awns_status_handle_simple;
	pklass->create_view = &gm_mcp_awns_status_create_view;
	
	g_type_class_add_private(object_class, sizeof(GmMcpAwnsStatusPrivate));
}

static void
gm_mcp_awns_status_init(GmMcpAwnsStatus *obj) {
	obj->priv = GM_MCP_AWNS_STATUS_GET_PRIVATE(obj);
}

/* Public */
GmMcpAwnsStatus *
gm_mcp_awns_status_new() {
	GmMcpAwnsStatus *obj = GM_MCP_AWNS_STATUS(g_object_new(
			GM_TYPE_MCP_AWNS_STATUS, NULL));
	
	return obj;
}

/* Private */
void
gm_mcp_awns_status_handle_simple(GmMcpPackage *package, gchar *suffix,
		GList *fields) {
	gchar const *text = gm_mcp_find_value(fields, "text");
	
	gm_debug_msg(DEBUG_MCP, "GmMcpAwnsStatus.HandleSimple: set status %s", 
			text);
	g_signal_emit(package, gm_mcp_awns_status_signals[STATUS_CHANGED], 0, text);
}

/* GmMcpAwnsStatusView */

void
on_gm_mcp_awns_status_view_status_changed(GmMcpAwnsStatus *package, 
		gchar const *status, GmMcpAwnsStatusView *view) {
	gm_world_view_update_status(view->view, status);
}

void
on_gm_mcp_awns_status_view_weak_notify(gpointer data, GObject *obj) {
	g_free(data);
}

void
gm_mcp_awns_status_create_view(GmMcpPackage *package, GObject *parent) {
	GmMcpAwnsStatusView *status_view;
	
	if (GM_IS_WORLD_VIEW(parent)) {
		status_view = g_new0(GmMcpAwnsStatusView, 1);
		status_view->package = GM_MCP_AWNS_STATUS(package);
		status_view->view = GM_WORLD_VIEW(parent);
		
		g_signal_connect(package, "status_changed",
				G_CALLBACK(on_gm_mcp_awns_status_view_status_changed),
				status_view);
		g_object_weak_ref(G_OBJECT(package), 
				on_gm_mcp_awns_status_view_weak_notify, status_view);
		
	}
}


