#ifndef __GM_MCP_PACKAGE_H__
#define __GM_MCP_PACKAGE_H__

#include <glib-object.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_MCP_PACKAGE					(gm_mcp_package_get_type())
#define GM_MCP_PACKAGE(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_MCP_PACKAGE, GmMcpPackage))
#define GM_MCP_PACKAGE_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj),\
		GM_TYPE_MCP_PACKAGE, GmMcpPackage const))
#define GM_MCP_PACKAGE_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_MCP_PACKAGE, GmMcpPackageClass))
#define GM_IS_MCP_PACKAGE(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_MCP_PACKAGE))
#define GM_IS_MCP_PACKAGE_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_MCP_PACKAGE))
#define GM_MCP_PACKAGE_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_MCP_PACKAGE, GmMcpPackageClass))
#define GM_MCP_PACKAGE_SESSION(obj)			(GM_MCP_SESSION( \
		gm_mcp_package_get_session(GM_MCP_PACKAGE(obj))))

/* Private structure type */
typedef struct _GmMcpPackagePrivate GmMcpPackagePrivate;

/*
 * Main object structure
 */
typedef struct _GmMcpPackage GmMcpPackage;
 
struct _GmMcpPackage {
	GObject parent;
	
	/*< private > */
	GmMcpPackagePrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmMcpPackageClass 	GmMcpPackageClass;

struct _GmMcpPackageClass {
	GObjectClass parent_class;

	gchar *name;
	gdouble min_version;
	gdouble max_version;	
	gchar **depends;
	gchar **overrides;
	
	void (* handle_simple)(GmMcpPackage *package, gchar *suffix, GList *fields);
	gboolean (* handle_multi)(GmMcpPackage *package, gchar const *data_tag,
			gchar const *key, gchar const *value, GList *all_values);
	void (* create_view)(GmMcpPackage *package, GObject *owner);
	void (* set_session)(GmMcpPackage *package, GObject *session);

	/* Signals
	void (* proto) (GmMcpPackage *obj); */
};

/* Public */
GType gm_mcp_package_get_type(void) G_GNUC_CONST;
GmMcpPackage *gm_mcp_package_new();
void gm_mcp_package_set_session(GmMcpPackage *package, GObject *session);

void gm_mcp_package_handle_simple(GmMcpPackage *package, gchar *suffix, 
		GList *fields);
gboolean gm_mcp_package_can_handle_simple(GmMcpPackage *package);

gboolean gm_mcp_package_handle_multi(GmMcpPackage *package, gchar *data_tag, 
		gchar *key, gchar *value, GList *allValues);
gboolean gm_mcp_package_can_handle_multi(GmMcpPackage *package);

void gm_mcp_package_create_view(GmMcpPackage *package, GObject *parent);
gboolean gm_mcp_package_can_create_view(GmMcpPackage *package);

void gm_mcp_package_set_version(GmMcpPackage *package, gdouble version);
gdouble gm_mcp_package_get_version(GmMcpPackage *package);
GObject *gm_mcp_package_get_session(GmMcpPackage *package);

/* Class getters */
gchar const *gm_mcp_package_get_name(GmMcpPackage *package);
gchar **gm_mcp_package_get_depends(GmMcpPackage *package);
gchar **gm_mcp_package_get_overrides(GmMcpPackage *package);
gdouble gm_mcp_package_get_min_version(GmMcpPackage *package);
gdouble gm_mcp_package_get_max_version(GmMcpPackage *package);

G_END_DECLS
#endif /* __GM_MCP_PACKAGE_H__ */
