// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about an event data store specified as either an ARN or the
// ID portion of the ARN.
func (c *Client) GetEventDataStore(ctx context.Context, params *GetEventDataStoreInput, optFns ...func(*Options)) (*GetEventDataStoreOutput, error) {
	if params == nil {
		params = &GetEventDataStoreInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEventDataStore", params, optFns, c.addOperationGetEventDataStoreMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEventDataStoreOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEventDataStoreInput struct {

	// The ARN (or ID suffix of the ARN) of the event data store about which you want
	// information.
	//
	// This member is required.
	EventDataStore *string

	noSmithyDocumentSerde
}

type GetEventDataStoreOutput struct {

	// The advanced event selectors used to select events for the data store.
	AdvancedEventSelectors []types.AdvancedEventSelector

	// The billing mode for the event data store.
	BillingMode types.BillingMode

	// The timestamp of the event data store's creation.
	CreatedTimestamp *time.Time

	// The event data store Amazon Resource Number (ARN).
	EventDataStoreArn *string

	//  If Lake query federation is enabled, provides the ARN of the federation role
	// used to access the resources for the federated event data store.
	FederationRoleArn *string

	//  Indicates the [Lake query federation] status. The status is ENABLED if Lake query federation is
	// enabled, or DISABLED if Lake query federation is disabled. You cannot delete an
	// event data store if the FederationStatus is ENABLED .
	//
	// [Lake query federation]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html
	FederationStatus types.FederationStatus

	// Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The
	// value is a fully specified ARN to a KMS key in the following format.
	//
	//     arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string

	// Indicates whether the event data store includes events from all Regions, or
	// only from the Region in which it was created.
	MultiRegionEnabled *bool

	// The name of the event data store.
	Name *string

	// Indicates whether an event data store is collecting logged events for an
	// organization in Organizations.
	OrganizationEnabled *bool

	// The partition keys for the event data store. To improve query performance and
	// efficiency, CloudTrail Lake organizes event data into partitions based on values
	// derived from partition keys.
	PartitionKeys []types.PartitionKey

	// The retention period of the event data store, in days.
	RetentionPeriod *int32

	// The status of an event data store.
	Status types.EventDataStoreStatus

	// Indicates that termination protection is enabled.
	TerminationProtectionEnabled *bool

	// Shows the time that an event data store was updated, if applicable.
	// UpdatedTimestamp is always either the same or newer than the time shown in
	// CreatedTimestamp .
	UpdatedTimestamp *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEventDataStoreMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetEventDataStore{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetEventDataStore{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEventDataStore"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetEventDataStoreValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEventDataStore(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEventDataStore(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEventDataStore",
	}
}
