// Code generated by smithy-go-codegen DO NOT EDIT.

package tnb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/tnb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the details of the network instance.
//
// A network instance is a single network created in Amazon Web Services TNB that
// can be deployed and on which life-cycle operations (like terminate, update, and
// delete) can be performed.
func (c *Client) GetSolNetworkInstance(ctx context.Context, params *GetSolNetworkInstanceInput, optFns ...func(*Options)) (*GetSolNetworkInstanceOutput, error) {
	if params == nil {
		params = &GetSolNetworkInstanceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSolNetworkInstance", params, optFns, c.addOperationGetSolNetworkInstanceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSolNetworkInstanceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSolNetworkInstanceInput struct {

	// ID of the network instance.
	//
	// This member is required.
	NsInstanceId *string

	noSmithyDocumentSerde
}

type GetSolNetworkInstanceOutput struct {

	// Network instance ARN.
	//
	// This member is required.
	Arn *string

	// Network instance ID.
	//
	// This member is required.
	Id *string

	// The metadata of a network instance.
	//
	// A network instance is a single network created in Amazon Web Services TNB that
	// can be deployed and on which life-cycle operations (like terminate, update, and
	// delete) can be performed.
	//
	// This member is required.
	Metadata *types.GetSolNetworkInstanceMetadata

	// Network instance description.
	//
	// This member is required.
	NsInstanceDescription *string

	// Network instance name.
	//
	// This member is required.
	NsInstanceName *string

	// Network service descriptor ID.
	//
	// This member is required.
	NsdId *string

	// Network service descriptor info ID.
	//
	// This member is required.
	NsdInfoId *string

	// Lifecycle management operation details on the network instance.
	//
	// Lifecycle management operations are deploy, update, or delete operations.
	LcmOpInfo *types.LcmOperationInfo

	// Network instance state.
	NsState types.NsState

	// A tag is a label that you assign to an Amazon Web Services resource. Each tag
	// consists of a key and an optional value. You can use tags to search and filter
	// your resources or track your Amazon Web Services costs.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSolNetworkInstanceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSolNetworkInstance{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSolNetworkInstance{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSolNetworkInstance"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetSolNetworkInstanceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSolNetworkInstance(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSolNetworkInstance(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSolNetworkInstance",
	}
}
