// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudsearch provides a client for Amazon CloudSearch.
package cloudsearch

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBuildSuggesters = "BuildSuggesters"

// BuildSuggestersRequest generates a "aws/request.Request" representing the
// client's request for the BuildSuggesters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BuildSuggesters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BuildSuggesters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BuildSuggestersRequest method.
//    req, resp := client.BuildSuggestersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) BuildSuggestersRequest(input *BuildSuggestersInput) (req *request.Request, output *BuildSuggestersOutput) {
	op := &request.Operation{
		Name:       opBuildSuggesters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BuildSuggestersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BuildSuggestersOutput{}
	req.Data = output
	return
}

// BuildSuggesters API operation for Amazon CloudSearch.
//
// Indexes the search suggestions. For more information, see Configuring Suggesters
// (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation BuildSuggesters for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) BuildSuggesters(input *BuildSuggestersInput) (*BuildSuggestersOutput, error) {
	req, out := c.BuildSuggestersRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDomainOutput{}
	req.Data = output
	return
}

// CreateDomain API operation for Amazon CloudSearch.
//
// Creates a new search domain. For more information, see Creating a Search
// Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation CreateDomain for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * LimitExceeded
//   The request was rejected because a resource limit has already been met.
//
func (c *CloudSearch) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDefineAnalysisScheme = "DefineAnalysisScheme"

// DefineAnalysisSchemeRequest generates a "aws/request.Request" representing the
// client's request for the DefineAnalysisScheme operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DefineAnalysisScheme for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DefineAnalysisScheme method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DefineAnalysisSchemeRequest method.
//    req, resp := client.DefineAnalysisSchemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DefineAnalysisSchemeRequest(input *DefineAnalysisSchemeInput) (req *request.Request, output *DefineAnalysisSchemeOutput) {
	op := &request.Operation{
		Name:       opDefineAnalysisScheme,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineAnalysisSchemeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DefineAnalysisSchemeOutput{}
	req.Data = output
	return
}

// DefineAnalysisScheme API operation for Amazon CloudSearch.
//
// Configures an analysis scheme that can be applied to a text or text-array
// field to define language-specific text processing options. For more information,
// see Configuring Analysis Schemes (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DefineAnalysisScheme for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * LimitExceeded
//   The request was rejected because a resource limit has already been met.
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DefineAnalysisScheme(input *DefineAnalysisSchemeInput) (*DefineAnalysisSchemeOutput, error) {
	req, out := c.DefineAnalysisSchemeRequest(input)
	err := req.Send()
	return out, err
}

const opDefineExpression = "DefineExpression"

// DefineExpressionRequest generates a "aws/request.Request" representing the
// client's request for the DefineExpression operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DefineExpression for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DefineExpression method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DefineExpressionRequest method.
//    req, resp := client.DefineExpressionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DefineExpressionRequest(input *DefineExpressionInput) (req *request.Request, output *DefineExpressionOutput) {
	op := &request.Operation{
		Name:       opDefineExpression,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineExpressionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DefineExpressionOutput{}
	req.Data = output
	return
}

// DefineExpression API operation for Amazon CloudSearch.
//
// Configures an Expression for the search domain. Used to create new expressions
// and modify existing ones. If the expression exists, the new configuration
// replaces the old one. For more information, see Configuring Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DefineExpression for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * LimitExceeded
//   The request was rejected because a resource limit has already been met.
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DefineExpression(input *DefineExpressionInput) (*DefineExpressionOutput, error) {
	req, out := c.DefineExpressionRequest(input)
	err := req.Send()
	return out, err
}

const opDefineIndexField = "DefineIndexField"

// DefineIndexFieldRequest generates a "aws/request.Request" representing the
// client's request for the DefineIndexField operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DefineIndexField for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DefineIndexField method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DefineIndexFieldRequest method.
//    req, resp := client.DefineIndexFieldRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DefineIndexFieldRequest(input *DefineIndexFieldInput) (req *request.Request, output *DefineIndexFieldOutput) {
	op := &request.Operation{
		Name:       opDefineIndexField,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineIndexFieldInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DefineIndexFieldOutput{}
	req.Data = output
	return
}

// DefineIndexField API operation for Amazon CloudSearch.
//
// Configures an IndexField for the search domain. Used to create new fields
// and modify existing ones. You must specify the name of the domain you are
// configuring and an index field configuration. The index field configuration
// specifies a unique name, the index field type, and the options you want to
// configure for the field. The options you can specify depend on the IndexFieldType.
// If the field exists, the new configuration replaces the old one. For more
// information, see Configuring Index Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DefineIndexField for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * LimitExceeded
//   The request was rejected because a resource limit has already been met.
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DefineIndexField(input *DefineIndexFieldInput) (*DefineIndexFieldOutput, error) {
	req, out := c.DefineIndexFieldRequest(input)
	err := req.Send()
	return out, err
}

const opDefineSuggester = "DefineSuggester"

// DefineSuggesterRequest generates a "aws/request.Request" representing the
// client's request for the DefineSuggester operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DefineSuggester for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DefineSuggester method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DefineSuggesterRequest method.
//    req, resp := client.DefineSuggesterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DefineSuggesterRequest(input *DefineSuggesterInput) (req *request.Request, output *DefineSuggesterOutput) {
	op := &request.Operation{
		Name:       opDefineSuggester,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineSuggesterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DefineSuggesterOutput{}
	req.Data = output
	return
}

// DefineSuggester API operation for Amazon CloudSearch.
//
// Configures a suggester for a domain. A suggester enables you to display possible
// matches before users finish typing their queries. When you configure a suggester,
// you must specify the name of the text field you want to search for possible
// matches and a unique name for the suggester. For more information, see Getting
// Search Suggestions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DefineSuggester for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * LimitExceeded
//   The request was rejected because a resource limit has already been met.
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DefineSuggester(input *DefineSuggesterInput) (*DefineSuggesterOutput, error) {
	req, out := c.DefineSuggesterRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAnalysisScheme = "DeleteAnalysisScheme"

// DeleteAnalysisSchemeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnalysisScheme operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAnalysisScheme for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAnalysisScheme method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAnalysisSchemeRequest method.
//    req, resp := client.DeleteAnalysisSchemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DeleteAnalysisSchemeRequest(input *DeleteAnalysisSchemeInput) (req *request.Request, output *DeleteAnalysisSchemeOutput) {
	op := &request.Operation{
		Name:       opDeleteAnalysisScheme,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAnalysisSchemeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteAnalysisSchemeOutput{}
	req.Data = output
	return
}

// DeleteAnalysisScheme API operation for Amazon CloudSearch.
//
// Deletes an analysis scheme. For more information, see Configuring Analysis
// Schemes (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DeleteAnalysisScheme for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DeleteAnalysisScheme(input *DeleteAnalysisSchemeInput) (*DeleteAnalysisSchemeOutput, error) {
	req, out := c.DeleteAnalysisSchemeRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDomainRequest method.
//    req, resp := client.DeleteDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDomainOutput{}
	req.Data = output
	return
}

// DeleteDomain API operation for Amazon CloudSearch.
//
// Permanently deletes a search domain and all of its data. Once a domain has
// been deleted, it cannot be recovered. For more information, see Deleting
// a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
func (c *CloudSearch) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteExpression = "DeleteExpression"

// DeleteExpressionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExpression operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteExpression for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteExpression method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteExpressionRequest method.
//    req, resp := client.DeleteExpressionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DeleteExpressionRequest(input *DeleteExpressionInput) (req *request.Request, output *DeleteExpressionOutput) {
	op := &request.Operation{
		Name:       opDeleteExpression,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteExpressionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteExpressionOutput{}
	req.Data = output
	return
}

// DeleteExpression API operation for Amazon CloudSearch.
//
// Removes an Expression from the search domain. For more information, see Configuring
// Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DeleteExpression for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DeleteExpression(input *DeleteExpressionInput) (*DeleteExpressionOutput, error) {
	req, out := c.DeleteExpressionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIndexField = "DeleteIndexField"

// DeleteIndexFieldRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIndexField operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteIndexField for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteIndexField method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteIndexFieldRequest method.
//    req, resp := client.DeleteIndexFieldRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DeleteIndexFieldRequest(input *DeleteIndexFieldInput) (req *request.Request, output *DeleteIndexFieldOutput) {
	op := &request.Operation{
		Name:       opDeleteIndexField,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIndexFieldInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIndexFieldOutput{}
	req.Data = output
	return
}

// DeleteIndexField API operation for Amazon CloudSearch.
//
// Removes an IndexField from the search domain. For more information, see Configuring
// Index Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DeleteIndexField for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DeleteIndexField(input *DeleteIndexFieldInput) (*DeleteIndexFieldOutput, error) {
	req, out := c.DeleteIndexFieldRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSuggester = "DeleteSuggester"

// DeleteSuggesterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSuggester operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSuggester for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSuggester method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSuggesterRequest method.
//    req, resp := client.DeleteSuggesterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DeleteSuggesterRequest(input *DeleteSuggesterInput) (req *request.Request, output *DeleteSuggesterOutput) {
	op := &request.Operation{
		Name:       opDeleteSuggester,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSuggesterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSuggesterOutput{}
	req.Data = output
	return
}

// DeleteSuggester API operation for Amazon CloudSearch.
//
// Deletes a suggester. For more information, see Getting Search Suggestions
// (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DeleteSuggester for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DeleteSuggester(input *DeleteSuggesterInput) (*DeleteSuggesterOutput, error) {
	req, out := c.DeleteSuggesterRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAnalysisSchemes = "DescribeAnalysisSchemes"

// DescribeAnalysisSchemesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnalysisSchemes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAnalysisSchemes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAnalysisSchemes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAnalysisSchemesRequest method.
//    req, resp := client.DescribeAnalysisSchemesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DescribeAnalysisSchemesRequest(input *DescribeAnalysisSchemesInput) (req *request.Request, output *DescribeAnalysisSchemesOutput) {
	op := &request.Operation{
		Name:       opDescribeAnalysisSchemes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAnalysisSchemesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAnalysisSchemesOutput{}
	req.Data = output
	return
}

// DescribeAnalysisSchemes API operation for Amazon CloudSearch.
//
// Gets the analysis schemes configured for a domain. An analysis scheme defines
// language-specific text processing options for a text field. Can be limited
// to specific analysis schemes by name. By default, shows all analysis schemes
// and includes any pending changes to the configuration. Set the Deployed option
// to true to show the active configuration and exclude pending changes. For
// more information, see Configuring Analysis Schemes (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DescribeAnalysisSchemes for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DescribeAnalysisSchemes(input *DescribeAnalysisSchemesInput) (*DescribeAnalysisSchemesOutput, error) {
	req, out := c.DescribeAnalysisSchemesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAvailabilityOptions = "DescribeAvailabilityOptions"

// DescribeAvailabilityOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAvailabilityOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAvailabilityOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAvailabilityOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAvailabilityOptionsRequest method.
//    req, resp := client.DescribeAvailabilityOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DescribeAvailabilityOptionsRequest(input *DescribeAvailabilityOptionsInput) (req *request.Request, output *DescribeAvailabilityOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAvailabilityOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailabilityOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAvailabilityOptionsOutput{}
	req.Data = output
	return
}

// DescribeAvailabilityOptions API operation for Amazon CloudSearch.
//
// Gets the availability options configured for a domain. By default, shows
// the configuration with any pending changes. Set the Deployed option to true
// to show the active configuration and exclude pending changes. For more information,
// see Configuring Availability Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DescribeAvailabilityOptions for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * LimitExceeded
//   The request was rejected because a resource limit has already been met.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
//   * DisabledAction
//   The request was rejected because it attempted an operation which is not enabled.
//
func (c *CloudSearch) DescribeAvailabilityOptions(input *DescribeAvailabilityOptionsInput) (*DescribeAvailabilityOptionsOutput, error) {
	req, out := c.DescribeAvailabilityOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDomains = "DescribeDomains"

// DescribeDomainsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomains operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeDomains for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeDomains method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeDomainsRequest method.
//    req, resp := client.DescribeDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DescribeDomainsRequest(input *DescribeDomainsInput) (req *request.Request, output *DescribeDomainsOutput) {
	op := &request.Operation{
		Name:       opDescribeDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDomainsOutput{}
	req.Data = output
	return
}

// DescribeDomains API operation for Amazon CloudSearch.
//
// Gets information about the search domains owned by this account. Can be limited
// to specific domains. Shows all domains by default. To get the number of searchable
// documents in a domain, use the console or submit a matchall request to your
// domain's search endpoint: q=matchall&q.parser=structured&size=0.
// For more information, see Getting Information about a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DescribeDomains for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
func (c *CloudSearch) DescribeDomains(input *DescribeDomainsInput) (*DescribeDomainsOutput, error) {
	req, out := c.DescribeDomainsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeExpressions = "DescribeExpressions"

// DescribeExpressionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExpressions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeExpressions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeExpressions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeExpressionsRequest method.
//    req, resp := client.DescribeExpressionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DescribeExpressionsRequest(input *DescribeExpressionsInput) (req *request.Request, output *DescribeExpressionsOutput) {
	op := &request.Operation{
		Name:       opDescribeExpressions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExpressionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeExpressionsOutput{}
	req.Data = output
	return
}

// DescribeExpressions API operation for Amazon CloudSearch.
//
// Gets the expressions configured for the search domain. Can be limited to
// specific expressions by name. By default, shows all expressions and includes
// any pending changes to the configuration. Set the Deployed option to true
// to show the active configuration and exclude pending changes. For more information,
// see Configuring Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DescribeExpressions for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DescribeExpressions(input *DescribeExpressionsInput) (*DescribeExpressionsOutput, error) {
	req, out := c.DescribeExpressionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeIndexFields = "DescribeIndexFields"

// DescribeIndexFieldsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIndexFields operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeIndexFields for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeIndexFields method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeIndexFieldsRequest method.
//    req, resp := client.DescribeIndexFieldsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DescribeIndexFieldsRequest(input *DescribeIndexFieldsInput) (req *request.Request, output *DescribeIndexFieldsOutput) {
	op := &request.Operation{
		Name:       opDescribeIndexFields,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIndexFieldsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeIndexFieldsOutput{}
	req.Data = output
	return
}

// DescribeIndexFields API operation for Amazon CloudSearch.
//
// Gets information about the index fields configured for the search domain.
// Can be limited to specific fields by name. By default, shows all fields and
// includes any pending changes to the configuration. Set the Deployed option
// to true to show the active configuration and exclude pending changes. For
// more information, see Getting Domain Information (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DescribeIndexFields for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DescribeIndexFields(input *DescribeIndexFieldsInput) (*DescribeIndexFieldsOutput, error) {
	req, out := c.DescribeIndexFieldsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeScalingParameters = "DescribeScalingParameters"

// DescribeScalingParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingParameters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeScalingParameters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeScalingParameters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeScalingParametersRequest method.
//    req, resp := client.DescribeScalingParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DescribeScalingParametersRequest(input *DescribeScalingParametersInput) (req *request.Request, output *DescribeScalingParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalingParametersOutput{}
	req.Data = output
	return
}

// DescribeScalingParameters API operation for Amazon CloudSearch.
//
// Gets the scaling parameters configured for a domain. A domain's scaling parameters
// specify the desired search instance type and replication count. For more
// information, see Configuring Scaling Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DescribeScalingParameters for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DescribeScalingParameters(input *DescribeScalingParametersInput) (*DescribeScalingParametersOutput, error) {
	req, out := c.DescribeScalingParametersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeServiceAccessPolicies = "DescribeServiceAccessPolicies"

// DescribeServiceAccessPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServiceAccessPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeServiceAccessPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeServiceAccessPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeServiceAccessPoliciesRequest method.
//    req, resp := client.DescribeServiceAccessPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DescribeServiceAccessPoliciesRequest(input *DescribeServiceAccessPoliciesInput) (req *request.Request, output *DescribeServiceAccessPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeServiceAccessPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServiceAccessPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeServiceAccessPoliciesOutput{}
	req.Data = output
	return
}

// DescribeServiceAccessPolicies API operation for Amazon CloudSearch.
//
// Gets information about the access policies that control access to the domain's
// document and search endpoints. By default, shows the configuration with any
// pending changes. Set the Deployed option to true to show the active configuration
// and exclude pending changes. For more information, see Configuring Access
// for a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DescribeServiceAccessPolicies for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DescribeServiceAccessPolicies(input *DescribeServiceAccessPoliciesInput) (*DescribeServiceAccessPoliciesOutput, error) {
	req, out := c.DescribeServiceAccessPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSuggesters = "DescribeSuggesters"

// DescribeSuggestersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSuggesters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSuggesters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSuggesters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSuggestersRequest method.
//    req, resp := client.DescribeSuggestersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) DescribeSuggestersRequest(input *DescribeSuggestersInput) (req *request.Request, output *DescribeSuggestersOutput) {
	op := &request.Operation{
		Name:       opDescribeSuggesters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSuggestersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSuggestersOutput{}
	req.Data = output
	return
}

// DescribeSuggesters API operation for Amazon CloudSearch.
//
// Gets the suggesters configured for a domain. A suggester enables you to display
// possible matches before users finish typing their queries. Can be limited
// to specific suggesters by name. By default, shows all suggesters and includes
// any pending changes to the configuration. Set the Deployed option to true
// to show the active configuration and exclude pending changes. For more information,
// see Getting Search Suggestions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation DescribeSuggesters for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) DescribeSuggesters(input *DescribeSuggestersInput) (*DescribeSuggestersOutput, error) {
	req, out := c.DescribeSuggestersRequest(input)
	err := req.Send()
	return out, err
}

const opIndexDocuments = "IndexDocuments"

// IndexDocumentsRequest generates a "aws/request.Request" representing the
// client's request for the IndexDocuments operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See IndexDocuments for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the IndexDocuments method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the IndexDocumentsRequest method.
//    req, resp := client.IndexDocumentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) IndexDocumentsRequest(input *IndexDocumentsInput) (req *request.Request, output *IndexDocumentsOutput) {
	op := &request.Operation{
		Name:       opIndexDocuments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IndexDocumentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &IndexDocumentsOutput{}
	req.Data = output
	return
}

// IndexDocuments API operation for Amazon CloudSearch.
//
// Tells the search domain to start indexing its documents using the latest
// indexing options. This operation must be invoked to activate options whose
// OptionStatus is RequiresIndexDocuments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation IndexDocuments for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
func (c *CloudSearch) IndexDocuments(input *IndexDocumentsInput) (*IndexDocumentsOutput, error) {
	req, out := c.IndexDocumentsRequest(input)
	err := req.Send()
	return out, err
}

const opListDomainNames = "ListDomainNames"

// ListDomainNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainNames operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDomainNames for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDomainNames method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDomainNamesRequest method.
//    req, resp := client.ListDomainNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) ListDomainNamesRequest(input *ListDomainNamesInput) (req *request.Request, output *ListDomainNamesOutput) {
	op := &request.Operation{
		Name:       opListDomainNames,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDomainNamesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDomainNamesOutput{}
	req.Data = output
	return
}

// ListDomainNames API operation for Amazon CloudSearch.
//
// Lists all search domains owned by an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation ListDomainNames for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
func (c *CloudSearch) ListDomainNames(input *ListDomainNamesInput) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAvailabilityOptions = "UpdateAvailabilityOptions"

// UpdateAvailabilityOptionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAvailabilityOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateAvailabilityOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateAvailabilityOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateAvailabilityOptionsRequest method.
//    req, resp := client.UpdateAvailabilityOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) UpdateAvailabilityOptionsRequest(input *UpdateAvailabilityOptionsInput) (req *request.Request, output *UpdateAvailabilityOptionsOutput) {
	op := &request.Operation{
		Name:       opUpdateAvailabilityOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAvailabilityOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAvailabilityOptionsOutput{}
	req.Data = output
	return
}

// UpdateAvailabilityOptions API operation for Amazon CloudSearch.
//
// Configures the availability options for a domain. Enabling the Multi-AZ option
// expands an Amazon CloudSearch domain to an additional Availability Zone in
// the same Region to increase fault tolerance in the event of a service disruption.
// Changes to the Multi-AZ option can take about half an hour to become active.
// For more information, see Configuring Availability Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation UpdateAvailabilityOptions for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
//   * LimitExceeded
//   The request was rejected because a resource limit has already been met.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
//   * DisabledAction
//   The request was rejected because it attempted an operation which is not enabled.
//
func (c *CloudSearch) UpdateAvailabilityOptions(input *UpdateAvailabilityOptionsInput) (*UpdateAvailabilityOptionsOutput, error) {
	req, out := c.UpdateAvailabilityOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateScalingParameters = "UpdateScalingParameters"

// UpdateScalingParametersRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScalingParameters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateScalingParameters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateScalingParameters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateScalingParametersRequest method.
//    req, resp := client.UpdateScalingParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) UpdateScalingParametersRequest(input *UpdateScalingParametersInput) (req *request.Request, output *UpdateScalingParametersOutput) {
	op := &request.Operation{
		Name:       opUpdateScalingParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateScalingParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateScalingParametersOutput{}
	req.Data = output
	return
}

// UpdateScalingParameters API operation for Amazon CloudSearch.
//
// Configures scaling parameters for a domain. A domain's scaling parameters
// specify the desired search instance type and replication count. Amazon CloudSearch
// will still automatically scale your domain based on the volume of data and
// traffic, but not below the desired instance type and replication count. If
// the Multi-AZ option is enabled, these values control the resources used per
// Availability Zone. For more information, see Configuring Scaling Options
// (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html)
// in the Amazon CloudSearch Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation UpdateScalingParameters for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * LimitExceeded
//   The request was rejected because a resource limit has already been met.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
func (c *CloudSearch) UpdateScalingParameters(input *UpdateScalingParametersInput) (*UpdateScalingParametersOutput, error) {
	req, out := c.UpdateScalingParametersRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateServiceAccessPolicies = "UpdateServiceAccessPolicies"

// UpdateServiceAccessPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceAccessPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateServiceAccessPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateServiceAccessPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateServiceAccessPoliciesRequest method.
//    req, resp := client.UpdateServiceAccessPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudSearch) UpdateServiceAccessPoliciesRequest(input *UpdateServiceAccessPoliciesInput) (req *request.Request, output *UpdateServiceAccessPoliciesOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceAccessPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceAccessPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateServiceAccessPoliciesOutput{}
	req.Data = output
	return
}

// UpdateServiceAccessPolicies API operation for Amazon CloudSearch.
//
// Configures the access rules that control access to the domain's document
// and search endpoints. For more information, see  Configuring Access for an
// Amazon CloudSearch Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudSearch's
// API operation UpdateServiceAccessPolicies for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   An internal error occurred while processing the request. If this problem
//   persists, report an issue from the Service Health Dashboard (http://status.aws.amazon.com/).
//
//   * LimitExceeded
//   The request was rejected because a resource limit has already been met.
//
//   * ResourceNotFound
//   The request was rejected because it attempted to reference a resource that
//   does not exist.
//
//   * InvalidType
//   The request was rejected because it specified an invalid type definition.
//
func (c *CloudSearch) UpdateServiceAccessPolicies(input *UpdateServiceAccessPoliciesInput) (*UpdateServiceAccessPoliciesOutput, error) {
	req, out := c.UpdateServiceAccessPoliciesRequest(input)
	err := req.Send()
	return out, err
}

// The configured access rules for the domain's document and search endpoints,
// and the current status of those rules.
type AccessPoliciesStatus struct {
	_ struct{} `type:"structure"`

	// Access rules for a domain's document or search service endpoints. For more
	// information, see Configuring Access for a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html)
	// in the Amazon CloudSearch Developer Guide. The maximum size of a policy document
	// is 100 KB.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPoliciesStatus) GoString() string {
	return s.String()
}

// Synonyms, stopwords, and stemming options for an analysis scheme. Includes
// tokenization dictionary for Japanese.
type AnalysisOptions struct {
	_ struct{} `type:"structure"`

	// The level of algorithmic stemming to perform: none, minimal, light, or full.
	// The available levels vary depending on the language. For more information,
	// see Language Specific Text Processing Settings (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings)
	// in the Amazon CloudSearch Developer Guide
	AlgorithmicStemming *string `type:"string" enum:"AlgorithmicStemming"`

	// A JSON array that contains a collection of terms, tokens, readings and part
	// of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary
	// enables you to override the default tokenization for selected terms. This
	// is only valid for Japanese language fields.
	JapaneseTokenizationDictionary *string `type:"string"`

	// A JSON object that contains a collection of string:value pairs that each
	// map a term to its stem. For example, {"term1": "stem1", "term2": "stem2",
	// "term3": "stem3"}. The stemming dictionary is applied in addition to any
	// algorithmic stemming. This enables you to override the results of the algorithmic
	// stemming to correct specific cases of overstemming or understemming. The
	// maximum size of a stemming dictionary is 500 KB.
	StemmingDictionary *string `type:"string"`

	// A JSON array of terms to ignore during indexing and searching. For example,
	// ["a", "an", "the", "of"]. The stopwords dictionary must explicitly list each
	// word you want to ignore. Wildcards and regular expressions are not supported.
	Stopwords *string `type:"string"`

	// A JSON object that defines synonym groups and aliases. A synonym group is
	// an array of arrays, where each sub-array is a group of terms where each term
	// in the group is considered a synonym of every other term in the group. The
	// aliases value is an object that contains a collection of string:value pairs
	// where the string specifies a term and the array of values specifies each
	// of the aliases for that term. An alias is considered a synonym of the specified
	// term, but the term is not considered a synonym of the alias. For more information
	// about specifying synonyms, see Synonyms (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms)
	// in the Amazon CloudSearch Developer Guide.
	Synonyms *string `type:"string"`
}

// String returns the string representation
func (s AnalysisOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalysisOptions) GoString() string {
	return s.String()
}

// Configuration information for an analysis scheme. Each analysis scheme has
// a unique name and specifies the language of the text to be processed. The
// following options can be configured for an analysis scheme: Synonyms, Stopwords,
// StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
type AnalysisScheme struct {
	_ struct{} `type:"structure"`

	// Synonyms, stopwords, and stemming options for an analysis scheme. Includes
	// tokenization dictionary for Japanese.
	AnalysisOptions *AnalysisOptions `type:"structure"`

	// An IETF RFC 4646 (http://tools.ietf.org/html/rfc4646) language code or mul
	// for multiple languages.
	//
	// AnalysisSchemeLanguage is a required field
	AnalysisSchemeLanguage *string `type:"string" required:"true" enum:"AnalysisSchemeLanguage"`

	// Names must begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore).
	//
	// AnalysisSchemeName is a required field
	AnalysisSchemeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AnalysisScheme) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalysisScheme) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisScheme) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisScheme"}
	if s.AnalysisSchemeLanguage == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisSchemeLanguage"))
	}
	if s.AnalysisSchemeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisSchemeName"))
	}
	if s.AnalysisSchemeName != nil && len(*s.AnalysisSchemeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisSchemeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status and configuration of an AnalysisScheme.
type AnalysisSchemeStatus struct {
	_ struct{} `type:"structure"`

	// Configuration information for an analysis scheme. Each analysis scheme has
	// a unique name and specifies the language of the text to be processed. The
	// following options can be configured for an analysis scheme: Synonyms, Stopwords,
	// StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
	//
	// Options is a required field
	Options *AnalysisScheme `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalysisSchemeStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalysisSchemeStatus) GoString() string {
	return s.String()
}

// The status and configuration of the domain's availability options.
type AvailabilityOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The availability options configured for the domain.
	//
	// Options is a required field
	Options *bool `type:"boolean" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AvailabilityOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityOptionsStatus) GoString() string {
	return s.String()
}

// Container for the parameters to the BuildSuggester operation. Specifies the
// name of the domain you want to update.
type BuildSuggestersInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s BuildSuggestersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildSuggestersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuildSuggestersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BuildSuggestersInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a BuildSuggester request. Contains a list of the fields used
// for suggestions.
type BuildSuggestersOutput struct {
	_ struct{} `type:"structure"`

	// A list of field names.
	FieldNames []*string `type:"list"`
}

// String returns the string representation
func (s BuildSuggestersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildSuggestersOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the CreateDomain operation. Specifies a name
// for the new search domain.
type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// A name for the domain you are creating. Allowed characters are a-z (lower-case
	// letters), 0-9, and hyphen (-). Domain names must start with a letter or number
	// and be at least 3 and no more than 28 characters long.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a CreateDomainRequest. Contains the status of a newly created
// domain.
type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the search domain.
	DomainStatus *DomainStatus `type:"structure"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// Options for a field that contains an array of dates. Present if IndexFieldType
// specifies the field is of type date-array. All options are enabled by default.
type DateArrayOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s DateArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateArrayOptions) GoString() string {
	return s.String()
}

// Options for a date field. Dates and times are specified in UTC (Coordinated
// Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z. Present
// if IndexFieldType specifies the field is of type date. All options are enabled
// by default.
type DateOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DateOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Container for the parameters to the DefineAnalysisScheme operation. Specifies
// the name of the domain you want to update and the analysis scheme configuration.
type DefineAnalysisSchemeInput struct {
	_ struct{} `type:"structure"`

	// Configuration information for an analysis scheme. Each analysis scheme has
	// a unique name and specifies the language of the text to be processed. The
	// following options can be configured for an analysis scheme: Synonyms, Stopwords,
	// StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
	//
	// AnalysisScheme is a required field
	AnalysisScheme *AnalysisScheme `type:"structure" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DefineAnalysisSchemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineAnalysisSchemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefineAnalysisSchemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefineAnalysisSchemeInput"}
	if s.AnalysisScheme == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisScheme"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.AnalysisScheme != nil {
		if err := s.AnalysisScheme.Validate(); err != nil {
			invalidParams.AddNested("AnalysisScheme", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DefineAnalysisScheme request. Contains the status of the
// newly-configured analysis scheme.
type DefineAnalysisSchemeOutput struct {
	_ struct{} `type:"structure"`

	// The status and configuration of an AnalysisScheme.
	//
	// AnalysisScheme is a required field
	AnalysisScheme *AnalysisSchemeStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineAnalysisSchemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineAnalysisSchemeOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DefineExpression operation. Specifies
// the name of the domain you want to update and the expression you want to
// configure.
type DefineExpressionInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// A named expression that can be evaluated at search time. Can be used to sort
	// the search results, define other expressions, or return computed information
	// in the search results.
	//
	// Expression is a required field
	Expression *Expression `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineExpressionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineExpressionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefineExpressionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefineExpressionInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil {
		if err := s.Expression.Validate(); err != nil {
			invalidParams.AddNested("Expression", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DefineExpression request. Contains the status of the newly-configured
// expression.
type DefineExpressionOutput struct {
	_ struct{} `type:"structure"`

	// The value of an Expression and its current status.
	//
	// Expression is a required field
	Expression *ExpressionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineExpressionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineExpressionOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DefineIndexField operation. Specifies
// the name of the domain you want to update and the index field configuration.
type DefineIndexFieldInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The index field and field options you want to configure.
	//
	// IndexField is a required field
	IndexField *IndexField `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineIndexFieldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineIndexFieldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefineIndexFieldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefineIndexFieldInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.IndexField == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexField"))
	}
	if s.IndexField != nil {
		if err := s.IndexField.Validate(); err != nil {
			invalidParams.AddNested("IndexField", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DefineIndexField request. Contains the status of the newly-configured
// index field.
type DefineIndexFieldOutput struct {
	_ struct{} `type:"structure"`

	// The value of an IndexField and its current status.
	//
	// IndexField is a required field
	IndexField *IndexFieldStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineIndexFieldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineIndexFieldOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DefineSuggester operation. Specifies
// the name of the domain you want to update and the suggester configuration.
type DefineSuggesterInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Configuration information for a search suggester. Each suggester has a unique
	// name and specifies the text field you want to use for suggestions. The following
	// options can be configured for a suggester: FuzzyMatching, SortExpression.
	//
	// Suggester is a required field
	Suggester *Suggester `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineSuggesterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineSuggesterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefineSuggesterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefineSuggesterInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.Suggester == nil {
		invalidParams.Add(request.NewErrParamRequired("Suggester"))
	}
	if s.Suggester != nil {
		if err := s.Suggester.Validate(); err != nil {
			invalidParams.AddNested("Suggester", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DefineSuggester request. Contains the status of the newly-configured
// suggester.
type DefineSuggesterOutput struct {
	_ struct{} `type:"structure"`

	// The value of a Suggester and its current status.
	//
	// Suggester is a required field
	Suggester *SuggesterStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineSuggesterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineSuggesterOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteAnalysisScheme operation. Specifies
// the name of the domain you want to update and the analysis scheme you want
// to delete.
type DeleteAnalysisSchemeInput struct {
	_ struct{} `type:"structure"`

	// The name of the analysis scheme you want to delete.
	//
	// AnalysisSchemeName is a required field
	AnalysisSchemeName *string `min:"1" type:"string" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAnalysisSchemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnalysisSchemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnalysisSchemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnalysisSchemeInput"}
	if s.AnalysisSchemeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisSchemeName"))
	}
	if s.AnalysisSchemeName != nil && len(*s.AnalysisSchemeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisSchemeName", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteAnalysisScheme request. Contains the status of the
// deleted analysis scheme.
type DeleteAnalysisSchemeOutput struct {
	_ struct{} `type:"structure"`

	// The status of the analysis scheme being deleted.
	//
	// AnalysisScheme is a required field
	AnalysisScheme *AnalysisSchemeStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAnalysisSchemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnalysisSchemeOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteDomain operation. Specifies the
// name of the domain you want to delete.
type DeleteDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain you want to permanently delete.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteDomain request. Contains the status of a newly deleted
// domain, or no status if the domain has already been completely deleted.
type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the search domain.
	DomainStatus *DomainStatus `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteExpression operation. Specifies
// the name of the domain you want to update and the name of the expression
// you want to delete.
type DeleteExpressionInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The name of the Expression to delete.
	//
	// ExpressionName is a required field
	ExpressionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteExpressionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteExpressionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExpressionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExpressionInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.ExpressionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpressionName"))
	}
	if s.ExpressionName != nil && len(*s.ExpressionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpressionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteExpression request. Specifies the expression being
// deleted.
type DeleteExpressionOutput struct {
	_ struct{} `type:"structure"`

	// The status of the expression being deleted.
	//
	// Expression is a required field
	Expression *ExpressionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteExpressionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteExpressionOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteIndexField operation. Specifies
// the name of the domain you want to update and the name of the index field
// you want to delete.
type DeleteIndexFieldInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The name of the index field your want to remove from the domain's indexing
	// options.
	//
	// IndexFieldName is a required field
	IndexFieldName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIndexFieldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIndexFieldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIndexFieldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIndexFieldInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.IndexFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexFieldName"))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteIndexField request.
type DeleteIndexFieldOutput struct {
	_ struct{} `type:"structure"`

	// The status of the index field being deleted.
	//
	// IndexField is a required field
	IndexField *IndexFieldStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteIndexFieldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIndexFieldOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteSuggester operation. Specifies
// the name of the domain you want to update and name of the suggester you want
// to delete.
type DeleteSuggesterInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Specifies the name of the suggester you want to delete.
	//
	// SuggesterName is a required field
	SuggesterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSuggesterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSuggesterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSuggesterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSuggesterInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.SuggesterName == nil {
		invalidParams.Add(request.NewErrParamRequired("SuggesterName"))
	}
	if s.SuggesterName != nil && len(*s.SuggesterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SuggesterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteSuggester request. Contains the status of the deleted
// suggester.
type DeleteSuggesterOutput struct {
	_ struct{} `type:"structure"`

	// The status of the suggester being deleted.
	//
	// Suggester is a required field
	Suggester *SuggesterStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSuggesterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSuggesterOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeAnalysisSchemes operation. Specifies
// the name of the domain you want to describe. To limit the response to particular
// analysis schemes, specify the names of the analysis schemes you want to describe.
// To show the active configuration and exclude any pending changes, set the
// Deployed option to true.
type DescribeAnalysisSchemesInput struct {
	_ struct{} `type:"structure"`

	// The analysis schemes you want to describe.
	AnalysisSchemeNames []*string `type:"list"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAnalysisSchemesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAnalysisSchemesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnalysisSchemesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAnalysisSchemesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeAnalysisSchemes request. Contains the analysis schemes
// configured for the domain specified in the request.
type DescribeAnalysisSchemesOutput struct {
	_ struct{} `type:"structure"`

	// The analysis scheme descriptions.
	//
	// AnalysisSchemes is a required field
	AnalysisSchemes []*AnalysisSchemeStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeAnalysisSchemesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAnalysisSchemesOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeAvailabilityOptions operation.
// Specifies the name of the domain you want to describe. To show the active
// configuration and exclude any pending changes, set the Deployed option to
// true.
type DescribeAvailabilityOptionsInput struct {
	_ struct{} `type:"structure"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAvailabilityOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAvailabilityOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAvailabilityOptionsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeAvailabilityOptions request. Indicates whether or
// not the Multi-AZ option is enabled for the domain specified in the request.
type DescribeAvailabilityOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The availability options configured for the domain. Indicates whether Multi-AZ
	// is enabled for the domain.
	AvailabilityOptions *AvailabilityOptionsStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeAvailabilityOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityOptionsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeDomains operation. By default
// shows the status of all domains. To restrict the response to particular domains,
// specify the names of the domains you want to describe.
type DescribeDomainsInput struct {
	_ struct{} `type:"structure"`

	// The names of the domains you want to include in the response.
	DomainNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainsInput) GoString() string {
	return s.String()
}

// The result of a DescribeDomains request. Contains the status of the domains
// specified in the request or all domains owned by the account.
type DescribeDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the status of each requested domain.
	//
	// DomainStatusList is a required field
	DomainStatusList []*DomainStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeDomains operation. Specifies
// the name of the domain you want to describe. To restrict the response to
// particular expressions, specify the names of the expressions you want to
// describe. To show the active configuration and exclude any pending changes,
// set the Deployed option to true.
type DescribeExpressionsInput struct {
	_ struct{} `type:"structure"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Limits the DescribeExpressions response to the specified expressions. If
	// not specified, all expressions are shown.
	ExpressionNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeExpressionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExpressionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExpressionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExpressionsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeExpressions request. Contains the expressions configured
// for the domain specified in the request.
type DescribeExpressionsOutput struct {
	_ struct{} `type:"structure"`

	// The expressions configured for the domain.
	//
	// Expressions is a required field
	Expressions []*ExpressionStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeExpressionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExpressionsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeIndexFields operation. Specifies
// the name of the domain you want to describe. To restrict the response to
// particular index fields, specify the names of the index fields you want to
// describe. To show the active configuration and exclude any pending changes,
// set the Deployed option to true.
type DescribeIndexFieldsInput struct {
	_ struct{} `type:"structure"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// A list of the index fields you want to describe. If not specified, information
	// is returned for all configured index fields.
	FieldNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeIndexFieldsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIndexFieldsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIndexFieldsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIndexFieldsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeIndexFields request. Contains the index fields configured
// for the domain specified in the request.
type DescribeIndexFieldsOutput struct {
	_ struct{} `type:"structure"`

	// The index fields configured for the domain.
	//
	// IndexFields is a required field
	IndexFields []*IndexFieldStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeIndexFieldsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIndexFieldsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeScalingParameters operation.
// Specifies the name of the domain you want to describe.
type DescribeScalingParametersInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeScalingParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingParametersInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeScalingParameters request. Contains the scaling parameters
// configured for the domain specified in the request.
type DescribeScalingParametersOutput struct {
	_ struct{} `type:"structure"`

	// The status and configuration of a search domain's scaling parameters.
	//
	// ScalingParameters is a required field
	ScalingParameters *ScalingParametersStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeScalingParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingParametersOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeServiceAccessPolicies operation.
// Specifies the name of the domain you want to describe. To show the active
// configuration and exclude any pending changes, set the Deployed option to
// true.
type DescribeServiceAccessPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeServiceAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceAccessPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeServiceAccessPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeServiceAccessPoliciesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeServiceAccessPolicies request.
type DescribeServiceAccessPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The access rules configured for the domain specified in the request.
	//
	// AccessPolicies is a required field
	AccessPolicies *AccessPoliciesStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeServiceAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceAccessPoliciesOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeSuggester operation. Specifies
// the name of the domain you want to describe. To restrict the response to
// particular suggesters, specify the names of the suggesters you want to describe.
// To show the active configuration and exclude any pending changes, set the
// Deployed option to true.
type DescribeSuggestersInput struct {
	_ struct{} `type:"structure"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The suggesters you want to describe.
	SuggesterNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeSuggestersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSuggestersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSuggestersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSuggestersInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeSuggesters request.
type DescribeSuggestersOutput struct {
	_ struct{} `type:"structure"`

	// The suggesters configured for the domain specified in the request.
	//
	// Suggesters is a required field
	Suggesters []*SuggesterStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeSuggestersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSuggestersOutput) GoString() string {
	return s.String()
}

// Options for a search suggester.
type DocumentSuggesterOptions struct {
	_ struct{} `type:"structure"`

	// The level of fuzziness allowed when suggesting matches for a string: none,
	// low, or high. With none, the specified string is treated as an exact prefix.
	// With low, suggestions must differ from the specified string by no more than
	// one character. With high, suggestions can differ by up to two characters.
	// The default is none.
	FuzzyMatching *string `type:"string" enum:"SuggesterFuzzyMatching"`

	// An expression that computes a score for each suggestion to control how they
	// are sorted. The scores are rounded to the nearest integer, with a floor of
	// 0 and a ceiling of 2^31-1. A document's relevance score is not computed for
	// suggestions, so sort expressions cannot reference the _score value. To sort
	// suggestions using a numeric field or existing expression, simply specify
	// the name of the field or expression. If no expression is configured for the
	// suggester, the suggestions are sorted with the closest matches listed first.
	SortExpression *string `type:"string"`

	// The name of the index field you want to use for suggestions.
	//
	// SourceField is a required field
	SourceField *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DocumentSuggesterOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentSuggesterOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentSuggesterOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentSuggesterOptions"}
	if s.SourceField == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceField"))
	}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The current status of the search domain.
type DomainStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the search domain. See Identifiers for
	// IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
	// in Using AWS Identity and Access Management for more information.
	ARN *string `type:"string"`

	// True if the search domain is created. It can take several minutes to initialize
	// a domain when CreateDomain is called. Newly created search domains are returned
	// from DescribeDomains with a false value for Created until domain creation
	// is complete.
	Created *bool `type:"boolean"`

	// True if the search domain has been deleted. The system must clean up resources
	// dedicated to the search domain when DeleteDomain is called. Newly deleted
	// search domains are returned from DescribeDomains with a true value for IsDeleted
	// for several minutes until resource cleanup is complete.
	Deleted *bool `type:"boolean"`

	// The service endpoint for updating documents in a search domain.
	DocService *ServiceEndpoint `type:"structure"`

	// An internally generated unique identifier for a domain.
	//
	// DomainId is a required field
	DomainId *string `min:"1" type:"string" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	Limits *Limits `type:"structure"`

	// True if processing is being done to activate the current domain configuration.
	Processing *bool `type:"boolean"`

	// True if IndexDocuments needs to be called to activate the current domain
	// configuration.
	//
	// RequiresIndexDocuments is a required field
	RequiresIndexDocuments *bool `type:"boolean" required:"true"`

	// The number of search instances that are available to process search requests.
	SearchInstanceCount *int64 `min:"1" type:"integer"`

	// The instance type that is being used to process search requests.
	SearchInstanceType *string `type:"string"`

	// The number of partitions across which the search index is spread.
	SearchPartitionCount *int64 `min:"1" type:"integer"`

	// The service endpoint for requesting search results from a search domain.
	SearchService *ServiceEndpoint `type:"structure"`
}

// String returns the string representation
func (s DomainStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainStatus) GoString() string {
	return s.String()
}

// Options for a field that contains an array of double-precision 64-bit floating
// point values. Present if IndexFieldType specifies the field is of type double-array.
// All options are enabled by default.
type DoubleArrayOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *float64 `type:"double"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s DoubleArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DoubleArrayOptions) GoString() string {
	return s.String()
}

// Options for a double-precision 64-bit floating point field. Present if IndexFieldType
// specifies the field is of type double. All options are enabled by default.
type DoubleOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	// This can be important if you are using the field in an expression and that
	// field is not present in every document.
	DefaultValue *float64 `type:"double"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// The name of the source field to map to the field.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DoubleOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DoubleOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DoubleOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DoubleOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A named expression that can be evaluated at search time. Can be used to sort
// the search results, define other expressions, or return computed information
// in the search results.
type Expression struct {
	_ struct{} `type:"structure"`

	// Names must begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore).
	//
	// ExpressionName is a required field
	ExpressionName *string `min:"1" type:"string" required:"true"`

	// The expression to evaluate for sorting while processing a search request.
	// The Expression syntax is based on JavaScript expressions. For more information,
	// see Configuring Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html)
	// in the Amazon CloudSearch Developer Guide.
	//
	// ExpressionValue is a required field
	ExpressionValue *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Expression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Expression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Expression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Expression"}
	if s.ExpressionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpressionName"))
	}
	if s.ExpressionName != nil && len(*s.ExpressionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpressionName", 1))
	}
	if s.ExpressionValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpressionValue"))
	}
	if s.ExpressionValue != nil && len(*s.ExpressionValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpressionValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The value of an Expression and its current status.
type ExpressionStatus struct {
	_ struct{} `type:"structure"`

	// The expression that is evaluated for sorting while processing a search request.
	//
	// Options is a required field
	Options *Expression `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ExpressionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpressionStatus) GoString() string {
	return s.String()
}

// Container for the parameters to the IndexDocuments operation. Specifies the
// name of the domain you want to re-index.
type IndexDocumentsInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s IndexDocumentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexDocumentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexDocumentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IndexDocumentsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of an IndexDocuments request. Contains the status of the indexing
// operation, including the fields being indexed.
type IndexDocumentsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the fields that are currently being indexed.
	FieldNames []*string `type:"list"`
}

// String returns the string representation
func (s IndexDocumentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexDocumentsOutput) GoString() string {
	return s.String()
}

// Configuration information for a field in the index, including its name, type,
// and options. The supported options depend on the IndexFieldType.
type IndexField struct {
	_ struct{} `type:"structure"`

	// Options for a field that contains an array of dates. Present if IndexFieldType
	// specifies the field is of type date-array. All options are enabled by default.
	DateArrayOptions *DateArrayOptions `type:"structure"`

	// Options for a date field. Dates and times are specified in UTC (Coordinated
	// Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z. Present
	// if IndexFieldType specifies the field is of type date. All options are enabled
	// by default.
	DateOptions *DateOptions `type:"structure"`

	// Options for a field that contains an array of double-precision 64-bit floating
	// point values. Present if IndexFieldType specifies the field is of type double-array.
	// All options are enabled by default.
	DoubleArrayOptions *DoubleArrayOptions `type:"structure"`

	// Options for a double-precision 64-bit floating point field. Present if IndexFieldType
	// specifies the field is of type double. All options are enabled by default.
	DoubleOptions *DoubleOptions `type:"structure"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	//
	// IndexFieldName is a required field
	IndexFieldName *string `min:"1" type:"string" required:"true"`

	// The type of field. The valid options for a field depend on the field type.
	// For more information about the supported field types, see Configuring Index
	// Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html)
	// in the Amazon CloudSearch Developer Guide.
	//
	// IndexFieldType is a required field
	IndexFieldType *string `type:"string" required:"true" enum:"IndexFieldType"`

	// Options for a field that contains an array of 64-bit signed integers. Present
	// if IndexFieldType specifies the field is of type int-array. All options are
	// enabled by default.
	IntArrayOptions *IntArrayOptions `type:"structure"`

	// Options for a 64-bit signed integer field. Present if IndexFieldType specifies
	// the field is of type int. All options are enabled by default.
	IntOptions *IntOptions `type:"structure"`

	// Options for a latlon field. A latlon field contains a location stored as
	// a latitude and longitude value pair. Present if IndexFieldType specifies
	// the field is of type latlon. All options are enabled by default.
	LatLonOptions *LatLonOptions `type:"structure"`

	// Options for a field that contains an array of literal strings. Present if
	// IndexFieldType specifies the field is of type literal-array. All options
	// are enabled by default.
	LiteralArrayOptions *LiteralArrayOptions `type:"structure"`

	// Options for literal field. Present if IndexFieldType specifies the field
	// is of type literal. All options are enabled by default.
	LiteralOptions *LiteralOptions `type:"structure"`

	// Options for a field that contains an array of text strings. Present if IndexFieldType
	// specifies the field is of type text-array. A text-array field is always searchable.
	// All options are enabled by default.
	TextArrayOptions *TextArrayOptions `type:"structure"`

	// Options for text field. Present if IndexFieldType specifies the field is
	// of type text. A text field is always searchable. All options are enabled
	// by default.
	TextOptions *TextOptions `type:"structure"`
}

// String returns the string representation
func (s IndexField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IndexField"}
	if s.IndexFieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexFieldName"))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexFieldName", 1))
	}
	if s.IndexFieldType == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexFieldType"))
	}
	if s.DateOptions != nil {
		if err := s.DateOptions.Validate(); err != nil {
			invalidParams.AddNested("DateOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.DoubleOptions != nil {
		if err := s.DoubleOptions.Validate(); err != nil {
			invalidParams.AddNested("DoubleOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.IntOptions != nil {
		if err := s.IntOptions.Validate(); err != nil {
			invalidParams.AddNested("IntOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.LatLonOptions != nil {
		if err := s.LatLonOptions.Validate(); err != nil {
			invalidParams.AddNested("LatLonOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.LiteralOptions != nil {
		if err := s.LiteralOptions.Validate(); err != nil {
			invalidParams.AddNested("LiteralOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.TextOptions != nil {
		if err := s.TextOptions.Validate(); err != nil {
			invalidParams.AddNested("TextOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The value of an IndexField and its current status.
type IndexFieldStatus struct {
	_ struct{} `type:"structure"`

	// Configuration information for a field in the index, including its name, type,
	// and options. The supported options depend on the IndexFieldType.
	//
	// Options is a required field
	Options *IndexField `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s IndexFieldStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexFieldStatus) GoString() string {
	return s.String()
}

// Options for a field that contains an array of 64-bit signed integers. Present
// if IndexFieldType specifies the field is of type int-array. All options are
// enabled by default.
type IntArrayOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *int64 `type:"long"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s IntArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntArrayOptions) GoString() string {
	return s.String()
}

// Options for a 64-bit signed integer field. Present if IndexFieldType specifies
// the field is of type int. All options are enabled by default.
type IntOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	// This can be important if you are using the field in an expression and that
	// field is not present in every document.
	DefaultValue *int64 `type:"long"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// The name of the source field to map to the field.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IntOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Options for a latlon field. A latlon field contains a location stored as
// a latitude and longitude value pair. Present if IndexFieldType specifies
// the field is of type latlon. All options are enabled by default.
type LatLonOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LatLonOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LatLonOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LatLonOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LatLonOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type Limits struct {
	_ struct{} `type:"structure"`

	// MaximumPartitionCount is a required field
	MaximumPartitionCount *int64 `min:"1" type:"integer" required:"true"`

	// MaximumReplicationCount is a required field
	MaximumReplicationCount *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s Limits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Limits) GoString() string {
	return s.String()
}

type ListDomainNamesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesInput) GoString() string {
	return s.String()
}

// The result of a ListDomainNames request. Contains a list of the domains owned
// by an account.
type ListDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// The names of the search domains owned by an account.
	DomainNames map[string]*string `type:"map"`
}

// String returns the string representation
func (s ListDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesOutput) GoString() string {
	return s.String()
}

// Options for a field that contains an array of literal strings. Present if
// IndexFieldType specifies the field is of type literal-array. All options
// are enabled by default.
type LiteralArrayOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s LiteralArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LiteralArrayOptions) GoString() string {
	return s.String()
}

// Options for literal field. Present if IndexFieldType specifies the field
// is of type literal. All options are enabled by default.
type LiteralOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LiteralOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LiteralOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LiteralOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LiteralOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status of domain configuration option.
type OptionStatus struct {
	_ struct{} `type:"structure"`

	// A timestamp for when this option was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Indicates that the option will be deleted once processing is complete.
	PendingDeletion *bool `type:"boolean"`

	// The state of processing a change to an option. Possible values:
	//
	//    * RequiresIndexDocuments: the option's latest value will not be deployed
	//    until IndexDocuments has been called and indexing is complete.
	//    * Processing: the option's latest value is in the process of being activated.
	//
	//    * Active: the option's latest value is completely deployed.
	//    * FailedToValidate: the option value is not compatible with the domain's
	//    data and cannot be used to index the data. You must either modify the
	//    option value or update or remove the incompatible documents.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"OptionState"`

	// A timestamp for when this option was last updated.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A unique integer that indicates when this option was last updated.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionStatus) GoString() string {
	return s.String()
}

// The desired instance type and desired number of replicas of each index partition.
type ScalingParameters struct {
	_ struct{} `type:"structure"`

	// The instance type that you want to preconfigure for your domain. For example,
	// search.m1.small.
	DesiredInstanceType *string `type:"string" enum:"PartitionInstanceType"`

	// The number of partitions you want to preconfigure for your domain. Only valid
	// when you select m2.2xlarge as the desired instance type.
	DesiredPartitionCount *int64 `type:"integer"`

	// The number of replicas you want to preconfigure for each index partition.
	DesiredReplicationCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ScalingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingParameters) GoString() string {
	return s.String()
}

// The status and configuration of a search domain's scaling parameters.
type ScalingParametersStatus struct {
	_ struct{} `type:"structure"`

	// The desired instance type and desired number of replicas of each index partition.
	//
	// Options is a required field
	Options *ScalingParameters `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ScalingParametersStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingParametersStatus) GoString() string {
	return s.String()
}

// The endpoint to which service requests can be submitted.
type ServiceEndpoint struct {
	_ struct{} `type:"structure"`

	// The endpoint to which service requests can be submitted. For example, search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com
	// or doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com.
	Endpoint *string `type:"string"`
}

// String returns the string representation
func (s ServiceEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceEndpoint) GoString() string {
	return s.String()
}

// Configuration information for a search suggester. Each suggester has a unique
// name and specifies the text field you want to use for suggestions. The following
// options can be configured for a suggester: FuzzyMatching, SortExpression.
type Suggester struct {
	_ struct{} `type:"structure"`

	// Options for a search suggester.
	//
	// DocumentSuggesterOptions is a required field
	DocumentSuggesterOptions *DocumentSuggesterOptions `type:"structure" required:"true"`

	// Names must begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore).
	//
	// SuggesterName is a required field
	SuggesterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Suggester) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Suggester) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Suggester) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Suggester"}
	if s.DocumentSuggesterOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentSuggesterOptions"))
	}
	if s.SuggesterName == nil {
		invalidParams.Add(request.NewErrParamRequired("SuggesterName"))
	}
	if s.SuggesterName != nil && len(*s.SuggesterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SuggesterName", 1))
	}
	if s.DocumentSuggesterOptions != nil {
		if err := s.DocumentSuggesterOptions.Validate(); err != nil {
			invalidParams.AddNested("DocumentSuggesterOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The value of a Suggester and its current status.
type SuggesterStatus struct {
	_ struct{} `type:"structure"`

	// Configuration information for a search suggester. Each suggester has a unique
	// name and specifies the text field you want to use for suggestions. The following
	// options can be configured for a suggester: FuzzyMatching, SortExpression.
	//
	// Options is a required field
	Options *Suggester `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s SuggesterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuggesterStatus) GoString() string {
	return s.String()
}

// Options for a field that contains an array of text strings. Present if IndexFieldType
// specifies the field is of type text-array. A text-array field is always searchable.
// All options are enabled by default.
type TextArrayOptions struct {
	_ struct{} `type:"structure"`

	// The name of an analysis scheme for a text-array field.
	AnalysisScheme *string `type:"string"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether highlights can be returned for the field.
	HighlightEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s TextArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextArrayOptions) GoString() string {
	return s.String()
}

// Options for text field. Present if IndexFieldType specifies the field is
// of type text. A text field is always searchable. All options are enabled
// by default.
type TextOptions struct {
	_ struct{} `type:"structure"`

	// The name of an analysis scheme for a text field.
	AnalysisScheme *string `type:"string"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether highlights can be returned for the field.
	HighlightEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TextOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Container for the parameters to the UpdateAvailabilityOptions operation.
// Specifies the name of the domain you want to update and the Multi-AZ availability
// option.
type UpdateAvailabilityOptionsInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// You expand an existing search domain to a second Availability Zone by setting
	// the Multi-AZ option to true. Similarly, you can turn off the Multi-AZ option
	// to downgrade the domain to a single Availability Zone by setting the Multi-AZ
	// option to false.
	//
	// MultiAZ is a required field
	MultiAZ *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s UpdateAvailabilityOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAvailabilityOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAvailabilityOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAvailabilityOptionsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.MultiAZ == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiAZ"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a UpdateAvailabilityOptions request. Contains the status of
// the domain's availability options.
type UpdateAvailabilityOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The newly-configured availability options. Indicates whether Multi-AZ is
	// enabled for the domain.
	AvailabilityOptions *AvailabilityOptionsStatus `type:"structure"`
}

// String returns the string representation
func (s UpdateAvailabilityOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAvailabilityOptionsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the UpdateScalingParameters operation. Specifies
// the name of the domain you want to update and the scaling parameters you
// want to configure.
type UpdateScalingParametersInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The desired instance type and desired number of replicas of each index partition.
	//
	// ScalingParameters is a required field
	ScalingParameters *ScalingParameters `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateScalingParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateScalingParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScalingParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateScalingParametersInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.ScalingParameters == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingParameters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a UpdateScalingParameters request. Contains the status of the
// newly-configured scaling parameters.
type UpdateScalingParametersOutput struct {
	_ struct{} `type:"structure"`

	// The status and configuration of a search domain's scaling parameters.
	//
	// ScalingParameters is a required field
	ScalingParameters *ScalingParametersStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateScalingParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateScalingParametersOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the UpdateServiceAccessPolicies operation.
// Specifies the name of the domain you want to update and the access rules
// you want to configure.
type UpdateServiceAccessPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The access rules you want to configure. These rules replace any existing
	// rules.
	//
	// AccessPolicies is a required field
	AccessPolicies *string `type:"string" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServiceAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceAccessPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceAccessPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceAccessPoliciesInput"}
	if s.AccessPolicies == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicies"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of an UpdateServiceAccessPolicies request. Contains the new access
// policies.
type UpdateServiceAccessPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The access rules configured for the domain.
	//
	// AccessPolicies is a required field
	AccessPolicies *AccessPoliciesStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateServiceAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceAccessPoliciesOutput) GoString() string {
	return s.String()
}

const (
	// AlgorithmicStemmingNone is a AlgorithmicStemming enum value
	AlgorithmicStemmingNone = "none"

	// AlgorithmicStemmingMinimal is a AlgorithmicStemming enum value
	AlgorithmicStemmingMinimal = "minimal"

	// AlgorithmicStemmingLight is a AlgorithmicStemming enum value
	AlgorithmicStemmingLight = "light"

	// AlgorithmicStemmingFull is a AlgorithmicStemming enum value
	AlgorithmicStemmingFull = "full"
)

// An IETF RFC 4646 (http://tools.ietf.org/html/rfc4646) language code or mul
// for multiple languages.
const (
	// AnalysisSchemeLanguageAr is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageAr = "ar"

	// AnalysisSchemeLanguageBg is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageBg = "bg"

	// AnalysisSchemeLanguageCa is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageCa = "ca"

	// AnalysisSchemeLanguageCs is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageCs = "cs"

	// AnalysisSchemeLanguageDa is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageDa = "da"

	// AnalysisSchemeLanguageDe is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageDe = "de"

	// AnalysisSchemeLanguageEl is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageEl = "el"

	// AnalysisSchemeLanguageEn is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageEn = "en"

	// AnalysisSchemeLanguageEs is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageEs = "es"

	// AnalysisSchemeLanguageEu is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageEu = "eu"

	// AnalysisSchemeLanguageFa is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageFa = "fa"

	// AnalysisSchemeLanguageFi is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageFi = "fi"

	// AnalysisSchemeLanguageFr is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageFr = "fr"

	// AnalysisSchemeLanguageGa is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageGa = "ga"

	// AnalysisSchemeLanguageGl is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageGl = "gl"

	// AnalysisSchemeLanguageHe is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageHe = "he"

	// AnalysisSchemeLanguageHi is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageHi = "hi"

	// AnalysisSchemeLanguageHu is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageHu = "hu"

	// AnalysisSchemeLanguageHy is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageHy = "hy"

	// AnalysisSchemeLanguageId is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageId = "id"

	// AnalysisSchemeLanguageIt is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageIt = "it"

	// AnalysisSchemeLanguageJa is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageJa = "ja"

	// AnalysisSchemeLanguageKo is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageKo = "ko"

	// AnalysisSchemeLanguageLv is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageLv = "lv"

	// AnalysisSchemeLanguageMul is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageMul = "mul"

	// AnalysisSchemeLanguageNl is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageNl = "nl"

	// AnalysisSchemeLanguageNo is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageNo = "no"

	// AnalysisSchemeLanguagePt is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguagePt = "pt"

	// AnalysisSchemeLanguageRo is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageRo = "ro"

	// AnalysisSchemeLanguageRu is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageRu = "ru"

	// AnalysisSchemeLanguageSv is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageSv = "sv"

	// AnalysisSchemeLanguageTh is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageTh = "th"

	// AnalysisSchemeLanguageTr is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageTr = "tr"

	// AnalysisSchemeLanguageZhHans is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageZhHans = "zh-Hans"

	// AnalysisSchemeLanguageZhHant is a AnalysisSchemeLanguage enum value
	AnalysisSchemeLanguageZhHant = "zh-Hant"
)

// The type of field. The valid options for a field depend on the field type.
// For more information about the supported field types, see Configuring Index
// Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html)
// in the Amazon CloudSearch Developer Guide.
const (
	// IndexFieldTypeInt is a IndexFieldType enum value
	IndexFieldTypeInt = "int"

	// IndexFieldTypeDouble is a IndexFieldType enum value
	IndexFieldTypeDouble = "double"

	// IndexFieldTypeLiteral is a IndexFieldType enum value
	IndexFieldTypeLiteral = "literal"

	// IndexFieldTypeText is a IndexFieldType enum value
	IndexFieldTypeText = "text"

	// IndexFieldTypeDate is a IndexFieldType enum value
	IndexFieldTypeDate = "date"

	// IndexFieldTypeLatlon is a IndexFieldType enum value
	IndexFieldTypeLatlon = "latlon"

	// IndexFieldTypeIntArray is a IndexFieldType enum value
	IndexFieldTypeIntArray = "int-array"

	// IndexFieldTypeDoubleArray is a IndexFieldType enum value
	IndexFieldTypeDoubleArray = "double-array"

	// IndexFieldTypeLiteralArray is a IndexFieldType enum value
	IndexFieldTypeLiteralArray = "literal-array"

	// IndexFieldTypeTextArray is a IndexFieldType enum value
	IndexFieldTypeTextArray = "text-array"

	// IndexFieldTypeDateArray is a IndexFieldType enum value
	IndexFieldTypeDateArray = "date-array"
)

// The state of processing a change to an option. One of:
//
//    * RequiresIndexDocuments: The option's latest value will not be deployed
//    until IndexDocuments has been called and indexing is complete.
//    * Processing: The option's latest value is in the process of being activated.
//
//    * Active: The option's latest value is fully deployed.
//    * FailedToValidate: The option value is not compatible with the domain's
//    data and cannot be used to index the data. You must either modify the
//    option value or update or remove the incompatible documents.
const (
	// OptionStateRequiresIndexDocuments is a OptionState enum value
	OptionStateRequiresIndexDocuments = "RequiresIndexDocuments"

	// OptionStateProcessing is a OptionState enum value
	OptionStateProcessing = "Processing"

	// OptionStateActive is a OptionState enum value
	OptionStateActive = "Active"

	// OptionStateFailedToValidate is a OptionState enum value
	OptionStateFailedToValidate = "FailedToValidate"
)

// The instance type (such as search.m1.small) on which an index partition is
// hosted.
const (
	// PartitionInstanceTypeSearchM1Small is a PartitionInstanceType enum value
	PartitionInstanceTypeSearchM1Small = "search.m1.small"

	// PartitionInstanceTypeSearchM1Large is a PartitionInstanceType enum value
	PartitionInstanceTypeSearchM1Large = "search.m1.large"

	// PartitionInstanceTypeSearchM2Xlarge is a PartitionInstanceType enum value
	PartitionInstanceTypeSearchM2Xlarge = "search.m2.xlarge"

	// PartitionInstanceTypeSearchM22xlarge is a PartitionInstanceType enum value
	PartitionInstanceTypeSearchM22xlarge = "search.m2.2xlarge"

	// PartitionInstanceTypeSearchM3Medium is a PartitionInstanceType enum value
	PartitionInstanceTypeSearchM3Medium = "search.m3.medium"

	// PartitionInstanceTypeSearchM3Large is a PartitionInstanceType enum value
	PartitionInstanceTypeSearchM3Large = "search.m3.large"

	// PartitionInstanceTypeSearchM3Xlarge is a PartitionInstanceType enum value
	PartitionInstanceTypeSearchM3Xlarge = "search.m3.xlarge"

	// PartitionInstanceTypeSearchM32xlarge is a PartitionInstanceType enum value
	PartitionInstanceTypeSearchM32xlarge = "search.m3.2xlarge"
)

const (
	// SuggesterFuzzyMatchingNone is a SuggesterFuzzyMatching enum value
	SuggesterFuzzyMatchingNone = "none"

	// SuggesterFuzzyMatchingLow is a SuggesterFuzzyMatching enum value
	SuggesterFuzzyMatchingLow = "low"

	// SuggesterFuzzyMatchingHigh is a SuggesterFuzzyMatching enum value
	SuggesterFuzzyMatchingHigh = "high"
)
