package eventrules

// go generate -import github.com/mesos/mesos-go/api/v1/lib/scheduler -type E:*scheduler.Event:&scheduler.Event{} -type ET:scheduler.Event_Type -output metrics_generated.go
// GENERATED CODE FOLLOWS; DO NOT EDIT.

import (
	"context"

	"strings"

	"github.com/mesos/mesos-go/api/v1/lib/extras/metrics"

	"github.com/mesos/mesos-go/api/v1/lib/scheduler"
)

// Labeler generates a set of strings that should be associated with metrics that are generated for the given event.
type Labeler func(ctx context.Context, e *scheduler.Event) []string

var defaultLabels = func() map[scheduler.Event_Type][]string {
	m := make(map[scheduler.Event_Type][]string)
	for k, v := range scheduler.Event_Type_name {
		m[scheduler.Event_Type(k)] = []string{strings.ToLower(v)}
	}
	return m
}()

func defaultLabeler(ctx context.Context, e *scheduler.Event) []string {
	return defaultLabels[e.GetType()]
}

// Metrics generates a Rule that invokes the given harness for each event, using the labels generated by the Labeler.
// Panics if harness or labeler is nil.
func Metrics(harness metrics.Harness, labeler Labeler) Rule {
	if harness == nil {
		panic("harness is a required parameter")
	}
	if labeler == nil {
		labeler = defaultLabeler
	}
	return func(ctx context.Context, e *scheduler.Event, err error, ch Chain) (context.Context, *scheduler.Event, error) {
		labels := labeler(ctx, e)
		harness(func() error {
			ctx, e, err = ch(ctx, e, err)
			return err
		}, labels...)
		return ctx, e, err
	}
}
