#ifndef GPSSHOGI_REDIS_REDIS_H
#define GPSSHOGI_REDIS_REDIS_H

#include <hiredis/hiredis.h>
#include <boost/shared_ptr.hpp>
#include <string>

namespace gpsshogi {

  namespace redis {

    void connectRedisServer(redisContext **c, const std::string& host, const int port);

    bool authenticate(redisContext *c, const std::string& password);

    typedef boost::shared_ptr<redisReply> redisReplyPtr;

    void freeRedisReply(redisReply *reply);

    int checkRedisReply(const redisReplyPtr& reply);

  } // namespace redis
} // namespace gpsshogi

#endif /* GPSSHOGI_REDIS_REDIS_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
