// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/message.h>
#include <gstreamermm/private/message_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/element.h>
#include <gstreamermm/pad.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/taglist.h>

#include <iostream>

namespace Gst
{

namespace Enums
{

Glib::ustring get_name(MessageType t)
{
  return gst_message_type_get_name(static_cast<GstMessageType>(t));
}

Glib::QueryQuark get_quark(MessageType t)
{
  return Glib::QueryQuark(gst_message_type_to_quark(static_cast<GstMessageType>(t)));
}

} //namespace Enums

Glib::RefPtr<Gst::Message> Message::create_writable()
{
  return Glib::RefPtr<Message>::cast_static(MiniObject::create_writable());
}

Glib::RefPtr<Gst::MessageEos>
  MessageEos::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_eos(Glib::unwrap(src));
  return Gst::wrap_msg_derived<Gst::MessageEos>(message, true);
}

Glib::RefPtr<Gst::MessageError>
  MessageError::create(const Glib::RefPtr<Gst::Object>& src,
  Glib::Error& error, const std::string& debug)
{
  GstMessage* message = gst_message_new_error(Glib::unwrap(src), error.gobj(),
    reinterpret_cast<const gchar*>(debug.c_str()));
  return Gst::wrap_msg_derived<Gst::MessageError>(message, true);
}

void MessageError::parse(Glib::Error& error, std::string& debug) const
{
  GError* c_error = 0;
  gchar* c_debug = 0;
  gst_message_parse_error(const_cast<GstMessage*>(gobj()), &c_error, &c_debug);

  debug = c_debug;
  if(c_debug)
    g_free(c_debug);

  error = Glib::Error(c_error);
}

Glib::Error MessageError::parse() const
{
  GError* c_error = 0;
  gst_message_parse_error(const_cast<GstMessage*>(gobj()), &c_error, 0);

  return Glib::Error(c_error);
}

std::string MessageError::parse_debug() const
{
  gchar* c_debug = 0;
  GError* c_error = 0;

  gst_message_parse_error(const_cast<GstMessage*>(gobj()), &c_error, &c_debug);

  std::string result = c_debug;

  if(c_debug)
    g_free(c_debug);

  if(c_error)
    g_error_free(c_error);

  return result;
}

Glib::RefPtr<Gst::MessageWarning>
  MessageWarning::create(const Glib::RefPtr<Gst::Object>& src,
  Glib::Error& error, const std::string& debug)
{
  GstMessage* message = gst_message_new_warning(Glib::unwrap(src),
    error.gobj(), reinterpret_cast<const gchar*>(debug.c_str()));
  return Gst::wrap_msg_derived<Gst::MessageWarning>(message, true);
}

void MessageWarning::parse(Glib::Error& error, std::string& debug) const
{
  GError* c_error = 0;
  gchar* c_debug = 0;
  gst_message_parse_warning(const_cast<GstMessage*>(gobj()), &c_error, &c_debug);

  debug = c_debug;
  if(c_debug)
    g_free(c_debug);

  error = Glib::Error(c_error);
}

Glib::Error MessageWarning::parse() const
{
  GError* c_error = 0;
  gst_message_parse_warning(const_cast<GstMessage*>(gobj()), &c_error, 0);

  return Glib::Error(c_error);
}

std::string MessageWarning::parse_debug() const
{
  gchar* c_debug = 0;
  GError* c_error = 0;

  gst_message_parse_warning(const_cast<GstMessage*>(gobj()), &c_error,
    &c_debug);

  std::string result = c_debug;

  if(c_debug)
    g_free(c_debug);

  if(c_error)
    g_error_free(c_error);

  return result;
}

Glib::RefPtr<Gst::MessageInfo>
  MessageInfo::create(const Glib::RefPtr<Gst::Object>& src,
  Glib::Error& error, const std::string& debug)
{
  GstMessage* message = gst_message_new_info(Glib::unwrap(src), error.gobj(),
    reinterpret_cast<const gchar*>(debug.c_str()));
  return Gst::wrap_msg_derived<Gst::MessageInfo>(message, true);
}


void MessageInfo::parse(Glib::Error& error, std::string& debug) const
{
  GError* c_error = 0;
  gchar* c_debug = 0;
  gst_message_parse_info(const_cast<GstMessage*>(gobj()), &c_error, &c_debug);

  debug = c_debug;
  if(c_debug)
    g_free(c_debug);

  error = Glib::Error(c_error);
}

Glib::Error MessageInfo::parse() const
{
  GError* c_error = 0;
  gst_message_parse_info(const_cast<GstMessage*>(gobj()), &c_error, 0);

  return Glib::Error(c_error);
}

std::string MessageInfo::parse_debug() const
{
  gchar* c_debug = 0;
  GError* c_error = 0;

  gst_message_parse_info(const_cast<GstMessage*>(gobj()), &c_error, &c_debug);

  std::string result = c_debug;

  if(c_debug)
    g_free(c_debug);

  if(c_error)
    g_error_free(c_error);

  return result;
}

Glib::RefPtr<Gst::MessageTag>
  MessageTag::create(const Glib::RefPtr<Gst::Object>& src, const Gst::TagList& taglist)
{
  GstTagList* c_taglist = gst_tag_list_copy(taglist.gobj());
  GstMessage* message = gst_message_new_tag(Glib::unwrap(src), c_taglist);
  return Gst::wrap_msg_derived<Gst::MessageTag>(message, true);
}

void MessageTag::parse(Gst::TagList& tag_list)
  const
{
  GstTagList* gst_tag_list = 0;

  gst_message_parse_tag(const_cast<GstMessage*>(gobj()), &gst_tag_list);

  // Use the Gst::TagList specific Glib::wrap() function:
  tag_list = Glib::wrap_taglist(gst_tag_list);
}

Gst::TagList MessageTag::parse() const
{
  GstTagList* gst_tag_list = 0;
  gst_message_parse_tag(const_cast<GstMessage*>(gobj()), &gst_tag_list);
  return Gst::TagList(gst_tag_list);
}

Glib::RefPtr<Gst::MessageBuffering>
  MessageBuffering::create(const Glib::RefPtr<Gst::Object>& src, int percent)
{
  GstMessage* message = gst_message_new_buffering(Glib::unwrap(src), percent);
  return Gst::wrap_msg_derived<Gst::MessageBuffering>(message, true);
}

int MessageBuffering::parse() const
{
  int percent = 0;
  gst_message_parse_buffering(const_cast<GstMessage*>(gobj()), &percent);
  return percent;
}

void MessageBuffering::set_stats(BufferingMode mode, int avg_in, int avg_out,
gint64 buffering_left)
{
  gst_message_set_buffering_stats(gobj(), static_cast<GstBufferingMode>(mode),
  avg_in, avg_out, buffering_left);
}

void MessageBuffering::parse_stats(BufferingMode& mode, int& avg_in,
int& avg_out, gint64& buffering_left) const
{
  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstBufferingMode*>(&mode), &avg_in, &avg_out,
    &buffering_left);
}

BufferingMode MessageBuffering::parse_stats_buffering_mode() const
{
  GstBufferingMode mode = GST_BUFFERING_STREAM;

  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()), &mode,
    0, 0, 0);
  return static_cast<BufferingMode>(mode);
}

int MessageBuffering::parse_stats_avg_in() const
{
  int avg_in = 0;

  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()), 0,
    &avg_in, 0, 0);
  return avg_in;
}

int MessageBuffering::parse_stats_avg_out() const
{
  int avg_out = 0;

  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()), 0,
    0, &avg_out, 0);
  return avg_out;
}

gint64 MessageBuffering::parse_stats_buffering_left() const
{
  gint64 buffering_left = 0;

  gst_message_parse_buffering_stats(const_cast<GstMessage*>(gobj()), 0,
    0, 0, &buffering_left);
  return buffering_left;
}

Glib::RefPtr<Gst::MessageStateChanged>
  MessageStateChanged::create(const Glib::RefPtr<Gst::Object>& src,
  State oldstate, State newstate, State pending)
{
  GstMessage* message = gst_message_new_state_changed(Glib::unwrap(src),
    static_cast<GstState>(oldstate), static_cast<GstState>(newstate),
    static_cast<GstState>(pending));
  return Gst::wrap_msg_derived<Gst::MessageStateChanged>(message, true);
}

void MessageStateChanged::parse(State& oldstate, State& newstate,
State& pending) const
{
  gst_message_parse_state_changed(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstState*>(&oldstate),
    reinterpret_cast<GstState*>(&newstate),
    reinterpret_cast<GstState*>(&pending));
}

State MessageStateChanged::parse() const
{
  GstState new_state = GST_STATE_NULL;

  gst_message_parse_state_changed(const_cast<GstMessage*>(gobj()), 0,
    &new_state, 0);
  return State(new_state);
}

State MessageStateChanged::parse_old() const
{
  GstState old_state = GST_STATE_NULL;

  gst_message_parse_state_changed(const_cast<GstMessage*>(gobj()), &old_state,
    0, 0);
  return State(old_state);
}

State MessageStateChanged::parse_pending() const
{
  GstState pending_state = GST_STATE_NULL;
  gst_message_parse_state_changed(const_cast<GstMessage*>(gobj()), 0,
    0, &pending_state);
  return State(pending_state);
}

Glib::RefPtr<Gst::MessageStateDirty>
  MessageStateDirty::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_state_dirty(Glib::unwrap(src));
  return Gst::wrap_msg_derived<Gst::MessageStateDirty>(message, true);
}

Glib::RefPtr<Gst::MessageStepDone>
  MessageStepDone::create(const Glib::RefPtr<Gst::Object>& src,
  Gst::Format format, guint64 amount, double rate, bool flush,
  bool intermediate, guint64 duration, bool eos)
{
  GstMessage* message = gst_message_new_step_done(Glib::unwrap(src),
    static_cast<GstFormat>(format), amount, rate, flush, intermediate,
    duration, eos);
  return Gst::wrap_msg_derived<Gst::MessageStepDone>(message, true);
}

void MessageStepDone::parse(Gst::Format& format, guint64& amount, double& rate,
  bool& flush, bool& intermediate, guint64& duration, bool& eos) const
{
  gboolean gst_flush = FALSE;
  gboolean gst_intermediate = FALSE;
  gboolean gst_eos = FALSE;

  gst_message_parse_step_done(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), &amount, &rate, &gst_flush,
    &gst_intermediate, &duration, &gst_eos);

  flush = gst_flush;
  intermediate = gst_intermediate;
  eos = gst_eos;
}

guint64 MessageStepDone::parse() const
{
  guint64 duration = 0;
  gst_message_parse_step_done(const_cast<GstMessage*>(gobj()), 0, 0, 0, 0, 0,
    &duration, 0);
  return duration;
}

Gst::Format MessageStepDone::parse_format() const
{
  GstFormat format = GST_FORMAT_UNDEFINED;
  gst_message_parse_step_done(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), 0, 0, 0, 0, 0, 0);
  return static_cast<Gst::Format>(format);
}

guint64 MessageStepDone::parse_amount() const
{
  guint64 amount = 0;
  gst_message_parse_step_done(const_cast<GstMessage*>(gobj()), 0, &amount, 0,
    0, 0, 0, 0);
  return amount;
}

double MessageStepDone::parse_rate() const
{
  double rate = 0;
  gst_message_parse_step_done(const_cast<GstMessage*>(gobj()), 0, 0, &rate, 0,
    0, 0, 0);
  return rate;
}

bool MessageStepDone::parse_flush() const
{
  gboolean gst_flush = FALSE;
  gst_message_parse_step_done(const_cast<GstMessage*>(gobj()), 0, 0, 0,
    &gst_flush, 0, 0, 0);
  return gst_flush;
}

bool MessageStepDone::parse_intermediate() const
{
  gboolean gst_intermediate = FALSE;
  gst_message_parse_step_done(const_cast<GstMessage*>(gobj()), 0, 0, 0, 0,
    &gst_intermediate, 0, 0);
  return gst_intermediate;
}

bool MessageStepDone::parse_eos() const
{
  gboolean gst_eos = FALSE;
  gst_message_parse_step_done(const_cast<GstMessage*>(gobj()), 0, 0, 0, 0, 0,
    0, &gst_eos);
  return gst_eos;
}

Glib::RefPtr<Gst::MessageClockProvide>
  MessageClockProvide::create(const Glib::RefPtr<Gst::Object>& src,
  const Glib::RefPtr<Gst::Clock>& clock, bool ready)
{
  GstMessage* message = gst_message_new_clock_provide(Glib::unwrap(src),
    Glib::unwrap(clock), ready);
  return Gst::wrap_msg_derived<Gst::MessageClockProvide>(message, true);
}

void MessageClockProvide::parse(Glib::RefPtr<Gst::Clock>& clock, bool& ready) const
{
  GstClock* cclock = 0;
  gboolean ready_ = false;
  gst_message_parse_clock_provide(const_cast<GstMessage*>(gobj()), &cclock,
    &ready_);
  clock = Glib::wrap(cclock);
  ready = ready_;
}

Glib::RefPtr<Gst::Clock> MessageClockProvide::parse()
{
  GstClock* cclock = 0;
  gst_message_parse_clock_provide(gobj(), &cclock, 0);
  return Glib::wrap(cclock);
}

Glib::RefPtr<const Gst::Clock> MessageClockProvide::parse() const
{
  return parse();
}

bool MessageClockProvide::parse_ready() const
{
  gboolean ready = FALSE;
  gst_message_parse_clock_provide(const_cast<GstMessage*>(gobj()), 0,
    &ready);
  return ready;
}

Glib::RefPtr<Gst::MessageClockLost>
  MessageClockLost::create(const Glib::RefPtr<Gst::Object>& src,
  const Glib::RefPtr<Gst::Clock>& clock)
{
  GstMessage* message = gst_message_new_clock_lost(Glib::unwrap(src),
    Glib::unwrap(clock));
  return Gst::wrap_msg_derived<Gst::MessageClockLost>(message, true);
}

Glib::RefPtr<Gst::Clock> MessageClockLost::parse()
{
  GstClock* cclock = 0;
  gst_message_parse_clock_lost(gobj(), &cclock);
  return Glib::wrap(cclock, false);
}

Glib::RefPtr<const Gst::Clock> MessageClockLost::parse() const
{
  return parse();
}

Glib::RefPtr<Gst::MessageNewClock>
  MessageNewClock::create(const Glib::RefPtr<Gst::Object>& src,
  const Glib::RefPtr<Gst::Clock>& clock)
{
  GstMessage* message = gst_message_new_new_clock(Glib::unwrap(src),
    Glib::unwrap(clock));
  return Gst::wrap_msg_derived<Gst::MessageNewClock>(message, true);
}

Glib::RefPtr<Gst::Clock> MessageNewClock::parse()
{
  GstClock* cclock = 0;
  gst_message_parse_new_clock(gobj(), &cclock);
  return Glib::wrap(cclock, false);
}

Glib::RefPtr<const Gst::Clock> MessageNewClock::parse() const
{
  return parse();
}

Glib::RefPtr<Gst::MessageApplication>
  MessageApplication::create(const Glib::RefPtr<Gst::Object>& src,
  const Gst::Structure& structure)
{
  GstStructure* copy_struct = gst_structure_copy(structure.gobj());
  GstMessage* message = gst_message_new_application(Glib::unwrap(src),
    copy_struct);
  return Gst::wrap_msg_derived<Gst::MessageApplication>(message, true);
}

Glib::RefPtr<Gst::MessageElement>
  MessageElement::create(const Glib::RefPtr<Gst::Object>& src,
  Gst::Structure& structure)
{
  GstStructure* copy_struct = gst_structure_copy(structure.gobj());
  GstMessage* message = gst_message_new_element(Glib::unwrap(src),
    copy_struct);
  return Gst::wrap_msg_derived<Gst::MessageElement>(message, true);
}

Glib::RefPtr<Gst::MessageElement>
  MessageElement::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_element(Glib::unwrap(src), 0);
  return Gst::wrap_msg_derived<Gst::MessageElement>(message, true);
}

Glib::RefPtr<Gst::MessageCustom>
  MessageCustom::create(MessageType type, const Glib::RefPtr<Gst::Object>& src,
  Gst::Structure& structure)
{
  GstStructure* copy_struct = gst_structure_copy(structure.gobj());
  GstMessage* message = gst_message_new_custom(GstMessageType(type),
    Glib::unwrap(src), copy_struct);
  return Gst::wrap_msg_derived<Gst::MessageCustom>(message, true);
}

Glib::RefPtr<Gst::MessageCustom>
  MessageCustom::create(MessageType type, const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_custom(GstMessageType(type),
    Glib::unwrap(src), 0);
  return Gst::wrap_msg_derived<Gst::MessageCustom>(message, true);
}

Glib::RefPtr<Gst::MessageSegmentStart>
  MessageSegmentStart::create(const Glib::RefPtr<Gst::Object>& src,
  Format format, gint64 position)
{
  GstMessage* message = gst_message_new_segment_start(Glib::unwrap(src),
    static_cast<GstFormat>(format), position);
  return Gst::wrap_msg_derived<Gst::MessageSegmentStart>(message, true);
}

void MessageSegmentStart::parse(Format& format, gint64& position) const
{
  gst_message_parse_segment_start(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), &position);
}

gint64 MessageSegmentStart::parse() const
{
  gint64 position = 0;
  gst_message_parse_segment_start(const_cast<GstMessage*>(gobj()), 0,
    &position);
  return position;
}

Format MessageSegmentStart::parse_format() const
{
  Format format = Gst::FORMAT_DEFAULT;
  gst_message_parse_segment_start(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), 0);
  return format;
}

Glib::RefPtr<Gst::MessageSegmentDone>
  MessageSegmentDone::create(const Glib::RefPtr<Gst::Object>& src,
  Format format, gint64 position)
{
  GstMessage* message = gst_message_new_segment_done(Glib::unwrap(src),
    static_cast<GstFormat>(format), position);
  return Gst::wrap_msg_derived<Gst::MessageSegmentDone>(message, true);
}

void MessageSegmentDone::parse(Format& format, gint64& position) const
{
  gst_message_parse_segment_done(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), &position);
}

gint64 MessageSegmentDone::parse() const
{
  gint64 position = 0;
  gst_message_parse_segment_done(const_cast<GstMessage*>(gobj()), 0,
    &position);
  return position;
}

Format MessageSegmentDone::parse_format() const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_message_parse_segment_done(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), 0);
  return format;
}

Glib::RefPtr<Gst::MessageDuration>
  MessageDuration::create(const Glib::RefPtr<Gst::Object>& src, Gst::Format,
  gint64 /* duration */)
{
  GstMessage* message = gst_message_new_duration(Glib::unwrap(src),
    static_cast<GstFormat>(format), duration);
  return Gst::wrap_msg_derived<Gst::MessageDuration>(message, true);
}

void MessageDuration::parse(Format& format, gint64& duration) const
{
  gst_message_parse_duration(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), &duration);
}

gint64 MessageDuration::parse() const
{
  gint64 duration = 0;
  gst_message_parse_duration(const_cast<GstMessage*>(gobj()), 0, &duration);
  return duration;
}

Format MessageDuration::parse_format() const
{
  Format format = Gst::FORMAT_UNDEFINED;
  gst_message_parse_duration(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), 0);
  return format;
}

Glib::RefPtr<Gst::MessageLatency>
  MessageLatency::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_latency(Glib::unwrap(src));
  return Gst::wrap_msg_derived<Gst::MessageLatency>(message, true);
}

Glib::RefPtr<Gst::MessageAsyncStart>
  MessageAsyncStart::create(const Glib::RefPtr<Gst::Object>& src)
{
  GstMessage* message = gst_message_new_async_start(Glib::unwrap(src));
  return Gst::wrap_msg_derived<Gst::MessageAsyncStart>(message, true);
}

Glib::RefPtr<Gst::MessageAsyncDone>
  MessageAsyncDone::create(const Glib::RefPtr<Gst::Object>& src, ClockTime running_time)
{
  GstMessage* message = gst_message_new_async_done(Glib::unwrap(src), running_time);
  return Gst::wrap_msg_derived<Gst::MessageAsyncDone>(message, true);
}

Glib::RefPtr<Gst::MessageStepStart>
  MessageStepStart::create(const Glib::RefPtr<Gst::Object>& src,
  bool active, Gst::Format format, guint64 amount, double rate, bool flush,
  bool intermediate)
{
  GstMessage* message = gst_message_new_step_start(Glib::unwrap(src),
    active, static_cast<GstFormat>(format), amount, rate, flush, intermediate);
  return Gst::wrap_msg_derived<Gst::MessageStepStart>(message, true);
}

void MessageStepStart::parse(bool& active, Gst::Format& format,
  guint64& amount, double& rate, bool& flush, bool& intermediate) const
{
  gboolean gst_active = FALSE;
  gboolean gst_flush = FALSE;
  gboolean gst_intermediate = FALSE;

  gst_message_parse_step_start(const_cast<GstMessage*>(gobj()), &gst_active,
    reinterpret_cast<GstFormat*>(&format), &amount, &rate, &gst_flush,
    &gst_intermediate);

  active = gst_active;
  flush = gst_flush;
  intermediate = gst_intermediate;
}

guint64 MessageStepStart::parse() const
{
  guint64 amount = 0;
  gst_message_parse_step_start(const_cast<GstMessage*>(gobj()), 0, 0, &amount,
    0, 0, 0);
  return amount;
}

bool MessageStepStart::parse_active() const
{
  gboolean gst_active = FALSE;
  gst_message_parse_step_start(const_cast<GstMessage*>(gobj()), &gst_active, 0,
    0, 0, 0, 0);
  return gst_active;
}

Gst::Format MessageStepStart::parse_format() const
{
  GstFormat format = GST_FORMAT_UNDEFINED;
  gst_message_parse_step_start(const_cast<GstMessage*>(gobj()), 0,
    reinterpret_cast<GstFormat*>(&format), 0, 0, 0, 0);
  return static_cast<Gst::Format>(format);
}

double MessageStepStart::parse_rate() const
{
  double rate = 0;
  gst_message_parse_step_start(const_cast<GstMessage*>(gobj()), 0, 0, 0, &rate,
    0, 0);
  return rate;
}

bool MessageStepStart::parse_flush() const
{
  gboolean gst_flush = FALSE;
  gst_message_parse_step_start(const_cast<GstMessage*>(gobj()), 0, 0, 0, 0,
    &gst_flush, 0);
  return gst_flush;
}

bool MessageStepStart::parse_intermediate() const
{
  gboolean gst_intermediate = FALSE;
  gst_message_parse_step_start(const_cast<GstMessage*>(gobj()), 0, 0, 0, 0, 0,
    &gst_intermediate);
  return gst_intermediate;
}

Glib::RefPtr<Gst::MessageStructureChange>
  MessageStructureChange::create(const Glib::RefPtr<Gst::Object>& src,
  Gst::StructureChangeType type, const Glib::RefPtr<Gst::Element>& owner,
  bool busy)
{
  GstMessage* message = gst_message_new_structure_change(Glib::unwrap(src),
    static_cast<GstStructureChangeType>(type), Glib::unwrap(owner), busy);
  return Gst::wrap_msg_derived<Gst::MessageStructureChange>(message, true);
}

void MessageStructureChange::parse(Gst::StructureChangeType& type,
  Glib::RefPtr<Gst::Element>& owner, bool& busy) const
{
  GstElement* gst_element = 0;
  gboolean gst_busy = false;
  gst_message_parse_structure_change(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstStructureChangeType*>(&type), &gst_element, &gst_busy);
  owner = Glib::wrap(gst_element, true);
  busy = gst_busy;
}

Gst::StructureChangeType MessageStructureChange::parse() const
{
  GstStructureChangeType gst_type = GST_STRUCTURE_CHANGE_TYPE_PAD_LINK;
  gst_message_parse_structure_change(const_cast<GstMessage*>(gobj()),
    &gst_type, 0, 0);
  return static_cast<Gst::StructureChangeType>(gst_type);
}

Glib::RefPtr<Gst::Element> MessageStructureChange::parse_owner() const
{
  GstElement* gst_element = 0;
  gst_message_parse_structure_change(const_cast<GstMessage*>(gobj()), 0,
    &gst_element, 0);
  return Glib::wrap(gst_element, true);
}

bool MessageStructureChange::parse_busy() const
{
  gboolean gst_busy = false;
  gst_message_parse_structure_change(const_cast<GstMessage*>(gobj()), 0, 0,
    &gst_busy);
  return gst_busy;
}

Glib::RefPtr<Gst::MessageRequestState>
  MessageRequestState::create(const Glib::RefPtr<Gst::Object>& src,
  Gst::State state)
{
  GstMessage* message = gst_message_new_request_state(Glib::unwrap(src),
    static_cast<GstState>(state));
  return Gst::wrap_msg_derived<Gst::MessageRequestState>(message, true);
}

Gst::State MessageRequestState::parse() const
{
  GstState gst_state = GST_STATE_VOID_PENDING;
  gst_message_parse_request_state(const_cast<GstMessage*>(gobj()),
    &gst_state);
  return static_cast<Gst::State>(gst_state);
}

Glib::RefPtr<Gst::MessageStreamStatus>
  MessageStreamStatus::create(const Glib::RefPtr<Gst::Object>& src,
  Gst::StreamStatusType type, const Glib::RefPtr<Gst::Element>& owner)
{
  GstMessage* message = gst_message_new_stream_status(Glib::unwrap(src),
    static_cast<GstStreamStatusType>(type), Glib::unwrap(owner));
  return Gst::wrap_msg_derived<Gst::MessageStreamStatus>(message, true);
}

void MessageStreamStatus::set_object(const Glib::RefPtr<Gst::Object>& object)
{
  Glib::Value< Glib::RefPtr<Gst::Object> > value;
  value.init(Glib::Value< Glib::RefPtr<Gst::Object> >::value_type());
  value.set(object);

  gst_message_set_stream_status_object(gobj(), value.gobj());
}

Glib::RefPtr<Gst::Object> MessageStreamStatus::get_object() const
{
  const GValue* g_val =
    gst_message_get_stream_status_object(const_cast<GstMessage*>(gobj()));
  GstObject* gst_object = static_cast<GstObject*>(g_value_get_object(g_val));
  return Glib::wrap(gst_object, true);
}

void MessageStreamStatus::parse(Gst::StreamStatusType& type,
  Glib::RefPtr<Gst::Element>& owner) const
{
  GstElement* gst_element;
  gst_message_parse_stream_status(const_cast<GstMessage*>(gobj()),
    reinterpret_cast<GstStreamStatusType*>(&type), &gst_element);
  owner = Glib::wrap(gst_element, true);
}

Gst::StreamStatusType MessageStreamStatus::parse() const
{
  GstStreamStatusType type;
  gst_message_parse_stream_status(const_cast<GstMessage*>(gobj()),
    &type, 0);
  return static_cast<Gst::StreamStatusType>(type);
}

Glib::RefPtr<Gst::Element> MessageStreamStatus::parse_owner() const
{
  GstElement* gst_element;
  gst_message_parse_stream_status(const_cast<GstMessage*>(gobj()), 0,
    &gst_element);
  return Glib::wrap(gst_element, true);
}

} //namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::MessageType>::value_type()
{
  return gst_message_type_get_type();
}

// static
GType Glib::Value<Gst::StructureChangeType>::value_type()
{
  return gst_structure_change_type_get_type();
}

// static
GType Glib::Value<Gst::StreamStatusType>::value_type()
{
  return gst_stream_status_type_get_type();
}


/* Why reinterpret_cast<Message*>(gobject) is needed:
 *
 * A Message instance is in fact always a GstMessage instance.
 * Unfortunately, GstMessage cannot be a member of Message,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Message does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gst::Message> wrap(GstMessage* object, bool take_copy)
{
  if(take_copy && object)
    gst_message_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::Message>(reinterpret_cast<Gst::Message*>(object));
}

} // namespace Glib


namespace Gst
{


void Message::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_message_ref(reinterpret_cast<GstMessage*>(const_cast<Message*>(this)));
}

void Message::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_message_unref(reinterpret_cast<GstMessage*>(const_cast<Message*>(this)));
}

GstMessage* Message::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstMessage*>(this);
}

const GstMessage* Message::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstMessage*>(this);
}

GstMessage* Message::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GstMessage *const gobject = reinterpret_cast<GstMessage*>(const_cast<Message*>(this));
  gst_message_ref(gobject);
  return gobject;
}


Gst::Structure Message::get_structure() const
{
  return Glib::wrap(const_cast<GstStructure*>(gst_message_get_structure(const_cast<GstMessage*>(gobj()))), true);
}

guint32 Message::get_seqnum() const
{
  return gst_message_get_seqnum(const_cast<GstMessage*>(gobj()));
}

void Message::set_seqnum(guint32 seqnum)
{
  gst_message_set_seqnum(gobj(), seqnum);
}

 MessageType Message::get_message_type() const
{
  return ((MessageType)(gobj()->type));
}
 
 ClockTime Message::get_timestamp() const
{
  return (ClockTime)(gobj()->timestamp);
}
 
 Glib::RefPtr<Gst::Object> Message::get_source()
{
  Glib::RefPtr<Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gst::Object> Message::get_source() const
{
  Glib::RefPtr<const Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 

} // namespace Gst


