# GSW-Python

[![Tests](https://github.com/TEOS-10/GSW-Python/actions/workflows/tests.yml/badge.svg)](https://github.com/TEOS-10/GSW-Python/actions/workflows/tests.yml)
[![Wheels](https://github.com/TEOS-10/GSW-Python/actions/workflows/cibuildwheel.yml/badge.svg)](https://github.com/TEOS-10/GSW-Python/actions/workflows/cibuildwheel.yml)
[![DOI](https://zenodo.org/badge/86503067.svg)](https://zenodo.org/badge/latestdoi/86503067)


This Python implementation of the Thermodynamic Equation of Seawater 2010 (TEOS-10) is based primarily on numpy ufunc wrappers of the GSW-C implementation.
This library replaces the original [python-gsw](https://github.com/TEOS-10/python-gsw) pure-python implementation..
The primary reasons for this change are that by building on the C implementation we reduce code duplication and we gain an immediate update to the 75-term equation.  
Additional benefits include a major increase in speed,
a reduction in memory usage,
and the inclusion of more functions.
The penalty is that a C (or MSVC C++ for Windows) compiler is required to build the package from source.

**Warning: this is for Python >=3.8 only.**

Documentation is provided at https://teos-10.github.io/GSW-Python/.

For the core functionality, we use an auto-generated C extension
module to wrap the C functions as numpy [ufuncs](https://docs.scipy.org/doc/numpy/reference/ufuncs.html),
and then use an autogenerated Python module to add docstrings and handle masked arrays.
165 scalar C functions with only double-precision arguments and return values are wrapped as ufuncs,
and 158 of these are exposed in the ``gsw`` namespace with an additional wrapper in Python.

A hand-written wrapper is used for one C function, and others are re-implemented directly in Python instead of being wrapped.
Additional functions present in GSW-Matlab but not in GSW-C may be re-implemented in Python,
but there is no expectation that all such functions will be provided.

## Installation

Pip users can install the pre-built wheels with:

```shell
pip install gsw
```

conda users will find binaries on conda-forge,

```shell
conda install gsw --channel conda-forge
```

The development version of the package can be installed from a clone of the repo using

```shell
pip install .
```

It is neither necessary nor recommended to run the code generators,
and no instructions are provided for them;
their output is included in the repo.
You will need a suitable compiler:
gcc or clang for unix-like systems,
or the MSVC compiler set used for Python itself on Windows.
For Windows, some of the source code has been modified to C++ because the MSVC C compiler does not support the
C99 complex data type used in original GSW-C.

To test, after installation, run "pytest" from the source directory.

## Note for xarray users

A wrapper around gsw called [gsw-xarray](https://github.com/DocOtak/gsw-xarray) exists for xarray.
It adds CF compliant attributes when possible, units, and name.

## Note on generating the docstrings

The autogenerated docstrings are checked with codespell in the CIs.
when autogenerating them we need to run ``pre-commit run --all-files`` and fix the documentation issues found.
