declare id "tiltdrive";
declare name "Tilt Tone Pro";
declare category "External";

import("stdfaust.lib");
import("redeye.lib");

process = pre : fi.iir((b0/a0,b1/a0,b2/a0,b3/a0,b4/a0,b5/a0),(a1/a0,a2/a0,a3/a0,a4/a0,a5/a0)) with {
    LogPot(a, x) = ba.if(a, (exp(a * x) - 1) / (exp(a) - 1), x);
    Inverted(b, x) = ba.if(b, 1 - x, x);
    s = 0.993;
    fs = float(ma.SR);
    pre = _;

    
        
        Body = vslider("Body[name:Body]", 0.5, 0, 1, 0.01) : Inverted(0) : si.smooth(s);
            
                Tone = vslider("Tone[name:Tone]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(1) : si.smooth(s);
            
                Drive = vslider("Drive[name:Drive]", 0.5, 0, 1, 0.01) : Inverted(1) : LogPot(1) : si.smooth(s);
            
                Level = vslider("Level[name:Level]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(1) : si.smooth(s);
            
    b0 = Level*(Body*(Drive*pow(fs,2)*(fs*(-3.98252244086665e-19*fs - 1.25414294001131e-16) - 1.8087904407686e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(-2.23479676537841e-22*fs - 3.38605570511882e-21) - 3.17641482147733e-31) - 4.81274972951113e-30) + pow(fs,2)*(fs*(fs*(2.23479676537841e-22*fs + 3.38605570511882e-21) + 3.17641482147733e-31) + 4.81274972951113e-30)) + pow(fs,2)*(fs*(3.98252244086665e-19*fs + 1.25414294001131e-16) + 1.8087904407686e-15)) + Drive*pow(fs,2)*(fs*(-8.92085026754128e-20*fs - 5.05613478219161e-16) - 7.64033082180657e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(-5.00594475444762e-23*fs - 7.58476477946615e-22) + 4.77520676362908e-16) + 7.23516176307441e-15) + pow(fs,2)*(fs*(fs*(5.00594475444762e-23*fs + 7.58476477946615e-22) - 4.77520676362908e-16) - 7.23516176307441e-15)) + pow(fs,2)*(fs*(8.92085026754128e-20*fs + 5.05613478219161e-16) + 7.64033082180657e-15));

    b1 = Level*(Body*(Drive*pow(fs,2)*(fs*(1.19475673226e-18*fs + 1.25414294001131e-16) - 1.8087904407686e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(1.1173983826892e-21*fs + 1.01581671153565e-20) + 3.17641482147733e-31) - 4.81274972951113e-30) + pow(fs,2)*(fs*(fs*(-1.1173983826892e-21*fs - 1.01581671153565e-20) - 3.17641482147733e-31) + 4.81274972951113e-30)) + pow(fs,2)*(fs*(-1.19475673226e-18*fs - 1.25414294001131e-16) + 1.8087904407686e-15)) + Drive*pow(fs,2)*(fs*(2.67625508026238e-19*fs + 5.05613478219161e-16) - 7.64033082180657e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(2.50297237722381e-22*fs + 2.27542943383984e-21) - 4.77520676362908e-16) + 7.23516176307441e-15) + pow(fs,2)*(fs*(fs*(-2.50297237722381e-22*fs - 2.27542943383984e-21) + 4.77520676362908e-16) - 7.23516176307441e-15)) + pow(fs,2)*(fs*(-2.67625508026238e-19*fs - 5.05613478219161e-16) + 7.64033082180657e-15));

    b2 = Level*(Body*(Drive*pow(fs,2)*(fs*(-7.9650448817333e-19*fs + 2.50828588002261e-16) + 3.61758088153719e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(-2.23479676537841e-21*fs - 6.77211141023765e-21) + 6.35282964295466e-31) + 9.62549945902227e-30) + pow(fs,2)*(fs*(fs*(2.23479676537841e-21*fs + 6.77211141023765e-21) - 6.35282964295466e-31) - 9.62549945902227e-30)) + pow(fs,2)*(fs*(7.9650448817333e-19*fs - 2.50828588002261e-16) - 3.61758088153719e-15)) + Drive*pow(fs,2)*(fs*(-1.78417005350826e-19*fs + 1.01122695643832e-15) + 1.52806616436131e-14) + Tone*(Drive*pow(fs,2)*(fs*(fs*(-5.00594475444762e-22*fs - 1.51695295589323e-21) - 9.55041352725816e-16) - 1.44703235261488e-14) + pow(fs,2)*(fs*(fs*(5.00594475444762e-22*fs + 1.51695295589323e-21) + 9.55041352725816e-16) + 1.44703235261488e-14)) + pow(fs,2)*(fs*(1.78417005350826e-19*fs - 1.01122695643832e-15) - 1.52806616436131e-14));

    b3 = Level*(Body*(Drive*pow(fs,2)*(fs*(-7.9650448817333e-19*fs - 2.50828588002261e-16) + 3.61758088153719e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(2.23479676537841e-21*fs - 6.77211141023765e-21) - 6.35282964295466e-31) + 9.62549945902227e-30) + pow(fs,2)*(fs*(fs*(-2.23479676537841e-21*fs + 6.77211141023765e-21) + 6.35282964295466e-31) - 9.62549945902227e-30)) + pow(fs,2)*(fs*(7.9650448817333e-19*fs + 2.50828588002261e-16) - 3.61758088153719e-15)) + Drive*pow(fs,2)*(fs*(-1.78417005350826e-19*fs - 1.01122695643832e-15) + 1.52806616436131e-14) + Tone*(Drive*pow(fs,2)*(fs*(fs*(5.00594475444762e-22*fs - 1.51695295589323e-21) + 9.55041352725816e-16) - 1.44703235261488e-14) + pow(fs,2)*(fs*(fs*(-5.00594475444762e-22*fs + 1.51695295589323e-21) - 9.55041352725816e-16) + 1.44703235261488e-14)) + pow(fs,2)*(fs*(1.78417005350826e-19*fs + 1.01122695643832e-15) - 1.52806616436131e-14));

    b4 = Level*(Body*(Drive*pow(fs,2)*(fs*(1.19475673226e-18*fs - 1.25414294001131e-16) - 1.8087904407686e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(-1.1173983826892e-21*fs + 1.01581671153565e-20) - 3.17641482147733e-31) - 4.81274972951113e-30) + pow(fs,2)*(fs*(fs*(1.1173983826892e-21*fs - 1.01581671153565e-20) + 3.17641482147733e-31) + 4.81274972951113e-30)) + pow(fs,2)*(fs*(-1.19475673226e-18*fs + 1.25414294001131e-16) + 1.8087904407686e-15)) + Drive*pow(fs,2)*(fs*(2.67625508026238e-19*fs - 5.05613478219161e-16) - 7.64033082180657e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(-2.50297237722381e-22*fs + 2.27542943383984e-21) + 4.77520676362908e-16) + 7.23516176307441e-15) + pow(fs,2)*(fs*(fs*(2.50297237722381e-22*fs - 2.27542943383984e-21) - 4.77520676362908e-16) - 7.23516176307441e-15)) + pow(fs,2)*(fs*(-2.67625508026238e-19*fs + 5.05613478219161e-16) + 7.64033082180657e-15));

    b5 = Level*(Body*(Drive*pow(fs,2)*(fs*(-3.98252244086665e-19*fs + 1.25414294001131e-16) - 1.8087904407686e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(2.23479676537841e-22*fs - 3.38605570511882e-21) + 3.17641482147733e-31) - 4.81274972951113e-30) + pow(fs,2)*(fs*(fs*(-2.23479676537841e-22*fs + 3.38605570511882e-21) - 3.17641482147733e-31) + 4.81274972951113e-30)) + pow(fs,2)*(fs*(3.98252244086665e-19*fs - 1.25414294001131e-16) + 1.8087904407686e-15)) + Drive*pow(fs,2)*(fs*(-8.92085026754128e-20*fs + 5.05613478219161e-16) - 7.64033082180657e-15) + Tone*(Drive*pow(fs,2)*(fs*(fs*(5.00594475444762e-23*fs - 7.58476477946615e-22) - 4.77520676362908e-16) + 7.23516176307441e-15) + pow(fs,2)*(fs*(fs*(-5.00594475444762e-23*fs + 7.58476477946615e-22) + 4.77520676362908e-16) - 7.23516176307441e-15)) + pow(fs,2)*(fs*(8.92085026754128e-20*fs - 5.05613478219161e-16) + 7.64033082180657e-15));

    a0 = Body*(Tone*(Tone*fs*(fs*(fs*(fs*(-2.20212655946247e-25*fs - 2.1715963793545e-22) - 6.19440233250284e-21) - 6.87715895801323e-21) + 1.04834817447643e-32) + fs*(fs*(fs*(fs*(2.62544964130344e-25*fs + 2.80645509263828e-22) + 9.57755921861201e-20) + 2.58687234633677e-18) + 2.86548289917719e-18) + 1.19130474372322e-30) + fs*(fs*(fs*(fs*(2.62544964130344e-24*fs + 4.0544103345737e-21) + 1.08757722986638e-18) + 4.26706837092244e-17) + 4.34866026595172e-16) + 4.47731702996255e-16) + Tone*(Tone*fs*(fs*(fs*(fs*(-2.18656867668347e-25*fs - 7.43012556103548e-22) - 5.07702668620608e-19) - 1.42068098536868e-17) - 1.57601559454686e-17) + fs*(fs*(fs*(fs*(2.28139304701584e-25*fs + 6.72568774912911e-22) + 2.89128836504038e-19) - 4.83903085275556e-17) - 1.60414454195004e-15) - 1.79092681198507e-15) + fs*(fs*(fs*(fs*(2.28139304701584e-24*fs + 8.78318666705471e-21) + 7.93180872955293e-18) + 8.46536337187037e-16) + 1.80810237761262e-14) + 1.9800486833307e-14;

    a1 = Body*(Tone*(Tone*fs*(fs*(fs*(fs*(1.10106327973123e-24*fs + 6.51478913806351e-22) + 6.19440233250284e-21) - 6.87715895801323e-21) + 3.1450445234293e-32) + fs*(fs*(fs*(fs*(-1.31272482065172e-24*fs - 8.41936527791485e-22) - 9.57755921861201e-20) + 2.58687234633677e-18) + 8.59644869753156e-18) + 5.9565237186161e-30) + fs*(fs*(fs*(fs*(-1.31272482065172e-23*fs - 1.21632310037211e-20) - 1.08757722986638e-18) + 4.26706837092244e-17) + 1.30459807978552e-15) + 2.23865851498128e-15) + Tone*(Tone*fs*(fs*(fs*(fs*(1.09328433834173e-24*fs + 2.22903766831064e-21) + 5.07702668620608e-19) - 1.42068098536868e-17) - 4.72804678364059e-17) + fs*(fs*(fs*(fs*(-1.14069652350792e-24*fs - 2.01770632473873e-21) - 2.89128836504038e-19) - 4.83903085275556e-17) - 4.81243362585013e-15) - 8.95463405992537e-15) + fs*(fs*(fs*(fs*(-1.14069652350792e-23*fs - 2.63495600011641e-20) - 7.93180872955293e-18) + 8.46536337187037e-16) + 5.42430713283786e-14) + 9.90024341665349e-14;

    a2 = Body*(Tone*(Tone*fs*(fs*(fs*(fs*(-2.20212655946247e-24*fs - 4.343192758709e-22) + 1.23888046650057e-20) + 1.37543179160265e-20) + 2.09669634895287e-32) + fs*(fs*(fs*(fs*(2.62544964130344e-24*fs + 5.61291018527657e-22) - 1.9155118437224e-19) - 5.17374469267354e-18) + 5.73096579835437e-18) + 1.19130474372322e-29) + fs*(fs*(fs*(fs*(2.62544964130344e-23*fs + 8.1088206691474e-21) - 2.17515445973276e-18) - 8.53413674184488e-17) + 8.69732053190344e-16) + 4.47731702996255e-15) + Tone*(Tone*fs*(fs*(fs*(fs*(-2.18656867668347e-24*fs - 1.4860251122071e-21) + 1.01540533724122e-18) + 2.84136197073737e-17) - 3.15203118909373e-17) + fs*(fs*(fs*(fs*(2.28139304701584e-24*fs + 1.34513754982582e-21) - 5.78257673008076e-19) + 9.67806170551113e-17) - 3.20828908390008e-15) - 1.79092681198507e-14) + fs*(fs*(fs*(fs*(2.28139304701584e-23*fs + 1.75663733341094e-20) - 1.58636174591059e-17) - 1.69307267437407e-15) + 3.61620475522524e-14) + 1.9800486833307e-13;

    a3 = Body*(Tone*(Tone*fs*(fs*(fs*(fs*(2.20212655946247e-24*fs - 4.343192758709e-22) - 1.23888046650057e-20) + 1.37543179160265e-20) - 2.09669634895287e-32) + fs*(fs*(fs*(fs*(-2.62544964130344e-24*fs + 5.61291018527657e-22) + 1.9155118437224e-19) - 5.17374469267354e-18) - 5.73096579835437e-18) + 1.19130474372322e-29) + fs*(fs*(fs*(fs*(-2.62544964130344e-23*fs + 8.1088206691474e-21) + 2.17515445973276e-18) - 8.53413674184488e-17) - 8.69732053190344e-16) + 4.47731702996255e-15) + Tone*(Tone*fs*(fs*(fs*(fs*(2.18656867668347e-24*fs - 1.4860251122071e-21) - 1.01540533724122e-18) + 2.84136197073737e-17) + 3.15203118909373e-17) + fs*(fs*(fs*(fs*(-2.28139304701584e-24*fs + 1.34513754982582e-21) + 5.78257673008076e-19) + 9.67806170551113e-17) + 3.20828908390008e-15) - 1.79092681198507e-14) + fs*(fs*(fs*(fs*(-2.28139304701584e-23*fs + 1.75663733341094e-20) + 1.58636174591059e-17) - 1.69307267437407e-15) - 3.61620475522524e-14) + 1.9800486833307e-13;

    a4 = Body*(Tone*(Tone*fs*(fs*(fs*(fs*(-1.10106327973123e-24*fs + 6.51478913806351e-22) - 6.19440233250284e-21) - 6.87715895801323e-21) - 3.1450445234293e-32) + fs*(fs*(fs*(fs*(1.31272482065172e-24*fs - 8.41936527791485e-22) + 9.57755921861201e-20) + 2.58687234633677e-18) - 8.59644869753156e-18) + 5.9565237186161e-30) + fs*(fs*(fs*(fs*(1.31272482065172e-23*fs - 1.21632310037211e-20) + 1.08757722986638e-18) + 4.26706837092244e-17) - 1.30459807978552e-15) + 2.23865851498128e-15) + Tone*(Tone*fs*(fs*(fs*(fs*(-1.09328433834173e-24*fs + 2.22903766831064e-21) - 5.07702668620608e-19) - 1.42068098536868e-17) + 4.72804678364059e-17) + fs*(fs*(fs*(fs*(1.14069652350792e-24*fs - 2.01770632473873e-21) + 2.89128836504038e-19) - 4.83903085275556e-17) + 4.81243362585013e-15) - 8.95463405992537e-15) + fs*(fs*(fs*(fs*(1.14069652350792e-23*fs - 2.63495600011641e-20) + 7.93180872955293e-18) + 8.46536337187037e-16) - 5.42430713283786e-14) + 9.90024341665349e-14;

    a5 = Body*(Tone*(Tone*fs*(fs*(fs*(fs*(2.20212655946247e-25*fs - 2.1715963793545e-22) + 6.19440233250284e-21) - 6.87715895801323e-21) - 1.04834817447643e-32) + fs*(fs*(fs*(fs*(-2.62544964130344e-25*fs + 2.80645509263828e-22) - 9.57755921861201e-20) + 2.58687234633677e-18) - 2.86548289917719e-18) + 1.19130474372322e-30) + fs*(fs*(fs*(fs*(-2.62544964130344e-24*fs + 4.0544103345737e-21) - 1.08757722986638e-18) + 4.26706837092244e-17) - 4.34866026595172e-16) + 4.47731702996255e-16) + Tone*(Tone*fs*(fs*(fs*(fs*(2.18656867668347e-25*fs - 7.43012556103548e-22) + 5.07702668620608e-19) - 1.42068098536868e-17) + 1.57601559454686e-17) + fs*(fs*(fs*(fs*(-2.28139304701584e-25*fs + 6.72568774912911e-22) - 2.89128836504038e-19) - 4.83903085275556e-17) + 1.60414454195004e-15) - 1.79092681198507e-15) + fs*(fs*(fs*(fs*(-2.28139304701584e-24*fs + 8.78318666705471e-21) - 7.93180872955293e-18) + 8.46536337187037e-16) - 1.80810237761262e-14) + 1.9800486833307e-14;
};
