import numpy
from numpy import array, nan, inf

version = '1.6.1'
cuda    = '7.0'
device  = 'Kepler K40c'
cpu     = '2x8 core Sandy Bridge E5-2670'

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/cgeev.txt
# numactl --interleave=all ./testing_cgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeev_RN = array([
	[    10,  nan,    0.0005 ],
	[    20,  nan,    0.0008 ],
	[    30,  nan,    0.0013 ],
	[    40,  nan,    0.0039 ],
	[    50,  nan,    0.0047 ],
	[    60,  nan,    0.0054 ],
	[    70,  nan,    0.0080 ],
	[    80,  nan,    0.0108 ],
	[    90,  nan,    0.0124 ],
	[   100,  nan,    0.0159 ],
	[   200,  nan,    0.0589 ],
	[   300,  nan,    0.0937 ],
	[   400,  nan,    0.1403 ],
	[   500,  nan,    0.1971 ],
	[   600,  nan,    0.3611 ],
	[   700,  nan,    0.4680 ],
	[   800,  nan,    0.5535 ],
	[   900,  nan,    0.6994 ],
	[  1000,  nan,    0.7811 ],
	[  2000,  nan,    2.4442 ],
	[  3000,  nan,    7.2809 ],
	[  4000,  nan,   11.6277 ],
	[  5000,  nan,   17.5651 ],
	[  6000,  nan,   31.0414 ],
	[  7000,  nan,   41.7092 ],
	[  8000,  nan,   53.7020 ],
	[  9000,  nan,   67.8587 ],
	[ 10000,  nan,   81.7743 ],
	[ 12000,  nan,  124.0545 ],
	[ 14000,  nan,  167.2559 ],
	[ 16000,  nan,  230.2912 ],
	[ 18000,  nan,  290.8537 ],
	[ 20000,  nan,  373.4943 ],
])

# numactl --interleave=all ./testing_cgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeev_RV = array([
	[    10,  nan,    0.0019 ],
	[    20,  nan,    0.0025 ],
	[    30,  nan,    0.0027 ],
	[    40,  nan,    0.0052 ],
	[    50,  nan,    0.0078 ],
	[    60,  nan,    0.0070 ],
	[    70,  nan,    0.0097 ],
	[    80,  nan,    0.0121 ],
	[    90,  nan,    0.0143 ],
	[   100,  nan,    0.0233 ],
	[   200,  nan,    0.0717 ],
	[   300,  nan,    0.1684 ],
	[   400,  nan,    0.2235 ],
	[   500,  nan,    0.2950 ],
	[   600,  nan,    0.6602 ],
	[   700,  nan,    0.7326 ],
	[   800,  nan,    0.9360 ],
	[   900,  nan,    1.1744 ],
	[  1000,  nan,    0.9703 ],
	[  2000,  nan,    3.8646 ],
	[  3000,  nan,   11.9488 ],
	[  4000,  nan,   17.3995 ],
	[  5000,  nan,   29.6873 ],
	[  6000,  nan,   47.0757 ],
	[  7000,  nan,   66.3783 ],
	[  8000,  nan,   86.6015 ],
	[  9000,  nan,  111.6952 ],
	[ 10000,  nan,  148.4911 ],
	[ 12000,  nan,  218.9101 ],
	[ 14000,  nan,  318.8500 ],
	[ 16000,  nan,  446.7903 ],
	[ 18000,  nan,  611.1254 ],
	[ 20000,  nan,  799.2029 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/cgeqrf.txt
# numactl --interleave=all ./testing_cgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeqrf = array([
	[    10,     10,  nan,  nan,     0.13,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.80,   0.00,  nan ],
	[    30,     30,  nan,  nan,     2.05,   0.00,  nan ],
	[    40,     40,  nan,  nan,     3.58,   0.00,  nan ],
	[    50,     50,  nan,  nan,     5.09,   0.00,  nan ],
	[    60,     60,  nan,  nan,     6.83,   0.00,  nan ],
	[    70,     70,  nan,  nan,     2.17,   0.00,  nan ],
	[    80,     80,  nan,  nan,     3.26,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.77,   0.00,  nan ],
	[   100,    100,  nan,  nan,     5.51,   0.00,  nan ],
	[   200,    200,  nan,  nan,    17.49,   0.00,  nan ],
	[   300,    300,  nan,  nan,    40.92,   0.00,  nan ],
	[   400,    400,  nan,  nan,    63.73,   0.01,  nan ],
	[   500,    500,  nan,  nan,    93.16,   0.01,  nan ],
	[   600,    600,  nan,  nan,   120.87,   0.01,  nan ],
	[   700,    700,  nan,  nan,   153.14,   0.01,  nan ],
	[   800,    800,  nan,  nan,   183.92,   0.01,  nan ],
	[   900,    900,  nan,  nan,   214.53,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   250.42,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   626.11,   0.07,  nan ],
	[  3000,   3000,  nan,  nan,  1017.00,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,  1393.34,   0.25,  nan ],
	[  5000,   5000,  nan,  nan,  1484.88,   0.45,  nan ],
	[  6000,   6000,  nan,  nan,  1779.15,   0.65,  nan ],
	[  7000,   7000,  nan,  nan,  1943.20,   0.94,  nan ],
	[  8000,   8000,  nan,  nan,  2076.82,   1.32,  nan ],
	[  9000,   9000,  nan,  nan,  2162.67,   1.80,  nan ],
	[ 10000,  10000,  nan,  nan,  2229.67,   2.39,  nan ],
	[ 12000,  12000,  nan,  nan,  2325.79,   3.96,  nan ],
	[ 14000,  14000,  nan,  nan,  2379.66,   6.15,  nan ],
	[ 16000,  16000,  nan,  nan,  2403.02,   9.09,  nan ],
	[ 18000,  18000,  nan,  nan,  2416.62,  12.87,  nan ],
	[ 20000,  20000,  nan,  nan,  2456.26,  17.37,  nan ],
])

# numactl --interleave=all ./testing_cgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.17,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.34,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.63,   0.00,  nan ],
	[    60,     60,  nan,  nan,     1.05,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.20,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.74,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.59,   0.00,  nan ],
	[   100,    100,  nan,  nan,     7.08,   0.00,  nan ],
	[   200,    200,  nan,  nan,    14.62,   0.00,  nan ],
	[   300,    300,  nan,  nan,    32.56,   0.00,  nan ],
	[   400,    400,  nan,  nan,    50.97,   0.01,  nan ],
	[   500,    500,  nan,  nan,    81.01,   0.01,  nan ],
	[   600,    600,  nan,  nan,   109.60,   0.01,  nan ],
	[   700,    700,  nan,  nan,   137.69,   0.01,  nan ],
	[   800,    800,  nan,  nan,   169.58,   0.02,  nan ],
	[   900,    900,  nan,  nan,   200.46,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   231.75,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   607.28,   0.07,  nan ],
	[  3000,   3000,  nan,  nan,  1004.62,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,  1374.30,   0.25,  nan ],
	[  5000,   5000,  nan,  nan,  1466.80,   0.45,  nan ],
	[  6000,   6000,  nan,  nan,  1722.78,   0.67,  nan ],
	[  7000,   7000,  nan,  nan,  1939.11,   0.94,  nan ],
	[  8000,   8000,  nan,  nan,  2077.29,   1.31,  nan ],
	[  9000,   9000,  nan,  nan,  2153.94,   1.81,  nan ],
	[ 10000,  10000,  nan,  nan,  2107.55,   2.53,  nan ],
	[ 12000,  12000,  nan,  nan,  2238.10,   4.12,  nan ],
	[ 14000,  14000,  nan,  nan,  2354.83,   6.22,  nan ],
	[ 16000,  16000,  nan,  nan,  2369.16,   9.22,  nan ],
	[ 18000,  18000,  nan,  nan,  2396.27,  12.98,  nan ],
	[ 20000,  20000,  nan,  nan,  2451.14,  17.41,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/cgesvd.txt
# numactl --interleave=all ./testing_cgesvd -UN -VN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
cgesvd_UN = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.02,  nan ],
	[ nan,     300,     300,  nan,    0.03,  nan ],
	[ nan,     400,     400,  nan,    0.05,  nan ],
	[ nan,     500,     500,  nan,    0.08,  nan ],
	[ nan,     600,     600,  nan,    0.11,  nan ],
	[ nan,     700,     700,  nan,    0.15,  nan ],
	[ nan,     800,     800,  nan,    0.22,  nan ],
	[ nan,     900,     900,  nan,    0.24,  nan ],
	[ nan,    1000,    1000,  nan,    0.29,  nan ],
	[ nan,    2000,    2000,  nan,    1.14,  nan ],
	[ nan,    3000,    3000,  nan,    2.95,  nan ],
	[ nan,    4000,    4000,  nan,    5.86,  nan ],
	[ nan,    5000,    5000,  nan,   10.14,  nan ],
	[ nan,    6000,    6000,  nan,   16.08,  nan ],
	[ nan,    7000,    7000,  nan,   23.93,  nan ],
	[ nan,    8000,    8000,  nan,   34.23,  nan ],
	[ nan,    9000,    9000,  nan,   46.92,  nan ],
	[ nan,   10000,   10000,  nan,   62.76,  nan ],
	[ nan,   12000,   12000,  nan,  106.69,  nan ],
	[ nan,   14000,   14000,  nan,  163.72,  nan ],
	[ nan,   16000,   16000,  nan,  249.04,  nan ],
	[ nan,   18000,   18000,  nan,  350.21,  nan ],
	[ nan,   20000,   20000,  nan,  491.80,  nan ],
	[ nan,     300,     100,  nan,    0.00,  nan ],
	[ nan,     600,     200,  nan,    0.02,  nan ],
	[ nan,     900,     300,  nan,    0.04,  nan ],
	[ nan,    1200,     400,  nan,    0.07,  nan ],
	[ nan,    1500,     500,  nan,    0.10,  nan ],
	[ nan,    1800,     600,  nan,    0.14,  nan ],
	[ nan,    2100,     700,  nan,    0.19,  nan ],
	[ nan,    2400,     800,  nan,    0.25,  nan ],
	[ nan,    2700,     900,  nan,    0.32,  nan ],
	[ nan,    3000,    1000,  nan,    0.43,  nan ],
	[ nan,    6000,    2000,  nan,    2.01,  nan ],
	[ nan,    9000,    3000,  nan,    4.67,  nan ],
	[ nan,   12000,    4000,  nan,    9.60,  nan ],
	[ nan,   15000,    5000,  nan,   17.07,  nan ],
	[ nan,   18000,    6000,  nan,   27.45,  nan ],
	[ nan,   21000,    7000,  nan,   41.71,  nan ],
	[ nan,   24000,    8000,  nan,   60.60,  nan ],
	[ nan,   27000,    9000,  nan,   83.55,  nan ],
	[ nan,     100,     300,  nan,    0.00,  nan ],
	[ nan,     200,     600,  nan,    0.02,  nan ],
	[ nan,     300,     900,  nan,    0.04,  nan ],
	[ nan,     400,    1200,  nan,    0.07,  nan ],
	[ nan,     500,    1500,  nan,    0.11,  nan ],
	[ nan,     600,    1800,  nan,    0.15,  nan ],
	[ nan,     700,    2100,  nan,    0.21,  nan ],
	[ nan,     800,    2400,  nan,    0.27,  nan ],
	[ nan,     900,    2700,  nan,    0.33,  nan ],
	[ nan,    1000,    3000,  nan,    0.41,  nan ],
	[ nan,    2000,    6000,  nan,    1.76,  nan ],
	[ nan,    3000,    9000,  nan,    4.75,  nan ],
	[ nan,    4000,   12000,  nan,    9.77,  nan ],
	[ nan,    5000,   15000,  nan,   17.43,  nan ],
	[ nan,    6000,   18000,  nan,   28.71,  nan ],
	[ nan,    7000,   21000,  nan,   43.55,  nan ],
	[ nan,    8000,   24000,  nan,   61.50,  nan ],
	[ nan,    9000,   27000,  nan,   96.95,  nan ],
	[ nan,   10000,     100,  nan,    0.02,  nan ],
	[ nan,   20000,     200,  nan,    0.08,  nan ],
	[ nan,   30000,     300,  nan,    0.19,  nan ],
	[ nan,   40000,     400,  nan,    0.51,  nan ],
	[ nan,   50000,     500,  nan,    0.79,  nan ],
	[ nan,   60000,     600,  nan,    1.17,  nan ],
	[ nan,   70000,     700,  nan,    1.63,  nan ],
	[ nan,   80000,     800,  nan,    2.23,  nan ],
	[ nan,   90000,     900,  nan,    3.37,  nan ],
	[ nan,  100000,    1000,  nan,    4.22,  nan ],
	[ nan,  200000,    2000,  nan,   24.45,  nan ],
	[ nan,     100,   10000,  nan,    0.02,  nan ],
	[ nan,     200,   20000,  nan,    0.09,  nan ],
	[ nan,     300,   30000,  nan,    0.24,  nan ],
	[ nan,     400,   40000,  nan,    0.46,  nan ],
	[ nan,     500,   50000,  nan,    0.80,  nan ],
	[ nan,     600,   60000,  nan,    1.29,  nan ],
	[ nan,     700,   70000,  nan,    1.94,  nan ],
	[ nan,     800,   80000,  nan,    2.90,  nan ],
	[ nan,     900,   90000,  nan,    3.60,  nan ],
	[ nan,    1000,  100000,  nan,    4.87,  nan ],
	[ nan,    2000,  200000,  nan,   29.54,  nan ],
])

# numactl --interleave=all ./testing_cgesvd -US -VS -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
cgesvd_US = array([
	[ nan,      10,      10,  nan,     0.00,  nan ],
	[ nan,      20,      20,  nan,     0.00,  nan ],
	[ nan,      30,      30,  nan,     0.00,  nan ],
	[ nan,      40,      40,  nan,     0.00,  nan ],
	[ nan,      50,      50,  nan,     0.01,  nan ],
	[ nan,      60,      60,  nan,     0.01,  nan ],
	[ nan,      70,      70,  nan,     0.01,  nan ],
	[ nan,      80,      80,  nan,     0.01,  nan ],
	[ nan,      90,      90,  nan,     0.02,  nan ],
	[ nan,     100,     100,  nan,     0.02,  nan ],
	[ nan,     200,     200,  nan,     0.02,  nan ],
	[ nan,     300,     300,  nan,     0.05,  nan ],
	[ nan,     400,     400,  nan,     0.09,  nan ],
	[ nan,     500,     500,  nan,     0.15,  nan ],
	[ nan,     600,     600,  nan,     0.21,  nan ],
	[ nan,     700,     700,  nan,     0.29,  nan ],
	[ nan,     800,     800,  nan,     0.38,  nan ],
	[ nan,     900,     900,  nan,     0.49,  nan ],
	[ nan,    1000,    1000,  nan,     0.62,  nan ],
	[ nan,    2000,    2000,  nan,     3.01,  nan ],
	[ nan,    3000,    3000,  nan,     9.41,  nan ],
	[ nan,    4000,    4000,  nan,    15.97,  nan ],
	[ nan,    5000,    5000,  nan,    32.61,  nan ],
	[ nan,    6000,    6000,  nan,    53.98,  nan ],
	[ nan,    7000,    7000,  nan,    86.43,  nan ],
	[ nan,    8000,    8000,  nan,   117.65,  nan ],
	[ nan,    9000,    9000,  nan,   182.15,  nan ],
	[ nan,   10000,   10000,  nan,   254.41,  nan ],
	[ nan,   12000,   12000,  nan,   421.33,  nan ],
	[ nan,   14000,   14000,  nan,   737.22,  nan ],
	[ nan,   16000,   16000,  nan,  1059.89,  nan ],
	[ nan,   18000,   18000,  nan,  1580.86,  nan ],
	[ nan,   20000,   20000,  nan,  2092.23,  nan ],
	[ nan,     300,     100,  nan,     0.03,  nan ],
	[ nan,     600,     200,  nan,     0.03,  nan ],
	[ nan,     900,     300,  nan,     0.07,  nan ],
	[ nan,    1200,     400,  nan,     0.14,  nan ],
	[ nan,    1500,     500,  nan,     0.22,  nan ],
	[ nan,    1800,     600,  nan,     0.35,  nan ],
	[ nan,    2100,     700,  nan,     0.48,  nan ],
	[ nan,    2400,     800,  nan,     0.64,  nan ],
	[ nan,    2700,     900,  nan,     0.85,  nan ],
	[ nan,    3000,    1000,  nan,     0.98,  nan ],
	[ nan,    6000,    2000,  nan,     4.89,  nan ],
	[ nan,    9000,    3000,  nan,    14.56,  nan ],
	[ nan,   12000,    4000,  nan,    28.84,  nan ],
	[ nan,   15000,    5000,  nan,    55.04,  nan ],
	[ nan,   18000,    6000,  nan,    91.95,  nan ],
	[ nan,   21000,    7000,  nan,   143.34,  nan ],
	[ nan,   24000,    8000,  nan,   209.27,  nan ],
	[ nan,   27000,    9000,  nan,   292.32,  nan ],
	[ nan,     100,     300,  nan,     0.07,  nan ],
	[ nan,     200,     600,  nan,     0.07,  nan ],
	[ nan,     300,     900,  nan,     0.20,  nan ],
	[ nan,     400,    1200,  nan,     0.43,  nan ],
	[ nan,     500,    1500,  nan,     0.79,  nan ],
	[ nan,     600,    1800,  nan,     1.28,  nan ],
	[ nan,     700,    2100,  nan,     1.97,  nan ],
	[ nan,     800,    2400,  nan,     2.79,  nan ],
	[ nan,     900,    2700,  nan,     4.02,  nan ],
	[ nan,    1000,    3000,  nan,     5.70,  nan ],
	[ nan,    2000,    6000,  nan,    45.69,  nan ],
	[ nan,    3000,    9000,  nan,   150.04,  nan ],
	[ nan,    4000,   12000,  nan,   347.69,  nan ],
	[ nan,    5000,   15000,  nan,   661.10,  nan ],
	[ nan,    6000,   18000,  nan,  1141.46,  nan ],
	[ nan,    7000,   21000,  nan,  1767.70,  nan ],
	[ nan,    8000,   24000,  nan,  2441.61,  nan ],
	[ nan,    9000,   27000,  nan,  3646.59,  nan ],
	[ nan,   10000,     100,  nan,     0.07,  nan ],
	[ nan,   20000,     200,  nan,     0.20,  nan ],
	[ nan,   30000,     300,  nan,     0.54,  nan ],
	[ nan,   40000,     400,  nan,     1.18,  nan ],
	[ nan,   50000,     500,  nan,     2.12,  nan ],
	[ nan,   60000,     600,  nan,     3.14,  nan ],
	[ nan,   70000,     700,  nan,     4.66,  nan ],
	[ nan,   80000,     800,  nan,     6.44,  nan ],
	[ nan,   90000,     900,  nan,     9.64,  nan ],
	[ nan,  100000,    1000,  nan,    12.90,  nan ],
	[ nan,  200000,    2000,  nan,    91.79,  nan ],
	[ nan,     100,   10000,  nan,     0.25,  nan ],
	[ nan,     200,   20000,  nan,     1.94,  nan ],
	[ nan,     300,   30000,  nan,     6.23,  nan ],
	[ nan,     400,   40000,  nan,    12.90,  nan ],
	[ nan,     500,   50000,  nan,    25.83,  nan ],
	[ nan,     600,   60000,  nan,    44.95,  nan ],
	[ nan,     700,   70000,  nan,    70.03,  nan ],
	[ nan,     800,   80000,  nan,   103.48,  nan ],
	[ nan,     900,   90000,  nan,   137.84,  nan ],
	[ nan,    1000,  100000,  nan,   196.71,  nan ],
	[ nan,    2000,  200000,  nan,  1479.90,  nan ],
])

# numactl --interleave=all ./testing_cgesdd -UN -VN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
cgesdd_UN = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.02,  nan ],
	[ nan,     300,     300,  nan,    0.03,  nan ],
	[ nan,     400,     400,  nan,    0.05,  nan ],
	[ nan,     500,     500,  nan,    0.08,  nan ],
	[ nan,     600,     600,  nan,    0.11,  nan ],
	[ nan,     700,     700,  nan,    0.15,  nan ],
	[ nan,     800,     800,  nan,    0.19,  nan ],
	[ nan,     900,     900,  nan,    0.24,  nan ],
	[ nan,    1000,    1000,  nan,    0.29,  nan ],
	[ nan,    2000,    2000,  nan,    1.15,  nan ],
	[ nan,    3000,    3000,  nan,    2.95,  nan ],
	[ nan,    4000,    4000,  nan,    5.87,  nan ],
	[ nan,    5000,    5000,  nan,   10.15,  nan ],
	[ nan,    6000,    6000,  nan,   16.09,  nan ],
	[ nan,    7000,    7000,  nan,   23.94,  nan ],
	[ nan,    8000,    8000,  nan,   34.26,  nan ],
	[ nan,    9000,    9000,  nan,   46.95,  nan ],
	[ nan,   10000,   10000,  nan,   62.80,  nan ],
	[ nan,   12000,   12000,  nan,  106.78,  nan ],
	[ nan,   14000,   14000,  nan,  163.81,  nan ],
	[ nan,   16000,   16000,  nan,  249.17,  nan ],
	[ nan,   18000,   18000,  nan,  350.33,  nan ],
	[ nan,   20000,   20000,  nan,  492.09,  nan ],
	[ nan,     300,     100,  nan,    0.00,  nan ],
	[ nan,     600,     200,  nan,    0.02,  nan ],
	[ nan,     900,     300,  nan,    0.04,  nan ],
	[ nan,    1200,     400,  nan,    0.07,  nan ],
	[ nan,    1500,     500,  nan,    0.10,  nan ],
	[ nan,    1800,     600,  nan,    0.14,  nan ],
	[ nan,    2100,     700,  nan,    0.19,  nan ],
	[ nan,    2400,     800,  nan,    0.25,  nan ],
	[ nan,    2700,     900,  nan,    0.32,  nan ],
	[ nan,    3000,    1000,  nan,    0.39,  nan ],
	[ nan,    6000,    2000,  nan,    1.74,  nan ],
	[ nan,    9000,    3000,  nan,    4.68,  nan ],
	[ nan,   12000,    4000,  nan,    9.60,  nan ],
	[ nan,   15000,    5000,  nan,   17.05,  nan ],
	[ nan,   18000,    6000,  nan,   27.55,  nan ],
	[ nan,   21000,    7000,  nan,   41.62,  nan ],
	[ nan,   24000,    8000,  nan,   60.31,  nan ],
	[ nan,   27000,    9000,  nan,   83.47,  nan ],
	[ nan,     100,     300,  nan,    0.00,  nan ],
	[ nan,     200,     600,  nan,    0.02,  nan ],
	[ nan,     300,     900,  nan,    0.04,  nan ],
	[ nan,     400,    1200,  nan,    0.07,  nan ],
	[ nan,     500,    1500,  nan,    0.11,  nan ],
	[ nan,     600,    1800,  nan,    0.15,  nan ],
	[ nan,     700,    2100,  nan,    0.21,  nan ],
	[ nan,     800,    2400,  nan,    0.26,  nan ],
	[ nan,     900,    2700,  nan,    0.33,  nan ],
	[ nan,    1000,    3000,  nan,    0.41,  nan ],
	[ nan,    2000,    6000,  nan,    1.77,  nan ],
	[ nan,    3000,    9000,  nan,    4.75,  nan ],
	[ nan,    4000,   12000,  nan,    9.78,  nan ],
	[ nan,    5000,   15000,  nan,   17.40,  nan ],
	[ nan,    6000,   18000,  nan,   28.22,  nan ],
	[ nan,    7000,   21000,  nan,   42.61,  nan ],
	[ nan,    8000,   24000,  nan,   61.51,  nan ],
	[ nan,    9000,   27000,  nan,   85.49,  nan ],
	[ nan,   10000,     100,  nan,    0.02,  nan ],
	[ nan,   20000,     200,  nan,    0.08,  nan ],
	[ nan,   30000,     300,  nan,    0.19,  nan ],
	[ nan,   40000,     400,  nan,    0.51,  nan ],
	[ nan,   50000,     500,  nan,    0.79,  nan ],
	[ nan,   60000,     600,  nan,    1.17,  nan ],
	[ nan,   70000,     700,  nan,    1.62,  nan ],
	[ nan,   80000,     800,  nan,    2.24,  nan ],
	[ nan,   90000,     900,  nan,    3.36,  nan ],
	[ nan,  100000,    1000,  nan,    4.18,  nan ],
	[ nan,  200000,    2000,  nan,   24.15,  nan ],
	[ nan,     100,   10000,  nan,    0.02,  nan ],
	[ nan,     200,   20000,  nan,    0.09,  nan ],
	[ nan,     300,   30000,  nan,    0.23,  nan ],
	[ nan,     400,   40000,  nan,    0.45,  nan ],
	[ nan,     500,   50000,  nan,    0.78,  nan ],
	[ nan,     600,   60000,  nan,    1.28,  nan ],
	[ nan,     700,   70000,  nan,    1.97,  nan ],
	[ nan,     800,   80000,  nan,    2.87,  nan ],
	[ nan,     900,   90000,  nan,    3.56,  nan ],
	[ nan,    1000,  100000,  nan,    4.58,  nan ],
	[ nan,    2000,  200000,  nan,   29.04,  nan ],
])

# numactl --interleave=all ./testing_cgesdd -US -VS -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
cgesdd_US = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.02,  nan ],
	[ nan,     300,     300,  nan,    0.05,  nan ],
	[ nan,     400,     400,  nan,    0.08,  nan ],
	[ nan,     500,     500,  nan,    0.12,  nan ],
	[ nan,     600,     600,  nan,    0.16,  nan ],
	[ nan,     700,     700,  nan,    0.21,  nan ],
	[ nan,     800,     800,  nan,    0.27,  nan ],
	[ nan,     900,     900,  nan,    0.34,  nan ],
	[ nan,    1000,    1000,  nan,    0.42,  nan ],
	[ nan,    2000,    2000,  nan,    1.72,  nan ],
	[ nan,    3000,    3000,  nan,    4.21,  nan ],
	[ nan,    4000,    4000,  nan,    8.28,  nan ],
	[ nan,    5000,    5000,  nan,   14.75,  nan ],
	[ nan,    6000,    6000,  nan,   21.63,  nan ],
	[ nan,    7000,    7000,  nan,   31.80,  nan ],
	[ nan,    8000,    8000,  nan,   44.88,  nan ],
	[ nan,    9000,    9000,  nan,   60.96,  nan ],
	[ nan,   10000,   10000,  nan,   80.32,  nan ],
	[ nan,   12000,   12000,  nan,  133.62,  nan ],
	[ nan,   14000,   14000,  nan,  203.80,  nan ],
	[ nan,   16000,   16000,  nan,  301.93,  nan ],
	[ nan,   18000,   18000,  nan,  418.26,  nan ],
	[ nan,   20000,   20000,  nan,  577.48,  nan ],
	[ nan,     300,     100,  nan,    0.01,  nan ],
	[ nan,     600,     200,  nan,    0.03,  nan ],
	[ nan,     900,     300,  nan,    0.06,  nan ],
	[ nan,    1200,     400,  nan,    0.10,  nan ],
	[ nan,    1500,     500,  nan,    0.16,  nan ],
	[ nan,    1800,     600,  nan,    0.24,  nan ],
	[ nan,    2100,     700,  nan,    0.34,  nan ],
	[ nan,    2400,     800,  nan,    0.45,  nan ],
	[ nan,    2700,     900,  nan,    0.60,  nan ],
	[ nan,    3000,    1000,  nan,    0.75,  nan ],
	[ nan,    6000,    2000,  nan,    3.62,  nan ],
	[ nan,    9000,    3000,  nan,    8.22,  nan ],
	[ nan,   12000,    4000,  nan,   17.26,  nan ],
	[ nan,   15000,    5000,  nan,   32.23,  nan ],
	[ nan,   18000,    6000,  nan,   50.46,  nan ],
	[ nan,   21000,    7000,  nan,   76.61,  nan ],
	[ nan,   24000,    8000,  nan,  110.93,  nan ],
	[ nan,   27000,    9000,  nan,  153.92,  nan ],
	[ nan,     100,     300,  nan,    0.01,  nan ],
	[ nan,     200,     600,  nan,    0.03,  nan ],
	[ nan,     300,     900,  nan,    0.06,  nan ],
	[ nan,     400,    1200,  nan,    0.11,  nan ],
	[ nan,     500,    1500,  nan,    0.16,  nan ],
	[ nan,     600,    1800,  nan,    0.23,  nan ],
	[ nan,     700,    2100,  nan,    0.32,  nan ],
	[ nan,     800,    2400,  nan,    0.41,  nan ],
	[ nan,     900,    2700,  nan,    0.52,  nan ],
	[ nan,    1000,    3000,  nan,    0.65,  nan ],
	[ nan,    2000,    6000,  nan,    3.06,  nan ],
	[ nan,    3000,    9000,  nan,    8.40,  nan ],
	[ nan,    4000,   12000,  nan,   17.64,  nan ],
	[ nan,    5000,   15000,  nan,   31.56,  nan ],
	[ nan,    6000,   18000,  nan,   51.43,  nan ],
	[ nan,    7000,   21000,  nan,   80.42,  nan ],
	[ nan,    8000,   24000,  nan,  116.60,  nan ],
	[ nan,    9000,   27000,  nan,  159.90,  nan ],
	[ nan,   10000,     100,  nan,    0.05,  nan ],
	[ nan,   20000,     200,  nan,    0.18,  nan ],
	[ nan,   30000,     300,  nan,    0.52,  nan ],
	[ nan,   40000,     400,  nan,    1.30,  nan ],
	[ nan,   50000,     500,  nan,    1.76,  nan ],
	[ nan,   60000,     600,  nan,    2.13,  nan ],
	[ nan,   70000,     700,  nan,    3.08,  nan ],
	[ nan,   80000,     800,  nan,    4.29,  nan ],
	[ nan,   90000,     900,  nan,    6.18,  nan ],
	[ nan,  100000,    1000,  nan,    9.25,  nan ],
	[ nan,  200000,    2000,  nan,   49.88,  nan ],
	[ nan,     100,   10000,  nan,    0.04,  nan ],
	[ nan,     200,   20000,  nan,    0.19,  nan ],
	[ nan,     300,   30000,  nan,    0.48,  nan ],
	[ nan,     400,   40000,  nan,    0.94,  nan ],
	[ nan,     500,   50000,  nan,    1.62,  nan ],
	[ nan,     600,   60000,  nan,    2.68,  nan ],
	[ nan,     700,   70000,  nan,    4.05,  nan ],
	[ nan,     800,   80000,  nan,    6.02,  nan ],
	[ nan,     900,   90000,  nan,    7.48,  nan ],
	[ nan,    1000,  100000,  nan,    9.54,  nan ],
	[ nan,    2000,  200000,  nan,   58.30,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/cgetrf.txt
# numactl --interleave=all ./testing_cgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgetrf = array([
	[    10,     10,  nan,  nan,     0.29,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.77,  0.00,  nan ],
	[    30,     30,  nan,  nan,     1.88,  0.00,  nan ],
	[    40,     40,  nan,  nan,     3.53,  0.00,  nan ],
	[    50,     50,  nan,  nan,     4.87,  0.00,  nan ],
	[    60,     60,  nan,  nan,     5.66,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.18,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.77,  0.00,  nan ],
	[    90,     90,  nan,  nan,     2.35,  0.00,  nan ],
	[   100,    100,  nan,  nan,     3.09,  0.00,  nan ],
	[   200,    200,  nan,  nan,    12.78,  0.00,  nan ],
	[   300,    300,  nan,  nan,    28.80,  0.00,  nan ],
	[   400,    400,  nan,  nan,    46.76,  0.00,  nan ],
	[   500,    500,  nan,  nan,    68.58,  0.00,  nan ],
	[   600,    600,  nan,  nan,    90.26,  0.01,  nan ],
	[   700,    700,  nan,  nan,   115.63,  0.01,  nan ],
	[   800,    800,  nan,  nan,   142.59,  0.01,  nan ],
	[   900,    900,  nan,  nan,   168.11,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   195.86,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   498.64,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   846.24,  0.09,  nan ],
	[  4000,   4000,  nan,  nan,  1107.91,  0.15,  nan ],
	[  5000,   5000,  nan,  nan,  1258.45,  0.26,  nan ],
	[  6000,   6000,  nan,  nan,  1537.05,  0.37,  nan ],
	[  7000,   7000,  nan,  nan,  1707.15,  0.54,  nan ],
	[  8000,   8000,  nan,  nan,  1860.49,  0.73,  nan ],
	[  9000,   9000,  nan,  nan,  1918.42,  1.01,  nan ],
	[ 10000,  10000,  nan,  nan,  2029.80,  1.31,  nan ],
	[ 12000,  12000,  nan,  nan,  2200.71,  2.09,  nan ],
	[ 14000,  14000,  nan,  nan,  2323.94,  3.15,  nan ],
	[ 16000,  16000,  nan,  nan,  2422.94,  4.51,  nan ],
	[ 18000,  18000,  nan,  nan,  2476.52,  6.28,  nan ],
	[ 20000,  20000,  nan,  nan,  2520.95,  8.46,  nan ],
])

# numactl --interleave=all ./testing_cgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.07,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.39,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.99,  0.00,  nan ],
	[    40,     40,  nan,  nan,     2.12,  0.00,  nan ],
	[    50,     50,  nan,  nan,     2.81,  0.00,  nan ],
	[    60,     60,  nan,  nan,     3.82,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.73,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.93,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.23,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.95,  0.00,  nan ],
	[   200,    200,  nan,  nan,     8.98,  0.00,  nan ],
	[   300,    300,  nan,  nan,    23.12,  0.00,  nan ],
	[   400,    400,  nan,  nan,    41.40,  0.00,  nan ],
	[   500,    500,  nan,  nan,    67.82,  0.00,  nan ],
	[   600,    600,  nan,  nan,    90.69,  0.01,  nan ],
	[   700,    700,  nan,  nan,   116.90,  0.01,  nan ],
	[   800,    800,  nan,  nan,   149.23,  0.01,  nan ],
	[   900,    900,  nan,  nan,   181.15,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   229.07,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   590.46,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,  1028.34,  0.07,  nan ],
	[  4000,   4000,  nan,  nan,  1328.21,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,  1458.62,  0.23,  nan ],
	[  6000,   6000,  nan,  nan,  1688.65,  0.34,  nan ],
	[  7000,   7000,  nan,  nan,  1900.68,  0.48,  nan ],
	[  8000,   8000,  nan,  nan,  2107.74,  0.65,  nan ],
	[  9000,   9000,  nan,  nan,  2129.66,  0.91,  nan ],
	[ 10000,  10000,  nan,  nan,  2228.35,  1.20,  nan ],
	[ 12000,  12000,  nan,  nan,  2443.86,  1.89,  nan ],
	[ 14000,  14000,  nan,  nan,  2583.52,  2.83,  nan ],
	[ 16000,  16000,  nan,  nan,  2643.80,  4.13,  nan ],
	[ 18000,  18000,  nan,  nan,  2683.00,  5.80,  nan ],
	[ 20000,  20000,  nan,  nan,  2724.53,  7.83,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/cheevd.txt
# numactl --interleave=all ./testing_cheevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_JN = array([
	[    10,  nan,    0.0000 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0001 ],
	[    50,  nan,    0.0002 ],
	[    60,  nan,    0.0003 ],
	[    70,  nan,    0.0005 ],
	[    80,  nan,    0.0007 ],
	[    90,  nan,    0.0009 ],
	[   100,  nan,    0.0011 ],
	[   200,  nan,    0.0108 ],
	[   300,  nan,    0.0203 ],
	[   400,  nan,    0.0351 ],
	[   500,  nan,    0.0492 ],
	[   600,  nan,    0.0680 ],
	[   700,  nan,    0.0878 ],
	[   800,  nan,    0.1119 ],
	[   900,  nan,    0.1375 ],
	[  1000,  nan,    0.1640 ],
	[  2000,  nan,    0.5694 ],
	[  3000,  nan,    1.2952 ],
	[  4000,  nan,    2.3348 ],
	[  5000,  nan,    3.7632 ],
	[  6000,  nan,    5.6444 ],
	[  7000,  nan,    8.1125 ],
	[  8000,  nan,   11.0722 ],
	[  9000,  nan,   14.8193 ],
	[ 10000,  nan,   19.3837 ],
	[ 12000,  nan,   31.0675 ],
	[ 14000,  nan,   45.9363 ],
	[ 16000,  nan,   65.4731 ],
	[ 18000,  nan,   90.3068 ],
	[ 20000,  nan,  119.1788 ],
])

# numactl --interleave=all ./testing_cheevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_JV = array([
	[    10,  nan,    0.0002 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0003 ],
	[    40,  nan,    0.0005 ],
	[    50,  nan,    0.0006 ],
	[    60,  nan,    0.0008 ],
	[    70,  nan,    0.0011 ],
	[    80,  nan,    0.0014 ],
	[    90,  nan,    0.0017 ],
	[   100,  nan,    0.0021 ],
	[   200,  nan,    0.0176 ],
	[   300,  nan,    0.0302 ],
	[   400,  nan,    0.0499 ],
	[   500,  nan,    0.0678 ],
	[   600,  nan,    0.0891 ],
	[   700,  nan,    0.1137 ],
	[   800,  nan,    0.1438 ],
	[   900,  nan,    0.1778 ],
	[  1000,  nan,    0.2086 ],
	[  2000,  nan,    0.7005 ],
	[  3000,  nan,    1.4685 ],
	[  4000,  nan,    2.6798 ],
	[  5000,  nan,    4.3095 ],
	[  6000,  nan,    6.5492 ],
	[  7000,  nan,    9.4248 ],
	[  8000,  nan,   12.9559 ],
	[  9000,  nan,   17.4774 ],
	[ 10000,  nan,   22.7936 ],
	[ 12000,  nan,   36.9305 ],
	[ 14000,  nan,   54.6267 ],
	[ 16000,  nan,   78.2375 ],
	[ 18000,  nan,  109.1700 ],
	[ 20000,  nan,  144.4371 ],
])

# numactl --interleave=all ./testing_cheevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_gpu_JN = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0003 ],
	[    60,  nan,    0.0004 ],
	[    70,  nan,    0.0007 ],
	[    80,  nan,    0.0009 ],
	[    90,  nan,    0.0012 ],
	[   100,  nan,    0.0014 ],
	[   200,  nan,    0.0124 ],
	[   300,  nan,    0.0235 ],
	[   400,  nan,    0.0395 ],
	[   500,  nan,    0.0542 ],
	[   600,  nan,    0.0755 ],
	[   700,  nan,    0.0957 ],
	[   800,  nan,    0.1225 ],
	[   900,  nan,    0.1491 ],
	[  1000,  nan,    0.1775 ],
	[  2000,  nan,    0.6002 ],
	[  3000,  nan,    1.3481 ],
	[  4000,  nan,    2.3962 ],
	[  5000,  nan,    3.8576 ],
	[  6000,  nan,    5.7451 ],
	[  7000,  nan,    8.2436 ],
	[  8000,  nan,   11.2046 ],
	[  9000,  nan,   14.9632 ],
	[ 10000,  nan,   19.5209 ],
	[ 12000,  nan,   31.2815 ],
	[ 14000,  nan,   46.2188 ],
	[ 16000,  nan,   65.6012 ],
	[ 18000,  nan,   90.6014 ],
	[ 20000,  nan,  119.1913 ],
])

# numactl --interleave=all ./testing_cheevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_gpu_JV = array([
	[    10,  nan,    0.0002 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0004 ],
	[    40,  nan,    0.0005 ],
	[    50,  nan,    0.0006 ],
	[    60,  nan,    0.0009 ],
	[    70,  nan,    0.0012 ],
	[    80,  nan,    0.0014 ],
	[    90,  nan,    0.0018 ],
	[   100,  nan,    0.0021 ],
	[   200,  nan,    0.0170 ],
	[   300,  nan,    0.0293 ],
	[   400,  nan,    0.0490 ],
	[   500,  nan,    0.0665 ],
	[   600,  nan,    0.0878 ],
	[   700,  nan,    0.1103 ],
	[   800,  nan,    0.1409 ],
	[   900,  nan,    0.1734 ],
	[  1000,  nan,    0.2023 ],
	[  2000,  nan,    0.6659 ],
	[  3000,  nan,    1.5009 ],
	[  4000,  nan,    2.7090 ],
	[  5000,  nan,    4.4119 ],
	[  6000,  nan,    6.5324 ],
	[  7000,  nan,    9.3413 ],
	[  8000,  nan,   13.0797 ],
	[  9000,  nan,   17.3712 ],
	[ 10000,  nan,   22.8849 ],
	[ 12000,  nan,   36.9572 ],
	[ 14000,  nan,   55.3174 ],
	[ 16000,  nan,   79.6378 ],
	[ 18000,  nan,  110.6351 ],
	[ 20000,  nan,  148.1050 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/cheevd_2stage.txt
# numactl --interleave=all ./testing_cheevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevdx_2stage_JN = array([
	[    10,      0,   0.0002 ],
	[    20,      0,   0.0000 ],
	[    30,      0,   0.0000 ],
	[    40,      0,   0.0000 ],
	[    50,      0,   0.0000 ],
	[    60,      0,   0.0000 ],
	[    70,      0,   0.0000 ],
	[    80,      0,   0.0000 ],
	[    90,      0,   0.0000 ],
	[   100,      0,   0.0000 ],
	[   200,    200,   0.0055 ],
	[   300,    300,   0.0266 ],
	[   400,    400,   0.0508 ],
	[   500,    500,   0.0796 ],
	[   600,    600,   0.1112 ],
	[   700,    700,   0.1462 ],
	[   800,    800,   0.2094 ],
	[   900,    900,   0.3014 ],
	[  1000,   1000,   0.2985 ],
	[  2000,   2000,   0.6633 ],
	[  3000,   3000,   0.9995 ],
	[  4000,   4000,   1.4907 ],
	[  5000,   5000,   2.1478 ],
	[  6000,   6000,   2.7970 ],
	[  7000,   7000,   3.8473 ],
	[  8000,   8000,   4.6921 ],
	[  9000,   9000,   5.8242 ],
	[ 10000,  10000,   7.1964 ],
	[ 12000,  12000,  10.4989 ],
	[ 14000,  14000,  14.6472 ],
	[ 16000,  16000,  19.7530 ],
	[ 18000,  18000,  26.0466 ],
	[ 20000,  20000,  33.7255 ],
])

# numactl --interleave=all ./testing_cheevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevdx_2stage_JV = array([
	[    10,     10,    0.0002 ],
	[    20,     20,    0.0002 ],
	[    30,     30,    0.0003 ],
	[    40,     40,    0.0004 ],
	[    50,     50,    0.0006 ],
	[    60,     60,    0.0008 ],
	[    70,     70,    0.0011 ],
	[    80,     80,    0.0014 ],
	[    90,     90,    0.0016 ],
	[   100,    100,    0.0020 ],
	[   200,    200,    0.0070 ],
	[   300,    300,    0.0463 ],
	[   400,    400,    0.0736 ],
	[   500,    500,    0.1048 ],
	[   600,    600,    0.1428 ],
	[   700,    700,    0.1758 ],
	[   800,    800,    0.2165 ],
	[   900,    900,    0.2532 ],
	[  1000,   1000,    0.2743 ],
	[  2000,   2000,    0.7273 ],
	[  3000,   3000,    1.4106 ],
	[  4000,   4000,    2.2832 ],
	[  5000,   5000,    3.5171 ],
	[  6000,   6000,    5.0641 ],
	[  7000,   7000,    7.9562 ],
	[  8000,   8000,   11.0187 ],
	[  9000,   9000,   14.1723 ],
	[ 10000,  10000,   17.0228 ],
	[ 12000,  12000,   29.7981 ],
	[ 14000,  14000,   48.8108 ],
	[ 16000,  16000,   60.3565 ],
	[ 18000,  18000,   93.0945 ],
	[ 20000,  20000,  110.9726 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/chemv.txt
# numactl --interleave=all ./testing_chemv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
chemv_L = array([
	[    10,    0.0249,   0.0370,    0.0341,   0.0269,   0.0402,   0.0229,   0.4823,    0.0019,  1.43e-07,  1.92e-07,  1.43e-07,  nan ],
	[    11,    0.0332,   0.0331,    0.0439,   0.0250,   0.0501,   0.0219,   0.5767,    0.0019,  2.45e-07,  3.13e-07,  2.45e-07,  nan ],
	[    12,    0.0391,   0.0331,    0.0518,   0.0250,   0.0591,   0.0219,   0.6795,    0.0019,  2.87e-07,  1.59e-07,  2.51e-07,  nan ],
	[    13,    0.0445,   0.0339,    0.0580,   0.0260,   0.0688,   0.0219,   0.7028,    0.0021,  1.73e-07,  1.64e-07,  1.47e-07,  nan ],
	[    14,    0.0528,   0.0329,    0.0668,   0.0260,   0.0783,   0.0222,   0.9102,    0.0019,  1.52e-07,  1.52e-07,  2.04e-07,  nan ],
	[    15,    0.0581,   0.0341,    0.0762,   0.0260,   0.0933,   0.0212,   1.0381,    0.0019,  2.17e-07,  1.91e-07,  2.29e-07,  nan ],
	[    16,    0.0622,   0.0360,    0.0862,   0.0260,   0.1010,   0.0222,   1.1744,    0.0019,  1.69e-07,  2.46e-07,  1.69e-07,  nan ],
	[    17,    0.0738,   0.0341,    0.0934,   0.0269,   0.1055,   0.0238,   0.8794,    0.0029,  1.16e-07,  1.68e-07,  1.25e-07,  nan ],
	[    18,    0.0760,   0.0370,    0.1033,   0.0272,   0.1178,   0.0238,   0.9815,    0.0029,  2.18e-07,  3.35e-07,  2.12e-07,  nan ],
	[    19,    0.0920,   0.0339,    0.1157,   0.0269,   0.1294,   0.0241,   1.0891,    0.0029,  2.07e-07,  2.07e-07,  2.01e-07,  nan ],
	[    20,    0.0931,   0.0370,    0.1277,   0.0269,   0.1374,   0.0250,   1.6032,    0.0021,  1.91e-07,  1.91e-07,  2.13e-07,  nan ],
	[    21,    0.1079,   0.0350,    0.1403,   0.0269,   0.1510,   0.0250,   1.7616,    0.0021,  3.27e-07,  2.72e-07,  2.03e-07,  nan ],
	[    22,    0.1213,   0.0341,    0.1470,   0.0281,   0.1735,   0.0238,   1.3344,    0.0031,  2.74e-07,  2.60e-07,  1.94e-07,  nan ],
	[    23,    0.1286,   0.0350,    0.1673,   0.0269,   0.1801,   0.0250,   1.4545,    0.0031,  1.96e-07,  2.07e-07,  2.23e-07,  nan ],
	[    24,    0.1446,   0.0339,    0.1755,   0.0279,   0.1956,   0.0250,   2.5669,    0.0019,  2.51e-07,  2.51e-07,  2.51e-07,  nan ],
	[    25,    0.1472,   0.0360,    0.1967,   0.0269,   0.2117,   0.0250,   1.7100,    0.0031,  2.41e-07,  2.56e-07,  1.71e-07,  nan ],
	[    26,    0.1589,   0.0360,    0.2051,   0.0279,   0.2285,   0.0250,   1.8455,    0.0031,  2.20e-07,  1.64e-07,  2.20e-07,  nan ],
	[    27,    0.1666,   0.0370,    0.2207,   0.0279,   0.2369,   0.0260,   1.9862,    0.0031,  1.58e-07,  1.58e-07,  1.58e-07,  nan ],
	[    28,    0.1885,   0.0350,    0.2349,   0.0281,   0.2543,   0.0260,   2.1320,    0.0031,  3.41e-07,  2.81e-07,  3.41e-07,  nan ],
	[    29,    0.1902,   0.0372,    0.2515,   0.0281,   0.2603,   0.0272,   1.7458,    0.0041,  2.10e-07,  1.47e-07,  2.25e-07,  nan ],
	[    30,    0.2157,   0.0350,    0.2599,   0.0291,   0.3020,   0.0250,   1.8652,    0.0041,  3.18e-07,  2.01e-07,  1.59e-07,  nan ],
	[    31,    0.2381,   0.0339,    0.2889,   0.0279,   0.3220,   0.0250,   1.9886,    0.0041,  1.74e-07,  2.48e-07,  2.63e-07,  nan ],
	[    32,    0.2382,   0.0360,    0.2973,   0.0288,   0.3426,   0.0250,   2.7670,    0.0031,  1.88e-07,  1.69e-07,  2.67e-07,  nan ],
	[    33,    0.2530,   0.0360,    0.2690,   0.0339,   0.3237,   0.0281,   1.1236,    0.0081,  2.38e-07,  1.73e-07,  2.31e-07,  nan ],
	[    34,    0.2774,   0.0348,    0.2832,   0.0341,   0.3553,   0.0272,   2.3824,    0.0041,  2.65e-07,  1.91e-07,  2.80e-07,  nan ],
	[    35,    0.2696,   0.0379,    0.3106,   0.0329,   0.3793,   0.0269,   3.5721,    0.0029,  1.96e-07,  2.18e-07,  1.74e-07,  nan ],
	[    36,    0.3168,   0.0341,    0.3282,   0.0329,   0.4156,   0.0260,   2.6646,    0.0041,  2.28e-07,  1.91e-07,  3.22e-07,  nan ],
	[    37,    0.3165,   0.0360,    0.3567,   0.0319,   0.4385,   0.0260,   2.9874,    0.0038,  2.58e-07,  3.10e-07,  2.43e-07,  nan ],
	[    38,    0.3522,   0.0341,    0.3759,   0.0319,   0.4621,   0.0260,   2.9627,    0.0041,  3.05e-07,  3.02e-07,  1.81e-07,  nan ],
	[    39,    0.3813,   0.0331,    0.3841,   0.0329,   0.5048,   0.0250,   3.1176,    0.0041,  2.19e-07,  2.94e-07,  3.28e-07,  nan ],
	[    40,    0.3923,   0.0339,    0.4007,   0.0331,   0.5110,   0.0260,   3.2765,    0.0041,  2.90e-07,  2.86e-07,  3.02e-07,  nan ],
	[    41,    0.4118,   0.0339,    0.4363,   0.0319,   0.5129,   0.0272,   3.4393,    0.0041,  2.08e-07,  1.95e-07,  2.08e-07,  nan ],
	[    42,    0.4442,   0.0329,    0.4575,   0.0319,   0.5624,   0.0260,   2.9192,    0.0050,  2.95e-07,  2.76e-07,  3.05e-07,  nan ],
	[    43,    0.4653,   0.0329,    0.4792,   0.0319,   0.5890,   0.0260,   3.0574,    0.0050,  3.20e-07,  3.76e-07,  3.20e-07,  nan ],
	[    44,    0.4570,   0.0350,    0.4976,   0.0322,   0.6398,   0.0250,   3.1989,    0.0050,  2.91e-07,  3.13e-07,  2.74e-07,  nan ],
	[    45,    0.4945,   0.0339,    0.5088,   0.0329,   0.6442,   0.0260,   3.3435,    0.0050,  2.68e-07,  2.40e-07,  2.68e-07,  nan ],
	[    46,    0.5127,   0.0341,    0.5471,   0.0319,   0.6983,   0.0250,   3.4913,    0.0050,  2.78e-07,  3.42e-07,  2.99e-07,  nan ],
	[    47,    0.5349,   0.0341,    0.5543,   0.0329,   0.7285,   0.0250,   3.6423,    0.0050,  2.03e-07,  2.47e-07,  1.81e-07,  nan ],
	[    48,    0.5144,   0.0370,    0.5575,   0.0341,   0.7055,   0.0269,   4.6897,    0.0041,  2.46e-07,  3.28e-07,  2.42e-07,  nan ],
	[    49,    0.5806,   0.0341,    0.5847,   0.0339,   0.6806,   0.0291,   3.9538,    0.0050,  3.11e-07,  3.97e-07,  3.21e-07,  nan ],
	[    50,    0.5574,   0.0370,    0.5878,   0.0350,   0.7141,   0.0288,   3.4561,    0.0060,  3.15e-07,  3.41e-07,  3.41e-07,  nan ],
	[    51,    0.6112,   0.0350,    0.6283,   0.0341,   0.7364,   0.0291,   3.5937,    0.0060,  2.70e-07,  3.35e-07,  2.70e-07,  nan ],
	[    52,    0.6022,   0.0370,    0.6350,   0.0350,   0.7978,   0.0279,   4.4452,    0.0050,  3.67e-07,  3.02e-07,  3.02e-07,  nan ],
	[    53,    0.6213,   0.0372,    0.6593,   0.0350,   0.8010,   0.0288,   4.6153,    0.0050,  2.52e-07,  2.88e-07,  2.16e-07,  nan ],
	[    54,    0.6660,   0.0360,    0.6841,   0.0350,   0.8522,   0.0281,   4.7887,    0.0050,  3.00e-07,  2.23e-07,  2.23e-07,  nan ],
	[    55,    0.6905,   0.0360,    0.7292,   0.0341,   0.8617,   0.0288,   3.5955,    0.0069,  3.10e-07,  2.22e-07,  2.19e-07,  nan ],
	[    56,    0.7350,   0.0350,    0.7556,   0.0341,   0.8929,   0.0288,   4.1556,    0.0062,  2.46e-07,  2.72e-07,  2.15e-07,  nan ],
	[    57,    0.7824,   0.0341,    0.7824,   0.0341,   0.9171,   0.0291,   5.3280,    0.0050,  3.35e-07,  2.99e-07,  2.99e-07,  nan ],
	[    58,    0.7471,   0.0370,    0.7931,   0.0348,   0.9492,   0.0291,   3.1296,    0.0088,  2.79e-07,  4.00e-07,  3.54e-07,  nan ],
	[    59,    0.7727,   0.0370,    0.8148,   0.0350,   0.9506,   0.0300,   4.6066,    0.0062,  3.23e-07,  2.74e-07,  2.74e-07,  nan ],
	[    60,    0.8423,   0.0350,    0.8423,   0.0350,   0.9905,   0.0298,   5.8960,    0.0050,  2.62e-07,  2.62e-07,  2.01e-07,  nan ],
	[    61,    0.8702,   0.0350,    0.8472,   0.0360,   1.0234,   0.0298,   4.4113,    0.0069,  3.54e-07,  3.13e-07,  3.96e-07,  nan ],
	[    62,    0.8523,   0.0370,    0.8749,   0.0360,   1.0568,   0.0298,   5.2842,    0.0060,  3.08e-07,  2.54e-07,  2.54e-07,  nan ],
	[    63,    0.9275,   0.0350,    0.7747,   0.0420,   1.1176,   0.0291,   4.7017,    0.0069,  2.57e-07,  2.18e-07,  2.44e-07,  nan ],
	[    64,    0.9075,   0.0370,    0.9569,   0.0350,   1.1530,   0.0291,   6.6981,    0.0050,  3.63e-07,  3.63e-07,  3.58e-07,  nan ],
	[    65,    0.7840,   0.0441,    0.9297,   0.0372,   1.1157,   0.0310,   5.8016,    0.0060,  3.63e-07,  3.71e-07,  2.62e-07,  nan ],
	[    66,    0.8305,   0.0429,    0.9900,   0.0360,   1.1156,   0.0319,   4.3966,    0.0081,  2.89e-07,  3.57e-07,  3.52e-07,  nan ],
	[    67,    0.8953,   0.0410,    1.0476,   0.0350,   1.1159,   0.0329,   5.1333,    0.0072,  2.85e-07,  3.46e-07,  3.60e-07,  nan ],
	[    68,    0.8810,   0.0429,    1.0502,   0.0360,   1.1834,   0.0319,   6.0992,    0.0062,  4.05e-07,  2.80e-07,  3.37e-07,  nan ],
	[    69,    0.8823,   0.0441,    1.0463,   0.0372,   1.2556,   0.0310,   5.4409,    0.0072,  3.50e-07,  2.47e-07,  3.36e-07,  nan ],
	[    70,    0.9542,   0.0420,    1.1122,   0.0360,   1.2918,   0.0310,   4.9394,    0.0081,  3.93e-07,  2.72e-07,  2.72e-07,  nan ],
	[    71,    1.0281,   0.0401,    1.1750,   0.0350,   1.3185,   0.0312,   5.9559,    0.0069,  5.40e-07,  5.37e-07,  4.33e-07,  nan ],
	[    72,    1.0570,   0.0401,    1.2417,   0.0341,   1.4093,   0.0300,   5.3809,    0.0079,  2.69e-07,  3.33e-07,  2.65e-07,  nan ],
	[    73,    1.0927,   0.0398,    1.2085,   0.0360,   1.4483,   0.0300,   6.2926,    0.0069,  3.51e-07,  4.31e-07,  3.30e-07,  nan ],
	[    74,    1.1159,   0.0401,    1.2753,   0.0350,   1.4421,   0.0310,   6.2490,    0.0072,  2.58e-07,  3.26e-07,  3.14e-07,  nan ],
	[    75,    1.1528,   0.0398,    1.3097,   0.0350,   1.4809,   0.0310,   5.6623,    0.0081,  4.44e-07,  3.31e-07,  3.22e-07,  nan ],
	[    76,    1.0683,   0.0441,    1.3088,   0.0360,   1.4749,   0.0319,   6.8150,    0.0069,  3.62e-07,  3.17e-07,  3.05e-07,  nan ],
	[    77,    1.1792,   0.0410,    1.3432,   0.0360,   1.5136,   0.0319,   6.7607,    0.0072,  2.22e-07,  2.48e-07,  3.13e-07,  nan ],
	[    78,    1.1308,   0.0439,    1.3780,   0.0360,   1.5413,   0.0322,   7.1749,    0.0069,  3.28e-07,  3.94e-07,  3.28e-07,  nan ],
	[    79,    1.2124,   0.0420,    1.3767,   0.0370,   1.6415,   0.0310,   5.6155,    0.0091,  3.98e-07,  4.85e-07,  3.89e-07,  nan ],
	[    80,    1.2360,   0.0422,    1.4488,   0.0360,   1.6829,   0.0310,   7.5440,    0.0069,  2.95e-07,  2.95e-07,  2.86e-07,  nan ],
	[    81,    1.2740,   0.0420,    1.4466,   0.0370,   1.6248,   0.0329,   6.5949,    0.0081,  4.21e-07,  2.98e-07,  4.02e-07,  nan ],
	[    82,    1.2486,   0.0439,    1.4822,   0.0370,   1.6529,   0.0331,   6.7573,    0.0081,  3.75e-07,  3.63e-07,  2.98e-07,  nan ],
	[    83,    1.2518,   0.0448,    1.5585,   0.0360,   1.6573,   0.0339,   6.1930,    0.0091,  4.34e-07,  3.79e-07,  3.79e-07,  nan ],
	[    84,    1.3388,   0.0429,    1.5548,   0.0370,   1.6852,   0.0341,   7.0879,    0.0081,  4.06e-07,  3.27e-07,  3.27e-07,  nan ],
	[    85,    1.3706,   0.0429,    1.5516,   0.0379,   1.7374,   0.0339,   7.4760,    0.0079,  3.83e-07,  3.70e-07,  4.51e-07,  nan ],
	[    86,    1.4346,   0.0420,    1.5880,   0.0379,   1.7657,   0.0341,   7.4264,    0.0081,  4.78e-07,  2.81e-07,  3.58e-07,  nan ],
	[    87,    1.4679,   0.0420,    1.6561,   0.0372,   1.8721,   0.0329,   7.5986,    0.0081,  2.67e-07,  2.77e-07,  2.36e-07,  nan ],
	[    88,    1.4285,   0.0441,    1.6621,   0.0379,   1.8611,   0.0339,   9.1129,    0.0069,  3.70e-07,  3.13e-07,  3.47e-07,  nan ],
	[    89,    1.6183,   0.0398,    1.7436,   0.0370,   1.9443,   0.0331,   4.2899,    0.0150,  3.66e-07,  4.37e-07,  3.53e-07,  nan ],
	[    90,    1.6065,   0.0410,    1.8299,   0.0360,   2.0023,   0.0329,   7.2716,    0.0091,  2.71e-07,  3.40e-07,  2.71e-07,  nan ],
	[   100,    1.9242,   0.0422,    2.2555,   0.0360,   2.3169,   0.0350,   8.1090,    0.0100,  4.83e-07,  3.15e-07,  3.81e-07,  nan ],
	[   110,    2.1775,   0.0451,    2.5248,   0.0389,   2.6551,   0.0370,   8.2309,    0.0119,  4.65e-07,  4.86e-07,  4.39e-07,  nan ],
	[   120,    2.7179,   0.0429,    2.9120,   0.0401,   3.1563,   0.0370,  10.4090,    0.0112,  4.02e-07,  5.13e-07,  2.84e-07,  nan ],
	[   130,    2.7315,   0.0501,    3.4144,   0.0401,   3.4144,   0.0401,  10.4293,    0.0131,  3.76e-07,  3.71e-07,  3.52e-07,  nan ],
	[   140,    3.1653,   0.0501,    3.9566,   0.0401,   3.8646,   0.0410,  12.0857,    0.0131,  3.97e-07,  4.49e-07,  3.31e-07,  nan ],
	[   150,    3.7016,   0.0491,    4.4333,   0.0410,   4.3325,   0.0420,  12.1036,    0.0150,  5.48e-07,  4.55e-07,  4.55e-07,  nan ],
	[   160,    4.1288,   0.0501,    5.3193,   0.0389,   4.9264,   0.0420,  13.7626,    0.0150,  6.11e-07,  5.16e-07,  5.56e-07,  nan ],
	[   170,    4.6808,   0.0498,    5.6877,   0.0410,   5.2880,   0.0441,  13.0437,    0.0179,  4.12e-07,  3.70e-07,  4.69e-07,  nan ],
	[   180,    5.4538,   0.0479,    6.3734,   0.0410,   5.8310,   0.0448,  13.7028,    0.0191,  5.24e-07,  6.90e-07,  5.16e-07,  nan ],
	[   190,    5.7050,   0.0510,    6.0740,   0.0479,   6.1974,   0.0470,  13.8736,    0.0210,  5.62e-07,  6.47e-07,  4.89e-07,  nan ],
	[   200,    5.8539,   0.0551,    7.5125,   0.0429,   6.6943,   0.0482,  14.6983,    0.0219,  6.56e-07,  5.50e-07,  4.72e-07,  nan ],
	[   210,    6.2356,   0.0570,    8.0558,   0.0441,   6.9641,   0.0510,  15.3641,    0.0231,  5.82e-07,  5.40e-07,  5.14e-07,  nan ],
	[   220,    6.9579,   0.0560,    8.4721,   0.0460,   7.6407,   0.0510,  16.3511,    0.0238,  4.86e-07,  4.87e-07,  4.97e-07,  nan ],
	[   230,    7.6026,   0.0560,    9.6573,   0.0441,   8.1954,   0.0520,  15.8107,    0.0269,  6.63e-07,  6.63e-07,  5.97e-07,  nan ],
	[   240,    8.1034,   0.0572,   10.0768,   0.0460,   9.0879,   0.0510,  17.8423,    0.0260,  6.39e-07,  7.63e-07,  7.66e-07,  nan ],
	[   250,    8.5414,   0.0589,   10.7093,   0.0470,   9.1728,   0.0548,  18.0319,    0.0279,  8.54e-07,  7.43e-07,  7.35e-07,  nan ],
	[   260,    8.3567,   0.0651,   11.5805,   0.0470,   9.5455,   0.0570,  17.5490,    0.0310,  7.42e-07,  7.26e-07,  7.87e-07,  nan ],
	[   270,    9.4604,   0.0620,   12.4228,   0.0472,  10.1223,   0.0579,  18.3560,    0.0319,  9.11e-07,  7.93e-07,  7.93e-07,  nan ],
	[   280,   10.1722,   0.0620,   13.3574,   0.0472,  10.8392,   0.0582,  18.6251,    0.0339,  5.87e-07,  7.63e-07,  6.54e-07,  nan ],
	[   290,   10.3902,   0.0651,   13.7695,   0.0491,  11.0802,   0.0610,  17.8398,    0.0379,  7.66e-07,  9.53e-07,  9.56e-07,  nan ],
	[   300,   11.3246,   0.0639,   15.0995,   0.0479,  11.8555,   0.0610,  19.0880,    0.0379,  1.12e-06,  1.22e-06,  1.22e-06,  nan ],
	[   310,   11.8688,   0.0651,   15.4294,   0.0501,  12.2734,   0.0629,  18.9484,    0.0408,  7.45e-07,  7.94e-07,  7.94e-07,  nan ],
	[   320,   12.8809,   0.0639,   16.4385,   0.0501,  13.0761,   0.0629,  20.0702,    0.0410,  6.74e-07,  6.88e-07,  7.69e-07,  nan ],
	[   330,   12.1546,   0.0720,   17.4795,   0.0501,  13.4457,   0.0651,  19.0191,    0.0460,  6.87e-07,  7.63e-07,  8.37e-07,  nan ],
	[   340,   12.9007,   0.0720,   17.8716,   0.0520,  13.8648,   0.0670,  19.7767,    0.0470,  7.18e-07,  8.38e-07,  8.38e-07,  nan ],
	[   350,   13.8525,   0.0710,   18.9359,   0.0520,  14.4337,   0.0682,  18.9359,    0.0520,  6.99e-07,  6.06e-07,  6.10e-07,  nan ],
	[   360,   14.6536,   0.0710,   19.6702,   0.0529,  15.0578,   0.0691,  20.0311,    0.0520,  8.23e-07,  9.56e-07,  7.92e-07,  nan ],
	[   370,   15.6878,   0.0701,   19.9663,   0.0551,  15.7414,   0.0699,  18.9803,    0.0579,  7.78e-07,  7.47e-07,  7.00e-07,  nan ],
	[   380,   15.8967,   0.0730,   21.4290,   0.0541,  16.3234,   0.0710,  18.7092,    0.0620,  8.03e-07,  7.40e-07,  7.27e-07,  nan ],
	[   390,   15.4781,   0.0789,   22.2750,   0.0548,  16.9644,   0.0720,  19.1166,    0.0639,  8.64e-07,  7.83e-07,  7.83e-07,  nan ],
	[   400,   16.6837,   0.0770,   23.7394,   0.0541,  17.8438,   0.0720,  19.1774,    0.0670,  7.97e-07,  8.53e-07,  7.24e-07,  nan ],
	[   410,   17.3123,   0.0780,   23.6868,   0.0570,  17.7465,   0.0761,  19.8636,    0.0679,  1.04e-06,  1.13e-06,  9.70e-07,  nan ],
	[   420,   17.7318,   0.0799,   24.8541,   0.0570,  17.9460,   0.0789,  20.2735,    0.0699,  9.47e-07,  1.02e-06,  9.47e-07,  nan ],
	[   430,   18.5293,   0.0801,   25.6208,   0.0579,  19.0393,   0.0780,  19.7646,    0.0751,  7.11e-07,  9.40e-07,  8.01e-07,  nan ],
	[   440,   19.8728,   0.0782,   26.3898,   0.0589,  19.3997,   0.0801,  19.3997,    0.0801,  1.18e-06,  1.25e-06,  1.04e-06,  nan ],
	[   450,   18.6779,   0.0870,   26.6306,   0.0610,  19.5903,   0.0830,  20.3505,    0.0799,  9.71e-07,  9.59e-07,  9.71e-07,  nan ],
	[   460,   20.2366,   0.0839,   28.8392,   0.0589,  20.4692,   0.0830,  19.9531,    0.0851,  1.08e-06,  1.07e-06,  1.08e-06,  nan ],
	[   470,   20.8287,   0.0851,   29.0462,   0.0610,  20.5979,   0.0861,  20.8287,    0.0851,  7.82e-07,  7.66e-07,  7.93e-07,  nan ],
	[   480,   21.4823,   0.0861,   30.2934,   0.0610,  21.7840,   0.0849,  20.3013,    0.0911,  9.45e-07,  1.03e-06,  9.26e-07,  nan ],
	[   490,   22.6997,   0.0849,   30.6102,   0.0629,  21.9000,   0.0880,  20.9354,    0.0920,  8.72e-07,  7.80e-07,  9.07e-07,  nan ],
	[   500,   22.8016,   0.0880,   31.8704,   0.0629,  22.0834,   0.0908,  20.9298,    0.0958,  1.01e-06,  9.94e-07,  8.89e-07,  nan ],
	[   510,   24.2470,   0.0861,   33.1560,   0.0629,  22.9742,   0.0908,  20.8409,    0.1001,  9.95e-07,  7.78e-07,  1.02e-06,  nan ],
	[   520,   23.6345,   0.0918,   33.3307,   0.0651,  23.3315,   0.0930,  20.0867,    0.1080,  9.68e-07,  1.06e-06,  9.75e-07,  nan ],
	[   530,   23.6895,   0.0951,   34.1232,   0.0660,  23.9901,   0.0939,  20.4591,    0.1101,  1.16e-06,  1.16e-06,  1.05e-06,  nan ],
	[   540,   25.4188,   0.0920,   35.5495,   0.0658,  24.5906,   0.0951,  21.2373,    0.1101,  1.14e-06,  1.06e-06,  1.15e-06,  nan ],
	[   550,   25.5085,   0.0951,   36.2203,   0.0670,  25.0071,   0.0970,  20.8992,    0.1161,  7.85e-07,  8.08e-07,  8.25e-07,  nan ],
	[   560,   25.4237,   0.0989,   37.5475,   0.0670,  25.6712,   0.0980,  21.3149,    0.1180,  1.10e-06,  1.10e-06,  1.16e-06,  nan ],
	[   570,   26.8563,   0.0970,   37.6915,   0.0691,  26.0251,   0.1001,  21.1832,    0.1230,  1.62e-06,  1.73e-06,  1.73e-06,  nan ],
	[   580,   26.1965,   0.1030,   38.4929,   0.0701,  26.1965,   0.1030,  21.7633,    0.1240,  9.66e-07,  1.15e-06,  9.41e-07,  nan ],
	[   590,   26.6136,   0.1049,   39.9658,   0.0699,  27.3598,   0.1020,  21.3297,    0.1309,  1.14e-06,  1.26e-06,  1.16e-06,  nan ],
	[   600,   27.2130,   0.1061,   41.3304,   0.0699,  27.7748,   0.1040,  22.0579,    0.1309,  9.50e-07,  1.16e-06,  9.65e-07,  nan ],
	[   610,   28.4462,   0.1049,   40.7697,   0.0732,  27.8760,   0.1070,  21.6545,    0.1378,  1.39e-06,  1.30e-06,  1.44e-06,  nan ],
	[   620,   29.1206,   0.1059,   42.1157,   0.0732,  29.1206,   0.1059,  21.1267,    0.1459,  1.15e-06,  1.15e-06,  1.15e-06,  nan ],
	[   630,   29.2111,   0.1090,   43.0628,   0.0739,  28.4031,   0.1121,  20.9568,    0.1519,  1.46e-06,  1.17e-06,  1.16e-06,  nan ],
	[   640,   30.6818,   0.1070,   45.0200,   0.0730,  29.8831,   0.1099,  22.0418,    0.1490,  1.25e-06,  1.34e-06,  1.24e-06,  nan ],
	[   650,   29.7269,   0.1140,   44.5438,   0.0761,  29.4802,   0.1149,  21.0511,    0.1609,  1.22e-06,  1.05e-06,  9.58e-07,  nan ],
	[   660,   29.5950,   0.1180,   44.7998,   0.0780,  29.8361,   0.1171,  21.9633,    0.1590,  1.58e-06,  1.55e-06,  1.46e-06,  nan ],
	[   670,   30.4976,   0.1180,   45.6082,   0.0789,  30.2531,   0.1190,  21.8155,    0.1650,  1.28e-06,  1.28e-06,  1.19e-06,  nan ],
	[   680,   31.1619,   0.1190,   46.9782,   0.0789,  30.9141,   0.1199,  21.8090,    0.1700,  1.35e-06,  1.17e-06,  1.35e-06,  nan ],
	[   690,   32.3434,   0.1180,   47.2271,   0.0808,  31.0271,   0.1230,  21.5478,    0.1771,  1.29e-06,  1.27e-06,  1.19e-06,  nan ],
	[   700,   32.2444,   0.1218,   48.4615,   0.0811,  31.9320,   0.1230,  22.1762,    0.1771,  1.57e-06,  1.13e-06,  1.19e-06,  nan ],
	[   710,   32.8499,   0.1230,   49.8545,   0.0811,  32.8499,   0.1230,  21.8435,    0.1850,  1.23e-06,  1.32e-06,  1.16e-06,  nan ],
	[   720,   33.5209,   0.1240,   50.0887,   0.0830,  32.9506,   0.1261,  21.3091,    0.1950,  1.50e-06,  1.45e-06,  1.38e-06,  nan ],
	[   730,   34.4575,   0.1240,   52.0869,   0.0820,  33.3667,   0.1280,  21.6924,    0.1969,  1.06e-06,  1.34e-06,  1.09e-06,  nan ],
	[   740,   35.1367,   0.1249,   51.7181,   0.0849,  33.4757,   0.1311,  21.9448,    0.2000,  1.16e-06,  1.33e-06,  1.32e-06,  nan ],
	[   750,   35.2181,   0.1280,   53.7276,   0.0839,  34.3857,   0.1311,  21.6882,    0.2079,  1.35e-06,  1.17e-06,  1.17e-06,  nan ],
	[   760,   37.0597,   0.1249,   55.1684,   0.0839,  35.1163,   0.1318,  22.0423,    0.2100,  1.39e-06,  1.37e-06,  1.36e-06,  nan ],
	[   770,   36.2421,   0.1311,   54.6114,   0.0870,  34.9705,   0.1359,  21.9046,    0.2170,  1.42e-06,  1.22e-06,  1.33e-06,  nan ],
	[   780,   36.9202,   0.1321,   56.6587,   0.0861,  35.6338,   0.1369,  21.6671,    0.2251,  1.66e-06,  1.61e-06,  1.61e-06,  nan ],
	[   790,   37.6005,   0.1330,   56.2496,   0.0889,  35.9881,   0.1390,  21.9467,    0.2279,  1.35e-06,  1.26e-06,  1.56e-06,  nan ],
	[   800,   38.0125,   0.1349,   58.9455,   0.0870,  36.6526,   0.1400,  21.6450,    0.2370,  1.18e-06,  1.22e-06,  1.15e-06,  nan ],
	[   810,   39.1755,   0.1342,   58.3488,   0.0901,  37.2565,   0.1411,  21.8159,    0.2410,  1.58e-06,  1.43e-06,  1.30e-06,  nan ],
	[   820,   39.3785,   0.1369,   59.1709,   0.0911,  37.4226,   0.1440,  22.1818,    0.2429,  1.42e-06,  1.34e-06,  1.27e-06,  nan ],
	[   830,   40.0647,   0.1378,   59.9933,   0.0920,  38.0879,   0.1450,  22.0128,    0.2508,  1.18e-06,  1.11e-06,  1.09e-06,  nan ],
	[   840,   39.8627,   0.1419,   60.8161,   0.0930,  38.5037,   0.1469,  22.3336,    0.2532,  1.37e-06,  1.31e-06,  1.24e-06,  nan ],
	[   850,   41.0234,   0.1411,   62.9167,   0.0920,  39.1077,   0.1481,  21.6838,    0.2670,  1.59e-06,  1.52e-06,  1.59e-06,  nan ],
	[   860,   41.7818,   0.1419,   64.4045,   0.0920,  39.7762,   0.1490,  22.2761,    0.2661,  1.14e-06,  1.14e-06,  1.02e-06,  nan ],
	[   870,   42.1211,   0.1440,   63.9225,   0.0949,  39.8764,   0.1521,  22.0460,    0.2751,  1.39e-06,  1.38e-06,  1.39e-06,  nan ],
	[   880,   42.8106,   0.1450,   66.0631,   0.0939,  40.5434,   0.1531,  21.5649,    0.2878,  1.39e-06,  1.33e-06,  1.27e-06,  nan ],
	[   890,   42.5972,   0.1490,   65.4134,   0.0970,  40.9589,   0.1550,  21.8761,    0.2902,  1.26e-06,  1.24e-06,  1.18e-06,  nan ],
	[   900,   43.2820,   0.1500,   66.8904,   0.0970,  41.3745,   0.1569,  22.0084,    0.2949,  1.26e-06,  1.34e-06,  1.34e-06,  nan ],
	[  1000,   48.5618,   0.1650,   77.0751,   0.1040,  46.0339,   0.1740,  22.3139,    0.3591,  1.49e-06,  1.60e-06,  1.64e-06,  nan ],
	[  1100,   52.6635,   0.1841,   86.5026,   0.1121,  30.2052,   0.3209,  23.0216,    0.4210,  1.83e-06,  1.80e-06,  1.62e-06,  nan ],
	[  1200,   57.7312,   0.1998,   95.2338,   0.1211,  32.3172,   0.3569,  23.0705,    0.5000,  1.83e-06,  1.83e-06,  2.04e-06,  nan ],
	[  1300,   63.2210,   0.2141,  104.9398,   0.1290,  35.2405,   0.3841,  23.4597,    0.5770,  1.80e-06,  1.44e-06,  1.60e-06,  nan ],
	[  1400,   70.7166,   0.2220,  114.4994,   0.1371,  38.3666,   0.4091,  23.5385,    0.6669,  1.42e-06,  1.49e-06,  1.50e-06,  nan ],
	[  1500,   73.2296,   0.2460,  120.9168,   0.1490,  40.4783,   0.4451,  23.3106,    0.7730,  1.96e-06,  2.04e-06,  2.03e-06,  nan ],
	[  1600,   77.3896,   0.2649,  129.8790,   0.1578,  42.7123,   0.4799,  21.8334,    0.9389,  1.81e-06,  2.06e-06,  1.93e-06,  nan ],
	[  1700,   84.1786,   0.2749,  137.6707,   0.1681,  44.4201,   0.5209,  19.2384,    1.2028,  1.98e-06,  2.25e-06,  1.93e-06,  nan ],
	[  1800,   88.5329,   0.2930,  143.3557,   0.1810,  46.6582,   0.5560,  17.6463,    1.4701,  2.09e-06,  2.04e-06,  1.90e-06,  nan ],
	[  1900,   93.8290,   0.3080,  148.9277,   0.1941,  49.6629,   0.5820,  17.0718,    1.6930,  2.22e-06,  1.96e-06,  1.98e-06,  nan ],
	[  2000,   97.3322,   0.3290,  156.9140,   0.2041,  51.7405,   0.6189,  17.0976,    1.8730,  1.91e-06,  1.95e-06,  1.93e-06,  nan ],
	[  2100,  102.9053,   0.3431,  159.0556,   0.2220,  38.7544,   0.9110,  17.0895,    2.0659,  2.56e-06,  2.68e-06,  2.56e-06,  nan ],
	[  2200,  108.1985,   0.3581,  167.7133,   0.2310,  40.8225,   0.9491,  16.8601,    2.2981,  2.13e-06,  2.19e-06,  2.33e-06,  nan ],
	[  2300,  115.0380,   0.3681,  174.9938,   0.2420,  42.4722,   0.9971,  17.2429,    2.4559,  2.87e-06,  2.99e-06,  2.98e-06,  nan ],
	[  2400,  119.0852,   0.3872,  182.9653,   0.2520,  44.2550,   1.0419,  17.2951,    2.6660,  2.99e-06,  3.08e-06,  3.07e-06,  nan ],
	[  2500,  122.2850,   0.4091,  187.3581,   0.2670,  45.8168,   1.0920,  17.2453,    2.9011,  2.64e-06,  2.58e-06,  2.77e-06,  nan ],
	[  2600,  126.0882,   0.4292,  193.3210,   0.2799,  47.6704,   1.1351,  17.2934,    3.1290,  2.55e-06,  2.38e-06,  2.29e-06,  nan ],
	[  2700,  132.0106,   0.4420,  199.1438,   0.2930,  49.1560,   1.1871,  17.4086,    3.3519,  2.39e-06,  2.38e-06,  2.29e-06,  nan ],
	[  2800,  135.5343,   0.4630,  207.9050,   0.3018,  50.8516,   1.2341,  17.5776,    3.5701,  2.93e-06,  3.13e-06,  2.89e-06,  nan ],
	[  2900,  140.2577,   0.4799,  211.8070,   0.3178,  52.3043,   1.2870,  18.2225,    3.6941,  2.95e-06,  2.53e-06,  2.78e-06,  nan ],
	[  3000,  143.5349,   0.5019,  217.0552,   0.3319,  53.8384,   1.3380,  17.4759,    4.1220,  3.20e-06,  2.67e-06,  3.06e-06,  nan ],
	[  3100,  149.6355,   0.5140,  221.5756,   0.3471,  42.9980,   1.7889,  16.9868,    4.5280,  2.46e-06,  2.55e-06,  2.72e-06,  nan ],
	[  3200,  152.9175,   0.5360,  237.5663,   0.3450,  45.1067,   1.8170,  17.6332,    4.6480,  2.75e-06,  2.92e-06,  2.90e-06,  nan ],
	[  3300,  159.0835,   0.5479,  234.3422,   0.3719,  46.3867,   1.8790,  17.6973,    4.9250,  3.11e-06,  2.96e-06,  3.03e-06,  nan ],
	[  3400,  162.5724,   0.5691,  239.1007,   0.3870,  47.2783,   1.9569,  17.7895,    5.2009,  2.59e-06,  2.88e-06,  2.86e-06,  nan ],
	[  3500,  166.4850,   0.5889,  251.3557,   0.3901,  48.8035,   2.0089,  17.8256,    5.5001,  3.18e-06,  3.71e-06,  3.01e-06,  nan ],
	[  3600,  171.6838,   0.6042,  250.0268,   0.4148,  49.9652,   2.0759,  16.5266,    6.2761,  3.40e-06,  3.27e-06,  3.22e-06,  nan ],
	[  3700,  173.6103,   0.6311,  256.5865,   0.4270,  50.9136,   2.1520,  17.8098,    6.1519,  3.51e-06,  3.65e-06,  4.09e-06,  nan ],
	[  3800,  176.7106,   0.6540,  258.5159,   0.4470,  52.3170,   2.2089,  17.8395,    6.4781,  2.91e-06,  3.01e-06,  2.65e-06,  nan ],
	[  3900,  178.5172,   0.6819,  256.8205,   0.4740,  53.4561,   2.2771,  17.9087,    6.7971,  3.17e-06,  2.72e-06,  2.75e-06,  nan ],
	[  4000,  178.7857,   0.7162,  263.0128,   0.4869,  54.9097,   2.3320,  17.4811,    7.3249,  4.09e-06,  3.94e-06,  3.94e-06,  nan ],
	[  4100,  176.3301,   0.7629,  265.9078,   0.5059,  46.2316,   2.9099,  17.8896,    7.5200,  3.14e-06,  3.31e-06,  3.24e-06,  nan ],
	[  4200,  177.5980,   0.7949,  261.8804,   0.5391,  47.2291,   2.9891,  17.8315,    7.9169,  3.37e-06,  3.49e-06,  3.26e-06,  nan ],
	[  4300,  179.7908,   0.8230,  261.8725,   0.5651,  48.7693,   3.0341,  17.9645,    8.2369,  3.20e-06,  3.37e-06,  2.99e-06,  nan ],
	[  4400,  181.6197,   0.8531,  259.9341,   0.5960,  49.3721,   3.1381,  17.9136,    8.6489,  3.44e-06,  3.55e-06,  3.22e-06,  nan ],
	[  4500,  182.5198,   0.8879,  256.0089,   0.6330,  50.3559,   3.2182,  17.9740,    9.0160,  3.62e-06,  3.52e-06,  3.49e-06,  nan ],
	[  4600,  187.8951,   0.9012,  255.0245,   0.6640,  51.4222,   3.2930,  16.7958,   10.0820,  3.91e-06,  3.50e-06,  3.45e-06,  nan ],
	[  4700,  186.2482,   0.9491,  258.0766,   0.6850,  52.1783,   3.3879,  17.8059,    9.9280,  3.99e-06,  4.17e-06,  4.09e-06,  nan ],
	[  4800,  187.3845,   0.9840,  261.1738,   0.7060,  52.8596,   3.4881,  17.8538,   10.3271,  4.05e-06,  3.51e-06,  3.61e-06,  nan ],
	[  4900,  187.6341,   1.0240,  262.0776,   0.7331,  54.1701,   3.5470,  17.9653,   10.6950,  3.57e-06,  3.64e-06,  3.62e-06,  nan ],
	[  5000,  188.0575,   1.0638,  260.8369,   0.7670,  55.0202,   3.6361,  17.6018,   11.3659,  4.27e-06,  4.90e-06,  4.33e-06,  nan ],
	[  5100,  190.7796,   1.0910,  265.1906,   0.7849,  55.9083,   3.7229,  17.7961,   11.6959,  4.20e-06,  4.50e-06,  4.68e-06,  nan ],
	[  5200,  191.3098,   1.1311,  265.5277,   0.8149,  49.0315,   4.4131,  17.5096,   12.3580,  3.88e-06,  3.88e-06,  3.79e-06,  nan ],
	[  5300,  193.1198,   1.1640,  261.6738,   0.8590,  49.6086,   4.5311,  17.7260,   12.6810,  3.67e-06,  3.55e-06,  3.63e-06,  nan ],
	[  5400,  193.8057,   1.2040,  266.6809,   0.8750,  49.8710,   4.6790,  17.5779,   13.2749,  4.65e-06,  4.40e-06,  4.29e-06,  nan ],
	[  5500,  195.7013,   1.2369,  261.4054,   0.9260,  51.2622,   4.7221,  17.8464,   13.5639,  3.96e-06,  3.73e-06,  4.32e-06,  nan ],
	[  5600,  198.2201,   1.2660,  267.2801,   0.9389,  52.4674,   4.7829,  17.8993,   14.0200,  4.03e-06,  4.28e-06,  4.32e-06,  nan ],
	[  5700,  198.1593,   1.3120,  266.3582,   0.9761,  52.4592,   4.9560,  17.8283,   14.5829,  4.19e-06,  4.61e-06,  4.21e-06,  nan ],
	[  5800,  199.9757,   1.3461,  266.5399,   1.0099,  53.9447,   4.9901,  17.6958,   15.2121,  4.50e-06,  4.40e-06,  4.13e-06,  nan ],
	[  5900,  201.5399,   1.3821,  270.6966,   1.0290,  54.4142,   5.1191,  18.0278,   15.4512,  4.33e-06,  4.35e-06,  4.11e-06,  nan ],
	[  6000,  202.2872,   1.4241,  267.4920,   1.0769,  55.4299,   5.1970,  17.4453,   16.5129,  4.16e-06,  4.41e-06,  3.83e-06,  nan ],
	[  6100,  203.9300,   1.4601,  271.1393,   1.0982,  55.4880,   5.3661,  12.1920,   24.4219,  4.37e-06,  4.55e-06,  4.55e-06,  nan ],
	[  6200,  205.7647,   1.4949,  269.1165,   1.1430,  50.0075,   6.1510,  17.7410,   17.3380,  3.80e-06,  3.64e-06,  3.88e-06,  nan ],
	[  6300,  207.9770,   1.5271,  273.3058,   1.1621,  50.4027,   6.3012,  17.9433,   17.7000,  4.89e-06,  4.27e-06,  4.75e-06,  nan ],
	[  6400,  207.1597,   1.5821,  276.6019,   1.1849,  51.1159,   6.4120,  19.5419,   16.7720,  4.76e-06,  4.43e-06,  4.15e-06,  nan ],
	[  6500,  210.6361,   1.6050,  275.0731,   1.2290,  51.2543,   6.5961,  17.9972,   18.7850,  4.80e-06,  4.15e-06,  4.97e-06,  nan ],
	[  6600,  213.3007,   1.6341,  278.1513,   1.2531,  52.4471,   6.6459,  17.8065,   19.5749,  4.36e-06,  4.63e-06,  4.43e-06,  nan ],
	[  6700,  215.7210,   1.6651,  276.1356,   1.3008,  52.5532,   6.8350,  18.0312,   19.9211,  5.18e-06,  4.38e-06,  4.88e-06,  nan ],
	[  6800,  212.6472,   1.7400,  279.2190,   1.3251,  54.3725,   6.8049,  17.7844,   20.8049,  4.36e-06,  3.81e-06,  4.20e-06,  nan ],
	[  6900,  216.0749,   1.7631,  279.5441,   1.3628,  54.5238,   6.9871,  18.0253,   21.1349,  4.06e-06,  3.64e-06,  3.62e-06,  nan ],
	[  7000,  216.3557,   1.8122,  281.0664,   1.3950,  54.6461,   7.1750,  18.0020,   21.7800,  4.19e-06,  4.06e-06,  3.99e-06,  nan ],
	[  7100,  217.9078,   1.8511,  280.1053,   1.4400,  55.3756,   7.2842,  18.0153,   22.3901,  4.30e-06,  4.02e-06,  3.69e-06,  nan ],
	[  7200,  220.7619,   1.8790,  282.5766,   1.4679,  49.8317,   8.3241,  17.6723,   23.4721,  4.07e-06,  4.35e-06,  4.07e-06,  nan ],
	[  7300,  221.2648,   1.9271,  284.6543,   1.4980,  50.9873,   8.3630,  17.6099,   24.2140,  4.46e-06,  4.42e-06,  4.55e-06,  nan ],
	[  7400,  223.5510,   1.9600,  285.9964,   1.5321,  52.0937,   8.4112,  17.6042,   24.8899,  4.27e-06,  4.18e-06,  4.23e-06,  nan ],
	[  7500,  224.7130,   2.0030,  283.6259,   1.5869,  52.4641,   8.5790,  17.8679,   25.1899,  4.63e-06,  4.19e-06,  4.17e-06,  nan ],
	[  7600,  227.3351,   2.0330,  284.4441,   1.6248,  53.0496,   8.7121,  17.2903,   26.7301,  3.98e-06,  3.88e-06,  4.23e-06,  nan ],
	[  7700,  225.0430,   2.1081,  284.0991,   1.6699,  53.3466,   8.8930,  16.4898,   28.7700,  5.22e-06,  4.58e-06,  4.81e-06,  nan ],
	[  7800,  225.4936,   2.1589,  284.3398,   1.7121,  54.0128,   9.0129,  17.4372,   27.9181,  4.48e-06,  5.09e-06,  4.66e-06,  nan ],
	[  7900,  224.4460,   2.2249,  284.5442,   1.7550,  54.6190,   9.1429,  17.7423,   28.1460,  4.67e-06,  4.82e-06,  4.79e-06,  nan ],
	[  8000,  224.3926,   2.2821,  281.0634,   1.8220,  54.6480,   9.3708,  17.8474,   28.6930,  4.53e-06,  4.92e-06,  5.01e-06,  nan ],
	[  8100,  226.3015,   2.3198,  282.6953,   1.8570,  55.6995,   9.4252,  17.3214,   30.3080,  5.05e-06,  5.03e-06,  4.90e-06,  nan ],
	[  8200,  226.5448,   2.3749,  284.6383,   1.8902,  50.1971,  10.7181,  16.4481,   32.7101,  5.15e-06,  5.52e-06,  5.19e-06,  nan ],
	[  8300,  228.3440,   2.4140,  289.2147,   1.9059,  51.1568,  10.7751,  17.3667,   31.7400,  6.48e-06,  6.03e-06,  5.72e-06,  nan ],
	[  8400,  225.5690,   2.5029,  289.2419,   1.9519,  51.7963,  10.9000,  16.9876,   33.2348,  4.66e-06,  4.62e-06,  4.80e-06,  nan ],
	[  8500,  229.2244,   2.5220,  285.1959,   2.0270,  52.0676,  11.1029,  17.7638,   32.5439,  5.47e-06,  5.63e-06,  5.71e-06,  nan ],
	[  8600,  227.8636,   2.5971,  280.5922,   2.1091,  53.0707,  11.1508,  16.6306,   35.5840,  5.47e-06,  5.26e-06,  5.22e-06,  nan ],
	[  8700,  226.9835,   2.6681,  286.6042,   2.1131,  53.2141,  11.3809,  17.4280,   34.7500,  5.47e-06,  5.42e-06,  5.36e-06,  nan ],
	[  8800,  225.8144,   2.7440,  282.8271,   2.1908,  53.2790,  11.6298,  17.8602,   34.6930,  5.95e-06,  5.68e-06,  5.61e-06,  nan ],
	[  8900,  227.5742,   2.7850,  285.7459,   2.2180,  54.3607,  11.6589,  17.9127,   35.3820,  5.69e-06,  5.32e-06,  5.26e-06,  nan ],
	[  9000,  227.8212,   2.8448,  283.7835,   2.2838,  54.6415,  11.8611,  17.5939,   36.8371,  5.18e-06,  5.31e-06,  5.75e-06,  nan ],
	[ 10000,  233.8802,   3.4211,  286.8821,   2.7890,  54.8743,  14.5810,  17.3314,   46.1659,  5.70e-06,  5.45e-06,  4.74e-06,  nan ],
	[ 12000,  238.6863,   4.8270,  290.7957,   3.9620,  54.5318,  21.1279,  17.3796,   66.2930,  6.72e-06,  6.68e-06,  6.35e-06,  nan ],
	[ 14000,  248.3621,   6.3140,  295.9981,   5.2979,  54.5143,  28.7662,  16.9389,   92.5779,  7.49e-06,  8.12e-06,  7.90e-06,  nan ],
	[ 16000,  252.4609,   8.1129,  293.8110,   6.9711,  54.6419,  37.4839,  15.6665,  130.7368,  6.96e-06,  6.64e-06,  6.96e-06,  nan ],
	[ 18000,  252.7499,  10.2561,  295.5780,   8.7700,  54.9235,  47.1969,  16.5584,  156.5499,  7.60e-06,  7.60e-06,  8.15e-06,  nan ],
	[ 20000,  261.2656,  12.2490,  294.5724,  10.8640,  54.0089,  59.2539,  17.2832,  185.1649,  9.59e-06,  9.18e-06,  9.22e-06,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/cpotrf.txt
# numactl --interleave=all ./testing_cpotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cpotrf = array([
	[    10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,  nan,  nan,     0.04,  0.00,  nan ],
	[    30,  nan,  nan,     0.13,  0.00,  nan ],
	[    40,  nan,  nan,     1.80,  0.00,  nan ],
	[    50,  nan,  nan,     2.35,  0.00,  nan ],
	[    60,  nan,  nan,     3.47,  0.00,  nan ],
	[    70,  nan,  nan,     4.50,  0.00,  nan ],
	[    80,  nan,  nan,     5.09,  0.00,  nan ],
	[    90,  nan,  nan,     2.37,  0.00,  nan ],
	[   100,  nan,  nan,     2.98,  0.00,  nan ],
	[   200,  nan,  nan,    18.16,  0.00,  nan ],
	[   300,  nan,  nan,    18.41,  0.00,  nan ],
	[   400,  nan,  nan,    35.80,  0.00,  nan ],
	[   500,  nan,  nan,    59.64,  0.00,  nan ],
	[   600,  nan,  nan,    58.65,  0.00,  nan ],
	[   700,  nan,  nan,    92.59,  0.00,  nan ],
	[   800,  nan,  nan,   103.84,  0.01,  nan ],
	[   900,  nan,  nan,   135.72,  0.01,  nan ],
	[  1000,  nan,  nan,   173.93,  0.01,  nan ],
	[  2000,  nan,  nan,   542.17,  0.02,  nan ],
	[  3000,  nan,  nan,   985.20,  0.04,  nan ],
	[  4000,  nan,  nan,  1292.83,  0.07,  nan ],
	[  5000,  nan,  nan,  1526.84,  0.11,  nan ],
	[  6000,  nan,  nan,  1740.43,  0.17,  nan ],
	[  7000,  nan,  nan,  1876.94,  0.24,  nan ],
	[  8000,  nan,  nan,  2023.99,  0.34,  nan ],
	[  9000,  nan,  nan,  2126.79,  0.46,  nan ],
	[ 10000,  nan,  nan,  2216.49,  0.60,  nan ],
	[ 12000,  nan,  nan,  2363.24,  0.98,  nan ],
	[ 14000,  nan,  nan,  2494.30,  1.47,  nan ],
	[ 16000,  nan,  nan,  2586.92,  2.11,  nan ],
	[ 18000,  nan,  nan,  2644.91,  2.94,  nan ],
	[ 20000,  nan,  nan,  2706.00,  3.94,  nan ],
])

# numactl --interleave=all ./testing_cpotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.05,  0.00,  nan ],
	[    40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,  nan,  nan,     0.19,  0.00,  nan ],
	[    60,  nan,  nan,     0.33,  0.00,  nan ],
	[    70,  nan,  nan,     0.50,  0.00,  nan ],
	[    80,  nan,  nan,     0.71,  0.00,  nan ],
	[    90,  nan,  nan,     1.00,  0.00,  nan ],
	[   100,  nan,  nan,     1.30,  0.00,  nan ],
	[   200,  nan,  nan,    24.85,  0.00,  nan ],
	[   300,  nan,  nan,    14.57,  0.00,  nan ],
	[   400,  nan,  nan,    28.90,  0.00,  nan ],
	[   500,  nan,  nan,    49.90,  0.00,  nan ],
	[   600,  nan,  nan,    64.01,  0.00,  nan ],
	[   700,  nan,  nan,    94.00,  0.00,  nan ],
	[   800,  nan,  nan,   105.97,  0.01,  nan ],
	[   900,  nan,  nan,   140.86,  0.01,  nan ],
	[  1000,  nan,  nan,   181.47,  0.01,  nan ],
	[  2000,  nan,  nan,   624.18,  0.02,  nan ],
	[  3000,  nan,  nan,  1151.31,  0.03,  nan ],
	[  4000,  nan,  nan,  1509.14,  0.06,  nan ],
	[  5000,  nan,  nan,  1762.60,  0.09,  nan ],
	[  6000,  nan,  nan,  1986.88,  0.15,  nan ],
	[  7000,  nan,  nan,  2119.76,  0.22,  nan ],
	[  8000,  nan,  nan,  2253.88,  0.30,  nan ],
	[  9000,  nan,  nan,  2313.50,  0.42,  nan ],
	[ 10000,  nan,  nan,  2416.80,  0.55,  nan ],
	[ 12000,  nan,  nan,  2565.33,  0.90,  nan ],
	[ 14000,  nan,  nan,  2676.10,  1.37,  nan ],
	[ 16000,  nan,  nan,  2759.86,  1.98,  nan ],
	[ 18000,  nan,  nan,  2793.26,  2.78,  nan ],
	[ 20000,  nan,  nan,  2840.93,  3.76,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/dgeev.txt
# numactl --interleave=all ./testing_dgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeev_RN = array([
	[    10,  nan,    0.0003 ],
	[    20,  nan,    0.0005 ],
	[    30,  nan,    0.0011 ],
	[    40,  nan,    0.0035 ],
	[    50,  nan,    0.0038 ],
	[    60,  nan,    0.0029 ],
	[    70,  nan,    0.0049 ],
	[    80,  nan,    0.0069 ],
	[    90,  nan,    0.0076 ],
	[   100,  nan,    0.0105 ],
	[   200,  nan,    0.0511 ],
	[   300,  nan,    0.0940 ],
	[   400,  nan,    0.1513 ],
	[   500,  nan,    0.2043 ],
	[   600,  nan,    0.4025 ],
	[   700,  nan,    0.4948 ],
	[   800,  nan,    0.6284 ],
	[   900,  nan,    0.7352 ],
	[  1000,  nan,    0.8453 ],
	[  2000,  nan,    2.7113 ],
	[  3000,  nan,    8.3927 ],
	[  4000,  nan,   13.1533 ],
	[  5000,  nan,   19.8204 ],
	[  6000,  nan,   35.3721 ],
	[  7000,  nan,   47.4245 ],
	[  8000,  nan,   60.2085 ],
	[  9000,  nan,   72.0642 ],
	[ 10000,  nan,   85.6638 ],
	[ 12000,  nan,  127.5793 ],
	[ 14000,  nan,  172.5071 ],
	[ 16000,  nan,  233.0806 ],
	[ 18000,  nan,  296.6084 ],
	[ 20000,  nan,  377.1261 ],
])

# numactl --interleave=all ./testing_dgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeev_RV = array([
	[    10,  nan,    0.0020 ],
	[    20,  nan,    0.0025 ],
	[    30,  nan,    0.0030 ],
	[    40,  nan,    0.0073 ],
	[    50,  nan,    0.0083 ],
	[    60,  nan,    0.0070 ],
	[    70,  nan,    0.0108 ],
	[    80,  nan,    0.0126 ],
	[    90,  nan,    0.0139 ],
	[   100,  nan,    0.0160 ],
	[   200,  nan,    0.0743 ],
	[   300,  nan,    0.1380 ],
	[   400,  nan,    0.2666 ],
	[   500,  nan,    0.3481 ],
	[   600,  nan,    0.4816 ],
	[   700,  nan,    0.6642 ],
	[   800,  nan,    0.7633 ],
	[   900,  nan,    0.9096 ],
	[  1000,  nan,    1.1074 ],
	[  2000,  nan,    3.7380 ],
	[  3000,  nan,    9.7185 ],
	[  4000,  nan,   16.8563 ],
	[  5000,  nan,   25.8547 ],
	[  6000,  nan,   44.7942 ],
	[  7000,  nan,   58.4372 ],
	[  8000,  nan,   77.0922 ],
	[  9000,  nan,  100.3287 ],
	[ 10000,  nan,  121.8376 ],
	[ 12000,  nan,  189.8740 ],
	[ 14000,  nan,  256.4798 ],
	[ 16000,  nan,  366.9515 ],
	[ 18000,  nan,  463.3130 ],
	[ 20000,  nan,  611.5157 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/dgeqrf.txt
# numactl --interleave=all ./testing_dgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeqrf = array([
	[    10,     10,  nan,  nan,     0.03,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.17,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.46,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.84,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.25,   0.00,  nan ],
	[    60,     60,  nan,  nan,     1.61,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.47,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.71,   0.00,  nan ],
	[    90,     90,  nan,  nan,     0.96,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.24,   0.00,  nan ],
	[   200,    200,  nan,  nan,     4.54,   0.00,  nan ],
	[   300,    300,  nan,  nan,    10.16,   0.00,  nan ],
	[   400,    400,  nan,  nan,    16.67,   0.01,  nan ],
	[   500,    500,  nan,  nan,    24.70,   0.01,  nan ],
	[   600,    600,  nan,  nan,    32.95,   0.01,  nan ],
	[   700,    700,  nan,  nan,    42.56,   0.01,  nan ],
	[   800,    800,  nan,  nan,    51.44,   0.01,  nan ],
	[   900,    900,  nan,  nan,    59.56,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,    71.06,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   186.61,   0.06,  nan ],
	[  3000,   3000,  nan,  nan,   305.99,   0.12,  nan ],
	[  4000,   4000,  nan,  nan,   378.07,   0.23,  nan ],
	[  5000,   5000,  nan,  nan,   483.83,   0.34,  nan ],
	[  6000,   6000,  nan,  nan,   584.61,   0.49,  nan ],
	[  7000,   7000,  nan,  nan,   707.00,   0.65,  nan ],
	[  8000,   8000,  nan,  nan,   733.32,   0.93,  nan ],
	[  9000,   9000,  nan,  nan,   779.32,   1.25,  nan ],
	[ 10000,  10000,  nan,  nan,   840.03,   1.59,  nan ],
	[ 12000,  12000,  nan,  nan,   901.33,   2.56,  nan ],
	[ 14000,  14000,  nan,  nan,   947.07,   3.86,  nan ],
	[ 16000,  16000,  nan,  nan,   962.32,   5.68,  nan ],
	[ 18000,  18000,  nan,  nan,   999.23,   7.78,  nan ],
	[ 20000,  20000,  nan,  nan,  1014.13,  10.52,  nan ],
])

# numactl --interleave=all ./testing_dgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.01,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.04,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.08,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.16,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.27,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.31,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.46,   0.00,  nan ],
	[    90,     90,  nan,  nan,     0.70,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.03,   0.00,  nan ],
	[   200,    200,  nan,  nan,     4.09,   0.00,  nan ],
	[   300,    300,  nan,  nan,     9.35,   0.00,  nan ],
	[   400,    400,  nan,  nan,    15.81,   0.01,  nan ],
	[   500,    500,  nan,  nan,    24.34,   0.01,  nan ],
	[   600,    600,  nan,  nan,    32.75,   0.01,  nan ],
	[   700,    700,  nan,  nan,    42.67,   0.01,  nan ],
	[   800,    800,  nan,  nan,    52.59,   0.01,  nan ],
	[   900,    900,  nan,  nan,    61.51,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,    73.34,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   195.61,   0.05,  nan ],
	[  3000,   3000,  nan,  nan,   311.99,   0.12,  nan ],
	[  4000,   4000,  nan,  nan,   400.75,   0.21,  nan ],
	[  5000,   5000,  nan,  nan,   517.73,   0.32,  nan ],
	[  6000,   6000,  nan,  nan,   622.53,   0.46,  nan ],
	[  7000,   7000,  nan,  nan,   688.27,   0.66,  nan ],
	[  8000,   8000,  nan,  nan,   749.37,   0.91,  nan ],
	[  9000,   9000,  nan,  nan,   790.68,   1.23,  nan ],
	[ 10000,  10000,  nan,  nan,   825.02,   1.62,  nan ],
	[ 12000,  12000,  nan,  nan,   890.99,   2.59,  nan ],
	[ 14000,  14000,  nan,  nan,   938.17,   3.90,  nan ],
	[ 16000,  16000,  nan,  nan,   970.53,   5.63,  nan ],
	[ 18000,  18000,  nan,  nan,   985.13,   7.89,  nan ],
	[ 20000,  20000,  nan,  nan,  1002.88,  10.64,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/dgesvd.txt
# numactl --interleave=all ./testing_dgesvd -UN -VN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
dgesvd_UN = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.01,  nan ],
	[ nan,     300,     300,  nan,    0.03,  nan ],
	[ nan,     400,     400,  nan,    0.05,  nan ],
	[ nan,     500,     500,  nan,    0.07,  nan ],
	[ nan,     600,     600,  nan,    0.09,  nan ],
	[ nan,     700,     700,  nan,    0.12,  nan ],
	[ nan,     800,     800,  nan,    0.15,  nan ],
	[ nan,     900,     900,  nan,    0.19,  nan ],
	[ nan,    1000,    1000,  nan,    0.23,  nan ],
	[ nan,    2000,    2000,  nan,    0.90,  nan ],
	[ nan,    3000,    3000,  nan,    2.32,  nan ],
	[ nan,    4000,    4000,  nan,    4.67,  nan ],
	[ nan,    5000,    5000,  nan,    8.28,  nan ],
	[ nan,    6000,    6000,  nan,   13.27,  nan ],
	[ nan,    7000,    7000,  nan,   19.95,  nan ],
	[ nan,    8000,    8000,  nan,   28.53,  nan ],
	[ nan,    9000,    9000,  nan,   39.61,  nan ],
	[ nan,   10000,   10000,  nan,   52.86,  nan ],
	[ nan,   12000,   12000,  nan,   88.18,  nan ],
	[ nan,   14000,   14000,  nan,  135.89,  nan ],
	[ nan,   16000,   16000,  nan,  200.69,  nan ],
	[ nan,   18000,   18000,  nan,  283.76,  nan ],
	[ nan,   20000,   20000,  nan,  383.85,  nan ],
	[ nan,     300,     100,  nan,    0.02,  nan ],
	[ nan,     600,     200,  nan,    0.02,  nan ],
	[ nan,     900,     300,  nan,    0.03,  nan ],
	[ nan,    1200,     400,  nan,    0.06,  nan ],
	[ nan,    1500,     500,  nan,    0.08,  nan ],
	[ nan,    1800,     600,  nan,    0.11,  nan ],
	[ nan,    2100,     700,  nan,    0.15,  nan ],
	[ nan,    2400,     800,  nan,    0.19,  nan ],
	[ nan,    2700,     900,  nan,    0.24,  nan ],
	[ nan,    3000,    1000,  nan,    0.30,  nan ],
	[ nan,    6000,    2000,  nan,    1.25,  nan ],
	[ nan,    9000,    3000,  nan,    3.32,  nan ],
	[ nan,   12000,    4000,  nan,    6.82,  nan ],
	[ nan,   15000,    5000,  nan,   12.82,  nan ],
	[ nan,   18000,    6000,  nan,   19.68,  nan ],
	[ nan,   21000,    7000,  nan,   29.68,  nan ],
	[ nan,   24000,    8000,  nan,   43.09,  nan ],
	[ nan,   27000,    9000,  nan,   59.81,  nan ],
	[ nan,     100,     300,  nan,    0.00,  nan ],
	[ nan,     200,     600,  nan,    0.02,  nan ],
	[ nan,     300,     900,  nan,    0.04,  nan ],
	[ nan,     400,    1200,  nan,    0.06,  nan ],
	[ nan,     500,    1500,  nan,    0.09,  nan ],
	[ nan,     600,    1800,  nan,    0.13,  nan ],
	[ nan,     700,    2100,  nan,    0.17,  nan ],
	[ nan,     800,    2400,  nan,    0.21,  nan ],
	[ nan,     900,    2700,  nan,    0.27,  nan ],
	[ nan,    1000,    3000,  nan,    0.33,  nan ],
	[ nan,    2000,    6000,  nan,    1.32,  nan ],
	[ nan,    3000,    9000,  nan,    3.53,  nan ],
	[ nan,    4000,   12000,  nan,    7.26,  nan ],
	[ nan,    5000,   15000,  nan,   12.87,  nan ],
	[ nan,    6000,   18000,  nan,   21.08,  nan ],
	[ nan,    7000,   21000,  nan,   31.73,  nan ],
	[ nan,    8000,   24000,  nan,   45.26,  nan ],
	[ nan,    9000,   27000,  nan,   62.39,  nan ],
	[ nan,   10000,     100,  nan,    0.01,  nan ],
	[ nan,   20000,     200,  nan,    0.06,  nan ],
	[ nan,   30000,     300,  nan,    0.15,  nan ],
	[ nan,   40000,     400,  nan,    0.38,  nan ],
	[ nan,   50000,     500,  nan,    0.61,  nan ],
	[ nan,   60000,     600,  nan,    0.93,  nan ],
	[ nan,   70000,     700,  nan,    1.30,  nan ],
	[ nan,   80000,     800,  nan,    1.76,  nan ],
	[ nan,   90000,     900,  nan,    2.47,  nan ],
	[ nan,  100000,    1000,  nan,    3.23,  nan ],
	[ nan,  200000,    2000,  nan,   18.50,  nan ],
	[ nan,     100,   10000,  nan,    0.01,  nan ],
	[ nan,     200,   20000,  nan,    0.05,  nan ],
	[ nan,     300,   30000,  nan,    0.16,  nan ],
	[ nan,     400,   40000,  nan,    0.33,  nan ],
	[ nan,     500,   50000,  nan,    0.60,  nan ],
	[ nan,     600,   60000,  nan,    0.91,  nan ],
	[ nan,     700,   70000,  nan,    1.44,  nan ],
	[ nan,     800,   80000,  nan,    1.92,  nan ],
	[ nan,     900,   90000,  nan,    2.28,  nan ],
	[ nan,    1000,  100000,  nan,    2.97,  nan ],
	[ nan,    2000,  200000,  nan,   20.16,  nan ],
])

# numactl --interleave=all ./testing_dgesvd -US -VS -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
dgesvd_US = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.01,  nan ],
	[ nan,      70,      70,  nan,    0.01,  nan ],
	[ nan,      80,      80,  nan,    0.01,  nan ],
	[ nan,      90,      90,  nan,    0.01,  nan ],
	[ nan,     100,     100,  nan,    0.02,  nan ],
	[ nan,     200,     200,  nan,    0.07,  nan ],
	[ nan,     300,     300,  nan,    0.08,  nan ],
	[ nan,     400,     400,  nan,    0.10,  nan ],
	[ nan,     500,     500,  nan,    0.15,  nan ],
	[ nan,     600,     600,  nan,    0.23,  nan ],
	[ nan,     700,     700,  nan,    0.31,  nan ],
	[ nan,     800,     800,  nan,    0.40,  nan ],
	[ nan,     900,     900,  nan,    0.52,  nan ],
	[ nan,    1000,    1000,  nan,    0.65,  nan ],
	[ nan,    2000,    2000,  nan,    3.15,  nan ],
	[ nan,    3000,    3000,  nan,    8.73,  nan ],
	[ nan,    4000,    4000,  nan,   17.19,  nan ],
	[ nan,    5000,    5000,  nan,   30.02,  nan ],
	[ nan,    6000,    6000,  nan,   43.31,  nan ],
	[ nan,    7000,    7000,  nan,   58.08,  nan ],
	[ nan,    8000,    8000,  nan,   80.02,  nan ],
	[ nan,    9000,    9000,  nan,  109.74,  nan ],
	[ nan,   10000,   10000,  nan,  145.96,  nan ],
	[ nan,   12000,   12000,  nan,  234.26,  nan ],
	[ nan,   14000,   14000,  nan,  361.08,  nan ],
	[ nan,   16000,   16000,  nan,  505.16,  nan ],
	[ nan,   18000,   18000,  nan,  718.19,  nan ],
	[ nan,   20000,   20000,  nan,  924.63,  nan ],
	[ nan,     300,     100,  nan,    0.04,  nan ],
	[ nan,     600,     200,  nan,    0.10,  nan ],
	[ nan,     900,     300,  nan,    0.10,  nan ],
	[ nan,    1200,     400,  nan,    0.18,  nan ],
	[ nan,    1500,     500,  nan,    0.22,  nan ],
	[ nan,    1800,     600,  nan,    0.34,  nan ],
	[ nan,    2100,     700,  nan,    0.48,  nan ],
	[ nan,    2400,     800,  nan,    0.56,  nan ],
	[ nan,    2700,     900,  nan,    0.73,  nan ],
	[ nan,    3000,    1000,  nan,    0.99,  nan ],
	[ nan,    6000,    2000,  nan,    4.82,  nan ],
	[ nan,    9000,    3000,  nan,   12.88,  nan ],
	[ nan,   12000,    4000,  nan,   27.43,  nan ],
	[ nan,   15000,    5000,  nan,   46.47,  nan ],
	[ nan,   18000,    6000,  nan,   78.11,  nan ],
	[ nan,   21000,    7000,  nan,  117.80,  nan ],
	[ nan,   24000,    8000,  nan,  158.32,  nan ],
	[ nan,   27000,    9000,  nan,  228.24,  nan ],
	[ nan,     100,     300,  nan,    0.02,  nan ],
	[ nan,     200,     600,  nan,    0.08,  nan ],
	[ nan,     300,     900,  nan,    0.09,  nan ],
	[ nan,     400,    1200,  nan,    0.16,  nan ],
	[ nan,     500,    1500,  nan,    0.25,  nan ],
	[ nan,     600,    1800,  nan,    0.39,  nan ],
	[ nan,     700,    2100,  nan,    0.52,  nan ],
	[ nan,     800,    2400,  nan,    0.68,  nan ],
	[ nan,     900,    2700,  nan,    0.83,  nan ],
	[ nan,    1000,    3000,  nan,    1.11,  nan ],
	[ nan,    2000,    6000,  nan,    6.02,  nan ],
	[ nan,    3000,    9000,  nan,   15.63,  nan ],
	[ nan,    4000,   12000,  nan,   31.95,  nan ],
	[ nan,    5000,   15000,  nan,   55.06,  nan ],
	[ nan,    6000,   18000,  nan,  101.32,  nan ],
	[ nan,    7000,   21000,  nan,  139.57,  nan ],
	[ nan,    8000,   24000,  nan,  272.79,  nan ],
	[ nan,    9000,   27000,  nan,  289.58,  nan ],
	[ nan,   10000,     100,  nan,    0.07,  nan ],
	[ nan,   20000,     200,  nan,    0.29,  nan ],
	[ nan,   30000,     300,  nan,    0.47,  nan ],
	[ nan,   40000,     400,  nan,    1.23,  nan ],
	[ nan,   50000,     500,  nan,    1.79,  nan ],
	[ nan,   60000,     600,  nan,    2.65,  nan ],
	[ nan,   70000,     700,  nan,    3.98,  nan ],
	[ nan,   80000,     800,  nan,    5.43,  nan ],
	[ nan,   90000,     900,  nan,    8.07,  nan ],
	[ nan,  100000,    1000,  nan,   10.53,  nan ],
	[ nan,  200000,    2000,  nan,   72.33,  nan ],
	[ nan,     100,   10000,  nan,    0.06,  nan ],
	[ nan,     200,   20000,  nan,    0.39,  nan ],
	[ nan,     300,   30000,  nan,    0.62,  nan ],
	[ nan,     400,   40000,  nan,    1.17,  nan ],
	[ nan,     500,   50000,  nan,    3.24,  nan ],
	[ nan,     600,   60000,  nan,    4.11,  nan ],
	[ nan,     700,   70000,  nan,    5.45,  nan ],
	[ nan,     800,   80000,  nan,    7.34,  nan ],
	[ nan,     900,   90000,  nan,    8.96,  nan ],
	[ nan,    1000,  100000,  nan,   14.89,  nan ],
	[ nan,    2000,  200000,  nan,  100.00,  nan ],
])

# numactl --interleave=all ./testing_dgesdd -UN -VN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
dgesdd_UN = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.01,  nan ],
	[ nan,     300,     300,  nan,    0.03,  nan ],
	[ nan,     400,     400,  nan,    0.05,  nan ],
	[ nan,     500,     500,  nan,    0.07,  nan ],
	[ nan,     600,     600,  nan,    0.09,  nan ],
	[ nan,     700,     700,  nan,    0.12,  nan ],
	[ nan,     800,     800,  nan,    0.15,  nan ],
	[ nan,     900,     900,  nan,    0.19,  nan ],
	[ nan,    1000,    1000,  nan,    0.23,  nan ],
	[ nan,    2000,    2000,  nan,    0.91,  nan ],
	[ nan,    3000,    3000,  nan,    2.35,  nan ],
	[ nan,    4000,    4000,  nan,    4.73,  nan ],
	[ nan,    5000,    5000,  nan,    8.37,  nan ],
	[ nan,    6000,    6000,  nan,   13.39,  nan ],
	[ nan,    7000,    7000,  nan,   20.14,  nan ],
	[ nan,    8000,    8000,  nan,   28.75,  nan ],
	[ nan,    9000,    9000,  nan,   39.93,  nan ],
	[ nan,   10000,   10000,  nan,   53.33,  nan ],
	[ nan,   12000,   12000,  nan,   88.78,  nan ],
	[ nan,   14000,   14000,  nan,  136.82,  nan ],
	[ nan,   16000,   16000,  nan,  201.80,  nan ],
	[ nan,   18000,   18000,  nan,  285.32,  nan ],
	[ nan,   20000,   20000,  nan,  385.63,  nan ],
	[ nan,     300,     100,  nan,    0.00,  nan ],
	[ nan,     600,     200,  nan,    0.02,  nan ],
	[ nan,     900,     300,  nan,    0.03,  nan ],
	[ nan,    1200,     400,  nan,    0.06,  nan ],
	[ nan,    1500,     500,  nan,    0.08,  nan ],
	[ nan,    1800,     600,  nan,    0.12,  nan ],
	[ nan,    2100,     700,  nan,    0.15,  nan ],
	[ nan,    2400,     800,  nan,    0.20,  nan ],
	[ nan,    2700,     900,  nan,    0.25,  nan ],
	[ nan,    3000,    1000,  nan,    0.31,  nan ],
	[ nan,    6000,    2000,  nan,    1.39,  nan ],
	[ nan,    9000,    3000,  nan,    3.34,  nan ],
	[ nan,   12000,    4000,  nan,    6.83,  nan ],
	[ nan,   15000,    5000,  nan,   12.18,  nan ],
	[ nan,   18000,    6000,  nan,   19.68,  nan ],
	[ nan,   21000,    7000,  nan,   29.76,  nan ],
	[ nan,   24000,    8000,  nan,   43.26,  nan ],
	[ nan,   27000,    9000,  nan,   59.81,  nan ],
	[ nan,     100,     300,  nan,    0.00,  nan ],
	[ nan,     200,     600,  nan,    0.02,  nan ],
	[ nan,     300,     900,  nan,    0.04,  nan ],
	[ nan,     400,    1200,  nan,    0.06,  nan ],
	[ nan,     500,    1500,  nan,    0.10,  nan ],
	[ nan,     600,    1800,  nan,    0.13,  nan ],
	[ nan,     700,    2100,  nan,    0.17,  nan ],
	[ nan,     800,    2400,  nan,    0.21,  nan ],
	[ nan,     900,    2700,  nan,    0.27,  nan ],
	[ nan,    1000,    3000,  nan,    0.32,  nan ],
	[ nan,    2000,    6000,  nan,    1.35,  nan ],
	[ nan,    3000,    9000,  nan,    3.57,  nan ],
	[ nan,    4000,   12000,  nan,    7.31,  nan ],
	[ nan,    5000,   15000,  nan,   12.97,  nan ],
	[ nan,    6000,   18000,  nan,   21.20,  nan ],
	[ nan,    7000,   21000,  nan,   31.85,  nan ],
	[ nan,    8000,   24000,  nan,   45.32,  nan ],
	[ nan,    9000,   27000,  nan,   62.50,  nan ],
	[ nan,   10000,     100,  nan,    0.01,  nan ],
	[ nan,   20000,     200,  nan,    0.06,  nan ],
	[ nan,   30000,     300,  nan,    0.15,  nan ],
	[ nan,   40000,     400,  nan,    0.38,  nan ],
	[ nan,   50000,     500,  nan,    0.61,  nan ],
	[ nan,   60000,     600,  nan,    0.93,  nan ],
	[ nan,   70000,     700,  nan,    1.30,  nan ],
	[ nan,   80000,     800,  nan,    1.77,  nan ],
	[ nan,   90000,     900,  nan,    2.40,  nan ],
	[ nan,  100000,    1000,  nan,    3.25,  nan ],
	[ nan,  200000,    2000,  nan,   18.60,  nan ],
	[ nan,     100,   10000,  nan,    0.01,  nan ],
	[ nan,     200,   20000,  nan,    0.05,  nan ],
	[ nan,     300,   30000,  nan,    0.16,  nan ],
	[ nan,     400,   40000,  nan,    0.33,  nan ],
	[ nan,     500,   50000,  nan,    0.59,  nan ],
	[ nan,     600,   60000,  nan,    0.91,  nan ],
	[ nan,     700,   70000,  nan,    1.44,  nan ],
	[ nan,     800,   80000,  nan,    1.92,  nan ],
	[ nan,     900,   90000,  nan,    2.31,  nan ],
	[ nan,    1000,  100000,  nan,    2.98,  nan ],
	[ nan,    2000,  200000,  nan,   20.24,  nan ],
])

# numactl --interleave=all ./testing_dgesdd -US -VS -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
dgesdd_US = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.01,  nan ],
	[ nan,      80,      80,  nan,    0.01,  nan ],
	[ nan,      90,      90,  nan,    0.01,  nan ],
	[ nan,     100,     100,  nan,    0.01,  nan ],
	[ nan,     200,     200,  nan,    0.02,  nan ],
	[ nan,     300,     300,  nan,    0.05,  nan ],
	[ nan,     400,     400,  nan,    0.08,  nan ],
	[ nan,     500,     500,  nan,    0.13,  nan ],
	[ nan,     600,     600,  nan,    0.18,  nan ],
	[ nan,     700,     700,  nan,    0.23,  nan ],
	[ nan,     800,     800,  nan,    0.30,  nan ],
	[ nan,     900,     900,  nan,    0.38,  nan ],
	[ nan,    1000,    1000,  nan,    0.48,  nan ],
	[ nan,    2000,    2000,  nan,    1.92,  nan ],
	[ nan,    3000,    3000,  nan,    5.59,  nan ],
	[ nan,    4000,    4000,  nan,    8.84,  nan ],
	[ nan,    5000,    5000,  nan,   14.96,  nan ],
	[ nan,    6000,    6000,  nan,   23.32,  nan ],
	[ nan,    7000,    7000,  nan,   34.05,  nan ],
	[ nan,    8000,    8000,  nan,   47.88,  nan ],
	[ nan,    9000,    9000,  nan,   64.61,  nan ],
	[ nan,   10000,   10000,  nan,   85.09,  nan ],
	[ nan,   12000,   12000,  nan,  137.52,  nan ],
	[ nan,   14000,   14000,  nan,  206.75,  nan ],
	[ nan,   16000,   16000,  nan,  302.89,  nan ],
	[ nan,   18000,   18000,  nan,  414.03,  nan ],
	[ nan,   20000,   20000,  nan,  552.59,  nan ],
	[ nan,     300,     100,  nan,    0.01,  nan ],
	[ nan,     600,     200,  nan,    0.03,  nan ],
	[ nan,     900,     300,  nan,    0.06,  nan ],
	[ nan,    1200,     400,  nan,    0.10,  nan ],
	[ nan,    1500,     500,  nan,    0.16,  nan ],
	[ nan,    1800,     600,  nan,    0.21,  nan ],
	[ nan,    2100,     700,  nan,    0.30,  nan ],
	[ nan,    2400,     800,  nan,    0.37,  nan ],
	[ nan,    2700,     900,  nan,    0.48,  nan ],
	[ nan,    3000,    1000,  nan,    0.62,  nan ],
	[ nan,    6000,    2000,  nan,    2.68,  nan ],
	[ nan,    9000,    3000,  nan,    6.93,  nan ],
	[ nan,   12000,    4000,  nan,   13.88,  nan ],
	[ nan,   15000,    5000,  nan,   24.22,  nan ],
	[ nan,   18000,    6000,  nan,   39.57,  nan ],
	[ nan,   21000,    7000,  nan,   58.84,  nan ],
	[ nan,   24000,    8000,  nan,   84.25,  nan ],
	[ nan,   27000,    9000,  nan,  114.81,  nan ],
	[ nan,     100,     300,  nan,    0.01,  nan ],
	[ nan,     200,     600,  nan,    0.03,  nan ],
	[ nan,     300,     900,  nan,    0.07,  nan ],
	[ nan,     400,    1200,  nan,    0.11,  nan ],
	[ nan,     500,    1500,  nan,    0.17,  nan ],
	[ nan,     600,    1800,  nan,    0.23,  nan ],
	[ nan,     700,    2100,  nan,    0.33,  nan ],
	[ nan,     800,    2400,  nan,    0.40,  nan ],
	[ nan,     900,    2700,  nan,    0.51,  nan ],
	[ nan,    1000,    3000,  nan,    0.64,  nan ],
	[ nan,    2000,    6000,  nan,    3.24,  nan ],
	[ nan,    3000,    9000,  nan,    7.45,  nan ],
	[ nan,    4000,   12000,  nan,   14.28,  nan ],
	[ nan,    5000,   15000,  nan,   24.86,  nan ],
	[ nan,    6000,   18000,  nan,   41.14,  nan ],
	[ nan,    7000,   21000,  nan,   61.94,  nan ],
	[ nan,    8000,   24000,  nan,   86.26,  nan ],
	[ nan,    9000,   27000,  nan,  117.24,  nan ],
	[ nan,   10000,     100,  nan,    0.03,  nan ],
	[ nan,   20000,     200,  nan,    0.18,  nan ],
	[ nan,   30000,     300,  nan,    0.32,  nan ],
	[ nan,   40000,     400,  nan,    0.64,  nan ],
	[ nan,   50000,     500,  nan,    1.55,  nan ],
	[ nan,   60000,     600,  nan,    1.95,  nan ],
	[ nan,   70000,     700,  nan,    2.49,  nan ],
	[ nan,   80000,     800,  nan,    3.13,  nan ],
	[ nan,   90000,     900,  nan,    4.08,  nan ],
	[ nan,  100000,    1000,  nan,    6.83,  nan ],
	[ nan,  200000,    2000,  nan,   36.24,  nan ],
	[ nan,     100,   10000,  nan,    0.04,  nan ],
	[ nan,     200,   20000,  nan,    0.25,  nan ],
	[ nan,     300,   30000,  nan,    0.48,  nan ],
	[ nan,     400,   40000,  nan,    0.82,  nan ],
	[ nan,     500,   50000,  nan,    2.82,  nan ],
	[ nan,     600,   60000,  nan,    3.20,  nan ],
	[ nan,     700,   70000,  nan,    5.06,  nan ],
	[ nan,     800,   80000,  nan,    4.80,  nan ],
	[ nan,     900,   90000,  nan,    6.14,  nan ],
	[ nan,    1000,  100000,  nan,   10.03,  nan ],
	[ nan,    2000,  200000,  nan,   42.18,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/dgetrf.txt
# numactl --interleave=all ./testing_dgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgetrf = array([
	[    10,     10,  nan,  nan,    0.03,  0.00,  nan ],
	[    20,     20,  nan,  nan,    0.16,  0.00,  nan ],
	[    30,     30,  nan,  nan,    0.27,  0.00,  nan ],
	[    40,     40,  nan,  nan,    0.65,  0.00,  nan ],
	[    50,     50,  nan,  nan,    0.88,  0.00,  nan ],
	[    60,     60,  nan,  nan,    1.25,  0.00,  nan ],
	[    70,     70,  nan,  nan,    1.56,  0.00,  nan ],
	[    80,     80,  nan,  nan,    2.11,  0.00,  nan ],
	[    90,     90,  nan,  nan,    2.66,  0.00,  nan ],
	[   100,    100,  nan,  nan,    3.39,  0.00,  nan ],
	[   200,    200,  nan,  nan,    3.64,  0.00,  nan ],
	[   300,    300,  nan,  nan,    8.18,  0.00,  nan ],
	[   400,    400,  nan,  nan,   13.61,  0.00,  nan ],
	[   500,    500,  nan,  nan,   20.78,  0.00,  nan ],
	[   600,    600,  nan,  nan,   27.95,  0.01,  nan ],
	[   700,    700,  nan,  nan,   34.96,  0.01,  nan ],
	[   800,    800,  nan,  nan,   43.26,  0.01,  nan ],
	[   900,    900,  nan,  nan,   50.68,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   59.98,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,  149.36,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,  243.92,  0.07,  nan ],
	[  4000,   4000,  nan,  nan,  329.38,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,  423.25,  0.20,  nan ],
	[  6000,   6000,  nan,  nan,  507.92,  0.28,  nan ],
	[  7000,   7000,  nan,  nan,  585.92,  0.39,  nan ],
	[  8000,   8000,  nan,  nan,  645.88,  0.53,  nan ],
	[  9000,   9000,  nan,  nan,  689.11,  0.71,  nan ],
	[ 10000,  10000,  nan,  nan,  732.19,  0.91,  nan ],
	[ 12000,  12000,  nan,  nan,  801.39,  1.44,  nan ],
	[ 14000,  14000,  nan,  nan,  849.90,  2.15,  nan ],
	[ 16000,  16000,  nan,  nan,  887.67,  3.08,  nan ],
	[ 18000,  18000,  nan,  nan,  916.90,  4.24,  nan ],
	[ 20000,  20000,  nan,  nan,  942.07,  5.66,  nan ],
])

# numactl --interleave=all ./testing_dgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.09,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.19,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.48,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.71,  0.00,  nan ],
	[    60,     60,  nan,  nan,     1.06,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.13,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.62,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.85,  0.00,  nan ],
	[   100,    100,  nan,  nan,     2.06,  0.00,  nan ],
	[   200,    200,  nan,  nan,     2.60,  0.00,  nan ],
	[   300,    300,  nan,  nan,     6.64,  0.00,  nan ],
	[   400,    400,  nan,  nan,    12.08,  0.00,  nan ],
	[   500,    500,  nan,  nan,    18.94,  0.00,  nan ],
	[   600,    600,  nan,  nan,    26.94,  0.01,  nan ],
	[   700,    700,  nan,  nan,    35.93,  0.01,  nan ],
	[   800,    800,  nan,  nan,    45.45,  0.01,  nan ],
	[   900,    900,  nan,  nan,    54.81,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    63.56,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   175.77,  0.03,  nan ],
	[  3000,   3000,  nan,  nan,   299.53,  0.06,  nan ],
	[  4000,   4000,  nan,  nan,   396.98,  0.11,  nan ],
	[  5000,   5000,  nan,  nan,   517.63,  0.16,  nan ],
	[  6000,   6000,  nan,  nan,   624.88,  0.23,  nan ],
	[  7000,   7000,  nan,  nan,   709.62,  0.32,  nan ],
	[  8000,   8000,  nan,  nan,   775.59,  0.44,  nan ],
	[  9000,   9000,  nan,  nan,   789.00,  0.62,  nan ],
	[ 10000,  10000,  nan,  nan,   837.81,  0.80,  nan ],
	[ 12000,  12000,  nan,  nan,   919.89,  1.25,  nan ],
	[ 14000,  14000,  nan,  nan,   976.29,  1.87,  nan ],
	[ 16000,  16000,  nan,  nan,  1008.44,  2.71,  nan ],
	[ 18000,  18000,  nan,  nan,  1027.63,  3.78,  nan ],
	[ 20000,  20000,  nan,  nan,  1046.16,  5.10,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/dpotrf.txt
# numactl --interleave=all ./testing_dpotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dpotrf = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,  nan,  nan,     0.43,  0.00,  nan ],
	[    50,  nan,  nan,     0.78,  0.00,  nan ],
	[    60,  nan,  nan,     1.17,  0.00,  nan ],
	[    70,  nan,  nan,     1.12,  0.00,  nan ],
	[    80,  nan,  nan,     1.60,  0.00,  nan ],
	[    90,  nan,  nan,     0.61,  0.00,  nan ],
	[   100,  nan,  nan,     0.79,  0.00,  nan ],
	[   200,  nan,  nan,     5.21,  0.00,  nan ],
	[   300,  nan,  nan,     5.35,  0.00,  nan ],
	[   400,  nan,  nan,    10.32,  0.00,  nan ],
	[   500,  nan,  nan,    17.48,  0.00,  nan ],
	[   600,  nan,  nan,    20.77,  0.00,  nan ],
	[   700,  nan,  nan,    28.51,  0.00,  nan ],
	[   800,  nan,  nan,    33.17,  0.01,  nan ],
	[   900,  nan,  nan,    42.04,  0.01,  nan ],
	[  1000,  nan,  nan,    54.57,  0.01,  nan ],
	[  2000,  nan,  nan,   172.74,  0.02,  nan ],
	[  3000,  nan,  nan,   304.93,  0.03,  nan ],
	[  4000,  nan,  nan,   485.42,  0.04,  nan ],
	[  5000,  nan,  nan,   574.53,  0.07,  nan ],
	[  6000,  nan,  nan,   668.13,  0.11,  nan ],
	[  7000,  nan,  nan,   723.38,  0.16,  nan ],
	[  8000,  nan,  nan,   786.98,  0.22,  nan ],
	[  9000,  nan,  nan,   827.85,  0.29,  nan ],
	[ 10000,  nan,  nan,   859.69,  0.39,  nan ],
	[ 12000,  nan,  nan,   930.60,  0.62,  nan ],
	[ 14000,  nan,  nan,   980.75,  0.93,  nan ],
	[ 16000,  nan,  nan,  1021.07,  1.34,  nan ],
	[ 18000,  nan,  nan,  1041.93,  1.87,  nan ],
	[ 20000,  nan,  nan,  1070.15,  2.49,  nan ],
])

# numactl --interleave=all ./testing_dpotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.02,  0.00,  nan ],
	[    50,  nan,  nan,     0.04,  0.00,  nan ],
	[    60,  nan,  nan,     0.06,  0.00,  nan ],
	[    70,  nan,  nan,     0.09,  0.00,  nan ],
	[    80,  nan,  nan,     0.14,  0.00,  nan ],
	[    90,  nan,  nan,     0.19,  0.00,  nan ],
	[   100,  nan,  nan,     0.24,  0.00,  nan ],
	[   200,  nan,  nan,     7.26,  0.00,  nan ],
	[   300,  nan,  nan,     3.55,  0.00,  nan ],
	[   400,  nan,  nan,     7.02,  0.00,  nan ],
	[   500,  nan,  nan,    12.70,  0.00,  nan ],
	[   600,  nan,  nan,    16.31,  0.00,  nan ],
	[   700,  nan,  nan,    24.13,  0.00,  nan ],
	[   800,  nan,  nan,    28.65,  0.01,  nan ],
	[   900,  nan,  nan,    37.23,  0.01,  nan ],
	[  1000,  nan,  nan,    49.58,  0.01,  nan ],
	[  2000,  nan,  nan,   179.61,  0.01,  nan ],
	[  3000,  nan,  nan,   339.19,  0.03,  nan ],
	[  4000,  nan,  nan,   564.63,  0.04,  nan ],
	[  5000,  nan,  nan,   674.93,  0.06,  nan ],
	[  6000,  nan,  nan,   789.98,  0.09,  nan ],
	[  7000,  nan,  nan,   839.24,  0.14,  nan ],
	[  8000,  nan,  nan,   924.44,  0.18,  nan ],
	[  9000,  nan,  nan,   959.69,  0.25,  nan ],
	[ 10000,  nan,  nan,   991.06,  0.34,  nan ],
	[ 12000,  nan,  nan,  1050.65,  0.55,  nan ],
	[ 14000,  nan,  nan,  1094.66,  0.84,  nan ],
	[ 16000,  nan,  nan,  1126.74,  1.21,  nan ],
	[ 18000,  nan,  nan,  1137.74,  1.71,  nan ],
	[ 20000,  nan,  nan,  1158.20,  2.30,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/dsyevd.txt
# numactl --interleave=all ./testing_dsyevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_JN = array([
	[    10,  nan,    0.0000 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0002 ],
	[    60,  nan,    0.0003 ],
	[    70,  nan,    0.0004 ],
	[    80,  nan,    0.0006 ],
	[    90,  nan,    0.0008 ],
	[   100,  nan,    0.0011 ],
	[   200,  nan,    0.0128 ],
	[   300,  nan,    0.0231 ],
	[   400,  nan,    0.0393 ],
	[   500,  nan,    0.0544 ],
	[   600,  nan,    0.0755 ],
	[   700,  nan,    0.0954 ],
	[   800,  nan,    0.1220 ],
	[   900,  nan,    0.1502 ],
	[  1000,  nan,    0.1776 ],
	[  2000,  nan,    0.5980 ],
	[  3000,  nan,    1.3180 ],
	[  4000,  nan,    2.3626 ],
	[  5000,  nan,    3.8870 ],
	[  6000,  nan,    5.7710 ],
	[  7000,  nan,    8.1626 ],
	[  8000,  nan,   11.0315 ],
	[  9000,  nan,   14.6957 ],
	[ 10000,  nan,   19.0375 ],
	[ 12000,  nan,   30.2727 ],
	[ 14000,  nan,   44.6141 ],
	[ 16000,  nan,   63.2342 ],
	[ 18000,  nan,   87.2691 ],
	[ 20000,  nan,  114.5946 ],
])

# numactl --interleave=all ./testing_dsyevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_JV = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0003 ],
	[    40,  nan,    0.0004 ],
	[    50,  nan,    0.0005 ],
	[    60,  nan,    0.0007 ],
	[    70,  nan,    0.0009 ],
	[    80,  nan,    0.0012 ],
	[    90,  nan,    0.0016 ],
	[   100,  nan,    0.0020 ],
	[   200,  nan,    0.0164 ],
	[   300,  nan,    0.0268 ],
	[   400,  nan,    0.0441 ],
	[   500,  nan,    0.0617 ],
	[   600,  nan,    0.0784 ],
	[   700,  nan,    0.1002 ],
	[   800,  nan,    0.1273 ],
	[   900,  nan,    0.1599 ],
	[  1000,  nan,    0.1884 ],
	[  2000,  nan,    0.6370 ],
	[  3000,  nan,    1.4418 ],
	[  4000,  nan,    2.5225 ],
	[  5000,  nan,    4.0450 ],
	[  6000,  nan,    6.1427 ],
	[  7000,  nan,    8.8017 ],
	[  8000,  nan,   12.1769 ],
	[  9000,  nan,   16.1912 ],
	[ 10000,  nan,   21.2096 ],
	[ 12000,  nan,   34.1056 ],
	[ 14000,  nan,   49.1354 ],
	[ 16000,  nan,   70.6249 ],
	[ 18000,  nan,   98.2735 ],
	[ 20000,  nan,  130.3086 ],
])

# numactl --interleave=all ./testing_dsyevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_gpu_JN = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0002 ],
	[    60,  nan,    0.0003 ],
	[    70,  nan,    0.0005 ],
	[    80,  nan,    0.0006 ],
	[    90,  nan,    0.0008 ],
	[   100,  nan,    0.0011 ],
	[   200,  nan,    0.0114 ],
	[   300,  nan,    0.0208 ],
	[   400,  nan,    0.0354 ],
	[   500,  nan,    0.0492 ],
	[   600,  nan,    0.0687 ],
	[   700,  nan,    0.0880 ],
	[   800,  nan,    0.1129 ],
	[   900,  nan,    0.1399 ],
	[  1000,  nan,    0.1666 ],
	[  2000,  nan,    0.5797 ],
	[  3000,  nan,    1.3182 ],
	[  4000,  nan,    2.3436 ],
	[  5000,  nan,    3.8155 ],
	[  6000,  nan,    5.6934 ],
	[  7000,  nan,    8.1011 ],
	[  8000,  nan,   11.0384 ],
	[  9000,  nan,   14.7141 ],
	[ 10000,  nan,   18.9900 ],
	[ 12000,  nan,   30.3040 ],
	[ 14000,  nan,   44.5872 ],
	[ 16000,  nan,   63.3596 ],
	[ 18000,  nan,   87.1945 ],
	[ 20000,  nan,  114.6432 ],
])

# numactl --interleave=all ./testing_dsyevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_gpu_JV = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0003 ],
	[    40,  nan,    0.0004 ],
	[    50,  nan,    0.0006 ],
	[    60,  nan,    0.0009 ],
	[    70,  nan,    0.0010 ],
	[    80,  nan,    0.0013 ],
	[    90,  nan,    0.0018 ],
	[   100,  nan,    0.0021 ],
	[   200,  nan,    0.0155 ],
	[   300,  nan,    0.0255 ],
	[   400,  nan,    0.0422 ],
	[   500,  nan,    0.0592 ],
	[   600,  nan,    0.0752 ],
	[   700,  nan,    0.0993 ],
	[   800,  nan,    0.1229 ],
	[   900,  nan,    0.1558 ],
	[  1000,  nan,    0.1836 ],
	[  2000,  nan,    0.6367 ],
	[  3000,  nan,    1.3501 ],
	[  4000,  nan,    2.4675 ],
	[  5000,  nan,    3.9757 ],
	[  6000,  nan,    6.1173 ],
	[  7000,  nan,    8.8302 ],
	[  8000,  nan,   12.3120 ],
	[  9000,  nan,   16.4472 ],
	[ 10000,  nan,   22.3377 ],
	[ 12000,  nan,   35.1828 ],
	[ 14000,  nan,   52.9599 ],
	[ 16000,  nan,   76.0177 ],
	[ 18000,  nan,  105.7984 ],
	[ 20000,  nan,  142.2281 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/dsyevd_2stage.txt
# numactl --interleave=all ./testing_dsyevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevdx_2stage_JN = array([
	[    10,      0,   0.0002 ],
	[    20,      0,   0.0000 ],
	[    30,      0,   0.0000 ],
	[    40,      0,   0.0000 ],
	[    50,      0,   0.0000 ],
	[    60,      0,   0.0000 ],
	[    70,     70,   0.0004 ],
	[    80,     80,   0.0005 ],
	[    90,     90,   0.0007 ],
	[   100,    100,   0.0009 ],
	[   200,    200,   0.0042 ],
	[   300,    300,   0.0245 ],
	[   400,    400,   0.0463 ],
	[   500,    500,   0.0487 ],
	[   600,    600,   0.0815 ],
	[   700,    700,   0.1056 ],
	[   800,    800,   0.1401 ],
	[   900,    900,   0.1503 ],
	[  1000,   1000,   0.1824 ],
	[  2000,   2000,   0.6132 ],
	[  3000,   3000,   1.0271 ],
	[  4000,   4000,   1.5903 ],
	[  5000,   5000,   2.1931 ],
	[  6000,   6000,   2.9508 ],
	[  7000,   7000,   3.9075 ],
	[  8000,   8000,   4.9290 ],
	[  9000,   9000,   6.2685 ],
	[ 10000,  10000,   7.7161 ],
	[ 12000,  12000,  10.5474 ],
	[ 14000,  14000,  14.8071 ],
	[ 16000,  16000,  19.2503 ],
	[ 18000,  18000,  28.0243 ],
	[ 20000,  20000,  32.2358 ],
])

# numactl --interleave=all ./testing_dsyevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevdx_2stage_JV = array([
	[    10,     10,   0.0001 ],
	[    20,     20,   0.0001 ],
	[    30,     30,   0.0003 ],
	[    40,     40,   0.0004 ],
	[    50,     50,   0.0005 ],
	[    60,     60,   0.0007 ],
	[    70,     70,   0.0009 ],
	[    80,     80,   0.0012 ],
	[    90,     90,   0.0016 ],
	[   100,    100,   0.0019 ],
	[   200,    200,   0.0075 ],
	[   300,    300,   0.0289 ],
	[   400,    400,   0.0480 ],
	[   500,    500,   0.0937 ],
	[   600,    600,   0.0977 ],
	[   700,    700,   0.1251 ],
	[   800,    800,   0.1576 ],
	[   900,    900,   0.2928 ],
	[  1000,   1000,   0.2289 ],
	[  2000,   2000,   0.7339 ],
	[  3000,   3000,   1.2198 ],
	[  4000,   4000,   2.0875 ],
	[  5000,   5000,   3.2698 ],
	[  6000,   6000,   4.8135 ],
	[  7000,   7000,   6.3343 ],
	[  8000,   8000,   8.8363 ],
	[  9000,   9000,  11.7228 ],
	[ 10000,  10000,  14.6346 ],
	[ 12000,  12000,  24.3806 ],
	[ 14000,  14000,  36.2935 ],
	[ 16000,  16000,  53.0486 ],
	[ 18000,  18000,  66.8810 ],
	[ 20000,  20000,  88.8894 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/dsymv.txt
# numactl --interleave=all ./testing_dsymv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
dsymv_L = array([
	[    10,   0.0058,   0.0379,   0.0082,   0.0269,   0.0095,   0.0231,   0.1153,   0.0019,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    11,   0.0075,   0.0350,   0.0102,   0.0260,   0.0120,   0.0219,   0.1230,   0.0021,  8.07e-17,  8.07e-17,  8.07e-17,  nan ],
	[    12,   0.0087,   0.0360,   0.0120,   0.0260,   0.0149,   0.0210,   0.1636,   0.0019,  7.40e-17,  7.40e-17,  7.40e-17,  nan ],
	[    13,   0.0098,   0.0370,   0.0140,   0.0260,   0.0166,   0.0219,   0.1696,   0.0021,  6.83e-17,  1.37e-16,  6.83e-17,  nan ],
	[    14,   0.0127,   0.0331,   0.0168,   0.0250,   0.0210,   0.0200,   0.1957,   0.0021,  1.27e-16,  1.27e-16,  1.27e-16,  nan ],
	[    15,   0.0137,   0.0350,   0.0185,   0.0260,   0.0229,   0.0210,   0.2517,   0.0019,  5.92e-17,  5.92e-17,  5.92e-17,  nan ],
	[    16,   0.0156,   0.0348,   0.0209,   0.0260,   0.0248,   0.0219,   0.1755,   0.0031,  1.11e-16,  1.11e-16,  5.55e-17,  nan ],
	[    17,   0.0185,   0.0331,   0.0244,   0.0250,   0.0306,   0.0200,   0.3209,   0.0019,  1.04e-16,  1.04e-16,  2.09e-16,  nan ],
	[    18,   0.0206,   0.0331,   0.0263,   0.0260,   0.0322,   0.0212,   0.3586,   0.0019,  9.87e-17,  9.87e-17,  9.87e-17,  nan ],
	[    19,   0.0213,   0.0358,   0.0292,   0.0260,   0.0362,   0.0210,   0.3985,   0.0019,  1.40e-16,  9.35e-17,  1.40e-16,  nan ],
	[    20,   0.0248,   0.0339,   0.0323,   0.0260,   0.0400,   0.0210,   0.3915,   0.0021,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    21,   0.0273,   0.0339,   0.0356,   0.0260,   0.0440,   0.0210,   0.3230,   0.0029,  8.46e-17,  1.27e-16,  1.69e-16,  nan ],
	[    22,   0.0247,   0.0410,   0.0360,   0.0281,   0.0461,   0.0219,   0.3537,   0.0029,  8.07e-17,  8.07e-17,  8.07e-17,  nan ],
	[    23,   0.0299,   0.0370,   0.0396,   0.0279,   0.0498,   0.0222,   0.3562,   0.0031,  7.72e-17,  1.16e-16,  1.16e-16,  nan ],
	[    24,   0.0323,   0.0372,   0.0427,   0.0281,   0.0541,   0.0222,   0.3872,   0.0031,  1.11e-16,  7.40e-17,  1.11e-16,  nan ],
	[    25,   0.0371,   0.0350,   0.0483,   0.0269,   0.0568,   0.0229,   0.4544,   0.0029,  1.42e-16,  1.42e-16,  7.11e-17,  nan ],
	[    26,   0.0415,   0.0339,   0.0499,   0.0281,   0.0640,   0.0219,   0.4907,   0.0029,  1.37e-16,  1.37e-16,  1.37e-16,  nan ],
	[    27,   0.0409,   0.0370,   0.0542,   0.0279,   0.0689,   0.0219,   0.5285,   0.0029,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    28,   0.0439,   0.0370,   0.0603,   0.0269,   0.0710,   0.0229,   0.8514,   0.0019,  1.90e-16,  1.27e-16,  1.27e-16,  nan ],
	[    29,   0.0496,   0.0350,   0.0624,   0.0279,   0.0760,   0.0229,   0.6082,   0.0029,  1.84e-16,  1.84e-16,  1.23e-16,  nan ],
	[    30,   0.0503,   0.0370,   0.0667,   0.0279,   0.0804,   0.0231,   0.6001,   0.0031,  5.92e-17,  1.18e-16,  1.18e-16,  nan ],
	[    31,   0.0537,   0.0370,   0.0711,   0.0279,   0.0858,   0.0231,   0.6935,   0.0029,  1.15e-16,  1.15e-16,  1.15e-16,  nan ],
	[    32,   0.0572,   0.0370,   0.0726,   0.0291,   0.0953,   0.0222,   0.6814,   0.0031,  1.67e-16,  1.11e-16,  1.67e-16,  nan ],
	[    33,   0.0623,   0.0360,   0.0623,   0.0360,   0.0941,   0.0238,   0.7240,   0.0031,  1.08e-16,  1.08e-16,  1.08e-16,  nan ],
	[    34,   0.0624,   0.0381,   0.0698,   0.0341,   0.1040,   0.0229,   0.7679,   0.0031,  2.09e-16,  1.57e-16,  1.04e-16,  nan ],
	[    35,   0.0682,   0.0370,   0.0744,   0.0339,   0.1046,   0.0241,   0.6217,   0.0041,  2.03e-16,  1.52e-16,  1.02e-16,  nan ],
	[    36,   0.0721,   0.0370,   0.0787,   0.0339,   0.1106,   0.0241,   0.9311,   0.0029,  9.87e-17,  9.87e-17,  1.48e-16,  nan ],
	[    37,   0.0761,   0.0370,   0.0855,   0.0329,   0.1216,   0.0231,   0.9073,   0.0031,  9.60e-17,  1.44e-16,  9.60e-17,  nan ],
	[    38,   0.0802,   0.0370,   0.0875,   0.0339,   0.1231,   0.0241,   0.9563,   0.0031,  1.87e-16,  1.40e-16,  1.40e-16,  nan ],
	[    39,   0.0890,   0.0350,   0.0948,   0.0329,   0.1309,   0.0238,   1.0066,   0.0031,  9.11e-17,  1.37e-16,  9.11e-17,  nan ],
	[    40,   0.0911,   0.0360,   0.0962,   0.0341,   0.1433,   0.0229,   1.1464,   0.0029,  1.78e-16,  1.33e-16,  1.33e-16,  nan ],
	[    41,   0.0983,   0.0350,   0.1017,   0.0339,   0.1376,   0.0250,   0.8497,   0.0041,  1.30e-16,  1.30e-16,  1.30e-16,  nan ],
	[    42,   0.0977,   0.0370,   0.1067,   0.0339,   0.1341,   0.0269,   0.9469,   0.0038,  1.69e-16,  1.27e-16,  1.27e-16,  nan ],
	[    43,   0.1080,   0.0350,   0.1118,   0.0339,   0.1571,   0.0241,   0.9336,   0.0041,  2.48e-16,  1.24e-16,  1.65e-16,  nan ],
	[    44,   0.1170,   0.0339,   0.1130,   0.0350,   0.1644,   0.0241,   1.0381,   0.0038,  1.61e-16,  1.61e-16,  1.61e-16,  nan ],
	[    45,   0.1181,   0.0350,   0.1065,   0.0389,   0.1654,   0.0250,   1.0214,   0.0041,  1.58e-16,  1.58e-16,  1.58e-16,  nan ],
	[    46,   0.1234,   0.0350,   0.1353,   0.0319,   0.1796,   0.0241,   1.0668,   0.0041,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    47,   0.1296,   0.0348,   0.1333,   0.0339,   0.1892,   0.0238,   1.1132,   0.0041,  1.51e-16,  1.51e-16,  1.13e-16,  nan ],
	[    48,   0.1342,   0.0350,   0.1430,   0.0329,   0.2055,   0.0229,   1.1606,   0.0041,  1.48e-16,  1.48e-16,  1.48e-16,  nan ],
	[    49,   0.1447,   0.0339,   0.1489,   0.0329,   0.2055,   0.0238,   1.2089,   0.0041,  1.45e-16,  1.45e-16,  1.45e-16,  nan ],
	[    50,   0.1455,   0.0350,   0.1496,   0.0341,   0.2205,   0.0231,   1.2583,   0.0041,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[    51,   0.1513,   0.0350,   0.1567,   0.0339,   0.2203,   0.0241,   1.3086,   0.0041,  1.39e-16,  1.39e-16,  1.39e-16,  nan ],
	[    52,   0.1531,   0.0360,   0.1617,   0.0341,   0.2383,   0.0231,   1.3599,   0.0041,  2.05e-16,  1.37e-16,  1.37e-16,  nan ],
	[    53,   0.1679,   0.0341,   0.1691,   0.0339,   0.2401,   0.0238,   1.4122,   0.0041,  1.34e-16,  2.01e-16,  1.34e-16,  nan ],
	[    54,   0.1557,   0.0381,   0.1695,   0.0350,   0.2491,   0.0238,   1.1864,   0.0050,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    55,   0.1711,   0.0360,   0.1758,   0.0350,   0.2584,   0.0238,   1.6148,   0.0038,  1.94e-16,  1.94e-16,  1.29e-16,  nan ],
	[    56,   0.1872,   0.0341,   0.1872,   0.0341,   0.2651,   0.0241,   1.5751,   0.0041,  1.90e-16,  1.27e-16,  1.27e-16,  nan ],
	[    57,   0.1887,   0.0350,   0.1887,   0.0350,   0.2746,   0.0241,   1.6313,   0.0041,  1.25e-16,  1.87e-16,  1.87e-16,  nan ],
	[    58,   0.2022,   0.0339,   0.2007,   0.0341,   0.2959,   0.0231,   1.3669,   0.0050,  1.23e-16,  1.23e-16,  1.23e-16,  nan ],
	[    59,   0.2077,   0.0341,   0.1967,   0.0360,   0.2828,   0.0250,   1.4141,   0.0050,  1.20e-16,  1.81e-16,  1.20e-16,  nan ],
	[    60,   0.2103,   0.0348,   0.1981,   0.0370,   0.2817,   0.0260,   1.4620,   0.0050,  1.18e-16,  1.18e-16,  1.78e-16,  nan ],
	[    61,   0.2158,   0.0350,   0.2101,   0.0360,   0.3173,   0.0238,   1.5107,   0.0050,  1.75e-16,  2.33e-16,  2.91e-16,  nan ],
	[    62,   0.2170,   0.0360,   0.2170,   0.0360,   0.3244,   0.0241,   1.5603,   0.0050,  1.72e-16,  1.15e-16,  1.72e-16,  nan ],
	[    63,   0.2317,   0.0348,   0.2182,   0.0370,   0.3221,   0.0250,   1.6106,   0.0050,  1.13e-16,  1.69e-16,  2.26e-16,  nan ],
	[    64,   0.2251,   0.0370,   0.2458,   0.0339,   0.3323,   0.0250,   1.6617,   0.0050,  2.22e-16,  1.67e-16,  1.11e-16,  nan ],
	[    65,   0.1818,   0.0472,   0.2322,   0.0370,   0.3185,   0.0269,   1.7137,   0.0050,  2.73e-16,  2.19e-16,  3.28e-16,  nan ],
	[    66,   0.2157,   0.0410,   0.2393,   0.0370,   0.3144,   0.0281,   1.7664,   0.0050,  1.61e-16,  2.15e-16,  2.15e-16,  nan ],
	[    67,   0.2112,   0.0432,   0.2404,   0.0379,   0.3382,   0.0269,   1.5287,   0.0060,  1.59e-16,  1.59e-16,  1.59e-16,  nan ],
	[    68,   0.2128,   0.0441,   0.2539,   0.0370,   0.3483,   0.0269,   1.5744,   0.0060,  1.57e-16,  2.09e-16,  2.09e-16,  nan ],
	[    69,   0.2190,   0.0441,   0.2548,   0.0379,   0.3463,   0.0279,   1.6207,   0.0060,  2.06e-16,  2.06e-16,  2.06e-16,  nan ],
	[    70,   0.2316,   0.0429,   0.2673,   0.0372,   0.3657,   0.0272,   1.6677,   0.0060,  1.52e-16,  2.03e-16,  2.03e-16,  nan ],
	[    71,   0.2437,   0.0420,   0.2382,   0.0429,   0.3795,   0.0269,   1.7153,   0.0060,  3.00e-16,  2.50e-16,  2.50e-16,  nan ],
	[    72,   0.2505,   0.0420,   0.2756,   0.0381,   0.3902,   0.0269,   2.0995,   0.0050,  1.48e-16,  1.48e-16,  9.87e-17,  nan ],
	[    73,   0.2635,   0.0410,   0.2924,   0.0370,   0.3873,   0.0279,   1.7429,   0.0062,  1.46e-16,  1.46e-16,  1.46e-16,  nan ],
	[    74,   0.2530,   0.0439,   0.2928,   0.0379,   0.4084,   0.0272,   2.2170,   0.0050,  2.40e-16,  2.88e-16,  2.40e-16,  nan ],
	[    75,   0.2780,   0.0410,   0.3085,   0.0370,   0.4231,   0.0269,   1.5938,   0.0072,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[    76,   0.2854,   0.0410,   0.3087,   0.0379,   0.4344,   0.0269,   1.9636,   0.0060,  1.40e-16,  1.87e-16,  1.40e-16,  nan ],
	[    77,   0.2738,   0.0439,   0.3169,   0.0379,   0.4130,   0.0291,   2.0153,   0.0060,  1.85e-16,  1.85e-16,  2.31e-16,  nan ],
	[    78,   0.3095,   0.0398,   0.3423,   0.0360,   0.4534,   0.0272,   1.7824,   0.0069,  2.28e-16,  1.37e-16,  1.37e-16,  nan ],
	[    79,   0.3082,   0.0410,   0.3511,   0.0360,   0.4692,   0.0269,   1.7672,   0.0072,  1.80e-16,  1.80e-16,  1.80e-16,  nan ],
	[    80,   0.3335,   0.0389,   0.3600,   0.0360,   0.4607,   0.0281,   2.0907,   0.0062,  1.78e-16,  1.33e-16,  1.78e-16,  nan ],
	[    81,   0.3316,   0.0401,   0.3595,   0.0370,   0.4931,   0.0269,   2.6532,   0.0050,  1.75e-16,  1.75e-16,  1.75e-16,  nan ],
	[    82,   0.3244,   0.0420,   0.3781,   0.0360,   0.5052,   0.0269,   1.9687,   0.0069,  2.60e-16,  2.60e-16,  2.60e-16,  nan ],
	[    83,   0.3502,   0.0398,   0.3773,   0.0370,   0.5176,   0.0269,   2.0167,   0.0069,  1.71e-16,  2.57e-16,  1.71e-16,  nan ],
	[    84,   0.3309,   0.0432,   0.3675,   0.0389,   0.5076,   0.0281,   2.3958,   0.0060,  1.69e-16,  1.69e-16,  1.69e-16,  nan ],
	[    85,   0.3407,   0.0429,   0.3857,   0.0379,   0.5197,   0.0281,   2.1145,   0.0069,  2.51e-16,  2.51e-16,  2.51e-16,  nan ],
	[    86,   0.3649,   0.0410,   0.3947,   0.0379,   0.5364,   0.0279,   2.1643,   0.0069,  2.07e-16,  2.07e-16,  1.65e-16,  nan ],
	[    87,   0.3472,   0.0441,   0.4039,   0.0379,   0.5443,   0.0281,   1.8889,   0.0081,  2.04e-16,  2.04e-16,  2.04e-16,  nan ],
	[    88,   0.3650,   0.0429,   0.4006,   0.0391,   0.5615,   0.0279,   2.1900,   0.0072,  2.02e-16,  1.61e-16,  1.21e-16,  nan ],
	[    89,   0.3632,   0.0441,   0.4097,   0.0391,   0.5743,   0.0279,   2.2398,   0.0072,  2.00e-16,  3.19e-16,  1.60e-16,  nan ],
	[    90,   0.3714,   0.0441,   0.4321,   0.0379,   0.6080,   0.0269,   2.0207,   0.0081,  1.58e-16,  2.37e-16,  2.37e-16,  nan ],
	[   100,   0.4580,   0.0441,   0.5198,   0.0389,   0.6724,   0.0300,   2.9215,   0.0069,  2.13e-16,  1.42e-16,  2.13e-16,  nan ],
	[   110,   0.5335,   0.0458,   0.6245,   0.0391,   0.7879,   0.0310,   2.6954,   0.0091,  3.23e-16,  3.23e-16,  3.23e-16,  nan ],
	[   120,   0.6729,   0.0432,   0.7294,   0.0398,   0.9744,   0.0298,   3.5824,   0.0081,  3.55e-16,  4.74e-16,  3.55e-16,  nan ],
	[   130,   0.6969,   0.0489,   0.8117,   0.0420,   1.0661,   0.0319,   3.4014,   0.0100,  3.28e-16,  2.19e-16,  2.73e-16,  nan ],
	[   140,   0.8406,   0.0470,   0.9627,   0.0410,   1.2738,   0.0310,   4.4754,   0.0088,  4.06e-16,  4.06e-16,  3.55e-16,  nan ],
	[   150,   0.9453,   0.0479,   1.0796,   0.0420,   1.4179,   0.0319,   1.1585,   0.0391,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[   160,   1.0490,   0.0491,   1.2563,   0.0410,   1.5546,   0.0331,   1.4700,   0.0350,  1.78e-16,  1.33e-16,  1.33e-16,  nan ],
	[   170,   1.1395,   0.0510,   1.3253,   0.0439,   1.6589,   0.0350,   1.5733,   0.0370,  1.67e-16,  1.67e-16,  1.67e-16,  nan ],
	[   180,   1.3332,   0.0489,   1.4460,   0.0451,   1.9247,   0.0339,   1.7632,   0.0370,  1.58e-16,  1.58e-16,  1.58e-16,  nan ],
	[   190,   1.4496,   0.0501,   1.5773,   0.0460,   2.0851,   0.0348,   1.8676,   0.0389,  2.24e-16,  1.50e-16,  1.50e-16,  nan ],
	[   200,   1.4350,   0.0560,   1.7118,   0.0470,   2.1756,   0.0370,   2.3582,   0.0341,  2.13e-16,  1.42e-16,  1.42e-16,  nan ],
	[   210,   1.6091,   0.0551,   1.8868,   0.0470,   2.3981,   0.0370,   2.3377,   0.0379,  2.03e-16,  2.03e-16,  1.35e-16,  nan ],
	[   220,   1.7733,   0.0548,   2.0703,   0.0470,   2.6313,   0.0370,   2.7010,   0.0360,  1.94e-16,  1.94e-16,  1.29e-16,  nan ],
	[   230,   1.8965,   0.0560,   2.2173,   0.0479,   2.8031,   0.0379,   2.7176,   0.0391,  1.85e-16,  1.85e-16,  1.85e-16,  nan ],
	[   240,   1.9564,   0.0591,   2.4139,   0.0479,   2.9767,   0.0389,   3.2132,   0.0360,  1.78e-16,  1.78e-16,  1.18e-16,  nan ],
	[   250,   2.1225,   0.0591,   2.5066,   0.0501,   3.1332,   0.0401,   2.9244,   0.0429,  1.71e-16,  1.71e-16,  2.27e-16,  nan ],
	[   260,   2.1563,   0.0629,   2.6112,   0.0520,   3.2344,   0.0420,   3.3096,   0.0410,  2.19e-16,  1.64e-16,  1.09e-16,  nan ],
	[   270,   2.3607,   0.0620,   2.8682,   0.0510,   3.3911,   0.0432,   3.7426,   0.0391,  1.58e-16,  2.11e-16,  1.58e-16,  nan ],
	[   280,   2.5782,   0.0610,   3.0276,   0.0520,   3.6668,   0.0429,   3.8373,   0.0410,  1.52e-16,  1.52e-16,  1.52e-16,  nan ],
	[   290,   2.6815,   0.0629,   3.1888,   0.0529,   3.8474,   0.0439,   3.6680,   0.0460,  2.45e-16,  1.96e-16,  1.96e-16,  nan ],
	[   300,   2.7747,   0.0651,   3.4121,   0.0529,   4.1168,   0.0439,   3.6771,   0.0491,  1.89e-16,  1.42e-16,  1.89e-16,  nan ],
	[   310,   3.0177,   0.0639,   3.5163,   0.0548,   4.3954,   0.0439,   4.0037,   0.0482,  2.29e-16,  2.29e-16,  2.29e-16,  nan ],
	[   320,   3.1679,   0.0648,   3.7302,   0.0551,   4.5834,   0.0448,   4.6577,   0.0441,  1.78e-16,  1.78e-16,  1.78e-16,  nan ],
	[   330,   3.2608,   0.0670,   4.0365,   0.0541,   4.6512,   0.0470,   4.9798,   0.0439,  2.15e-16,  1.72e-16,  2.15e-16,  nan ],
	[   340,   3.3081,   0.0701,   4.2103,   0.0551,   4.9369,   0.0470,   5.0392,   0.0460,  1.67e-16,  2.51e-16,  2.09e-16,  nan ],
	[   350,   3.5052,   0.0701,   4.1722,   0.0589,   5.2312,   0.0470,   5.6936,   0.0432,  1.62e-16,  1.62e-16,  1.62e-16,  nan ],
	[   360,   3.7723,   0.0689,   4.4680,   0.0582,   5.2922,   0.0491,   5.5339,   0.0470,  1.58e-16,  2.37e-16,  1.97e-16,  nan ],
	[   370,   3.8641,   0.0710,   4.5695,   0.0601,   5.5096,   0.0498,   5.5898,   0.0491,  1.54e-16,  2.30e-16,  2.30e-16,  nan ],
	[   380,   4.2024,   0.0689,   4.9980,   0.0579,   6.0124,   0.0482,   5.3739,   0.0539,  2.24e-16,  2.24e-16,  2.24e-16,  nan ],
	[   390,   3.9119,   0.0780,   4.9968,   0.0610,   6.1205,   0.0498,   6.4933,   0.0470,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[   400,   4.2312,   0.0758,   5.2560,   0.0610,   6.1722,   0.0520,   6.4073,   0.0501,  2.13e-16,  2.13e-16,  2.84e-16,  nan ],
	[   410,   4.3096,   0.0782,   5.4368,   0.0620,   6.6365,   0.0508,   6.6054,   0.0510,  2.77e-16,  2.08e-16,  2.08e-16,  nan ],
	[   420,   4.6644,   0.0758,   5.5973,   0.0632,   6.6814,   0.0529,   7.0632,   0.0501,  2.03e-16,  2.71e-16,  2.03e-16,  nan ],
	[   430,   4.6408,   0.0799,   5.7794,   0.0641,   6.5049,   0.0570,   7.1315,   0.0520,  1.98e-16,  2.64e-16,  1.98e-16,  nan ],
	[   440,   4.8589,   0.0799,   5.9843,   0.0648,   7.0464,   0.0551,   6.8106,   0.0570,  1.94e-16,  1.94e-16,  1.94e-16,  nan ],
	[   450,   5.0073,   0.0811,   6.1684,   0.0658,   7.1233,   0.0570,   7.0936,   0.0572,  1.89e-16,  1.89e-16,  1.89e-16,  nan ],
	[   460,   5.0393,   0.0842,   6.3306,   0.0670,   7.2020,   0.0589,   7.4430,   0.0570,  2.47e-16,  1.85e-16,  1.85e-16,  nan ],
	[   470,   5.3362,   0.0830,   6.4930,   0.0682,   7.4878,   0.0591,   7.1423,   0.0620,  2.42e-16,  1.81e-16,  2.42e-16,  nan ],
	[   480,   5.6301,   0.0820,   6.9919,   0.0660,   7.8411,   0.0589,   8.1036,   0.0570,  2.37e-16,  2.37e-16,  2.37e-16,  nan ],
	[   490,   5.6062,   0.0858,   6.9834,   0.0689,   7.4199,   0.0648,   8.3054,   0.0579,  2.32e-16,  2.32e-16,  1.74e-16,  nan ],
	[   500,   5.8209,   0.0861,   7.1474,   0.0701,   7.9596,   0.0629,   8.6475,   0.0579,  2.27e-16,  2.84e-16,  1.71e-16,  nan ],
	[   510,   6.2107,   0.0839,   7.2389,   0.0720,   8.1270,   0.0641,   8.5397,   0.0610,  2.23e-16,  2.23e-16,  2.23e-16,  nan ],
	[   520,   6.0123,   0.0901,   7.5253,   0.0720,   8.3247,   0.0651,   8.0877,   0.0670,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[   530,   6.2621,   0.0899,   7.8172,   0.0720,   8.5228,   0.0660,   8.1689,   0.0689,  2.15e-16,  2.68e-16,  2.15e-16,  nan ],
	[   540,   6.3488,   0.0920,   7.9053,   0.0739,   8.5988,   0.0679,   8.3355,   0.0701,  2.63e-16,  2.63e-16,  1.58e-16,  nan ],
	[   550,   6.5859,   0.0920,   8.2005,   0.0739,   9.0469,   0.0670,   8.3077,   0.0730,  2.58e-16,  2.58e-16,  2.07e-16,  nan ],
	[   560,   6.6215,   0.0949,   7.9618,   0.0789,   8.9638,   0.0701,   8.3662,   0.0751,  2.03e-16,  2.03e-16,  3.05e-16,  nan ],
	[   570,   7.0006,   0.0930,   8.4528,   0.0770,   9.2865,   0.0701,   8.6950,   0.0749,  2.99e-16,  1.99e-16,  1.99e-16,  nan ],
	[   580,   6.6670,   0.1011,   8.6183,   0.0782,   9.2379,   0.0730,   8.7517,   0.0770,  2.94e-16,  1.96e-16,  1.96e-16,  nan ],
	[   590,   7.1168,   0.0980,   8.9450,   0.0780,   9.8155,   0.0710,   8.5030,   0.0820,  2.89e-16,  2.89e-16,  2.89e-16,  nan ],
	[   600,   7.0022,   0.1030,   9.0028,   0.0801,  10.0163,   0.0720,   9.1112,   0.0792,  2.37e-16,  2.37e-16,  1.89e-16,  nan ],
	[   610,   7.3739,   0.1011,   9.1152,   0.0818,  10.0855,   0.0739,   8.9842,   0.0830,  2.80e-16,  1.86e-16,  2.33e-16,  nan ],
	[   620,   7.4078,   0.1040,   9.2544,   0.0832,  10.1247,   0.0761,   9.2810,   0.0830,  2.29e-16,  1.83e-16,  2.75e-16,  nan ],
	[   630,   7.7914,   0.1020,   9.3672,   0.0849,  10.6201,   0.0749,   8.8454,   0.0899,  2.71e-16,  2.26e-16,  2.71e-16,  nan ],
	[   640,   7.8035,   0.1051,   9.5328,   0.0861,  10.9597,   0.0749,   9.4283,   0.0870,  2.66e-16,  2.66e-16,  3.11e-16,  nan ],
	[   650,   7.6999,   0.1099,   9.7250,   0.0870,  10.8552,   0.0780,   9.3166,   0.0908,  2.62e-16,  2.62e-16,  2.62e-16,  nan ],
	[   660,   8.0079,   0.1090,  10.0263,   0.0870,  11.3301,   0.0770,   9.3836,   0.0930,  2.58e-16,  2.58e-16,  2.15e-16,  nan ],
	[   670,   8.0240,   0.1121,  10.0034,   0.0899,  11.3936,   0.0789,   9.1758,   0.0980,  2.55e-16,  2.55e-16,  2.55e-16,  nan ],
	[   680,   7.9766,   0.1161,  10.3040,   0.0899,  11.5958,   0.0799,   9.5445,   0.0970,  2.51e-16,  2.51e-16,  2.51e-16,  nan ],
	[   690,   8.5279,   0.1118,  10.4702,   0.0911,  11.7635,   0.0811,   9.6376,   0.0989,  3.30e-16,  3.30e-16,  2.47e-16,  nan ],
	[   700,   8.4523,   0.1161,  10.5546,   0.0930,  11.9660,   0.0820,   9.6175,   0.1020,  2.44e-16,  2.44e-16,  3.25e-16,  nan ],
	[   710,   8.6245,   0.1171,  10.7479,   0.0939,  12.1685,   0.0830,   9.7125,   0.1040,  2.40e-16,  2.40e-16,  2.40e-16,  nan ],
	[   720,   8.8871,   0.1168,  11.1373,   0.0932,  12.5135,   0.0830,   9.6987,   0.1070,  2.37e-16,  2.37e-16,  2.37e-16,  nan ],
	[   730,   8.8818,   0.1202,  10.9986,   0.0970,  12.2641,   0.0870,   9.9036,   0.1078,  2.34e-16,  3.11e-16,  2.34e-16,  nan ],
	[   740,   9.2925,   0.1180,  11.5573,   0.0949,  12.9208,   0.0849,  10.0433,   0.1092,  3.07e-16,  3.07e-16,  2.30e-16,  nan ],
	[   750,   9.3010,   0.1211,  11.6091,   0.0970,  12.5328,   0.0899,  10.1610,   0.1109,  3.03e-16,  3.79e-16,  3.79e-16,  nan ],
	[   760,   9.4759,   0.1221,  11.8045,   0.0980,  13.0071,   0.0889,  10.4336,   0.1109,  2.99e-16,  2.24e-16,  2.24e-16,  nan ],
	[   770,   9.4141,   0.1261,  11.9713,   0.0992,  13.3514,   0.0889,  10.2470,   0.1159,  2.95e-16,  2.95e-16,  2.95e-16,  nan ],
	[   780,   9.7337,   0.1252,  12.3137,   0.0989,  13.1030,   0.0930,  10.5148,   0.1159,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[   790,   9.9279,   0.1259,  12.3631,   0.1011,  13.7584,   0.0908,  10.4839,   0.1192,  2.88e-16,  2.16e-16,  2.88e-16,  nan ],
	[   800,  10.1615,   0.1261,  12.6779,   0.1011,  14.0718,   0.0911,  10.0101,   0.1280,  2.84e-16,  2.84e-16,  3.55e-16,  nan ],
	[   810,  10.0192,   0.1311,  12.6100,   0.1042,  13.6738,   0.0961,  10.6794,   0.1230,  2.81e-16,  2.81e-16,  2.11e-16,  nan ],
	[   820,  10.3622,   0.1299,  13.0726,   0.1030,  14.3334,   0.0939,  10.9445,   0.1230,  2.77e-16,  2.77e-16,  2.77e-16,  nan ],
	[   830,  10.4438,   0.1321,  13.0312,   0.1059,  14.2159,   0.0970,  10.3690,   0.1330,  2.74e-16,  2.74e-16,  2.74e-16,  nan ],
	[   840,  10.4516,   0.1352,  13.4683,   0.1049,  14.7048,   0.0961,  10.7943,   0.1309,  2.71e-16,  3.38e-16,  2.71e-16,  nan ],
	[   850,  10.7970,   0.1340,  13.6357,   0.1061,  14.9088,   0.0970,  10.7207,   0.1349,  2.67e-16,  2.67e-16,  2.67e-16,  nan ],
	[   860,  11.0327,   0.1342,  13.8339,   0.1070,  15.2615,   0.0970,  11.0524,   0.1340,  2.64e-16,  2.64e-16,  2.64e-16,  nan ],
	[   870,  11.1520,   0.1359,  14.0323,   0.1080,  15.4663,   0.0980,  10.7557,   0.1409,  3.27e-16,  3.27e-16,  3.92e-16,  nan ],
	[   880,  11.1553,   0.1390,  14.3566,   0.1080,  15.6711,   0.0989,  10.8573,   0.1428,  3.23e-16,  2.58e-16,  2.58e-16,  nan ],
	[   890,  11.5890,   0.1369,  14.4297,   0.1099,  15.8383,   0.1001,  11.3131,   0.1402,  3.19e-16,  2.55e-16,  2.55e-16,  nan ],
	[   900,  11.2621,   0.1440,  14.4730,   0.1121,  16.0811,   0.1009,  11.4325,   0.1419,  2.53e-16,  2.53e-16,  2.53e-16,  nan ],
	[  1000,  12.8394,   0.1559,  16.8276,   0.1190,  17.7152,   0.1130,  11.5661,   0.1731,  2.84e-16,  2.84e-16,  2.84e-16,  nan ],
	[  1100,  14.2289,   0.1702,  18.9542,   0.1278,  12.0515,   0.2010,  12.6676,   0.1912,  3.10e-16,  3.10e-16,  3.10e-16,  nan ],
	[  1200,  15.7623,   0.1829,  21.0621,   0.1369,  13.0982,   0.2201,  12.9857,   0.2220,  3.32e-16,  2.84e-16,  2.84e-16,  nan ],
	[  1300,  17.1556,   0.1972,  22.8465,   0.1481,  13.9780,   0.2420,  13.9780,   0.2420,  3.50e-16,  2.62e-16,  3.06e-16,  nan ],
	[  1400,  18.7610,   0.2091,  25.3129,   0.1550,  15.3198,   0.2561,  13.9082,   0.2820,  3.25e-16,  3.25e-16,  3.25e-16,  nan ],
	[  1500,  19.8392,   0.2270,  26.4894,   0.1700,  15.9653,   0.2820,  14.4396,   0.3119,  3.79e-16,  3.03e-16,  3.79e-16,  nan ],
	[  1600,  20.6618,   0.2480,  28.1629,   0.1819,  16.4787,   0.3109,  13.7745,   0.3719,  3.55e-16,  3.55e-16,  3.55e-16,  nan ],
	[  1700,  22.0722,   0.2620,  29.9473,   0.1931,  17.1067,   0.3381,  14.4217,   0.4010,  3.34e-16,  3.34e-16,  4.01e-16,  nan ],
	[  1800,  23.6677,   0.2739,  31.6212,   0.2050,  18.2634,   0.3550,  18.0213,   0.3598,  3.79e-16,  3.79e-16,  3.79e-16,  nan ],
	[  1900,  24.8148,   0.2911,  33.5907,   0.2151,  19.3232,   0.3738,  16.2373,   0.4449,  3.59e-16,  3.59e-16,  2.99e-16,  nan ],
	[  2000,  25.9839,   0.3080,  34.6452,   0.2310,  20.3709,   0.3929,  18.1172,   0.4418,  3.98e-16,  4.55e-16,  3.41e-16,  nan ],
	[  2100,  27.2343,   0.3240,  36.0383,   0.2449,  15.1873,   0.5810,  18.2232,   0.4842,  4.33e-16,  3.25e-16,  3.25e-16,  nan ],
	[  2200,  28.7265,   0.3371,  37.6803,   0.2570,  16.2218,   0.5970,  18.1986,   0.5322,  5.17e-16,  3.62e-16,  3.62e-16,  nan ],
	[  2300,  30.1597,   0.3510,  39.4974,   0.2680,  16.6711,   0.6349,  19.4204,   0.5450,  3.95e-16,  4.45e-16,  3.95e-16,  nan ],
	[  2400,  31.6766,   0.3638,  40.5865,   0.2840,  17.5649,   0.6561,  18.2409,   0.6318,  4.26e-16,  4.26e-16,  3.79e-16,  nan ],
	[  2500,  32.7402,   0.3819,  41.8260,   0.2990,  18.1739,   0.6881,  18.8600,   0.6630,  4.55e-16,  4.09e-16,  4.09e-16,  nan ],
	[  2600,  33.6470,   0.4020,  43.7722,   0.3090,  18.8155,   0.7188,  20.0314,   0.6752,  5.25e-16,  3.94e-16,  4.81e-16,  nan ],
	[  2700,  34.9775,   0.4170,  45.0152,   0.3240,  19.4517,   0.7498,  19.8172,   0.7360,  4.21e-16,  4.21e-16,  4.63e-16,  nan ],
	[  2800,  35.7167,   0.4392,  44.5733,   0.3519,  20.0275,   0.7832,  20.2618,   0.7741,  4.06e-16,  4.47e-16,  4.06e-16,  nan ],
	[  2900,  36.9877,   0.4549,  47.8134,   0.3519,  20.8733,   0.8061,  21.4311,   0.7851,  5.49e-16,  4.70e-16,  4.70e-16,  nan ],
	[  3000,  38.5516,   0.4671,  48.5364,   0.3710,  21.6957,   0.8299,  21.3040,   0.8452,  5.31e-16,  4.55e-16,  5.31e-16,  nan ],
	[  3100,  39.6463,   0.4849,  49.6861,   0.3870,  17.4320,   1.1029,  21.6252,   0.8891,  5.13e-16,  5.13e-16,  5.87e-16,  nan ],
	[  3200,  40.3978,   0.5071,  50.9645,   0.4020,  18.0669,   1.1339,  21.1225,   0.9699,  4.97e-16,  4.97e-16,  5.68e-16,  nan ],
	[  3300,  42.4627,   0.5131,  52.4869,   0.4151,  18.6375,   1.1690,  21.4204,   1.0171,  4.82e-16,  4.82e-16,  4.82e-16,  nan ],
	[  3400,  43.0732,   0.5369,  53.7699,   0.4301,  19.0796,   1.2121,  21.7735,   1.0622,  5.35e-16,  4.68e-16,  5.35e-16,  nan ],
	[  3500,  43.8336,   0.5591,  55.2040,   0.4439,  19.6201,   1.2491,  20.6116,   1.1890,  5.20e-16,  5.85e-16,  5.20e-16,  nan ],
	[  3600,  45.4816,   0.5701,  56.8461,   0.4561,  20.1943,   1.2839,  18.7753,   1.3809,  5.68e-16,  4.42e-16,  4.42e-16,  nan ],
	[  3700,  45.5657,   0.6011,  57.1498,   0.4792,  20.6566,   1.3258,  20.4397,   1.3399,  6.76e-16,  6.15e-16,  5.53e-16,  nan ],
	[  3800,  47.2004,   0.6120,  58.7316,   0.4919,  20.8722,   1.3840,  19.4922,   1.4820,  5.39e-16,  5.98e-16,  4.79e-16,  nan ],
	[  3900,  47.3205,   0.6430,  58.6235,   0.5190,  21.7973,   1.3959,  21.8122,   1.3950,  4.66e-16,  6.41e-16,  4.66e-16,  nan ],
	[  4000,  47.5731,   0.6728,  59.4822,   0.5381,  22.1208,   1.4470,  19.5303,   1.6389,  5.12e-16,  5.68e-16,  5.12e-16,  nan ],
	[  4100,  46.7817,   0.7188,  58.5743,   0.5741,  18.2278,   1.8449,  22.0214,   1.5271,  4.99e-16,  5.55e-16,  5.55e-16,  nan ],
	[  4200,  46.9874,   0.7510,  63.6877,   0.5541,  18.8596,   1.8711,  20.8553,   1.6921,  7.04e-16,  5.41e-16,  5.41e-16,  nan ],
	[  4300,  47.0696,   0.7858,  63.3489,   0.5839,  19.4486,   1.9019,  23.7728,   1.5559,  6.35e-16,  6.35e-16,  4.76e-16,  nan ],
	[  4400,  48.2879,   0.8020,  64.0285,   0.6049,  19.9216,   1.9441,  24.7660,   1.5638,  5.68e-16,  5.17e-16,  5.68e-16,  nan ],
	[  4500,  48.4480,   0.8361,  64.1885,   0.6311,  20.1145,   2.0139,  26.0474,   1.5552,  6.06e-16,  6.57e-16,  5.56e-16,  nan ],
	[  4600,  49.2760,   0.8590,  64.8198,   0.6530,  20.7602,   2.0390,  26.9451,   1.5709,  4.94e-16,  6.43e-16,  5.93e-16,  nan ],
	[  4700,  48.6722,   0.9079,  64.6022,   0.6840,  21.1943,   2.0850,  25.4978,   1.7331,  5.81e-16,  5.32e-16,  5.81e-16,  nan ],
	[  4800,  50.0943,   0.9201,  66.3169,   0.6950,  21.4080,   2.1529,  25.7477,   1.7900,  6.16e-16,  5.68e-16,  5.68e-16,  nan ],
	[  4900,  49.9756,   0.9611,  66.0714,   0.7269,  21.8399,   2.1992,  26.3198,   1.8249,  6.50e-16,  6.50e-16,  6.03e-16,  nan ],
	[  5000,  49.8709,   1.0028,  66.2530,   0.7548,  22.3170,   2.2409,  26.8438,   1.8630,  6.37e-16,  5.46e-16,  6.37e-16,  nan ],
	[  5100,  50.9170,   1.0219,  65.6135,   0.7930,  22.7394,   2.2881,  26.0015,   2.0010,  8.47e-16,  7.58e-16,  6.24e-16,  nan ],
	[  5200,  50.8909,   1.0629,  66.8646,   0.8090,  19.7847,   2.7339,  25.9430,   2.0850,  7.00e-16,  6.12e-16,  7.43e-16,  nan ],
	[  5300,  51.0352,   1.1010,  66.7272,   0.8421,  20.1402,   2.7900,  21.0843,   2.6650,  6.44e-16,  6.44e-16,  5.58e-16,  nan ],
	[  5400,  51.2586,   1.1380,  67.3430,   0.8662,  20.3660,   2.8641,  26.8441,   2.1729,  8.42e-16,  6.74e-16,  7.58e-16,  nan ],
	[  5500,  51.3249,   1.1790,  67.3929,   0.8979,  20.8530,   2.9018,  26.1732,   2.3119,  8.27e-16,  6.61e-16,  6.61e-16,  nan ],
	[  5600,  52.6333,   1.1919,  67.0183,   0.9360,  21.2137,   2.9571,  27.4649,   2.2840,  7.31e-16,  6.50e-16,  7.31e-16,  nan ],
	[  5700,  52.7975,   1.2310,  67.7757,   0.9589,  21.3297,   3.0470,  26.4834,   2.4540,  7.18e-16,  6.38e-16,  5.58e-16,  nan ],
	[  5800,  52.9832,   1.2701,  67.7650,   0.9930,  21.6161,   3.1130,  26.7350,   2.5170,  7.84e-16,  7.84e-16,  7.84e-16,  nan ],
	[  5900,  53.2368,   1.3080,  67.1550,   1.0369,  22.0987,   3.1509,  27.4490,   2.5368,  7.71e-16,  7.71e-16,  6.94e-16,  nan ],
	[  6000,  53.5817,   1.3440,  67.1051,   1.0731,  22.5101,   3.1991,  26.7316,   2.6939,  6.82e-16,  6.82e-16,  6.06e-16,  nan ],
	[  6100,  54.0123,   1.3781,  68.2833,   1.0900,  22.7131,   3.2771,  26.1357,   2.8479,  7.45e-16,  6.71e-16,  7.45e-16,  nan ],
	[  6200,  54.3770,   1.4141,  67.1616,   1.1449,  20.2137,   3.8040,  25.8380,   2.9759,  8.07e-16,  7.33e-16,  6.60e-16,  nan ],
	[  6300,  55.2050,   1.4381,  66.5594,   1.1928,  20.5897,   3.8559,  26.9132,   2.9500,  8.66e-16,  7.22e-16,  8.66e-16,  nan ],
	[  6400,  55.2139,   1.4839,  67.2639,   1.2181,  20.8210,   3.9351,  27.7093,   2.9569,  7.11e-16,  8.53e-16,  7.11e-16,  nan ],
	[  6500,  55.9724,   1.5099,  68.2073,   1.2391,  20.9092,   4.0419,  26.0126,   3.2489,  7.70e-16,  8.40e-16,  7.70e-16,  nan ],
	[  6600,  56.8372,   1.5330,  68.4004,   1.2739,  21.3621,   4.0789,  27.3060,   3.1910,  8.27e-16,  7.58e-16,  6.89e-16,  nan ],
	[  6700,  56.9000,   1.5781,  68.1790,   1.3170,  21.6312,   4.1511,  26.8440,   3.3450,  8.14e-16,  7.47e-16,  6.79e-16,  nan ],
	[  6800,  55.6195,   1.6630,  68.3124,   1.3540,  21.8549,   4.2322,  27.4051,   3.3751,  7.36e-16,  6.69e-16,  6.69e-16,  nan ],
	[  6900,  57.5395,   1.6551,  67.6443,   1.4079,  22.1677,   4.2961,  27.5970,   3.4509,  7.25e-16,  7.25e-16,  7.25e-16,  nan ],
	[  7000,  57.1529,   1.7149,  68.4369,   1.4322,  22.5113,   4.3540,  27.9242,   3.5100,  8.45e-16,  8.45e-16,  8.45e-16,  nan ],
	[  7100,  57.6827,   1.7481,  68.1704,   1.4791,  22.7675,   4.4289,  26.5559,   3.7971,  7.69e-16,  8.97e-16,  7.05e-16,  nan ],
	[  7200,  58.5522,   1.7710,  68.8937,   1.5051,  20.4123,   5.0800,  27.1371,   3.8211,  7.58e-16,  9.47e-16,  8.21e-16,  nan ],
	[  7300,  58.6040,   1.8189,  69.1234,   1.5421,  20.7101,   5.1470,  28.1561,   3.7858,  8.72e-16,  9.34e-16,  8.10e-16,  nan ],
	[  7400,  59.0821,   1.8539,  68.8892,   1.5900,  20.5044,   5.3420,  27.5962,   3.9692,  7.37e-16,  8.60e-16,  7.37e-16,  nan ],
	[  7500,  59.1604,   1.9019,  68.4342,   1.6441,  21.0661,   5.3411,  26.3555,   4.2691,  8.49e-16,  8.49e-16,  6.67e-16,  nan ],
	[  7600,  60.3024,   1.9159,  69.6050,   1.6599,  21.6518,   5.3360,  27.7654,   4.1611,  8.38e-16,  7.78e-16,  6.58e-16,  nan ],
	[  7700,  59.2384,   2.0020,  68.9910,   1.7190,  21.6847,   5.4691,  27.6778,   4.2849,  9.45e-16,  7.68e-16,  8.27e-16,  nan ],
	[  7800,  59.5947,   2.0421,  69.1825,   1.7591,  22.1550,   5.4929,  27.5030,   4.4248,  8.16e-16,  7.58e-16,  7.00e-16,  nan ],
	[  7900,  58.9705,   2.1169,  69.8132,   1.7881,  22.3122,   5.5950,  26.8471,   4.6499,  8.63e-16,  8.63e-16,  6.91e-16,  nan ],
	[  8000,  59.4287,   2.1541,  69.3898,   1.8449,  22.5216,   5.6841,  27.6558,   4.6289,  8.53e-16,  8.53e-16,  7.39e-16,  nan ],
	[  8100,  60.2830,   2.1770,  70.1114,   1.8718,  22.7842,   5.7600,  28.1313,   4.6651,  7.86e-16,  7.86e-16,  7.30e-16,  nan ],
	[  8200,  59.6194,   2.2559,  70.0856,   1.9190,  20.5868,   6.5331,  22.7734,   5.9059,  7.21e-16,  9.43e-16,  7.76e-16,  nan ],
	[  8300,  60.4056,   2.2812,  72.1009,   1.9112,  21.0061,   6.5598,  28.1274,   4.8990,  9.31e-16,  8.22e-16,  6.57e-16,  nan ],
	[  8400,  59.3990,   2.3761,  71.9721,   1.9610,  21.2427,   6.6440,  27.4365,   5.1441,  8.12e-16,  7.58e-16,  6.50e-16,  nan ],
	[  8500,  60.9255,   2.3720,  71.1943,   2.0299,  21.3967,   6.7542,  28.2534,   5.1150,  8.02e-16,  8.56e-16,  6.95e-16,  nan ],
	[  8600,  60.3065,   2.4531,  71.5019,   2.0690,  21.7138,   6.8130,  28.5035,   5.1901,  9.52e-16,  1.22e-15,  1.00e-15,  nan ],
	[  8700,  59.8386,   2.5301,  72.5142,   2.0878,  21.8689,   6.9230,  27.6078,   5.4839,  8.89e-16,  7.84e-16,  6.27e-16,  nan ],
	[  8800,  59.3485,   2.6100,  71.5515,   2.1648,  22.1313,   6.9990,  28.6370,   5.4090,  9.30e-16,  7.75e-16,  9.82e-16,  nan ],
	[  8900,  59.9221,   2.6441,  72.4843,   2.1858,  22.3374,   7.0930,  27.1905,   5.8270,  1.02e-15,  9.20e-16,  7.66e-16,  nan ],
	[  9000,  60.3618,   2.6841,  72.7183,   2.2280,  22.2585,   7.2789,  28.3845,   5.7080,  8.59e-16,  8.08e-16,  8.08e-16,  nan ],
	[ 10000,  61.7143,   3.2411,  73.0279,   2.7390,  22.5196,   8.8820,  28.5462,   7.0069,  1.14e-15,  9.09e-16,  8.64e-16,  nan ],
	[ 12000,  63.0545,   4.5679,  72.7879,   3.9570,  21.8069,  13.2079,  29.3753,   9.8050,  1.14e-15,  9.09e-16,  9.09e-16,  nan ],
	[ 14000,  65.7109,   5.9659,  74.4863,   5.2631,  21.9859,  17.8308,  28.8446,  13.5911,  1.30e-15,  1.10e-15,  1.17e-15,  nan ],
	[ 16000,  66.5144,   7.6981,  74.4563,   6.8769,  22.5446,  22.7120,  27.4934,  18.6238,  1.14e-15,  1.08e-15,  1.02e-15,  nan ],
	[ 18000,  66.7238,   9.7122,  74.8839,   8.6539,  22.1036,  29.3181,  28.9651,  22.3730,  1.26e-15,  1.52e-15,  1.16e-15,  nan ],
	[ 20000,  68.4330,  11.6909,  75.0797,  10.6559,  21.3961,  37.3919,  29.8946,  26.7620,  1.50e-15,  1.27e-15,  1.27e-15,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/log.txt
# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/setup.txt
# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/sgeev.txt
# numactl --interleave=all ./testing_sgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeev_RN = array([
	[    10,  nan,    0.0004 ],
	[    20,  nan,    0.0006 ],
	[    30,  nan,    0.0011 ],
	[    40,  nan,    0.0036 ],
	[    50,  nan,    0.0042 ],
	[    60,  nan,    0.0034 ],
	[    70,  nan,    0.0053 ],
	[    80,  nan,    0.0086 ],
	[    90,  nan,    0.0090 ],
	[   100,  nan,    0.0116 ],
	[   200,  nan,    0.0490 ],
	[   300,  nan,    0.0948 ],
	[   400,  nan,    0.1523 ],
	[   500,  nan,    0.1948 ],
	[   600,  nan,    0.4105 ],
	[   700,  nan,    0.4940 ],
	[   800,  nan,    0.6075 ],
	[   900,  nan,    0.7507 ],
	[  1000,  nan,    0.8398 ],
	[  2000,  nan,    1.6267 ],
	[  3000,  nan,    4.3466 ],
	[  4000,  nan,    6.6281 ],
	[  5000,  nan,   10.1955 ],
	[  6000,  nan,   19.1285 ],
	[  7000,  nan,   24.9622 ],
	[  8000,  nan,   32.9550 ],
	[  9000,  nan,   41.3171 ],
	[ 10000,  nan,   47.8675 ],
	[ 12000,  nan,   67.5161 ],
	[ 14000,  nan,   93.7432 ],
	[ 16000,  nan,  126.4203 ],
	[ 18000,  nan,  160.5888 ],
	[ 20000,  nan,  206.5202 ],
])

# numactl --interleave=all ./testing_sgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeev_RV = array([
	[    10,  nan,    0.0015 ],
	[    20,  nan,    0.0016 ],
	[    30,  nan,    0.0021 ],
	[    40,  nan,    0.0041 ],
	[    50,  nan,    0.0062 ],
	[    60,  nan,    0.0053 ],
	[    70,  nan,    0.0061 ],
	[    80,  nan,    0.0083 ],
	[    90,  nan,    0.0091 ],
	[   100,  nan,    0.0121 ],
	[   200,  nan,    0.0433 ],
	[   300,  nan,    0.1046 ],
	[   400,  nan,    0.1237 ],
	[   500,  nan,    0.1746 ],
	[   600,  nan,    0.2825 ],
	[   700,  nan,    0.4077 ],
	[   800,  nan,    0.4491 ],
	[   900,  nan,    0.6653 ],
	[  1000,  nan,    0.6913 ],
	[  2000,  nan,    2.1403 ],
	[  3000,  nan,    5.4876 ],
	[  4000,  nan,   12.0730 ],
	[  5000,  nan,   14.5700 ],
	[  6000,  nan,   25.0527 ],
	[  7000,  nan,   33.2062 ],
	[  8000,  nan,   44.9840 ],
	[  9000,  nan,   55.8217 ],
	[ 10000,  nan,   67.7477 ],
	[ 12000,  nan,   98.0590 ],
	[ 14000,  nan,  138.1966 ],
	[ 16000,  nan,  186.6003 ],
	[ 18000,  nan,  251.4918 ],
	[ 20000,  nan,  323.1083 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/sgeqrf.txt
# numactl --interleave=all ./testing_sgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeqrf = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.04,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.12,  0.00,  nan ],
	[    40,     40,  nan,  nan,     1.03,  0.00,  nan ],
	[    50,     50,  nan,  nan,     1.44,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.17,  0.00,  nan ],
	[    70,     70,  nan,  nan,     2.50,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.47,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.75,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.50,  0.00,  nan ],
	[   200,    200,  nan,  nan,     6.31,  0.00,  nan ],
	[   300,    300,  nan,  nan,    14.22,  0.00,  nan ],
	[   400,    400,  nan,  nan,    25.10,  0.00,  nan ],
	[   500,    500,  nan,  nan,    37.82,  0.00,  nan ],
	[   600,    600,  nan,  nan,    54.27,  0.01,  nan ],
	[   700,    700,  nan,  nan,    68.37,  0.01,  nan ],
	[   800,    800,  nan,  nan,    84.13,  0.01,  nan ],
	[   900,    900,  nan,  nan,   103.83,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   119.84,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   338.30,  0.03,  nan ],
	[  3000,   3000,  nan,  nan,   571.34,  0.06,  nan ],
	[  4000,   4000,  nan,  nan,   729.00,  0.12,  nan ],
	[  5000,   5000,  nan,  nan,   904.31,  0.18,  nan ],
	[  6000,   6000,  nan,  nan,  1031.58,  0.28,  nan ],
	[  7000,   7000,  nan,  nan,  1109.99,  0.41,  nan ],
	[  8000,   8000,  nan,  nan,  1303.37,  0.52,  nan ],
	[  9000,   9000,  nan,  nan,  1431.33,  0.68,  nan ],
	[ 10000,  10000,  nan,  nan,  1526.08,  0.87,  nan ],
	[ 12000,  12000,  nan,  nan,  1685.03,  1.37,  nan ],
	[ 14000,  14000,  nan,  nan,  1767.31,  2.07,  nan ],
	[ 16000,  16000,  nan,  nan,  1886.81,  2.89,  nan ],
	[ 18000,  18000,  nan,  nan,  1885.45,  4.12,  nan ],
	[ 20000,  20000,  nan,  nan,  1989.43,  5.36,  nan ],
])

# numactl --interleave=all ./testing_sgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.07,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.13,  0.00,  nan ],
	[    60,     60,  nan,  nan,     0.20,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.30,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.43,  0.00,  nan ],
	[    90,     90,  nan,  nan,     0.57,  0.00,  nan ],
	[   100,    100,  nan,  nan,     0.61,  0.00,  nan ],
	[   200,    200,  nan,  nan,     6.25,  0.00,  nan ],
	[   300,    300,  nan,  nan,    13.31,  0.00,  nan ],
	[   400,    400,  nan,  nan,    21.97,  0.00,  nan ],
	[   500,    500,  nan,  nan,    25.64,  0.01,  nan ],
	[   600,    600,  nan,  nan,    38.07,  0.01,  nan ],
	[   700,    700,  nan,  nan,    48.45,  0.01,  nan ],
	[   800,    800,  nan,  nan,    62.14,  0.01,  nan ],
	[   900,    900,  nan,  nan,    74.98,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    90.56,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   257.53,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   455.14,  0.08,  nan ],
	[  4000,   4000,  nan,  nan,   643.10,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,   846.73,  0.20,  nan ],
	[  6000,   6000,  nan,  nan,   986.20,  0.29,  nan ],
	[  7000,   7000,  nan,  nan,  1062.77,  0.43,  nan ],
	[  8000,   8000,  nan,  nan,  1305.88,  0.52,  nan ],
	[  9000,   9000,  nan,  nan,  1409.01,  0.69,  nan ],
	[ 10000,  10000,  nan,  nan,  1480.54,  0.90,  nan ],
	[ 12000,  12000,  nan,  nan,  1568.22,  1.47,  nan ],
	[ 14000,  14000,  nan,  nan,  1680.74,  2.18,  nan ],
	[ 16000,  16000,  nan,  nan,  1836.92,  2.97,  nan ],
	[ 18000,  18000,  nan,  nan,  1877.23,  4.14,  nan ],
	[ 20000,  20000,  nan,  nan,  1970.03,  5.41,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/sgesvd.txt
# numactl --interleave=all ./testing_sgesvd -UN -VN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
sgesvd_UN = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.01,  nan ],
	[ nan,     300,     300,  nan,    0.03,  nan ],
	[ nan,     400,     400,  nan,    0.04,  nan ],
	[ nan,     500,     500,  nan,    0.06,  nan ],
	[ nan,     600,     600,  nan,    0.08,  nan ],
	[ nan,     700,     700,  nan,    0.11,  nan ],
	[ nan,     800,     800,  nan,    0.14,  nan ],
	[ nan,     900,     900,  nan,    0.17,  nan ],
	[ nan,    1000,    1000,  nan,    0.21,  nan ],
	[ nan,    2000,    2000,  nan,    0.76,  nan ],
	[ nan,    3000,    3000,  nan,    1.77,  nan ],
	[ nan,    4000,    4000,  nan,    3.33,  nan ],
	[ nan,    5000,    5000,  nan,    6.01,  nan ],
	[ nan,    6000,    6000,  nan,    9.44,  nan ],
	[ nan,    7000,    7000,  nan,   14.09,  nan ],
	[ nan,    8000,    8000,  nan,   19.90,  nan ],
	[ nan,    9000,    9000,  nan,   27.19,  nan ],
	[ nan,   10000,   10000,  nan,   36.20,  nan ],
	[ nan,   12000,   12000,  nan,   58.91,  nan ],
	[ nan,   14000,   14000,  nan,   90.76,  nan ],
	[ nan,   16000,   16000,  nan,  132.79,  nan ],
	[ nan,   18000,   18000,  nan,  187.07,  nan ],
	[ nan,   20000,   20000,  nan,  252.82,  nan ],
	[ nan,     300,     100,  nan,    0.03,  nan ],
	[ nan,     600,     200,  nan,    0.01,  nan ],
	[ nan,     900,     300,  nan,    0.03,  nan ],
	[ nan,    1200,     400,  nan,    0.05,  nan ],
	[ nan,    1500,     500,  nan,    0.07,  nan ],
	[ nan,    1800,     600,  nan,    0.10,  nan ],
	[ nan,    2100,     700,  nan,    0.13,  nan ],
	[ nan,    2400,     800,  nan,    0.16,  nan ],
	[ nan,    2700,     900,  nan,    0.21,  nan ],
	[ nan,    3000,    1000,  nan,    0.25,  nan ],
	[ nan,    6000,    2000,  nan,    0.98,  nan ],
	[ nan,    9000,    3000,  nan,    2.41,  nan ],
	[ nan,   12000,    4000,  nan,    4.98,  nan ],
	[ nan,   15000,    5000,  nan,    8.80,  nan ],
	[ nan,   18000,    6000,  nan,   14.20,  nan ],
	[ nan,   21000,    7000,  nan,   19.71,  nan ],
	[ nan,   24000,    8000,  nan,   29.24,  nan ],
	[ nan,   27000,    9000,  nan,   38.47,  nan ],
	[ nan,     100,     300,  nan,    0.00,  nan ],
	[ nan,     200,     600,  nan,    0.02,  nan ],
	[ nan,     300,     900,  nan,    0.04,  nan ],
	[ nan,     400,    1200,  nan,    0.06,  nan ],
	[ nan,     500,    1500,  nan,    0.08,  nan ],
	[ nan,     600,    1800,  nan,    0.11,  nan ],
	[ nan,     700,    2100,  nan,    0.15,  nan ],
	[ nan,     800,    2400,  nan,    0.18,  nan ],
	[ nan,     900,    2700,  nan,    0.23,  nan ],
	[ nan,    1000,    3000,  nan,    0.29,  nan ],
	[ nan,    2000,    6000,  nan,    1.07,  nan ],
	[ nan,    3000,    9000,  nan,    2.65,  nan ],
	[ nan,    4000,   12000,  nan,    5.15,  nan ],
	[ nan,    5000,   15000,  nan,    9.39,  nan ],
	[ nan,    6000,   18000,  nan,   14.60,  nan ],
	[ nan,    7000,   21000,  nan,   22.08,  nan ],
	[ nan,    8000,   24000,  nan,   31.03,  nan ],
	[ nan,    9000,   27000,  nan,   42.65,  nan ],
	[ nan,   10000,     100,  nan,    0.01,  nan ],
	[ nan,   20000,     200,  nan,    0.04,  nan ],
	[ nan,   30000,     300,  nan,    0.09,  nan ],
	[ nan,   40000,     400,  nan,    0.21,  nan ],
	[ nan,   50000,     500,  nan,    0.33,  nan ],
	[ nan,   60000,     600,  nan,    0.49,  nan ],
	[ nan,   70000,     700,  nan,    0.69,  nan ],
	[ nan,   80000,     800,  nan,    0.96,  nan ],
	[ nan,   90000,     900,  nan,    1.32,  nan ],
	[ nan,  100000,    1000,  nan,    1.67,  nan ],
	[ nan,  200000,    2000,  nan,    9.11,  nan ],
	[ nan,     100,   10000,  nan,    0.01,  nan ],
	[ nan,     200,   20000,  nan,    0.05,  nan ],
	[ nan,     300,   30000,  nan,    0.13,  nan ],
	[ nan,     400,   40000,  nan,    0.26,  nan ],
	[ nan,     500,   50000,  nan,    0.45,  nan ],
	[ nan,     600,   60000,  nan,    0.68,  nan ],
	[ nan,     700,   70000,  nan,    1.07,  nan ],
	[ nan,     800,   80000,  nan,    1.31,  nan ],
	[ nan,     900,   90000,  nan,    1.64,  nan ],
	[ nan,    1000,  100000,  nan,    2.05,  nan ],
	[ nan,    2000,  200000,  nan,   12.39,  nan ],
])

# numactl --interleave=all ./testing_sgesvd -US -VS -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
sgesvd_US = array([
	[ nan,      10,      10,  nan,     0.00,  nan ],
	[ nan,      20,      20,  nan,     0.00,  nan ],
	[ nan,      30,      30,  nan,     0.00,  nan ],
	[ nan,      40,      40,  nan,     0.00,  nan ],
	[ nan,      50,      50,  nan,     0.00,  nan ],
	[ nan,      60,      60,  nan,     0.01,  nan ],
	[ nan,      70,      70,  nan,     0.01,  nan ],
	[ nan,      80,      80,  nan,     0.01,  nan ],
	[ nan,      90,      90,  nan,     0.02,  nan ],
	[ nan,     100,     100,  nan,     0.02,  nan ],
	[ nan,     200,     200,  nan,     0.08,  nan ],
	[ nan,     300,     300,  nan,     0.05,  nan ],
	[ nan,     400,     400,  nan,     0.08,  nan ],
	[ nan,     500,     500,  nan,     0.12,  nan ],
	[ nan,     600,     600,  nan,     0.18,  nan ],
	[ nan,     700,     700,  nan,     0.24,  nan ],
	[ nan,     800,     800,  nan,     0.29,  nan ],
	[ nan,     900,     900,  nan,     0.37,  nan ],
	[ nan,    1000,    1000,  nan,     0.50,  nan ],
	[ nan,    2000,    2000,  nan,     2.26,  nan ],
	[ nan,    3000,    3000,  nan,     6.63,  nan ],
	[ nan,    4000,    4000,  nan,    15.08,  nan ],
	[ nan,    5000,    5000,  nan,    26.60,  nan ],
	[ nan,    6000,    6000,  nan,    47.03,  nan ],
	[ nan,    7000,    7000,  nan,    71.89,  nan ],
	[ nan,    8000,    8000,  nan,    99.61,  nan ],
	[ nan,    9000,    9000,  nan,   139.39,  nan ],
	[ nan,   10000,   10000,  nan,   191.95,  nan ],
	[ nan,   12000,   12000,  nan,   320.06,  nan ],
	[ nan,   14000,   14000,  nan,   493.71,  nan ],
	[ nan,   16000,   16000,  nan,   659.14,  nan ],
	[ nan,   18000,   18000,  nan,  1009.44,  nan ],
	[ nan,   20000,   20000,  nan,  1340.65,  nan ],
	[ nan,     300,     100,  nan,     0.10,  nan ],
	[ nan,     600,     200,  nan,     0.08,  nan ],
	[ nan,     900,     300,  nan,     0.07,  nan ],
	[ nan,    1200,     400,  nan,     0.10,  nan ],
	[ nan,    1500,     500,  nan,     0.16,  nan ],
	[ nan,    1800,     600,  nan,     0.24,  nan ],
	[ nan,    2100,     700,  nan,     0.33,  nan ],
	[ nan,    2400,     800,  nan,     0.41,  nan ],
	[ nan,    2700,     900,  nan,     0.53,  nan ],
	[ nan,    3000,    1000,  nan,     0.67,  nan ],
	[ nan,    6000,    2000,  nan,     3.38,  nan ],
	[ nan,    9000,    3000,  nan,     8.20,  nan ],
	[ nan,   12000,    4000,  nan,    18.20,  nan ],
	[ nan,   15000,    5000,  nan,    31.61,  nan ],
	[ nan,   18000,    6000,  nan,    56.63,  nan ],
	[ nan,   21000,    7000,  nan,    83.85,  nan ],
	[ nan,   24000,    8000,  nan,   112.83,  nan ],
	[ nan,   27000,    9000,  nan,   169.79,  nan ],
	[ nan,     100,     300,  nan,     0.02,  nan ],
	[ nan,     200,     600,  nan,     0.08,  nan ],
	[ nan,     300,     900,  nan,     0.07,  nan ],
	[ nan,     400,    1200,  nan,     0.12,  nan ],
	[ nan,     500,    1500,  nan,     0.19,  nan ],
	[ nan,     600,    1800,  nan,     0.28,  nan ],
	[ nan,     700,    2100,  nan,     0.40,  nan ],
	[ nan,     800,    2400,  nan,     0.50,  nan ],
	[ nan,     900,    2700,  nan,     0.64,  nan ],
	[ nan,    1000,    3000,  nan,     0.80,  nan ],
	[ nan,    2000,    6000,  nan,     3.90,  nan ],
	[ nan,    3000,    9000,  nan,     9.64,  nan ],
	[ nan,    4000,   12000,  nan,    20.47,  nan ],
	[ nan,    5000,   15000,  nan,    37.20,  nan ],
	[ nan,    6000,   18000,  nan,    65.37,  nan ],
	[ nan,    7000,   21000,  nan,    97.80,  nan ],
	[ nan,    8000,   24000,  nan,   150.90,  nan ],
	[ nan,    9000,   27000,  nan,   217.87,  nan ],
	[ nan,   10000,     100,  nan,     0.04,  nan ],
	[ nan,   20000,     200,  nan,     0.21,  nan ],
	[ nan,   30000,     300,  nan,     0.29,  nan ],
	[ nan,   40000,     400,  nan,     0.58,  nan ],
	[ nan,   50000,     500,  nan,     1.00,  nan ],
	[ nan,   60000,     600,  nan,     1.53,  nan ],
	[ nan,   70000,     700,  nan,     2.22,  nan ],
	[ nan,   80000,     800,  nan,     3.21,  nan ],
	[ nan,   90000,     900,  nan,     4.54,  nan ],
	[ nan,  100000,    1000,  nan,     5.80,  nan ],
	[ nan,  200000,    2000,  nan,    40.23,  nan ],
	[ nan,     100,   10000,  nan,     0.07,  nan ],
	[ nan,     200,   20000,  nan,     0.35,  nan ],
	[ nan,     300,   30000,  nan,     0.52,  nan ],
	[ nan,     400,   40000,  nan,     0.91,  nan ],
	[ nan,     500,   50000,  nan,     2.52,  nan ],
	[ nan,     600,   60000,  nan,     3.43,  nan ],
	[ nan,     700,   70000,  nan,     4.40,  nan ],
	[ nan,     800,   80000,  nan,     5.69,  nan ],
	[ nan,     900,   90000,  nan,     7.78,  nan ],
	[ nan,    1000,  100000,  nan,    15.10,  nan ],
	[ nan,    2000,  200000,  nan,    89.97,  nan ],
])

# numactl --interleave=all ./testing_sgesdd -UN -VN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
sgesdd_UN = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.01,  nan ],
	[ nan,     300,     300,  nan,    0.03,  nan ],
	[ nan,     400,     400,  nan,    0.04,  nan ],
	[ nan,     500,     500,  nan,    0.06,  nan ],
	[ nan,     600,     600,  nan,    0.08,  nan ],
	[ nan,     700,     700,  nan,    0.10,  nan ],
	[ nan,     800,     800,  nan,    0.13,  nan ],
	[ nan,     900,     900,  nan,    0.17,  nan ],
	[ nan,    1000,    1000,  nan,    0.20,  nan ],
	[ nan,    2000,    2000,  nan,    0.75,  nan ],
	[ nan,    3000,    3000,  nan,    1.76,  nan ],
	[ nan,    4000,    4000,  nan,    3.32,  nan ],
	[ nan,    5000,    5000,  nan,    5.97,  nan ],
	[ nan,    6000,    6000,  nan,    9.46,  nan ],
	[ nan,    7000,    7000,  nan,   14.06,  nan ],
	[ nan,    8000,    8000,  nan,   19.93,  nan ],
	[ nan,    9000,    9000,  nan,   27.21,  nan ],
	[ nan,   10000,   10000,  nan,   36.27,  nan ],
	[ nan,   12000,   12000,  nan,   59.08,  nan ],
	[ nan,   14000,   14000,  nan,   91.02,  nan ],
	[ nan,   16000,   16000,  nan,  133.15,  nan ],
	[ nan,   18000,   18000,  nan,  187.29,  nan ],
	[ nan,   20000,   20000,  nan,  253.30,  nan ],
	[ nan,     300,     100,  nan,    0.00,  nan ],
	[ nan,     600,     200,  nan,    0.02,  nan ],
	[ nan,     900,     300,  nan,    0.03,  nan ],
	[ nan,    1200,     400,  nan,    0.05,  nan ],
	[ nan,    1500,     500,  nan,    0.07,  nan ],
	[ nan,    1800,     600,  nan,    0.09,  nan ],
	[ nan,    2100,     700,  nan,    0.12,  nan ],
	[ nan,    2400,     800,  nan,    0.15,  nan ],
	[ nan,    2700,     900,  nan,    0.20,  nan ],
	[ nan,    3000,    1000,  nan,    0.24,  nan ],
	[ nan,    6000,    2000,  nan,    0.97,  nan ],
	[ nan,    9000,    3000,  nan,    2.39,  nan ],
	[ nan,   12000,    4000,  nan,    4.61,  nan ],
	[ nan,   15000,    5000,  nan,    8.27,  nan ],
	[ nan,   18000,    6000,  nan,   13.19,  nan ],
	[ nan,   21000,    7000,  nan,   19.71,  nan ],
	[ nan,   24000,    8000,  nan,   28.21,  nan ],
	[ nan,   27000,    9000,  nan,   38.61,  nan ],
	[ nan,     100,     300,  nan,    0.00,  nan ],
	[ nan,     200,     600,  nan,    0.02,  nan ],
	[ nan,     300,     900,  nan,    0.04,  nan ],
	[ nan,     400,    1200,  nan,    0.06,  nan ],
	[ nan,     500,    1500,  nan,    0.08,  nan ],
	[ nan,     600,    1800,  nan,    0.11,  nan ],
	[ nan,     700,    2100,  nan,    0.14,  nan ],
	[ nan,     800,    2400,  nan,    0.18,  nan ],
	[ nan,     900,    2700,  nan,    0.22,  nan ],
	[ nan,    1000,    3000,  nan,    0.27,  nan ],
	[ nan,    2000,    6000,  nan,    1.05,  nan ],
	[ nan,    3000,    9000,  nan,    2.63,  nan ],
	[ nan,    4000,   12000,  nan,    5.01,  nan ],
	[ nan,    5000,   15000,  nan,    9.11,  nan ],
	[ nan,    6000,   18000,  nan,   14.50,  nan ],
	[ nan,    7000,   21000,  nan,   21.97,  nan ],
	[ nan,    8000,   24000,  nan,   30.87,  nan ],
	[ nan,    9000,   27000,  nan,   42.54,  nan ],
	[ nan,   10000,     100,  nan,    0.01,  nan ],
	[ nan,   20000,     200,  nan,    0.04,  nan ],
	[ nan,   30000,     300,  nan,    0.09,  nan ],
	[ nan,   40000,     400,  nan,    0.21,  nan ],
	[ nan,   50000,     500,  nan,    0.33,  nan ],
	[ nan,   60000,     600,  nan,    0.49,  nan ],
	[ nan,   70000,     700,  nan,    0.70,  nan ],
	[ nan,   80000,     800,  nan,    0.96,  nan ],
	[ nan,   90000,     900,  nan,    1.31,  nan ],
	[ nan,  100000,    1000,  nan,    1.65,  nan ],
	[ nan,  200000,    2000,  nan,    9.10,  nan ],
	[ nan,     100,   10000,  nan,    0.01,  nan ],
	[ nan,     200,   20000,  nan,    0.05,  nan ],
	[ nan,     300,   30000,  nan,    0.13,  nan ],
	[ nan,     400,   40000,  nan,    0.25,  nan ],
	[ nan,     500,   50000,  nan,    0.44,  nan ],
	[ nan,     600,   60000,  nan,    0.68,  nan ],
	[ nan,     700,   70000,  nan,    1.06,  nan ],
	[ nan,     800,   80000,  nan,    1.29,  nan ],
	[ nan,     900,   90000,  nan,    1.61,  nan ],
	[ nan,    1000,  100000,  nan,    2.02,  nan ],
	[ nan,    2000,  200000,  nan,   12.42,  nan ],
])

# numactl --interleave=all ./testing_sgesdd -US -VS -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
sgesdd_US = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.02,  nan ],
	[ nan,     300,     300,  nan,    0.04,  nan ],
	[ nan,     400,     400,  nan,    0.06,  nan ],
	[ nan,     500,     500,  nan,    0.09,  nan ],
	[ nan,     600,     600,  nan,    0.12,  nan ],
	[ nan,     700,     700,  nan,    0.16,  nan ],
	[ nan,     800,     800,  nan,    0.21,  nan ],
	[ nan,     900,     900,  nan,    0.27,  nan ],
	[ nan,    1000,    1000,  nan,    0.32,  nan ],
	[ nan,    2000,    2000,  nan,    1.23,  nan ],
	[ nan,    3000,    3000,  nan,    2.88,  nan ],
	[ nan,    4000,    4000,  nan,    5.40,  nan ],
	[ nan,    5000,    5000,  nan,    9.84,  nan ],
	[ nan,    6000,    6000,  nan,   14.44,  nan ],
	[ nan,    7000,    7000,  nan,    0.00,  nan ],
	[ nan,    8000,    8000,  nan,   29.12,  nan ],
	[ nan,    9000,    9000,  nan,   38.77,  nan ],
	[ nan,   10000,   10000,  nan,   50.51,  nan ],
	[ nan,   12000,   12000,  nan,   79.90,  nan ],
	[ nan,   14000,   14000,  nan,    0.00,  nan ],
	[ nan,   16000,   16000,  nan,  170.35,  nan ],
	[ nan,   18000,   18000,  nan,  234.33,  nan ],
	[ nan,   20000,   20000,  nan,  310.26,  nan ],
	[ nan,     300,     100,  nan,    0.01,  nan ],
	[ nan,     600,     200,  nan,    0.02,  nan ],
	[ nan,     900,     300,  nan,    0.04,  nan ],
	[ nan,    1200,     400,  nan,    0.07,  nan ],
	[ nan,    1500,     500,  nan,    0.10,  nan ],
	[ nan,    1800,     600,  nan,    0.15,  nan ],
	[ nan,    2100,     700,  nan,    0.20,  nan ],
	[ nan,    2400,     800,  nan,    0.24,  nan ],
	[ nan,    2700,     900,  nan,    0.33,  nan ],
	[ nan,    3000,    1000,  nan,    0.41,  nan ],
	[ nan,    6000,    2000,  nan,    1.77,  nan ],
	[ nan,    9000,    3000,  nan,    4.21,  nan ],
	[ nan,   12000,    4000,  nan,    8.15,  nan ],
	[ nan,   15000,    5000,  nan,   14.27,  nan ],
	[ nan,   18000,    6000,  nan,   23.12,  nan ],
	[ nan,   21000,    7000,  nan,    0.00,  nan ],
	[ nan,   24000,    8000,  nan,   48.00,  nan ],
	[ nan,   27000,    9000,  nan,   64.77,  nan ],
	[ nan,     100,     300,  nan,    0.01,  nan ],
	[ nan,     200,     600,  nan,    0.02,  nan ],
	[ nan,     300,     900,  nan,    0.05,  nan ],
	[ nan,     400,    1200,  nan,    0.08,  nan ],
	[ nan,     500,    1500,  nan,    0.12,  nan ],
	[ nan,     600,    1800,  nan,    0.17,  nan ],
	[ nan,     700,    2100,  nan,    0.22,  nan ],
	[ nan,     800,    2400,  nan,    0.28,  nan ],
	[ nan,     900,    2700,  nan,    0.36,  nan ],
	[ nan,    1000,    3000,  nan,    0.45,  nan ],
	[ nan,    2000,    6000,  nan,    1.77,  nan ],
	[ nan,    3000,    9000,  nan,    4.40,  nan ],
	[ nan,    4000,   12000,  nan,    8.43,  nan ],
	[ nan,    5000,   15000,  nan,   14.94,  nan ],
	[ nan,    6000,   18000,  nan,   25.70,  nan ],
	[ nan,    7000,   21000,  nan,    0.00,  nan ],
	[ nan,    8000,   24000,  nan,   50.43,  nan ],
	[ nan,    9000,   27000,  nan,   68.50,  nan ],
	[ nan,   10000,     100,  nan,    0.02,  nan ],
	[ nan,   20000,     200,  nan,    0.10,  nan ],
	[ nan,   30000,     300,  nan,    0.18,  nan ],
	[ nan,   40000,     400,  nan,    0.34,  nan ],
	[ nan,   50000,     500,  nan,    0.76,  nan ],
	[ nan,   60000,     600,  nan,    0.99,  nan ],
	[ nan,   70000,     700,  nan,    1.30,  nan ],
	[ nan,   80000,     800,  nan,    1.63,  nan ],
	[ nan,   90000,     900,  nan,    2.18,  nan ],
	[ nan,  100000,    1000,  nan,    3.48,  nan ],
	[ nan,  200000,    2000,  nan,   18.28,  nan ],
	[ nan,     100,   10000,  nan,    0.04,  nan ],
	[ nan,     200,   20000,  nan,    0.18,  nan ],
	[ nan,     300,   30000,  nan,    0.34,  nan ],
	[ nan,     400,   40000,  nan,    0.50,  nan ],
	[ nan,     500,   50000,  nan,    1.85,  nan ],
	[ nan,     600,   60000,  nan,    2.18,  nan ],
	[ nan,     700,   70000,  nan,    2.55,  nan ],
	[ nan,     800,   80000,  nan,    2.72,  nan ],
	[ nan,     900,   90000,  nan,    3.10,  nan ],
	[ nan,    1000,  100000,  nan,    6.57,  nan ],
	[ nan,    2000,  200000,  nan,   26.70,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/sgetrf.txt
# numactl --interleave=all ./testing_sgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgetrf = array([
	[    10,     10,  nan,  nan,     0.03,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.08,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.45,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.66,  0.00,  nan ],
	[    50,     50,  nan,  nan,     1.61,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.50,  0.00,  nan ],
	[    70,     70,  nan,  nan,     2.10,  0.00,  nan ],
	[    80,     80,  nan,  nan,     3.39,  0.00,  nan ],
	[    90,     90,  nan,  nan,     3.33,  0.00,  nan ],
	[   100,    100,  nan,  nan,     4.60,  0.00,  nan ],
	[   200,    200,  nan,  nan,    16.24,  0.00,  nan ],
	[   300,    300,  nan,  nan,    10.97,  0.00,  nan ],
	[   400,    400,  nan,  nan,    21.24,  0.00,  nan ],
	[   500,    500,  nan,  nan,    31.72,  0.00,  nan ],
	[   600,    600,  nan,  nan,    41.11,  0.00,  nan ],
	[   700,    700,  nan,  nan,    54.26,  0.00,  nan ],
	[   800,    800,  nan,  nan,    65.93,  0.01,  nan ],
	[   900,    900,  nan,  nan,    78.59,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    94.05,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   240.35,  0.02,  nan ],
	[  3000,   3000,  nan,  nan,   403.41,  0.04,  nan ],
	[  4000,   4000,  nan,  nan,   564.04,  0.08,  nan ],
	[  5000,   5000,  nan,  nan,   656.71,  0.13,  nan ],
	[  6000,   6000,  nan,  nan,   848.49,  0.17,  nan ],
	[  7000,   7000,  nan,  nan,   996.31,  0.23,  nan ],
	[  8000,   8000,  nan,  nan,  1136.85,  0.30,  nan ],
	[  9000,   9000,  nan,  nan,  1244.66,  0.39,  nan ],
	[ 10000,  10000,  nan,  nan,  1334.36,  0.50,  nan ],
	[ 12000,  12000,  nan,  nan,  1482.65,  0.78,  nan ],
	[ 14000,  14000,  nan,  nan,  1598.32,  1.14,  nan ],
	[ 16000,  16000,  nan,  nan,  1682.82,  1.62,  nan ],
	[ 18000,  18000,  nan,  nan,  1757.24,  2.21,  nan ],
	[ 20000,  20000,  nan,  nan,  1896.00,  2.81,  nan ],
])

# numactl --interleave=all ./testing_sgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.26,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.44,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.84,  0.00,  nan ],
	[    60,     60,  nan,  nan,     1.32,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.15,  0.00,  nan ],
	[    80,     80,  nan,  nan,     2.17,  0.00,  nan ],
	[    90,     90,  nan,  nan,     2.44,  0.00,  nan ],
	[   100,    100,  nan,  nan,     3.18,  0.00,  nan ],
	[   200,    200,  nan,  nan,     9.15,  0.00,  nan ],
	[   300,    300,  nan,  nan,     8.51,  0.00,  nan ],
	[   400,    400,  nan,  nan,    15.48,  0.00,  nan ],
	[   500,    500,  nan,  nan,    24.88,  0.00,  nan ],
	[   600,    600,  nan,  nan,    34.61,  0.00,  nan ],
	[   700,    700,  nan,  nan,    47.36,  0.00,  nan ],
	[   800,    800,  nan,  nan,    59.18,  0.01,  nan ],
	[   900,    900,  nan,  nan,    73.60,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    87.99,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   252.59,  0.02,  nan ],
	[  3000,   3000,  nan,  nan,   455.66,  0.04,  nan ],
	[  4000,   4000,  nan,  nan,   656.97,  0.06,  nan ],
	[  5000,   5000,  nan,  nan,   729.49,  0.11,  nan ],
	[  6000,   6000,  nan,  nan,   944.08,  0.15,  nan ],
	[  7000,   7000,  nan,  nan,  1121.09,  0.20,  nan ],
	[  8000,   8000,  nan,  nan,  1204.28,  0.28,  nan ],
	[  9000,   9000,  nan,  nan,  1418.28,  0.34,  nan ],
	[ 10000,  10000,  nan,  nan,  1537.15,  0.43,  nan ],
	[ 12000,  12000,  nan,  nan,  1703.22,  0.68,  nan ],
	[ 14000,  14000,  nan,  nan,  1819.34,  1.01,  nan ],
	[ 16000,  16000,  nan,  nan,  1890.63,  1.44,  nan ],
	[ 18000,  18000,  nan,  nan,  1965.96,  1.98,  nan ],
	[ 20000,  20000,  nan,  nan,  2106.88,  2.53,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/spotrf.txt
# numactl --interleave=all ./testing_spotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
spotrf = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,  nan,  nan,     0.07,  0.00,  nan ],
	[    50,  nan,  nan,     0.14,  0.00,  nan ],
	[    60,  nan,  nan,     0.24,  0.00,  nan ],
	[    70,  nan,  nan,     1.70,  0.00,  nan ],
	[    80,  nan,  nan,     2.26,  0.00,  nan ],
	[    90,  nan,  nan,     2.78,  0.00,  nan ],
	[   100,  nan,  nan,     3.42,  0.00,  nan ],
	[   200,  nan,  nan,     5.43,  0.00,  nan ],
	[   300,  nan,  nan,     6.17,  0.00,  nan ],
	[   400,  nan,  nan,    13.90,  0.00,  nan ],
	[   500,  nan,  nan,    23.99,  0.00,  nan ],
	[   600,  nan,  nan,    25.77,  0.00,  nan ],
	[   700,  nan,  nan,    38.10,  0.00,  nan ],
	[   800,  nan,  nan,    42.09,  0.00,  nan ],
	[   900,  nan,  nan,    53.65,  0.00,  nan ],
	[  1000,  nan,  nan,    72.40,  0.00,  nan ],
	[  2000,  nan,  nan,   285.20,  0.01,  nan ],
	[  3000,  nan,  nan,   537.14,  0.02,  nan ],
	[  4000,  nan,  nan,   817.18,  0.03,  nan ],
	[  5000,  nan,  nan,  1014.83,  0.04,  nan ],
	[  6000,  nan,  nan,  1204.58,  0.06,  nan ],
	[  7000,  nan,  nan,  1345.66,  0.08,  nan ],
	[  8000,  nan,  nan,  1493.26,  0.11,  nan ],
	[  9000,  nan,  nan,  1591.92,  0.15,  nan ],
	[ 10000,  nan,  nan,  1687.21,  0.20,  nan ],
	[ 12000,  nan,  nan,  1844.47,  0.31,  nan ],
	[ 14000,  nan,  nan,  1983.09,  0.46,  nan ],
	[ 16000,  nan,  nan,  2086.46,  0.65,  nan ],
	[ 18000,  nan,  nan,  2170.56,  0.90,  nan ],
	[ 20000,  nan,  nan,  2258.64,  1.18,  nan ],
])

# numactl --interleave=all ./testing_spotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
spotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.03,  0.00,  nan ],
	[    50,  nan,  nan,     0.05,  0.00,  nan ],
	[    60,  nan,  nan,     0.08,  0.00,  nan ],
	[    70,  nan,  nan,     0.13,  0.00,  nan ],
	[    80,  nan,  nan,     0.19,  0.00,  nan ],
	[    90,  nan,  nan,     0.27,  0.00,  nan ],
	[   100,  nan,  nan,     0.36,  0.00,  nan ],
	[   200,  nan,  nan,     8.99,  0.00,  nan ],
	[   300,  nan,  nan,     4.95,  0.00,  nan ],
	[   400,  nan,  nan,    10.83,  0.00,  nan ],
	[   500,  nan,  nan,    19.35,  0.00,  nan ],
	[   600,  nan,  nan,    22.63,  0.00,  nan ],
	[   700,  nan,  nan,    34.72,  0.00,  nan ],
	[   800,  nan,  nan,    39.50,  0.00,  nan ],
	[   900,  nan,  nan,    53.08,  0.00,  nan ],
	[  1000,  nan,  nan,    68.66,  0.00,  nan ],
	[  2000,  nan,  nan,   287.91,  0.01,  nan ],
	[  3000,  nan,  nan,   592.52,  0.02,  nan ],
	[  4000,  nan,  nan,   916.09,  0.02,  nan ],
	[  5000,  nan,  nan,  1133.76,  0.04,  nan ],
	[  6000,  nan,  nan,  1368.93,  0.05,  nan ],
	[  7000,  nan,  nan,  1511.83,  0.08,  nan ],
	[  8000,  nan,  nan,  1725.48,  0.10,  nan ],
	[  9000,  nan,  nan,  1856.69,  0.13,  nan ],
	[ 10000,  nan,  nan,  1950.79,  0.17,  nan ],
	[ 12000,  nan,  nan,  2105.77,  0.27,  nan ],
	[ 14000,  nan,  nan,  2230.78,  0.41,  nan ],
	[ 16000,  nan,  nan,  2336.12,  0.58,  nan ],
	[ 18000,  nan,  nan,  2397.51,  0.81,  nan ],
	[ 20000,  nan,  nan,  2475.24,  1.08,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/ssyevd.txt
# numactl --interleave=all ./testing_ssyevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_JN = array([
	[    10,  nan,   0.0000 ],
	[    20,  nan,   0.0000 ],
	[    30,  nan,   0.0001 ],
	[    40,  nan,   0.0001 ],
	[    50,  nan,   0.0002 ],
	[    60,  nan,   0.0002 ],
	[    70,  nan,   0.0003 ],
	[    80,  nan,   0.0004 ],
	[    90,  nan,   0.0005 ],
	[   100,  nan,   0.0006 ],
	[   200,  nan,   0.0103 ],
	[   300,  nan,   0.0185 ],
	[   400,  nan,   0.0315 ],
	[   500,  nan,   0.0430 ],
	[   600,  nan,   0.0585 ],
	[   700,  nan,   0.0732 ],
	[   800,  nan,   0.1004 ],
	[   900,  nan,   0.1142 ],
	[  1000,  nan,   0.1332 ],
	[  2000,  nan,   0.4478 ],
	[  3000,  nan,   0.9329 ],
	[  4000,  nan,   1.5652 ],
	[  5000,  nan,   2.5726 ],
	[  6000,  nan,   3.8303 ],
	[  7000,  nan,   5.3957 ],
	[  8000,  nan,   7.2237 ],
	[  9000,  nan,   9.5361 ],
	[ 10000,  nan,  12.2019 ],
	[ 12000,  nan,  19.3860 ],
	[ 14000,  nan,  28.1998 ],
	[ 16000,  nan,  39.8069 ],
	[ 18000,  nan,  54.8997 ],
	[ 20000,  nan,  71.6659 ],
])

# numactl --interleave=all ./testing_ssyevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_JV = array([
	[    10,  nan,   0.0001 ],
	[    20,  nan,   0.0001 ],
	[    30,  nan,   0.0002 ],
	[    40,  nan,   0.0003 ],
	[    50,  nan,   0.0004 ],
	[    60,  nan,   0.0005 ],
	[    70,  nan,   0.0006 ],
	[    80,  nan,   0.0007 ],
	[    90,  nan,   0.0009 ],
	[   100,  nan,   0.0010 ],
	[   200,  nan,   0.0131 ],
	[   300,  nan,   0.0208 ],
	[   400,  nan,   0.0345 ],
	[   500,  nan,   0.0467 ],
	[   600,  nan,   0.0601 ],
	[   700,  nan,   0.0757 ],
	[   800,  nan,   0.0954 ],
	[   900,  nan,   0.1183 ],
	[  1000,  nan,   0.1358 ],
	[  2000,  nan,   0.4480 ],
	[  3000,  nan,   0.9326 ],
	[  4000,  nan,   1.6237 ],
	[  5000,  nan,   2.5988 ],
	[  6000,  nan,   3.9168 ],
	[  7000,  nan,   5.6690 ],
	[  8000,  nan,   7.4417 ],
	[  9000,  nan,   9.8196 ],
	[ 10000,  nan,  12.6641 ],
	[ 12000,  nan,  20.2119 ],
	[ 14000,  nan,  29.8157 ],
	[ 16000,  nan,  42.1683 ],
	[ 18000,  nan,  58.2346 ],
	[ 20000,  nan,  75.8294 ],
])

# numactl --interleave=all ./testing_ssyevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_gpu_JN = array([
	[    10,  nan,   0.0001 ],
	[    20,  nan,   0.0001 ],
	[    30,  nan,   0.0001 ],
	[    40,  nan,   0.0002 ],
	[    50,  nan,   0.0002 ],
	[    60,  nan,   0.0003 ],
	[    70,  nan,   0.0004 ],
	[    80,  nan,   0.0005 ],
	[    90,  nan,   0.0006 ],
	[   100,  nan,   0.0007 ],
	[   200,  nan,   0.0101 ],
	[   300,  nan,   0.0183 ],
	[   400,  nan,   0.0314 ],
	[   500,  nan,   0.0431 ],
	[   600,  nan,   0.0586 ],
	[   700,  nan,   0.0731 ],
	[   800,  nan,   0.0938 ],
	[   900,  nan,   0.1147 ],
	[  1000,  nan,   0.1341 ],
	[  2000,  nan,   0.4268 ],
	[  3000,  nan,   0.8961 ],
	[  4000,  nan,   1.5610 ],
	[  5000,  nan,   2.5132 ],
	[  6000,  nan,   3.7655 ],
	[  7000,  nan,   5.3641 ],
	[  8000,  nan,   7.2363 ],
	[  9000,  nan,   9.5510 ],
	[ 10000,  nan,  12.2405 ],
	[ 12000,  nan,  19.4162 ],
	[ 14000,  nan,  28.2947 ],
	[ 16000,  nan,  39.8984 ],
	[ 18000,  nan,  55.1168 ],
	[ 20000,  nan,  71.8349 ],
])

# numactl --interleave=all ./testing_ssyevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_gpu_JV = array([
	[    10,  nan,   0.0001 ],
	[    20,  nan,   0.0002 ],
	[    30,  nan,   0.0004 ],
	[    40,  nan,   0.0003 ],
	[    50,  nan,   0.0004 ],
	[    60,  nan,   0.0006 ],
	[    70,  nan,   0.0007 ],
	[    80,  nan,   0.0008 ],
	[    90,  nan,   0.0009 ],
	[   100,  nan,   0.0011 ],
	[   200,  nan,   0.0123 ],
	[   300,  nan,   0.0200 ],
	[   400,  nan,   0.0339 ],
	[   500,  nan,   0.0466 ],
	[   600,  nan,   0.0596 ],
	[   700,  nan,   0.0747 ],
	[   800,  nan,   0.1215 ],
	[   900,  nan,   0.1182 ],
	[  1000,  nan,   0.1369 ],
	[  2000,  nan,   0.4472 ],
	[  3000,  nan,   0.9319 ],
	[  4000,  nan,   1.6236 ],
	[  5000,  nan,   2.6221 ],
	[  6000,  nan,   3.9895 ],
	[  7000,  nan,   5.6979 ],
	[  8000,  nan,   7.7891 ],
	[  9000,  nan,  10.3995 ],
	[ 10000,  nan,  13.3980 ],
	[ 12000,  nan,  21.3793 ],
	[ 14000,  nan,  31.4721 ],
	[ 16000,  nan,  45.0187 ],
	[ 18000,  nan,  62.8949 ],
	[ 20000,  nan,  83.1238 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/ssyevd_2stage.txt
# numactl --interleave=all ./testing_ssyevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevdx_2stage_JN = array([
	[    10,      0,   0.0000 ],
	[    20,      0,   0.0000 ],
	[    30,      0,   0.0000 ],
	[    40,      0,   0.0000 ],
	[    50,      0,   0.0000 ],
	[    60,      0,   0.0000 ],
	[    70,     70,   0.0003 ],
	[    80,     80,   0.0004 ],
	[    90,     90,   0.0004 ],
	[   100,    100,   0.0005 ],
	[   200,    200,   0.0028 ],
	[   300,    300,   0.0156 ],
	[   400,    400,   0.0272 ],
	[   500,    500,   0.0442 ],
	[   600,    600,   0.0605 ],
	[   700,    700,   0.0795 ],
	[   800,    800,   0.0963 ],
	[   900,    900,   0.1214 ],
	[  1000,   1000,   0.1235 ],
	[  2000,   2000,   0.5216 ],
	[  3000,   3000,   0.7768 ],
	[  4000,   4000,   1.1041 ],
	[  5000,   5000,   1.3587 ],
	[  6000,   6000,   1.8045 ],
	[  7000,   7000,   2.3656 ],
	[  8000,   8000,   2.9823 ],
	[  9000,   9000,   3.7799 ],
	[ 10000,  10000,   4.4917 ],
	[ 12000,  12000,   6.5610 ],
	[ 14000,  14000,   8.9986 ],
	[ 16000,  16000,  12.0558 ],
	[ 18000,  18000,  15.9094 ],
	[ 20000,  20000,  20.1123 ],
])

# numactl --interleave=all ./testing_ssyevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevdx_2stage_JV = array([
	[    10,     10,   0.0001 ],
	[    20,     20,   0.0001 ],
	[    30,     30,   0.0002 ],
	[    40,     40,   0.0003 ],
	[    50,     50,   0.0003 ],
	[    60,     60,   0.0005 ],
	[    70,     70,   0.0006 ],
	[    80,     80,   0.0007 ],
	[    90,     90,   0.0009 ],
	[   100,    100,   0.0010 ],
	[   200,    200,   0.0048 ],
	[   300,    300,   0.0382 ],
	[   400,    400,   0.0558 ],
	[   500,    500,   0.0750 ],
	[   600,    600,   0.0928 ],
	[   700,    700,   0.0948 ],
	[   800,    800,   0.1354 ],
	[   900,    900,   0.1444 ],
	[  1000,   1000,   0.1599 ],
	[  2000,   2000,   0.6484 ],
	[  3000,   3000,   0.9724 ],
	[  4000,   4000,   1.6108 ],
	[  5000,   5000,   2.1483 ],
	[  6000,   6000,   3.2763 ],
	[  7000,   7000,   4.0355 ],
	[  8000,   8000,   5.1646 ],
	[  9000,   9000,   7.5894 ],
	[ 10000,  10000,  10.0678 ],
	[ 12000,  12000,  14.1138 ],
	[ 14000,  14000,  22.1149 ],
	[ 16000,  16000,  33.2558 ],
	[ 18000,  18000,  40.8178 ],
	[ 20000,  20000,  54.7261 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/ssymv.txt
# numactl --interleave=all ./testing_ssymv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
ssymv_L = array([
	[   10,   0.0067,  0.0329,    0.0082,  0.0269,   0.0105,  0.0210,   0.1025,  0.0021,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[   11,   0.0085,  0.0310,    0.0105,  0.0250,   0.0140,  0.0188,   0.1384,  0.0019,  4.33e-08,  4.33e-08,  4.33e-08,  nan ],
	[   12,   0.0101,  0.0310,    0.0120,  0.0260,   0.0149,  0.0210,   0.1636,  0.0019,  3.97e-08,  1.99e-08,  1.99e-08,  nan ],
	[   13,   0.0121,  0.0300,    0.0140,  0.0260,   0.0182,  0.0200,   0.1908,  0.0019,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[   14,   0.0128,  0.0329,    0.0162,  0.0260,   0.0210,  0.0200,   0.1957,  0.0021,  6.81e-08,  6.81e-08,  6.81e-08,  nan ],
	[   15,   0.0155,  0.0310,    0.0185,  0.0260,   0.0252,  0.0191,   0.2517,  0.0019,  3.18e-08,  4.77e-08,  6.36e-08,  nan ],
	[   16,   0.0181,  0.0300,    0.0209,  0.0260,   0.0275,  0.0198,   0.2852,  0.0019,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[   17,   0.0204,  0.0300,    0.0225,  0.0272,   0.0306,  0.0200,   0.2139,  0.0029,  5.61e-08,  2.80e-08,  5.61e-08,  nan ],
	[   18,   0.0201,  0.0341,    0.0254,  0.0269,   0.0312,  0.0219,   0.3586,  0.0019,  7.95e-08,  2.65e-08,  5.30e-08,  nan ],
	[   19,   0.0229,  0.0331,    0.0270,  0.0281,   0.0362,  0.0210,   0.2452,  0.0031,  5.02e-08,  5.02e-08,  5.02e-08,  nan ],
	[   20,   0.0271,  0.0310,    0.0299,  0.0281,   0.0396,  0.0212,   0.4404,  0.0019,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[   21,   0.0281,  0.0329,    0.0331,  0.0279,   0.0440,  0.0210,   0.4844,  0.0019,  9.08e-08,  6.81e-08,  4.54e-08,  nan ],
	[   22,   0.0327,  0.0310,    0.0363,  0.0279,   0.0461,  0.0219,   0.3265,  0.0031,  6.50e-08,  4.33e-08,  6.50e-08,  nan ],
	[   23,   0.0346,  0.0319,    0.0392,  0.0281,   0.0477,  0.0231,   0.3562,  0.0031,  4.15e-08,  8.29e-08,  4.15e-08,  nan ],
	[   24,   0.0354,  0.0339,    0.0416,  0.0288,   0.0547,  0.0219,   0.6291,  0.0019,  7.95e-08,  3.97e-08,  3.97e-08,  nan ],
	[   25,   0.0419,  0.0310,    0.0436,  0.0298,   0.0593,  0.0219,   0.6816,  0.0019,  7.63e-08,  7.63e-08,  5.72e-08,  nan ],
	[   26,   0.0415,  0.0339,    0.0487,  0.0288,   0.0669,  0.0210,   0.4907,  0.0029,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[   27,   0.0460,  0.0329,    0.0520,  0.0291,   0.0689,  0.0219,   0.7046,  0.0021,  7.06e-08,  7.06e-08,  7.06e-08,  nan ],
	[   28,   0.0480,  0.0339,    0.0541,  0.0300,   0.0732,  0.0222,   0.5676,  0.0029,  6.81e-08,  6.81e-08,  1.02e-07,  nan ],
	[   29,   0.0561,  0.0310,    0.0584,  0.0298,   0.0793,  0.0219,   0.5614,  0.0031,  6.58e-08,  6.58e-08,  9.87e-08,  nan ],
	[   30,   0.0561,  0.0331,    0.0619,  0.0300,   0.0848,  0.0219,   0.6001,  0.0031,  9.54e-08,  9.54e-08,  1.27e-07,  nan ],
	[   31,   0.0599,  0.0331,    0.0666,  0.0298,   0.0905,  0.0219,   0.6401,  0.0031,  9.23e-08,  6.15e-08,  9.23e-08,  nan ],
	[   32,   0.0681,  0.0310,    0.0681,  0.0310,   0.0923,  0.0229,   0.6814,  0.0031,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[   33,   0.0702,  0.0319,    0.0747,  0.0300,   0.0980,  0.0229,   0.7240,  0.0031,  8.67e-08,  1.16e-07,  5.78e-08,  nan ],
	[   34,   0.0723,  0.0329,    0.0768,  0.0310,   0.0998,  0.0238,   0.7679,  0.0031,  5.61e-08,  8.41e-08,  5.61e-08,  nan ],
	[   35,   0.0744,  0.0339,    0.0839,  0.0300,   0.1101,  0.0229,   0.8808,  0.0029,  5.45e-08,  5.45e-08,  5.45e-08,  nan ],
	[   36,   0.0834,  0.0319,    0.0887,  0.0300,   0.1164,  0.0229,   0.6573,  0.0041,  7.95e-08,  5.30e-08,  5.30e-08,  nan ],
	[   37,   0.0907,  0.0310,    0.0967,  0.0291,   0.1282,  0.0219,   0.6938,  0.0041,  1.03e-07,  1.03e-07,  1.03e-07,  nan ],
	[   38,   0.0956,  0.0310,    0.1019,  0.0291,   0.1282,  0.0231,   0.7313,  0.0041,  7.53e-08,  5.02e-08,  7.53e-08,  nan ],
	[   39,   0.0948,  0.0329,    0.1118,  0.0279,   0.1363,  0.0229,   0.7698,  0.0041,  4.89e-08,  4.89e-08,  4.89e-08,  nan ],
	[   40,   0.1058,  0.0310,    0.1092,  0.0300,   0.1362,  0.0241,   1.0583,  0.0031,  7.15e-08,  9.54e-08,  7.15e-08,  nan ],
	[   41,   0.1078,  0.0319,    0.1156,  0.0298,   0.1570,  0.0219,   1.1112,  0.0031,  6.98e-08,  6.98e-08,  6.98e-08,  nan ],
	[   42,   0.1165,  0.0310,    0.1202,  0.0300,   0.1629,  0.0222,   1.1654,  0.0031,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[   43,   0.1184,  0.0319,    0.1260,  0.0300,   0.1571,  0.0241,   0.9336,  0.0041,  8.87e-08,  8.87e-08,  8.87e-08,  nan ],
	[   44,   0.1240,  0.0319,    0.1278,  0.0310,   0.1329,  0.0298,   1.0381,  0.0038,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[   45,   0.1223,  0.0339,    0.1336,  0.0310,   0.1736,  0.0238,   1.0214,  0.0041,  8.48e-08,  8.48e-08,  8.48e-08,  nan ],
	[   46,   0.1268,  0.0341,    0.1395,  0.0310,   0.1796,  0.0241,   0.8636,  0.0050,  8.29e-08,  1.24e-07,  8.29e-08,  nan ],
	[   47,   0.1412,  0.0319,    0.1514,  0.0298,   0.1874,  0.0241,   1.1828,  0.0038,  8.12e-08,  8.12e-08,  8.12e-08,  nan ],
	[   48,   0.1389,  0.0339,    0.1566,  0.0300,   0.1973,  0.0238,   1.1606,  0.0041,  7.95e-08,  3.97e-08,  7.95e-08,  nan ],
	[   49,   0.1479,  0.0331,    0.1569,  0.0312,   0.1976,  0.0248,   1.2089,  0.0041,  7.79e-08,  7.79e-08,  7.79e-08,  nan ],
	[   50,   0.1455,  0.0350,    0.1645,  0.0310,   0.2037,  0.0250,   1.0186,  0.0050,  3.81e-08,  5.72e-08,  5.72e-08,  nan ],
	[   51,   0.1648,  0.0322,    0.1711,  0.0310,   0.2119,  0.0250,   1.3086,  0.0041,  7.48e-08,  5.61e-08,  7.48e-08,  nan ],
	[   52,   0.1628,  0.0339,    0.1778,  0.0310,   0.2121,  0.0260,   1.3599,  0.0041,  1.10e-07,  1.10e-07,  1.10e-07,  nan ],
	[   53,   0.1691,  0.0339,    0.1847,  0.0310,   0.2203,  0.0260,   1.1432,  0.0050,  9.00e-08,  1.08e-07,  7.20e-08,  nan ],
	[   54,   0.1695,  0.0350,    0.1916,  0.0310,   0.2373,  0.0250,   1.1864,  0.0050,  1.06e-07,  1.06e-07,  1.06e-07,  nan ],
	[   55,   0.1872,  0.0329,    0.2051,  0.0300,   0.2370,  0.0260,   1.2303,  0.0050,  6.94e-08,  6.94e-08,  6.94e-08,  nan ],
	[   56,   0.1872,  0.0341,    0.2060,  0.0310,   0.2457,  0.0260,   1.5751,  0.0041,  6.81e-08,  6.81e-08,  3.41e-08,  nan ],
	[   57,   0.1900,  0.0348,    0.1887,  0.0350,   0.2641,  0.0250,   1.6313,  0.0041,  6.69e-08,  6.69e-08,  6.69e-08,  nan ],
	[   58,   0.2142,  0.0319,    0.2208,  0.0310,   0.2634,  0.0260,   1.3669,  0.0050,  9.87e-08,  1.32e-07,  9.87e-08,  nan ],
	[   59,   0.2034,  0.0348,    0.2284,  0.0310,   0.2724,  0.0260,   1.4141,  0.0050,  9.70e-08,  6.47e-08,  6.47e-08,  nan ],
	[   60,   0.2089,  0.0350,    0.2362,  0.0310,   0.2817,  0.0260,   1.4620,  0.0050,  1.27e-07,  9.54e-08,  9.54e-08,  nan ],
	[   61,   0.2440,  0.0310,    0.2440,  0.0310,   0.2808,  0.0269,   1.5107,  0.0050,  1.25e-07,  1.25e-07,  9.38e-08,  nan ],
	[   62,   0.2445,  0.0319,    0.2520,  0.0310,   0.2900,  0.0269,   1.3106,  0.0060,  9.23e-08,  9.23e-08,  1.23e-07,  nan ],
	[   63,   0.2524,  0.0319,    0.2706,  0.0298,   0.3221,  0.0250,   1.3529,  0.0060,  9.08e-08,  9.08e-08,  1.51e-07,  nan ],
	[   64,   0.2664,  0.0312,    0.2792,  0.0298,   0.3202,  0.0260,   1.6617,  0.0050,  8.94e-08,  5.96e-08,  8.94e-08,  nan ],
	[   65,   0.2448,  0.0350,    0.2263,  0.0379,   0.3185,  0.0269,   1.7137,  0.0050,  5.87e-08,  5.87e-08,  8.80e-08,  nan ],
	[   66,   0.2523,  0.0350,    0.1297,  0.0682,   0.3283,  0.0269,   1.7664,  0.0050,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[   67,   0.2600,  0.0350,    0.2531,  0.0360,   0.3133,  0.0291,   1.5287,  0.0060,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   68,   0.2607,  0.0360,    0.2607,  0.0360,   0.3364,  0.0279,   1.5744,  0.0060,  1.40e-07,  1.12e-07,  1.40e-07,  nan ],
	[   69,   0.2833,  0.0341,    0.2683,  0.0360,   0.3434,  0.0281,   1.9294,  0.0050,  8.29e-08,  8.29e-08,  1.11e-07,  nan ],
	[   70,   0.2690,  0.0370,    0.2690,  0.0370,   0.3563,  0.0279,   1.6677,  0.0060,  1.36e-07,  1.63e-07,  1.63e-07,  nan ],
	[   71,   0.2697,  0.0379,    0.2767,  0.0370,   0.3544,  0.0288,   1.7153,  0.0060,  8.06e-08,  1.61e-07,  1.07e-07,  nan ],
	[   72,   0.2756,  0.0381,    0.2845,  0.0370,   0.3614,  0.0291,   2.5936,  0.0041,  1.06e-07,  1.06e-07,  1.32e-07,  nan ],
	[   73,   0.3001,  0.0360,    0.2850,  0.0379,   0.3596,  0.0300,   2.1579,  0.0050,  1.05e-07,  7.84e-08,  1.05e-07,  nan ],
	[   74,   0.2928,  0.0379,    0.3004,  0.0370,   0.3945,  0.0281,   1.7906,  0.0062,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[   75,   0.3253,  0.0350,    0.3065,  0.0372,   0.4052,  0.0281,   1.9126,  0.0060,  1.27e-07,  7.63e-08,  7.63e-08,  nan ],
	[   76,   0.3167,  0.0370,    0.3251,  0.0360,   0.4057,  0.0288,   1.9636,  0.0060,  1.00e-07,  1.00e-07,  7.53e-08,  nan ],
	[   77,   0.3250,  0.0370,    0.3250,  0.0370,   0.4306,  0.0279,   1.9378,  0.0062,  9.91e-08,  9.91e-08,  9.91e-08,  nan ],
	[   78,   0.3516,  0.0350,    0.3251,  0.0379,   0.4418,  0.0279,   2.4615,  0.0050,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[   79,   0.3420,  0.0370,    0.3420,  0.0370,   0.4346,  0.0291,   2.1206,  0.0060,  9.66e-08,  1.45e-07,  1.21e-07,  nan ],
	[   80,   0.3600,  0.0360,    0.3484,  0.0372,   0.4607,  0.0281,   2.7179,  0.0048,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[   81,   0.3690,  0.0360,    0.3504,  0.0379,   0.4762,  0.0279,   2.6532,  0.0050,  9.42e-08,  1.18e-07,  1.18e-07,  nan ],
	[   82,   0.3591,  0.0379,    0.3683,  0.0370,   0.4838,  0.0281,   2.2837,  0.0060,  1.40e-07,  1.40e-07,  9.30e-08,  nan ],
	[   83,   0.3873,  0.0360,    0.3655,  0.0381,   0.4794,  0.0291,   2.7850,  0.0050,  1.15e-07,  9.19e-08,  9.19e-08,  nan ],
	[   84,   0.3767,  0.0379,    0.3864,  0.0370,   0.5119,  0.0279,   2.3958,  0.0060,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[   85,   0.3931,  0.0372,    0.3484,  0.0420,   0.5197,  0.0281,   2.1145,  0.0069,  8.98e-08,  8.98e-08,  1.35e-07,  nan ],
	[   86,   0.4270,  0.0350,    0.4049,  0.0370,   0.5364,  0.0279,   2.1643,  0.0069,  1.33e-07,  1.33e-07,  8.87e-08,  nan ],
	[   87,   0.4369,  0.0350,    0.4143,  0.0370,   0.5489,  0.0279,   2.2146,  0.0069,  8.77e-08,  6.58e-08,  8.77e-08,  nan ],
	[   88,   0.4351,  0.0360,    0.4239,  0.0370,   0.5385,  0.0291,   3.1286,  0.0050,  1.30e-07,  8.67e-08,  8.67e-08,  nan ],
	[   89,   0.4335,  0.0370,    0.4307,  0.0372,   0.5508,  0.0291,   2.6877,  0.0060,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[   90,   0.4432,  0.0370,    0.4432,  0.0370,   0.5872,  0.0279,   2.3691,  0.0069,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[  100,   0.5295,  0.0381,    0.5295,  0.0381,   0.6778,  0.0298,   2.9215,  0.0069,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[  110,   0.6442,  0.0379,    0.6245,  0.0391,   0.7879,  0.0310,   3.0125,  0.0081,  1.39e-07,  1.39e-07,  1.04e-07,  nan ],
	[  120,   0.7858,  0.0370,    0.7427,  0.0391,   0.9369,  0.0310,   3.5824,  0.0081,  9.54e-08,  1.27e-07,  1.27e-07,  nan ],
	[  130,   0.8554,  0.0398,    0.9217,  0.0370,   1.0582,  0.0322,   3.7594,  0.0091,  1.47e-07,  1.47e-07,  1.47e-07,  nan ],
	[  140,   0.9627,  0.0410,    1.0415,  0.0379,   1.1999,  0.0329,   5.0179,  0.0079,  2.18e-07,  1.63e-07,  1.63e-07,  nan ],
	[  150,   1.1047,  0.0410,    1.1875,  0.0381,   1.3669,  0.0331,   4.1305,  0.0110,  1.53e-07,  1.27e-07,  1.53e-07,  nan ],
	[  160,   1.2563,  0.0410,    1.3591,  0.0379,   1.5218,  0.0339,   5.6866,  0.0091,  1.43e-07,  1.43e-07,  1.43e-07,  nan ],
	[  170,   1.3253,  0.0439,    1.4515,  0.0401,   1.6149,  0.0360,   5.8061,  0.0100,  1.35e-07,  1.35e-07,  1.35e-07,  nan ],
	[  180,   1.5441,  0.0422,    1.5890,  0.0410,   1.8099,  0.0360,   6.5072,  0.0100,  1.70e-07,  1.27e-07,  1.27e-07,  nan ],
	[  190,   1.6819,  0.0432,    1.7699,  0.0410,   2.0160,  0.0360,   5.9691,  0.0122,  2.41e-07,  2.01e-07,  1.61e-07,  nan ],
	[  200,   1.7473,  0.0460,    1.9606,  0.0410,   2.1756,  0.0370,   8.8743,  0.0091,  1.53e-07,  1.53e-07,  1.53e-07,  nan ],
	[  210,   1.9259,  0.0460,    2.1610,  0.0410,   2.2804,  0.0389,   7.4340,  0.0119,  1.82e-07,  1.82e-07,  1.82e-07,  nan ],
	[  220,   2.1132,  0.0460,    2.3712,  0.0410,   2.5651,  0.0379,   8.8664,  0.0110,  1.73e-07,  2.08e-07,  1.73e-07,  nan ],
	[  230,   2.2624,  0.0470,    2.5912,  0.0410,   2.7176,  0.0391,   7.5540,  0.0141,  2.32e-07,  1.66e-07,  1.66e-07,  nan ],
	[  240,   2.5140,  0.0460,    2.8209,  0.0410,   2.9054,  0.0398,   8.3655,  0.0138,  2.23e-07,  2.54e-07,  2.23e-07,  nan ],
	[  250,   2.6720,  0.0470,    2.9739,  0.0422,   3.2899,  0.0381,   8.3553,  0.0150,  2.75e-07,  2.75e-07,  3.05e-07,  nan ],
	[  260,   2.6601,  0.0510,    3.2344,  0.0420,   3.2344,  0.0420,   4.0953,  0.0331,  1.17e-07,  8.80e-08,  8.80e-08,  nan ],
	[  270,   2.8682,  0.0510,    3.4875,  0.0420,   3.4100,  0.0429,   5.2016,  0.0281,  1.13e-07,  5.65e-08,  8.48e-08,  nan ],
	[  280,   3.0276,  0.0520,    3.6668,  0.0429,   3.7501,  0.0420,   5.2801,  0.0298,  8.17e-08,  5.45e-08,  8.17e-08,  nan ],
	[  290,   3.1888,  0.0529,    3.9329,  0.0429,   3.9111,  0.0432,   4.9505,  0.0341,  1.05e-07,  7.89e-08,  1.05e-07,  nan ],
	[  300,   3.4747,  0.0520,    4.2083,  0.0429,   4.3039,  0.0420,   5.2971,  0.0341,  1.02e-07,  7.63e-08,  1.02e-07,  nan ],
	[  310,   3.7098,  0.0520,    4.3716,  0.0441,   4.3954,  0.0439,   5.8183,  0.0331,  9.84e-08,  7.38e-08,  1.23e-07,  nan ],
	[  320,   4.0265,  0.0510,    4.7871,  0.0429,   4.6577,  0.0441,   5.2541,  0.0391,  9.54e-08,  9.54e-08,  1.43e-07,  nan ],
	[  330,   3.8991,  0.0560,    4.8481,  0.0451,   4.7476,  0.0460,   5.6214,  0.0389,  1.16e-07,  9.25e-08,  9.25e-08,  nan ],
	[  340,   4.0694,  0.0570,    5.1733,  0.0448,   5.0392,  0.0460,   5.8238,  0.0398,  1.12e-07,  8.98e-08,  1.12e-07,  nan ],
	[  350,   4.4806,  0.0548,    5.4526,  0.0451,   5.4526,  0.0451,   5.9915,  0.0410,  8.72e-08,  8.72e-08,  8.72e-08,  nan ],
	[  360,   4.4864,  0.0579,    5.5339,  0.0470,   5.4238,  0.0479,   6.3383,  0.0410,  1.48e-07,  1.06e-07,  8.48e-08,  nan ],
	[  370,   4.7387,  0.0579,    6.1250,  0.0448,   5.8452,  0.0470,   7.2422,  0.0379,  1.24e-07,  1.65e-07,  1.24e-07,  nan ],
	[  380,   4.8195,  0.0601,    6.1650,  0.0470,   6.0124,  0.0482,   7.6384,  0.0379,  1.20e-07,  1.20e-07,  1.20e-07,  nan ],
	[  390,   5.1580,  0.0591,    6.8041,  0.0448,   6.3641,  0.0479,   8.5279,  0.0358,  1.17e-07,  1.17e-07,  1.17e-07,  nan ],
	[  400,   5.2560,  0.0610,    6.8301,  0.0470,   6.4073,  0.0501,   9.2160,  0.0348,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[  410,   5.5434,  0.0608,    7.3242,  0.0460,   6.7313,  0.0501,   9.3614,  0.0360,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[  420,   5.7940,  0.0610,    7.3795,  0.0479,   6.9312,  0.0510,   9.5082,  0.0372,  1.09e-07,  1.45e-07,  1.09e-07,  nan ],
	[  430,   5.8889,  0.0629,    7.8917,  0.0470,   7.2648,  0.0510,  10.0301,  0.0370,  1.42e-07,  1.06e-07,  1.06e-07,  nan ],
	[  440,   6.1656,  0.0629,    8.0580,  0.0482,   7.6062,  0.0510,  10.1733,  0.0381,  1.04e-07,  1.04e-07,  1.04e-07,  nan ],
	[  450,   6.2591,  0.0648,    8.2644,  0.0491,   7.6688,  0.0529,  11.2746,  0.0360,  1.02e-07,  1.36e-07,  1.02e-07,  nan ],
	[  460,   6.5161,  0.0651,    8.8502,  0.0479,   8.0130,  0.0529,  11.4031,  0.0372,  9.95e-08,  1.33e-07,  9.95e-08,  nan ],
	[  470,   6.8272,  0.0648,    9.1930,  0.0482,   8.2168,  0.0539,  11.9806,  0.0370,  9.74e-08,  9.74e-08,  9.74e-08,  nan ],
	[  480,   6.9919,  0.0660,    9.4018,  0.0491,   8.5697,  0.0539,  11.0043,  0.0420,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[  490,   7.3927,  0.0651,    9.8450,  0.0489,   9.0911,  0.0529,  10.9686,  0.0439,  9.34e-08,  1.25e-07,  1.25e-07,  nan ],
	[  500,   7.3731,  0.0679,   10.2505,  0.0489,   8.7556,  0.0572,  12.2171,  0.0410,  9.16e-08,  1.22e-07,  1.53e-07,  nan ],
	[  510,   7.8923,  0.0660,   10.4601,  0.0498,   8.9965,  0.0579,  12.0782,  0.0432,  8.98e-08,  8.98e-08,  8.98e-08,  nan ],
	[  520,   7.7565,  0.0699,   10.6198,  0.0510,   9.0184,  0.0601,  11.3067,  0.0479,  1.47e-07,  8.80e-08,  1.17e-07,  nan ],
	[  530,   7.9488,  0.0708,   11.2419,  0.0501,   9.3683,  0.0601,  12.2322,  0.0460,  1.44e-07,  1.15e-07,  1.15e-07,  nan ],
	[  540,   8.4505,  0.0691,   12.1319,  0.0482,   9.5728,  0.0610,  12.6977,  0.0460,  1.13e-07,  1.13e-07,  1.13e-07,  nan ],
	[  550,   8.4178,  0.0720,   11.8793,  0.0510,   9.6294,  0.0629,  12.4008,  0.0489,  1.39e-07,  1.11e-07,  1.11e-07,  nan ],
	[  560,   8.9638,  0.0701,   12.7930,  0.0491,  10.2944,  0.0610,  12.7930,  0.0491,  1.36e-07,  1.09e-07,  1.09e-07,  nan ],
	[  570,   9.1619,  0.0710,   12.2984,  0.0529,  10.1875,  0.0639,  13.0011,  0.0501,  1.34e-07,  1.07e-07,  1.07e-07,  nan ],
	[  580,   8.6446,  0.0780,   12.9669,  0.0520,  10.0598,  0.0670,  13.7892,  0.0489,  1.05e-07,  1.05e-07,  1.05e-07,  nan ],
	[  590,   9.2858,  0.0751,   13.1758,  0.0529,  10.7144,  0.0651,  13.1167,  0.0532,  1.29e-07,  1.03e-07,  1.29e-07,  nan ],
	[  600,   9.6335,  0.0749,   13.5647,  0.0532,  10.9203,  0.0660,  13.6258,  0.0529,  1.27e-07,  1.53e-07,  1.27e-07,  nan ],
	[  610,   9.5612,  0.0780,   13.7732,  0.0541,  10.8184,  0.0689,  14.0834,  0.0529,  1.25e-07,  1.00e-07,  1.25e-07,  nan ],
	[  620,   9.8469,  0.0782,   13.9817,  0.0551,  11.1372,  0.0691,  13.9817,  0.0551,  1.23e-07,  9.84e-08,  1.23e-07,  nan ],
	[  630,   9.9544,  0.0799,   14.4360,  0.0551,  11.1903,  0.0710,  14.7554,  0.0539,  1.21e-07,  1.21e-07,  1.21e-07,  nan ],
	[  640,  10.6874,  0.0768,   15.5015,  0.0529,  11.7052,  0.0701,  14.8976,  0.0551,  9.54e-08,  1.19e-07,  1.19e-07,  nan ],
	[  650,  10.2001,  0.0830,   15.3664,  0.0551,  11.6001,  0.0730,  14.6076,  0.0579,  1.17e-07,  1.17e-07,  1.41e-07,  nan ],
	[  660,  10.9242,  0.0799,   16.1216,  0.0541,  12.1179,  0.0720,  15.3122,  0.0570,  1.39e-07,  1.16e-07,  1.16e-07,  nan ],
	[  670,  10.7138,  0.0839,   16.0479,  0.0560,  11.8222,  0.0761,  14.5049,  0.0620,  1.37e-07,  9.11e-08,  9.11e-08,  nan ],
	[  680,  11.1626,  0.0830,   16.8164,  0.0551,  12.3321,  0.0751,  15.9860,  0.0579,  1.12e-07,  1.35e-07,  1.35e-07,  nan ],
	[  690,  11.2034,  0.0851,   17.0196,  0.0560,  12.5379,  0.0761,  15.6235,  0.0610,  1.33e-07,  1.33e-07,  1.33e-07,  nan ],
	[  700,  11.9660,  0.0820,   17.2230,  0.0570,  12.7439,  0.0770,  15.0780,  0.0651,  1.31e-07,  1.31e-07,  1.31e-07,  nan ],
	[  710,  11.8951,  0.0849,   18.0198,  0.0560,  13.1104,  0.0770,  15.5686,  0.0648,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[  720,  11.8013,  0.0880,   18.1446,  0.0572,  13.3171,  0.0780,  16.2489,  0.0639,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[  730,  12.4000,  0.0861,   18.7298,  0.0570,  13.6893,  0.0780,  16.3971,  0.0651,  1.25e-07,  1.25e-07,  1.25e-07,  nan ],
	[  740,  11.9166,  0.0920,   18.9293,  0.0579,  13.5289,  0.0811,  17.0997,  0.0641,  1.24e-07,  1.24e-07,  1.24e-07,  nan ],
	[  750,  12.8046,  0.0880,   19.4440,  0.0579,  14.2746,  0.0789,  16.3491,  0.0689,  1.22e-07,  1.22e-07,  1.63e-07,  nan ],
	[  760,  12.7006,  0.0911,   19.6422,  0.0589,  14.3116,  0.0808,  16.2807,  0.0710,  1.20e-07,  1.20e-07,  1.20e-07,  nan ],
	[  770,  13.0368,  0.0911,   19.7622,  0.0601,  14.3105,  0.0830,  16.2747,  0.0730,  1.19e-07,  1.19e-07,  1.59e-07,  nan ],
	[  780,  13.1030,  0.0930,   20.2785,  0.0601,  14.6423,  0.0832,  16.0193,  0.0761,  1.57e-07,  1.17e-07,  1.57e-07,  nan ],
	[  790,  13.4409,  0.0930,   21.2225,  0.0589,  15.2382,  0.0820,  16.2290,  0.0770,  1.55e-07,  1.55e-07,  1.16e-07,  nan ],
	[  800,  13.9260,  0.0920,   21.3310,  0.0601,  15.4466,  0.0830,  16.2399,  0.0789,  1.53e-07,  1.14e-07,  1.53e-07,  nan ],
	[  810,  13.7079,  0.0958,   21.1945,  0.0620,  15.2647,  0.0861,  17.0606,  0.0770,  1.13e-07,  1.13e-07,  1.51e-07,  nan ],
	[  820,  13.8756,  0.0970,   22.0601,  0.0610,  15.6437,  0.0861,  17.2703,  0.0780,  1.49e-07,  1.12e-07,  1.49e-07,  nan ],
	[  830,  14.3570,  0.0961,   22.6011,  0.0610,  16.2525,  0.0849,  16.8194,  0.0820,  1.47e-07,  1.10e-07,  1.10e-07,  nan ],
	[  840,  14.1096,  0.1001,   22.4472,  0.0629,  16.0163,  0.0882,  16.9801,  0.0832,  1.45e-07,  1.45e-07,  1.09e-07,  nan ],
	[  850,  14.0461,  0.1030,   22.8977,  0.0632,  16.4442,  0.0880,  17.2384,  0.0839,  1.08e-07,  1.44e-07,  1.08e-07,  nan ],
	[  860,  14.6842,  0.1009,   23.8901,  0.0620,  16.8331,  0.0880,  17.0176,  0.0870,  1.42e-07,  1.42e-07,  1.06e-07,  nan ],
	[  870,  14.5794,  0.1040,   23.6306,  0.0641,  16.9964,  0.0892,  17.4154,  0.0870,  1.40e-07,  1.40e-07,  1.40e-07,  nan ],
	[  880,  14.8822,  0.1042,   24.2669,  0.0639,  17.2507,  0.0899,  17.6247,  0.0880,  1.39e-07,  1.39e-07,  1.39e-07,  nan ],
	[  890,  15.2571,  0.1040,   24.8212,  0.0639,  17.8340,  0.0889,  17.5981,  0.0901,  1.03e-07,  1.37e-07,  1.03e-07,  nan ],
	[  900,  14.7556,  0.1099,   24.5571,  0.0660,  17.6226,  0.0920,  18.0433,  0.0899,  1.36e-07,  1.36e-07,  1.36e-07,  nan ],
	[ 1000,  17.2778,  0.1159,   28.5612,  0.0701,  19.2592,  0.1040,  18.7016,  0.1070,  1.22e-07,  1.22e-07,  1.53e-07,  nan ],
	[ 1100,  18.3383,  0.1321,   31.4534,  0.0770,  20.3596,  0.1190,  20.6913,  0.1171,  1.66e-07,  1.39e-07,  1.39e-07,  nan ],
	[ 1200,  20.7370,  0.1390,   36.5247,  0.0789,  23.7985,  0.1211,  18.5709,  0.1552,  1.78e-07,  1.27e-07,  1.27e-07,  nan ],
	[ 1300,  22.0991,  0.1531,   39.7413,  0.0851,  26.0324,  0.1299,  24.5037,  0.1380,  1.64e-07,  1.17e-07,  1.64e-07,  nan ],
	[ 1400,  24.5207,  0.1600,   44.1110,  0.0889,  29.0696,  0.1349,  23.7766,  0.1650,  1.74e-07,  1.74e-07,  1.31e-07,  nan ],
	[ 1500,  26.6389,  0.1690,   48.9299,  0.0920,  29.8372,  0.1509,  24.5924,  0.1831,  2.03e-07,  1.63e-07,  1.63e-07,  nan ],
	[ 1600,  28.3113,  0.1810,   53.3207,  0.0961,  31.8345,  0.1609,  26.2693,  0.1950,  1.91e-07,  1.53e-07,  1.53e-07,  nan ],
	[ 1700,  29.9473,  0.1931,   54.6336,  0.1059,  32.5165,  0.1779,  27.4094,  0.2110,  1.80e-07,  2.15e-07,  1.80e-07,  nan ],
	[ 1800,  31.7689,  0.2041,   58.4821,  0.1109,  36.0188,  0.1800,  26.1483,  0.2480,  1.70e-07,  1.70e-07,  1.70e-07,  nan ],
	[ 1900,  33.9292,  0.2129,   64.4656,  0.1121,  38.0161,  0.1900,  24.9784,  0.2892,  2.25e-07,  1.61e-07,  1.61e-07,  nan ],
	[ 2000,  35.5627,  0.2251,   62.9854,  0.1271,  37.0543,  0.2160,  27.0300,  0.2961,  2.14e-07,  1.53e-07,  1.53e-07,  nan ],
	[ 2100,  37.9994,  0.2322,   65.8565,  0.1340,  24.3817,  0.3619,  25.7381,  0.3428,  2.03e-07,  1.74e-07,  1.74e-07,  nan ],
	[ 2200,  38.4289,  0.2520,   68.2678,  0.1419,  25.3554,  0.3819,  27.0435,  0.3581,  2.50e-07,  1.66e-07,  1.39e-07,  nan ],
	[ 2300,  41.0305,  0.2580,   71.4896,  0.1481,  25.8863,  0.4089,  29.6560,  0.3569,  2.92e-07,  1.86e-07,  1.86e-07,  nan ],
	[ 2400,  41.7431,  0.2761,   74.2527,  0.1552,  27.1717,  0.4241,  30.6522,  0.3760,  2.29e-07,  1.78e-07,  1.78e-07,  nan ],
	[ 2500,  43.5629,  0.2871,   79.7109,  0.1569,  27.9732,  0.4470,   4.3862,  2.8510,  2.69e-07,  1.71e-07,  1.46e-07,  nan ],
	[ 2600,  45.9715,  0.2942,   80.9255,  0.1671,  29.0321,  0.4659,  31.0163,  0.4361,  2.11e-07,  1.88e-07,  1.88e-07,  nan ],
	[ 2700,  47.2034,  0.3090,   82.8938,  0.1760,  30.1358,  0.4840,  34.0811,  0.4280,  2.26e-07,  1.81e-07,  1.58e-07,  nan ],
	[ 2800,  49.1705,  0.3190,   88.5467,  0.1771,  31.4334,  0.4990,  32.2027,  0.4871,  2.62e-07,  1.74e-07,  1.74e-07,  nan ],
	[ 2900,  50.8448,  0.3309,   90.9440,  0.1850,  32.4770,  0.5181,  33.5261,  0.5019,  2.53e-07,  2.10e-07,  1.68e-07,  nan ],
	[ 3000,  52.5192,  0.3428,   94.2854,  0.1910,  33.5955,  0.5360,  34.7710,  0.5178,  3.26e-07,  2.44e-07,  2.03e-07,  nan ],
	[ 3100,  54.1575,  0.3550,   97.6278,  0.1969,  34.4470,  0.5581,  35.2758,  0.5450,  2.36e-07,  2.36e-07,  1.97e-07,  nan ],
	[ 3200,  55.6517,  0.3681,  100.9708,  0.2029,  35.5655,  0.5760,  35.8773,  0.5710,  2.67e-07,  1.91e-07,  1.53e-07,  nan ],
	[ 3300,  57.4715,  0.3791,  103.7226,  0.2100,  36.1184,  0.6032,  36.9211,  0.5901,  2.96e-07,  2.22e-07,  1.85e-07,  nan ],
	[ 3400,  59.7664,  0.3870,  104.6395,  0.2210,  37.8466,  0.6111,  31.9924,  0.7229,  2.87e-07,  2.15e-07,  2.15e-07,  nan ],
	[ 3500,  60.9667,  0.4020,  107.8592,  0.2272,  38.4692,  0.6371,  32.5387,  0.7532,  3.14e-07,  2.09e-07,  1.74e-07,  nan ],
	[ 3600,  62.1764,  0.4170,  111.3066,  0.2329,  39.4724,  0.6568,  35.7132,  0.7260,  2.71e-07,  2.37e-07,  2.03e-07,  nan ],
])

# numactl --interleave=all ./testing_ssymv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
ssymv_L = array([
	[    10,    0.0054,  0.0410,    0.0065,  0.0339,   0.0082,   0.0269,   0.1025,   0.0021,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[    11,    0.0069,  0.0381,    0.0080,  0.0331,   0.0105,   0.0250,   0.0923,   0.0029,  4.33e-08,  4.33e-08,  4.33e-08,  nan ],
	[    12,    0.0082,  0.0379,    0.0097,  0.0322,   0.0120,   0.0260,   0.1091,   0.0029,  3.97e-08,  1.99e-08,  1.99e-08,  nan ],
	[    13,    0.0096,  0.0379,    0.0108,  0.0339,   0.0135,   0.0269,   0.1272,   0.0029,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[    14,    0.0108,  0.0389,    0.0128,  0.0329,   0.0169,   0.0248,   0.1468,   0.0029,  6.81e-08,  6.81e-08,  6.81e-08,  nan ],
	[    15,    0.0120,  0.0401,    0.0141,  0.0341,   0.0192,   0.0250,   0.1678,   0.0029,  3.18e-08,  4.77e-08,  6.36e-08,  nan ],
	[    16,    0.0137,  0.0398,    0.0161,  0.0339,   0.0209,   0.0260,   0.2852,   0.0019,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    17,    0.0161,  0.0379,    0.0181,  0.0339,   0.0227,   0.0269,   0.2139,   0.0029,  5.61e-08,  2.80e-08,  5.61e-08,  nan ],
	[    18,    0.0185,  0.0370,    0.0202,  0.0339,   0.0254,   0.0269,   0.2207,   0.0031,  7.95e-08,  2.65e-08,  5.30e-08,  nan ],
	[    19,    0.0206,  0.0370,    0.0229,  0.0331,   0.0304,   0.0250,   0.2656,   0.0029,  5.02e-08,  5.02e-08,  5.02e-08,  nan ],
	[    20,    0.0233,  0.0360,    0.0263,  0.0319,   0.0323,   0.0260,   0.2710,   0.0031,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[    21,    0.0248,  0.0372,    0.0273,  0.0339,   0.0356,   0.0260,   0.3230,   0.0029,  9.08e-08,  6.81e-08,  4.54e-08,  nan ],
	[    22,    0.0281,  0.0360,    0.0305,  0.0331,   0.0389,   0.0260,   0.3537,   0.0029,  6.50e-08,  4.33e-08,  6.50e-08,  nan ],
	[    23,    0.0299,  0.0370,    0.0336,  0.0329,   0.0425,   0.0260,   0.3562,   0.0031,  4.15e-08,  8.29e-08,  4.15e-08,  nan ],
	[    24,    0.0333,  0.0360,    0.0333,  0.0360,   0.0445,   0.0269,   0.2961,   0.0041,  7.95e-08,  3.97e-08,  3.97e-08,  nan ],
	[    25,    0.0350,  0.0372,    0.0361,  0.0360,   0.0483,   0.0269,   0.2596,   0.0050,  7.63e-08,  7.63e-08,  5.72e-08,  nan ],
	[    26,    0.0370,  0.0379,    0.0401,  0.0350,   0.0521,   0.0269,   0.3464,   0.0041,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[    27,    0.0369,  0.0410,    0.0420,  0.0360,   0.0542,   0.0279,   0.3020,   0.0050,  7.06e-08,  7.06e-08,  7.06e-08,  nan ],
	[    28,    0.0428,  0.0379,    0.0439,  0.0370,   0.0577,   0.0281,   0.4257,   0.0038,  6.81e-08,  6.81e-08,  1.02e-07,  nan ],
	[    29,    0.0445,  0.0391,    0.0483,  0.0360,   0.0646,   0.0269,   0.2919,   0.0060,  6.58e-08,  6.58e-08,  9.87e-08,  nan ],
	[    30,    0.0464,  0.0401,    0.0531,  0.0350,   0.0661,   0.0281,   0.3715,   0.0050,  9.54e-08,  9.54e-08,  1.27e-07,  nan ],
	[    31,    0.0484,  0.0410,    0.0566,  0.0350,   0.0711,   0.0279,   0.3329,   0.0060,  9.23e-08,  6.15e-08,  9.23e-08,  nan ],
	[    32,    0.0572,  0.0370,    0.0637,  0.0331,   0.0852,   0.0248,   0.4218,   0.0050,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    33,    0.0607,  0.0370,    0.0640,  0.0350,   0.0771,   0.0291,   0.3765,   0.0060,  8.67e-08,  1.16e-07,  5.78e-08,  nan ],
	[    34,    0.0644,  0.0370,    0.0768,  0.0310,   0.1040,   0.0229,   0.5872,   0.0041,  5.61e-08,  8.41e-08,  5.61e-08,  nan ],
	[    35,    0.0789,  0.0319,    0.0846,  0.0298,   0.1046,   0.0241,   0.3645,   0.0069,  5.45e-08,  5.45e-08,  5.45e-08,  nan ],
	[    36,    0.0721,  0.0370,    0.0834,  0.0319,   0.1106,   0.0241,   0.3725,   0.0072,  7.95e-08,  5.30e-08,  5.30e-08,  nan ],
	[    37,    0.0849,  0.0331,    0.0936,  0.0300,   0.1168,   0.0241,   0.6938,   0.0041,  1.03e-07,  1.03e-07,  1.03e-07,  nan ],
	[    38,    0.0928,  0.0319,    0.0987,  0.0300,   0.1231,   0.0241,   0.7313,   0.0041,  7.53e-08,  5.02e-08,  7.53e-08,  nan ],
	[    39,    0.0977,  0.0319,    0.0948,  0.0329,   0.1296,   0.0241,   0.8179,   0.0038,  4.89e-08,  4.89e-08,  4.89e-08,  nan ],
	[    40,    0.1092,  0.0300,    0.1137,  0.0288,   0.1495,   0.0219,   1.0583,   0.0031,  7.15e-08,  9.54e-08,  7.15e-08,  nan ],
	[    41,    0.1078,  0.0319,    0.1184,  0.0291,   0.1489,   0.0231,   1.1112,   0.0031,  6.98e-08,  6.98e-08,  6.98e-08,  nan ],
	[    42,    0.1156,  0.0312,    0.1252,  0.0288,   0.1578,   0.0229,   1.2625,   0.0029,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    43,    0.1184,  0.0319,    0.1345,  0.0281,   0.1653,   0.0229,   0.9336,   0.0041,  8.87e-08,  8.87e-08,  8.87e-08,  nan ],
	[    44,    0.1278,  0.0310,    0.1240,  0.0319,   0.1730,   0.0229,   0.9770,   0.0041,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[    45,    0.1336,  0.0310,    0.1378,  0.0300,   0.1887,   0.0219,   1.0214,   0.0041,  8.48e-08,  8.48e-08,  8.48e-08,  nan ],
	[    46,    0.1268,  0.0341,    0.1395,  0.0310,   0.1814,   0.0238,   0.8636,   0.0050,  8.29e-08,  1.24e-07,  8.29e-08,  nan ],
	[    47,    0.1412,  0.0319,    0.1456,  0.0310,   0.1874,   0.0241,   1.1828,   0.0038,  8.12e-08,  8.12e-08,  8.12e-08,  nan ],
	[    48,    0.1380,  0.0341,    0.1518,  0.0310,   0.1973,   0.0238,   1.1606,   0.0041,  7.95e-08,  3.97e-08,  7.95e-08,  nan ],
	[    49,    0.1534,  0.0319,    0.1581,  0.0310,   0.1957,   0.0250,   1.2089,   0.0041,  7.79e-08,  7.79e-08,  7.79e-08,  nan ],
	[    50,    0.1550,  0.0329,    0.1645,  0.0310,   0.2037,   0.0250,   1.2583,   0.0041,  3.81e-08,  5.72e-08,  5.72e-08,  nan ],
	[    51,    0.1660,  0.0319,    0.1711,  0.0310,   0.2119,   0.0250,   1.3086,   0.0041,  7.48e-08,  5.61e-08,  7.48e-08,  nan ],
	[    52,    0.1725,  0.0319,    0.1778,  0.0310,   0.2202,   0.0250,   1.4449,   0.0038,  1.10e-07,  1.10e-07,  1.10e-07,  nan ],
	[    53,    0.1847,  0.0310,    0.1847,  0.0310,   0.2308,   0.0248,   1.1432,   0.0050,  9.00e-08,  1.08e-07,  7.20e-08,  nan ],
	[    54,    0.1755,  0.0339,    0.1977,  0.0300,   0.2373,   0.0250,   1.1864,   0.0050,  1.06e-07,  1.06e-07,  1.06e-07,  nan ],
	[    55,    0.1872,  0.0329,    0.2051,  0.0300,   0.2461,   0.0250,   1.5198,   0.0041,  6.94e-08,  6.94e-08,  6.94e-08,  nan ],
	[    56,    0.1998,  0.0319,    0.2125,  0.0300,   0.2550,   0.0250,   1.5751,   0.0041,  6.81e-08,  6.81e-08,  3.41e-08,  nan ],
	[    57,    0.1691,  0.0391,    0.2133,  0.0310,   0.2544,   0.0260,   1.3206,   0.0050,  6.69e-08,  6.69e-08,  6.69e-08,  nan ],
	[    58,    0.2142,  0.0319,    0.2208,  0.0310,   0.2734,   0.0250,   1.3669,   0.0050,  9.87e-08,  1.32e-07,  9.87e-08,  nan ],
	[    59,    0.2034,  0.0348,    0.2357,  0.0300,   0.2724,   0.0260,   1.4141,   0.0050,  9.70e-08,  6.47e-08,  6.47e-08,  nan ],
	[    60,    0.2291,  0.0319,    0.2362,  0.0310,   0.2817,   0.0260,   1.4620,   0.0050,  1.27e-07,  9.54e-08,  9.54e-08,  nan ],
	[    61,    0.2368,  0.0319,    0.2440,  0.0310,   0.2808,   0.0269,   1.5107,   0.0050,  1.25e-07,  1.25e-07,  9.38e-08,  nan ],
	[    62,    0.2445,  0.0319,    0.2374,  0.0329,   0.2600,   0.0300,   1.5603,   0.0050,  9.23e-08,  9.23e-08,  1.23e-07,  nan ],
	[    63,    0.2365,  0.0341,    0.2505,  0.0322,   0.2993,   0.0269,   1.3529,   0.0060,  9.08e-08,  9.08e-08,  1.51e-07,  nan ],
	[    64,    0.2770,  0.0300,    0.2770,  0.0300,   0.3323,   0.0250,   2.0527,   0.0041,  8.94e-08,  5.96e-08,  8.94e-08,  nan ],
	[    65,    0.2448,  0.0350,    0.2307,  0.0372,   0.3076,   0.0279,   2.1169,   0.0041,  5.87e-08,  5.87e-08,  8.80e-08,  nan ],
	[    66,    0.2594,  0.0341,    0.1344,  0.0658,   0.3254,   0.0272,   1.7664,   0.0050,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[    67,    0.2618,  0.0348,    0.2531,  0.0360,   0.3506,   0.0260,   1.5287,   0.0060,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[    68,    0.2752,  0.0341,    0.2539,  0.0370,   0.3483,   0.0269,   1.8743,   0.0050,  1.40e-07,  1.12e-07,  1.40e-07,  nan ],
	[    69,    0.2775,  0.0348,    0.2683,  0.0360,   0.3554,   0.0272,   1.5583,   0.0062,  8.29e-08,  8.29e-08,  1.11e-07,  nan ],
	[    70,    0.2836,  0.0350,    0.2836,  0.0350,   0.3825,   0.0260,   1.6677,   0.0060,  1.36e-07,  1.63e-07,  1.63e-07,  nan ],
	[    71,    0.2999,  0.0341,    0.2840,  0.0360,   0.3665,   0.0279,   1.7153,   0.0060,  8.06e-08,  1.61e-07,  1.07e-07,  nan ],
	[    72,    0.3105,  0.0339,    0.2920,  0.0360,   0.3902,   0.0269,   2.2045,   0.0048,  1.06e-07,  1.06e-07,  1.32e-07,  nan ],
	[    73,    0.3083,  0.0350,    0.3001,  0.0360,   0.3873,   0.0279,   2.1579,   0.0050,  1.05e-07,  7.84e-08,  1.05e-07,  nan ],
	[    74,    0.3256,  0.0341,    0.3167,  0.0350,   0.4120,   0.0269,   2.2170,   0.0050,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[    75,    0.3275,  0.0348,    0.3085,  0.0370,   0.4052,   0.0281,   2.2769,   0.0050,  1.27e-07,  7.63e-08,  7.63e-08,  nan ],
	[    76,    0.3167,  0.0370,    0.3251,  0.0360,   0.4160,   0.0281,   1.9636,   0.0060,  1.00e-07,  1.00e-07,  7.53e-08,  nan ],
	[    77,    0.3250,  0.0370,    0.3250,  0.0370,   0.4270,   0.0281,   2.0153,   0.0060,  9.91e-08,  9.91e-08,  9.91e-08,  nan ],
	[    78,    0.3251,  0.0379,    0.3423,  0.0360,   0.4418,   0.0279,   2.0676,   0.0060,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[    79,    0.3511,  0.0360,    0.3314,  0.0381,   0.3707,   0.0341,   2.1206,   0.0060,  9.66e-08,  1.45e-07,  1.21e-07,  nan ],
	[    80,    0.3698,  0.0350,    0.3600,  0.0360,   0.4646,   0.0279,   2.1743,   0.0060,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    81,    0.3790,  0.0350,    0.3504,  0.0379,   0.4762,   0.0279,   2.6532,   0.0050,  9.42e-08,  1.18e-07,  1.18e-07,  nan ],
	[    82,    0.3910,  0.0348,    0.3683,  0.0370,   0.4838,   0.0281,   2.2837,   0.0060,  1.40e-07,  1.40e-07,  9.30e-08,  nan ],
	[    83,    0.3678,  0.0379,    0.3873,  0.0360,   0.4999,   0.0279,   2.0167,   0.0069,  1.15e-07,  9.19e-08,  9.19e-08,  nan ],
	[    84,    0.4074,  0.0350,    0.3839,  0.0372,   0.5119,   0.0279,   2.0653,   0.0069,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    85,    0.3857,  0.0379,    0.3956,  0.0370,   0.5026,   0.0291,   2.4528,   0.0060,  8.98e-08,  8.98e-08,  1.35e-07,  nan ],
	[    86,    0.4049,  0.0370,    0.4049,  0.0370,   0.5145,   0.0291,   2.0921,   0.0072,  1.33e-07,  1.33e-07,  8.87e-08,  nan ],
	[    87,    0.4369,  0.0350,    0.4253,  0.0360,   0.5308,   0.0288,   3.0582,   0.0050,  8.77e-08,  6.58e-08,  8.77e-08,  nan ],
	[    88,    0.3820,  0.0410,    0.4239,  0.0370,   0.5615,   0.0279,   2.5269,   0.0062,  1.30e-07,  8.67e-08,  8.67e-08,  nan ],
	[    89,    0.4602,  0.0348,    0.4335,  0.0370,   0.5743,   0.0279,   2.6877,   0.0060,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[    90,    0.4321,  0.0379,    0.4432,  0.0370,   0.5822,   0.0281,   2.2901,   0.0072,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   100,    0.5329,  0.0379,    0.5466,  0.0370,   0.6724,   0.0300,   2.4919,   0.0081,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   110,    0.6442,  0.0379,    0.6284,  0.0389,   0.7879,   0.0310,   3.9394,   0.0062,  1.39e-07,  1.39e-07,  1.04e-07,  nan ],
	[   120,    0.7858,  0.0370,    0.7613,  0.0381,   0.9667,   0.0300,   4.8721,   0.0060,  9.54e-08,  1.27e-07,  1.27e-07,  nan ],
	[   130,    0.8306,  0.0410,    0.8764,  0.0389,   1.0352,   0.0329,   4.2017,   0.0081,  1.47e-07,  1.47e-07,  1.47e-07,  nan ],
	[   140,    0.9149,  0.0432,    1.0097,  0.0391,   1.1999,   0.0329,   4.3577,   0.0091,  2.18e-07,  1.63e-07,  1.63e-07,  nan ],
	[   150,    1.1310,  0.0401,    1.2258,  0.0370,   1.4179,   0.0319,   4.5239,   0.0100,  1.53e-07,  1.27e-07,  1.53e-07,  nan ],
	[   160,    1.3176,  0.0391,    1.3257,  0.0389,   1.5218,   0.0339,   7.2030,   0.0072,  1.43e-07,  1.43e-07,  1.43e-07,  nan ],
	[   170,    1.4178,  0.0410,    1.4869,  0.0391,   1.7053,   0.0341,   6.4173,   0.0091,  1.35e-07,  1.35e-07,  1.35e-07,  nan ],
	[   180,    1.4853,  0.0439,    1.6268,  0.0401,   1.8592,   0.0350,   5.3588,   0.0122,  1.70e-07,  1.27e-07,  1.27e-07,  nan ],
	[   190,    1.7297,  0.0420,    1.7699,  0.0410,   2.0160,   0.0360,   6.0885,   0.0119,  2.41e-07,  2.01e-07,  1.61e-07,  nan ],
	[   200,    1.7118,  0.0470,    2.0073,  0.0401,   2.1756,   0.0370,   7.3309,   0.0110,  1.53e-07,  1.53e-07,  1.53e-07,  nan ],
	[   210,    1.9259,  0.0460,    2.1610,  0.0410,   2.3827,   0.0372,   7.2882,   0.0122,  1.82e-07,  1.82e-07,  1.82e-07,  nan ],
	[   220,    2.1132,  0.0460,    2.3712,  0.0410,   2.5651,   0.0379,   8.1571,   0.0119,  1.73e-07,  2.08e-07,  1.73e-07,  nan ],
	[   230,    2.3093,  0.0460,    2.5912,  0.0410,   2.3707,   0.0448,   8.1034,   0.0131,  2.32e-07,  1.66e-07,  1.66e-07,  nan ],
	[   240,    2.3668,  0.0489,    2.7568,  0.0420,   2.9054,   0.0398,   8.2237,   0.0141,  2.23e-07,  2.54e-07,  2.23e-07,  nan ],
	[   250,    2.7274,  0.0460,    2.9908,  0.0420,   3.2899,   0.0381,   6.2665,   0.0200,  2.75e-07,  2.75e-07,  3.05e-07,  nan ],
	[   260,    2.7634,  0.0491,    3.2344,  0.0420,   3.3096,   0.0410,   3.8725,   0.0350,  1.17e-07,  8.80e-08,  8.80e-08,  nan ],
	[   270,    2.8682,  0.0510,    3.4100,  0.0429,   3.4875,   0.0420,   4.7215,   0.0310,  1.13e-07,  5.65e-08,  8.48e-08,  nan ],
	[   280,    3.0987,  0.0508,    3.6465,  0.0432,   3.4921,   0.0451,   4.7827,   0.0329,  8.17e-08,  5.45e-08,  8.17e-08,  nan ],
	[   290,    3.1324,  0.0539,    3.8266,  0.0441,   3.9329,   0.0429,   5.2829,   0.0319,  1.05e-07,  7.89e-08,  1.05e-07,  nan ],
	[   300,    3.4747,  0.0520,    4.1168,  0.0439,   4.0945,   0.0441,   6.2089,   0.0291,  1.02e-07,  7.63e-08,  1.02e-07,  nan ],
	[   310,    3.7969,  0.0508,    4.4930,  0.0429,   4.4682,   0.0432,   6.0354,   0.0319,  9.84e-08,  7.38e-08,  1.23e-07,  nan ],
	[   320,    4.0265,  0.0510,    4.7871,  0.0429,   4.6830,   0.0439,   6.1991,   0.0331,  9.54e-08,  9.54e-08,  1.43e-07,  nan ],
	[   330,    3.7707,  0.0579,    4.8481,  0.0451,   4.7476,   0.0460,   6.4076,   0.0341,  1.16e-07,  9.25e-08,  9.25e-08,  nan ],
	[   340,    4.2286,  0.0548,    5.2572,  0.0441,   5.0392,   0.0460,   6.2345,   0.0372,  1.12e-07,  8.98e-08,  1.12e-07,  nan ],
	[   350,    4.3853,  0.0560,    5.4526,  0.0451,   5.4816,   0.0448,   5.8553,   0.0420,  8.72e-08,  8.72e-08,  8.72e-08,  nan ],
	[   360,    4.7399,  0.0548,    5.9249,  0.0439,   5.6486,   0.0460,   7.4162,   0.0350,  1.48e-07,  1.06e-07,  8.48e-08,  nan ],
	[   370,    4.6620,  0.0589,    5.8452,  0.0470,   5.7289,   0.0479,   8.3442,   0.0329,  1.24e-07,  1.65e-07,  1.24e-07,  nan ],
	[   380,    5.0816,  0.0570,    6.2928,  0.0460,   6.0124,   0.0482,   8.8007,   0.0329,  1.20e-07,  1.20e-07,  1.20e-07,  nan ],
	[   390,    4.9199,  0.0620,    6.4933,  0.0470,   6.2399,   0.0489,   9.8398,   0.0310,  1.17e-07,  1.17e-07,  1.17e-07,  nan ],
	[   400,    5.3394,  0.0601,    6.9717,  0.0460,   6.6942,   0.0479,  10.3503,   0.0310,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   410,    5.3544,  0.0629,    7.1755,  0.0470,   6.6054,   0.0510,   9.8851,   0.0341,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[   420,    5.7940,  0.0610,    7.5293,  0.0470,   6.9312,   0.0510,  10.3725,   0.0341,  1.09e-07,  1.45e-07,  1.09e-07,  nan ],
	[   430,    6.0729,  0.0610,    7.8917,  0.0470,   7.4386,   0.0498,  10.9483,   0.0339,  1.42e-07,  1.06e-07,  1.06e-07,  nan ],
	[   440,    6.1656,  0.0629,    8.0981,  0.0479,   7.4666,   0.0520,  10.5015,   0.0370,  1.04e-07,  1.04e-07,  1.04e-07,  nan ],
	[   450,    6.3525,  0.0639,    8.4281,  0.0482,   7.6344,   0.0532,  12.3367,   0.0329,  1.02e-07,  1.36e-07,  1.02e-07,  nan ],
	[   460,    6.7382,  0.0629,    8.8502,  0.0479,   8.0130,   0.0529,  12.1013,   0.0350,  9.95e-08,  1.33e-07,  9.95e-08,  nan ],
	[   470,    6.8021,  0.0651,    9.0145,  0.0491,   8.2168,   0.0539,  12.6326,   0.0350,  9.74e-08,  9.74e-08,  9.74e-08,  nan ],
	[   480,    6.8924,  0.0670,    9.4476,  0.0489,   8.5697,   0.0539,  11.5974,   0.0398,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[   490,    7.2860,  0.0660,    9.6105,  0.0501,   8.9302,   0.0539,  11.2123,   0.0429,  9.34e-08,  1.25e-07,  1.25e-07,  nan ],
	[   500,    7.5861,  0.0660,   10.0543,  0.0498,   8.7922,   0.0570,  12.8131,   0.0391,  9.16e-08,  1.22e-07,  1.53e-07,  nan ],
	[   510,    7.5646,  0.0689,   10.4103,  0.0501,   8.9965,   0.0579,  12.7102,   0.0410,  8.98e-08,  8.98e-08,  8.98e-08,  nan ],
	[   520,    7.8367,  0.0691,   11.0322,  0.0491,   9.5090,   0.0570,  15.4601,   0.0350,  1.47e-07,  8.80e-08,  1.17e-07,  nan ],
	[   530,    8.1407,  0.0691,   11.0318,  0.0510,   9.2219,   0.0610,  15.6345,   0.0360,  1.44e-07,  1.15e-07,  1.15e-07,  nan ],
	[   540,    8.1147,  0.0720,   11.4516,  0.0510,   9.5728,   0.0610,  16.2295,   0.0360,  1.13e-07,  1.13e-07,  1.13e-07,  nan ],
	[   550,    8.4178,  0.0720,   11.8793,  0.0510,   9.4857,   0.0639,  16.4011,   0.0370,  1.39e-07,  1.11e-07,  1.11e-07,  nan ],
	[   560,    8.8733,  0.0708,   12.0888,  0.0520,   9.9448,   0.0632,  17.0024,   0.0370,  1.36e-07,  1.09e-07,  1.09e-07,  nan ],
	[   570,    9.2865,  0.0701,   12.5240,  0.0520,  10.5009,   0.0620,  17.6145,   0.0370,  1.34e-07,  1.07e-07,  1.07e-07,  nan ],
	[   580,    8.9739,  0.0751,   12.9669,  0.0520,  10.3926,   0.0648,  15.2800,   0.0441,  1.05e-07,  1.05e-07,  1.05e-07,  nan ],
	[   590,    9.3154,  0.0749,   13.4175,  0.0520,  10.9143,   0.0639,  17.9449,   0.0389,  1.29e-07,  1.03e-07,  1.29e-07,  nan ],
	[   600,    9.2506,  0.0780,   13.3847,  0.0539,  10.9203,   0.0660,  18.1134,   0.0398,  1.27e-07,  1.53e-07,  1.27e-07,  nan ],
	[   610,    9.8010,  0.0761,   14.0203,  0.0532,  11.1264,   0.0670,  18.6102,   0.0401,  1.25e-07,  1.00e-07,  1.25e-07,  nan ],
	[   620,    9.7283,  0.0792,   13.9817,  0.0551,  11.1757,   0.0689,  19.3400,   0.0398,  1.23e-07,  9.84e-08,  1.23e-07,  nan ],
	[   630,   10.4537,  0.0761,   14.7554,  0.0539,  11.3813,   0.0699,  17.2784,   0.0460,  1.21e-07,  1.21e-07,  1.21e-07,  nan ],
	[   640,   10.6543,  0.0770,   15.4320,  0.0532,  11.5481,   0.0710,  19.5531,   0.0420,  9.54e-08,  1.19e-07,  1.19e-07,  nan ],
	[   650,   10.5959,  0.0799,   15.7064,  0.0539,  11.7538,   0.0720,  19.1872,   0.0441,  1.17e-07,  1.17e-07,  1.41e-07,  nan ],
	[   660,   10.3672,  0.0842,   15.6394,  0.0558,  11.9595,   0.0730,  19.7817,   0.0441,  1.39e-07,  1.16e-07,  1.16e-07,  nan ],
	[   670,   10.8370,  0.0830,   16.3968,  0.0548,  12.0104,   0.0749,  19.5402,   0.0460,  1.37e-07,  9.11e-08,  9.11e-08,  nan ],
	[   680,   11.4253,  0.0811,   16.2535,  0.0570,  12.3713,   0.0749,  20.1274,   0.0460,  1.12e-07,  1.35e-07,  1.35e-07,  nan ],
	[   690,   11.6268,  0.0820,   16.7347,  0.0570,  12.9019,   0.0739,  20.2000,   0.0472,  1.33e-07,  1.33e-07,  1.33e-07,  nan ],
	[   700,   11.9660,  0.0820,   17.5910,  0.0558,  12.9037,   0.0761,  20.8949,   0.0470,  1.31e-07,  1.31e-07,  1.31e-07,  nan ],
	[   710,   11.6018,  0.0870,   17.3551,  0.0582,  13.1104,   0.0770,  20.9636,   0.0482,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[   720,   12.0964,  0.0858,   17.8471,  0.0582,  13.4820,   0.0770,  21.2424,   0.0489,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   730,   12.4000,  0.0861,   18.7298,  0.0570,  13.6893,   0.0780,  21.7302,   0.0491,  1.25e-07,  1.25e-07,  1.25e-07,  nan ],
	[   740,   12.0414,  0.0911,   18.6227,  0.0589,  13.7308,   0.0799,  21.1000,   0.0520,  1.24e-07,  1.24e-07,  1.24e-07,  nan ],
	[   750,   12.4013,  0.0908,   19.0519,  0.0591,  14.0622,   0.0801,  22.0789,   0.0510,  1.22e-07,  1.22e-07,  1.63e-07,  nan ],
	[   760,   13.0071,  0.0889,   19.2525,  0.0601,  14.2695,   0.0811,  21.0028,   0.0551,  1.20e-07,  1.20e-07,  1.20e-07,  nan ],
	[   770,   13.2097,  0.0899,   20.1622,  0.0589,  14.6905,   0.0808,  22.3321,   0.0532,  1.19e-07,  1.19e-07,  1.59e-07,  nan ],
	[   780,   13.2388,  0.0920,    9.6784,  0.1259,  14.6844,   0.0830,  22.6114,   0.0539,  1.57e-07,  1.17e-07,  1.57e-07,  nan ],
	[   790,   13.3045,  0.0939,   20.8014,  0.0601,  15.0631,   0.0830,  22.4015,   0.0558,  1.55e-07,  1.55e-07,  1.16e-07,  nan ],
	[   800,   13.6432,  0.0939,   21.3310,  0.0601,  15.4466,   0.0830,  22.4913,   0.0570,  1.53e-07,  1.14e-07,  1.53e-07,  nan ],
	[   810,   13.7079,  0.0958,   21.5256,  0.0610,  15.4791,   0.0849,  23.9590,   0.0548,  1.13e-07,  1.13e-07,  1.51e-07,  nan ],
	[   820,   14.4805,  0.0930,   22.4102,  0.0601,  16.0437,   0.0839,  22.1466,   0.0608,  1.49e-07,  1.12e-07,  1.49e-07,  nan ],
	[   830,   14.8356,  0.0930,   22.6011,  0.0610,  16.6261,   0.0830,  23.8102,   0.0579,  1.47e-07,  1.10e-07,  1.10e-07,  nan ],
	[   840,   14.1096,  0.1001,   23.1486,  0.0610,  16.2357,   0.0870,  23.5161,   0.0601,  1.45e-07,  1.45e-07,  1.09e-07,  nan ],
	[   850,   14.1773,  0.1020,   22.8977,  0.0632,  16.6244,   0.0870,  24.0790,   0.0601,  1.08e-07,  1.44e-07,  1.08e-07,  nan ],
	[   860,   14.7891,  0.1001,   23.1770,  0.0639,  16.6526,   0.0889,  24.2634,   0.0610,  1.42e-07,  1.42e-07,  1.06e-07,  nan ],
	[   870,   14.7144,  0.1030,   23.3700,  0.0648,  17.0419,   0.0889,  24.8306,   0.0610,  1.40e-07,  1.40e-07,  1.40e-07,  nan ],
	[   880,   15.3385,  0.1011,   24.2669,  0.0639,  17.2507,   0.0899,  24.1767,   0.0641,  1.39e-07,  1.39e-07,  1.39e-07,  nan ],
	[   890,   15.8761,  0.0999,   24.7289,  0.0641,  17.8340,   0.0889,  25.1022,   0.0632,  1.03e-07,  1.37e-07,  1.03e-07,  nan ],
	[   900,   15.0162,  0.1080,   24.5571,  0.0660,  17.9956,   0.0901,  24.9169,   0.0651,  1.36e-07,  1.36e-07,  1.36e-07,  nan ],
	[  1000,   17.1018,  0.1171,   28.1778,  0.0710,  19.2151,   0.1042,  27.0000,   0.0741,  1.22e-07,  1.22e-07,  1.53e-07,  nan ],
	[  1100,   18.5054,  0.1309,   32.2522,  0.0751,  21.0777,   0.1149,  28.5378,   0.0849,  1.66e-07,  1.39e-07,  1.39e-07,  nan ],
	[  1200,   20.2847,  0.1421,   36.5247,  0.0789,  23.6126,   0.1221,  27.7286,   0.1040,  1.78e-07,  1.27e-07,  1.27e-07,  nan ],
	[  1300,   22.4134,  0.1509,   39.7413,  0.0851,  26.0324,   0.1299,  31.3193,   0.1080,  1.64e-07,  1.17e-07,  1.64e-07,  nan ],
	[  1400,   24.3754,  0.1609,   43.5276,  0.0901,  28.6146,   0.1371,  31.3996,   0.1249,  1.74e-07,  1.74e-07,  1.31e-07,  nan ],
	[  1500,   26.0510,  0.1729,   46.8659,  0.0961,  28.8791,   0.1559,  33.6067,   0.1340,  2.03e-07,  1.63e-07,  1.63e-07,  nan ],
	[  1600,   28.4613,  0.1800,   52.7967,  0.0970,  31.6469,   0.1619,  30.1378,   0.1700,  1.91e-07,  1.53e-07,  1.53e-07,  nan ],
	[  1700,   30.4358,  0.1900,   54.6336,  0.1059,  33.4123,   0.1731,  34.6533,   0.1669,  1.80e-07,  2.15e-07,  1.80e-07,  nan ],
	[  1800,   32.4126,  0.2000,   56.3027,  0.1152,  36.0188,   0.1800,  36.0188,   0.1800,  1.70e-07,  1.70e-07,  1.70e-07,  nan ],
	[  1900,   34.2359,  0.2110,   61.7084,  0.1171,  38.4015,   0.1881,  32.8264,   0.2201,  2.25e-07,  1.61e-07,  1.28e-07,  nan ],
	[  2000,   35.5627,  0.2251,   60.7074,  0.1318,  37.5937,   0.2129,  36.5302,   0.2191,  2.14e-07,  1.53e-07,  1.53e-07,  nan ],
	[  2100,   37.5369,  0.2351,   64.3676,  0.1371,  24.6414,   0.3581,  36.4644,   0.2420,  2.03e-07,  1.74e-07,  1.74e-07,  nan ],
	[  2200,   39.0570,  0.2480,   68.7298,  0.1409,  25.8393,   0.3748,  36.2672,   0.2670,  2.50e-07,  1.66e-07,  1.39e-07,  nan ],
	[  2300,   40.8794,  0.2589,   72.0699,  0.1469,  26.3942,   0.4010,  37.5275,   0.2820,  2.92e-07,  1.86e-07,  1.86e-07,  nan ],
	[  2400,   42.6642,  0.2701,   74.8274,  0.1540,  27.4963,   0.4191,  40.0153,   0.2880,  2.29e-07,  1.78e-07,  1.78e-07,  nan ],
	[  2500,   43.7446,  0.2859,   78.1666,  0.1600,  28.5519,   0.4380,  38.4811,   0.3250,  2.69e-07,  1.71e-07,  1.71e-07,  nan ],
	[  2600,   45.2022,  0.2992,   81.5069,  0.1659,  29.1515,   0.4640,  41.7430,   0.3240,  2.11e-07,  1.88e-07,  1.88e-07,  nan ],
	[  2700,   47.2034,  0.3090,   82.8938,  0.1760,  30.4508,   0.4790,  40.0626,   0.3641,  2.26e-07,  1.81e-07,  1.58e-07,  nan ],
	[  2800,   49.1705,  0.3190,   87.1393,  0.1800,  31.6147,   0.4961,  35.4091,   0.4430,  2.62e-07,  1.74e-07,  1.74e-07,  nan ],
	[  2900,   50.3730,  0.3340,   90.9440,  0.1850,  32.5519,   0.5169,  36.5093,   0.4609,  2.53e-07,  2.10e-07,  1.68e-07,  nan ],
	[  3000,   52.1926,  0.3450,   91.8767,  0.1960,  33.4615,   0.5381,  38.8891,   0.4630,  3.26e-07,  2.44e-07,  2.03e-07,  nan ],
	[  3100,   54.1575,  0.3550,   99.0670,  0.1941,  34.4030,   0.5589,  35.4153,   0.5429,  2.36e-07,  2.36e-07,  1.97e-07,  nan ],
	[  3200,   55.5079,  0.3691,  101.3281,  0.2022,  35.7579,   0.5729,  41.3903,   0.4950,  2.67e-07,  1.91e-07,  1.53e-07,  nan ],
	[  3300,   58.2407,  0.3741,  103.7226,  0.2100,  36.4353,   0.5980,  37.4353,   0.5820,  2.96e-07,  2.22e-07,  1.85e-07,  nan ],
	[  3400,   60.2490,  0.3839,  104.6395,  0.2210,  37.6702,   0.6139,  39.1290,   0.5910,  2.87e-07,  2.15e-07,  1.80e-07,  nan ],
	[  3500,   60.5002,  0.4051,  106.0782,  0.2310,  38.5269,   0.6361,  40.7734,   0.6011,  3.14e-07,  2.09e-07,  1.74e-07,  nan ],
	[  3600,   62.3547,  0.4158,  110.2906,  0.2351,  39.3439,   0.6590,  38.9354,   0.6659,  2.71e-07,  2.37e-07,  1.70e-07,  nan ],
	[  3700,   65.1936,  0.4201,  113.1735,  0.2420,  40.3907,   0.6781,  41.0694,   0.6669,  2.64e-07,  2.31e-07,  1.98e-07,  nan ],
	[  3800,   66.1011,  0.4370,  115.5037,  0.2501,  41.5085,   0.6959,  38.8220,   0.7441,  2.89e-07,  2.89e-07,  1.93e-07,  nan ],
	[  3900,   67.7407,  0.4492,  111.9504,  0.2718,  42.7836,   0.7112,  38.6621,   0.7870,  2.50e-07,  2.19e-07,  1.88e-07,  nan ],
	[  4000,   67.9753,  0.4709,  113.4838,  0.2820,  43.4892,   0.7360,  42.5654,   0.7520,  3.05e-07,  2.14e-07,  1.53e-07,  nan ],
	[  4100,   68.5026,  0.4909,  114.3933,  0.2940,  31.6320,   1.0631,  43.4525,   0.7739,  3.28e-07,  2.08e-07,  2.08e-07,  nan ],
	[  4200,   70.7168,  0.4990,  112.7268,  0.3130,  32.7674,   1.0769,  42.6174,   0.8280,  2.91e-07,  2.33e-07,  2.03e-07,  nan ],
	[  4300,   73.7014,  0.5019,  114.1585,  0.3240,  33.5949,   1.1010,  40.2547,   0.9189,  3.41e-07,  2.55e-07,  1.99e-07,  nan ],
	[  4400,   74.7540,  0.5181,  111.9506,  0.3459,  34.4008,   1.1258,  43.6668,   0.8869,  2.77e-07,  2.77e-07,  2.22e-07,  nan ],
	[  4500,   74.6188,  0.5429,  114.7246,  0.3531,  35.0685,   1.1551,  46.8322,   0.8650,  2.71e-07,  2.44e-07,  1.90e-07,  nan ],
	[  4600,   77.9375,  0.5431,  116.6502,  0.3629,  35.7155,   1.1852,  45.6170,   0.9279,  3.18e-07,  2.39e-07,  2.12e-07,  nan ],
	[  4700,   78.6355,  0.5620,  114.4804,  0.3860,  36.6147,   1.2069,  45.6062,   0.9689,  3.12e-07,  2.60e-07,  2.08e-07,  nan ],
	[  4800,   80.4469,  0.5729,  118.1625,  0.3901,  37.4349,   1.2312,  46.3249,   0.9949,  3.05e-07,  2.29e-07,  1.78e-07,  nan ],
	[  4900,   78.8460,  0.6092,  114.3961,  0.4199,  38.0313,   1.2629,  48.0333,   0.9999,  3.99e-07,  2.24e-07,  2.49e-07,  nan ],
	[  5000,   79.5137,  0.6289,  117.3795,  0.4261,  39.0391,   1.2810,  49.2157,   1.0161,  3.17e-07,  2.44e-07,  2.20e-07,  nan ],
	[  5100,   80.1728,  0.6490,  117.4545,  0.4430,  39.5991,   1.3139,  50.9170,   1.0219,  3.35e-07,  2.15e-07,  2.15e-07,  nan ],
	[  5200,   80.3654,  0.6731,  117.3676,  0.4609,  40.1259,   1.3480,  49.1277,   1.1010,  3.29e-07,  2.58e-07,  2.35e-07,  nan ],
	[  5300,   80.8509,  0.6950,  118.5515,  0.4740,  40.6907,   1.3809,  49.4193,   1.1370,  3.92e-07,  2.53e-07,  2.53e-07,  nan ],
	[  5400,   80.4528,  0.7250,  122.0235,  0.4780,  41.7290,   1.3978,  49.2664,   1.1840,  3.84e-07,  2.49e-07,  2.03e-07,  nan ],
	[  5500,   80.8800,  0.7482,  120.5708,  0.5019,  42.4915,   1.4241,  49.0343,   1.2341,  3.11e-07,  2.66e-07,  2.22e-07,  nan ],
	[  5600,   82.2230,  0.7629,  123.0078,  0.5100,  42.9995,   1.4589,  47.8563,   1.3108,  4.36e-07,  3.05e-07,  2.18e-07,  nan ],
	[  5700,   82.2800,  0.7899,  122.1845,  0.5319,  43.3239,   1.5001,  51.0953,   1.2720,  3.43e-07,  2.57e-07,  2.14e-07,  nan ],
	[  5800,   81.1738,  0.8290,  121.0298,  0.5560,  44.3010,   1.5190,  49.6991,   1.3540,  3.79e-07,  2.53e-07,  2.53e-07,  nan ],
	[  5900,   81.7171,  0.8521,  123.0231,  0.5660,  44.5820,   1.5619,  52.5944,   1.3239,  3.72e-07,  3.31e-07,  2.48e-07,  nan ],
	[  6000,   82.9781,  0.8678,  125.9026,  0.5720,  45.8679,   1.5700,  51.4024,   1.4009,  4.07e-07,  2.85e-07,  2.44e-07,  nan ],
	[  6100,   83.6301,  0.8900,  124.8765,  0.5960,  45.8027,   1.6251,  50.5983,   1.4710,  4.00e-07,  2.80e-07,  2.40e-07,  nan ],
	[  6200,   85.1399,  0.9031,  126.8726,  0.6061,  36.7365,   2.0931,  51.2979,   1.4989,  3.94e-07,  2.76e-07,  3.15e-07,  nan ],
	[  6300,   85.4495,  0.9291,  127.8789,  0.6208,  37.3818,   2.1238,  52.2676,   1.5190,  3.49e-07,  2.71e-07,  2.33e-07,  nan ],
	[  6400,   86.2578,  0.9499,  124.6920,  0.6571,  38.3582,   2.1360,  52.1236,   1.5719,  3.43e-07,  2.67e-07,  2.67e-07,  nan ],
	[  6500,   86.5836,  0.9761,  125.9677,  0.6709,  38.5046,   2.1949,  52.0442,   1.6239,  3.76e-07,  3.00e-07,  3.00e-07,  nan ],
	[  6600,   86.7877,  1.0040,  126.2830,  0.6900,  39.2676,   2.2190,  52.3961,   1.6630,  3.70e-07,  2.96e-07,  2.59e-07,  nan ],
	[  6700,   86.8390,  1.0340,  128.2768,  0.7000,  39.3338,   2.2829,  51.7550,   1.7350,  3.64e-07,  2.55e-07,  2.55e-07,  nan ],
	[  6800,   87.2574,  1.0600,  130.0524,  0.7112,  40.3019,   2.2950,  52.4039,   1.7650,  3.59e-07,  3.95e-07,  2.87e-07,  nan ],
	[  6900,   87.8661,  1.0839,  130.4505,  0.7300,  39.4508,   2.4140,  52.4957,   1.8141,  3.54e-07,  3.18e-07,  2.83e-07,  nan ],
	[  7000,   87.7482,  1.1170,  130.3426,  0.7520,  41.9063,   2.3389,  52.3295,   1.8730,  4.53e-07,  3.14e-07,  2.44e-07,  nan ],
	[  7100,   88.8320,  1.1351,  131.3037,  0.7679,  42.0156,   2.3999,  53.7804,   1.8749,  4.47e-07,  3.09e-07,  2.75e-07,  nan ],
	[  7200,   89.6385,  1.1568,  132.9642,  0.7799,  41.8118,   2.4800,  54.0885,   1.9171,  3.73e-07,  2.71e-07,  3.39e-07,  nan ],
	[  7300,   89.4180,  1.1921,  132.2752,  0.8059,  41.4740,   2.5702,  52.5865,   2.0270,  4.68e-07,  3.01e-07,  3.01e-07,  nan ],
	[  7400,   89.8713,  1.2188,  133.2431,  0.8221,  43.3458,   2.5270,  51.3321,   2.1338,  3.96e-07,  2.97e-07,  2.97e-07,  nan ],
	[  7500,   92.0106,  1.2228,  132.3393,  0.8502,  42.7466,   2.6321,  54.0699,   2.0809,  3.91e-07,  2.93e-07,  2.60e-07,  nan ],
	[  7600,   91.2598,  1.2660,  132.6553,  0.8709,  44.4537,   2.5990,  52.2976,   2.2092,  4.50e-07,  3.21e-07,  2.89e-07,  nan ],
	[  7700,   91.7251,  1.2929,  131.9080,  0.8991,  44.7365,   2.6510,  51.0756,   2.3220,  4.12e-07,  3.17e-07,  2.54e-07,  nan ],
	[  7800,   92.5527,  1.3149,  132.4068,  0.9191,  45.3271,   2.6848,  51.5636,   2.3601,  4.38e-07,  3.13e-07,  3.13e-07,  nan ],
	[  7900,   93.0182,  1.3421,  133.4011,  0.9358,  45.8774,   2.7211,  51.9547,   2.4028,  4.02e-07,  3.09e-07,  2.47e-07,  nan ],
	[  8000,   92.5755,  1.3828,  134.0335,  0.9551,  46.2320,   2.7690,  53.9908,   2.3711,  3.97e-07,  3.36e-07,  2.44e-07,  nan ],
	[  8100,   94.7572,  1.3850,  134.4515,  0.9761,  45.2557,   2.8999,  53.1779,   2.4679,  4.22e-07,  3.92e-07,  2.71e-07,  nan ],
	[  8200,   95.9875,  1.4012,  134.6346,  0.9990,  38.3493,   3.5071,  54.6521,   2.4610,  3.87e-07,  2.98e-07,  2.98e-07,  nan ],
	[  8300,   95.5623,  1.4420,  134.0354,  1.0281,  39.1705,   3.5179,  54.7882,   2.5151,  4.12e-07,  3.53e-07,  2.94e-07,  nan ],
	[  8400,   96.4750,  1.4629,  135.2149,  1.0438,  40.3497,   3.4978,  53.7862,   2.6240,  4.36e-07,  3.78e-07,  2.91e-07,  nan ],
	[  8500,   97.3107,  1.4851,  133.4247,  1.0831,  40.5613,   3.5629,  55.0343,   2.6259,  5.17e-07,  3.45e-07,  2.87e-07,  nan ],
	[  8600,   98.1638,  1.5070,  134.7435,  1.0979,  41.2782,   3.5839,  53.8156,   2.7490,  4.26e-07,  3.12e-07,  2.84e-07,  nan ],
	[  8700,   95.9515,  1.5779,  134.1091,  1.1289,  40.7526,   3.7150,  55.2132,   2.7421,  4.21e-07,  3.37e-07,  2.53e-07,  nan ],
	[  8800,   97.4775,  1.5891,  134.9299,  1.1480,  41.7055,   3.7141,  54.9094,   2.8210,  3.88e-07,  3.05e-07,  2.77e-07,  nan ],
	[  8900,   97.6254,  1.6229,  134.7124,  1.1761,  41.8263,   3.7880,  54.5417,   2.9049,  4.11e-07,  3.29e-07,  2.74e-07,  nan ],
	[  9000,   98.9736,  1.6370,  134.3521,  1.2059,  42.6935,   3.7949,  54.7938,   2.9569,  4.88e-07,  3.80e-07,  3.53e-07,  nan ],
	[ 10000,  101.1630,  1.9772,  135.7076,  1.4739,  46.8868,   4.2660,  54.8294,   3.6480,  4.88e-07,  3.91e-07,  3.66e-07,  nan ],
	[ 12000,  102.5344,  2.8090,  139.8056,  2.0602,  45.2220,   6.3691,  56.0481,   5.1389,  5.70e-07,  4.48e-07,  3.26e-07,  nan ],
	[ 14000,  109.5678,  3.5779,  140.6213,  2.7878,  45.6530,   8.5871,  57.3221,   6.8390,  5.58e-07,  4.19e-07,  3.84e-07,  nan ],
	[ 16000,  111.1891,  4.6051,  139.4014,  3.6731,  46.3468,  11.0478,  57.5846,   8.8918,  5.49e-07,  4.27e-07,  4.27e-07,  nan ],
	[ 18000,  111.7302,  5.8000,  143.3425,  4.5209,  46.0969,  14.0581,  58.3926,  11.0979,  6.51e-07,  5.70e-07,  4.61e-07,  nan ],
	[ 20000,  115.6310,  6.9189,  144.2591,  5.5459,  46.4573,  17.2210,  57.3050,  13.9611,  7.08e-07,  5.13e-07,  4.15e-07,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/zgeev.txt
# numactl --interleave=all ./testing_zgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeev_RN = array([
	[    10,  nan,    0.0004 ],
	[    20,  nan,    0.0007 ],
	[    30,  nan,    0.0012 ],
	[    40,  nan,    0.0036 ],
	[    50,  nan,    0.0042 ],
	[    60,  nan,    0.0049 ],
	[    70,  nan,    0.0077 ],
	[    80,  nan,    0.0115 ],
	[    90,  nan,    0.0139 ],
	[   100,  nan,    0.0175 ],
	[   200,  nan,    0.0881 ],
	[   300,  nan,    0.1800 ],
	[   400,  nan,    0.3027 ],
	[   500,  nan,    0.4473 ],
	[   600,  nan,    0.8902 ],
	[   700,  nan,    1.0337 ],
	[   800,  nan,    1.2890 ],
	[   900,  nan,    1.5493 ],
	[  1000,  nan,    1.8565 ],
	[  2000,  nan,    5.9068 ],
	[  3000,  nan,   16.8003 ],
	[  4000,  nan,   28.0323 ],
	[  5000,  nan,   42.1905 ],
	[  6000,  nan,   78.2203 ],
	[  7000,  nan,  102.5614 ],
	[  8000,  nan,  134.8554 ],
	[  9000,  nan,  166.1584 ],
	[ 10000,  nan,  203.7712 ],
	[ 12000,  nan,  296.8788 ],
	[ 14000,  nan,  413.8873 ],
	[ 16000,  nan,  569.2293 ],
	[ 18000,  nan,  753.6494 ],
	[ 20000,  nan,  957.9114 ],
])

# numactl --interleave=all ./testing_zgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeev_RV = array([
	[    10,  nan,     0.0014 ],
	[    20,  nan,     0.0017 ],
	[    30,  nan,     0.0024 ],
	[    40,  nan,     0.0064 ],
	[    50,  nan,     0.0073 ],
	[    60,  nan,     0.0089 ],
	[    70,  nan,     0.0180 ],
	[    80,  nan,     0.0186 ],
	[    90,  nan,     0.0219 ],
	[   100,  nan,     0.0281 ],
	[   200,  nan,     0.1264 ],
	[   300,  nan,     0.2381 ],
	[   400,  nan,     0.3755 ],
	[   500,  nan,     0.6030 ],
	[   600,  nan,     1.0214 ],
	[   700,  nan,     1.2375 ],
	[   800,  nan,     1.5965 ],
	[   900,  nan,     1.9500 ],
	[  1000,  nan,     2.3635 ],
	[  2000,  nan,     9.0155 ],
	[  3000,  nan,    22.4971 ],
	[  4000,  nan,    40.0431 ],
	[  5000,  nan,    65.5690 ],
	[  6000,  nan,   110.9951 ],
	[  7000,  nan,   152.6330 ],
	[  8000,  nan,   205.9501 ],
	[  9000,  nan,   254.2981 ],
	[ 10000,  nan,   354.4332 ],
	[ 12000,  nan,   489.7992 ],
	[ 14000,  nan,   727.0022 ],
	[ 16000,  nan,  1010.3870 ],
	[ 18000,  nan,  1488.6314 ],
	[ 20000,  nan,  1793.5032 ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/zgeqrf.txt
# numactl --interleave=all ./testing_zgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeqrf = array([
	[    10,     10,  nan,  nan,     0.12,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.76,   0.00,  nan ],
	[    30,     30,  nan,  nan,     1.83,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.92,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.59,   0.00,  nan ],
	[    60,     60,  nan,  nan,     2.22,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.67,   0.00,  nan ],
	[    80,     80,  nan,  nan,     2.62,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.44,   0.00,  nan ],
	[   100,    100,  nan,  nan,     4.35,   0.00,  nan ],
	[   200,    200,  nan,  nan,    13.96,   0.00,  nan ],
	[   300,    300,  nan,  nan,    29.51,   0.00,  nan ],
	[   400,    400,  nan,  nan,    46.09,   0.01,  nan ],
	[   500,    500,  nan,  nan,    64.51,   0.01,  nan ],
	[   600,    600,  nan,  nan,    83.67,   0.01,  nan ],
	[   700,    700,  nan,  nan,   104.68,   0.02,  nan ],
	[   800,    800,  nan,  nan,   123.91,   0.02,  nan ],
	[   900,    900,  nan,  nan,   141.81,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   164.11,   0.03,  nan ],
	[  2000,   2000,  nan,  nan,   382.23,   0.11,  nan ],
	[  3000,   3000,  nan,  nan,   545.03,   0.26,  nan ],
	[  4000,   4000,  nan,  nan,   746.75,   0.46,  nan ],
	[  5000,   5000,  nan,  nan,   827.59,   0.81,  nan ],
	[  6000,   6000,  nan,  nan,   908.51,   1.27,  nan ],
	[  7000,   7000,  nan,  nan,   956.59,   1.91,  nan ],
	[  8000,   8000,  nan,  nan,   997.48,   2.74,  nan ],
	[  9000,   9000,  nan,  nan,  1009.93,   3.85,  nan ],
	[ 10000,  10000,  nan,  nan,  1021.70,   5.22,  nan ],
	[ 12000,  12000,  nan,  nan,  1057.49,   8.72,  nan ],
	[ 14000,  14000,  nan,  nan,  1063.87,  13.76,  nan ],
	[ 16000,  16000,  nan,  nan,  1073.69,  20.35,  nan ],
	[ 18000,  18000,  nan,  nan,  1050.56,  29.61,  nan ],
	[ 20000,  20000,  nan,  nan,  1072.71,  39.78,  nan ],
])

# numactl --interleave=all ./testing_zgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.15,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.33,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.60,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.95,   0.00,  nan ],
	[    70,     70,  nan,  nan,     2.09,   0.00,  nan ],
	[    80,     80,  nan,  nan,     3.12,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.54,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.70,   0.00,  nan ],
	[   200,    200,  nan,  nan,    11.33,   0.00,  nan ],
	[   300,    300,  nan,  nan,    25.13,   0.01,  nan ],
	[   400,    400,  nan,  nan,    37.00,   0.01,  nan ],
	[   500,    500,  nan,  nan,    57.51,   0.01,  nan ],
	[   600,    600,  nan,  nan,    70.94,   0.02,  nan ],
	[   700,    700,  nan,  nan,    92.71,   0.02,  nan ],
	[   800,    800,  nan,  nan,   106.65,   0.03,  nan ],
	[   900,    900,  nan,  nan,   128.17,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   150.61,   0.04,  nan ],
	[  2000,   2000,  nan,  nan,   347.84,   0.12,  nan ],
	[  3000,   3000,  nan,  nan,   605.55,   0.24,  nan ],
	[  4000,   4000,  nan,  nan,   741.14,   0.46,  nan ],
	[  5000,   5000,  nan,  nan,   799.79,   0.83,  nan ],
	[  6000,   6000,  nan,  nan,   877.47,   1.31,  nan ],
	[  7000,   7000,  nan,  nan,   937.07,   1.95,  nan ],
	[  8000,   8000,  nan,  nan,   981.20,   2.78,  nan ],
	[  9000,   9000,  nan,  nan,   996.99,   3.90,  nan ],
	[ 10000,  10000,  nan,  nan,  1013.21,   5.26,  nan ],
	[ 12000,  12000,  nan,  nan,  1052.16,   8.76,  nan ],
	[ 14000,  14000,  nan,  nan,  1063.70,  13.76,  nan ],
	[ 16000,  16000,  nan,  nan,  1085.06,  20.14,  nan ],
	[ 18000,  18000,  nan,  nan,  1049.97,  29.63,  nan ],
	[ 20000,  20000,  nan,  nan,  1070.26,  39.87,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/zgesvd.txt
# numactl --interleave=all ./testing_zgesvd -UN -VN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
zgesvd_UN = array([
	[ nan,     10,     10,  nan,    0.00,  nan ],
	[ nan,     20,     20,  nan,    0.00,  nan ],
	[ nan,     30,     30,  nan,    0.00,  nan ],
	[ nan,     40,     40,  nan,    0.00,  nan ],
	[ nan,     50,     50,  nan,    0.00,  nan ],
	[ nan,     60,     60,  nan,    0.00,  nan ],
	[ nan,     70,     70,  nan,    0.00,  nan ],
	[ nan,     80,     80,  nan,    0.00,  nan ],
	[ nan,     90,     90,  nan,    0.00,  nan ],
	[ nan,    100,    100,  nan,    0.00,  nan ],
	[ nan,    200,    200,  nan,    0.02,  nan ],
	[ nan,    300,    300,  nan,    0.05,  nan ],
	[ nan,    400,    400,  nan,    0.08,  nan ],
	[ nan,    500,    500,  nan,    0.15,  nan ],
	[ nan,    600,    600,  nan,    0.15,  nan ],
	[ nan,    700,    700,  nan,    0.20,  nan ],
	[ nan,    800,    800,  nan,    0.31,  nan ],
	[ nan,    900,    900,  nan,    0.32,  nan ],
	[ nan,   1000,   1000,  nan,    0.39,  nan ],
	[ nan,   2000,   2000,  nan,    1.69,  nan ],
	[ nan,   3000,   3000,  nan,    4.50,  nan ],
	[ nan,   4000,   4000,  nan,    9.26,  nan ],
	[ nan,   5000,   5000,  nan,   16.58,  nan ],
	[ nan,   6000,   6000,  nan,   27.12,  nan ],
	[ nan,   7000,   7000,  nan,   40.84,  nan ],
	[ nan,   8000,   8000,  nan,   59.67,  nan ],
	[ nan,   9000,   9000,  nan,   82.25,  nan ],
	[ nan,  10000,  10000,  nan,  113.55,  nan ],
	[ nan,  12000,  12000,  nan,  204.99,  nan ],
	[ nan,  14000,  14000,  nan,  302.73,  nan ],
	[ nan,  16000,  16000,  nan,  460.29,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/zgetrf.txt
# numactl --interleave=all ./testing_zgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgetrf = array([
	[    10,     10,  nan,  nan,     0.26,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.75,   0.00,  nan ],
	[    30,     30,  nan,  nan,     1.27,   0.00,  nan ],
	[    40,     40,  nan,  nan,     3.09,   0.00,  nan ],
	[    50,     50,  nan,  nan,     2.22,   0.00,  nan ],
	[    60,     60,  nan,  nan,     3.92,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.11,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.59,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.07,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.71,   0.00,  nan ],
	[   200,    200,  nan,  nan,    10.69,   0.00,  nan ],
	[   300,    300,  nan,  nan,    23.03,   0.00,  nan ],
	[   400,    400,  nan,  nan,    36.86,   0.00,  nan ],
	[   500,    500,  nan,  nan,    52.48,   0.01,  nan ],
	[   600,    600,  nan,  nan,    68.63,   0.01,  nan ],
	[   700,    700,  nan,  nan,    87.08,   0.01,  nan ],
	[   800,    800,  nan,  nan,   105.82,   0.01,  nan ],
	[   900,    900,  nan,  nan,   123.14,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   142.71,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   339.72,   0.06,  nan ],
	[  3000,   3000,  nan,  nan,   518.56,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,   627.35,   0.27,  nan ],
	[  5000,   5000,  nan,  nan,   684.01,   0.49,  nan ],
	[  6000,   6000,  nan,  nan,   772.08,   0.75,  nan ],
	[  7000,   7000,  nan,  nan,   829.56,   1.10,  nan ],
	[  8000,   8000,  nan,  nan,   882.56,   1.55,  nan ],
	[  9000,   9000,  nan,  nan,   906.12,   2.15,  nan ],
	[ 10000,  10000,  nan,  nan,   944.31,   2.82,  nan ],
	[ 12000,  12000,  nan,  nan,   994.15,   4.63,  nan ],
	[ 14000,  14000,  nan,  nan,  1027.60,   7.12,  nan ],
	[ 16000,  16000,  nan,  nan,  1053.91,  10.36,  nan ],
	[ 18000,  18000,  nan,  nan,  1063.89,  14.62,  nan ],
	[ 20000,  20000,  nan,  nan,  1071.63,  19.91,  nan ],
])

# numactl --interleave=all ./testing_zgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.06,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.36,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.69,   0.00,  nan ],
	[    40,     40,  nan,  nan,     1.38,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.19,   0.00,  nan ],
	[    60,     60,  nan,  nan,     2.64,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.67,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.02,   0.00,  nan ],
	[    90,     90,  nan,  nan,     1.35,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.79,   0.00,  nan ],
	[   200,    200,  nan,  nan,     7.88,   0.00,  nan ],
	[   300,    300,  nan,  nan,    18.82,   0.00,  nan ],
	[   400,    400,  nan,  nan,    32.03,   0.01,  nan ],
	[   500,    500,  nan,  nan,    50.66,   0.01,  nan ],
	[   600,    600,  nan,  nan,    68.52,   0.01,  nan ],
	[   700,    700,  nan,  nan,    89.21,   0.01,  nan ],
	[   800,    800,  nan,  nan,   110.91,   0.01,  nan ],
	[   900,    900,  nan,  nan,   133.32,   0.01,  nan ],
	[  1000,   1000,  nan,  nan,   161.19,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   405.92,   0.05,  nan ],
	[  3000,   3000,  nan,  nan,   630.44,   0.11,  nan ],
	[  4000,   4000,  nan,  nan,   753.23,   0.23,  nan ],
	[  5000,   5000,  nan,  nan,   725.11,   0.46,  nan ],
	[  6000,   6000,  nan,  nan,   884.64,   0.65,  nan ],
	[  7000,   7000,  nan,  nan,   945.01,   0.97,  nan ],
	[  8000,   8000,  nan,  nan,   996.60,   1.37,  nan ],
	[  9000,   9000,  nan,  nan,   986.27,   1.97,  nan ],
	[ 10000,  10000,  nan,  nan,  1021.82,   2.61,  nan ],
	[ 12000,  12000,  nan,  nan,  1076.85,   4.28,  nan ],
	[ 14000,  14000,  nan,  nan,  1110.41,   6.59,  nan ],
	[ 16000,  16000,  nan,  nan,  1120.76,   9.75,  nan ],
	[ 18000,  18000,  nan,  nan,  1133.20,  13.72,  nan ],
	[ 20000,  20000,  nan,  nan,  1120.56,  19.04,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/zheevd.txt
# numactl --interleave=all ./testing_zheevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_JN = array([
	[    10,  nan,    0.0000 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0001 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0003 ],
	[    60,  nan,    0.0004 ],
	[    70,  nan,    0.0007 ],
	[    80,  nan,    0.0009 ],
	[    90,  nan,    0.0013 ],
	[   100,  nan,    0.0016 ],
	[   200,  nan,    0.0148 ],
	[   300,  nan,    0.0275 ],
	[   400,  nan,    0.0471 ],
	[   500,  nan,    0.0672 ],
	[   600,  nan,    0.0942 ],
	[   700,  nan,    0.1218 ],
	[   800,  nan,    0.1559 ],
	[   900,  nan,    0.1931 ],
	[  1000,  nan,    0.2313 ],
	[  2000,  nan,    0.8349 ],
	[  3000,  nan,    2.0546 ],
	[  4000,  nan,    3.9284 ],
	[  5000,  nan,    6.6537 ],
	[  6000,  nan,   10.3261 ],
	[  7000,  nan,   15.1780 ],
	[  8000,  nan,   21.2056 ],
	[  9000,  nan,   28.8199 ],
	[ 10000,  nan,   37.7967 ],
	[ 12000,  nan,   61.5253 ],
	[ 14000,  nan,   93.0888 ],
	[ 16000,  nan,  135.2279 ],
	[ 18000,  nan,  189.0661 ],
	[ 20000,  nan,  256.5293 ],
])

# numactl --interleave=all ./testing_zheevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_JV = array([
	[    10,  nan,    0.0002 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0003 ],
	[    40,  nan,    0.0005 ],
	[    50,  nan,    0.0007 ],
	[    60,  nan,    0.0009 ],
	[    70,  nan,    0.0014 ],
	[    80,  nan,    0.0018 ],
	[    90,  nan,    0.0022 ],
	[   100,  nan,    0.0027 ],
	[   200,  nan,    0.0201 ],
	[   300,  nan,    0.0345 ],
	[   400,  nan,    0.0567 ],
	[   500,  nan,    0.0815 ],
	[   600,  nan,    0.1100 ],
	[   700,  nan,    0.1416 ],
	[   800,  nan,    0.1816 ],
	[   900,  nan,    0.2242 ],
	[  1000,  nan,    0.2697 ],
	[  2000,  nan,    1.0056 ],
	[  3000,  nan,    2.3441 ],
	[  4000,  nan,    4.5146 ],
	[  5000,  nan,    7.7003 ],
	[  6000,  nan,   12.1018 ],
	[  7000,  nan,   18.2927 ],
	[  8000,  nan,   25.3105 ],
	[  9000,  nan,   34.7899 ],
	[ 10000,  nan,   45.9261 ],
	[ 12000,  nan,   74.9215 ],
	[ 14000,  nan,  114.9891 ],
	[ 16000,  nan,  167.8138 ],
	[ 18000,  nan,  236.7416 ],
	[ 20000,  nan,  321.9395 ],
])

# numactl --interleave=all ./testing_zheevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_gpu_JN = array([
	[    10,  nan,    0.0001 ],
	[    20,  nan,    0.0001 ],
	[    30,  nan,    0.0002 ],
	[    40,  nan,    0.0002 ],
	[    50,  nan,    0.0003 ],
	[    60,  nan,    0.0005 ],
	[    70,  nan,    0.0008 ],
	[    80,  nan,    0.0010 ],
	[    90,  nan,    0.0014 ],
	[   100,  nan,    0.0017 ],
	[   200,  nan,    0.0148 ],
	[   300,  nan,    0.0271 ],
	[   400,  nan,    0.0465 ],
	[   500,  nan,    0.0666 ],
	[   600,  nan,    0.0933 ],
	[   700,  nan,    0.1251 ],
	[   800,  nan,    0.1540 ],
	[   900,  nan,    0.1913 ],
	[  1000,  nan,    0.2276 ],
	[  2000,  nan,    0.8259 ],
	[  3000,  nan,    2.0320 ],
	[  4000,  nan,    3.9013 ],
	[  5000,  nan,    6.5860 ],
	[  6000,  nan,   10.2309 ],
	[  7000,  nan,   14.9722 ],
	[  8000,  nan,   21.0334 ],
	[  9000,  nan,   28.4432 ],
	[ 10000,  nan,   37.5093 ],
	[ 12000,  nan,   60.9586 ],
	[ 14000,  nan,   92.5242 ],
	[ 16000,  nan,  134.1422 ],
	[ 18000,  nan,  187.9327 ],
	[ 20000,  nan,       nan ],  # malloc failed?
])

# numactl --interleave=all ./testing_zheevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_gpu_JV = array([
	[    10,  nan,    0.0002 ],
	[    20,  nan,    0.0002 ],
	[    30,  nan,    0.0004 ],
	[    40,  nan,    0.0006 ],
	[    50,  nan,    0.0007 ],
	[    60,  nan,    0.0010 ],
	[    70,  nan,    0.0015 ],
	[    80,  nan,    0.0019 ],
	[    90,  nan,    0.0023 ],
	[   100,  nan,    0.0029 ],
	[   200,  nan,    0.0195 ],
	[   300,  nan,    0.0338 ],
	[   400,  nan,    0.0564 ],
	[   500,  nan,    0.0801 ],
	[   600,  nan,    0.1067 ],
	[   700,  nan,    0.1368 ],
	[   800,  nan,    0.1755 ],
	[   900,  nan,    0.2180 ],
	[  1000,  nan,    0.2612 ],
	[  2000,  nan,    0.9518 ],
	[  3000,  nan,    2.3471 ],
	[  4000,  nan,    4.5293 ],
	[  5000,  nan,    7.8989 ],
	[  6000,  nan,   12.3295 ],
	[  7000,  nan,   17.7410 ],
	[  8000,  nan,   25.4602 ],
	[  9000,  nan,   34.6644 ],
	[ 10000,  nan,   45.8345 ],
	[ 12000,  nan,   74.5212 ],
	[ 14000,  nan,  116.1441 ],
	[ 16000,  nan,  167.4060 ],
	[ 18000,  nan,  237.8173 ],
	[ 20000,  nan,       nan ],  # malloc failed?
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/zheevd_2stage.txt
# numactl --interleave=all ./testing_zheevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevdx_2stage_JN = array([
	[    10,      0,   0.0002 ],
	[    20,      0,   0.0000 ],
	[    30,      0,   0.0000 ],
	[    40,      0,   0.0000 ],
	[    50,      0,   0.0000 ],
	[    60,      0,   0.0000 ],
	[    70,      0,   0.0000 ],
	[    80,      0,   0.0000 ],
	[    90,      0,   0.0000 ],
	[   100,      0,   0.0000 ],
	[   200,    200,   0.0068 ],
	[   300,    300,   0.0415 ],
	[   400,    400,   0.0791 ],
	[   500,    500,   0.1287 ],
	[   600,    600,   0.1797 ],
	[   700,    700,   0.2359 ],
	[   800,    800,   0.2890 ],
	[   900,    900,   0.3333 ],
	[  1000,   1000,   0.3589 ],
	[  2000,   2000,   0.8954 ],
	[  3000,   3000,   1.7160 ],
	[  4000,   4000,   2.5617 ],
	[  5000,   5000,   3.6103 ],
	[  6000,   6000,   4.9139 ],
	[  7000,   7000,   6.5160 ],
	[  8000,   8000,   8.4061 ],
	[  9000,   9000,  10.5946 ],
	[ 10000,  10000,  13.3940 ],
	[ 12000,  12000,  20.1843 ],
	[ 14000,  14000,  30.0964 ],
	[ 16000,  16000,  41.2036 ],
	[ 18000,  18000,  56.8361 ],
	[ 20000,  20000,  73.6939 ],
])

# numactl --interleave=all ./testing_zheevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevdx_2stage_JV = array([
	[    10,     10,    0.0002 ],
	[    20,     20,    0.0002 ],
	[    30,     30,    0.0003 ],
	[    40,     40,    0.0005 ],
	[    50,     50,    0.0007 ],
	[    60,     60,    0.0010 ],
	[    70,     70,    0.0014 ],
	[    80,     80,    0.0018 ],
	[    90,     90,    0.0022 ],
	[   100,    100,    0.0027 ],
	[   200,    200,    0.0107 ],
	[   300,    300,    0.0485 ],
	[   400,    400,    0.0860 ],
	[   500,    500,    0.1354 ],
	[   600,    600,    0.1774 ],
	[   700,    700,    0.2385 ],
	[   800,    800,    0.3178 ],
	[   900,    900,    0.3811 ],
	[  1000,   1000,    0.4447 ],
	[  2000,   2000,    1.4069 ],
	[  3000,   3000,    2.6774 ],
	[  4000,   4000,    4.1303 ],
	[  5000,   5000,    6.3914 ],
	[  6000,   6000,   10.9810 ],
	[  7000,   7000,   15.2683 ],
	[  8000,   8000,   20.8768 ],
	[  9000,   9000,   27.3412 ],
	[ 10000,  10000,   33.2341 ],
	[ 12000,  12000,   54.8366 ],
	[ 14000,  14000,   94.2965 ],
	[ 16000,  16000,  129.5659 ],
	[ 18000,  18000,  174.3231 ],
	[ 20000,  20000,       nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/zhemv.txt
# numactl --interleave=all ./testing_zhemv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
zhemv_L = array([
	[    10,    0.0214,   0.0429,   0.0297,   0.0310,   0.0341,   0.0269,   0.2968,    0.0031,  1.99e-16,  2.51e-16,  3.20e-16,  nan ],
	[    11,    0.0275,   0.0401,   0.0381,   0.0288,   0.0423,   0.0260,   0.5126,    0.0021,  3.61e-16,  3.33e-16,  2.28e-16,  nan ],
	[    12,    0.0324,   0.0401,   0.0435,   0.0298,   0.0518,   0.0250,   0.6795,    0.0019,  3.70e-16,  3.70e-16,  4.74e-16,  nan ],
	[    13,    0.0388,   0.0389,   0.0487,   0.0310,   0.0580,   0.0260,   0.4865,    0.0031,  1.93e-16,  3.06e-16,  1.93e-16,  nan ],
	[    14,    0.0433,   0.0401,   0.0578,   0.0300,   0.0668,   0.0260,   0.5601,    0.0031,  2.54e-16,  3.92e-16,  2.84e-16,  nan ],
	[    15,    0.0494,   0.0401,   0.0664,   0.0298,   0.0762,   0.0260,   1.0381,    0.0019,  2.65e-16,  2.65e-16,  2.65e-16,  nan ],
	[    16,    0.0559,   0.0401,   0.0746,   0.0300,   0.0862,   0.0260,   1.1744,    0.0019,  3.14e-16,  4.45e-16,  4.74e-16,  nan ],
	[    17,    0.0628,   0.0401,   0.0838,   0.0300,   0.0902,   0.0279,   0.8794,    0.0029,  4.31e-16,  4.21e-16,  4.46e-16,  nan ],
	[    18,    0.0669,   0.0420,   0.0935,   0.0300,   0.1007,   0.0279,   1.4722,    0.0019,  3.21e-16,  4.02e-16,  2.96e-16,  nan ],
	[    19,    0.0743,   0.0420,   0.1005,   0.0310,   0.0920,   0.0339,   1.0891,    0.0029,  4.67e-16,  5.91e-16,  4.41e-16,  nan ],
	[    20,    0.0802,   0.0429,   0.1145,   0.0300,   0.1223,   0.0281,   1.2024,    0.0029,  3.97e-16,  4.87e-16,  3.97e-16,  nan ],
	[    21,    0.0973,   0.0389,   0.1258,   0.0300,   0.1391,   0.0272,   0.9909,    0.0038,  5.08e-16,  3.61e-16,  4.79e-16,  nan ],
	[    22,    0.1039,   0.0398,   0.1377,   0.0300,   0.1535,   0.0269,   1.0204,    0.0041,  3.61e-16,  3.23e-16,  4.04e-16,  nan ],
	[    23,    0.1189,   0.0379,   0.1501,   0.0300,   0.1735,   0.0260,   1.1122,    0.0041,  5.36e-16,  3.45e-16,  4.37e-16,  nan ],
	[    24,    0.1283,   0.0381,   0.1630,   0.0300,   0.1817,   0.0269,   1.5796,    0.0031,  5.92e-16,  5.34e-16,  4.44e-16,  nan ],
	[    25,    0.1355,   0.0391,   0.1764,   0.0300,   0.1884,   0.0281,   1.3894,    0.0038,  3.18e-16,  3.18e-16,  3.18e-16,  nan ],
	[    26,    0.1395,   0.0410,   0.1845,   0.0310,   0.2051,   0.0279,   1.4113,    0.0041,  3.86e-16,  5.63e-16,  3.86e-16,  nan ],
	[    27,    0.1537,   0.0401,   0.2049,   0.0300,   0.2134,   0.0288,   1.5188,    0.0041,  3.72e-16,  4.00e-16,  3.72e-16,  nan ],
	[    28,    0.1575,   0.0420,   0.2132,   0.0310,   0.2272,   0.0291,   1.6304,    0.0041,  3.81e-16,  2.84e-16,  4.26e-16,  nan ],
	[    29,    0.1777,   0.0398,   0.2283,   0.0310,   0.2374,   0.0298,   1.7458,    0.0041,  3.47e-16,  3.73e-16,  3.47e-16,  nan ],
	[    30,    0.1899,   0.0398,   0.2349,   0.0322,   0.2621,   0.0288,   1.5099,    0.0050,  4.27e-16,  2.65e-16,  2.65e-16,  nan ],
	[    31,    0.2074,   0.0389,   0.2523,   0.0319,   0.2771,   0.0291,   1.6098,    0.0050,  4.90e-16,  4.73e-16,  3.05e-16,  nan ],
	[    32,    0.2141,   0.0401,   0.2767,   0.0310,   0.3074,   0.0279,   1.7129,    0.0050,  3.55e-16,  4.58e-16,  5.39e-16,  nan ],
	[    33,    0.2274,   0.0401,   0.2122,   0.0429,   0.3032,   0.0300,   1.8191,    0.0050,  3.05e-16,  3.88e-16,  4.81e-16,  nan ],
	[    34,    0.2355,   0.0410,   0.2425,   0.0398,   0.3214,   0.0300,   1.9286,    0.0050,  3.35e-16,  4.67e-16,  3.77e-16,  nan ],
	[    35,    0.2492,   0.0410,   0.2552,   0.0401,   0.3402,   0.0300,   1.0206,    0.0100,  4.06e-16,  4.19e-16,  4.19e-16,  nan ],
	[    36,    0.2574,   0.0420,   0.2762,   0.0391,   0.3484,   0.0310,   1.8119,    0.0060,  4.93e-16,  4.02e-16,  3.98e-16,  nan ],
	[    37,    0.2845,   0.0401,   0.2845,   0.0401,   0.3794,   0.0300,   1.9119,    0.0060,  4.80e-16,  4.80e-16,  3.84e-16,  nan ],
	[    38,    0.3016,   0.0398,   0.2998,   0.0401,   0.3997,   0.0300,   2.0146,    0.0060,  3.92e-16,  3.74e-16,  4.18e-16,  nan ],
	[    39,    0.2994,   0.0422,   0.3232,   0.0391,   0.4240,   0.0298,   2.0384,    0.0062,  5.15e-16,  6.57e-16,  5.83e-16,  nan ],
	[    40,    0.3077,   0.0432,   0.3315,   0.0401,   0.4566,   0.0291,   2.2280,    0.0060,  3.20e-16,  3.97e-16,  3.55e-16,  nan ],
	[    41,    0.3480,   0.0401,   0.3480,   0.0401,   0.4793,   0.0291,   2.3387,    0.0060,  4.90e-16,  5.48e-16,  5.20e-16,  nan ],
	[    42,    0.3406,   0.0429,   0.3649,   0.0401,   0.4865,   0.0300,   2.4522,    0.0060,  5.42e-16,  4.23e-16,  4.79e-16,  nan ],
	[    43,    0.3822,   0.0401,   0.3822,   0.0401,   0.5096,   0.0300,   2.2140,    0.0069,  6.61e-16,  3.69e-16,  3.41e-16,  nan ],
	[    44,    0.3999,   0.0401,   0.3906,   0.0410,   0.5331,   0.0300,   2.2392,    0.0072,  5.42e-16,  6.51e-16,  5.42e-16,  nan ],
	[    45,    0.4082,   0.0410,   0.4082,   0.0410,   0.5617,   0.0298,   2.0651,    0.0081,  4.80e-16,  4.74e-16,  5.69e-16,  nan ],
	[    46,    0.4364,   0.0401,   0.4364,   0.0401,   0.5865,   0.0298,   2.5282,    0.0069,  5.57e-16,  4.78e-16,  4.52e-16,  nan ],
	[    47,    0.4553,   0.0401,   0.4447,   0.0410,   0.6070,   0.0300,   2.2496,    0.0081,  6.76e-16,  6.76e-16,  4.78e-16,  nan ],
	[    48,    0.4861,   0.0391,   0.4746,   0.0401,   0.6535,   0.0291,   2.7491,    0.0069,  5.34e-16,  4.68e-16,  4.50e-16,  nan ],
	[    49,    0.5063,   0.0391,   0.4827,   0.0410,   0.6590,   0.0300,   2.8631,    0.0069,  5.23e-16,  5.23e-16,  4.86e-16,  nan ],
	[    50,    0.5268,   0.0391,   0.5143,   0.0401,   0.6646,   0.0310,   2.9794,    0.0069,  5.86e-16,  5.86e-16,  6.36e-16,  nan ],
	[    51,    0.5348,   0.0401,   0.5348,   0.0401,   0.6705,   0.0319,   3.0980,    0.0069,  4.67e-16,  3.12e-16,  3.94e-16,  nan ],
	[    52,    0.5727,   0.0389,   0.5556,   0.0401,   0.7181,   0.0310,   2.7455,    0.0081,  5.47e-16,  5.63e-16,  5.63e-16,  nan ],
	[    53,    0.5804,   0.0398,   0.5635,   0.0410,   0.7233,   0.0319,   2.9370,    0.0079,  5.69e-16,  5.40e-16,  4.83e-16,  nan ],
	[    54,    0.6132,   0.0391,   0.5847,   0.0410,   0.7736,   0.0310,   3.4677,    0.0069,  4.74e-16,  4.00e-16,  4.00e-16,  nan ],
	[    55,    0.6244,   0.0398,   0.6062,   0.0410,   0.8021,   0.0310,   3.0668,    0.0081,  4.09e-16,  3.93e-16,  2.89e-16,  nan ],
	[    56,    0.6104,   0.0422,   0.6139,   0.0420,   0.8063,   0.0319,   3.1778,    0.0081,  5.23e-16,  6.34e-16,  4.57e-16,  nan ],
	[    57,    0.6505,   0.0410,   0.6357,   0.0420,   0.8108,   0.0329,   2.9444,    0.0091,  5.57e-16,  5.14e-16,  3.94e-16,  nan ],
	[    58,    0.6893,   0.0401,   0.6398,   0.0432,   0.8578,   0.0322,   3.1296,    0.0088,  5.05e-16,  6.93e-16,  4.78e-16,  nan ],
	[    59,    0.6805,   0.0420,   0.6805,   0.0420,   0.8679,   0.0329,   3.1519,    0.0091,  6.02e-16,  4.97e-16,  4.85e-16,  nan ],
	[    60,    0.7370,   0.0401,   0.7035,   0.0420,   0.9240,   0.0319,   3.2583,    0.0091,  4.74e-16,  4.75e-16,  4.77e-16,  nan ],
	[    61,    0.7269,   0.0420,   0.6953,   0.0439,   0.9547,   0.0319,   3.0459,    0.0100,  5.21e-16,  4.80e-16,  4.80e-16,  nan ],
	[    62,    0.7680,   0.0410,   0.7180,   0.0439,   1.0162,   0.0310,   3.1453,    0.0100,  4.73e-16,  6.88e-16,  5.13e-16,  nan ],
	[    63,    0.7927,   0.0410,   0.7533,   0.0432,   0.9880,   0.0329,   3.5881,    0.0091,  5.64e-16,  4.07e-16,  4.07e-16,  nan ],
	[    64,    0.8373,   0.0401,   0.7992,   0.0420,   1.0497,   0.0319,   3.8016,    0.0088,  5.55e-16,  7.02e-16,  4.00e-16,  nan ],
	[    65,    0.6907,   0.0501,   0.3757,   0.0920,   0.9867,   0.0350,   3.0859,    0.0112,  4.89e-16,  4.89e-16,  4.89e-16,  nan ],
	[    66,    0.7292,   0.0489,   0.8124,   0.0439,   1.0169,   0.0350,   3.2497,    0.0110,  6.55e-16,  4.44e-16,  5.62e-16,  nan ],
	[    67,    0.7333,   0.0501,   0.8191,   0.0448,   1.0548,   0.0348,   3.3478,    0.0110,  4.53e-16,  5.00e-16,  7.65e-16,  nan ],
	[    68,    0.7410,   0.0510,   0.8435,   0.0448,   1.0788,   0.0350,   3.4474,    0.0110,  7.53e-16,  5.22e-16,  5.22e-16,  nan ],
	[    69,    0.7773,   0.0501,   0.8682,   0.0448,   1.1104,   0.0350,   3.4729,    0.0112,  6.26e-16,  6.26e-16,  6.18e-16,  nan ],
	[    70,    0.8192,   0.0489,   0.9278,   0.0432,   1.2170,   0.0329,   3.6509,    0.0110,  6.11e-16,  6.42e-16,  8.18e-16,  nan ],
	[    71,    0.8385,   0.0491,   0.9336,   0.0441,   1.2516,   0.0329,   2.3030,    0.0179,  8.01e-16,  1.00e-15,  8.01e-16,  nan ],
	[    72,    0.8662,   0.0489,   0.9651,   0.0439,   1.2505,   0.0339,   3.5514,    0.0119,  7.12e-16,  4.41e-16,  8.83e-16,  nan ],
	[    73,    0.8371,   0.0520,   0.9655,   0.0451,   1.2085,   0.0360,   3.8827,    0.0112,  6.16e-16,  7.79e-16,  8.03e-16,  nan ],
	[    74,    0.8760,   0.0510,   0.9972,   0.0448,   1.2415,   0.0360,   3.7494,    0.0119,  6.44e-16,  9.06e-16,  6.92e-16,  nan ],
	[    75,    0.9391,   0.0489,   1.0463,   0.0439,   1.2421,   0.0370,   3.5003,    0.0131,  5.36e-16,  6.36e-16,  5.10e-16,  nan ],
	[    76,    0.9411,   0.0501,   1.0513,   0.0448,   1.3445,   0.0350,   3.6599,    0.0129,  6.27e-16,  5.69e-16,  5.63e-16,  nan ],
	[    77,    0.9658,   0.0501,   1.0509,   0.0460,   1.3797,   0.0350,   3.7559,    0.0129,  5.61e-16,  4.61e-16,  4.61e-16,  nan ],
	[    78,    0.9723,   0.0510,   1.1009,   0.0451,   1.4251,   0.0348,   3.5266,    0.0141,  8.59e-16,  7.78e-16,  6.11e-16,  nan ],
	[    79,    0.9744,   0.0522,   1.1290,   0.0451,   1.4516,   0.0350,   3.6168,    0.0141,  7.42e-16,  7.68e-16,  9.17e-16,  nan ],
	[    80,    0.9310,   0.0560,   1.1335,   0.0460,   1.4488,   0.0360,   3.7080,    0.0141,  5.40e-16,  9.06e-16,  9.06e-16,  nan ],
	[    81,    1.0885,   0.0491,   1.1618,   0.0460,   1.4850,   0.0360,   4.0769,    0.0131,  6.85e-16,  5.34e-16,  5.62e-16,  nan ],
	[    82,    1.1430,   0.0479,   1.1662,   0.0470,   1.5629,   0.0350,   3.6468,    0.0150,  7.35e-16,  5.48e-16,  6.25e-16,  nan ],
	[    83,    1.1480,   0.0489,   1.2193,   0.0460,   1.4708,   0.0381,   3.9887,    0.0141,  6.69e-16,  6.17e-16,  7.66e-16,  nan ],
	[    84,    1.1054,   0.0520,   1.2233,   0.0470,   1.5062,   0.0381,   4.0845,    0.0141,  9.11e-16,  6.10e-16,  5.35e-16,  nan ],
	[    85,    1.1748,   0.0501,   1.1528,   0.0510,   1.6338,   0.0360,   3.9160,    0.0150,  8.52e-16,  7.14e-16,  8.52e-16,  nan ],
	[    86,    1.1582,   0.0520,   1.2817,   0.0470,   1.6290,   0.0370,   4.0079,    0.0150,  7.01e-16,  7.39e-16,  6.81e-16,  nan ],
	[    87,    1.2302,   0.0501,   1.3114,   0.0470,   1.6668,   0.0370,   2.9028,    0.0212,  6.93e-16,  5.89e-16,  5.89e-16,  nan ],
	[    88,    1.2349,   0.0510,   1.3415,   0.0470,   1.7050,   0.0370,   4.1948,    0.0150,  5.82e-16,  5.42e-16,  6.51e-16,  nan ],
	[    89,    1.3120,   0.0491,   1.3446,   0.0479,   1.7436,   0.0370,   4.0338,    0.0160,  5.76e-16,  6.77e-16,  6.82e-16,  nan ],
	[    90,    1.3221,   0.0498,   1.3679,   0.0482,   1.7827,   0.0370,   4.3860,    0.0150,  7.93e-16,  9.60e-16,  7.93e-16,  nan ],
	[   100,    1.6296,   0.0498,   1.7288,   0.0470,   2.1286,   0.0381,   4.4813,    0.0181,  7.65e-16,  7.42e-16,  6.07e-16,  nan ],
	[   110,    1.9691,   0.0498,   2.0075,   0.0489,   2.5722,   0.0381,   4.6766,    0.0210,  7.86e-16,  7.31e-16,  6.46e-16,  nan ],
	[   120,    2.2441,   0.0520,   2.3408,   0.0498,   2.8443,   0.0410,   4.8922,    0.0238,  6.70e-16,  8.34e-16,  7.49e-16,  nan ],
	[   130,    2.2762,   0.0601,   2.5838,   0.0529,   3.1867,   0.0429,   4.7406,    0.0288,  7.88e-16,  9.16e-16,  9.28e-16,  nan ],
	[   140,    2.6911,   0.0589,   2.9283,   0.0541,   3.6724,   0.0432,   4.9605,    0.0319,  8.37e-16,  8.67e-16,  7.32e-16,  nan ],
	[   150,    3.0379,   0.0598,   3.2448,   0.0560,   4.0345,   0.0451,   4.8880,    0.0372,  8.47e-16,  7.64e-16,  8.47e-16,  nan ],
	[   160,    3.4544,   0.0598,   3.8196,   0.0541,   4.5875,   0.0451,   5.1610,    0.0401,  7.59e-16,  9.10e-16,  7.19e-16,  nan ],
	[   170,    3.8214,   0.0610,   4.1629,   0.0560,   5.2036,   0.0448,   5.2036,    0.0448,  1.00e-15,  8.52e-16,  8.52e-16,  nan ],
	[   180,    4.2162,   0.0620,   4.4382,   0.0589,   5.4538,   0.0479,   5.2201,    0.0501,  1.11e-15,  8.24e-16,  9.87e-16,  nan ],
	[   190,    4.6957,   0.0620,   4.7691,   0.0610,   5.7050,   0.0510,   5.4021,    0.0539,  8.72e-16,  6.69e-16,  7.48e-16,  nan ],
	[   200,    4.6790,   0.0689,   5.2009,   0.0620,   6.3189,   0.0510,   5.4526,    0.0591,  9.53e-16,  9.10e-16,  8.64e-16,  nan ],
	[   210,    5.1568,   0.0689,   5.8216,   0.0610,   6.9641,   0.0510,   5.6452,    0.0629,  1.03e-15,  1.22e-15,  1.08e-15,  nan ],
	[   220,    5.4869,   0.0710,   6.0785,   0.0641,   7.3323,   0.0532,   5.6578,    0.0689,  9.32e-16,  1.19e-15,  1.04e-15,  nan ],
	[   230,    5.8386,   0.0730,   6.5443,   0.0651,   7.8705,   0.0541,   5.7632,    0.0739,  1.11e-15,  1.04e-15,  9.91e-16,  nan ],
	[   240,    6.4398,   0.0720,   7.0210,   0.0660,   8.5675,   0.0541,   5.8054,    0.0799,  1.12e-15,  1.38e-15,  1.39e-15,  nan ],
	[   250,    6.9859,   0.0720,   7.4026,   0.0679,   8.9776,   0.0560,   5.7801,    0.0870,  1.14e-15,  1.16e-15,  1.02e-15,  nan ],
	[   260,    6.6319,   0.0820,   7.8940,   0.0689,   9.1991,   0.0591,   5.9103,    0.0920,  1.10e-15,  1.03e-15,  1.14e-15,  nan ],
	[   270,    7.3206,   0.0801,   8.3949,   0.0699,   9.7996,   0.0598,   5.8704,    0.0999,  1.13e-15,  1.23e-15,  1.13e-15,  nan ],
	[   280,    7.9902,   0.0789,   8.8750,   0.0710,  10.4951,   0.0601,   5.9433,    0.1061,  1.06e-15,  1.08e-15,  1.02e-15,  nan ],
	[   290,    8.2457,   0.0820,   8.8919,   0.0761,  10.4284,   0.0648,   5.8727,    0.1152,  1.57e-15,  1.39e-15,  1.57e-15,  nan ],
	[   300,    8.7213,   0.0830,   9.6349,   0.0751,  11.1172,   0.0651,   5.9744,    0.1211,  1.33e-15,  1.33e-15,  1.33e-15,  nan ],
	[   310,    9.3109,   0.0830,   9.9088,   0.0780,  11.5309,   0.0670,   5.9453,    0.1299,  1.65e-15,  1.54e-15,  1.51e-15,  nan ],
	[   320,    9.4578,   0.0870,  10.8216,   0.0761,  12.1126,   0.0679,   5.9621,    0.1380,  1.79e-15,  1.97e-15,  1.96e-15,  nan ],
	[   330,    9.5096,   0.0920,  10.9247,   0.0801,  12.4853,   0.0701,   5.9881,    0.1462,  1.22e-15,  1.25e-15,  1.12e-15,  nan ],
	[   340,   10.2257,   0.0908,  11.3256,   0.0820,  12.9007,   0.0720,   5.9939,    0.1550,  1.35e-15,  1.40e-15,  1.24e-15,  nan ],
	[   350,   10.8347,   0.0908,  11.1871,   0.0880,  13.3162,   0.0739,   6.0000,    0.1640,  1.32e-15,  1.32e-15,  1.30e-15,  nan ],
	[   360,   11.3129,   0.0920,  12.4056,   0.0839,  13.0351,   0.0799,   6.0148,    0.1731,  1.59e-15,  1.43e-15,  1.61e-15,  nan ],
	[   370,   11.5885,   0.0949,  12.7762,   0.0861,  14.5039,   0.0758,   5.8457,    0.1881,  1.55e-15,  1.38e-15,  1.24e-15,  nan ],
	[   380,   11.9518,   0.0970,  13.3637,   0.0868,  15.0600,   0.0770,   6.0729,    0.1910,  1.50e-15,  1.50e-15,  1.35e-15,  nan ],
	[   390,   11.8594,   0.1030,  13.5895,   0.0899,  14.9366,   0.0818,   5.9851,    0.2041,  1.46e-15,  1.61e-15,  1.49e-15,  nan ],
	[   400,   12.5908,   0.1020,  14.4473,   0.0889,  16.6837,   0.0770,   6.0891,    0.2110,  1.53e-15,  1.37e-15,  1.48e-15,  nan ],
	[   410,   12.9843,   0.1040,  14.6662,   0.0920,  16.4568,   0.0820,   6.0807,    0.2220,  1.45e-15,  1.37e-15,  1.19e-15,  nan ],
	[   420,   12.9981,   0.1090,  14.9250,   0.0949,  17.0694,   0.0830,   5.9461,    0.2382,  1.64e-15,  1.70e-15,  1.67e-15,  nan ],
	[   430,   13.6233,   0.1090,  15.4872,   0.0958,  17.4394,   0.0851,   5.9864,    0.2480,  1.72e-15,  1.77e-15,  1.80e-15,  nan ],
	[   440,   14.1394,   0.1099,  15.8596,   0.0980,  18.4654,   0.0842,   6.1435,    0.2530,  1.40e-15,  1.51e-15,  1.37e-15,  nan ],
	[   450,   14.1440,   0.1149,  15.9286,   0.1020,  18.6779,   0.0870,   6.1585,    0.2639,  1.58e-15,  1.54e-15,  1.52e-15,  nan ],
	[   460,   14.2751,   0.1190,  16.6432,   0.1020,  18.8446,   0.0901,   6.0831,    0.2792,  1.29e-15,  1.26e-15,  1.36e-15,  nan ],
	[   470,   14.6375,   0.1211,  16.8613,   0.1051,  19.7237,   0.0899,   6.1555,    0.2880,  1.94e-15,  1.85e-15,  1.88e-15,  nan ],
	[   480,   15.5413,   0.1190,  17.7869,   0.1040,  20.5161,   0.0901,   6.1257,    0.3018,  1.59e-15,  1.76e-15,  1.95e-15,  nan ],
	[   490,   15.6610,   0.1230,  18.0381,   0.1068,  20.1022,   0.0958,   6.0760,    0.3171,  2.79e-15,  2.35e-15,  2.81e-15,  nan ],
	[   500,   16.1803,   0.1240,  18.4109,   0.1090,  20.6727,   0.0970,   6.1549,    0.3259,  1.89e-15,  1.82e-15,  1.82e-15,  nan ],
	[   510,   16.4225,   0.1271,  18.6238,   0.1121,  20.8906,   0.0999,   5.9303,    0.3519,  1.79e-15,  2.01e-15,  1.79e-15,  nan ],
	[   520,   16.4247,   0.1321,  19.1968,   0.1130,  21.7167,   0.0999,   6.0743,    0.3572,  1.96e-15,  1.63e-15,  1.63e-15,  nan ],
	[   530,   17.0616,   0.1321,  19.6102,   0.1149,  22.0844,   0.1020,   6.0903,    0.3700,  2.21e-15,  2.03e-15,  2.19e-15,  nan ],
	[   540,   17.3045,   0.1352,  20.3140,   0.1152,  22.7122,   0.1030,   6.1554,    0.3800,  1.99e-15,  1.91e-15,  1.70e-15,  nan ],
	[   550,   17.4578,   0.1390,  20.7289,   0.1171,  23.2904,   0.1042,   6.0800,    0.3991,  1.68e-15,  1.89e-15,  1.67e-15,  nan ],
	[   560,   18.3813,   0.1369,  21.7096,   0.1159,  24.4233,   0.1030,   6.1809,    0.4070,  1.82e-15,  1.69e-15,  1.91e-15,  nan ],
	[   570,   18.4637,   0.1411,  16.1694,   0.1612,  24.3442,   0.1070,   6.0624,    0.4299,  1.88e-15,  2.01e-15,  1.78e-15,  nan ],
	[   580,   18.2237,   0.1481,  21.9320,   0.1230,  24.7635,   0.1090,   6.1040,    0.4420,  2.23e-15,  2.40e-15,  2.02e-15,  nan ],
	[   590,   18.8567,   0.1481,  22.6938,   0.1230,  25.8499,   0.1080,   6.1213,    0.4561,  2.50e-15,  2.51e-15,  2.52e-15,  nan ],
	[   600,   19.2525,   0.1500,  23.2881,   0.1240,  26.0426,   0.1109,   6.1690,    0.4680,  1.84e-15,  1.75e-15,  1.84e-15,  nan ],
	[   610,   19.6180,   0.1521,  23.7051,   0.1259,  26.4057,   0.1130,   6.1657,    0.4840,  2.13e-15,  2.67e-15,  2.71e-15,  nan ],
	[   620,   20.2975,   0.1519,  24.3036,   0.1268,  27.0492,   0.1140,   6.1277,    0.5031,  2.39e-15,  2.20e-15,  2.42e-15,  nan ],
	[   630,   20.5376,   0.1550,  24.3160,   0.1309,  27.4680,   0.1159,   6.2527,    0.5090,  1.95e-15,  2.04e-15,  2.04e-15,  nan ],
	[   640,   21.4581,   0.1531,  25.4642,   0.1290,  28.2877,   0.1161,   6.1254,    0.5362,  2.18e-15,  2.39e-15,  2.22e-15,  nan ],
	[   650,   21.4644,   0.1578,  25.8824,   0.1309,  28.7060,   0.1180,   6.2268,    0.5441,  2.28e-15,  2.31e-15,  2.32e-15,  nan ],
	[   660,   21.2929,   0.1640,  25.8826,   0.1349,  28.8945,   0.1209,   6.2685,    0.5572,  2.10e-15,  2.10e-15,  1.78e-15,  nan ],
	[   670,   22.2331,   0.1619,  26.4847,   0.1359,  30.0125,   0.1199,   6.2588,    0.5751,  2.04e-15,  2.06e-15,  2.10e-15,  nan ],
	[   680,   22.9010,   0.1619,  26.6720,   0.1390,  30.3707,   0.1221,   6.1583,    0.6020,  2.36e-15,  2.34e-15,  2.21e-15,  nan ],
	[   690,   22.7092,   0.1681,  27.4614,   0.1390,  30.7884,   0.1240,   6.2368,    0.6120,  2.49e-15,  2.48e-15,  2.33e-15,  nan ],
	[   700,   23.4047,   0.1678,  27.8797,   0.1409,  31.2063,   0.1259,   6.2365,    0.6299,  2.77e-15,  2.44e-15,  2.28e-15,  nan ],
	[   710,   23.6409,   0.1709,  28.0638,   0.1440,  31.5652,   0.1280,   6.2456,    0.6471,  2.25e-15,  2.40e-15,  2.40e-15,  nan ],
	[   720,   23.7478,   0.1750,  28.8590,   0.1440,  32.2197,   0.1290,   6.2120,    0.6690,  2.08e-15,  1.90e-15,  1.95e-15,  nan ],
	[   730,   24.1481,   0.1769,  29.2299,   0.1462,  31.3799,   0.1361,   6.1828,    0.6909,  1.99e-15,  1.85e-15,  2.03e-15,  nan ],
	[   740,   24.6475,   0.1781,  29.4586,   0.1490,  31.3123,   0.1402,   6.1909,    0.7091,  2.16e-15,  2.16e-15,  2.00e-15,  nan ],
	[   750,   24.7541,   0.1822,  30.0670,   0.1500,  32.4393,   0.1390,   6.2027,    0.7269,  2.04e-15,  2.13e-15,  2.11e-15,  nan ],
	[   760,   25.7209,   0.1800,  30.8733,   0.1500,  33.5394,   0.1380,   6.1983,    0.7470,  2.70e-15,  2.25e-15,  2.29e-15,  nan ],
	[   770,   25.9547,   0.1831,  30.8563,   0.1540,  32.5706,   0.1459,   5.5524,    0.8559,  2.44e-15,  2.38e-15,  2.06e-15,  nan ],
	[   780,   26.4945,   0.1841,  31.6622,   0.1540,  34.5503,   0.1411,   6.2038,    0.7861,  2.60e-15,  2.21e-15,  2.21e-15,  nan ],
	[   790,   27.0375,   0.1850,  32.2786,   0.1550,  34.9685,   0.1431,   6.2686,    0.7980,  2.00e-15,  2.19e-15,  2.25e-15,  nan ],
	[   800,   27.2688,   0.1881,  32.8977,   0.1559,  35.3286,   0.1452,   6.2708,    0.8180,  2.11e-15,  2.15e-15,  2.01e-15,  nan ],
	[   810,   27.8132,   0.1891,  33.0672,   0.1590,  36.2760,   0.1450,   6.2147,    0.8461,  2.16e-15,  1.98e-15,  2.11e-15,  nan ],
	[   820,   28.2188,   0.1910,  33.6859,   0.1600,  36.1652,   0.1490,   6.2148,    0.8671,  2.23e-15,  2.21e-15,  2.10e-15,  nan ],
	[   830,   28.7670,   0.1919,  34.5118,   0.1600,  37.0519,   0.1490,   6.1770,    0.8938,  2.17e-15,  2.30e-15,  2.43e-15,  nan ],
	[   840,   28.8193,   0.1962,  34.2255,   0.1652,  36.9444,   0.1531,   6.2139,    0.9100,  2.00e-15,  2.19e-15,  2.10e-15,  nan ],
	[   850,   29.0849,   0.1991,  34.8935,   0.1659,  37.1343,   0.1559,   6.2383,    0.9282,  2.78e-15,  2.56e-15,  2.56e-15,  nan ],
	[   860,   29.6307,   0.2000,  36.3985,   0.1628,  37.7814,   0.1569,  10.6788,    0.5550,  2.25e-15,  2.66e-15,  2.31e-15,  nan ],
	[   870,   30.6520,   0.1979,  36.2926,   0.1671,  38.6057,   0.1571,  10.6404,    0.5701,  2.03e-15,  2.28e-15,  2.03e-15,  nan ],
	[   880,   31.1723,   0.1991,  37.1841,   0.1669,  39.7995,   0.1559,  10.6284,    0.5839,  2.34e-15,  2.34e-15,  2.33e-15,  nan ],
	[   890,   31.2480,   0.2031,  37.9790,   0.1671,  40.4609,   0.1569,  10.5439,    0.6020,  2.43e-15,  2.33e-15,  2.31e-15,  nan ],
	[   900,   31.3645,   0.2069,  37.7069,   0.1721,  40.5729,   0.1600,  10.6553,    0.6092,  2.84e-15,  2.38e-15,  2.49e-15,  nan ],
	[  1000,   34.3959,   0.2329,  42.1641,   0.1900,  44.5096,   0.1800,  10.3911,    0.7710,  3.31e-15,  2.96e-15,  3.23e-15,  nan ],
	[  1100,   37.5751,   0.2580,  45.9392,   0.2110,  28.3516,   0.3419,  10.6180,    0.9129,  3.19e-15,  3.24e-15,  3.24e-15,  nan ],
	[  1200,   41.3494,   0.2789,  51.3031,   0.2248,  30.9130,   0.3731,   9.4306,    1.2231,  3.04e-15,  3.44e-15,  3.23e-15,  nan ],
	[  1300,   44.2153,   0.3061,  54.3797,   0.2489,  32.6278,   0.4148,   8.5346,    1.5860,  3.33e-15,  3.15e-15,  3.22e-15,  nan ],
	[  1400,   48.4453,   0.3240,  60.6235,   0.2589,  34.6511,   0.4530,   8.1877,    1.9171,  3.45e-15,  4.07e-15,  3.90e-15,  nan ],
	[  1500,   52.2273,   0.3450,  65.4878,   0.2751,  37.5425,   0.4799,   8.4392,    2.1350,  3.54e-15,  2.77e-15,  3.06e-15,  nan ],
	[  1600,   55.3994,   0.3700,  68.7839,   0.2980,  38.8171,   0.5281,   8.3468,    2.4559,  3.14e-15,  3.04e-15,  2.70e-15,  nan ],
	[  1700,   59.1816,   0.3910,  73.4730,   0.3150,  40.1730,   0.5760,   8.3938,    2.7568,  3.76e-15,  3.66e-15,  3.27e-15,  nan ],
	[  1800,   63.4073,   0.4091,  75.8765,   0.3419,  42.6694,   0.6080,   7.8635,    3.2990,  3.33e-15,  3.62e-15,  3.41e-15,  nan ],
	[  1900,   65.5636,   0.4408,  77.4614,   0.3731,  44.9489,   0.6430,   8.4414,    3.4239,  5.07e-15,  5.00e-15,  4.89e-15,  nan ],
	[  2000,   64.4213,   0.4971,  76.9733,   0.4160,  44.4910,   0.7198,   8.2323,    3.8900,  3.93e-15,  4.00e-15,  3.81e-15,  nan ],
	[  2100,   66.4934,   0.5310,  78.1017,   0.4520,  35.0238,   1.0080,   8.4584,    4.1740,  3.76e-15,  3.51e-15,  3.81e-15,  nan ],
	[  2200,   67.2658,   0.5760,  78.7757,   0.4919,  37.2910,   1.0390,   8.1846,    4.7340,  4.15e-15,  4.37e-15,  4.17e-15,  nan ],
	[  2300,   68.2886,   0.6201,  78.4189,   0.5400,  38.4290,   1.1020,   7.7971,    5.4312,  4.35e-15,  4.95e-15,  4.55e-15,  nan ],
	[  2400,   70.8145,   0.6511,  78.6795,   0.5860,  40.0237,   1.1520,   8.4681,    5.4450,  5.39e-15,  5.73e-15,  6.04e-15,  nan ],
	[  2500,   71.1808,   0.7029,  78.7987,   0.6349,  42.0018,   1.1911,   8.4583,    5.9149,  5.28e-15,  5.28e-15,  4.73e-15,  nan ],
	[  2600,   71.4831,   0.7570,  79.6906,   0.6790,  42.5415,   1.2720,   8.2829,    6.5329,  5.84e-15,  4.69e-15,  5.07e-15,  nan ],
	[  2700,   73.4757,   0.7942,  79.2834,   0.7360,  44.0987,   1.3232,   8.3515,    6.9871,  4.90e-15,  4.24e-15,  4.53e-15,  nan ],
	[  2800,   75.4393,   0.8318,  80.4670,   0.7799,  40.5371,   1.5481,   8.4630,    7.4151,  6.08e-15,  5.87e-15,  5.04e-15,  nan ],
	[  2900,   75.6332,   0.8900,  81.6008,   0.8249,  45.9760,   1.4641,   8.5134,    7.9069,  4.26e-15,  4.58e-15,  4.71e-15,  nan ],
	[  3000,   77.3728,   0.9310,  82.5071,   0.8731,  46.1213,   1.5619,   8.2487,    8.7330,  5.07e-15,  4.46e-15,  5.37e-15,  nan ],
	[  3100,   78.2474,   0.9830,  83.6872,   0.9191,  38.5533,   1.9951,   8.4146,    9.1410,  4.85e-15,  5.16e-15,  4.85e-15,  nan ],
	[  3200,   80.2799,   1.0209,  84.0691,   0.9749,  40.7152,   2.0130,   9.0613,    9.0449,  5.78e-15,  5.55e-15,  5.57e-15,  nan ],
	[  3300,   82.0040,   1.0629,  85.5344,   1.0190,  41.5236,   2.0990,   8.5677,   10.1731,  5.83e-15,  6.03e-15,  6.08e-15,  nan ],
	[  3400,   82.8304,   1.1170,  86.3892,   1.0710,  42.1118,   2.1970,   8.4019,   11.0118,  6.40e-15,  5.89e-15,  6.04e-15,  nan ],
	[  3500,   84.0765,   1.1661,  87.4560,   1.1210,  43.9852,   2.2290,   8.4583,   11.5912,  5.33e-15,  4.88e-15,  4.68e-15,  nan ],
	[  3600,   86.2161,   1.2031,  87.8882,   1.1802,  44.6889,   2.3210,   8.3011,   12.4950,  4.98e-15,  5.08e-15,  5.21e-15,  nan ],
	[  3700,   88.2894,   1.2410,  87.6495,   1.2500,  44.7030,   2.4509,   8.4580,   12.9540,  7.14e-15,  6.15e-15,  6.24e-15,  nan ],
	[  3800,   89.5800,   1.2901,  88.6138,   1.3041,  45.7669,   2.5251,   8.2229,   14.0541,  4.79e-15,  5.35e-15,  5.03e-15,  nan ],
	[  3900,   88.0882,   1.3819,  88.5926,   1.3740,  47.1605,   2.5811,   8.4119,   14.4708,  6.18e-15,  6.43e-15,  5.60e-15,  nan ],
	[  4000,   88.3052,   1.4501,  88.6697,   1.4441,  46.9551,   2.7270,   8.4542,   15.1460,  8.13e-15,  7.03e-15,  7.12e-15,  nan ],
	[  4100,   87.9315,   1.5299,  87.9863,   1.5290,  38.9035,   3.4580,   7.9547,   16.9120,  6.49e-15,  6.29e-15,  6.51e-15,  nan ],
	[  4200,   89.1197,   1.5841,  88.4013,   1.5969,  41.2679,   3.4208,   8.3409,   16.9251,  7.64e-15,  7.16e-15,  7.21e-15,  nan ],
	[  4300,   90.4984,   1.6351,  88.5613,   1.6708,  42.8647,   3.4521,   8.4257,   17.5619,  6.87e-15,  7.02e-15,  7.41e-15,  nan ],
	[  4400,   90.7211,   1.7078,  89.6696,   1.7278,  44.4453,   3.4859,   8.4524,   18.3301,  6.15e-15,  6.33e-15,  6.45e-15,  nan ],
	[  4500,   91.8643,   1.7641,  89.7773,   1.8051,  43.9881,   3.6840,   8.4744,   19.1228,  6.38e-15,  6.61e-15,  6.14e-15,  nan ],
	[  4600,   91.9290,   1.8420,  89.9725,   1.8821,  45.5459,   3.7179,   8.2800,   20.4511,  7.94e-15,  7.22e-15,  6.91e-15,  nan ],
	[  4700,   92.6933,   1.9071,  89.4180,   1.9770,  45.8679,   3.8540,   8.5943,   20.5691,  6.17e-15,  6.62e-15,  6.32e-15,  nan ],
	[  4800,   92.8374,   1.9860,  90.2060,   2.0440,  46.0950,   3.9999,   8.5913,   21.4610,  7.29e-15,  6.77e-15,  6.09e-15,  nan ],
	[  4900,   92.7695,   2.0711,  89.9128,   2.1369,  47.4890,   4.0460,   8.6061,   22.3260,  8.60e-15,  7.83e-15,  7.27e-15,  nan ],
	[  5000,   94.2399,   2.1229,  90.6463,   2.2070,  47.7827,   4.1869,   8.4930,   23.5560,  7.46e-15,  6.79e-15,  6.76e-15,  nan ],
	[  5100,   93.9627,   2.2151,  90.5328,   2.2991,  48.8150,   4.2639,   8.5444,   24.3599,  8.21e-15,  7.87e-15,  7.45e-15,  nan ],
	[  5200,   95.7861,   2.2590,  91.8411,   2.3561,  43.3106,   4.9961,   8.6132,   25.1222,  7.62e-15,  8.81e-15,  8.19e-15,  nan ],
	[  5300,   96.6391,   2.3260,  91.8292,   2.4478,  43.8700,   5.1239,   8.6323,   26.0398,  8.09e-15,  7.39e-15,  7.75e-15,  nan ],
	[  5400,   96.6636,   2.4140,  91.7606,   2.5430,  43.4870,   5.3658,   8.3082,   28.0859,  7.52e-15,  7.13e-15,  7.19e-15,  nan ],
	[  5500,   98.2769,   2.4631,  92.1073,   2.6281,  44.8771,   5.3940,   8.5884,   28.1851,  7.80e-15,  7.50e-15,  7.40e-15,  nan ],
	[  5600,   99.3439,   2.5260,  91.3909,   2.7459,  46.0795,   5.4460,   8.6243,   29.0978,  6.73e-15,  6.82e-15,  8.29e-15,  nan ],
	[  5700,   99.3776,   2.6162,  92.3580,   2.8150,  45.5959,   5.7020,   8.6504,   30.0550,  7.51e-15,  7.66e-15,  7.82e-15,  nan ],
	[  5800,   98.4276,   2.7349,  91.7192,   2.9349,  47.2510,   5.6970,   8.5195,   31.5969,  9.77e-15,  9.50e-15,  8.77e-15,  nan ],
	[  5900,   98.7764,   2.8200,  92.4236,   3.0138,  47.3160,   5.8870,   8.3164,   33.4940,  7.59e-15,  6.96e-15,  7.36e-15,  nan ],
	[  6000,   99.5765,   2.8930,  92.8076,   3.1040,  48.7497,   5.9092,   8.7234,   33.0229,  7.65e-15,  8.34e-15,  8.60e-15,  nan ],
	[  6100,   99.4876,   2.9929,  92.8181,   3.2079,  48.4696,   6.1431,   8.6965,   34.2381,  8.56e-15,  8.41e-15,  8.09e-15,  nan ],
	[  6200,   99.4791,   3.0921,  92.7094,   3.3178,  43.7604,   7.0291,   8.1059,   37.9469,  8.77e-15,  7.33e-15,  7.14e-15,  nan ],
	[  6300,   99.6851,   3.1860,  92.5386,   3.4320,  44.4876,   7.1390,   8.6725,   36.6211,  7.80e-15,  7.06e-15,  7.83e-15,  nan ],
	[  6400,  100.0227,   3.2768,  91.8863,   3.5670,  44.3699,   7.3869,   9.1806,   35.7010,  7.25e-15,  7.02e-15,  6.82e-15,  nan ],
	[  6500,  101.4090,   3.3338,  91.9229,   3.6778,  44.7602,   7.5531,   8.5447,   39.5660,  8.65e-15,  8.89e-15,  8.45e-15,  nan ],
	[  6600,  101.1739,   3.4451,  92.4825,   3.7689,  45.8210,   7.6070,   8.1708,   42.6590,  7.22e-15,  7.57e-15,  7.65e-15,  nan ],
	[  6700,  100.8701,   3.5610,  92.6737,   3.8760,  46.0465,   7.8008,   8.4464,   42.5270,  8.01e-15,  9.00e-15,  9.09e-15,  nan ],
	[  6800,  100.8185,   3.6700,  92.0844,   4.0181,  46.2384,   8.0020,   8.4518,   43.7779,  9.13e-15,  8.55e-15,  8.76e-15,  nan ],
	[  6900,  101.6718,   3.7470,  93.1433,   4.0901,  47.3950,   8.0380,   8.2127,   46.3870,  8.09e-15,  8.61e-15,  7.92e-15,  nan ],
	[  7000,  101.7396,   3.8538,  92.6020,   4.2341,  47.8559,   8.1930,   8.3000,   47.2391,  7.82e-15,  7.37e-15,  7.80e-15,  nan ],
	[  7100,  100.5908,   4.0100,  92.9631,   4.3390,  48.2321,   8.3630,   8.2241,   49.0470,  8.14e-15,  8.94e-15,  7.90e-15,  nan ],
	[  7200,  102.6748,   4.0400,  92.3621,   4.4911,  44.0384,   9.4192,   8.3794,   49.5028,  7.41e-15,  8.43e-15,  7.95e-15,  nan ],
	[  7300,  103.5481,   4.1180,  93.5106,   4.5600,  45.1557,   9.4430,   7.8723,   54.1658,  7.77e-15,  7.85e-15,  7.61e-15,  nan ],
	[  7400,  103.5855,   4.2300,  92.8751,   4.7178,  44.9871,   9.7399,   8.0235,   54.6110,  7.64e-15,  7.63e-15,  7.41e-15,  nan ],
	[  7500,  104.7447,   4.2970,  93.0875,   4.8351,  44.9330,  10.0169,   8.0909,   55.6290,  8.62e-15,  8.71e-15,  8.97e-15,  nan ],
	[  7600,  105.2096,   4.3929,  93.0488,   4.9670,  45.5739,  10.1411,   8.1013,   57.0488,  7.76e-15,  8.67e-15,  7.84e-15,  nan ],
	[  7700,  103.5130,   4.5831,  92.9306,   5.1050,  46.4924,  10.2041,   7.9385,   59.7610,  9.77e-15,  1.01e-14,  1.06e-14,  nan ],
	[  7800,  102.8119,   4.7350,  93.2434,   5.2209,  47.0710,  10.3421,   7.4230,   65.5820,  8.48e-15,  8.56e-15,  8.45e-15,  nan ],
	[  7900,  103.3468,   4.8320,  92.9415,   5.3730,  47.4058,  10.5340,   7.6943,   64.9021,  8.30e-15,  9.71e-15,  9.28e-15,  nan ],
	[  8000,  103.8981,   4.9288,  93.4148,   5.4820,  47.4734,  10.7870,   7.5299,   68.0079,  8.46e-15,  9.30e-15,  9.18e-15,  nan ],
	[  8100,  105.2037,   4.9901,  93.6307,   5.6069,  48.7991,  10.7579,   7.5352,   69.6700,  8.61e-15,  8.64e-15,  8.84e-15,  nan ],
	[  8200,  105.0613,   5.1210,  93.2253,   5.7712,  44.0891,  12.2030,   7.3522,   73.1781,  8.71e-15,  8.97e-15,  9.19e-15,  nan ],
	[  8300,  105.4159,   5.2290,  93.4097,   5.9011,  44.0101,  12.5248,   7.2936,   75.5761,  1.17e-14,  9.67e-15,  9.57e-15,  nan ],
	[  8400,  104.9563,   5.3792,  93.4906,   6.0389,  45.1844,  12.4950,   7.6251,   74.0421,  8.88e-15,  9.15e-15,  9.60e-15,  nan ],
	[  8500,  106.2316,   5.4419,  93.9856,   6.1510,  46.3293,  12.4781,   7.5885,   76.1809,  8.81e-15,  8.94e-15,  9.20e-15,  nan ],
	[  8600,  105.6940,   5.5990,  93.0888,   6.3572,  46.4503,  12.7401,   7.5041,   78.8610,  9.75e-15,  8.71e-15,  8.47e-15,  nan ],
	[  8700,  104.6890,   5.7850,  94.1153,   6.4349,  46.6549,  12.9809,   7.5398,   80.3242,  1.13e-14,  1.08e-14,  1.11e-14,  nan ],
	[  8800,  105.9910,   5.8460,  93.0504,   6.6590,  46.7251,  13.2611,   7.9902,   77.5480,  1.13e-14,  1.15e-14,  1.23e-14,  nan ],
	[  8900,  106.0730,   5.9750,  93.7439,   6.7608,  47.3292,  13.3910,   8.1088,   78.1600,  1.01e-14,  1.07e-14,  1.08e-14,  nan ],
	[  9000,  106.9842,   6.0580,  93.9407,   6.8991,  48.0369,  13.4919,   7.9592,   81.4290,  1.03e-14,  1.01e-14,  1.06e-14,  nan ],
	[ 10000,  107.9048,   7.4151,  94.7767,   8.4422,  47.6799,  16.7811,   8.3239,   96.1230,  1.04e-14,  1.00e-14,  9.42e-15,  nan ],
	[ 12000,  111.0268,  10.3772,  93.7083,  12.2950,  48.1146,  23.9458,   8.3559,  137.8839,  1.17e-14,  1.09e-14,  1.18e-14,  nan ],
	[ 14000,  110.4031,  14.2040,  94.2236,  16.6430,  47.8462,  32.7752,   8.4701,  185.1411,  1.12e-14,  1.11e-14,  1.25e-14,  nan ],
	[ 16000,  108.1984,  18.9300,  94.0359,  21.7810,  47.0870,  43.4980,   8.5963,  238.2650,  1.50e-14,  1.39e-14,  1.39e-14,  nan ],
	[ 18000,  109.7560,  23.6180,  95.2462,  27.2160,  47.1499,  54.9781,   8.7234,  297.1561,  1.40e-14,  1.48e-14,  1.46e-14,  nan ],
	[ 20000,  107.8074,  29.6848,  94.2075,  33.9701,  46.9961,  68.0959,   8.2953,  385.7899,  1.77e-14,  1.88e-14,  1.88e-14,  nan ],
])

# ------------------------------------------------------------
# file: v1.6.1/cuda7.0-k40c/zpotrf.txt
# numactl --interleave=all ./testing_zpotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zpotrf = array([
	[    10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,  nan,  nan,     0.04,  0.00,  nan ],
	[    30,  nan,  nan,     0.12,  0.00,  nan ],
	[    40,  nan,  nan,     1.33,  0.00,  nan ],
	[    50,  nan,  nan,     2.18,  0.00,  nan ],
	[    60,  nan,  nan,     2.99,  0.00,  nan ],
	[    70,  nan,  nan,     1.19,  0.00,  nan ],
	[    80,  nan,  nan,     1.63,  0.00,  nan ],
	[    90,  nan,  nan,     2.09,  0.00,  nan ],
	[   100,  nan,  nan,     2.61,  0.00,  nan ],
	[   200,  nan,  nan,    14.08,  0.00,  nan ],
	[   300,  nan,  nan,    13.48,  0.00,  nan ],
	[   400,  nan,  nan,    27.34,  0.00,  nan ],
	[   500,  nan,  nan,    44.14,  0.00,  nan ],
	[   600,  nan,  nan,    53.18,  0.01,  nan ],
	[   700,  nan,  nan,    73.23,  0.01,  nan ],
	[   800,  nan,  nan,    79.44,  0.01,  nan ],
	[   900,  nan,  nan,   107.34,  0.01,  nan ],
	[  1000,  nan,  nan,   130.32,  0.01,  nan ],
	[  2000,  nan,  nan,   373.50,  0.03,  nan ],
	[  3000,  nan,  nan,   553.62,  0.07,  nan ],
	[  4000,  nan,  nan,   679.90,  0.13,  nan ],
	[  5000,  nan,  nan,   761.87,  0.22,  nan ],
	[  6000,  nan,  nan,   829.55,  0.35,  nan ],
	[  7000,  nan,  nan,   879.78,  0.52,  nan ],
	[  8000,  nan,  nan,   923.14,  0.74,  nan ],
	[  9000,  nan,  nan,   953.24,  1.02,  nan ],
	[ 10000,  nan,  nan,   981.67,  1.36,  nan ],
	[ 12000,  nan,  nan,  1029.55,  2.24,  nan ],
	[ 14000,  nan,  nan,  1062.63,  3.44,  nan ],
	[ 16000,  nan,  nan,  1088.09,  5.02,  nan ],
	[ 18000,  nan,  nan,  1104.05,  7.04,  nan ],
	[ 20000,  nan,  nan,  1113.50,  9.58,  nan ],
])

# numactl --interleave=all ./testing_zpotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.04,  0.00,  nan ],
	[    40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,  nan,  nan,     0.19,  0.00,  nan ],
	[    60,  nan,  nan,     0.32,  0.00,  nan ],
	[    70,  nan,  nan,     0.48,  0.00,  nan ],
	[    80,  nan,  nan,     0.70,  0.00,  nan ],
	[    90,  nan,  nan,     0.93,  0.00,  nan ],
	[   100,  nan,  nan,     1.21,  0.00,  nan ],
	[   200,  nan,  nan,     7.38,  0.00,  nan ],
	[   300,  nan,  nan,    11.55,  0.00,  nan ],
	[   400,  nan,  nan,    25.28,  0.00,  nan ],
	[   500,  nan,  nan,    42.68,  0.00,  nan ],
	[   600,  nan,  nan,    54.18,  0.01,  nan ],
	[   700,  nan,  nan,    77.27,  0.01,  nan ],
	[   800,  nan,  nan,    84.58,  0.01,  nan ],
	[   900,  nan,  nan,   111.70,  0.01,  nan ],
	[  1000,  nan,  nan,   143.75,  0.01,  nan ],
	[  2000,  nan,  nan,   441.50,  0.02,  nan ],
	[  3000,  nan,  nan,   644.39,  0.06,  nan ],
	[  4000,  nan,  nan,   779.69,  0.11,  nan ],
	[  5000,  nan,  nan,   862.11,  0.19,  nan ],
	[  6000,  nan,  nan,   917.14,  0.31,  nan ],
	[  7000,  nan,  nan,   970.62,  0.47,  nan ],
	[  8000,  nan,  nan,  1008.54,  0.68,  nan ],
	[  9000,  nan,  nan,  1029.56,  0.94,  nan ],
	[ 10000,  nan,  nan,  1052.90,  1.27,  nan ],
	[ 12000,  nan,  nan,  1095.40,  2.10,  nan ],
	[ 14000,  nan,  nan,  1117.90,  3.27,  nan ],
	[ 16000,  nan,  nan,  1139.32,  4.79,  nan ],
	[ 18000,  nan,  nan,  1148.96,  6.77,  nan ],
	[ 20000,  nan,  nan,  1150.85,  9.27,  nan ],
])

