---
layout: documentation
current_menu: v7
---

# Migrating from PHP-DI 6.x to 7.0

PHP-DI 7.0 is a new major version that comes with backward compatibility breaks.

This guide will help you migrate from a 6.x version to 7.0. It will only explain backward compatibility breaks, it will not present the new features (read the release notes or the blog post for that).

## PHP version

PHP-DI now requires PHP 8.0 or greater. If you are using an older version, you can of course still use PHP-DI 6.

## Container creation

The container can now be created with sane defaults without using the `ContainerBuilder` class (though it's not mandatory):

```php
$container = new \DI\Container();

// With definitions:
$container = new \DI\Container([
    \Psr\Log\LoggerInterface::class => get(MyLogger::class),
]);
```

Related to that: `\DI\ContainerBuilder::buildDevContainer()` method is now obsolete and has been removed. Replace it with:

```diff
- $container = \DI\ContainerBuilder::buildDevContainer();
+ $container = new \DI\Container();
```

## Annotations (`@Inject`) have been replaced by PHP attributes (`#[Inject]`)

Now that PHP 8.0 and up [supports attributes natively](https://www.php.net/manual/fr/language.attributes.overview.php), these are read instead of phpdoc annotations.

Additionally, now that PHP supports typed properties, PHP-DI will stop reading types from phpdoc.

Here is an example on how to migrate from PHP-DI 6 to PHP-DI 7:

- **before:**

```php
// Container configuration
$containerBuilder = new \DI\ContainerBuilder;
$containerBuilder->useAnnotations(true);
```

```php
class Example
{
    /**
     * @Inject
     * @var Foo
     */
    private $property;

    /**
     * @Inject
     * @param Foo $param
     */
    public function method($param)
    {
    }
}
```

- **after:**

```php
// Container configuration
$containerBuilder = new \DI\ContainerBuilder;
$containerBuilder->useAttributes(true);
```

```php
use DI\Attribute\Inject;

class Example
{
    #[Inject]
    private Foo $property;

    #[Inject]
    public function method(Foo $param)
    {
    }
}
```
*Note: remember to import the attribute class via `use DI\Attribute\Inject;`.*

Read more about attributes in the PHP-DI documentation: [PHP-DI attributes](../attributes.md).

## Internal changes

If you were overriding or extending some internal classes of PHP-DI, be aware that they may have changed.
