/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Vector;

public class InOut {
    public InputStream In;
    public OutputStream Out;
    static final Boolean T = new Boolean(Boolean.TRUE);
    static final Boolean Nil = new Boolean(Boolean.FALSE);
    static final HashMap<Integer, Object> Obj = new HashMap();
    private int InCount;
    private boolean InMore;
    static final int NIX = 0;
    static final int BEG = 1;
    static final int DOT = 2;
    static final int END = 3;
    static final int NUMBER = 0;
    static final int INTERN = 1;
    static final int TRANSIENT = 2;
    static final int EXTERN = 3;

    public InOut(InputStream inputStream, OutputStream outputStream) {
        this.In = inputStream;
        this.Out = new BufferedOutputStream(outputStream);
    }

    public void close() throws IOException {
        this.In.close();
        this.Out.close();
    }

    public void flush() throws IOException {
        this.Out.flush();
    }

    private void outBytes(int n, byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = byArray.length;
        if (n3 < 63) {
            this.Out.write(n3 * 4 | n);
            do {
                this.Out.write(byArray[n2++]);
            } while (--n3 > 0);
        } else {
            int n4;
            this.Out.write(0xFC | n);
            for (n4 = 0; n4 < 63; ++n4) {
                this.Out.write(byArray[n2++]);
            }
            n3 -= 63;
            while (n3 >= 255) {
                this.Out.write(255);
                for (n4 = 0; n4 < 255; ++n4) {
                    this.Out.write(byArray[n2++]);
                }
                n3 -= 255;
            }
            this.Out.write(n3);
            while (--n3 >= 0) {
                this.Out.write(byArray[n2++]);
            }
        }
    }

    private void prNum(int n, long l) throws IOException {
        long l2 = l;
        int n2 = 1;
        while ((l2 >>>= 8) != 0L) {
            ++n2;
        }
        this.Out.write(n2 * 4 + n);
        do {
            this.Out.write((byte)l);
            l >>>= 8;
        } while (--n2 != 0);
    }

    public static int utfLength(String string) {
        int n = 0;
        int n2 = string.length();
        while (--n2 >= 0) {
            if (string.charAt(n2) < '\u0080') {
                ++n;
                continue;
            }
            if (string.charAt(n2) < '\u0800') {
                n += 2;
                continue;
            }
            n += 3;
        }
        return n;
    }

    public void prSym(String string) throws IOException {
        this.print(1, string);
    }

    public void print(String string) throws IOException {
        this.print(2, string);
    }

    public void print(int n, String string) throws IOException {
        if (string.length() == 0) {
            this.Out.write(0);
        } else {
            byte[] byArray = new byte[InOut.utfLength(string)];
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c < '\u0080') {
                    byArray[n2++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    byArray[n2++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    byArray[n2++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                byArray[n2++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
            }
            this.outBytes(n, byArray);
        }
    }

    public void print(long l) throws IOException {
        this.prNum(0, l >= 0L ? l * 2L : -l * 2L + 1L);
    }

    public void print(BigInteger bigInteger) throws IOException {
        boolean bl = bigInteger.signum() < 0;
        if (bl) {
            bigInteger = bigInteger.abs();
        }
        int n = 0;
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        while (true) {
            byArray2[--n2] = (byte)(byArray[n++] << 1);
            if (n2 == 0) break;
            if ((byArray[n] & 0x80) == 0) continue;
            int n3 = n2;
            byArray2[n3] = (byte)(byArray2[n3] | 1);
        }
        if (bl) {
            byArray2[0] = (byte)(byArray2[0] | 1);
        }
        this.outBytes(0, byArray2);
    }

    public void print(Object object) throws IOException {
        if (object == null) {
            this.Out.write(0);
        } else if (object instanceof String) {
            this.print((String)object);
        } else if (object instanceof Symbol) {
            this.prSym(((Symbol)object).Name);
        } else if (object instanceof BigInteger) {
            this.print((BigInteger)object);
        } else if (object instanceof Double) {
            this.print((long)((Double)object * 1000000.0));
        } else if (object instanceof Long) {
            this.print((Long)object);
        } else if (object instanceof Number) {
            this.print(((Number)object).intValue());
        } else if (object instanceof Character) {
            this.print(((Character)object).charValue());
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                this.prSym("T");
            } else {
                this.Out.write(0);
            }
        } else if (object instanceof int[]) {
            if (((int[])object).length == 0) {
                this.Out.write(0);
            } else {
                this.Out.write(1);
                for (int i = 0; i < ((int[])object).length; ++i) {
                    this.print(((int[])object)[i]);
                }
                this.Out.write(3);
            }
        } else if (object instanceof byte[]) {
            if (((byte[])object).length == 0) {
                this.Out.write(0);
            } else {
                this.Out.write(1);
                for (int i = 0; i < ((byte[])object).length; ++i) {
                    this.print(((byte[])object)[i]);
                }
                this.Out.write(3);
            }
        } else if (object instanceof double[]) {
            if (((double[])object).length == 0) {
                this.Out.write(0);
            } else {
                this.Out.write(1);
                for (int i = 0; i < ((double[])object).length; ++i) {
                    this.print(((double[])object)[i]);
                }
                this.Out.write(3);
            }
        } else if (object instanceof Object[]) {
            if (((Object[])object).length == 0) {
                this.Out.write(0);
            } else {
                this.Out.write(1);
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    this.print(((Object[])object)[i]);
                }
                this.Out.write(3);
            }
        } else {
            int n = object.hashCode();
            Obj.put(n, object);
            this.prNum(3, (long)n & 0xFFFFFL | (long)(n & 0xFFF00000) << 8);
        }
    }

    private int inByte1() throws IOException {
        int n = this.In.read();
        if (n < 0) {
            return -1;
        }
        this.InCount = n / 4 - 1;
        this.InMore = this.InCount == 62;
        return n;
    }

    private int inByte() throws IOException {
        if (this.InCount == 0) {
            if (!this.InMore || (this.InCount = this.In.read()) <= 0) {
                return -1;
            }
            this.InMore = this.InCount == 255;
        }
        --this.InCount;
        return this.In.read();
    }

    private String getStr() throws IOException {
        int n = this.In.read();
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((n & 0x80) != 0) {
                n = (n & 0x20) == 0 ? (n &= 0x1F) : (n & 0xF) << 6 | this.inByte() & 0x3F;
                n = n << 6 | this.inByte() & 0x3F;
            }
            stringBuffer.append((char)n);
        } while ((n = this.inByte()) >= 0);
        return stringBuffer.toString();
    }

    private BigInteger getBig() throws IOException {
        byte[] byArray;
        int n = this.In.read();
        boolean bl = (n & 1) != 0;
        int n2 = 63;
        byte[] byArray2 = new byte[63];
        while (true) {
            byArray2[--n2] = (byte)(n >> 1 & 0x7F);
            n = this.inByte();
            if (n < 0) break;
            if ((n & 1) != 0) {
                int n3 = n2;
                byArray2[n3] = (byte)(byArray2[n3] | 0x80);
            }
            if (n2 != 0) continue;
            byArray = new byte[byArray2.length + 255];
            System.arraycopy(byArray2, 0, byArray, 255, byArray2.length);
            byArray2 = byArray;
            n2 = 255;
        }
        if (n2 == 0) {
            byArray = byArray2;
        } else {
            byArray = new byte[byArray2.length - n2];
            System.arraycopy(byArray2, n2, byArray, 0, byArray.length);
        }
        return bl ? new BigInteger(-1, byArray) : new BigInteger(byArray);
    }

    public int rdNum() throws IOException {
        int n = this.inByte1();
        if (n < 0) {
            throw new EOFException();
        }
        if (n <= 3 || (n & 3) != 0) {
            throw new IOException("Number expected");
        }
        int n2 = 0;
        n = this.In.read();
        while (--this.InCount >= 0) {
            n |= this.In.read() << (n2 += 8);
        }
        n2 = n & 1;
        return n2 == 0 ? n : -(n >>>= 1);
    }

    public String rdStr() throws IOException {
        int n = this.inByte1();
        if (n < 0) {
            throw new EOFException();
        }
        if (n == 0) {
            return "";
        }
        if (n <= 3) {
            throw new IOException("String expected");
        }
        if ((n & 3) == 0) {
            return this.getBig().toString();
        }
        return this.getStr();
    }

    public BigInteger rdBig() throws IOException {
        int n = this.inByte1();
        if (n < 0) {
            throw new EOFException();
        }
        if (n <= 3 || (n & 3) != 0) {
            throw new IOException("Number expected");
        }
        return this.getBig();
    }

    private Object read1(int n) throws IOException {
        if ((n & 0xFFFFFFFC) != 0) {
            if ((n & 3) == 0) {
                BigInteger bigInteger = this.getBig();
                if (bigInteger.bitLength() < 32) {
                    return new Integer(bigInteger.intValue());
                }
                return bigInteger;
            }
            if ((n & 3) == 3) {
                int n2 = 0;
                long l = this.In.read();
                while (--this.InCount >= 0) {
                    l |= (long)this.In.read() << (n2 += 8);
                }
                return Obj.get((int)l & 0xFFFFF | (int)(l >> 8 & 0xFFFFFFFFFFF00000L));
            }
            String string = this.getStr();
            if ((n & 3) == 1) {
                if (string.equals("T")) {
                    return T;
                }
                return new Symbol(string);
            }
            return string;
        }
        if (n == 0) {
            return Nil;
        }
        if (n != 1) {
            return null;
        }
        Object object = this.read();
        n = this.inByte1();
        if (n == 2) {
            int n3 = (Integer)object;
            if (n3 <= 0) {
                double d = this.rdBig().doubleValue();
                while (++n3 <= 0) {
                    d /= 10.0;
                }
                return new Double(d);
            }
            switch (n3) {
                case 1: {
                    return new Byte((byte)this.rdNum());
                }
                case 2: {
                    return new Character((char)this.rdNum());
                }
                case 3: {
                    return new Short((short)this.rdNum());
                }
                case 4: {
                    return this.rdNum();
                }
                case 8: {
                    return new Long(this.rdBig().longValue());
                }
                case 9: {
                    return this.rdBig();
                }
            }
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        while (n != 3) {
            vector.addElement(this.read1(n));
            n = this.inByte1();
            if (n != 2) continue;
            return null;
        }
        int n4 = 0;
        if (object instanceof Integer) {
            do {
                if (++n4 != vector.size()) continue;
                int[] nArray = new int[vector.size()];
                while (--n4 >= 0) {
                    Array.setInt(nArray, n4, (Integer)vector.get(n4));
                }
                return nArray;
            } while (vector.get(n4) instanceof Integer);
        }
        if (object instanceof String) {
            do {
                if (++n4 != vector.size()) continue;
                String[] stringArray = new String[vector.size()];
                while (--n4 >= 0) {
                    stringArray[n4] = (String)vector.get(n4);
                }
                return stringArray;
            } while (vector.get(n4) instanceof String);
        } else if (object instanceof Byte) {
            do {
                if (++n4 != vector.size()) continue;
                byte[] byArray = new byte[vector.size()];
                while (--n4 >= 0) {
                    Array.setByte(byArray, n4, (Byte)vector.get(n4));
                }
                return byArray;
            } while (vector.get(n4) instanceof Byte);
        } else if (object instanceof Double) {
            do {
                if (++n4 != vector.size()) continue;
                double[] dArray = new double[vector.size()];
                while (--n4 >= 0) {
                    Array.setDouble(dArray, n4, (Double)vector.get(n4));
                }
                return dArray;
            } while (vector.get(n4) instanceof Double);
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object read() throws IOException {
        int n = this.inByte1();
        if (n < 0) {
            throw new EOFException();
        }
        return this.read1(n);
    }
}

