# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessRights(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessRights."""

    MANAGE = "Manage"
    SEND = "Send"
    LISTEN = "Listen"


class EntityStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumerates the possible values for the status of the Event Hub."""

    ACTIVE = "Active"
    DISABLED = "Disabled"
    RESTORING = "Restoring"
    SEND_DISABLED = "SendDisabled"
    RECEIVE_DISABLED = "ReceiveDisabled"
    CREATING = "Creating"
    DELETING = "Deleting"
    RENAMING = "Renaming"
    UNKNOWN = "Unknown"


class NamespaceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the Namespace."""

    UNKNOWN = "Unknown"
    CREATING = "Creating"
    CREATED = "Created"
    ACTIVATING = "Activating"
    ENABLING = "Enabling"
    ACTIVE = "Active"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    SOFT_DELETING = "SoftDeleting"
    SOFT_DELETED = "SoftDeleted"
    REMOVING = "Removing"
    REMOVED = "Removed"
    FAILED = "Failed"


class Policykey(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Key that needs to be regenerated."""

    PRIMARY_KEY = "PrimaryKey"
    SECONDARY_KEY = "SecondaryKey"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of this SKU."""

    BASIC = "Basic"
    STANDARD = "Standard"


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The billing tier of this particular SKU."""

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class UnavailableReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the reason for the unavailability of the service."""

    NONE = "None"
    INVALID_NAME = "InvalidName"
    SUBSCRIPTION_IS_DISABLED = "SubscriptionIsDisabled"
    NAME_IN_USE = "NameInUse"
    NAME_IN_LOCKDOWN = "NameInLockdown"
    TOO_MANY_NAMESPACE_IN_CURRENT_SUBSCRIPTION = "TooManyNamespaceInCurrentSubscription"
