# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource import ResourcePrivateLinkClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestResourcePrivateLinkResourceManagementPrivateLinkOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ResourcePrivateLinkClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_management_private_link_put(self, resource_group):
        response = self.client.resource_management_private_link.put(
            resource_group_name=resource_group.name,
            rmpl_name="str",
            parameters={"location": "str"},
            api_version="2020-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_management_private_link_get(self, resource_group):
        response = self.client.resource_management_private_link.get(
            resource_group_name=resource_group.name,
            rmpl_name="str",
            api_version="2020-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_management_private_link_delete(self, resource_group):
        response = self.client.resource_management_private_link.delete(
            resource_group_name=resource_group.name,
            rmpl_name="str",
            api_version="2020-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_management_private_link_list(self, resource_group):
        response = self.client.resource_management_private_link.list(
            api_version="2020-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_management_private_link_list_by_resource_group(self, resource_group):
        response = self.client.resource_management_private_link.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2020-05-01",
        )

        # please add some check logic here by yourself
        # ...
