# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement.aio import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementWorkspaceSubscriptionOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_subscription_list(self, resource_group):
        response = self.client.workspace_subscription.list(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_subscription_get_entity_tag(self, resource_group):
        response = await self.client.workspace_subscription.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_subscription_get(self, resource_group):
        response = await self.client.workspace_subscription.get(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_subscription_create_or_update(self, resource_group):
        response = await self.client.workspace_subscription.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            sid="str",
            parameters={
                "allowTracing": bool,
                "displayName": "str",
                "ownerId": "str",
                "primaryKey": "str",
                "scope": "str",
                "secondaryKey": "str",
                "state": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_subscription_update(self, resource_group):
        response = await self.client.workspace_subscription.update(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            sid="str",
            if_match="str",
            parameters={
                "allowTracing": bool,
                "displayName": "str",
                "expirationDate": "2020-02-20 00:00:00",
                "ownerId": "str",
                "primaryKey": "str",
                "scope": "str",
                "secondaryKey": "str",
                "state": "str",
                "stateComment": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_subscription_delete(self, resource_group):
        response = await self.client.workspace_subscription.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            sid="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_subscription_regenerate_primary_key(self, resource_group):
        response = await self.client.workspace_subscription.regenerate_primary_key(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_subscription_regenerate_secondary_key(self, resource_group):
        response = await self.client.workspace_subscription.regenerate_secondary_key(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_subscription_list_secrets(self, resource_group):
        response = await self.client.workspace_subscription.list_secrets(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            sid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
