% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-dataset-converters.R
\name{rename_net}
\alias{rename_net}
\title{Rename network}
\usage{
rename_net(
  network,
  .source,
  .target,
  .mor = NULL,
  .likelihood = NULL,
  def_mor = 1
)
}
\arguments{
\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{.mor}{Column with edge mode of regulation (i.e. mor).}

\item{.likelihood}{Deprecated argument. Now it will always be set to 1.}

\item{def_mor}{Default value for .mor when not provided.}
}
\description{
Renames a given network to these column names: .source, .target, .mor, If
.mor is not provided, then the function sets them to default values.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")
mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))
rename_net(net, source, target, mor)
}
