% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OverlayTrack-class.R
\docType{class}
\name{OverlayTrack-class}
\alias{OverlayTrack-class}
\alias{initialize,OverlayTrack-method}
\alias{OverlayTrack}
\alias{displayPars<-,OverlayTrack,list-method}
\alias{length,OverlayTrack-method}
\alias{chromosome,OverlayTrack-method}
\alias{chromosome<-,OverlayTrack-method}
\alias{setStacks,OverlayTrack-method}
\alias{consolidateTrack,OverlayTrack-method}
\alias{subset,OverlayTrack-method}
\alias{drawGD,OverlayTrack-method}
\alias{show,OverlayTrack-method}
\title{OverlayTrack class and methods}
\usage{
\S4method{initialize}{OverlayTrack}(.Object, trackList, ...)

OverlayTrack(trackList = list(), name = "OverlayTrack", ...)

\S4method{displayPars}{OverlayTrack,list}(x, recursive = FALSE) <- value

\S4method{length}{OverlayTrack}(x)

\S4method{chromosome}{OverlayTrack}(GdObject)

\S4method{chromosome}{OverlayTrack}(GdObject) <- value

\S4method{setStacks}{OverlayTrack}(GdObject, ...)

\S4method{consolidateTrack}{OverlayTrack}(GdObject, chromosome, ...)

\S4method{subset}{OverlayTrack}(x, ...)

\S4method{drawGD}{OverlayTrack}(GdObject, ...)

\S4method{show}{OverlayTrack}(object)
}
\arguments{
\item{trackList}{A list of Gviz track objects that all have to inherit from
class \code{GdObject}.}

\item{\dots}{All additional parameters are ignored.}

\item{name}{Character scalar of the track's name. This is not really used
and only exists fro completeness.}
}
\value{
The return value of the constructor function is a new object of class
\code{OverlayTrack}.
}
\description{
A container for other track objects from the Gviz package that allows for
overlays of their content on the same region of the plot.
}
\details{
A track to conceptionally group other Gviz track objects into a meta track
in order to merge them into a single overlay visualization. Only the first
track in the supplied list will be inferred when setting up the track title
and axis, for all the other tracks only the panel content is plotted.
}
\section{Functions}{
\itemize{
\item \code{initialize(OverlayTrack)}: Initialize.

\item \code{OverlayTrack()}: Constructor function for \code{OverlayTrack-class}.

\item \code{displayPars(x = OverlayTrack) <- value}: set display parameters using the values of
the named list in value. See \code{\link{settings}} for details on
display parameters and customization.

\item \code{length(OverlayTrack)}: return the number of subtracks.

\item \code{chromosome(OverlayTrack)}: return the chromosome for which the track
is defined.

\item \code{chromosome(OverlayTrack) <- value}: replace the value of the track's chromosome.
This has to be a valid UCSC chromosome identifier or an integer or character
scalar that can be reasonably coerced into one.

\item \code{setStacks(OverlayTrack)}: recompute the stacks based on the available
space and on the object's track items and stacking settings.
This really just calls the setStacks methods for the contained
tracks and only exists for dispatching reasons.

\item \code{consolidateTrack(OverlayTrack)}: #' For a \code{OverlayTrack} apply the method on
each of the subtracks in the \code{trackList} slot

\item \code{subset(OverlayTrack)}: plot subset all the contained tracks in an
\code{OverlayTrack} by coordinates and sort if necessary.

\item \code{drawGD(OverlayTrack)}: plot the object to a graphics device.
The return value of this method is the input object, potentially updated
during the plotting operation. Internally, there are two modes in which the
method can be called. Either in 'prepare' mode, in which case no plotting is
done but the object is preprocessed based on the available space, or in
'plotting' mode, in which case the actual graphical output is created.
Since subsetting of the object can be potentially costly, this can be
switched off in case subsetting has already been performed before or
is not necessary.

\item \code{show(OverlayTrack)}: Show method.

}}
\section{Objects from the Class}{


Objects can be created using the constructor function \code{OverlayTrack}.
}

\examples{


## Object construction:
set.seed(123)
dat <- runif(100, min = -2, max = 22)
dt1 <- DataTrack(data = dat, start = sort(sample(200, 100)), width = 1, genome = "hg19")
dt2 <- DataTrack(data = dat, start = sort(sample(200, 100)), width = 1, genome = "hg19")
ot <- OverlayTrack(trackList = list(dt1, dt2))
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
\keyword{internal}
