% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchSummary.R
\name{fetchSummary}
\alias{fetchSummary}
\title{Fetch version summary}
\usage{
fetchSummary(
  project,
  asset,
  version,
  cache = cacheDirectory(),
  overwrite = FALSE,
  url = restUrl(),
  config = NULL
)
}
\arguments{
\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.}

\item{version}{String containing the version name.}

\item{cache}{String containing the cache directory.
If \code{NULL}, no caching is performed.}

\item{overwrite}{Logical scalar indicating whether to overwrite an existing file in \code{cache}, if one is present.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{config}{Deprecated and ignored.}
}
\value{
List containing the summary for this version, with the following fields:
\itemize{
\item \code{upload_user_id}, string containing the identity of the uploader.
\item \code{upload_start}, a \link{POSIXct} object containing the upload start time.
\item \code{upload_finish}, a \link{POSIXct} object containing the upload finish time.
\item \code{on_probation} (optional), a logical scalar indicating whether the upload is probational.
If missing, this can be assumed to be \code{FALSE}.
}
}
\description{
Fetch the summary for a version of an asset of a project.
}
\examples{
fetchSummary("test-R", "basic", "v1")

}
\author{
Aaron Lun
}
