% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PaulHSCData.R
\name{PaulHSCData}
\alias{PaulHSCData}
\title{Obtain the Paul HSC data}
\usage{
PaulHSCData(
  ensembl = FALSE,
  discard.multiple = TRUE,
  location = TRUE,
  legacy = FALSE
)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{discard.multiple}{Logical scalar indicating whether ambiguous rows should be discarded.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the mouse haematopoietic stem cell single-cell RNA-seq data from Paul et al. (2015).
}
\details{
Column metadata includes the plate and the mouse of origin, fluoresence intensities from indexed sorting 
and the number of cells in each well.

Some of the original rownames are concatenated symbols from multiple genes.
We consider these rows to represent ambiguously assigned counts and discard them if \code{discard.multiple=TRUE}.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/nestorowa-hsc}.
}
\examples{
sce <- PaulHSCData()

}
\references{
Paul F et al. (2015). 
Transcriptional heterogeneity and lineage commitment in myeloid progenitors. 
\emph{Cell} 163, 1663-77.
}
\author{
Aaron Lun
}
