% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict.brmsfit}
\alias{posterior_predict.brmsfit}
\alias{posterior_predict}
\title{Draws from the Posterior Predictive Distribution}
\usage{
\method{posterior_predict}{brmsfit}(
  object,
  newdata = NULL,
  re_formula = NULL,
  re.form = NULL,
  transform = NULL,
  resp = NULL,
  negative_rt = FALSE,
  ndraws = NULL,
  draw_ids = NULL,
  sort = FALSE,
  ntrys = 5,
  cores = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{re.form}{Alias of \code{re_formula}.}

\item{transform}{(Deprecated) A function or a character string naming 
a function to be applied on the predicted responses
before summary statistics are computed.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{negative_rt}{Only relevant for Wiener diffusion models. 
A flag indicating whether response times of responses
on the lower boundary should be returned as negative values.
This allows to distinguish responses on the upper and
lower boundary. Defaults to \code{FALSE}.}

\item{ndraws}{Positive integer indicating how many posterior draws should
be used. If \code{NULL} (the default) all draws are used. Ignored if
\code{draw_ids} is not \code{NULL}.}

\item{draw_ids}{An integer vector specifying the posterior draws to be used.
If \code{NULL} (the default), all draws are used.}

\item{sort}{Logical. Only relevant for time series models. 
Indicating whether to return predicted values in the original 
order (\code{FALSE}; default) or in the order of the 
time series (\code{TRUE}).}

\item{ntrys}{Parameter used in rejection sampling 
for truncated discrete models only 
(defaults to \code{5}). See Details for more information.}

\item{cores}{Number of cores (defaults to \code{1}). On non-Windows systems,
this argument can be set globally via the \code{mc.cores} option.}

\item{...}{Further arguments passed to \code{\link{prepare_predictions}}
that control several aspects of data validation and prediction.}
}
\value{
An \code{array} of predicted response values. In univariate models,
  the output is as an S x N matrix, where S is the number of posterior
  draws and N is the number of observations. In multivariate models, an
  additional dimension is added to the output which indexes along the
  different response variables.
}
\description{
Compute posterior draws of the posterior predictive distribution. Can be
performed for the data used to fit the model (posterior predictive checks) or
for new data. By definition, these draws have higher variance than draws
of the means of the posterior predictive distribution computed by
\code{\link{posterior_epred.brmsfit}}. This is because the residual error
is incorporated in \code{posterior_predict}. However, the estimated means of
both methods averaged across draws should be very similar.
}
\details{
\code{NA} values within factors in \code{newdata}, 
  are interpreted as if all dummy variables of this factor are 
  zero. This allows, for instance, to make predictions of the grand mean 
  when using sum coding.

In multilevel models, it is possible to 
allow new levels of grouping factors to be used in the predictions.
This can be controlled via argument \code{allow_new_levels}.
New levels can be sampled in multiple ways, which can be controlled
via argument \code{sample_new_levels}. Both of these arguments are
documented in \code{\link{prepare_predictions}} along with several
other useful arguments to control specific aspects of the predictions.

For truncated discrete models only: In the absence of any general
  algorithm to sample from truncated discrete distributions, rejection
  sampling is applied in this special case. This means that values are
  sampled until a value lies within the defined truncation boundaries. In
  practice, this procedure may be rather slow (especially in \R). Thus, we
  try to do approximate rejection sampling by sampling each value
  \code{ntrys} times and then select a valid value. If all values are
  invalid, the closest boundary is used, instead. If there are more than a
  few of these pathological cases, a warning will occur suggesting to
  increase argument \code{ntrys}.
}
\examples{
\dontrun{
## fit a model
fit <- brm(time | cens(censored) ~ age + sex + (1 + age || patient), 
           data = kidney, family = "exponential", inits = "0")

## predicted responses
pp <- posterior_predict(fit)
str(pp)

## predicted responses excluding the group-level effect of age
pp <- posterior_predict(fit, re_formula = ~ (1 | patient))
str(pp)

## predicted responses of patient 1 for new data
newdata <- data.frame(
  sex = factor(c("male", "female")),
  age = c(20, 50),
  patient = c(1, 1)
)
pp <- posterior_predict(fit, newdata = newdata)
str(pp)
}

}
