% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_predictions.R
\name{prepare_predictions.brmsfit}
\alias{prepare_predictions.brmsfit}
\alias{prepare_predictions}
\alias{extract_draws}
\title{Prepare Predictions}
\usage{
\method{prepare_predictions}{brmsfit}(
  x,
  newdata = NULL,
  re_formula = NULL,
  allow_new_levels = FALSE,
  sample_new_levels = "uncertainty",
  incl_autocor = TRUE,
  oos = NULL,
  resp = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  nsamples = NULL,
  subset = NULL,
  nug = NULL,
  smooths_only = FALSE,
  offset = TRUE,
  newdata2 = NULL,
  new_objects = NULL,
  point_estimate = NULL,
  ndraws_point_estimate = 1,
  ...
)

prepare_predictions(x, ...)
}
\arguments{
\item{x}{An \R object typically of class \code{'brmsfit'}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used. \code{NA}
values within factors (excluding grouping variables) are interpreted as if
all dummy variables of this factor are zero. This allows, for instance, to
make predictions of the grand mean when using sum coding. \code{NA} values
within grouping variables are treated as a new level.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA} or \code{~0}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels for grouping
factors specified in \code{re_formula}. This argument is only relevant if
\code{newdata} is provided and \code{allow_new_levels} is set to
\code{TRUE}. If \code{"uncertainty"} (default), each posterior sample for a
new level is drawn from the posterior draws of a randomly chosen existing
level. Each posterior sample for a new level may be drawn from a different
existing level such that the resulting set of new posterior draws
represents the variation across existing levels. If \code{"gaussian"},
sample new levels from the (multivariate) normal distribution implied by the
group-level standard deviations and correlations. This options may be useful
for conducting Bayesian power analysis or predicting new levels in
situations where relatively few levels where observed in the old_data. If
\code{"old_levels"}, directly sample new levels from the existing levels,
where a new level is assigned all of the posterior draws of the same
(randomly chosen) existing level.}

\item{incl_autocor}{A flag indicating if correlation structures originally
specified via \code{autocor} should be included in the predictions.
Defaults to \code{TRUE}.}

\item{oos}{Optional indices of observations for which to compute
out-of-sample rather than in-sample predictions. Only required in models
that make use of response values to make predictions, that is, currently
only ARMA models.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{ndraws}{Positive integer indicating how many posterior draws should
be used. If \code{NULL} (the default) all draws are used. Ignored if
\code{draw_ids} is not \code{NULL}.}

\item{draw_ids}{An integer vector specifying the posterior draws to be used.
If \code{NULL} (the default), all draws are used.}

\item{nsamples}{Deprecated alias of \code{ndraws}.}

\item{subset}{Deprecated alias of \code{draw_ids}.}

\item{nug}{Small positive number for Gaussian process terms only. For
numerical reasons, the covariance matrix of a Gaussian process might not be
positive definite. Adding a very small number to the matrix's diagonal
often solves this problem. If \code{NULL} (the default), \code{nug} is
chosen internally.}

\item{smooths_only}{Logical; If \code{TRUE} only predictions related to
smoothing splines (i.e., \code{s} or \code{t2}) will be computed.
Defaults to \code{FALSE}.}

\item{offset}{Logical; Indicates if offsets should be included in the
predictions. Defaults to \code{TRUE}.}

\item{newdata2}{A named \code{list} of objects containing new data, which
cannot be passed via argument \code{newdata}. Required for some objects
used in autocorrelation structures, or \code{\link{stanvars}}.}

\item{new_objects}{Deprecated alias of \code{newdata2}.}

\item{point_estimate}{Shall the returned object contain only point estimates
of the parameters instead of their posterior draws? Defaults to
\code{NULL} in which case no point estimate is computed. Alternatively, may
be set to \code{"mean"} or \code{"median"}. This argument is primarily
implemented to ensure compatibility with the \code{\link{loo_subsample}}
method.}

\item{ndraws_point_estimate}{Only used if \code{point_estimate} is not
\code{NULL}. How often shall the point estimate's value be repeated?
Defaults to \code{1}.}

\item{...}{Further arguments passed to \code{\link{validate_newdata}}.}
}
\value{
An object of class \code{'brmsprep'} or \code{'mvbrmsprep'},
  depending on whether a univariate or multivariate model is passed.
}
\description{
This method helps in preparing \pkg{brms} models for certin post-processing
tasks most notably various forms of predictions. Unless you are a package
developer, you will rarely need to call \code{prepare_predictions} directly.
}
