% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_ci.R
\name{boot_ci}
\alias{boot_ci}
\title{Calculate bootstrap confidence intervals from a cutpointr object}
\usage{
boot_ci(x, variable, in_bag = TRUE, alpha = 0.05)
}
\arguments{
\item{x}{(character) The numeric independent (predictor) variable.}

\item{variable}{Variable to calculate CI for}

\item{in_bag}{Whether the in-bag or out-of-bag results should be used for testing}

\item{alpha}{Alpha level. Quantiles of the bootstrapped values are returned
for (alpha / 2) and 1 - (alpha / 2).}
}
\value{
A data frame with the columns quantile and value
}
\description{
Given a \code{cutpointr} object that includes bootstrap results
this function calculates a bootstrap
confidence interval for a selected variable.
Missing values are removed before calculating the quantiles. In the case
of multiple optimal cutpoints all cutpoints / metric values are included
in the calculation.
Values of the selected variable are returned for the percentiles alpha / 2
and 1 - alpha / 2. The metrics in the bootstrap data frames of
\code{cutpointr} are suffixed with \code{_b} and \code{_oob} to indicate
in-bag and out-of-bag, respectively. For example, to calculate quantiles
of the in-bag AUC \code{variable = AUC_b} should be set.
}
\examples{
\dontrun{
opt_cut <- cutpointr(suicide, dsi, suicide, gender,
  metric = youden, boot_runs = 1000)
boot_ci(opt_cut, optimal_cutpoint, in_bag = FALSE, alpha = 0.05)
boot_ci(opt_cut, acc, in_bag = FALSE, alpha = 0.05)
boot_ci(opt_cut, cohens_kappa, in_bag = FALSE, alpha = 0.05)
boot_ci(opt_cut, AUC, in_bag = TRUE, alpha = 0.05)
}
}
\seealso{
Other main cutpointr functions: 
\code{\link{add_metric}()},
\code{\link{boot_test}()},
\code{\link{cutpointr}()},
\code{\link{multi_cutpointr}()},
\code{\link{predict.cutpointr}()},
\code{\link{roc}()}
}
\concept{main cutpointr functions}
