% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mime.R
\name{mime-parameters}
\alias{mime-parameters}
\title{Parameters for MIME functions}
\arguments{
\item{content}{A string of message content.}

\item{disposition}{Should the content be displayed inline or as an
attachment? Valid options are \code{"inline"} and \code{"attachment"}. If
set to \code{NA} then will guess appropriate value.}

\item{charset}{What character set is used. Most often either \code{"UTF-8"}
or \code{"ISO-8859-1"}.}

\item{encoding}{How content is transformed to ASCII. Options are
\code{"7bit"}, \code{"quoted-printable"} and \code{"base64"}. Use \code{NA}
or \code{NULL} for no (or "identity") encoding.}

\item{language}{Language of content. If \code{FALSE} then will not include
language field. If \code{TRUE} then will attempt to auto-detect language.
Otherwise will use the specified language.}

\item{description}{Description of content.}

\item{name}{Name used when downloading file.}

\item{filename}{Path to a file.}

\item{boundary}{Boundary string.}

\item{type}{The MIME type of the content.}

\item{children}{List of child MIME objects.}

\item{interpolate}{Whether or not to interpolate into input using \link[glue]{glue}.}

\item{.open}{The opening delimiter.}

\item{.close}{The closing delimiter.}

\item{.envir}{Environment used for \code{glue} interpolation. Defaults to \code{parent.frame()}.}
}
\description{
These are parameters which occur commonly across functions for components of
a MIME document.
}
