% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{get_con}
\alias{get_con}
\title{Create a connection extractor function}
\usage{
get_con(
  from = integer(),
  to = integer(),
  paths = NULL,
  ...,
  weight = NULL,
  mode = "all"
)
}
\arguments{
\item{from, to}{The index of the start and end nodes for the connections}

\item{paths}{A list of integer vectors giving the index of nodes defining
connections}

\item{...}{Additional information to be added to the final data output.
Accepts expressions that will be evaluated on the node data in it's
original order (irrespective of any reordering by the layout)}

\item{weight}{An expression to be evaluated on the edge data to provide
weights for the shortest path calculations}

\item{mode}{Character constant, gives whether the shortest paths to or from
the given vertices should be calculated for directed graphs. If \code{out}
then the shortest paths \emph{from} the vertex, if \verb{in} then \emph{to}
it will be considered. If \code{all}, the default, then the corresponding
undirected graph will be used, i.e. not directed paths are searched. This
argument is ignored for undirected graphs.}
}
\value{
A function that takes a layout_ggraph object and returns the given
connections
}
\description{
Connections within the ggraph terminology are links between nodes that are
not part of the network structure itself. In that sense connections do not
affect the layout calculation in any way and will not be drawn by the
standard \verb{geom_edge_*} functions. A connection does not need to only be
defined by a start and end node, but can include intermediary nodes.
\code{get_con} helps in creating connection data by letting you specify start
and end nodes and automatically finds the shortest path within the graph
structure that connects the given points. If this is not what is needed it is
also possible to supply a list of vectors giving node indices that define a
connection.
}
\seealso{
Other extractors: 
\code{\link{get_edges}()},
\code{\link{get_sf_nodes}()}
}
\concept{extractors}
